/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.impexport;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.adjust.importplugin.AdjustCommonImportPlugin;
import kd.fi.bcm.formplugin.impexport.ImpBaseDataModel;

public class AdjustImportValidator {
    List<AdjustCommonImportPlugin.AdjustBillResult> results = new ArrayList<AdjustCommonImportPlugin.AdjustBillResult>(12);
    Set<String> errSet = new TreeSet<String>();
    private AdjustCommonImportPlugin.AdjustImpModel adjustModel;
    private BusinessTypeEnum bussnesstype;
    private boolean isMerge = false;
    private String mergeNumber;
    private Map<Long, String> orgMap = new HashMap<Long, String>();
    private Boolean isModelPerm = null;
    private SchemeContext sctx;
    private List<String> failAdjustNumberList = new ArrayList<String>(10);
    private Table<String, Long, String> collectMsgMap = HashBasedTable.create();

    public AdjustImportValidator(SchemeContext sctx) {
        this.sctx = sctx;
    }

    public void start(AdjustCommonImportPlugin.AdjustImpModel adjustImpModel) {
        this.adjustModel = adjustImpModel;
        this.errSet.clear();
        this.bussnesstype = BusinessTypeEnum.searchByName((String)this.adjustModel.getSingleFields().getOrDefault("bussnesstype", "1").toString());
        if (this.bussnesstype != null) {
            this.isMerge = OrgRelaProcessMembPool.isRelaProcess((String)this.bussnesstype.getProcessNumber());
        }
        this.mergeNumber = null;
    }

    public void validatorSingleHead() {
        Object number = this.adjustModel.getSingleFields().get("number");
        if (number == null) {
            this.errSet.add(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustImportValidator_1", (String)"fi-bcm-formplugin", (Object[])new Object[]{this.adjustModel.getStartIndex() + 1}));
        } else if (number.toString().length() > 100) {
            this.errSet.add(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7f16\u7801\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u957f\u5ea6\u8d85\u8fc7100\u3002", (String)"AdjustImportValidator_2", (String)"fi-bcm-formplugin", (Object[])new Object[]{this.adjustModel.getStartIndex() + 1}));
        } else if (!BCMNumberRule.checkNumber((String)number.toString())) {
            this.errSet.add(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AdjustPaperTemplatePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Object name = this.adjustModel.getSingleFields().get("name");
        if (name == null) {
            this.errSet.add(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustImportValidator_3", (String)"fi-bcm-formplugin", (Object[])new Object[]{this.adjustModel.getStartIndex() + 1}));
        } else if (name.toString().length() > 255) {
            this.errSet.add(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u540d\u79f0\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u957f\u5ea6\u8d85\u8fc7255\u3002", (String)"AdjustImportValidator_4", (String)"fi-bcm-formplugin", (Object[])new Object[]{this.adjustModel.getStartIndex() + 1}));
        }
        if (this.bussnesstype == null) {
            this.errSet.add(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5408\u6cd5\u3002", (String)"AdjustImportValidator_5", (String)"fi-bcm-formplugin", (Object[])new Object[]{this.adjustModel.getStartIndex() + 1}));
        }
        this.adjustModel.getAdjustDataImpModels().stream().forEach(e -> {
            this.checkNumeric("cvtbeforedebit", (AdjustCommonImportPlugin.AdjustDataImpModel)e);
            this.checkNumeric("cvtbeforecredit", (AdjustCommonImportPlugin.AdjustDataImpModel)e);
            this.checkNumeric("cvtbeforesummoney", (AdjustCommonImportPlugin.AdjustDataImpModel)e);
            this.checkNumeric("rate_imp", (AdjustCommonImportPlugin.AdjustDataImpModel)e);
            this.checkNumeric("debit_imp", (AdjustCommonImportPlugin.AdjustDataImpModel)e);
            this.checkNumeric("credit_imp", (AdjustCommonImportPlugin.AdjustDataImpModel)e);
            this.checkNumeric("summoney", (AdjustCommonImportPlugin.AdjustDataImpModel)e);
        });
    }

    private boolean checkNumeric(String fieldKey, AdjustCommonImportPlugin.AdjustDataImpModel adjustDataImpModel) {
        Object val = adjustDataImpModel.getSingleFields().getOrDefault(fieldKey, 0L);
        if (val instanceof String) {
            try {
                new BigDecimal(val.toString());
            }
            catch (Exception e) {
                this.errSet.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c%2$s\u5217\u7684%3$s\u503c\u4e0d\u80fd\u8f6c\u6362\u6210\u6570\u503c\u3002", (String)"AdjustImportValidator_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), adjustDataImpModel.getIndex(), fieldKey, val));
                return false;
            }
        }
        return true;
    }

    private boolean isModelManage() {
        if (this.isModelPerm == null) {
            this.isModelPerm = MemberPermHelper.getLimitedModelListByUser().contains(this.sctx.getModel());
        }
        return this.isModelPerm;
    }

    public boolean checkDimPerm(Long dimId, Long id) {
        return PermissionServiceImpl.getInstance((Long)this.sctx.getModel()).hasWritePerm(dimId, id);
    }

    private boolean checkCollector(int rowIndex, String key, DynaEntityObject value) {
        String msg = (String)this.collectMsgMap.get((Object)value.getDataEntityNumber(), (Object)value.getId());
        if (msg != null) {
            this.errSet.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c%2$s\u5217\u7684%3$s\u503c%4$s", (String)"AdjustImportValidator_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), rowIndex + 1, key, value.getNumber(), msg));
            return false;
        }
        return true;
    }

    public void validatorBaseDataToHead(String key, DynaEntityObject value) {
        if (value.getId() == 0L && StringUtils.isNotEmpty((CharSequence)value.getNumber())) {
            this.isNullData(this.adjustModel.getStartIndex(), key, value.getNumber());
            return;
        }
        if (!this.checkCollector(this.adjustModel.getStartIndex(), key, value)) {
            return;
        }
        if (!this.isModelManage()) {
            if ("templatecatalog".equals(key) && !AdjustmentServiceHelper.hasPermClassWriteTCache((String)"bcm_templatecatalog", (String)(this.sctx.getModel() + ""), (Long)value.getId())) {
                this.notPermData(this.adjustModel.getStartIndex(), key, value.getNumber());
                return;
            }
            DynamicObject dim = (DynamicObject)value.get("dimension");
            if (dim != null && !this.checkDimPerm(dim.getLong("id"), value.getId())) {
                this.notPermData(this.adjustModel.getStartIndex(), key, value.getNumber());
            }
        }
        if (value.getDataEntityNumber().equals("bcm_entitymembertree")) {
            this.mergeNumber = value.getNumber();
            if (this.isMerge && value.getId() != 0L) {
                this.orgMap.put(value.getId(), this.mergeNumber);
            }
        }
    }

    private void isNullData(int row, String colkey, String number) {
        this.errSet.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c%2$s\u5217\u7684%3$s\u503c\u672a\u586b\u5199\u6216\u4e0d\u5b58\u5728\u3002", (String)"AdjustImportValidator_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row + 1, colkey, number));
    }

    private void notPermData(int row, String colkey, String number) {
        this.errSet.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c%2$s\u5217\u7684%3$s%4$s\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u95ee\u9898\u3002", (String)"AdjustImportValidator_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), row + 1, colkey, number, ResManager.loadKDString((String)"\u65e0\u6743\u6216\u53ea\u8bfb", (String)"AdjustImportValidator_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
    }

    public void validatorEntryDataBatch() {
        if (this.bussnesstype != null && !OrgRelaProcessMembPool.isRelaProcess((String)this.bussnesstype.getProcessNumber())) {
            HashSet<String> entryOrgNums = new HashSet<String>(16);
            String columName = "";
            for (AdjustCommonImportPlugin.AdjustDataImpModel adjustDataImpModel : this.adjustModel.getAdjustDataImpModels()) {
                for (Map.Entry<String, ImpBaseDataModel> entry : adjustDataImpModel.getBasedatas().entrySet()) {
                    ImpBaseDataModel value = entry.getValue();
                    if (!value.getDataEntityNumber().equals("bcm_entitymembertree")) continue;
                    columName = entry.getKey();
                    entryOrgNums.add(value.getNumber());
                }
            }
            if (entryOrgNums.size() > 1) {
                this.errSet.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c%2$s\u5217\u4e0d\u7b26\u5408\u5355\u4f53\u8fc7\u7a0b\u5206\u5f55\u7684\u6240\u6709\u5206\u5f55\u660e\u7ec6\u7ec4\u7ec7\u7f16\u7801\u9700\u4e3a\u540c\u4e00\u7ec4\u7ec7\u7f16\u7801\u7684\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustImportValidator_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.adjustModel.getStartIndex() + 1, columName));
            }
        }
    }

    public void validatorBaseDataToBody(AdjustCommonImportPlugin.AdjustDataImpModel adjustDataImpModel, String key, ImpBaseDataModel value) {
        String olapOrg;
        if (value.getDataEntityNumber().equals("bcm_entitymembertree") && this.isMerge && this.mergeNumber != null && (olapOrg = (String)adjustDataImpModel.getSingleFields().get("olaporg")) != null) {
            IDNumberTreeNode childNode;
            String childorg;
            String prefix = this.mergeNumber + "_";
            String string = childorg = olapOrg.length() > prefix.length() ? olapOrg.substring(prefix.length()) : null;
            if (StringUtils.isEmpty((CharSequence)childorg)) {
                this.errSet.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c%2$s\u5217\u5165\u5e93\u7ec4\u7ec7\u7f16\u7801%3$s\u4e0e\u5408\u5e76\u8282\u70b9%4$s\u65e0\u6cd5\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustImportValidator_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), adjustDataImpModel.getIndex() + 1, key, olapOrg, this.mergeNumber));
            } else if (!StringUtils.equals((CharSequence)childorg, (CharSequence)value.getNumber()) && (childNode = MemberReader.findEntityMemberByNum((String)this.sctx.getModelNumber(), (String)childorg)) == IDNumberTreeNode.NotFoundTreeNode) {
                this.errSet.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c%2$s\u5217\u5165\u5e93\u7ec4\u7ec7\u7f16\u7801%3$s\u7684\u8d21\u732e\u7ec4\u7ec7%4$s\u4e3a\u65e0\u6548\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustImportValidator_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), adjustDataImpModel.getIndex() + 1, key, olapOrg, childorg));
            }
        }
        if (value.getId() == 0L) {
            this.isNullData(adjustDataImpModel.getIndex(), key, value.getNumber());
        } else {
            if (!this.checkCollector(this.adjustModel.getStartIndex(), key, value)) {
                return;
            }
            DynamicObject dim = (DynamicObject)value.get("dimension");
            if (dim != null) {
                if (this.isMerge && value.getDataEntityNumber().equals("bcm_entitymembertree")) {
                    return;
                }
                if (!this.checkDimPerm(dim.getLong("id"), value.getId())) {
                    this.notPermData(this.adjustModel.getStartIndex(), key, value.getNumber());
                }
                if (!this.isMerge && value.getDataEntityNumber().equals("bcm_entitymembertree")) {
                    this.orgMap.put(value.getId(), value.getNumber());
                }
                if (value.getDataEntityNumber().equals("bcm_mycompanymembertree") && SystemVarsEnum.isDimVarsByNumber((String)value.getNumber())) {
                    this.errSet.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c%2$s\u5217\u7684%3$s\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustImportValidator_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.adjustModel.getStartIndex() + 1, key, value.getNumber()));
                }
            }
        }
    }

    public void end() {
        if (this.isMerge && this.mergeNumber == null) {
            this.isNullData(this.adjustModel.getStartIndex(), "entity", "");
        }
        if (this.errSet.isEmpty() && !this.orgMap.isEmpty()) {
            Map mcStatusMap = McStatus.batchGetMcStatus((Object)this.sctx.getModel(), this.orgMap.keySet(), (Object)this.adjustModel.getBasedatas().get("scenario").getId(), (Object)this.adjustModel.getBasedatas().get("year").getId(), (Object)this.adjustModel.getBasedatas().get("period").getId());
            HashSet isArchiveSet = new HashSet(mcStatusMap.size());
            mcStatusMap.forEach((orgid, mc) -> {
                if (mc.getArchive().isArchive()) {
                    isArchiveSet.add(this.orgMap.get(orgid));
                }
            });
            if (isArchiveSet.size() > 0) {
                this.errSet.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6d41\u7a0b\u72b6\u6001\u4e3a\u5df2\u5f52\u6863\u3002", (String)"AdjustImportValidator_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        if (!this.errSet.isEmpty()) {
            StringJoiner sj = new StringJoiner("\r\n \t ");
            sj.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e\u201c%s\u201d\uff0c\u5b58\u5728\u5f02\u5e38\u3002", (String)"AdjustImportValidator_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.adjustModel.getNumber()));
            this.errSet.forEach(e -> sj.add((CharSequence)e));
            this.results.add(this.addErrorResult(this.adjustModel, sj.toString()));
            this.failAdjustNumberList.add(this.adjustModel.getNumber());
        }
    }

    private AdjustCommonImportPlugin.AdjustBillResult addErrorResult(AdjustCommonImportPlugin.AdjustImpModel adjustImpModel, String msg) {
        AdjustCommonImportPlugin.AdjustBillResult result = new AdjustCommonImportPlugin.AdjustBillResult();
        result.setNumber(adjustImpModel.getNumber());
        result.setIndex(adjustImpModel.getDindex());
        result.setMessage(msg);
        result.setSucess(false);
        result.setData(adjustImpModel.getData());
        return result;
    }

    public List<AdjustCommonImportPlugin.AdjustBillResult> getFailBillResults() {
        return this.results;
    }

    public boolean isMerge() {
        return this.isMerge;
    }

    public void addErrorMsg(String rowKey, Long memberId, String msg) {
        this.collectMsgMap.put((Object)rowKey, (Object)memberId, (Object)msg);
    }

    public void removeFailAdjust(Map<String, AdjustCommonImportPlugin.AdjustImpModel> num2AdjustModels) {
        this.failAdjustNumberList.forEach(e -> {
            AdjustCommonImportPlugin.AdjustImpModel cfr_ignored_0 = (AdjustCommonImportPlugin.AdjustImpModel)num2AdjustModels.remove(e);
        });
    }
}

