/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.impexport;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.Pair;

public class ImportPreDataModel {
    private static final Table<String, String, Pair<Long, DynamicObject>> EMPTY_TABLE = HashBasedTable.create();
    public static final Pair<Long, DynamicObject> EMPTY_BASEDATA = Pair.onePair((Object)0L, null);
    private long modelId;
    private Map<String, Table<String, String, Pair<Long, DynamicObject>>> value = new HashMap<String, Table<String, String, Pair<Long, DynamicObject>>>(16);
    private Map<String, DynamicObject> orgNumber2CurrencyMap = new HashMap<String, DynamicObject>();

    public ImportPreDataModel(long modelId) {
        this.modelId = modelId;
    }

    public void putOrg(String number, Long memberId, Long dimId) {
        this.put("bcm_entitymembertree", "bcm_entitymembertree", number, memberId, dimId);
    }

    public Pair<Long, DynamicObject> get(String entityNumber, String fieldKey, String number) {
        Pair id2Dim = (Pair)this.value.getOrDefault(entityNumber, EMPTY_TABLE).get((Object)fieldKey, (Object)number);
        return id2Dim == null ? EMPTY_BASEDATA : id2Dim;
    }

    public void put(String entityNumber, String fieldKey, String number, Long memberId, Long dimId) {
        this.value.computeIfAbsent(entityNumber, k -> HashBasedTable.create()).put((Object)fieldKey, (Object)number, (Object)Pair.onePair((Object)memberId, (Object)this.getDimension(dimId)));
    }

    public Map<String, Pair<Long, DynamicObject>> rowNumberAndId(String entityNumber, String fieldKey) {
        Map row = this.value.getOrDefault(entityNumber, EMPTY_TABLE).row((Object)fieldKey);
        return row == null ? Collections.emptyMap() : row;
    }

    public DynamicObject getOrgCurrency(String orgNumber) {
        return this.orgNumber2CurrencyMap.get(orgNumber);
    }

    public void addOrgCurrency(String number, DynamicObject cy) {
        this.orgNumber2CurrencyMap.put(number, cy);
    }

    private DynamicObject getDimension(Long dimId) {
        if (dimId != null && dimId != 0L) {
            return (DynamicObject)((Map)ThreadCache.get((Object)("dimension_" + this.modelId), () -> {
                DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name,fieldmapped,membermodel,dseq", (QFilter[])new QFilter("model", "=", (Object)this.modelId).toArray());
                return docs.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            })).get(dimId);
        }
        return null;
    }
}

