/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.initperiod;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.batch.BatchInsertService;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class InitPeriodListPlugin
extends AbstractBaseListPlugin {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(InitPeriodListPlugin.class);
    private static final String entryentity = "entryentity";
    private static Set<String> dimKeys = Sets.newHashSet((Object[])new String[]{"scenario"});
    private static Set<String> entityKey = Sets.newHashSet((Object[])new String[]{"entity"});

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("selectstatus");
        HashMap map = new HashMap();
        this.asMapF7toType(new ArrayList<String>(dimKeys), SingleF7TypeEnum.LEAF, map);
        this.asMapF7toType(new ArrayList<String>(entityKey), SingleF7TypeEnum.NOLEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(new ArrayList<String>(dimKeys), true);
        this.refreshBillByUserSelect(new ArrayList<String>(entityKey), false);
        this.loadEntitymember();
        this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.LOOKUP.getMultiLangEnumBridge(), (String)"Query"), new OPDescMultiLangEnumBridge("\u67e5\u770b\u6210\u529f", "InitPeriodListPlugin_6", "fi-bcm-formplugin", null));
    }

    private void loadEntitymember() {
        this.getModel().deleteEntryData(entryentity);
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        String scenarioId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
        String selectstatus = (String)this.getModel().getValue("selectstatus");
        if (modelId == null || scenarioId == null || entity == null || selectstatus == null) {
            return;
        }
        DynamicObjectCollection orgs = OrgServiceHelper.getAllOrgChildren((Long)LongUtil.toLong((Object)modelId), (long)entity.getLong("id"));
        if (orgs.size() > 0) {
            orgs = this.queryInitPeriodEntity(orgs, modelId, scenarioId, selectstatus);
            List<String> properties = this.getProperties();
            BatchInsertService<DynamicObject> bs = new BatchInsertService<DynamicObject>(entryentity, properties.toArray(new String[0]));
            bs.batchCreateNewEntryRow(this.getView(), (Collection<DynamicObject>)orgs, mcData -> {
                ArrayList mcRowData = new ArrayList();
                properties.forEach(p -> mcRowData.add(mcData.get(p)));
                return mcRowData.toArray();
            });
        }
    }

    private List<String> getProperties() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("orgid");
        list.add("orgnumber");
        list.add("orgname");
        list.add("storagetype");
        list.add("initperiod");
        list.add("initstatus");
        list.add("modifier");
        list.add("modifytime");
        return list;
    }

    private DynamicObjectCollection queryInitPeriodEntity(DynamicObjectCollection orgTree, String modelId, String scenarioId, String selectstatus) {
        EntryType entityType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(entryentity);
        DynamicObjectCollection result = new DynamicObjectCollection((DynamicObjectType)entityType, (Object)this);
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (DynamicObject org : orgTree) {
            orgIds.add(org.getLong("id"));
        }
        QFilter qcf = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        qcf.and("scenario", "=", (Object)LongUtil.toLong((Object)scenarioId));
        qcf.and("org", "in", orgIds);
        DynamicObjectCollection mcs = QueryServiceHelper.query((String)"bcm_initperiod", (String)"org.id, inityear, initperiod, modifier, modifytime", (QFilter[])new QFilter[]{qcf});
        HashMap<String, DynamicObject> mcMap = new HashMap<String, DynamicObject>();
        for (DynamicObject mc : mcs) {
            mcMap.put(mc.getString("org.id"), mc);
        }
        for (DynamicObject org : orgTree) {
            DynamicObject rowObj;
            String storageType = StorageTypeEnum.stringToStorageType((String)String.valueOf(org.get("storagetype"))).getName();
            if (mcMap.containsKey(org.getString("id"))) {
                if (!"1".equals(selectstatus) && !"2".equals(selectstatus)) continue;
                rowObj = new DynamicObject((DynamicObjectType)entityType);
                rowObj.set("orgid", org.get("id"));
                rowObj.set("orgnumber", org.get("number"));
                rowObj.set("orgname", org.get("name"));
                rowObj.set("storagetype", (Object)storageType);
                DynamicObject initPeriodData = (DynamicObject)mcMap.get(org.getString("id"));
                rowObj.set("initperiod", (Object)String.valueOf(initPeriodData.getInt("inityear")).concat("-").concat(initPeriodData.getString("initperiod")));
                rowObj.set("initstatus", (Object)"1");
                rowObj.set("modifier", initPeriodData.get("modifier"));
                rowObj.set("modifytime", (Object)initPeriodData.getDate("modifytime"));
                result.add((Object)rowObj);
                continue;
            }
            if (!"0".equals(selectstatus) && !"2".equals(selectstatus)) continue;
            rowObj = new DynamicObject((DynamicObjectType)entityType);
            rowObj.set("orgid", org.get("id"));
            rowObj.set("orgnumber", org.get("number"));
            rowObj.set("orgname", org.get("name"));
            rowObj.set("storagetype", (Object)storageType);
            rowObj.set("initperiod", (Object)"-");
            rowObj.set("initstatus", (Object)"0");
            result.add((Object)rowObj);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Boolean isSureReturn;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        DynamicObject newValue = null;
        if ("selectstatus".equals(propName)) {
            Object newSelectstatus = e.getChangeSet()[0].getNewValue();
            Object oldSelectstatus = e.getChangeSet()[0].getOldValue();
            if (newSelectstatus == null) return;
            if (newSelectstatus.equals(oldSelectstatus)) {
                return;
            }
        } else {
            newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newValue != null && oldValue != null && newValue.getLong("id") == oldValue.getLong("id")) {
                return;
            }
        }
        if ("model".equals(propName)) {
            this.propertyChangedModelUse(Lists.newArrayList((Object[])new String[]{"scenario", "entity"}));
        } else if ((dimKeys.contains(propName) || entityKey.contains(propName)) && !(isSureReturn = this.propertyChangedDimUse(propName, newValue, false, false)).booleanValue()) {
            return;
        }
        this.loadEntitymember();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_initperiod".equals(key)) {
            EntryGrid entry = (EntryGrid)this.getControl(entryentity);
            int[] sels = entry.getSelectRows();
            if (sels.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"InitPeriodListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
            String scenarioId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
            String year = null;
            String period = null;
            long[] ids = new long[sels.length];
            for (int i = 0; i < ids.length; ++i) {
                String initperiod;
                DynamicObject sel = (DynamicObject)this.getModel().getEntryEntity(entryentity).get(sels[i]);
                ids[i] = sel.getLong("orgid");
                if (i != 0 || "-".equals(initperiod = sel.getString("initperiod"))) continue;
                year = initperiod.split("-")[0];
                period = initperiod.split("-")[1];
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_setinitperiod");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("modelId", (Object)modelId);
            showParameter.setCustomParam("scenarioId", (Object)scenarioId);
            showParameter.setCustomParam("orgIds", (Object)SerializationUtils.toJsonString((Object)ids));
            showParameter.setCustomParam("year", year);
            showParameter.setCustomParam("period", period);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "refresh");
            showParameter.setCloseCallBack(callBack);
            this.getView().showForm(showParameter);
        } else if ("refresh".equals(key)) {
            this.loadEntitymember();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if ("refresh".equals(actionId) && "OK".equals(evt.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"InitPeriodListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            HashMap<String, String> map = null;
            try {
                map = this.getlogMessageMap();
                for (Map.Entry<String, String> next : map.entrySet()) {
                    String number = next.getKey();
                    String name = next.getValue();
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u521d\u59cb\u5316\u671f\u95f4", "InitPeriodListPlugin_4", "fi-bcm-formplugin", "Init Period"), new OPDescMultiLangEnumBridge("%1$s %2$s,\u521d\u59cb\u5316\u671f\u95f4\u6210\u529f\u3002", "InitPeriodListPlugin_5", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{number, name})));
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            this.loadEntitymember();
        }
    }

    private HashMap<String, String> getlogMessageMap() {
        EntryGrid entryentity = (EntryGrid)this.getView().getControl(entryentity);
        int[] selectRows = entryentity.getSelectRows();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(entryentity, selectRow);
            String number = dynamicObject.getString("orgnumber");
            String name = dynamicObject.getString("orgname");
            map.put(number, name);
        }
        return map;
    }
}

