/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.initperiod;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;

public class InitPeriodSetPlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        List<ComboItem> fyitems = ModelUtil.getFYComboItemByCurrentModel(LongUtil.toLong((Object)fsp.getCustomParam("modelId")));
        ComboEdit comboEdit = (ComboEdit)this.getControl("inityear");
        comboEdit.setComboItems(fyitems);
        List<ComboItem> perioditems = ModelUtil.getPeriodComboItemByModel(LongUtil.toLong((Object)fsp.getCustomParam("modelId")));
        ComboEdit pComboEdit = (ComboEdit)this.getControl("initperiod");
        pComboEdit.setComboItems(perioditems);
        List orgIds = (List)SerializationUtils.fromJsonString((String)((String)fsp.getCustomParam("orgIds")), List.class);
        if (orgIds.size() == 1 && fsp.getCustomParam("year") != null) {
            this.getModel().setValue("inityear", fsp.getCustomParam("year"));
            this.getModel().setValue("initperiod", fsp.getCustomParam("period"));
            this.getView().updateView();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_save".equals(key)) {
            String inityear = (String)this.getModel().getValue("inityear");
            String initperiod = (String)this.getModel().getValue("initperiod");
            if (StringUtils.isEmpty((CharSequence)inityear) || StringUtils.isEmpty((CharSequence)initperiod)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u8bbe\u7f6e\u7684\u8d22\u5e74\u548c\u671f\u95f4\u3002", (String)"InitPeriodSetPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter fsp = this.getView().getFormShowParameter();
            List orgIds = (List)SerializationUtils.fromJsonString((String)((String)fsp.getCustomParam("orgIds")), List.class);
            this.batchUpdateStatus(LongUtil.toLong((Object)fsp.getCustomParam("modelId")), LongUtil.toLong((Object)fsp.getCustomParam("scenarioId")), orgIds);
            this.getView().returnDataToParent((Object)"OK");
            this.getView().close();
        }
    }

    private void batchUpdateStatus(Object modelId, Object scenarioId, List<Long> okIds) {
        ArrayList<DynamicObject> listToUpdate = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> listToAdd = new ArrayList<DynamicObject>(10);
        Object inityear = this.getModel().getValue("inityear");
        Object initperiod = this.getModel().getValue("initperiod");
        QFilter qcf = new QFilter("model", "=", modelId);
        qcf.and("scenario", "=", scenarioId);
        qcf.and("org", "in", (Object)okIds.toArray());
        DynamicObject[] initPeriods = BusinessDataServiceHelper.load((String)"bcm_initperiod", (String)"org.id, id, inityear, initperiod, modifier, modifytime", (QFilter[])new QFilter[]{qcf});
        HashMap<Long, DynamicObject> ipMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject tmp : initPeriods) {
            ipMap.put(tmp.getLong("org.id"), tmp);
        }
        for (Long orgId : okIds) {
            DynamicObject tmp;
            DynamicObject dyn = (DynamicObject)ipMap.get(orgId);
            if (dyn != null) {
                dyn.set("inityear", inityear);
                dyn.set("initperiod", initperiod);
                dyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
                dyn.set("modifytime", (Object)TimeServiceHelper.now());
                listToUpdate.add(dyn);
                continue;
            }
            tmp = BusinessDataServiceHelper.newDynamicObject((String)"bcm_initperiod");
            tmp.set("model", modelId);
            tmp.set("scenario", scenarioId);
            tmp.set("org", (Object)orgId);
            tmp.set("inityear", inityear);
            tmp.set("initperiod", initperiod);
            tmp.set("modifier", (Object)RequestContext.get().getCurrUserId());
            tmp.set("modifytime", (Object)TimeServiceHelper.now());
            listToAdd.add(tmp);
        }
        if (listToUpdate.size() > 0) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)listToUpdate.get(0)).getDynamicObjectType(), (Object[])listToUpdate.toArray());
        }
        if (listToAdd.size() > 0) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)listToAdd.get(0)).getDynamicObjectType(), (Object[])listToAdd.toArray());
        }
    }
}

