/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.innertrade.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.papertemplate.filterchain.AbstractPaperFilter;
import kd.fi.bcm.business.papertemplate.filterchain.PaperTmplChainFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.IntrRecordAddition;
import kd.fi.bcm.business.papertemplate.filterchain.filter.ReadOrWriteAuthFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.SceneFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.StatusFilter;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.dynamicobject.DynamicObjectCollectionUtil;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExportPageSourceEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.innertrade.export.IntrReportMultiExportService;
import kd.fi.bcm.formplugin.report.export.FYPeriodPair;
import kd.fi.bcm.formplugin.template.model.SpreadDataModel;
import org.apache.commons.lang3.StringUtils;

public class IntrReportMultiExportPlugin
extends AbstractBaseFormPlugin {
    protected static final String SPLITSTR = "|";
    protected static final String SHEETRULE = "sheetrule";
    protected static final String FILERULE = "filerule";
    protected static final String SHEETRULESELECT = "sheetruleselect";
    protected static final String FILERULESELECT = "fileruleselect";
    protected static final String START_YEAR = "startyear";
    protected static final String END_YEAR = "endyear";
    protected String periodKey = "startperiod";
    protected static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "startyear", "startperiod", "endyear", "endperiod"});
    protected static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    protected static final String MODEL = "model";
    protected static final String NUMBER = "number";
    protected static final String ORG_ENTRY = "orgentry";
    protected static final String ORG_NUMBER = "org_number";
    protected static final String SHEET_CLICK = "sheetclick";
    protected static final String FILE_CLICK = "fileclick";
    protected static final String CONNECT_STR = "connectstr";
    protected static final String TEMPLATE_ENTRY = "intrtemplateentry";
    private static final String DOWNLOADED = "downloaded";
    protected static final String FILETYPE = "filetype";
    protected static final String DEFINEDPROP_NUMBER = "definedprop_number";
    protected int viewDataunit = 0;
    protected Integer scale = null;
    protected String excelfiletype;
    protected List<FYPeriodPair> fyPeriodPairs;
    protected DynamicObject startYear;
    protected DynamicObject endYear;
    protected DynamicObject startPeriod;
    protected DynamicObject endPeriod;
    protected DynamicObjectCollection effectTmpls;
    protected DynamicObjectCollection effectOrgs;
    protected String filetype = "3";
    protected String fileruleStr = null;
    protected String sheetruleStr = null;
    protected String filetxt = null;
    protected String sheettxt = null;
    protected DynamicObject scene;
    protected List<String> sheetDefaultRuleNumbers = Lists.newArrayList((Object[])new String[]{"reportname"});
    protected List<String> fileDefaultRuleNumbers = Lists.newArrayList((Object[])new String[]{"yearname", "periodname", "orgnumber"});
    public boolean isPackDownload = false;
    protected static final Map<String, String> fileTypeMap = new LinkedHashMap<String, String>(3);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(SHEET_CLICK, FILE_CLICK, "bar_confirm");
        this.addItemClickListeners("toolbarap");
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("cslscheme");
        edit.addBeforeF7SelectListener(evt -> {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qf = new QFilter(NUMBER, "!=", (Object)"DefaultRateScheme");
            listShowParameter.getListFilterParameter().setFilter(qf);
        });
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getView().addService(ISpreadAction.class, (Object)new SpreadDataModel(this));
        HashMap map = new HashMap(16);
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        this.getModel().setValue(MODEL, (Object)this.getModelId());
        Object selecttemplate = this.getView().getFormShowParameter().getCustomParam("selecttemplate");
        if (selecttemplate != null) {
            this.initSelectTemplate();
        } else {
            DynamicObject[] otherPlan;
            DynamicObject defaultPlan = null;
            QFilter filter = new QFilter(MODEL, "=", (Object)this.getModelId());
            filter.and(new QFilter("isdefaultplan", "=", (Object)Boolean.TRUE));
            filter.and(new QFilter("exporttype", "=", (Object)"2"));
            DynamicObject[] defaultPlans = BusinessDataServiceHelper.load((String)"bcm_batchexportplan", (String)"id,user.id,plan", (QFilter[])new QFilter[]{filter, new QFilter("user", "=", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId()))}, null, (int)1);
            if (defaultPlans != null && defaultPlans.length > 0) {
                defaultPlan = defaultPlans[0];
            }
            if (defaultPlan == null && (otherPlan = BusinessDataServiceHelper.load((String)"bcm_batchexportplan", (String)"id,user.id,plan", (QFilter[])new QFilter[]{filter, new QFilter("applicationscope", "=", (Object)"2")}, null, (int)1)) != null && otherPlan.length > 0) {
                defaultPlan = otherPlan[0];
            }
            if (defaultPlan != null) {
                this.getPageCache().put("planId", String.valueOf(defaultPlan.getPkValue()));
                String planDetailId = String.valueOf(defaultPlan.getDynamicObject("plan").getPkValue());
                this.initData(planDetailId);
                this.getView().updateView();
            } else {
                this.initSelectTemplate();
            }
        }
    }

    private void initSelectTemplate() {
        this.initFilterControl();
        this.getModel().setValue("dataunit", (Object)Character.valueOf('0'));
        this.getView().setEnable(Boolean.FALSE, new String[]{"scale"});
        this.initEntry();
        this.bindUserSelectData();
    }

    private void initData(String planDetailId) {
        this.initDataModel();
        this.getPageCache().put("planDetailId", planDetailId);
        IDataModel model = this.getModel();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)planDetailId, (String)"bcm_batchexportplandetail");
        model.setValue("currentplan", dynamicObject.get("name"));
        model.setValue("excelfiletype", dynamicObject.get("excelfiletype"));
        model.setValue("dataunit", dynamicObject.get("dataunit"));
        model.setValue("scale", dynamicObject.get("scale"));
        model.setValue("isdealscalegroup", (Object)(dynamicObject.getBoolean("isdealscale") ? "1" : "2"));
        model.setValue("pack_download", dynamicObject.get("pack_download"));
        model.setValue("cslscheme", dynamicObject.get("cslscheme"));
        this.getView().setEnable(Boolean.valueOf(dynamicObject.getBoolean("isdealscale")), new String[]{"scale"});
        this.bindUserSelectData();
        DynamicObjectCollection reportEntry = dynamicObject.getDynamicObjectCollection(TEMPLATE_ENTRY);
        DynamicObjectCollection orgEntry = dynamicObject.getDynamicObjectCollection(ORG_ENTRY);
        IntrReportMultiExportPlugin.checkData(reportEntry);
        IntrReportMultiExportPlugin.checkData(orgEntry);
        this.bindEntry(dynamicObject, TEMPLATE_ENTRY, "intr_template_number");
        this.bindEntry(dynamicObject, ORG_ENTRY, ORG_NUMBER);
    }

    private static void checkData(DynamicObjectCollection reportEntry) {
        block2: {
            block3: {
                if (reportEntry == null || reportEntry.isEmpty()) break block2;
                if (!reportEntry.getDynamicObjectType().getProperties().containsKey((Object)"intr_template_number")) break block3;
                Iterator it = reportEntry.iterator();
                while (it.hasNext()) {
                    DynamicObject dy = (DynamicObject)it.next();
                    if (dy.get("intr_template_number") != null) continue;
                    it.remove();
                }
                break block2;
            }
            if (!reportEntry.getDynamicObjectType().getProperties().containsKey((Object)ORG_NUMBER)) break block2;
            Iterator it = reportEntry.iterator();
            while (it.hasNext()) {
                DynamicObject dy = (DynamicObject)it.next();
                if (dy.get(ORG_NUMBER) != null || dy.get(DEFINEDPROP_NUMBER) != null) continue;
                it.remove();
            }
        }
    }

    private void initDataModel() {
        HashMap<String, String> f7Key2Dim = new HashMap<String, String>();
        f7Key2Dim.put(START_YEAR, DimTypesEnum.YEAR.getNumber());
        f7Key2Dim.put("startperiod", DimTypesEnum.PERIOD.getNumber());
        f7Key2Dim.put(END_YEAR, DimTypesEnum.YEAR.getNumber());
        f7Key2Dim.put("endperiod", DimTypesEnum.PERIOD.getNumber());
        f7Key2Dim.put("scenario", "scenario");
        this.getPageCache().put("f7Key2Dim", this.toByteSerialized(f7Key2Dim));
        Object cslSchemeId = this.getView().getFormShowParameter().getCustomParam("cslscheme");
        Object sceneId = this.getView().getFormShowParameter().getCustomParam("scenario");
        Object yearId = this.getView().getFormShowParameter().getCustomParam("year");
        Object periodId = this.getView().getFormShowParameter().getCustomParam("period");
        if (cslSchemeId instanceof Long) {
            this.getModel().setValue("cslscheme", cslSchemeId);
        }
        if (sceneId instanceof Long) {
            this.getModel().setValue("scenario", sceneId);
        }
        if (yearId instanceof Long) {
            this.getModel().setValue(START_YEAR, yearId);
            this.getModel().setValue(END_YEAR, yearId);
        }
        if (periodId instanceof Long) {
            this.getModel().setValue("startperiod", periodId);
            this.getModel().setValue("endperiod", periodId);
        }
    }

    private boolean isDealScale() {
        String key = (String)this.getModel().getValue("isdealscalegroup");
        return "1".equals(key);
    }

    private void bindEntry(DynamicObject dynamicObject, String entryName, String entryNumber) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryNews = dynamicObject.getDynamicObjectCollection(entryName);
        model.deleteEntryData(entryName);
        if (entryNews.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(entryName, entryNews.size());
            for (int j = 0; j < entryNews.size(); ++j) {
                model.setValue(entryNumber, ((DynamicObject)entryNews.get(j)).get(entryNumber), j);
                if (ORG_ENTRY.equals(entryName)) {
                    model.setValue("membrange", ((DynamicObject)entryNews.get(j)).get("membrange"), j);
                    model.setValue(DEFINEDPROP_NUMBER, ((DynamicObject)entryNews.get(j)).get(DEFINEDPROP_NUMBER), j);
                    continue;
                }
                if (!TEMPLATE_ENTRY.equals(entryName)) continue;
                model.setValue("intr_definednumber", ((DynamicObject)entryNews.get(j)).get("intr_definednumber"), j);
                model.setValue("intr_definedname", ((DynamicObject)entryNews.get(j)).get("intr_definedname"), j);
            }
            model.endInit();
            this.initShowFiledControl();
            this.getView().updateView(entryName);
        }
    }

    public void bindUserSelectData() {
        String userId = RequestContext.getOrCreate().getUserId();
        String planDetailId = this.getPageCache().get("planDetailId");
        String ruleId = this.getPageCache().get("ruleId");
        QFilter filter = new QFilter("user", "=", (Object)Long.parseLong(userId));
        if (planDetailId != null) {
            filter.and(new QFilter("plan", "=", (Object)LongUtil.toLong((Object)planDetailId)));
        } else {
            filter.and(new QFilter("plan", "=", (Object)-1));
        }
        DynamicObject dy = null;
        dy = ruleId == null ? BusinessDataServiceHelper.loadSingle((String)"bcm_exportfilenamerule", (String)"user,excelfiletype,filerule,sheetrule,filename,sheetname,fixvalue,sheetfixvalue,connectstr,sheetconnectstr,plan", (QFilter[])new QFilter[]{filter}) : BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"bcm_exportfilenamerule");
        Label sheetclicklabel = (Label)this.getView().getControl(SHEET_CLICK);
        Label fileclicklabel = (Label)this.getView().getControl(FILE_CLICK);
        if (dy != null) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            String filerule = dy.getString(FILERULE);
            String sheetrule = dy.getString(SHEETRULE);
            String joiner = dy.getString(CONNECT_STR);
            String sheetjoiner = dy.getString("sheetconnectstr");
            List filerules = kd.bos.util.StringUtils.isEmpty((String)filerule) ? this.fileDefaultRuleNumbers : (List)this.deSerializedBytes(filerule);
            List sheetrules = kd.bos.util.StringUtils.isEmpty((String)sheetrule) ? this.sheetDefaultRuleNumbers : (List)this.deSerializedBytes(sheetrule);
            map.put(FILERULE, kd.bos.util.StringUtils.isEmpty((String)filerule) ? String.join((CharSequence)"_", this.fileDefaultRuleNumbers) : String.join((CharSequence)joiner, filerules));
            map.put(SHEETRULE, kd.bos.util.StringUtils.isEmpty((String)sheetrule) ? String.join((CharSequence)"", this.sheetDefaultRuleNumbers) : String.join((CharSequence)sheetjoiner, sheetrules));
            map.put("fileruletxt", kd.bos.util.StringUtils.isEmpty((String)dy.getString("fixvalue")) ? "" : dy.getString("fixvalue"));
            map.put("sheetruletxt", kd.bos.util.StringUtils.isEmpty((String)dy.getString("sheetfixvalue")) ? "" : dy.getString("sheetfixvalue"));
            map.put(FILERULESELECT, this.toByteSerialized(filerules));
            map.put(SHEETRULESELECT, this.toByteSerialized(sheetrules));
            map.put(CONNECT_STR, joiner);
            map.put("sheetconnectstr", sheetjoiner);
            this.getPageCache().put(map);
            this.getModel().beginInit();
            this.getModel().setValue("excelfiletype", (Object)dy.getString("excelfiletype"));
            fileclicklabel.setText(kd.bos.util.StringUtils.isEmpty((String)filerule) ? ResManager.loadKDString((String)"\u8d22\u5e74\u540d\u79f0_\u671f\u95f4\u540d\u79f0_\u7ec4\u7ec7\u7f16\u7801", (String)"ReportMultiExportPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : dy.getString("filename"));
            sheetclicklabel.setText(kd.bos.util.StringUtils.isEmpty((String)sheetrule) ? ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"ReportMultiExportPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : dy.getString("sheetname"));
            this.getPageCache().put(SHEET_CLICK, kd.bos.util.StringUtils.isEmpty((String)sheetrule) ? ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"ReportMultiExportPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : dy.getString("sheetname"));
            this.getPageCache().put(FILE_CLICK, kd.bos.util.StringUtils.isEmpty((String)filerule) ? ResManager.loadKDString((String)"\u8d22\u5e74\u540d\u79f0_\u671f\u95f4\u540d\u79f0_\u7ec4\u7ec7\u7f16\u7801", (String)"ReportMultiExportPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : dy.getString("filename"));
            this.getModel().endInit();
        } else {
            fileclicklabel.setText(ResManager.loadKDString((String)"\u8d22\u5e74\u540d\u79f0_\u671f\u95f4\u540d\u79f0_\u7ec4\u7ec7\u7f16\u7801", (String)"ReportMultiExportPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            sheetclicklabel.setText(ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"ReportMultiExportPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            this.getPageCache().put(FILERULE, String.join((CharSequence)"_", this.fileDefaultRuleNumbers));
            this.getPageCache().put(SHEETRULE, String.join((CharSequence)"", this.sheetDefaultRuleNumbers));
            this.getPageCache().put("fileruletxt", "");
            this.getPageCache().put("sheetruletxt", "");
            this.getPageCache().put(FILERULESELECT, this.toByteSerialized(this.fileDefaultRuleNumbers));
            this.getPageCache().put(SHEETRULESELECT, this.toByteSerialized(this.sheetDefaultRuleNumbers));
        }
    }

    public void initEntry() {
        Object[] orgIds;
        Object orgStr;
        Object[] tempIds;
        Object selecttemplate = this.getView().getFormShowParameter().getCustomParam("selecttemplate");
        if (selecttemplate != null && (tempIds = ((JSONArray)selecttemplate).toArray()).length > 0) {
            Map map = BusinessDataServiceHelper.loadFromCache((String)"bcm_papertemplate", (String)"number,name,templatecatalog.name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)tempIds)});
            LinkedHashMap<Object, DynamicObject> sortMap = new LinkedHashMap<Object, DynamicObject>(16);
            for (Object id : tempIds) {
                sortMap.put(id, (DynamicObject)map.get(id));
            }
            EntryGrid reportEntryGrid = (EntryGrid)this.getView().getControl(TEMPLATE_ENTRY);
            reportEntryGrid.getModel().deleteEntryData(TEMPLATE_ENTRY);
            reportEntryGrid.getModel().batchCreateNewEntryRow(TEMPLATE_ENTRY, sortMap.size());
            this.initEntryModel("intr_template_number", reportEntryGrid, sortMap.size(), sortMap, null);
        }
        if ((orgStr = this.getView().getFormShowParameter().getCustomParam("org")) != null && (orgIds = (Long[])((JSONArray)orgStr).toArray((Object[])new Long[0])).length > 0) {
            Map<Object, DynamicObject> orgMap = this.getBaseOrgMap(orgIds);
            EntryGrid orgEntryGrid = (EntryGrid)this.getView().getControl(ORG_ENTRY);
            orgEntryGrid.getModel().deleteEntryData(ORG_ENTRY);
            orgEntryGrid.getModel().batchCreateNewEntryRow(ORG_ENTRY, orgMap.size());
            this.initEntryModel(ORG_NUMBER, orgEntryGrid, orgMap.size(), orgMap, null);
            this.initShowFiledControl();
            this.getView().updateView(ORG_ENTRY);
        }
    }

    private Map<Object, DynamicObject> getBaseOrgMap(Object[] ids) {
        String selectField = "number,name,isleaf,currency.number";
        return BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
    }

    public void initFilterControl() {
        this.initDataModel();
        this.setCheckbox("pack_download", false);
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.equals("startperiod") || key.equals("endperiod")) {
            this.periodKey = key;
        }
        super.onGetControl(e);
    }

    @Override
    public String getPeriodLogo() {
        return this.periodKey;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String planDeatilId = "";
        switch (key) {
            case "bar_confirm": {
                this.viewDataunit = Integer.parseInt(this.getModel().getValue("dataunit").toString());
                boolean isDealScale = this.isDealScale();
                this.scale = isDealScale ? Integer.valueOf(((BigDecimal)this.getModel().getValue("scale")).intValue()) : null;
                this.exportExcel();
                IFormView parentView = this.getView().getParentView();
                if (parentView == null || !this.getView().getEntityId().equals("bcm_reportlistmultiprint")) break;
                OperationLogUtil.writeOperationLog((IFormView)parentView, (String)OpItemEnum.MULTIEXPORT.getName(), (String)OpItemEnum.PRINTSUCCESS.getName(), (Long)this.getModelId());
                break;
            }
            case "bar_plansave": {
                if (!this.checkData()) {
                    return;
                }
                planDeatilId = this.getPageCache().get("planDetailId");
                if (planDeatilId != null) {
                    this.updatePlan(planDeatilId);
                } else {
                    planDeatilId = this.getNewPlanDetailId();
                }
                this.openBillShowView("bcm_batchexportplan", "bar_plansave", planDeatilId, true);
                break;
            }
            case "bar_plansaveas": {
                if (!this.checkData()) {
                    return;
                }
                planDeatilId = this.getNewPlanDetailId();
                this.openBillShowView("bcm_batchexportplan", "bar_plansaveas", planDeatilId, false);
                break;
            }
            case "bar_planlist": {
                if (!this.checkData()) {
                    return;
                }
                this.openListShowView("bcm_planlist", "bar_planlist");
                break;
            }
            case "bar_download": {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("bcm_exporturllist");
                OpenStyle openStyle = showParameter.getOpenStyle();
                openStyle.setShowType(ShowType.Modal);
                StyleCss css = new StyleCss();
                css.setWidth("960");
                css.setHeight("580");
                openStyle.setInlineStyleCss(css);
                showParameter.setMultiSelect(true);
                showParameter.setShowTitle(true);
                showParameter.setLookUp(false);
                showParameter.setCustomParam("modelId", (Object)this.getModelId());
                ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId())});
                filters.add(new QFilter("creater", "=", (Object)this.getUserId()));
                int type = ExportPageSourceEnum.INTR.getIndex();
                filters.add(new QFilter("type", "=", (Object)Integer.toString(type)));
                showParameter.setCustomParam("ExportPageSource", (Object)Integer.toString(type));
                showParameter.getListFilterParameter().setQFilters((List)filters);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    private String getNewPlanDetailId() {
        String planDetailId = this.savePlan();
        this.getPageCache().put("planDetailId", planDetailId);
        String ruleId = this.getPageCache().get("ruleId");
        if (ruleId != null) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"bcm_exportfilenamerule");
            if (dynamicObject != null) {
                dynamicObject.set("plan", (Object)planDetailId);
                SaveServiceHelper.update((DynamicObject)dynamicObject);
                this.getPageCache().remove("ruleId");
            }
        } else {
            this.setLabelName(String.valueOf(this.getModel().getValue("excelfiletype")));
        }
        return planDetailId;
    }

    private boolean checkData() {
        boolean result = true;
        DynamicObject obj = (DynamicObject)this.getModel().getValue(MODEL);
        if (obj == null) {
            result = false;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"ReportMultiExportPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        return result;
    }

    private void openBillShowView(String formId, String actionId, String planDeatilId, boolean isSave) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u51fa\u65b9\u6848", (String)"ReportMultiExportPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        formShowParameter.setCustomParam(MODEL, (Object)this.getModelId());
        formShowParameter.setCustomParam("planDeatilId", (Object)planDeatilId);
        formShowParameter.setCustomParam("userId", (Object)RequestContext.get().getUserId());
        formShowParameter.setCustomParam("exporttype", (Object)"2");
        formShowParameter.setCustomParam("actionSign", (Object)"intr");
        formShowParameter.setCustomParam("isSave", (Object)(isSave ? "1" : "0"));
        formShowParameter.setShowTitle(true);
        switch (actionId) {
            case "bar_plansave": {
                String planId = this.getPageCache().get("planId");
                boolean flag = QueryServiceHelper.exists((String)"bcm_batchexportplan", (Object)planId);
                if (flag) {
                    formShowParameter.setPkId((Object)planId);
                    formShowParameter.setStatus(OperationStatus.EDIT);
                    formShowParameter.setCustomParam("status", (Object)OperationStatus.EDIT);
                    break;
                }
                formShowParameter.setStatus(OperationStatus.ADDNEW);
                formShowParameter.setCustomParam("status", (Object)OperationStatus.ADDNEW);
                break;
            }
            case "bar_plansaveas": {
                formShowParameter.setStatus(OperationStatus.ADDNEW);
                formShowParameter.setCustomParam("status", (Object)OperationStatus.ADDNEW);
                break;
            }
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void openListShowView(String formId, String actionId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u5217\u8868", (String)"ReportMultiExportPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        formShowParameter.setCustomParam(MODEL, (Object)this.getModelId());
        formShowParameter.setCustomParam("userId", (Object)RequestContext.get().getUserId());
        formShowParameter.setCustomParam("planId", (Object)this.getPageCache().get("planId"));
        formShowParameter.setCustomParam("exporttype", (Object)"2");
        formShowParameter.setCustomParam("actionSign", (Object)"intr");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        formShowParameter.setShowTitle(true);
        this.getView().showForm(formShowParameter);
    }

    private DynamicObject getBatchExportPlanDetail() {
        IDataModel model = this.getModel();
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_batchexportplandetail");
        dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("name", (Object)"kingdee");
        dynamicObject.set("status", (Object)"A");
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set(START_YEAR, model.getValue(START_YEAR));
        dynamicObject.set("startperiod", model.getValue("startperiod"));
        dynamicObject.set(END_YEAR, model.getValue(END_YEAR));
        dynamicObject.set("endperiod", model.getValue("endperiod"));
        dynamicObject.set("scenario", model.getValue("scenario"));
        dynamicObject.set("excelfiletype", model.getValue("excelfiletype"));
        dynamicObject.set("dataunit", model.getValue("dataunit"));
        dynamicObject.set("scale", model.getValue("scale"));
        dynamicObject.set("isdealscale", (Object)this.isDealScale());
        dynamicObject.set("pack_download", model.getValue("pack_download"));
        dynamicObject.set("sheetname", (Object)this.getPageCache().get(SHEET_CLICK));
        dynamicObject.set("filename", (Object)this.getPageCache().get(FILE_CLICK));
        DynamicObjectCollection reportEntry = model.getEntryEntity(TEMPLATE_ENTRY);
        DynamicObjectCollection orgEntry = model.getEntryEntity(ORG_ENTRY);
        this.buildEntry(dynamicObject, reportEntry, TEMPLATE_ENTRY, "intr_template_number");
        this.buildEntry(dynamicObject, orgEntry, ORG_ENTRY, ORG_NUMBER);
        return dynamicObject;
    }

    private void buildEntry(DynamicObject dynamicObject, DynamicObjectCollection entryEntity, String entryName, String entryNumber) {
        if (entryEntity.size() > 0) {
            DynamicObjectCollection reportEntryNews = dynamicObject.getDynamicObjectCollection(entryName);
            for (DynamicObject obj : entryEntity) {
                DynamicObject entryObj = new DynamicObject(reportEntryNews.getDynamicObjectType());
                entryObj.set(entryNumber, obj.get(entryNumber));
                entryObj.set("seq", obj.get("seq"));
                if (ORG_ENTRY.equals(entryName)) {
                    entryObj.set("membrange", obj.get("membrange"));
                    entryObj.set(DEFINEDPROP_NUMBER, obj.get(DEFINEDPROP_NUMBER));
                } else if (TEMPLATE_ENTRY.equals(entryName)) {
                    entryObj.set("intr_definednumber", obj.get("intr_definednumber"));
                    entryObj.set("intr_definedname", obj.get("intr_definedname"));
                }
                reportEntryNews.add((Object)entryObj);
            }
        }
    }

    private String savePlan() {
        String id = null;
        DynamicObject obj = this.getBatchExportPlanDetail();
        DynamicObject[] ids = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        int len = ids.length;
        if (len > 0) {
            id = String.valueOf(ids[0].getPkValue());
        }
        return id;
    }

    private void updatePlan(String planDetailId) {
        IDataModel model = this.getModel();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)planDetailId, (String)"bcm_batchexportplandetail");
        dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set(START_YEAR, model.getValue(START_YEAR));
        dynamicObject.set("startperiod", model.getValue("startperiod"));
        dynamicObject.set(END_YEAR, model.getValue(END_YEAR));
        dynamicObject.set("endperiod", model.getValue("endperiod"));
        dynamicObject.set("cslscheme", model.getValue("cslscheme"));
        dynamicObject.set("scenario", model.getValue("scenario"));
        dynamicObject.set("excelfiletype", model.getValue("excelfiletype"));
        dynamicObject.set("dataunit", model.getValue("dataunit"));
        dynamicObject.set("scale", model.getValue("scale"));
        dynamicObject.set("isdealscale", (Object)this.isDealScale());
        dynamicObject.set("pack_download", model.getValue("pack_download"));
        dynamicObject.set("sheetname", (Object)this.getPageCache().get(SHEET_CLICK));
        dynamicObject.set("filename", (Object)this.getPageCache().get(FILE_CLICK));
        DynamicObjectCollection reportEntry = model.getEntryEntity(TEMPLATE_ENTRY);
        DynamicObjectCollection orgEntry = model.getEntryEntity(ORG_ENTRY);
        QFilter filters = new QFilter("id", "=", (Object)LongUtil.toLong((Object)planDetailId));
        List entryIds = QueryServiceHelper.query((String)"bcm_batchexportplandetail", (String)"intrtemplateentry.id", (QFilter[])new QFilter[]{filters}).stream().map(id -> id.get("intrtemplateentry.id")).collect(Collectors.toList());
        if (entryIds.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)dynamicObject.getDynamicObjectCollection(TEMPLATE_ENTRY).getDynamicObjectType(), (Object[])entryIds.toArray());
        }
        this.buildEntry(dynamicObject, reportEntry, TEMPLATE_ENTRY, "intr_template_number");
        List orgEntryIds = QueryServiceHelper.query((String)"bcm_batchexportplandetail", (String)"orgentry.id", (QFilter[])new QFilter[]{filters}).stream().map(id -> id.get("orgentry.id")).collect(Collectors.toList());
        if (orgEntryIds.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)dynamicObject.getDynamicObjectCollection(ORG_ENTRY).getDynamicObjectType(), (Object[])orgEntryIds.toArray());
        }
        this.buildEntry(dynamicObject, orgEntry, ORG_ENTRY, ORG_NUMBER);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (args.getSource() instanceof NewEntry) {
            args.setCancel(true);
            if ("reportnewentry".equals(operateKey)) {
                this.showMultiF7("bcm_papertemplate", "reportnewentry");
            } else if ("orgnewentry".equals(operateKey)) {
                this.showSelectOrgView();
            }
        }
    }

    private void showSelectOrgView() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_tem");
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"DistributionPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("isFilterRateScheme", (Object)Boolean.TRUE);
        formShowParameter.setCustomParam("sign", (Object)"Entity");
        formShowParameter.setCustomParam("isUpDownBtn", (Object)true);
        List<Map<String, String>> orgList = this.getOrgList();
        if (orgList != null) {
            formShowParameter.setCustomParam("Entity", (Object)SerializationUtils.toJsonString(orgList));
        } else {
            formShowParameter.setCustomParam("Entity", (Object)SerializationUtils.toJsonString(new ArrayList(10)));
        }
        Object cslscheme = this.getModel().getValue("cslscheme");
        if (cslscheme != null) {
            formShowParameter.setCustomParam("cslscheme", (Object)((DynamicObject)cslscheme).getLong("id"));
        }
        formShowParameter.setCustomParam("customFilter", (Object)new QFilter("isleaf", "=", (Object)Boolean.FALSE).toSerializedString());
        formShowParameter.setCustomParam("showScopes", (Object)ObjectSerialUtil.toByteSerialized((Object)new int[]{RangeEnum.VALUE_10.getValue(), RangeEnum.VALUE_110.getValue()}));
        formShowParameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectmember");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private List<Map<String, String>> getOrgList() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ORG_ENTRY);
        if (entryEntity.size() > 0) {
            ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>(entryEntity.size());
            if (((DynamicObject)entryEntity.get(0)).get(ORG_NUMBER) != null) {
                for (DynamicObject object : entryEntity) {
                    HashMap<String, String> m = new HashMap<String, String>(10);
                    m.put("id", Long.toString(object.getLong("org_number_id")));
                    m.put("scope", object.getString("membrange"));
                    m.put(NUMBER, object.getString("org_number.number"));
                    m.put("name", object.getString("org_number.name"));
                    maps.add(m);
                }
            } else {
                for (DynamicObject object : entryEntity) {
                    HashMap<String, String> m = new HashMap<String, String>(10);
                    m.put("id", Long.toString(object.getLong("definedprop_number_id")));
                    m.put("scope", object.getString("membrange"));
                    m.put(NUMBER, object.getString(NUMBER));
                    m.put("name", object.getString("name"));
                    m.put("pid", object.getDynamicObject(DEFINEDPROP_NUMBER).getString("propertyid.id"));
                    maps.add(m);
                }
            }
            return maps;
        }
        return null;
    }

    private void showMultiF7(String entityForm, String closeCallbackkey) {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_listf7");
        param.setBillFormId(entityForm);
        ListFilterParameter listFilter = new ListFilterParameter();
        ArrayList<Long> ids = new ArrayList<Long>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TEMPLATE_ENTRY);
        for (DynamicObject object : entryEntity) {
            ids.add(object.getLong("intr_template_number_id"));
        }
        param.setSelectedRows(ids.toArray());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
        Long sceneId = (Long)this.getView().getFormShowParameter().getCustomParam("scenario");
        PaperTmplChainFilter tmplFilter = new PaperTmplChainFilter(Long.valueOf(this.getModelId()), PaperTemplateTypeEnum.INNERTRADE, true);
        tmplFilter.addFilter((AbstractPaperFilter)new SceneFilter(sceneId)).addFilter((AbstractPaperFilter)new StatusFilter(Boolean.valueOf(true))).addFilter((AbstractPaperFilter)new IntrRecordAddition(null, sceneId)).addFilter((AbstractPaperFilter)new ReadOrWriteAuthFilter(Long.valueOf(this.getUserId())));
        Set tmpls = tmplFilter.doFilter(null);
        if (CollectionUtils.isEmpty((Collection)tmpls)) {
            filters.add(new QFilter("1", "=", (Object)0));
        } else {
            Map<String, Long> valueMaps = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"group, id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)tmpls)}, (String)"versionnumber desc").stream().collect(Collectors.toMap(k -> k.getString("group"), v -> v.getLong("id"), (e1, e2) -> e1));
            filters.add(new QFilter("id", "in", valueMaps.values()));
        }
        listFilter.setQFilters(filters);
        param.setListFilterParameter(listFilter);
        param.setSearchKeyword(NUMBER);
        param.setShowUsed(true);
        param.setLookUp(true);
        param.setSelectedEntity("bcm_papertemplate");
        param.setShowFilter(false);
        param.setShowQuickFilter(false);
        param.setShowTitle(false);
        param.setMultiSelect(true);
        param.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u62b5\u9500\u5e95\u7a3f\u5217\u8868", (String)"IntrReportMultiExportPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        param.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        param.getOpenStyle().setInlineStyleCss(css);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallbackkey));
        this.getView().showForm((FormShowParameter)param);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionKey = e.getActionId();
        if ("reportnewentry".equals(actionKey)) {
            this.fillBackReportEntrys(e);
        } else if ("orgnewentry".equals(actionKey)) {
            this.setEntryGrid(e, ORG_ENTRY, ORG_NUMBER, "bcm_entitymembertree", "number,name,isleaf,currency.number");
        } else if ("selectmember".equals(actionKey)) {
            this.fillBackOrgEntrys(e);
        } else if (SHEET_CLICK.equals(actionKey)) {
            this.setClickLable(e, SHEET_CLICK, SHEETRULE);
        } else if (FILE_CLICK.equals(actionKey)) {
            this.setClickLable(e, FILE_CLICK, FILERULE);
        } else if ("bar_plansave".equals(actionKey) || "bar_plansaveas".equals(actionKey)) {
            String planDetailId = this.getPageCache().get("planDetailId");
            Map returnData = (Map)e.getReturnData();
            if (returnData == null) {
                return;
            }
            String planId = String.valueOf(returnData.get("planId"));
            if (planId != null) {
                this.getPageCache().put("planId", planId);
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)planDetailId, (String)"bcm_batchexportplandetail");
            this.getModel().setValue("currentplan", (Object)dynamicObject.getString("name"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReportMultiExportPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        } else if ("bar_planlist".equals(actionKey)) {
            Map returnData = (Map)e.getReturnData();
            if (returnData != null) {
                DynamicObject planDy;
                Object planDetailId = returnData.get("planDetailId");
                Object planId = returnData.get("planId");
                this.getPageCache().put("planId", String.valueOf(planId));
                if (planId != null && (planDy = QueryServiceHelper.queryOne((String)"bcm_exportfilenamerule", (String)"id", (QFilter[])new QFilter[]{new QFilter("plan", "=", planDetailId)})) != null) {
                    this.getPageCache().put("ruleId", planDy.getString("id"));
                }
                this.initData(String.valueOf(planDetailId));
                this.getView().updateView();
            }
        } else if ("taskcloseback".equals(actionKey)) {
            this.taskCompleteCallback(e);
        }
    }

    public void taskCompleteCallback(ClosedCallBackEvent e) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Object returnData;
        Map result;
        if (e.getReturnData() != null && (result = (Map)(returnData = e.getReturnData())).containsKey("taskinfo") && kd.bos.util.StringUtils.isNotEmpty((String)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && this.getPageCache().get(DOWNLOADED) == null) {
            String data = taskInfo.getData();
            JSONObject dataObj = (JSONObject)JSONObject.parse((String)data);
            JSONArray urls = dataObj.getJSONArray("data");
            String message = (String)dataObj.get((Object)"message");
            this.getPageCache().put(DOWNLOADED, "1");
            if (kd.bos.util.StringUtils.isNotEmpty((String)message)) {
                this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.EXPORT.getMultiLangEnumBridge(), (String)"Export"), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u5931\u8d25", "IntrReportMultiExportPlugin_5", FI_BCM_FORMPLUGIN, null));
                this.getView().showTipNotification(message);
            } else {
                this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpItemEnum.EXPORT.getMultiLangEnumBridge(), (String)"Export"), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "IntrReportMultiExportPlugin_6", FI_BCM_FORMPLUGIN, null));
            }
            if (urls != null && urls.size() > 0) {
                for (Object o : urls.toArray()) {
                    this.downloadFile(o.toString(), "bcm_intrreportlist", "35Y/ISB669YT");
                }
            } else if (kd.bos.util.StringUtils.isEmpty((String)message)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u53ef\u5bfc\u51fa\u7684\u62a5\u8868\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5bfc\u51fa\u8bbe\u7f6e\u3002", (String)"IntrReportMultiExportPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void fillBackReportEntrys(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            ListSelectedRowCollection lsc = (ListSelectedRowCollection)e.getReturnData();
            List ids = DynamicObjectCollectionUtil.getMultiF7DyIds((ListSelectedRowCollection)lsc);
            QFBuilder qf = new QFBuilder("id", "in", (Object)ids);
            Map id2newDys = BusinessDataServiceHelper.loadFromCache((String)"bcm_papertemplate", (String)"name,templatecatalog.name", (QFilter[])qf.toArray());
            int newSize = ids.size();
            this.getModel().deleteEntryData(TEMPLATE_ENTRY);
            if (newSize > 0 && id2newDys != null && !id2newDys.isEmpty()) {
                int[] rows = this.getModel().batchCreateNewEntryRow(TEMPLATE_ENTRY, newSize);
                int i = 0;
                for (Long id : ids) {
                    DynamicObject object = (DynamicObject)id2newDys.get(id);
                    if (object == null) continue;
                    this.getModel().setValue("intr_template_number", (Object)object, rows[i]);
                    ++i;
                }
                this.getView().updateView(TEMPLATE_ENTRY);
            }
        }
    }

    public void fillBackOrgEntrys(ClosedCallBackEvent e) {
        DynamicObjectCollection newdoc;
        if (e.getReturnData() != null && (newdoc = (DynamicObjectCollection)e.getReturnData()) != null && !newdoc.isEmpty()) {
            Object pid1 = ((DynamicObject)newdoc.get(0)).get("pid1");
            if (StringUtils.isEmpty((CharSequence)(pid1 == null ? null : pid1.toString()))) {
                this.fillBackOrgProp(newdoc);
            } else {
                this.fillBackDefinedProp(newdoc);
            }
            this.initShowFiledControl();
        }
    }

    private void fillBackOrgProp(DynamicObjectCollection newdoc) {
        List ids = DynamicObjectCollectionUtil.getPKList((DynamicObjectCollection)newdoc, (String)"mid1");
        Map<Long, String> id2Ranges = newdoc.stream().collect(Collectors.toMap(k -> k.getLong("mid1"), v -> v.getString("filltypevalue1")));
        QFBuilder qf = new QFBuilder("id", "in", (Object)ids);
        Map id2newDys = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"number,name,isleaf,currency.number", (QFilter[])qf.toArray());
        int newSize = ids.size();
        this.getModel().deleteEntryData(ORG_ENTRY);
        if (newSize > 0 && id2newDys != null && !id2newDys.isEmpty()) {
            int[] rows = this.getModel().batchCreateNewEntryRow(ORG_ENTRY, newSize);
            this.getModel().beginInit();
            int i = 0;
            for (Long id : ids) {
                DynamicObject object = (DynamicObject)id2newDys.get(id);
                if (object == null) continue;
                this.getModel().setValue(ORG_NUMBER, (Object)object, rows[i]);
                this.getModel().setValue("org_number_id", (Object)object.getLong("id"), rows[i]);
                this.getModel().setValue("membrange", (Object)id2Ranges.get(id), rows[i]);
                ++i;
            }
            this.getModel().endInit();
            this.getView().updateView(ORG_ENTRY);
        }
    }

    private void fillBackDefinedProp(DynamicObjectCollection newdoc) {
        List ids = DynamicObjectCollectionUtil.getPKList((DynamicObjectCollection)newdoc, (String)"mid1");
        Map<Long, String> id2Ranges = newdoc.stream().collect(Collectors.toMap(k -> k.getLong("mid1"), v -> v.getString("filltypevalue1")));
        QFBuilder qf = new QFBuilder("id", "in", (Object)ids);
        Map id2newDys = BusinessDataServiceHelper.loadFromCache((String)"bcm_definedpropertyvalue", (String)"id,number,name,propertyid.number,propertyid.name", (QFilter[])qf.toArray());
        int newSize = ids.size();
        this.getModel().deleteEntryData(ORG_ENTRY);
        if (newSize > 0 && id2newDys != null && !id2newDys.isEmpty()) {
            int[] rows = this.getModel().batchCreateNewEntryRow(ORG_ENTRY, newSize);
            this.getModel().beginInit();
            int i = 0;
            for (Long id : ids) {
                DynamicObject object = (DynamicObject)id2newDys.get(id);
                if (object == null) continue;
                this.getModel().setValue(DEFINEDPROP_NUMBER, (Object)object, rows[i]);
                this.getModel().setValue("definedprop_number_id", (Object)object.getLong("id"), rows[i]);
                this.getModel().setValue("membrange", (Object)id2Ranges.get(id), rows[i]);
                ++i;
            }
            this.getModel().endInit();
            this.getView().updateView(ORG_ENTRY);
        }
    }

    private void initShowFiledControl() {
        DynamicObject pid1;
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ORG_ENTRY);
        int count = this.getModel().getEntryRowCount(ORG_ENTRY);
        this.getModel().beginInit();
        HashMap<Long, DynamicObject> id2PropDys = new HashMap<Long, DynamicObject>(16);
        if (count > 0 && (pid1 = ((DynamicObject)doc.get(0)).getDynamicObject(DEFINEDPROP_NUMBER)) != null) {
            List pids = doc.stream().filter(d -> d.getDynamicObject(DEFINEDPROP_NUMBER) != null).map(d -> d.getDynamicObject(DEFINEDPROP_NUMBER).getLong("propertyid_id")).collect(Collectors.toList());
            QFBuilder qfBuilder = new QFBuilder("id", "in", pids);
            DynamicObjectCollection customs = QueryServiceHelper.query((String)"bcm_definedproperty", (String)"id,number,name", (QFilter[])qfBuilder.toArray());
            for (DynamicObject custom : customs) {
                id2PropDys.put(custom.getLong("id"), custom);
            }
        }
        for (int i = 0; i < count; ++i) {
            if (((DynamicObject)doc.get(i)).get(ORG_NUMBER) != null) {
                Object org_number = this.getModel().getValue(ORG_NUMBER, i);
                if (org_number == null) continue;
                this.getModel().setValue(NUMBER, (Object)((DynamicObject)org_number).getString(NUMBER), i);
                this.getModel().setValue("name", (Object)((DynamicObject)org_number).getString("name"), i);
                this.getModel().setValue("basetype", (Object)"0", i);
                this.getModel().setValue("cynumber", (Object)((DynamicObject)org_number).getString("currency.number"), i);
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"membrange"});
                continue;
            }
            Object definedprop_number = this.getModel().getValue(DEFINEDPROP_NUMBER, i);
            if (definedprop_number == null) continue;
            DynamicObject definedpropDy = (DynamicObject)definedprop_number;
            DynamicObject propertyidId = (DynamicObject)id2PropDys.get(definedpropDy.getLong("propertyid_id"));
            String propNumber = propertyidId != null ? propertyidId.getString(NUMBER) : "";
            String propName = propertyidId != null ? propertyidId.getString("name") : "";
            this.getModel().setValue(NUMBER, (Object)(propNumber + ":" + definedpropDy.getString(NUMBER)), i);
            this.getModel().setValue("name", (Object)(propName + ":" + definedpropDy.getString("name")), i);
            this.getModel().setValue("basetype", (Object)"1", i);
            this.getModel().setValue("cynumber", (Object)"-", i);
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"membrange"});
        }
        this.getModel().endInit();
        this.getView().updateView(ORG_ENTRY);
    }

    private void setClickLable(ClosedCallBackEvent e, String ctrlKey, String cacheKey) {
        if (e.getReturnData() == null) {
            return;
        }
        if (SHEET_CLICK.equals(ctrlKey) || FILE_CLICK.equals(ctrlKey)) {
            Map returnData = (Map)e.getReturnData();
            String joiner = (String)returnData.get("joiner");
            List ruleNumbers = (List)returnData.get("ruleNumbers");
            List ruleNames = (List)returnData.get("ruleNames");
            String fixvalue = (String)returnData.get("txt");
            this.getPageCache().put(cacheKey, String.join((CharSequence)joiner, ruleNumbers));
            if (SHEET_CLICK.equals(ctrlKey)) {
                this.getPageCache().put(SHEETRULESELECT, this.toByteSerialized(ruleNumbers));
                this.getPageCache().put("sheetconectstr", joiner);
            } else if (FILE_CLICK.equals(ctrlKey)) {
                this.getPageCache().put(FILERULESELECT, this.toByteSerialized(ruleNumbers));
                this.getPageCache().put(CONNECT_STR, joiner);
            }
            this.getPageCache().put(cacheKey + "txt", fixvalue);
            Label label = (Label)this.getView().getControl(ctrlKey);
            label.setText(String.join((CharSequence)joiner, ruleNames));
            this.getPageCache().put(ctrlKey, String.join((CharSequence)joiner, ruleNames));
            this.saveFileNameRule(cacheKey, joiner, ruleNumbers, fixvalue, String.join((CharSequence)joiner, ruleNames));
        }
    }

    private void saveFileNameRule(String cacheKey, String joiner, List<String> ruleNumbers, String fixvalue, String clickName) {
        Long userId = LongUtil.toLong((Object)RequestContext.getOrCreate().getUserId());
        QFilter filter = new QFilter("user.id", "=", (Object)userId);
        String planDetailId = this.getPageCache().get("planDetailId");
        String ruleId = this.getPageCache().get("ruleId");
        if (planDetailId != null) {
            filter.and(new QFilter("plan", "=", (Object)LongUtil.toLong((Object)planDetailId)));
        } else {
            filter.and(new QFilter("plan", "=", (Object)-1));
        }
        DynamicObject ruleDy = null;
        ruleDy = ruleId == null ? BusinessDataServiceHelper.loadSingle((String)"bcm_exportfilenamerule", (String)"user,excelfiletype,filerule,sheetrule,filename,sheetname,fixvalue,sheetfixvalue,connectstr,sheetconnectstr,plan", (QFilter[])new QFilter[]{filter}) : BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"bcm_exportfilenamerule");
        if (ruleDy == null) {
            ruleDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_exportfilenamerule");
            ruleDy.set("user", (Object)userId);
            ruleDy.set("plan", (Object)LongUtil.toLong((Object)planDetailId));
        }
        ruleDy.set("excelfiletype", this.getModel().getValue("excelfiletype"));
        ruleDy.set(FILERULE, FILERULE.equals(cacheKey) ? this.toByteSerialized(ruleNumbers) : ruleDy.get(FILERULE));
        ruleDy.set(SHEETRULE, SHEETRULE.equals(cacheKey) ? this.toByteSerialized(ruleNumbers) : ruleDy.get(SHEETRULE));
        ruleDy.set("filename", FILERULE.equals(cacheKey) ? clickName : ruleDy.get("filename"));
        ruleDy.set("sheetname", SHEETRULE.equals(cacheKey) ? clickName : ruleDy.get("sheetname"));
        ruleDy.set("fixvalue", FILERULE.equals(cacheKey) ? fixvalue : ruleDy.get("fixvalue"));
        ruleDy.set("sheetfixvalue", SHEETRULE.equals(cacheKey) ? fixvalue : ruleDy.get("sheetfixvalue"));
        ruleDy.set(CONNECT_STR, FILERULE.equals(cacheKey) ? joiner : ruleDy.get(CONNECT_STR));
        ruleDy.set("sheetconnectstr", SHEETRULE.equals(cacheKey) ? joiner : ruleDy.get("sheetconnectstr"));
        DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ruleDy});
        this.getPageCache().put("ruleId", String.valueOf(save[0].getPkValue()));
    }

    private void setEntryGrid(ClosedCallBackEvent e, String entryGridKey, String baseDataKey, String entityForm, String entryFiled) {
        if (e.getReturnData() != null) {
            ListSelectedRowCollection lsc = (ListSelectedRowCollection)e.getReturnData();
            DynamicObjectCollection selectedDoc = this.getModel().getEntryEntity(entryGridKey);
            EntryGrid reportentry = (EntryGrid)this.getView().getControl(entryGridKey);
            Set idSet = DynamicObjectCollectionUtil.getFieldSet((DynamicObjectCollection)selectedDoc, (String)(ORG_ENTRY.equals(entryGridKey) ? "org_number_id" : "intr_template_number_id"));
            lsc.removeIf(item -> idSet.contains(item.getPrimaryKeyValue()));
            int size = lsc.size();
            if (size == 0) {
                return;
            }
            int[] newRowIndex = reportentry.getModel().batchCreateNewEntryRow(entryGridKey, size);
            Map<Object, DynamicObject> tempMap = this.getSelectedBaseData(lsc, entityForm, entryFiled);
            this.initEntryModel(baseDataKey, reportentry, size, tempMap, newRowIndex);
        }
    }

    private void initEntryModel(String baseDataKey, EntryGrid reportentry, int size, Map<Object, DynamicObject> tempMap, int[] newRowIndex) {
        if (newRowIndex != null) {
            int i = 0;
            for (Map.Entry<Object, DynamicObject> objectEntry : tempMap.entrySet()) {
                this.getModel().setValue(baseDataKey, (Object)objectEntry.getValue(), newRowIndex[i]);
                this.getModel().setValue(ORG_NUMBER.equals(baseDataKey) ? "org_number_id" : "intr_template_number_id", objectEntry.getKey(), newRowIndex[i]);
                ++i;
            }
        } else {
            int i = 0;
            for (Map.Entry<Object, DynamicObject> objectEntry : tempMap.entrySet()) {
                if (i >= size) continue;
                reportentry.getModel().setValue(baseDataKey, (Object)objectEntry.getValue(), i);
                ++i;
            }
        }
    }

    private Map<Object, DynamicObject> getSelectedBaseData(ListSelectedRowCollection lsc, String entityForm, String entryFiled) {
        List ids = DynamicObjectCollectionUtil.getMultiF7DyIds((ListSelectedRowCollection)lsc);
        QFBuilder qf = new QFBuilder("id", "in", (Object)ids);
        return BusinessDataServiceHelper.loadFromCache((String)entityForm, (String)entryFiled, (QFilter[])qf.toArray());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("excelfiletype".equals(propertyName)) {
            String excelfiletype = (String)e.getChangeSet()[0].getNewValue();
            this.setLabelName(excelfiletype);
            this.loadFileTypeCombo(excelfiletype);
            this.setControlVisible();
        } else if (FILETYPE.equals(propertyName)) {
            this.setControlVisible();
        } else if ("isdealscalegroup".equals(propertyName)) {
            String excelfiletype = (String)e.getChangeSet()[0].getNewValue();
            this.getView().setEnable(Boolean.valueOf(!"2".equals(excelfiletype)), new String[]{"scale"});
        } else if ("pack_download".equals(propertyName)) {
            boolean value = (Boolean)e.getChangeSet()[0].getNewValue();
            this.setCheckbox("pack_download", value);
        }
    }

    private void loadFileTypeCombo(String excelFileType) {
        ArrayList comboItems = new ArrayList();
        fileTypeMap.forEach((k, v) -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(v));
            comboItem.setValue(k);
            comboItems.add(comboItem);
        });
        ComboEdit comboEdit = (ComboEdit)this.getControl(FILETYPE);
        if (comboEdit != null) {
            comboEdit.setComboItems(comboItems);
            if ("4".equals(this.getModel().getValue(FILETYPE)) && !excelFileType.equals("3")) {
                this.getModel().setValue(FILETYPE, (Object)"0");
            }
        }
    }

    private void setControlVisible() {
        if (this.getView().getFormShowParameter().getFormId().equals("bcm_reportlistmultiprint")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pack_download"});
            this.getView().setVisible(Boolean.TRUE, new String[]{SHEET_CLICK, FILE_CLICK, "labelap2122", "labelap21221"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{SHEET_CLICK, FILE_CLICK, "labelap2122", "labelap21221", "pack_download"});
        }
    }

    private void setCheckbox(String key, boolean value) {
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)key);
        if (iDataEntityProperty != null) {
            this.getModel().setValue(key, (Object)value);
            this.getView().updateView(key);
        }
    }

    private void setLabelName(String excelfiletype) {
        Label sheetclicklabel = (Label)this.getView().getControl(SHEET_CLICK);
        Label fileclicklabel = (Label)this.getView().getControl(FILE_CLICK);
        if ("0".equals(excelfiletype)) {
            ArrayList sheetRuleNumbers = Lists.newArrayList((Object[])new String[]{"reportname"});
            ArrayList fileRuleNumbers = Lists.newArrayList((Object[])new String[]{"yearname", "periodname", "orgnumber"});
            HashMap<String, String> caches = new HashMap<String, String>(16);
            caches.put(FILERULESELECT, this.toByteSerialized(fileRuleNumbers));
            caches.put(SHEETRULESELECT, this.toByteSerialized(sheetRuleNumbers));
            caches.put(FILERULE, String.join((CharSequence)"_", fileRuleNumbers));
            caches.put(SHEETRULE, String.join((CharSequence)"", sheetRuleNumbers));
            this.getPageCache().put(caches);
            String fileClick = ResManager.loadKDString((String)"\u8d22\u5e74\u540d\u79f0_\u671f\u95f4\u540d\u79f0_\u7ec4\u7ec7\u7f16\u7801", (String)"ReportMultiExportPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            String sheetClick = ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"ReportMultiExportPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            fileclicklabel.setText(fileClick);
            sheetclicklabel.setText(sheetClick);
            this.saveFileNameRule(FILERULE, "_", fileRuleNumbers, "", fileClick);
            this.saveFileNameRule(SHEETRULE, "", sheetRuleNumbers, "", sheetClick);
        } else if ("1".equals(excelfiletype)) {
            ArrayList sheetRuleNumbers = Lists.newArrayList((Object[])new String[]{"orgnumber"});
            ArrayList fileRuleNumbers = Lists.newArrayList((Object[])new String[]{"yearname", "periodname", "reportname"});
            HashMap<String, String> caches = new HashMap<String, String>(16);
            caches.put(FILERULESELECT, this.toByteSerialized(fileRuleNumbers));
            caches.put(SHEETRULESELECT, this.toByteSerialized(sheetRuleNumbers));
            caches.put(FILERULE, String.join((CharSequence)"_", fileRuleNumbers));
            caches.put(SHEETRULE, String.join((CharSequence)"", sheetRuleNumbers));
            this.getPageCache().put(caches);
            String fileClick = ResManager.loadKDString((String)"\u8d22\u5e74\u540d\u79f0_\u671f\u95f4\u540d\u79f0_\u62a5\u8868\u540d\u79f0", (String)"ReportMultiExportPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            String sheetClick = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801", (String)"ReportMultiExportPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            fileclicklabel.setText(fileClick);
            sheetclicklabel.setText(sheetClick);
            this.saveFileNameRule(FILERULE, "_", fileRuleNumbers, "", fileClick);
            this.saveFileNameRule(SHEETRULE, "", sheetRuleNumbers, "", sheetClick);
        } else if ("2".equals(excelfiletype)) {
            ArrayList sheetRuleNumbers = Lists.newArrayList((Object[])new String[]{"yearname", "periodname"});
            ArrayList fileRuleNumbers = Lists.newArrayList((Object[])new String[]{"orgnumber", "reportname"});
            HashMap<String, String> caches = new HashMap<String, String>(16);
            caches.put(FILERULESELECT, this.toByteSerialized(fileRuleNumbers));
            caches.put(SHEETRULESELECT, this.toByteSerialized(sheetRuleNumbers));
            caches.put(FILERULE, String.join((CharSequence)"_", fileRuleNumbers));
            caches.put(SHEETRULE, String.join((CharSequence)"", sheetRuleNumbers));
            this.getPageCache().put(caches);
            String fileClick = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801_\u62a5\u8868\u540d\u79f0", (String)"ReportMultiExportPlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            String sheetClick = ResManager.loadKDString((String)"\u8d22\u5e74\u540d\u79f0\u671f\u95f4\u540d\u79f0", (String)"ReportMultiExportPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            fileclicklabel.setText(fileClick);
            sheetclicklabel.setText(sheetClick);
            this.saveFileNameRule(FILERULE, "_", fileRuleNumbers, "", fileClick);
            this.saveFileNameRule(SHEETRULE, "", sheetRuleNumbers, "", sheetClick);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("bar_confirm".equals(key)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u5bfc\u51fa\u4e2d", (String)"ReportMultiExportPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            this.exportExcel();
            this.getView().hideLoading();
        } else {
            this.showFileSheetNameRuleView(key);
        }
    }

    public void showFileSheetNameRuleView(String key) {
        FormShowParameter fp = new FormShowParameter();
        fp.setFormId("bcm_filesheetnamerule");
        fp.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        fp.setCloseCallBack(closeCallBack);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("filestyle", this.getModel().getValue("excelfiletype"));
        if (FILE_CLICK.equals(key)) {
            params.put(CONNECT_STR, this.getPageCache().get(CONNECT_STR));
            params.put("txt", this.getPageCache().get("fileruletxt"));
            params.put("defaultruleselect", this.getPageCache().get(FILERULESELECT));
            params.put("issheetclick", Boolean.FALSE);
            if ("3".equals(params.get("filestyle"))) {
                params.put("isRpaSchemeType", "1");
            }
            fp.setCaption(ResManager.loadKDString((String)"\u6587\u4ef6\u547d\u540d\u89c4\u5219-\u6587\u4ef6\u540d", (String)"ReportMultiExportPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        } else if (SHEET_CLICK.equals(key)) {
            params.put(CONNECT_STR, this.getPageCache().get("sheetconectstr"));
            params.put("txt", this.getPageCache().get("sheetruletxt"));
            params.put("defaultruleselect", this.getPageCache().get(SHEETRULESELECT));
            params.put("issheetclick", Boolean.TRUE);
            fp.setCaption(ResManager.loadKDString((String)"\u6587\u4ef6\u547d\u540d\u89c4\u5219-\u6587\u4ef6\u5185sheet\u5de5\u4f5c\u8868\u540d", (String)"ReportMultiExportPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        params.put("isIntrType", "1");
        fp.setCustomParams(params);
        this.getView().showForm(fp);
    }

    public void exportExcel() {
        if (this.getModel().getValue(START_YEAR) == null || this.getModel().getValue(END_YEAR) == null || this.getModel().getValue("startperiod") == null || this.getModel().getValue("endperiod") == null) {
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"ReportMultiExportPlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        this.getPageCache().remove(DOWNLOADED);
        this.filetype = (String)this.getModel().getValue(FILETYPE);
        this.fyPeriodPairs = this.initAllFYPeriodPair();
        if (this.fyPeriodPairs == null || this.fyPeriodPairs.size() == 0) {
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6548\u8d22\u5e74\u671f\u95f4\u8303\u56f4\u3002", (String)"ReportMultiExportPlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        this.effectOrgs = this.getEffectOrgs();
        if (this.effectOrgs.size() == 0) {
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6709\u6548\u7684\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u7684\u6743\u9650\u914d\u7f6e\u3002", (String)"IntrReportMultiExportPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        this.effectTmpls = this.getEffectTmpls();
        if (this.effectTmpls.size() == 0) {
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6709\u6548\u7684\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u7684\u914d\u7f6e\u3002", (String)"IntrReportMultiExportPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        this.startYear = (DynamicObject)this.getModel().getValue(START_YEAR);
        this.endYear = (DynamicObject)this.getModel().getValue(END_YEAR);
        this.startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        this.endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        this.excelfiletype = (String)this.getModel().getValue("excelfiletype");
        this.scene = (DynamicObject)this.getModel().getValue("scenario");
        this.fileruleStr = this.getPageCache().get(FILERULE);
        this.sheetruleStr = this.getPageCache().get(SHEETRULE);
        this.filetxt = this.getPageCache().get("fileruletxt");
        this.sheettxt = this.getPageCache().get("sheetruletxt");
        this.isPackDownload = (Boolean)this.getModel().getValue("pack_download");
        IntrReportMultiExportService service = new IntrReportMultiExportService(this);
        this.dispatch(service);
    }

    private DynamicObjectCollection getEffectTmpls() {
        return this.getModel().getEntryEntity(TEMPLATE_ENTRY);
    }

    private DynamicObjectCollection getEffectOrgs() {
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId()));
        DynamicObjectCollection orgs = this.getModel().getEntryEntity(ORG_ENTRY);
        Long cslschemeId = this.getModel().getValue("cslscheme") == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("cslscheme")).getLong("id"));
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        HashMap effectOrg = new HashMap(16);
        for (DynamicObject org : orgs) {
            long mid = 0L;
            String number = "";
            boolean isCustom = false;
            if ("1".equals(org.getString("basetype"))) {
                mid = org.getLong("definedprop_number_id");
                number = org.getDynamicObject(DEFINEDPROP_NUMBER).getString(NUMBER);
                isCustom = true;
            } else {
                mid = org.getLong("org_number_id");
                number = org.getDynamicObject(ORG_NUMBER).getString(NUMBER);
            }
            new MembRangeItem("bcm_entitymembertree", Long.valueOf(mid), number, org.getInt("membrange"), isCustom, (Object)this.getModelId()).matchItems(e -> {
                if (cslschemeId != null) {
                    IDNumberTreeNode node = MemberReader.findEntityMemberById((String)modelNum, (Long)((Long)e.id));
                    if (cslschemeId.equals(node.getProperty("cslscheme.id"))) {
                        effectOrg.put(e.getId(), e.getNumber());
                    }
                } else {
                    effectOrg.put(e.getId(), e.getNumber());
                }
            });
        }
        if (CollectionUtils.isEmpty(effectOrg)) {
            return new DynamicObjectCollection();
        }
        if (!adminUserBol) {
            Long entityDimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)PresetConstant.ENTITY_DIM);
            PermissionService permService = PermissionServiceImpl.getInstance((Long)this.getModelId());
            Set noPermissionIds = permService.matchNoPermMembers(entityDimensionId, "bcm_entitymembertree", effectOrg.keySet());
            noPermissionIds.forEach(effectOrg::remove);
        }
        if (CollectionUtils.isEmpty(effectOrg)) {
            return new DynamicObjectCollection();
        }
        Set orgIdSet = effectOrg.keySet().stream().map(s -> {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)s);
            return node.getBaseTreeNode().getId();
        }).collect(Collectors.toSet());
        QFBuilder qf = new QFBuilder();
        qf.add(MODEL, "=", (Object)this.getModelId());
        qf.add("id", "in", orgIdSet);
        return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,longnumber,name,simplename,orgcode,currency.number,currency.name", (QFilter[])qf.toArray());
    }

    public String getTaskClassName() {
        return "kd.fi.bcm.formplugin.innertrade.export.IntrReportMultiExportTask";
    }

    public String getTaskJobInfoName() {
        return ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"ReportMultiExportPlugin_47", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private void dispatch(IntrReportMultiExportService service) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(this.getTaskJobInfoName());
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(this.getTaskClassName());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("time", 100);
        params.put("service", this.toByteSerialized(service));
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByUserId(this.getUserId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        this.dispatch(jobInfo, this.getView(), closeCallBack);
    }

    public void dispatch(JobInfo jobInfo, IFormView view, CloseCallBack closeCallBack) {
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(this.getView().getPageId());
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
    }

    public boolean isCsl(String formBcmCslreportList, String parentFormId) {
        return formBcmCslreportList.equals(parentFormId);
    }

    private List<DynamicObject> getEffectiveYear() {
        String selectProperties = "id,number,name,dimension.membermodel";
        DynamicObject startYear = (DynamicObject)this.getModel().getValue(START_YEAR);
        DynamicObject endYear = (DynamicObject)this.getModel().getValue(END_YEAR);
        QFilter filter3 = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter filter1 = new QFilter(NUMBER, ">=", (Object)startYear.getString(NUMBER));
        QFilter filter2 = new QFilter(NUMBER, "<=", (Object)endYear.getString(NUMBER));
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bcm_fymembertree", (String)selectProperties, (QFilter[])new QFilter[]{filter3, filter1, filter2});
        return Lists.newArrayList(map.values());
    }

    public List<DynamicObject> getEffectivePeriod() {
        String selectProperties = "id,number,name,dimension.membermodel,effmonth,effday,expmonth,expday";
        DynamicObject scenarioDy = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObjectCollection coll = DimensionServiceHelper.getScenePeriod((long)this.getModelId(), (long)scenarioDy.getLong("id"));
        Long[] periodIds = DynamicObjectCollectionUtil.getFieldPKArray((DynamicObjectCollection)coll, (String)"fbasedataid");
        QFilter filter3 = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter filter0 = new QFilter("id", "in", (Object)periodIds);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bcm_periodmembertree", (String)selectProperties, (QFilter[])new QFilter[]{filter3, filter0}, (String)"dseq");
        return Lists.newArrayList(map.values());
    }

    public List<DynamicObject> getLargeEffectivePeriod(Collection<DynamicObject> dys) {
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        String startPNumber = startPeriod.getString(NUMBER);
        ArrayList<DynamicObject> speriods = new ArrayList<DynamicObject>(dys.size());
        for (DynamicObject dy : dys) {
            if (startPNumber.compareTo(dy.getString(NUMBER)) > 0) continue;
            speriods.add(dy);
        }
        return speriods;
    }

    public List<DynamicObject> getLessEffectivePeriod(Collection<DynamicObject> dys) {
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        String endPNumber = endPeriod.getString(NUMBER);
        ArrayList<DynamicObject> endperiods = new ArrayList<DynamicObject>(dys.size());
        for (DynamicObject dy : dys) {
            if (endPNumber.compareTo(dy.getString(NUMBER)) < 0) continue;
            endperiods.add(dy);
        }
        return endperiods;
    }

    public List<FYPeriodPair> initAllFYPeriodPair() {
        List<DynamicObject> years = this.getEffectiveYear();
        List<DynamicObject> periods = this.getEffectivePeriod();
        DynamicObject startYear = (DynamicObject)this.getModel().getValue(START_YEAR);
        String startYearNumber = startYear.getString(NUMBER);
        DynamicObject endYear = (DynamicObject)this.getModel().getValue(END_YEAR);
        String endYearNumber = endYear.getString(NUMBER);
        boolean isOneYear = startYearNumber.equals(endYearNumber);
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        String endPeriodNumber = endPeriod.getString(NUMBER);
        DynamicObject startPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        String startPeriodNumber = startPeriod.getString(NUMBER);
        List<DynamicObject> lessPs = this.getLessEffectivePeriod(periods);
        List<DynamicObject> largePs = this.getLargeEffectivePeriod(periods);
        ArrayList<FYPeriodPair> fyPeriodKeys = new ArrayList<FYPeriodPair>(10);
        for (DynamicObject year : years) {
            FYPeriodPair fyPeriodPair;
            String periodNumber;
            String yearStr = year.getString(NUMBER);
            if (startYearNumber.equals(yearStr)) {
                for (DynamicObject largeP : largePs) {
                    periodNumber = largeP.getString(NUMBER);
                    if (isOneYear && periodNumber.compareTo(startPeriodNumber) >= 0 && periodNumber.compareTo(endPeriodNumber) <= 0) {
                        fyPeriodPair = new FYPeriodPair(startYearNumber + SPLITSTR + largeP.getString(NUMBER), year, largeP);
                        fyPeriodKeys.add(fyPeriodPair);
                        continue;
                    }
                    if (isOneYear || periodNumber.compareTo(startPeriodNumber) < 0) continue;
                    fyPeriodPair = new FYPeriodPair(startYearNumber + SPLITSTR + largeP.getString(NUMBER), year, largeP);
                    fyPeriodKeys.add(fyPeriodPair);
                }
                continue;
            }
            if (endYearNumber.equals(yearStr)) {
                for (DynamicObject lessP : lessPs) {
                    periodNumber = lessP.getString(NUMBER);
                    if (periodNumber.compareTo(endPeriodNumber) > 0) continue;
                    fyPeriodPair = new FYPeriodPair(endYearNumber + SPLITSTR + lessP.getString(NUMBER), year, lessP);
                    fyPeriodKeys.add(fyPeriodPair);
                }
                continue;
            }
            for (DynamicObject period : periods) {
                FYPeriodPair fyPeriodPair2 = new FYPeriodPair(yearStr + SPLITSTR + period.getString(NUMBER), year, period);
                fyPeriodKeys.add(fyPeriodPair2);
            }
        }
        return fyPeriodKeys;
    }

    @Override
    public void destory() {
        this.getView().hideLoading();
        super.destory();
    }

    static {
        fileTypeMap.put("0", ResManager.loadKDString((String)"Microsoft Excel 97-2003 \u5de5\u4f5c\u8868 (.xls)", (String)"ReportMultiExportPlugin_42", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        fileTypeMap.put("3", ResManager.loadKDString((String)"Microsoft Excel \u5de5\u4f5c\u8868 (.xlsx)", (String)"ReportMultiExportPlugin_43", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }
}

