/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.innertrade.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.grapecity.documents.excel.SaveFileFormat;
import com.grapecity.documents.excel.Workbook;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrMergeParam;
import kd.fi.bcm.business.innertrade.model.IntrRow;
import kd.fi.bcm.business.innertrade.model.IntrTable;
import kd.fi.bcm.business.innertrade.model.IntrTplDimScope;
import kd.fi.bcm.business.innertrade.report.IntrReportHelper;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.innertrade.report.QueryIntrDataHelper;
import kd.fi.bcm.business.papertemplate.filterchain.AbstractPaperFilter;
import kd.fi.bcm.business.papertemplate.filterchain.PaperTmplChainFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.IntrRecordAddition;
import kd.fi.bcm.business.papertemplate.filterchain.filter.OrgAssignFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.ReadOrWriteAuthFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.SceneFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.StatusFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.VersionFilter;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.innertrade.export.IntrReportMultiExportPlugin;
import kd.fi.bcm.formplugin.report.export.FYPeriodPair;
import kd.fi.bcm.formplugin.report.export.SheetInfo;
import kd.fi.bcm.formplugin.report.util.SXSSFUtil;
import kd.fi.bcm.formplugin.util.POIUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.util.GZIPUtils;
import kd.fi.bcm.spread.util.SpreadUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbookType;

public class IntrReportMultiExportService
implements Serializable {
    private static final Log log = LogFactory.getLog(IntrReportMultiExportService.class);
    private static final long serialVersionUID = -2591357818293491255L;
    private Long modelId;
    private String modelShowNum;
    private String modelNum;
    private Long userId;
    private DynamicObject scene;
    private List<FYPeriodPair> fyPeriodPairs;
    private int dataunit = 0;
    private Integer scale = null;
    private BigDecimal divisor = BigDecimal.ONE;
    private String exportType;
    private String excelType;
    private DynamicObjectCollection effectOrgs;
    private DynamicObjectCollection effectTmpls;
    private boolean isPackDownload;
    private String fileRuleStr;
    private String sheetRuleStr;
    private String filetxt;
    private String sheettxt;
    private Map<String, String> fileMap = new HashMap<String, String>(16);
    private Integer allSheetCount;
    private AtomicInteger completeSheet = new AtomicInteger(0);
    private Consumer<Integer> taskConsumer;
    private HashMultimap<String, String> sheetName2Name = HashMultimap.create();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private SimpleDateFormat sdfss = new SimpleDateFormat("yyyyMMddHHmmss");

    public IntrReportMultiExportService(IntrReportMultiExportPlugin plugin) {
        this.modelId = plugin.getModelId();
        this.modelShowNum = MemberReader.findModelSNumberById((Object)this.modelId);
        this.modelNum = MemberReader.findModelNumberById((Object)this.modelId);
        this.userId = plugin.getUserId();
        this.scene = plugin.scene;
        this.fyPeriodPairs = plugin.fyPeriodPairs;
        this.dataunit = plugin.viewDataunit;
        this.scale = plugin.scale;
        this.divisor = BigDecimal.valueOf(Math.pow(10.0, this.dataunit));
        this.exportType = plugin.excelfiletype;
        this.excelType = plugin.filetype;
        this.effectOrgs = plugin.effectOrgs;
        this.effectTmpls = plugin.effectTmpls;
        this.isPackDownload = plugin.isPackDownload;
        this.fileRuleStr = plugin.fileruleStr;
        this.sheetRuleStr = plugin.sheetruleStr;
        this.filetxt = plugin.filetxt;
        this.sheettxt = plugin.sheettxt;
        this.allSheetCount = this.effectOrgs.size() * this.fyPeriodPairs.size() * this.effectTmpls.size();
    }

    public Map<String, String> doExportExcels() {
        Object fileName;
        SXSSFWorkbook workbook;
        if ("0".equals(this.exportType)) {
            for (DynamicObject org : this.effectOrgs) {
                for (FYPeriodPair fyPeriodPair : this.fyPeriodPairs) {
                    workbook = new SXSSFWorkbook(500);
                    this.sheetName2Name = HashMultimap.create();
                    for (DynamicObject effectTmpl : this.effectTmpls) {
                        this.createSheet(workbook, org, fyPeriodPair, effectTmpl, this.sheetRuleStr, this.sheettxt);
                    }
                    fileName = this.getFileName(org, fyPeriodPair, null, this.fileRuleStr, this.filetxt);
                    this.addToResultMap(this.createFileDownloadUrl((String)fileName, workbook), (String)fileName);
                }
            }
        }
        if ("1".equals(this.exportType)) {
            for (FYPeriodPair fyPeriodPair : this.fyPeriodPairs) {
                for (DynamicObject effectTmpl : this.effectTmpls) {
                    workbook = new SXSSFWorkbook(500);
                    this.sheetName2Name = HashMultimap.create();
                    for (DynamicObject org : this.effectOrgs) {
                        this.createSheet(workbook, org, fyPeriodPair, effectTmpl, this.sheetRuleStr, this.sheettxt);
                    }
                    fileName = this.getFileName(null, fyPeriodPair, effectTmpl, this.fileRuleStr, this.filetxt);
                    this.addToResultMap(this.createFileDownloadUrl((String)fileName, workbook), (String)fileName);
                }
            }
        }
        if ("2".equals(this.exportType)) {
            for (DynamicObject org : this.effectOrgs) {
                for (DynamicObject effectTmpl : this.effectTmpls) {
                    workbook = new SXSSFWorkbook(500);
                    this.sheetName2Name = HashMultimap.create();
                    for (FYPeriodPair fyPeriodPair : this.fyPeriodPairs) {
                        this.createSheet(workbook, org, fyPeriodPair, effectTmpl, this.sheetRuleStr, this.sheettxt);
                        String fileName2 = this.getFileName(org, null, effectTmpl, this.fileRuleStr, this.filetxt);
                        this.addToResultMap(this.createFileDownloadUrl(fileName2, workbook), fileName2);
                    }
                }
            }
        }
        return this.fileMap;
    }

    private String getFillKey(long year, long period, long entity, long papertemplate) {
        return String.format("%s_%s_%s_%s", year, period, entity, papertemplate);
    }

    private void addToResultMap(String fileDownloadUrl, String fileName) {
        if (StringUtils.isNotBlank((CharSequence)fileDownloadUrl)) {
            this.fileMap.put(fileDownloadUrl, fileName);
        }
    }

    private String getFileName(DynamicObject org, FYPeriodPair fyPeriodPair, DynamicObject effectTmpl, String nameRuleStr, String fixTxt) {
        return this.getCustomName(org, fyPeriodPair, effectTmpl, nameRuleStr, fixTxt) + "." + this.getFileSuffix();
    }

    private String getCustomName(DynamicObject org, FYPeriodPair fyPeriodPair, DynamicObject effectTmpl, String nameRuleStr, String fixTxt) {
        String customName = nameRuleStr;
        if (effectTmpl != null) {
            DynamicObject tmplDoc = effectTmpl.getDynamicObject("intr_template_number");
            customName = customName.replace("reportnumber", StringUtils.isBlank((CharSequence)effectTmpl.getString("intr_definednumber")) ? tmplDoc.getString("number") : effectTmpl.getString("intr_definednumber"));
            customName = customName.replace("reportname", StringUtils.isBlank((CharSequence)effectTmpl.getString("intr_definedname")) ? tmplDoc.getString("name") : effectTmpl.getString("intr_definedname"));
            customName = customName.replace("tempcatalog", tmplDoc.getString("templatecatalog.name"));
        }
        if (org != null) {
            customName = customName.replace("orgnumber", org.getString("number"));
            customName = customName.replace("orgname", org.getString("name"));
            customName = customName.replace("orgcode", org.getString("orgcode"));
            customName = customName.replace("orgsimplename", org.getString("simplename"));
            customName = customName.replace("currencynumber", org.getString("number"));
            customName = customName.replace("currencyname", org.getString("name"));
        }
        if (fyPeriodPair != null) {
            if (fyPeriodPair.getFy() != null) {
                customName = customName.replace("yearnumber", fyPeriodPair.getFy().getString("number"));
                customName = customName.replace("yearname", fyPeriodPair.getFy().getString("name"));
            }
            if (fyPeriodPair.getFy() != null) {
                customName = customName.replace("periodnumber", fyPeriodPair.getPeriod().getString("number"));
                customName = customName.replace("periodname", fyPeriodPair.getPeriod().getString("name"));
            }
        }
        customName = customName.replace("systemtime", this.sdf.format(new Date()));
        customName = customName.replace("txt", StringUtils.isEmpty((CharSequence)fixTxt) ? "" : fixTxt);
        return customName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createFileDownloadUrl(String fileName, SXSSFWorkbook workbook) {
        if (workbook == null || !workbook.iterator().hasNext()) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)out);
            String string = this.downloadFile(out, fileName);
            return string;
        }
        catch (IOException e) {
            log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (workbook != null) {
                    try {
                        workbook.dispose();
                        workbook.close();
                    }
                    catch (IOException e) {
                        log.warn("\u5bfc\u51faExcel\u6587\u4ef6\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                log.warn(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
            }
        }
        return "";
    }

    public String getFileSuffix() {
        switch (this.excelType) {
            case "0": {
                return "xls";
            }
            case "3": {
                return "xlsx";
            }
        }
        return "xlsx";
    }

    public String downloadFile(ByteArrayOutputStream oo, String fileName) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        return cache.saveAsUrl(fileName, oo.toByteArray(), 5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSheet(SXSSFWorkbook workbook, DynamicObject org, FYPeriodPair fyPeriodPair, DynamicObject effectTmpl, String sheetRuleStr, String sheettxt) {
        Object spreadJsonOut = null;
        try {
            Optional<Long> tmplIdOpt = this.getEffectTmplId(this.modelId, org.getLong("id"), fyPeriodPair.getFy().getLong("id"), fyPeriodPair.getPeriod().getLong("id"), effectTmpl.getLong("intr_template_number_id"));
            if (!tmplIdOpt.isPresent()) {
                return;
            }
            Long verionTemplateId = tmplIdOpt.get();
            XSSFWorkbook tempWorkboox = null;
            String sheetName = this.getCustomName(org, fyPeriodPair, effectTmpl, sheetRuleStr, sheettxt);
            SheetInfo sheetInfo = new SheetInfo(0, sheetName, null);
            IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberByNum((String)this.modelNum, (String)MemberReader.findEntityMemberById((Long)this.modelId, (Long)org.getLong("id")).getCurrency());
            DynamicObject report = IntrReportHelper.getReportInfo((Long)this.modelId, (Long)verionTemplateId, (Long)org.getLong("id"), (Long)this.scene.getLong("id"), (Long)fyPeriodPair.getFy().getLong("id"), (Long)fyPeriodPair.getPeriod().getLong("id"), (Long)currencyNode.getId());
            if (report != null && StringUtils.isNotEmpty((CharSequence)report.getString("spreadjson"))) {
                DynamicObject tmplInfo;
                tempWorkboox = this.getWorkBook(report.getString("spreadjson"), sheetName);
                SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)report.getString("data"));
                sheetInfo.setMaxRow(sm.getBook().getSheet(0).getMaxRowCount());
                sheetInfo.setMaxCol(sm.getBook().getSheet(0).getMaxColumnCount());
                if ((BigDecimal.ONE.compareTo(this.divisor) != 0 || this.scale != null) && (tmplInfo = IntrTemplateHelper.getAllTemplateInfo((Long)this.modelId, (Long)verionTemplateId)) != null) {
                    RangeModel range = SpreadAreaUtil.getRangModel((String)tmplInfo.getString("areapoint"));
                    Pair startPoint = Pair.onePair((Object)(range.getY_start() + 1), (Object)range.getX_start());
                    List fields = QueryIntrDataHelper.queryMergeFields((Long)tmplInfo.getLong("id"));
                    Map<String, Integer> fieldIndexMap = this.getFieldIndexMap(tmplInfo, (Pair<Integer, Integer>)startPoint);
                    Map dimScopeMap = IntrTemplateHelper.getDimScope((Long)verionTemplateId);
                    IntrMergeParam queryParam = new IntrMergeParam(Pair.onePair((Object)this.modelId, (Object)this.modelShowNum), verionTemplateId, Tuple.create((Object)org.getLong("id"), (Object)org.getString("number"), (Object)org.getString("longnumber")), Pair.onePair((Object)this.scene.getLong("id"), (Object)this.scene.getString("number")), Pair.onePair((Object)fyPeriodPair.getFy().getLong("id"), (Object)fyPeriodPair.getFy().getString("number")), Pair.onePair((Object)fyPeriodPair.getPeriod().getLong("id"), (Object)fyPeriodPair.getPeriod().getString("number")), Pair.onePair(null, (Object)org.getString("currency.number")));
                    queryParam.setModelNumber(this.modelNum);
                    IntrTable table = QueryIntrDataHelper.queryIntrDataConvertName((IntrMergeParam)queryParam);
                    this.setSheetValue(tempWorkboox, table, (Pair<Integer, Integer>)startPoint, fields, fieldIndexMap, "1".equals(tmplInfo.getString("usage")), dimScopeMap);
                }
            } else {
                DynamicObject tmplInfo = IntrTemplateHelper.getAllTemplateInfo((Long)this.modelId, (Long)verionTemplateId);
                if (tmplInfo != null) {
                    RangeModel range = SpreadAreaUtil.getRangModel((String)tmplInfo.getString("areapoint"));
                    Pair startPoint = Pair.onePair((Object)(range.getY_start() + 1), (Object)range.getX_start());
                    int maxColIndex = range.getColSize() + (Integer)startPoint.p2;
                    sheetInfo.setMaxCol(maxColIndex);
                    sheetInfo.setMaxRow(range.getY_start());
                    List fields = QueryIntrDataHelper.queryMergeFields((Long)tmplInfo.getLong("id"));
                    Map<String, Integer> fieldIndexMap = this.getFieldIndexMap(tmplInfo, (Pair<Integer, Integer>)startPoint);
                    Map dimScopeMap = IntrTemplateHelper.getDimScope((Long)verionTemplateId);
                    tempWorkboox = this.getWorkBook(tmplInfo.getString("spreadjson"), sheetName);
                    if (tempWorkboox == null) {
                        log.error("\u751f\u6210sheet\u5931\u8d25\uff0c\u7ec4\u7ec7\uff1a%s\uff0c\u8d22\u5e74\uff1a%s\uff0c\u671f\u95f4\uff1a%s\uff0c\u6a21\u677f\uff1a%s", new Object[]{org.getString("number"), fyPeriodPair.getFy().getString("number"), fyPeriodPair.getPeriod().getString("number"), effectTmpl.getDynamicObject("intr_template_number").getString("number")});
                        return;
                    }
                    int formulaMaxCol = this.caculateRptInfoFormula(tempWorkboox.getSheetAt(0), sheetInfo, this.modelId, verionTemplateId, org, this.scene, fyPeriodPair);
                    maxColIndex = Math.max(maxColIndex, formulaMaxCol);
                    sheetInfo.setMaxCol(maxColIndex);
                    IntrMergeParam queryParam = new IntrMergeParam(Pair.onePair((Object)this.modelId, (Object)this.modelShowNum), verionTemplateId, Tuple.create((Object)org.getLong("id"), (Object)org.getString("number"), (Object)org.getString("longnumber")), Pair.onePair((Object)this.scene.getLong("id"), (Object)this.scene.getString("number")), Pair.onePair((Object)fyPeriodPair.getFy().getLong("id"), (Object)fyPeriodPair.getFy().getString("number")), Pair.onePair((Object)fyPeriodPair.getPeriod().getLong("id"), (Object)fyPeriodPair.getPeriod().getString("number")), Pair.onePair(null, (Object)org.getString("currency.number")));
                    queryParam.setModelNumber(this.modelNum);
                    IntrTable table = QueryIntrDataHelper.queryIntrDataConvertName((IntrMergeParam)queryParam);
                    Integer maxRow = table.getMaxRow();
                    if ("0".equals(tmplInfo.getString("usage"))) {
                        maxRow = range.getY_start() + maxRow;
                    }
                    if (maxRow > sheetInfo.getMaxRow()) {
                        sheetInfo.setMaxRow(maxRow);
                    }
                    this.setSheetValue(tempWorkboox, table, (Pair<Integer, Integer>)startPoint, fields, fieldIndexMap, "1".equals(tmplInfo.getString("usage")), dimScopeMap);
                    this.setCellStyle(tempWorkboox, (Pair<Integer, Integer>)startPoint, maxRow, maxColIndex);
                }
            }
            if (tempWorkboox == null) {
                log.error("\u751f\u6210sheet\u5931\u8d25\uff0c\u7ec4\u7ec7\uff1a%s\uff0c\u8d22\u5e74\uff1a%s\uff0c\u671f\u95f4\uff1a%s\uff0c\u6a21\u677f\uff1a%s", new Object[]{org.getString("number"), fyPeriodPair.getFy().getString("number"), fyPeriodPair.getPeriod().getString("number"), effectTmpl.getDynamicObject("intr_template_number").getString("number")});
                return;
            }
            this.copyWorkbook(tempWorkboox, workbook, sheetInfo);
        }
        catch (Throwable e) {
            log.error("\u751f\u6210sheet\u5931\u8d25\uff0c\u7ec4\u7ec7\uff1a%s\uff0c\u8d22\u5e74\uff1a%s\uff0c\u671f\u95f4\uff1a%s\uff0c\u6a21\u677f\uff1a%s", new Object[]{org.getString("number"), fyPeriodPair.getFy().getString("number"), fyPeriodPair.getPeriod().getString("number"), effectTmpl.getDynamicObject("intr_template_number").getString("number"), e});
        }
        finally {
            this.closeBackCompleteOneSheet();
        }
    }

    private XSSFWorkbook getWorkBook(String spreadJson, String sheetName) throws IOException {
        try (ByteArrayOutputStream spreadJsonOut = null;){
            Optional sheetObjEntry;
            String realSpreadJson = this.getRealSpreadJson(spreadJson);
            String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(realSpreadJson)));
            int freeRow = 0;
            int freecol = 0;
            JSONArray columns = new JSONArray();
            JSONObject jsonMap = JSONObject.parseObject((String)ssjson, (Feature[])new Feature[]{Feature.OrderedField});
            JSONObject sheets = jsonMap.getJSONObject("sheets");
            boolean isChange = false;
            if (sheets != null) {
                sheetObjEntry = sheets.entrySet().stream().findFirst();
                JSONObject sheetObj = null;
                if (sheetObjEntry.isPresent()) {
                    sheetObj = (JSONObject)((Map.Entry)sheetObjEntry.get()).getValue();
                }
                if (sheetObj != null) {
                    if (sheetObj.containsKey((Object)"rowFilter")) {
                        isChange = true;
                        sheetObj.remove((Object)"rowFilter");
                    }
                    columns = sheetObj.getJSONArray("columns");
                }
                Workbook gcbook = SpreadUtils.getWorkbook((String)(isChange ? jsonMap.toString() : ssjson));
                freeRow = gcbook.getActiveSheet().getFreezeRow();
                freecol = gcbook.getActiveSheet().getFreezeColumn();
                spreadJsonOut = SpreadUtils.getByteArrayOutputStream((Workbook)gcbook, (SaveFileFormat)SaveFileFormat.Xlsx);
            }
            if (spreadJsonOut == null) {
                sheetObjEntry = null;
                return sheetObjEntry;
            }
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String excelUrl = cache.saveAsUrl(sheetName + "." + XSSFWorkbookType.XLSX.getExtension(), spreadJsonOut.toByteArray(), 1000);
            XSSFWorkbook tempWorkboox = new XSSFWorkbook(cache.getInputStream(excelUrl));
            tempWorkboox.setMissingCellPolicy(Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            tempWorkboox.setForceFormulaRecalculation(false);
            XSSFSheet sheet = tempWorkboox.getSheetAt(0);
            if (columns != null && !columns.isEmpty()) {
                for (int i = 0; i < columns.size(); ++i) {
                    if (columns.getJSONObject(i) == null || columns.getJSONObject(i).get((Object)"size") == null) continue;
                    int size = Double.valueOf(columns.getJSONObject(i).get((Object)"size").toString()).intValue();
                    sheet.autoSizeColumn(i);
                    sheet.setColumnWidth(i, size * 35);
                }
            }
            sheet.createFreezePane(freeRow, freecol);
            XSSFWorkbook xSSFWorkbook = tempWorkboox;
            return xSSFWorkbook;
        }
    }

    private Optional<Long> getEffectTmplId(Long modelId, long orgId, long yearId, long periodId, long tmplId) {
        Set groupTmpIds = IntrTemplateHelper.getGroupTmplIds((Long)modelId, (Set)Sets.newHashSet((Object[])new Long[]{tmplId}));
        PaperTmplChainFilter filter = new PaperTmplChainFilter(modelId, PaperTemplateTypeEnum.INNERTRADE);
        filter.addFilter((AbstractPaperFilter)new VersionFilter(Long.valueOf(yearId), Long.valueOf(periodId))).addFilter((AbstractPaperFilter)new OrgAssignFilter((Set)Sets.newHashSet((Object[])new Long[]{orgId}))).addFilter((AbstractPaperFilter)new SceneFilter(Long.valueOf(this.scene.getLong("id")))).addFilter((AbstractPaperFilter)new StatusFilter(Boolean.valueOf(true))).addFilter((AbstractPaperFilter)new IntrRecordAddition(groupTmpIds, (Set)Sets.newHashSet((Object[])new Long[]{orgId}), Long.valueOf(this.scene.getLong("id")), Long.valueOf(yearId), Long.valueOf(periodId))).addFilter((AbstractPaperFilter)new ReadOrWriteAuthFilter(this.userId));
        Set ids = filter.doFilter(groupTmpIds);
        return ids.stream().findFirst();
    }

    private int caculateRptInfoFormula(XSSFSheet sheet, SheetInfo sheetInfo, Long modelId, Long verionTemplateId, DynamicObject org, DynamicObject scene, FYPeriodPair fyPeriodPair) {
        int maxCol = 0;
        CalContext calContext = new CalContext(MemberReader.findModelNumberById((Object)modelId), org.getString("number"), fyPeriodPair.getFy().getString("number"), fyPeriodPair.getPeriod().getString("number"), this.scene.getString("number"), org.getString("currency.number"));
        DynamicObject currencyDyn = OrgCurrencyServiceHelper.getCurrencyDyn((String)org.getString("currency.number"), (long)this.getModelId());
        DynamicObject report = IntrReportHelper.getReport((Long)modelId, (Long)verionTemplateId, (Long)org.getLong("id"), (Long)scene.getLong("id"), (Long)fyPeriodPair.getFy().getLong("id"), (Long)fyPeriodPair.getPeriod().getLong("id"), (Long)currencyDyn.getLong("id"), (String)"modifier.name");
        String intrModifyName = null;
        if (report != null && StringUtils.isNotBlank((CharSequence)report.getString("modifier.name"))) {
            intrModifyName = report.getString("modifier.name");
        }
        calContext.setProperty("intrModifyName", intrModifyName);
        CalculateService calculateService = new CalculateService((ICalContext)calContext);
        int rowCount = Math.max(sheetInfo.getMaxRow(), sheet.getLastRowNum());
        for (int i = 0; i <= rowCount; ++i) {
            XSSFRow row = this.getOrCreateRow(sheet, i);
            Iterator it = row.cellIterator();
            while (it.hasNext()) {
                String formula;
                XSSFCell cell = (XSSFCell)it.next();
                if (CellType.FORMULA != cell.getCellType() || kd.fi.bcm.fel.common.StringUtils.isBlank((CharSequence)(formula = cell.getCellFormula()))) continue;
                Object value = calculateService.singleCalculate(formula);
                cell.removeFormula();
                maxCol = Math.max(maxCol, cell.getColumnIndex());
                SXSSFUtil.setCellValue(cell, value);
            }
        }
        return maxCol;
    }

    private void setCellStyle(XSSFWorkbook workbook, Pair<Integer, Integer> startPoint, Integer maxRow, Integer maxCol) {
        XSSFSheet sheet = workbook.getSheetAt(0);
        XSSFRow formateRow = this.getOrCreateRow(sheet, (Integer)startPoint.p1);
        Integer i = (Integer)startPoint.p1;
        while (i <= maxRow) {
            XSSFRow row = this.getOrCreateRow(sheet, i);
            row.setHeight(formateRow.getHeight());
            row.setRowStyle((CellStyle)formateRow.getRowStyle());
            for (int colIndex = 0; colIndex < maxCol; ++colIndex) {
                XSSFCell cell = formateRow.getCell(colIndex);
                if (cell == null) continue;
                row.getCell(colIndex).setCellStyle((CellStyle)cell.getCellStyle());
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    private XSSFRow getOrCreateRow(XSSFSheet sheet, int rowIndex) {
        XSSFRow row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    private XSSFCell getCell(XSSFRow row, int colIndex) {
        return row.getCell(colIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
    }

    private void setSheetValue(XSSFWorkbook tempWorkboox, IntrTable table, Pair<Integer, Integer> startPoint, List<IntrField> fields, Map<String, Integer> fieldIndexMap, boolean isCslReport, Map<String, IntrTplDimScope> dimScopeMap) {
        if (table == null || CollectionUtils.isEmpty((Collection)table.getRows())) {
            return;
        }
        XSSFSheet sheet = tempWorkboox.getSheetAt(0);
        int rowIndex = (Integer)startPoint.p1;
        for (IntrRow data : table.getRows()) {
            if (isCslReport) {
                rowIndex = data.getRowNumber();
            }
            for (IntrField field : fields) {
                XSSFRow row = this.getOrCreateRow(sheet, rowIndex);
                XSSFCell cell = this.getCell(row, fieldIndexMap.get(field.getNumber()));
                Object value = data.getData().get(field.getNumber());
                if (value instanceof Number && DataTypeEnum.CURRENCY.getOIndex().equals(field.getDataType())) {
                    BigDecimal srcval = new BigDecimal(value.toString());
                    BigDecimal newval = this.scale != null ? srcval.divide(this.divisor, (int)this.scale, RoundingMode.HALF_UP) : srcval.divide(this.divisor, RoundingMode.HALF_UP);
                    SXSSFUtil.setCellValue(cell, newval);
                    continue;
                }
                if (value instanceof Pair) {
                    Pair temp = (Pair)value;
                    value = IntrReportHelper.getDisplayName((String)((String)temp.p1), (String)((String)temp.p2), dimScopeMap.get(field.getNumber()) == null ? null : dimScopeMap.get(field.getNumber()).getDisplayMode());
                }
                SXSSFUtil.setCellValue(cell, value);
            }
            ++rowIndex;
        }
    }

    private Map<String, Integer> getFieldIndexMap(DynamicObject versionTmpl, Pair<Integer, Integer> startPoint) {
        HashMap<String, Integer> fieldIndexMap = new HashMap<String, Integer>(16);
        SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)versionTmpl.getString("data"));
        if (startPoint != null) {
            fieldIndexMap = new HashMap(16);
            List headRow = spreadManager.getBook().getSheet(0).getRow((Integer)startPoint.p1 - 1, true);
            fieldIndexMap.put(IntrConstant.FIELD_ORG_NUMBER, (Integer)startPoint.p2);
            fieldIndexMap.put(IntrConstant.FIELD_IC_NUMBER, (Integer)startPoint.p2 + 1);
            for (int i = ((Integer)startPoint.p2).intValue(); i < headRow.size(); ++i) {
                Cell cell = (Cell)headRow.get(i);
                if (cell.getUserObject() == null || cell.getUserObject().size() <= 0 || cell.getUserObject("number") == null) continue;
                String number = cell.getUserObject("number").toString();
                if (IntrConstant.FIELD_ORG_NUMBER.equalsIgnoreCase(number)) {
                    number = IntrConstant.FIELD_ORG_NUMBER;
                }
                if (IntrConstant.FIELD_IC_NUMBER.equalsIgnoreCase(number)) {
                    number = IntrConstant.FIELD_IC_NUMBER;
                }
                fieldIndexMap.put(number, i);
            }
        }
        return fieldIndexMap;
    }

    private void copyWorkbook(XSSFWorkbook sourceWorkbook, SXSSFWorkbook targetWorkbook, SheetInfo sheetInfo) {
        XSSFSheet sheet = sourceWorkbook.getSheetAt(0);
        String safeSheetName = IntrReportMultiExportService.createSafeSheetName(sheetInfo.getReal_sheetName(), '_');
        sheetInfo.setReal_sheetName(safeSheetName);
        String addr = "";
        if (!this.sheetName2Name.get((Object)sheetInfo.getReal_sheetName()).isEmpty()) {
            addr = "(" + this.sheetName2Name.get((Object)sheetInfo.getReal_sheetName()).size() + ")";
        }
        if (!StringUtils.isEmpty((CharSequence)addr)) {
            int length = safeSheetName.length();
            int addrLength = addr.length();
            if (length >= 29) {
                safeSheetName = safeSheetName.substring(0, 31 - addrLength);
            }
        }
        XSSFSheet newSheet = targetWorkbook.getXSSFWorkbook().createSheet(safeSheetName + addr);
        newSheet.setForceFormulaRecalculation(false);
        this.sheetName2Name.put((Object)sheetInfo.getReal_sheetName(), (Object)(safeSheetName + addr));
        for (int row = sheetInfo.getMaxRow() + 1; row < sheet.getLastRowNum(); ++row) {
            if (sheet.getRow(row) == null) continue;
            sheet.removeRow((Row)sheet.getRow(row));
        }
        POIUtil.copySheet(targetWorkbook.getXSSFWorkbook(), sheet, newSheet, sheetInfo, null);
        try {
            sourceWorkbook.close();
        }
        catch (IOException e) {
            log.warn("\u5bfc\u51faExcel\u6587\u4ef6\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
        }
    }

    public static String createSafeSheetName(String nameProposal, char replaceChar) {
        if (nameProposal == null) {
            return "null";
        }
        if (nameProposal.length() < 1) {
            return "empty";
        }
        nameProposal = nameProposal.replaceAll("\n", "");
        int length = Math.min(31, nameProposal.length());
        String shortenname = nameProposal.substring(0, length);
        StringBuilder result = new StringBuilder(shortenname);
        block4: for (int i = 0; i < length; ++i) {
            char ch = result.charAt(i);
            switch (ch) {
                case '\u0000': 
                case '\u0003': 
                case '*': 
                case '/': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '\uff1a': {
                    result.setCharAt(i, replaceChar);
                    continue block4;
                }
                case '\'': {
                    if (i != 0 && i != length - 1) continue block4;
                    result.setCharAt(i, replaceChar);
                }
            }
        }
        return result.toString();
    }

    private String getRealSpreadJson(String spreadjson) {
        if (spreadjson.startsWith("#MERGE#")) {
            spreadjson = StringUtils.substring((String)spreadjson, (int)"#MERGE#".length());
        }
        return spreadjson.substring(6);
    }

    private void closeBackCompleteOneSheet() {
        this.taskConsumer.accept(this.completeSheet.incrementAndGet() / this.allSheetCount * 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> zipFiles() {
        HashMap<String, String> result = new HashMap<String, String>(1);
        String fileName = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u6587\u4ef6%s.zip", (String)"IntrReportMultiExportService_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.sdfss.format(new Date()));
        byte[] buffer = new byte[512];
        int readLength = 0;
        ByteArrayOutputStream oo = new ByteArrayOutputStream();
        InputStream inputStream = null;
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        if (!this.fileMap.isEmpty()) {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)oo, Charset.forName("GBK"));){
                for (Map.Entry<String, String> entry : this.fileMap.entrySet()) {
                    ZipEntry z = new ZipEntry(entry.getValue());
                    zipOutputStream.putNextEntry(z);
                    inputStream = cache.getInputStream(entry.getKey());
                    while ((readLength = inputStream.read(buffer, 0, 512)) != -1) {
                        zipOutputStream.write(buffer, 0, readLength);
                    }
                    inputStream.close();
                    zipOutputStream.closeEntry();
                }
                zipOutputStream.finish();
                result.put(cache.saveAsUrl(fileName, oo.toByteArray(), 5000), fileName);
            }
            catch (IOException e) {
                log.warn((Throwable)e);
            }
            finally {
                try {
                    oo.close();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20));
                }
            }
        }
        return result;
    }

    public void setTaskConsumer(Consumer<Integer> taskConsumer) {
        this.taskConsumer = taskConsumer;
    }

    public boolean isPackDownload() {
        return this.isPackDownload;
    }

    public Long getModelId() {
        return this.modelId;
    }
}

