/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.innertrade.export;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.enums.ExportPageSourceEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.innertrade.export.IntrReportMultiExportService;
import org.apache.commons.lang3.StringUtils;

public class IntrReportMultiExportTask
extends AbstractTask {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(IntrReportMultiExportTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        log.startWatch();
        Recorder serviceRecord = new Recorder(null);
        String reportMultiExportTask_0 = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1\u3002", (String)"ReportMultiExportTask_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        this.feedbackProgress(0, reportMultiExportTask_0, null);
        Map<Object, Object> data = new HashMap(16);
        String message = "";
        Date now = TimeServiceHelper.now();
        try {
            if (this.isStop()) {
                this.stop();
            }
            if (params.containsKey("service")) {
                String serviceStr = (String)params.get("service");
                serviceRecord.setRecord(ObjectSerialUtil.deSerializedBytes((String)serviceStr));
                ((IntrReportMultiExportService)serviceRecord.getRecord()).setTaskConsumer(e -> this.feedbackProgress((int)e, reportMultiExportTask_0, null));
                if (((IntrReportMultiExportService)serviceRecord.getRecord()).isPackDownload()) {
                    ((IntrReportMultiExportService)serviceRecord.getRecord()).doExportExcels();
                    data.putAll(((IntrReportMultiExportService)serviceRecord.getRecord()).zipFiles());
                } else {
                    data = ((IntrReportMultiExportService)serviceRecord.getRecord()).doExportExcels();
                }
            }
        }
        catch (Exception e2) {
            message = ThrowableHelper.toString((Exception)e2);
            log.error((Throwable)e2);
        }
        ArrayList<DynamicObject> urlDys = new ArrayList<DynamicObject>(16);
        SimpleDateFormat sdfss = new SimpleDateFormat("yyyyMMddHHmmss");
        for (Map.Entry kv : data.entrySet()) {
            DynamicObject urlDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_exporturllist");
            urlDy.set("url", kv.getKey());
            urlDy.set("filename", (Object)this.addTimeStamp(sdfss, (String)kv.getValue()));
            urlDy.set("creater", (Object)Long.parseLong(RequestContext.get().getUserId()));
            urlDy.set("createdate", (Object)now);
            urlDy.set("modifydate", (Object)now);
            urlDy.set("type", (Object)ExportPageSourceEnum.INTR.getIndex());
            urlDy.set("log", (Object)message);
            urlDy.set("model", (Object)((IntrReportMultiExportService)serviceRecord.getRecord()).getModelId());
            urlDys.add(urlDy);
        }
        SaveServiceHelper.save((DynamicObject[])urlDys.toArray(new DynamicObject[0]));
        Set<Object> urls = data.keySet();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", "true");
        result.put("data", urls);
        result.put("message", message);
        log.infoEnd("\u5185\u90e8\u4ea4\u6613\u5bfc\u51fa\u6587\u4ef6\u8def\u5f84\uff1a" + String.join((CharSequence)",", urls));
        this.feedbackCustomdata(result);
    }

    private String addTimeStamp(SimpleDateFormat sdfss, String fileName) {
        String name = StringUtils.substringBeforeLast((String)fileName, (String)".");
        String ext = StringUtils.substringAfterLast((String)fileName, (String)".");
        return name + "_" + sdfss.format(new Date()) + "." + ext;
    }
}

