/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.innertrade.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.lang.Lang;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrMergeContext;
import kd.fi.bcm.business.innertrade.model.IntrMergeParam;
import kd.fi.bcm.business.innertrade.model.IntrMergeResult;
import kd.fi.bcm.business.innertrade.model.IntrReportData;
import kd.fi.bcm.business.innertrade.model.IntrRow;
import kd.fi.bcm.business.innertrade.model.IntrTable;
import kd.fi.bcm.business.innertrade.model.IntrTplDimScope;
import kd.fi.bcm.business.innertrade.report.IntrReportHelper;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.innertrade.report.QueryIntrDataHelper;
import kd.fi.bcm.business.linkquery.LinkQueryUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.papertemplate.PaperTemplateRuleHelper;
import kd.fi.bcm.business.papertemplate.filterchain.AbstractPaperFilter;
import kd.fi.bcm.business.papertemplate.filterchain.PaperTmplChainFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.OrgAssignFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.ReadOrWriteAuthFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.SceneFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.StatusFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.VersionFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.YearPeriodFilter;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.ExtConvertServiceHelper;
import kd.fi.bcm.business.serviceHelper.MutexServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserServiceHelper;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.convert.ReportConvertParam;
import kd.fi.bcm.common.encrypt.Encrypt;
import kd.fi.bcm.common.encrypt.EncryptFactory;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.adjust.LinkAdjustMappingEnum;
import kd.fi.bcm.common.enums.innertrade.IntrDimDisplayModeEnum;
import kd.fi.bcm.common.enums.innertrade.IntrReportStatusEnum;
import kd.fi.bcm.common.enums.innertrade.IntrRptGenTypeEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateRuleTypeEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.database.SpreadMulItemClassEdit;
import kd.fi.bcm.formplugin.innertrade.report.multi.IntrReportCacheService;
import kd.fi.bcm.formplugin.innertrade.report.multi.IntrReportPostmanByTemplate;
import kd.fi.bcm.formplugin.innertrade.report.multi.IntrReportTabInfo;
import kd.fi.bcm.formplugin.innertrade.report.multi.IntrReportTabManager;
import kd.fi.bcm.formplugin.intergration.formula.FormulaLinkShowForm;
import kd.fi.bcm.formplugin.report.IIncreaseReportTab;
import kd.fi.bcm.formplugin.report.postman.AbstractReportPostman;
import kd.fi.bcm.formplugin.spread.SpreadBasePlugin;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.spread.SpreadUtils;
import kd.fi.bcm.formplugin.template.model.ISpreadModelSupplier;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.UserObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class AbstractIntrReportPlugin
extends SpreadBasePlugin
implements IIncreaseReportTab,
ISpreadModelSupplier {
    protected static final Encrypt encrypt = EncryptFactory.getInstance((String)"Encrypt_Five");
    public static final String SPLIT_SYMBLE = "_";
    protected static final String SPREAD_KEY = "report";
    protected static final String REPORT_TAB = "reporttab";
    private static final String CMDNAMEKEY = "closeTab";
    private static final String CMDNAMEKEYS = "closeTabs";
    private static final String IS_MODIFY = "is_modify";
    private static final String SWITCH_TAB = "switch_tab";
    private static final String CLOSE_TAB = "close_tab";
    private static final String FRESH_TAB = "fresh_tab";
    private static final String QUIT_VIEW = "quit_view";
    public static final String CHANGE_CONDITION = "change_condition";
    public static final String INTR_SM_CACHE_KEY = "intr_sm";
    public static final String CLOSE_TAB_FLAG_KEY = "close_tab_flag";
    public static final String SWITCH_TAB_KEY = "switch_tab_key";
    public static final String SAVE_ACTION = "SAVE_ACTION";
    public static final String CONFIRM_CLOSE = "confirmClose";
    private static final Set<String> PERIOD_CHECK_BTNS = Sets.newHashSet((Object[])new String[]{"btn_save", "btn_complete", "btn_back", "btn_genadjust", "btn_caculate", "btn_cancel", "btn_commit", "btn_convert", "btn_reset", "btn_rule"});
    private static final Set<String> READONLY_CHECK_BTNS = Sets.newHashSet((Object[])new String[]{"btn_save", "btn_complete", "btn_cancel", "btn_commit", "btn_caculate", "btn_reset", "btn_convert", "btn_back", "btn_genadjust", "btn_rule"});
    public static final String RESET_TABLE = "reset_table";
    public static final String LOSE_LOCK = "loseLock";
    public static final String HAS_LOCK = "hasLock";
    private static final Set<String> PROPER_CHANGE_SPEC_DEAL = Sets.newHashSet((Object[])new String[]{"scenario", "year", "period", "currency"});
    protected IntrReportCacheService cacheService;
    private IntrReportTabManager manager;
    private SpreadManager currentManager;
    private boolean isCacheSpreadModel = false;

    @Override
    public String getSpreadKey() {
        return SPREAD_KEY;
    }

    @Override
    public void initialize() {
        super.initialize();
        HashMap<String, SingleF7TypeEnum> map = new HashMap<String, SingleF7TypeEnum>(16);
        this.asMapF7toType(Arrays.asList("scenario", "year", "period", "currency"), SingleF7TypeEnum.LEAF, map);
        map.put("entity", SingleF7TypeEnum.COMMON);
        this.initSingleMemberF7(map);
        this.cacheService = new IntrReportCacheService(this.getPageCache());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        Arrays.asList("scenario", "year", "period", "currency").forEach(item -> {
            BasedataEdit control = (BasedataEdit)this.getControl((String)item);
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        });
        Tab reporttab = (Tab)this.getControl(REPORT_TAB);
        if (reporttab != null) {
            reporttab.addTabSelectListener(this::reportTabSelected);
        }
        this.initSpreadListener();
    }

    @Override
    public void setSingleF7Filter(BasedataEditSingleMemberF7 bdEdit) {
        super.setSingleF7Filter(bdEdit);
        if (DimTypesEnum.CURRENCY.getNumber().equalsIgnoreCase(bdEdit.getDimNumber())) {
            QFilter qf = new QFilter("number", "not in", (Object)IntrConstant.CURRENCYNUM).and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            bdEdit.setCustomFilter(qf);
        }
    }

    public void initSpreadListener() {
        this.registerBeforeEvent(EventConstant.ActionName.UPDATE_MULVALUE, e -> {
            IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
            if (tab.isReadOnly() || tab.isLock()) {
                e.setCancel(true);
                return;
            }
            this.setModified(true);
            SpreadManager spreadModel = this.getSpreadModel();
            Sheet sheet = this.getEffectiveSheet(spreadModel);
            int maxRowCount = this.getMaxRowCount(sheet);
            List values = ((SpreadPostDataInfo)e.getParam()).getValues();
            this.extendRowStyle(tab, sheet, values);
            if (CollectionUtils.isEmpty((Collection)values)) {
                return;
            }
            String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
            SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
            invoker.setBatch(true);
            Iterator iterator = values.iterator();
            boolean needToCacheModel = Boolean.FALSE;
            while (iterator.hasNext()) {
                LinkedHashMap value = (LinkedHashMap)iterator.next();
                int row = Integer.parseInt(value.get("r").toString());
                if (!this.isClsReport() && row > maxRowCount) continue;
                int col = Integer.parseInt(value.get("c").toString());
                Object cellValue = value.get("v");
                if (!tab.getFieldIndexMap().containsValue(col)) continue;
                Cell newCell = sheet.getCell(row, col);
                if (cellValue == null || StringUtils.isBlank((CharSequence)cellValue.toString())) {
                    newCell.removeUserObject("number");
                    newCell.removeUserObject("name");
                    continue;
                }
                Cell oldCell = sheet.getCell(row, col);
                Object oldValue = oldCell.getValue();
                IntrField field = tab.getField(col);
                IntrDimDisplayModeEnum dimDisplayMode = tab.getDisplayMode(field.getNumber());
                if (field == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5934\u6ca1\u6709\u627e\u5230\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u91cd\u7f6e\u6574\u8868\u540e\uff0c\u91cd\u65b0\u586b\u62a5\u3002", (String)"AbstractIntrReportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!"F7".equals(field.getShowType())) {
                    if (IntrConstant.DB_DIGITAL_DATA_TYPE.contains(field.getDataType())) {
                        String tempValue = StringUtils.deleteWhitespace((String)cellValue.toString());
                        if (!NumberUtils.isCreatable((String)tempValue)) {
                            invoker.updataValue(row, col, oldValue);
                            newCell.setValue(oldValue);
                            iterator.remove();
                            needToCacheModel = Boolean.TRUE;
                            continue;
                        }
                        if (cellValue.toString().equals(tempValue)) continue;
                        invoker.updataValue(row, col, tempValue);
                        newCell.setValue((Object)tempValue);
                        iterator.remove();
                        needToCacheModel = Boolean.TRUE;
                        continue;
                    }
                    if (DataTypeEnum.ENUMTP.getOIndex().equals(field.getDataType())) {
                        ArrayList<Object> enumScopes = new ArrayList<Object>(16);
                        if (tab.getEnums(field.getNumber()) != null) {
                            enumScopes.addAll(tab.getEnums(field.getNumber()));
                        }
                        if (enumScopes.isEmpty()) {
                            enumScopes.addAll(field.getEunmList());
                        }
                        if (!enumScopes.stream().noneMatch(item -> cellValue.toString().equals(item.toString()))) continue;
                        invoker.updataValue(row, col, oldValue);
                        newCell.setValue(oldValue);
                        iterator.remove();
                        needToCacheModel = Boolean.TRUE;
                        continue;
                    }
                    if (DataTypeEnum.DATETP.getOIndex().equals(field.getDataType())) {
                        String dateStr = cellValue.toString();
                        dateStr = DateTimeUtils.getOADateStr((String)dateStr, (String)(oldValue == null ? "" : oldValue.toString()));
                        invoker.updataValue(row, col, dateStr);
                        newCell.setValue((Object)dateStr);
                        iterator.remove();
                        needToCacheModel = Boolean.TRUE;
                        continue;
                    }
                    if (cellValue.toString().length() <= 200) continue;
                    String subValue = StringUtils.substring((String)cellValue.toString(), (int)0, (int)200);
                    invoker.updataValue(row, col, subValue);
                    newCell.setValue((Object)subValue);
                    iterator.remove();
                    needToCacheModel = Boolean.TRUE;
                    continue;
                }
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumber, (String)((String)IntrReportHelper.getAndInitDimInfo((long)this.getModelId(), (IntrField)field).p2), (String)cellValue.toString().split("\\|")[0]);
                if (IDNumberTreeNode.NotFoundTreeNode == node) {
                    invoker.updataValue(row, col, oldValue);
                    newCell.setValue(oldValue);
                } else {
                    String displayValue = IntrReportHelper.getDisplayName((String)node.getNumber(), (String)node.getName(), (IntrDimDisplayModeEnum)dimDisplayMode);
                    invoker.updataValue(row, col, displayValue);
                    newCell.setValue((Object)displayValue);
                    newCell.setUserObject("number", (Object)node.getNumber());
                    newCell.setUserObject("name", (Object)node.getName());
                }
                needToCacheModel = Boolean.TRUE;
                iterator.remove();
            }
            invoker.startToInvoke();
            if (needToCacheModel) {
                this.cacheSpreadModel(spreadModel);
            }
        });
        this.initSubSpreadListener();
    }

    protected abstract void extendRowStyle(IntrReportTabInfo var1, Sheet var2, List<LinkedHashMap<String, Object>> var3);

    protected abstract void initSubSpreadListener();

    protected abstract int getMaxRowCount(Sheet var1);

    @Override
    public void doubleClickLockedCell(int row, int col) {
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        if (tab.isReadOnly()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u6b64\u6570\u636e\u6743\u9650\u3002", (String)"IntrMultiTabReportFillInPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if (tab.isLock()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e95\u7a3f\u5df2\u5176\u4ed6\u7528\u6237\u88ab\u9501\u5b9a\uff0c\u53ea\u80fd\u67e5\u770b\u3002", (String)"IntrMultiTabReportFillInPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (PERIOD_CHECK_BTNS.contains(evt.getItemKey())) {
            this.checkOrgPeriodOpen();
        }
        switch (evt.getItemKey()) {
            case "btn_fresh": {
                if (this.isModified()) {
                    this.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"IntrMultiTabReportFillInPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), FRESH_TAB);
                    break;
                }
                this.loadSheetData();
                break;
            }
            case "btn_save": {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\u3002", (String)"IntrMultiTabReportFillInPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                this.autoFillFixValue();
                this.invokeSaveSpreadJsonEvent();
                this.getPageCache().put(SAVE_ACTION, "true");
                break;
            }
            case "btn_complete": {
                Long reportId = this.getReportTabInfoManager().getCurrSelectReportTabInfo().getReportId();
                if (this.isModified()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u62a5\u8868\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"IntrMultiTabReportFillInPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.validateData()) {
                    return;
                }
                if (reportId == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u62a5\u8868\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"IntrMultiTabReportFillInPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.updateReportStatus(IntrReportStatusEnum.COMPLETE.value);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"IntrMultiTabReportFillInPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5b8c\u6210\u7f16\u5236", "IntrMultiTabReportFillInPlugin_9", "fi-bcm-formplugin", "Completed compilation"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), ResManager.loadKDString((String)"\u5b8c\u6210\u7f16\u5236", (String)"IntrMultiTabReportFillInPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
                break;
            }
            case "btn_cancel": {
                this.updateReportStatus(IntrReportStatusEnum.EDITING.value);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"IntrMultiTabReportFillInPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u53d6\u6d88\u7f16\u5236\u5b8c\u6210", "IntrMultiTabReportFillInPlugin_10", "fi-bcm-formplugin", "Cancel compilation completed"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), ResManager.loadKDString((String)"\u53d6\u6d88\u7f16\u5236\u5b8c\u6210", (String)"IntrMultiTabReportFillInPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
                break;
            }
            case "btn_commit": {
                this.updateReportStatus(IntrReportStatusEnum.REPORTED.value);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"IntrMultiTabReportFillInPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4e0a\u62a5", "IntrMultiTabReportFillInPlugin_11", "fi-bcm-formplugin", "Report"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), ResManager.loadKDString((String)"\u4e0a\u62a5", (String)"IntrMultiTabReportFillInPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
                break;
            }
            case "btn_back": {
                this.updateReportStatus(IntrReportStatusEnum.REJECTED.value);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"IntrMultiTabReportFillInPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6253\u56de", "IntrMultiTabReportFillInPlugin_12", "fi-bcm-formplugin", "Call back"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), ResManager.loadKDString((String)"\u6253\u56de", (String)"IntrMultiTabReportFillInPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
                break;
            }
            case "btn_quit": {
                if (this.isModified()) {
                    this.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"IntrMultiTabReportFillInPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), QUIT_VIEW);
                    break;
                }
                this.getView().close();
                break;
            }
            case "btn_convert": {
                if (this.isModified()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u62a5\u8868\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"IntrMultiTabReportFillInPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.convertCurrency();
                break;
            }
            case "btn_genadjust": {
                this.showAdjustProcessView();
                break;
            }
            case "btn_reset": {
                if (IntrReportStatusEnum.REPORTED.value.equals(this.getReportTabInfoManager().getCurrSelectReportTabInfo().getStatus())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6253\u56de\u5e95\u7a3f\u751f\u6210\u7684\u5206\u5f55\u540e\u518d\u6267\u884c\u6574\u8868\u91cd\u7f6e\u3002", (String)"IntrMultiTabReportFillInPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u6e05\u7a7a\u5e95\u7a3f\u6570\u636e\u4e14\u5c06\u5e95\u7a3f\u7f16\u5236\u72b6\u6001\u91cd\u7f6e\u4e3a\u672a\u7f16\u5236\uff1f", (String)"IntrMultiTabReportFillInPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), RESET_TABLE);
                break;
            }
            case "btn_linkadjust": {
                if (this.isModified()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u62a5\u8868\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"IntrMultiTabReportFillInPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.linkAdjust();
                break;
            }
            case "btn_linkhistory": {
                if (this.isModified()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u62a5\u8868\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"IntrMultiTabReportFillInPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.linkHistory();
                break;
            }
            case "btn_rule": {
                IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
                DynamicObject report = IntrReportHelper.getReportInfo((Long)tab.getModelId(), (Long)tab.getTemplateId(), (Long)tab.getEntityId(), (Long)tab.getScenarioId(), (Long)tab.getYearId(), (Long)tab.getPeriodId(), (Long)tab.getCurrencyId());
                if (this.isModified() || report == null) {
                    this.autoFillFixValue();
                    this.actionSaveSpreadJson(null);
                }
                Map dimValueMap = MapInitHelper.ofMap((Object)PresetConstant.ENTITY_DIM, (Object)tab.getEntityId(), (Object)PresetConstant.SCENE_DIM, (Object)tab.getScenarioId(), (Object)PresetConstant.FY_DIM, (Object)tab.getYearId(), (Object)PresetConstant.PERIOD_DIM, (Object)tab.getPeriodId(), (Object)PresetConstant.CURRENCY_DIM, (Object)tab.getCurrencyId(), (Object)PresetConstant.PROCESS_DIM, (Object)MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)tab.getModelId()), (String)"ADJ").getId());
                PaperTemplateRuleHelper.execBizRule((Long)tab.getModelId(), (Long)tab.getTemplateId(), (Map)dimValueMap, (PaperTemplateRuleTypeEnum)PaperTemplateRuleTypeEnum.MANUAL, (BizRuleExecuteTypeEnum)BizRuleExecuteTypeEnum.INTR_ONLY, null);
                if (report == null) {
                    report = IntrReportHelper.getReportInfo((Long)tab.getModelId(), (Long)tab.getTemplateId(), (Long)tab.getEntityId(), (Long)tab.getScenarioId(), (Long)tab.getYearId(), (Long)tab.getPeriodId(), (Long)tab.getCurrencyId());
                }
                if (report != null) {
                    report.set("gentype", (Object)IntrRptGenTypeEnum.MANUAL.value);
                    report.set("spreadjson", null);
                    report.set("data", null);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
                }
                tab.changeRptStyle(null);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89c4\u5219\u5df2\u6267\u884c\u5b8c\u6210\uff0c\u53ef\u5728\u89c4\u5219\u6267\u884c\u60c5\u51b5\u4e2d\u67e5\u770b\u65e5\u5fd7\u3002", (String)"AbstractIntrReportPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.loadSheetData();
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6267\u884c\u89c4\u5219", "AbstractIntrReportPlugin_21", "fi-bcm-formplugin", "Execute Rule"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(tab, ResManager.loadKDString((String)"\u6267\u884c\u89c4\u5219", (String)"AbstractIntrReportPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
                break;
            }
        }
    }

    public void linkHistory() {
        Sheet sheet;
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        List<List<Cell>> rows = this.getSelectedRows(tab, sheet = this.getEffectiveSheet(this.getSpreadModel()));
        if (CollectionUtils.isEmpty(rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u6570\u636e\u884c\u3002", (String)"AbstractIntrReportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.isDCCurrency(tab).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u7b97\u5e01\u4e0d\u53ef\u4ee5\u8054\u67e5\u5386\u53f2\uff0c\u8054\u67e5\u5931\u8d25\u3002", (String)"AbstractIntrReportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List uniqueFields = IntrReportHelper.getUniqueFields(tab.getFileds(), (String)(tab.isCslReport() ? "1" : "0"));
        if (rows.size() * uniqueFields.size() > 2500) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u533a\u57df\u5185\u5355\u4e2a\u5355\u5143\u683c\u518d\u8054\u67e5\u3002", (String)"AbstractIntrReportPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList queryData = new ArrayList(16);
        for (List<Cell> row : rows) {
            HashMap<String, Object> item = new HashMap<String, Object>(16);
            for (IntrField field : uniqueFields) {
                Object cellValue = this.getCellValue(row.get(tab.getColIndex(field.getNumber())));
                if (Objects.equals(DataTypeEnum.DATETP.getOIndex(), field.getDataType())) {
                    if (cellValue != null) {
                        try {
                            cellValue = DateTimeUtils.parseStrDate((String)cellValue.toString());
                        }
                        catch (ParseException e) {
                            log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0cvalue=" + cellValue, (Throwable)e);
                        }
                    }
                } else if (cellValue == null) {
                    cellValue = " ";
                    if (IntrConstant.DB_DIGITAL_DATA_TYPE.contains(field.getDataType())) {
                        cellValue = BigDecimal.ZERO.stripTrailingZeros();
                    }
                }
                if (DataTypeEnum.TXT.getOIndex().equals(field.getDataType()) || DataTypeEnum.ENUMTP.getOIndex().equals(field.getDataType())) {
                    cellValue = cellValue == null ? " " : cellValue.toString();
                }
                item.put(field.getBoundField(), cellValue);
            }
            queryData.add(item);
        }
        DynamicObject sceneDy = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject yearDy = (DynamicObject)this.getModel().getValue("year");
        DynamicObject periodDy = (DynamicObject)this.getModel().getValue("period");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setFormId("bcm_intrhistory");
        fsp.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        fsp.setCustomParam("entity", (Object)tab.getEntityId());
        fsp.setCustomParam("scenario", (Object)sceneDy.getLong("id"));
        fsp.setCustomParam("year", (Object)(yearDy == null ? 0L : yearDy.getLong("id")));
        fsp.setCustomParam("period", (Object)(periodDy == null ? 0L : periodDy.getLong("id")));
        fsp.setCustomParam("currency", (Object)tab.getEntityCurrencyId());
        DynamicObject template = IntrTemplateHelper.getTemplateInfo((Long)this.getModelId(), (Long)tab.getTemplateId());
        fsp.setCustomParam("datamodel", (Object)template.getString("mergenode.number"));
        fsp.setCustomParam("queryData", (Object)this.toByteSerialized(queryData));
        fsp.setCustomParam("fields", (Object)this.toByteSerialized(tab.getFileds()));
        this.getView().showForm(fsp);
    }

    private List<List<Cell>> getSelectedRows(IntrReportTabInfo tab, Sheet sheet) {
        ArrayList<List<Cell>> result = new ArrayList<List<Cell>>(16);
        SpreadSelector selector = this.getSpreadSelector();
        int sellIndex = tab.getColIndex(IntrConstant.FIELD_ORG_NUMBER);
        int maxRowCount = this.getMaxRowCount(sheet);
        if (selector.getSelections() != null) {
            for (Map selection : selector.getSelections()) {
                Integer row = (Integer)selection.get("row");
                Integer rowCount = (Integer)selection.get("rowCount");
                Integer i = 0;
                while (i < rowCount) {
                    int rowIndex = row + i;
                    List rowData = sheet.getRow(rowIndex);
                    Object value = ((Cell)rowData.get(sellIndex)).getValue();
                    if (rowIndex >= (Integer)tab.getStartPoint().p1 && value != null && !kd.bos.util.StringUtils.isBlank((String)value.toString()) && rowIndex <= maxRowCount) {
                        result.add(rowData);
                    }
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            }
        } else {
            String rangePosition = selector.getRangePosition();
            if (kd.bos.util.StringUtils.isEmpty((String)rangePosition)) {
                return result;
            }
            RangeModel range = SpreadAreaUtil.getRangModel((String)rangePosition);
            for (int i = range.getY_start(); i <= range.getY_end(); ++i) {
                List rowData = sheet.getRow(i);
                Object value = ((Cell)rowData.get(sellIndex)).getValue();
                if (i < (Integer)tab.getStartPoint().p1 || value == null || kd.bos.util.StringUtils.isBlank((String)value.toString()) || i > maxRowCount) continue;
                result.add(rowData);
            }
        }
        return result;
    }

    protected void autoFillFixValue() {
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        List fixScope = tab.getDimScopeMap().entrySet().stream().filter(e -> ((IntrTplDimScope)e.getValue()).isFix()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(fixScope)) {
            return;
        }
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.setBatch(true);
        SpreadManager spreadModel = this.getSpreadModel();
        int sellIndex = tab.getColIndex(IntrConstant.FIELD_ORG_NUMBER);
        for (Map.Entry kv : fixScope) {
            IDNumberTreeNode node = IDNumberTreeNode.NotFoundTreeNode;
            if (((IntrTplDimScope)kv.getValue()).getEnumList() == null || ((IntrTplDimScope)kv.getValue()).getEnumList().isEmpty()) {
                Long fixValueId = (Long)((IntrTplDimScope)kv.getValue()).getMemberIds().iterator().next();
                String entityNumber = MemberReader.getEntityNumberByDim((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)((String)tab.getFieldByNumber((String)((String)kv.getKey())).getDimInfo().p2));
                node = MemberReader.findMemberById((long)this.getModelId(), (String)entityNumber, (Long)fixValueId);
            } else {
                Object enumValue = ((IntrTplDimScope)kv.getValue()).getEnumList().get(0);
                if (enumValue != null) {
                    node = new IDNumberTreeNode(Long.valueOf(1L), enumValue.toString(), "0", 1, 1, null, StorageTypeEnum.DEFAULT, true, null, Long.valueOf(0L), enumValue.toString());
                }
            }
            if (node.getId() == -1L) continue;
            Sheet sheet = this.getEffectiveSheet(spreadModel);
            for (int i = ((Integer)tab.getStartPoint().p1).intValue(); i < this.getMaxRowCount(sheet); ++i) {
                int colIndex;
                Cell cell;
                if (sheet.getCell(i, sellIndex).isNullValue() || !(cell = sheet.getCell(i, colIndex = tab.getColIndex((String)kv.getKey()))).isNullValue()) continue;
                String cellValue = IntrReportHelper.getDisplayName((String)node.getNumber(), (String)node.getName(), (IntrDimDisplayModeEnum)tab.getDisplayMode((String)kv.getKey()));
                cell.setValue((Object)cellValue);
                cell.setUserObject("number", (Object)node.getNumber());
                cell.setUserObject("name", (Object)node.getName());
                invoker.updataValue(i, colIndex, cellValue);
            }
        }
        this.cacheSpreadModel(spreadModel);
        invoker.startToInvoke();
    }

    public void linkAdjust() {
        super.checkPerm("btn_linkadjust", this.getView().getEntityId());
        SpreadSelector selector = this.getSpreadSelector();
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        int rowNumber = selector.getStartRow();
        int colNumber = selector.getStartCol();
        Sheet sheet = this.getEffectiveSheet(this.getSpreadModel());
        Cell selectCell = sheet.getCell(rowNumber, colNumber);
        if (rowNumber < (Integer)tab.getStartPoint().p1 || colNumber < (Integer)tab.getStartPoint().p2 || selectCell.getValue() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u533a\u57df\u5185\u6709\u6548\u7684\u5355\u5143\u683c\u518d\u8054\u67e5\u3002", (String)"IntrMultiTabReportFillInPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List row = sheet.getRow(rowNumber, true);
        DynamicObject dynamicObject = QueryIntrDataHelper.queryRowDataByCellValue((IntrMergeParam)this.getIntrParam(tab), (List)row, tab.getFieldIndexMap());
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u5206\u5f55\u6570\u636e\uff0c\u8054\u67e5\u5931\u8d25\u3002", (String)"IntrMultiTabReportFillInPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection mappings = QueryServiceHelper.query((String)"bcm_linkadjust_mapping", (String)"elim.id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("biztype", "=", (Object)LinkAdjustMappingEnum.INTER_TRADE_EXTDATA.getBizType()), new QFilter("linkid", "in", (Object)dynamicObject.getLong("id"))});
        if (mappings.size() > 0) {
            IFormView parentView;
            String modelNumber = MemberReader.findModelNumberById((Object)tab.getModelId());
            List idList = mappings.stream().map(e -> e.getLong("elim.id")).collect(Collectors.toList());
            IFormView mainPageView = this.getView().getMainView();
            for (parentView = this.getView().getParentView(); parentView != null && !parentView.getEntityId().equals("bcm_apphome"); parentView = parentView.getParentView()) {
            }
            Collections.sort(idList);
            String menuPageID = String.format("innertrade_to_rptadjust_%s", String.join((CharSequence)SPLIT_SYMBLE, mappings.stream().map(e -> e.getString("elim.id")).collect(Collectors.toList())).hashCode());
            if (mainPageView == null || mainPageView.getView(menuPageID) == null) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setPageId(menuPageID);
                parameter.setCustomParam("enterType", (Object)"intrView");
                parameter.setCustomParam("selectedOrgid", (Object)tab.getEntityId());
                parameter.setCustomParam("modelId", (Object)tab.getModelId());
                parameter.setCustomParam("scenarioId", (Object)tab.getScenarioId());
                parameter.setCustomParam("yearId", (Object)tab.getYearId());
                parameter.setCustomParam("perioId", (Object)tab.getPeriodId());
                parameter.setCustomParam("adjustIds", idList);
                parameter.setFormId("bcm_rptadjust_list");
                parameter.setCaption(String.format(ResManager.loadKDString((String)"\u8054\u67e5\uff1a%s", (String)"IntrMultiTabReportFillInPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MemberReader.findEntityMemberById((String)modelNumber, (Long)tab.getEntityId()).getName()));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
                if (parentView == null) {
                    this.getView().showForm(parameter);
                } else {
                    parameter.setParentPageId(parentView.getPageId());
                    parameter.setParentFormId(parentView.getEntityId());
                    parentView.showForm(parameter);
                    this.getView().sendFormAction(parentView);
                }
            } else {
                IFormView childFormView = mainPageView.getView(menuPageID);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u8054\u67e5\u5206\u5f55", "IntrMultiTabReportFillInPlugin_32", "fi-bcm-formplugin", "Joint Query Entries"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), ResManager.loadKDString((String)"\u8054\u67e5\u5206\u5f55", (String)"IntrMultiTabReportFillInPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u5206\u5f55\u6570\u636e\uff0c\u8054\u67e5\u5931\u8d25\u3002", (String)"IntrMultiTabReportFillInPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void linkReport() {
        super.checkPerm("btn_linkreport", this.getView().getEntityId());
        if (this.isModified()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e95\u7a3f\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u4fdd\u5b58\u540e\u518d\u6267\u884c\u8054\u67e5\u3002", (String)"IntrMultiTabReportFillInPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        SpreadSelector selector = this.getSpreadSelector();
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        int rowNumber = selector.getStartRow();
        int colNumber = selector.getStartCol();
        Sheet sheet = this.getEffectiveSheet(this.getSpreadModel());
        Cell selectCell = sheet.getCell(rowNumber, colNumber);
        if (rowNumber < (Integer)tab.getStartPoint().p1 || !tab.getFieldIndexMap().containsValue(colNumber) || selectCell.getValue() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u533a\u57df\u5185\u6709\u6548\u7684\u5355\u5143\u683c\u518d\u8054\u67e5\u3002", (String)"IntrMultiTabReportFillInPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List row = sheet.getRow(rowNumber, true);
        QFilter qFilter = new QFilter("model", "=", (Object)tab.getModelId());
        qFilter.and("id", "=", (Object)tab.getTemplateId());
        DynamicObject intrTemplate = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"id,seller.id,purchaser.id,mergenode.id", (QFilter[])new QFilter[]{qFilter});
        if (intrTemplate == null) {
            return;
        }
        long extModelId = 0L;
        String entityNum = "";
        String icNum = "";
        Optional<Map.Entry> head = tab.getFieldIndexMap().entrySet().stream().filter(e -> ((Integer)e.getValue()).equals(selectCell.getCol())).findFirst();
        if (!head.isPresent()) {
            return;
        }
        Cell entityCell = (Cell)row.get(tab.getColIndex(IntrConstant.FIELD_ORG_NUMBER));
        Cell icCell = (Cell)row.get(tab.getColIndex(IntrConstant.FIELD_IC_NUMBER));
        Cell typeCell = (Cell)row.get(tab.getColIndex("INTR_001"));
        List buyerFields = QueryIntrDataHelper.queryBuyerFields((Long)tab.getTemplateId());
        List sellerFields = QueryIntrDataHelper.querySellerFields((Long)tab.getTemplateId());
        if (buyerFields.stream().anyMatch(e -> Objects.equals(e.getNumber(), ((Map.Entry)head.get()).getKey()))) {
            extModelId = intrTemplate.getLong("purchaser.id");
            entityNum = (String)icCell.getUserObject("number");
            icNum = (String)entityCell.getUserObject("number");
        } else if (sellerFields.stream().anyMatch(e -> Objects.equals(e.getNumber(), ((Map.Entry)head.get()).getKey()))) {
            extModelId = intrTemplate.getLong("seller.id");
            entityNum = (String)entityCell.getUserObject("number");
            icNum = (String)icCell.getUserObject("number");
        }
        if (extModelId != 0L) {
            String modelNumber = MemberReader.findModelNumberById((Object)tab.getModelId());
            HashMap<String, String> param = new HashMap<String, String>(16);
            param.put("Entity", entityNum);
            param.put("InternalCompany", icNum);
            param.put("Scenario", MemberReader.findScenaMemberById((String)modelNumber, (Long)tab.getScenarioId()).getNumber());
            param.put("Year", MemberReader.findFyMemberById((String)modelNumber, (Long)tab.getYearId()).getNumber());
            param.put("Period", MemberReader.findPeriodMemberById((String)modelNumber, (Long)tab.getPeriodId()).getNumber());
            DynamicObject currencyOrg = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)MemberReader.findEntityMemberByNum((String)modelNumber, (String)entityNum).getId(), (Long)tab.getYearId(), (Long)tab.getPeriodId());
            param.put("Currency", currencyOrg.getString("number"));
            param.put("INTR_001", (String)typeCell.getValue());
            Map linkParam = LinkQueryUtil.getLinkParam((long)tab.getModelId(), param, (Long)extModelId);
            if (linkParam == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u5143\u683c\u672a\u627e\u5230\u5339\u914d\u7684\u62a5\u8868\uff0c\u8054\u67e5\u5931\u8d25\u3002", (String)"IntrMultiTabReportFillInPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            new FormulaLinkShowForm(this.getView(), linkParam, true).showForm();
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u8054\u67e5\u62a5\u8868", "IntrMultiTabReportFillInPlugin_29", "fi-bcm-formplugin", "Joint Query Report"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), ResManager.loadKDString((String)"\u8054\u67e5\u62a5\u8868", (String)"IntrMultiTabReportFillInPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u5143\u683c\u7684\u6210\u5458\u4e0d\u662f\u62a5\u8868\u9879\u76ee\u6210\u5458\uff0c\u65e0\u6cd5\u8054\u67e5\u5230\u62a5\u8868\u3002", (String)"IntrMultiTabReportFillInPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkOrgPeriodOpen() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
        DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject year = (DynamicObject)this.getModel().getValue("year");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (LockScopeServiceHelper.isExistArchiving((long)model.getLong("id"), (String)scenario.getString("number"), (String)year.getString("number"), (String)period.getString("number"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u8d22\u5e74\u671f\u95f4%1$s_%2$s_%3$s\u7684\u5206\u9636\u6bb5\u9501\u5b9a\u5df2\u5728\u667a\u80fd\u5408\u5e76\u5f52\u6863\uff0c\u8bf7\u53cd\u5f52\u6863\u540e\u518d\u64cd\u4f5c\u3002", (String)"IntrReportListPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]), scenario.getString("number"), year.getString("number"), period.getString("number")));
        }
        boolean periodManage = ConfigServiceHelper.getBoolParam((Long)model.getLong("id"), (String)"CM012");
        if (periodManage) {
            Pair periodStatusPair = PeriodSettingHelper.batchSelectPeriodStatusOpenbyUntreated((long)model.getLong("id"), (String)entity.getString("number"), (long)scenario.getLong("id"), (long)year.getLong("id"), (long)period.getLong("id"));
            if (!((Boolean)periodStatusPair.p1).booleanValue()) {
                this.getView().hideLoading();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\"%s\"\u6ca1\u6709\u6253\u5f00\u6570\u636e\u671f\u95f4\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"IntrMultiTabReportFillInPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entity.getString("name")));
            }
        }
    }

    private void showAdjustProcessView() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_intradjustprocess");
        param.getOpenStyle().setShowType(ShowType.Modal);
        if (this.getView().getParentView() != null) {
            param.setRootPageId(this.getView().getParentView().getPageId());
        }
        param.setCaption(ResManager.loadKDString((String)"\u751f\u6210\u5206\u5f55", (String)"IntrReportListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "generate_adjust");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private void generateAdjust(List<Long> processIds) {
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        this.dispatchJob(Lists.newArrayList((Object[])new Long[]{tab.getReportId()}), processIds, null);
    }

    private void dispatchJob(List<Long> reportIds, List<Long> processIds, String message) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u751f\u6210\u5206\u5f55", (String)"IntrReportListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.fi.bcm.business.innertrade.adjust.IntrAdjustTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reportIds", this.toByteSerialized(reportIds));
        params.put("processIds", this.toByteSerialized(processIds));
        params.put("isFormList", true);
        params.put("message", message);
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByUserId(this.getUserId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(this.getView().getPageId());
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)this.getView());
    }

    protected void convertCurrency() {
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_reportconvert");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setParentFormId(this.getView().getEntityId());
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)tab.getModelId());
        formShowParameter.setCustomParam("bcm_scenemembertree", (Object)tab.getScenarioId());
        formShowParameter.setCustomParam("bcm_fymembertree", (Object)tab.getYearId());
        formShowParameter.setCustomParam("bcm_periodmembertree", (Object)tab.getPeriodId());
        formShowParameter.setCustomParam("bcm_entitymembertree", (Object)tab.getEntityId());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "convert_confirm"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object data = evt.getReturnData();
        if ("convert_confirm".equals(actionId) && data != null) {
            IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
            IntrMergeParam imp = this.getIntrParam(tab);
            ReportConvertParam param = (ReportConvertParam)data;
            List cvtPaths = param.getCvtPath();
            if ((cvtPaths = ConvertServiceHelper.getCurrectCvtPath((List)cvtPaths, (long)((Long)imp.getEntity().p1), (Long)((Long)imp.getYear().p1), (Long)((Long)imp.getPeriod().p1))).size() == 2 && ((String)((Pair)cvtPaths.get((int)0)).p2).equals(((Pair)cvtPaths.get((int)1)).p2)) {
                return;
            }
            try {
                ExtConvertServiceHelper.convertIntrMergeData((Pair)((Pair)cvtPaths.get(0)), (Pair)((Pair)cvtPaths.get(1)), (IntrMergeParam)imp);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6298\u7b97\u6210\u529f\u3002", (String)"AbstractIntrReportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5185\u90e8\u4ea4\u6613\u5e95\u7a3f\u6298\u7b97", "IntrMultiTabReportFillInPlugin_20", "fi-bcm-formplugin", "Internal transaction"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), ResManager.loadKDString((String)"\u6298\u7b97", (String)"IntrMultiTabReportFillInPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6298\u7b97\u5931\u8d25\uff1a%s", (String)"AbstractIntrReportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()));
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5185\u90e8\u4ea4\u6613\u5e95\u7a3f\u6298\u7b97", "IntrMultiTabReportFillInPlugin_20", "fi-bcm-formplugin", "Internal transaction"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), ResManager.loadKDString((String)"\u6298\u7b97", (String)"IntrMultiTabReportFillInPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), false)));
            }
        }
        if ("generate_adjust".equals(actionId) && data != null) {
            this.generateAdjust((List)data);
        }
        if ("cellF7".equals(actionId) && data instanceof ListSelectedRowCollection) {
            this.setModified(true);
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)data;
            SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
            invoker.setBatch(Boolean.TRUE);
            SpreadManager spreadModel = this.getSpreadModel();
            int row = this.getF7SelectRow();
            int col = this.getF7SelectCol();
            int maxRowCount = this.getMaxRowCount(this.getEffectiveSheet(spreadModel));
            int maxEffectRow = Math.min(selectedRows.size(), maxRowCount - row);
            IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
            IntrField field = tab.getField(col);
            IntrDimDisplayModeEnum dimDisplayMode = tab.getDisplayMode(field.getNumber());
            for (int i = 0; i < maxEffectRow; ++i) {
                ListSelectedRow listSelectedRow = selectedRows.get(i);
                Cell cell = this.getEffectiveSheet(spreadModel).getCell(row + i, col);
                cell.setUserObject("number", (Object)listSelectedRow.getNumber());
                cell.setUserObject("name", (Object)listSelectedRow.getName());
                String cellValue = IntrReportHelper.getDisplayName((String)listSelectedRow.getNumber(), (String)listSelectedRow.getName(), (IntrDimDisplayModeEnum)dimDisplayMode);
                cell.setValue((Object)cellValue);
                invoker.updataValue(row + i, col, cellValue);
            }
            invoker.startToInvoke();
            this.cacheSpreadModel(spreadModel);
        }
        if ("taskcloseback".equals(actionId)) {
            this.taskCompleteCallback(evt);
        }
    }

    public void taskCompleteCallback(ClosedCallBackEvent e) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Object returnData;
        Map result;
        if (e.getReturnData() != null && (result = (Map)(returnData = e.getReturnData())).containsKey("taskinfo") && kd.bos.util.StringUtils.isNotEmpty((String)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            JSONObject dataObj = (JSONObject)JSONObject.parse((String)data);
            boolean isSuccess = dataObj.getBoolean("data");
            String message = (String)dataObj.get((Object)"message");
            if (isSuccess) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u5206\u5f55\u7ed3\u679c", (String)"IntrReportListPlugin_43", (String)"fi-bcm-formplugin", (Object[])new Object[0]), message, MessageTypes.Default);
            } else {
                this.getView().showErrorNotification(message);
            }
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u751f\u6210\u5206\u5f55", "IntrReportListPlugin_16", "fi-bcm-formplugin", "Generate Entries"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescriptionMsg(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), message)));
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        if (this.isModified() && this.getPageCache().get(CONFIRM_CLOSE) == null) {
            e.setCancel(true);
            this.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"IntrMultiTabReportFillInPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), QUIT_VIEW);
        } else {
            this.getPageCache().remove(CONFIRM_CLOSE);
        }
    }

    private void updateReportStatus(String status) {
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        IntrReportHelper.updateStatus((Long)RequestContext.get().getCurrUserId(), (Long)tab.getReportId(), (String)status, (String)"1");
        tab.setStatus(status);
        this.cacherReportTabManager();
        if (IntrReportStatusEnum.REJECTED.value.equals(tab.getStatus()) || IntrReportStatusEnum.EDITING.value.equals(tab.getStatus())) {
            Pair<Integer, Integer> startPoint = tab.getStartPoint();
            int rowSize = this.getMaxRowCount(this.getEffectiveSheet(this.getSpreadModel())) - (Integer)startPoint.p1;
            SpreadEasyInvoker sei = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
            sei.unlockCell((Integer)startPoint.p1, (Integer)startPoint.p2, rowSize, tab.getColSize());
        }
        this.updateButtonAndStyle(tab);
    }

    protected void updateButtonAndStyle(IntrReportTabInfo tab) {
        String status = tab.getStatus();
        boolean lockTable = false;
        if (this.isDCCurrency(tab).booleanValue()) {
            if (IntrReportStatusEnum.EDITING.value.equals(status)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_cancel", "btn_commit", "btn_back", "btn_genadjust"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"btn_save", "btn_complete", "btn_caculate", "btn_reset", "btn_convert", "btn_linkreport", "btn_linkadjust", "btn_smartnotice", "btn_rule"});
            }
            if (IntrReportStatusEnum.COMPLETE.value.equals(status)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save", "btn_complete", "btn_back", "btn_genadjust", "btn_caculate", "btn_reset", "btn_rule"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"btn_cancel", "btn_commit", "btn_convert", "btn_linkreport", "btn_linkadjust", "btn_smartnotice"});
                lockTable = true;
            }
            if (IntrReportStatusEnum.REPORTED.value.equals(status)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save", "btn_complete", "btn_cancel", "btn_commit", "btn_caculate", "btn_reset", "btn_rule"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"btn_back", "btn_genadjust", "btn_convert", "btn_linkreport", "btn_linkadjust", "btn_smartnotice"});
                lockTable = true;
            }
            if (IntrReportStatusEnum.REJECTED.value.equals(status)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_back", "btn_genadjust", "btn_cancel", "btn_commit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"btn_save", "btn_complete", "btn_caculate", "btn_reset", "btn_convert", "btn_linkreport", "btn_linkadjust", "btn_smartnotice", "btn_rule"});
            }
        } else {
            lockTable = true;
            for (String btn : READONLY_CHECK_BTNS) {
                this.getView().setVisible(Boolean.FALSE, new String[]{btn});
            }
        }
        if (tab.isReadOnly() || tab.isLock()) {
            for (String btn : READONLY_CHECK_BTNS) {
                this.getView().setEnable(Boolean.FALSE, new String[]{btn});
            }
            lockTable = true;
        } else {
            for (String btn : READONLY_CHECK_BTNS) {
                this.getView().setEnable(Boolean.TRUE, new String[]{btn});
            }
        }
        SpreadClientInvoker.invokeSetWorkbookOptions(this.getClientViewProxy(), this.getSpreadKey(), MapInitHelper.ofMap((Object)SpreadProperties.SetWorkbookOptions.AllowCopyPasteExcelStyle.k(), (Object)false));
        this.handleMenuItem(false);
        this.updateStyle(lockTable);
        this.handleMenuItem(lockTable);
    }

    protected abstract void updateStyle(boolean var1);

    protected abstract void handleMenuItem(boolean var1);

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"hidepanel"});
        String postmanSerial = (String)this.getFormCustomParam("reportpostman");
        if (kd.bos.util.StringUtils.isEmpty((String)postmanSerial)) {
            throw new KDBizException("not found ReportPostman Info!");
        }
        IntrReportPostmanByTemplate postman = (IntrReportPostmanByTemplate)this.deSerializedBytes(postmanSerial);
        this.getModel().setValue("model", postman.getModelPK());
        this.registSpreadShortcutKey();
        this.hideSpreadToolbar();
        this.initReportTabEnv(postman);
    }

    private void hideSpreadToolbar() {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.setBatch(true);
        invoker.lockAllToolbarItems(true, SpreadProperties.ToolbarItemNamesEnum.DeleteRowAndCol, SpreadProperties.ToolbarItemNamesEnum.InsertRowAndCol, SpreadProperties.ToolbarItemNamesEnum.LockCells, SpreadProperties.ToolbarItemNamesEnum.ClearCells, SpreadProperties.ToolbarItemNamesEnum.CellFormat, SpreadProperties.ToolbarItemNamesEnum.MergeCells, SpreadProperties.ToolbarItemNamesEnum.DataValidation);
        invoker.startToInvoke();
    }

    private void registSpreadShortcutKey() {
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "releaseLock", "R", true, true, true);
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "displayInfo", "U", true, true, true);
    }

    public void releaseLock() {
        this.releaseOldMutexLock(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), true);
    }

    public void displayInfo() {
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        int rowIndex = this.getSelectorStartRow();
        Sheet sheet = this.getEffectiveSheet(this.getSpreadModel());
        List row = sheet.getRow(rowIndex, true);
        Object value = ((Cell)row.get(tab.getColIndex(IntrConstant.FIELD_ORG_NUMBER))).getValue();
        if (rowIndex < (Integer)tab.getStartPoint().p1 || rowIndex > this.getMaxRowCount(sheet) || value == null || kd.bos.util.StringUtils.isBlank((String)value.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u6570\u636e\u884c\u3002", (String)"AbstractIntrReportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        IntrMergeParam intrParam = this.getIntrParam(tab);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_intrreportinfo");
        param.getOpenStyle().setShowType(ShowType.Modal);
        if (this.getView().getParentView() != null) {
            param.setRootPageId(this.getView().getParentView().getPageId());
        }
        param.setCaption(String.format(ResManager.loadKDString((String)"\u5e95\u7a3f\u4fe1\u606f-\u7b2c%s\u884c", (String)"AbstractIntrReportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), rowIndex + 1));
        param.setCustomParam("isClsReport", (Object)this.isClsReport());
        String uniqueKeyStr = "";
        if (this.isClsReport()) {
            List<IntrField> uniqueFields = tab.getFileds().stream().filter(IntrField::isUnique).collect(Collectors.toList());
            uniqueKeyStr = this.getUniqueKey(tab, uniqueFields, row, ",");
            param.setCustomParam("uniqueFields", (Object)uniqueFields.stream().map(e -> String.format("%s|%s", e.getNumber(), e.getName())).collect(Collectors.joining(",")));
        } else {
            IntrMergeContext context = new IntrMergeContext(intrParam);
            param.setCustomParam("intrParam", (Object)ObjectSerialUtil.toByteSerialized((Object)intrParam));
            uniqueKeyStr = this.getUniqueKey(tab, context.getBuyerUniqueKeys().stream().map(e -> (IntrField)context.getBuyerFieldMap().get(e)).collect(Collectors.toList()), row, ",");
        }
        param.setCustomParam("uniqueKey", (Object)uniqueKeyStr);
        this.getView().showForm(param);
    }

    protected String getUniqueKey(IntrReportTabInfo tab, List<IntrField> uniqueFields, List<Cell> row) {
        return this.getUniqueKey(tab, uniqueFields, row, SPLIT_SYMBLE);
    }

    protected String getUniqueKey(IntrReportTabInfo tab, List<IntrField> uniqueFields, List<Cell> row, String joinSymble) {
        ArrayList<String> keyList = new ArrayList<String>(16);
        for (IntrField intrField : uniqueFields) {
            Object cellValue = this.getCellValue(row.get(tab.getColIndex(intrField.getNumber())));
            if (cellValue instanceof BigDecimal) {
                cellValue = ((BigDecimal)cellValue).stripTrailingZeros();
            }
            if (cellValue == null && intrField != null && IntrConstant.DB_DIGITAL_DATA_TYPE.contains(intrField.getDataType())) {
                cellValue = BigDecimal.ZERO.stripTrailingZeros();
            }
            keyList.add(cellValue == null ? "" : cellValue.toString());
        }
        return String.join((CharSequence)joinSymble, keyList);
    }

    private void initTabLock(IntrReportTabInfo tab) {
        if (!ConfigServiceHelper.getGlobalBoolParam((String)"P001")) {
            tab.setLock(Boolean.FALSE);
            return;
        }
        String mutexKey = this.getMutexKey(tab);
        String lockStatus = this.getPageCache().get(mutexKey);
        if (StringUtils.isBlank((CharSequence)lockStatus)) {
            tab.setLock(!this.requestMutex(mutexKey));
            return;
        }
        if (LOSE_LOCK.equals(lockStatus)) {
            tab.setLock(Boolean.TRUE);
        }
        if (HAS_LOCK.equals(lockStatus)) {
            tab.setLock(Boolean.FALSE);
        }
    }

    private boolean requestMutex(String mutexKey) {
        String opDesc = ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u5e95\u7a3f\u586b\u62a5", (String)"IntrMultiTabReportFillInPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        boolean mutex = MutexServiceHelper.request((String)mutexKey, (String)"bcm_intrreportentity", (String)opDesc);
        if (!mutex) {
            this.getPageCache().put(mutexKey, LOSE_LOCK);
            Map lockInfo = MutexServiceHelper.getLockInfo((String)mutexKey, (String)"bcm_intrreportentity", (String)opDesc);
            if (lockInfo != null) {
                String tips = String.format(ResManager.loadKDString((String)"\u5df2\u88ab %s \u9501\u5b9a\uff0c\u53ea\u80fd\u67e5\u770b\u3002", (String)"IntrMultiTabReportFillInPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), UserServiceHelper.getUsernameByUserid(lockInfo.get("userid")));
                this.getView().showTipNotification(tips, Integer.valueOf(3000));
            }
        } else {
            this.getPageCache().put(mutexKey, HAS_LOCK);
        }
        return mutex;
    }

    private String getMutexKey(IntrReportTabInfo tab) {
        Long currencyId = tab.getCurrencyId();
        String currency = IntrReportHelper.getCurrencyDyn((Long)tab.getModelId(), (Long)currencyId).getString("number");
        if ("DC".equals(currency) || "EC".equals(currency)) {
            currencyId = tab.getEntityCurrencyId();
        }
        return encrypt.ecode(String.format("%s_%s_%s_%s_%s_%s", tab.getEntityId(), tab.getTemplateId(), tab.getScenarioId(), tab.getYearId(), tab.getPeriodId(), currencyId));
    }

    public void pageRelease(EventObject e) {
        this.getReportTabInfoManager().getTabs().forEach(item -> this.releaseOldMutexLock((IntrReportTabInfo)item, false));
    }

    private void releaseOldMutexLock(IntrReportTabInfo tab, boolean isForceRelease) {
        String mutexKey = this.getMutexKey(tab);
        String lockStatus = this.getPageCache().get(mutexKey);
        if (isForceRelease || HAS_LOCK.equals(lockStatus)) {
            String opDesc = ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u5e95\u7a3f\u586b\u62a5", (String)"IntrMultiTabReportFillInPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            MutexServiceHelper.release((String)mutexKey, (String)"bcm_intrreportentity", (String)opDesc);
        }
        this.getPageCache().remove(mutexKey);
    }

    protected void reportTabSelected(TabSelectEvent evt) {
        String targetKey = evt.getTabKey();
        if (this.isModified()) {
            this.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"IntrMultiTabReportFillInPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.format("%s,%s", SWITCH_TAB, targetKey));
        } else {
            this.getReportTabInfoManager().setSelectReportTabInfo(targetKey);
            IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
            this.enableYearPeriod(tab);
            this.cacherReportTabManager();
            this.loadReport();
        }
    }

    private void loadReport() {
        IntrReportTabInfo irt = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        this.getModel().beginInit();
        this.getModel().setValue("entity", (Object)irt.getEntityId());
        this.getModel().setValue("scenario", (Object)irt.getScenarioId());
        this.getModel().setValue("year", (Object)irt.getYearId());
        this.getModel().setValue("period", (Object)irt.getPeriodId());
        this.getModel().setValue("currency", (Object)irt.getCurrencyId());
        this.getModel().endInit();
        this.getView().updateView();
        this.loadSheetData();
    }

    private void loadSheetData() {
        DynamicObject ts;
        if (!this.validateCondition()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u641c\u7d22\u6761\u4ef6\u3002", (String)"IntrMultiTabReportFillInPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\u3002", (String)"IntrMultiTabReportFillInPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        boolean refreshFromTmpl = Boolean.FALSE;
        boolean isSmartMergeData = Boolean.FALSE;
        Boolean isIntegrate = Boolean.FALSE;
        SpreadManager sm = null;
        String spreadJson = null;
        DynamicObject report = IntrReportHelper.getReportInfo((Long)tab.getModelId(), (Long)tab.getTemplateId(), (Long)tab.getEntityId(), (Long)tab.getScenarioId(), (Long)tab.getYearId(), (Long)tab.getPeriodId(), (Long)tab.getCurrencyId());
        if (report != null) {
            if (kd.bos.util.StringUtils.isEmpty((String)report.getString("spreadjson")) || kd.bos.util.StringUtils.isEmpty((String)report.getString("data"))) {
                ts = IntrTemplateHelper.getRightVerionTemplate((Long)tab.getModelId(), (Long)tab.getYearId(), (Long)tab.getPeriodId(), (Long)tab.getTemplateId());
                tab.changeTemplate(ts.getLong("id"), false);
                sm = JsonSerializerUtil.toSpreadManager((String)ts.getString("data"));
                IntrTemplateHelper.repairTableRow((SpreadManager)sm);
                spreadJson = ts.getString("spreadjson");
                isSmartMergeData = Boolean.TRUE;
                refreshFromTmpl = Boolean.TRUE;
            } else {
                sm = JsonSerializerUtil.toSpreadManager((String)report.getString("data"));
                if (this.checkShowTip(tab, sm, report.getDate("createtime"))) {
                    this.getView().showTipNotification(tab.isCslReport() ? ResManager.loadKDString((String)"\u5e95\u7a3f\u6a21\u677f\u5df2\u66f4\u65b0\uff0c\u5efa\u8bae\u6574\u8868\u91cd\u7f6e\u6216\u516c\u5f0f\u8ba1\u7b97\u4ee5\u83b7\u53d6\u6700\u65b0\u6a21\u677f\u3002", (String)"AbstractIntrReportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e95\u7a3f\u6a21\u677f\u5df2\u66f4\u65b0\uff0c\u5efa\u8bae\u6574\u8868\u91cd\u7f6e\u6216\u751f\u6210\u5e95\u7a3f\u4ee5\u83b7\u53d6\u6700\u65b0\u6a21\u677f\u3002", (String)"AbstractIntrReportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if ((spreadJson = report.getString("spreadjson")).startsWith("#MERGE#")) {
                    spreadJson = StringUtils.substring((String)spreadJson, (int)"#MERGE#".length());
                    isSmartMergeData = true;
                }
            }
            tab.changeReport(report.getLong("id"), report.getString("reportstatus"));
        } else {
            ts = IntrTemplateHelper.getRightVerionTemplate((Long)tab.getModelId(), (Long)tab.getYearId(), (Long)tab.getPeriodId(), (Long)tab.getTemplateId());
            tab.changeTemplate(ts.getLong("id"), false);
            sm = JsonSerializerUtil.toSpreadManager((String)ts.getString("data"));
            IntrTemplateHelper.repairTableRow((SpreadManager)sm);
            spreadJson = ts.getString("spreadjson");
            if (this.isDCCurrency(tab).booleanValue()) {
                tab.setStatus(IntrReportStatusEnum.EDITING.value);
                isIntegrate = QueryIntrDataHelper.isExistIntrData((IntrMergeParam)this.getIntrParam(tab));
            }
            refreshFromTmpl = Boolean.TRUE;
        }
        tab.changeRptStyle(sm);
        this.cacherReportTabManager();
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), SPREAD_KEY, spreadJson);
        if (refreshFromTmpl) {
            this.caculateRptInfoFormula(tab, sm);
            this.updateTemplateConfig(tab, sm);
        }
        this.cacheSpreadModel(sm);
        if (!this.isDCCurrency(tab).booleanValue() || isSmartMergeData || isIntegrate.booleanValue()) {
            SpreadManager spreadModel;
            IntrTable table = QueryIntrDataHelper.queryIntrDataConvertName((IntrMergeParam)this.getIntrParam(tab));
            if (isIntegrate.booleanValue()) {
                this.initRowNumber(tab, table);
            }
            if ((spreadModel = this.getSpreadModel()) != null) {
                this.updateSpread(tab, spreadModel, table);
            }
            this.cacheSpreadModel(spreadModel);
        }
        this.updateButtonAndStyle(tab);
        this.getView().hideLoading();
    }

    private boolean checkShowTip(IntrReportTabInfo tab, SpreadManager sm, Date createtime) {
        Date reportDate = (Date)sm.getBook().getSheet(0).getUserObject("intr_show_tip_date");
        if (reportDate != null && tab.getShowTipDate() != null) {
            return reportDate.before(tab.getShowTipDate());
        }
        if (tab.getShowTipDate() != null && createtime != null) {
            return createtime.before(tab.getShowTipDate());
        }
        return false;
    }

    private void initRowNumber(IntrReportTabInfo tab, IntrTable table) {
        for (int i = 0; i < table.getRows().size(); ++i) {
            IntrRow row = (IntrRow)table.getRows().get(i);
            if (row.getRowNumber() != null) {
                return;
            }
            row.setRowNumber(Integer.valueOf((Integer)tab.getStartPoint().p1 + i));
        }
    }

    protected abstract void updateTemplateConfig(IntrReportTabInfo var1, SpreadManager var2);

    protected void caculateRptInfoFormula(IntrReportTabInfo tab, SpreadManager sm) {
        IntrMergeParam param = this.getIntrParam(tab);
        Pair realCurrency = IntrReportHelper.getRealCurrencyId((Long)((Long)param.getModel().p1), (Long)((Long)param.getEntity().p1), (Long)((Long)param.getCurrency().p1));
        CalContext calContext = new CalContext(param.getModelNumber(), (String)param.getEntity().p2, (String)param.getYear().p2, (String)param.getPeriod().p2, (String)param.getScenario().p2, (String)realCurrency.p2);
        CalculateService calculateService = new CalculateService((ICalContext)calContext);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.setBatch(true);
        Sheet sheet = this.getEffectiveSheet(sm);
        for (int i = 0; i < sheet.getMaxRowCount(); ++i) {
            for (int j = 0; j < sheet.getMaxColumnCount(); ++j) {
                Cell cell = sheet.getCell(i, j);
                if (!cell.hasFormula()) continue;
                Object value = calculateService.singleCalculate(cell.getFormula());
                cell.setValue(value);
                invoker.setFormula(i, j, null);
                invoker.updataValue(i, j, value);
            }
        }
        invoker.startToInvoke();
    }

    private Boolean isDCCurrency(IntrReportTabInfo tab) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        return "DC".equals(currency.getString("number")) || "EC".equals(currency.getString("number")) || tab.getEntityCurrencyId().equals(currency.getLong("id"));
    }

    protected void updateTab(IntrReportTabInfo tab, SpreadManager sm, IntrMergeResult result) {
        if (result.isSuccess()) {
            this.caculateRptInfoFormula(tab, sm);
            this.updateSpread(tab, sm, result.getTable());
            this.cacheSpreadModel(sm);
        } else {
            this.getView().showErrorNotification(result.getMessage());
        }
    }

    protected void updateSpread(IntrReportTabInfo tab, SpreadManager sm, IntrTable table) {
        Pair<Integer, Integer> startPoint = tab.getStartPoint();
        this.setModified(true);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.setBatch(true);
        Sheet sheet = this.getEffectiveSheet(sm);
        List head = table.getHead();
        int nullRowNumIndex = (Integer)startPoint.p1;
        if (this.isClsReport()) {
            int totalRow = this.getMaxRowCount(sheet);
            int noNumberCount = 0;
            int maxRowNumber = (Integer)startPoint.p1 - 1;
            for (IntrRow row : table.getRows()) {
                if (row.getRowNumber() != null) {
                    if (row.getRowNumber() <= maxRowNumber) continue;
                    maxRowNumber = row.getRowNumber();
                    continue;
                }
                ++noNumberCount;
            }
            nullRowNumIndex = maxRowNumber + 1;
            totalRow = Math.max(maxRowNumber + noNumberCount + 1, totalRow) + 1;
            this.insertRows(sheet, (Integer)tab.getStartPoint().p1, totalRow);
        } else {
            SpreadClientInvoker.invokeBatchDelRow(this.getClientViewProxy(), this.getSpreadKey(), (Integer)tab.getStartPoint().p1 + 1, table.getRows().size());
            SpreadClientInvoker.invokeBatchInsertRow(this.getClientViewProxy(), this.getSpreadKey(), (Integer)tab.getStartPoint().p1, table.getRows().size() - 1, true);
            if ((Integer)tab.getStartPoint().p1 + table.getRows().size() >= IntrConstant.TMP_INIT_ROW_COUNT) {
                SpreadClientInvoker.appendRows(this.getClientViewProxy(), this.getSpreadKey(), (Integer)tab.getStartPoint().p1 + table.getRows().size(), 1);
            }
        }
        for (int i = 0; i < table.getRows().size(); ++i) {
            IntrRow row = (IntrRow)table.getRows().get(i);
            Map rowData = row.getData();
            int rowInx = (Integer)startPoint.p1 + i;
            if (this.isClsReport()) {
                rowInx = row.getRowNumber() == null ? nullRowNumIndex++ : row.getRowNumber();
            }
            for (IntrField intrField : head) {
                Object fieldValue = rowData.get(intrField.getNumber());
                int colInx = tab.getColIndex(intrField.getNumber());
                Cell cell = sheet.getCell(rowInx, colInx);
                if (!this.isClsReport()) {
                    cell.clearAllUserObject();
                }
                Object cellValue = fieldValue;
                if (fieldValue != null) {
                    if (fieldValue instanceof Pair) {
                        Pair pair = (Pair)fieldValue;
                        cellValue = IntrReportHelper.getDisplayName((String)pair.p1.toString(), (String)pair.p2.toString(), (IntrDimDisplayModeEnum)tab.getDisplayMode(intrField.getNumber()));
                        cell.setValue(cellValue);
                        cell.setUserObject("number", pair.p1);
                        cell.setUserObject("name", pair.p2);
                    } else if (fieldValue instanceof Date) {
                        cellValue = DateTimeUtils.getOADateStr((String)fieldValue.toString(), (String)fieldValue.toString());
                        cell.setValue(cellValue);
                    } else {
                        cell.setValue(fieldValue);
                    }
                }
                invoker.updataValue(rowInx, colInx, cellValue);
            }
        }
        this.afterUpdateSpread(tab, table, invoker, sheet, head);
        invoker.startToInvoke();
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        this.setModified(true);
        int row = arg.getR();
        int col = arg.getC();
        SpreadManager spreadModel = this.getSpreadModel();
        Cell cell = this.getEffectiveSheet(spreadModel).getCell(row, col);
        String cellValue = arg.getName();
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        IntrField field = tab.getField(col);
        if ("F7".equals(field.getShowType())) {
            cellValue = IntrReportHelper.getDisplayName((String)arg.getNumber(), (String)arg.getName(), (IntrDimDisplayModeEnum)tab.getDisplayMode(field.getNumber()));
            cell.setUserObject("number", (Object)arg.getNumber());
            cell.setUserObject("name", (Object)arg.getName());
        }
        cell.setValue((Object)cellValue);
        this.cacheSpreadModel(spreadModel);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.updataValue(row, col, cellValue);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        if (this.getPageCache().get("spreadF7Click") != null) {
            event.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cellF7"));
            this.getPageCache().remove("spreadF7Click");
        } else if (this.isModified() && "getLookUpList".equals(event.getSourceMethod())) {
            event.setCancel(true);
            this.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"IntrMultiTabReportFillInPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), CHANGE_CONDITION);
        }
        if (DimTypesEnum.CURRENCY.getNumber().equalsIgnoreCase(event.getProperty().getName())) {
            event.setCustomQFilters((List)Lists.newArrayList((Object[])new QFilter[]{new QFilter("number", "not in", (Object)IntrConstant.CURRENCYNUM).and(new QFilter("isleaf", "=", (Object)Boolean.TRUE))}));
        }
    }

    @Override
    public void spreadF7Click(int row, int col) {
        super.spreadF7Click(row, col);
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        IntrField field = tab.getField(col);
        this.getModel().setValue("spreadf7type", field.getDimInfo().p3);
        ItemClassEdit bsEdit0 = (ItemClassEdit)this.getControl("spreadf7");
        SpreadMulItemClassEdit bsEdit = new SpreadMulItemClassEdit(bsEdit0);
        bsEdit.setQFilter(this.getF7Filter((String)field.getDimInfo().p2, (Long)field.getDimInfo().p1, (String)field.getDimInfo().p3, null, tab.getMemberIds(field.getNumber())));
        bsEdit.addBeforeF7SelectListener(this);
        this.getPageCache().put("spreadF7Click", "true");
        bsEdit.click();
    }

    @Override
    public void spreadF7LookUpData(LookUpDataArgs args) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        int col = args.getC();
        int row = args.getR();
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        IntrField field = tab.getField(col);
        if ("F7".equals(field.getShowType())) {
            args.setCountEnd(10);
            SpreadUtils.spreadF7lookUpData(this.getClientViewProxy(), SPREAD_KEY, (String)field.getDimInfo().p3, args, this.getF7Filter((String)field.getDimInfo().p2, (Long)field.getDimInfo().p1, (String)field.getDimInfo().p3, args.getValue(), tab.getMemberIds(field.getNumber())));
        } else {
            if (CollectionUtils.isNotEmpty((Collection)field.getEunmList())) {
                ArrayList<Object> enumScopes = new ArrayList<Object>(16);
                if (tab.getEnums(field.getNumber()) != null) {
                    enumScopes.addAll(tab.getEnums(field.getNumber()));
                }
                if (enumScopes.isEmpty()) {
                    enumScopes.addAll(field.getEunmList());
                }
                List options = enumScopes.stream().map(item -> {
                    ArrayList<Object> temp = new ArrayList<Object>(3);
                    temp.add(String.valueOf(item.hashCode()));
                    temp.add(item);
                    temp.add(item);
                    return temp;
                }).collect(Collectors.toList());
                data.put("data", options);
            }
            data.put("r", row);
            data.put("c", col);
            this.getClientViewProxy().invokeControlMethod(SPREAD_KEY, "setLookupData", new Object[]{data});
        }
    }

    public Map<String, IDNumberTreeNode> getEffectiveEntity(String search) {
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
        DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject year = (DynamicObject)this.getModel().getValue("year");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        return IntrReportHelper.getSellerBuyerEntity((Long)this.getModelId(), (Tuple)Tuple.create((Object)entity.getLong("id"), (Object)entity.getString("number"), (Object)entity.getString("longnumber")), (SimpleItem)SimpleItem.newOne((Object)scenario.getLong("id"), (String)scenario.getString("number")), (SimpleItem)SimpleItem.newOne((Object)year.getLong("id"), (String)year.getString("number")), (SimpleItem)SimpleItem.newOne((Object)period.getLong("id"), (String)period.getString("number")), (String)search);
    }

    protected abstract void afterUpdateSpread(IntrReportTabInfo var1, IntrTable var2, SpreadEasyInvoker var3, Sheet var4, List<IntrField> var5);

    protected abstract boolean isClsReport();

    protected abstract void insertRows(Sheet var1, int var2, int var3);

    protected Sheet getEffectiveSheet(SpreadManager spreadModel) {
        return spreadModel.getBook().getSheet(0);
    }

    protected boolean validateCondition() {
        return this.getModel().getValue("scenario") != null && this.getModel().getValue("year") != null && this.getModel().getValue("period") != null && this.getModel().getValue("currency") != null;
    }

    public void invokeSaveSpreadJsonEvent() {
        this.checkOrgPeriodOpen();
        super.checkPerm("btn_save");
        if (!this.validateCondition()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u641c\u7d22\u6761\u4ef6\u3002", (String)"IntrMultiTabReportFillInPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.getView().hideLoading();
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", "actionSaveSpreadJson");
        SpreadClientInvoker.invokeGetSpreadJsonMethod(this.getClientViewProxy(), SPREAD_KEY, params);
    }

    public void actionSaveSpreadJson(String spreadJson) {
        if (this.validateData()) {
            IntrReportTabInfo irt = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
            Long rptId = IntrReportHelper.saveReport((IntrReportData)this.getReortData(irt, this.getSpreadModel(), spreadJson));
            irt.setReportId(rptId);
            this.setModified(false);
            this.afterSaveAction();
            this.cacherReportTabManager();
        }
        this.getView().hideLoading();
    }

    private IntrReportData getReortData(IntrReportTabInfo irt, SpreadManager spreadManager, String spreadJson) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject year = (DynamicObject)this.getModel().getValue("year");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        IntrReportData rptData = new IntrReportData();
        rptData.setType(IntrRptGenTypeEnum.MANUAL);
        rptData.setActionUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
        rptData.setModel(new Pair((Object)model.getLong("id"), (Object)model.getString("shownumber")));
        rptData.setReportId(irt.getReportId());
        rptData.setTemplateId(irt.getTemplateId());
        IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)model.getLong("id"), (Long)irt.getEntityStorageId()).getBaseTreeNode();
        rptData.setEntity(new Tuple((Object)entity.getId(), (Object)entity.getNumber(), (Object)entity.getLongNumber()));
        rptData.setScenario(new Pair((Object)scenario.getLong("id"), (Object)scenario.getString("number")));
        rptData.setYear(new Pair((Object)year.getLong("id"), (Object)year.getString("number")));
        rptData.setPeriod(new Pair((Object)period.getLong("id"), (Object)period.getString("number")));
        rptData.setCurrency(new Pair((Object)currency.getLong("id"), (Object)currency.getString("number")));
        rptData.setSpreadJson(spreadJson);
        rptData.setSpreadManager(JsonSerializerUtil.toJson((SpreadManager)spreadManager));
        rptData.setTable(new IntrTable(irt.getFileds(), this.getAllRowData(irt, spreadManager)));
        return rptData;
    }

    protected abstract List<IntrRow> getAllRowData(IntrReportTabInfo var1, SpreadManager var2);

    abstract boolean validateData();

    public boolean validateDim(String modelNumber, IntrReportTabInfo tab, Integer rowIndex, List<Cell> row, List<IntrField> dimFields) {
        for (IntrField dimField : dimFields) {
            if (dimField.isJoinKey()) continue;
            Tuple dimInfo = IntrReportHelper.getAndInitDimInfo((long)tab.getModelId(), (IntrField)dimField);
            String dimNumber = (String)dimInfo.p2;
            int colIndex = tab.getColIndex(dimField.getNumber());
            Object cellValue = this.getCellValue(row.get(colIndex));
            if (cellValue == null || kd.bos.util.StringUtils.isBlank((String)cellValue.toString())) continue;
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)cellValue.toString());
            if (IDNumberTreeNode.NotFoundTreeNode == node) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u627e\u4e0d\u5230%2$s\u7684\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u7b2c%3$s\u884c\u7684\u6570\u636e\u540e\u518d\u4fdd\u5b58\u3002", (String)"AbstractIntrReportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimField.getName(), cellValue, rowIndex + 1));
                return Boolean.FALSE;
            }
            if (PresetConstant.ENTITY_DIM.equalsIgnoreCase(dimNumber) || IntrReportHelper.validataDimScope((Long)((Long)dimInfo.p1), tab.getDimScopeMap(), (String)dimField.getNumber(), (IDNumberTreeNode)node)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ea\u80fd\u586b\u5199\u6709\u6548\u8303\u56f4\u5185\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u7b2c%1$s\u884c%2$s\u5217\u7684\u6570\u636e\u540e\u518d\u4fdd\u5b58\u3002", (String)"AbstractIntrReportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), rowIndex + 1, colIndex + 1));
            return Boolean.FALSE;
        }
        return true;
    }

    private QFilter getF7Filter(String number, Long dimId, String entityName, String search, Set<Long> dimScopeIds) {
        long modelId = this.getModelId();
        PermissionService permService = PermissionServiceImpl.getInstance((Long)modelId);
        QFilter qf = new QFilter("model", "=", (Object)modelId).and("dimension", "=", (Object)dimId);
        if (kd.bos.util.StringUtils.isNotEmpty((String)search)) {
            QFilter searchQf = new QFilter("number", "like", (Object)("%" + search + "%")).or("name", "like", (Object)("%" + search + "%"));
            qf.and(searchQf);
        }
        if (PresetConstant.ENTITY_DIM.equals(number)) {
            qf.and("id", "in", this.getEffectiveEntity(null).entrySet().stream().map(e -> ((IDNumberTreeNode)e.getValue()).getId()).collect(Collectors.toSet()));
        } else if (dimScopeIds != null) {
            qf.and("id", "in", dimScopeIds);
        } else {
            qf.and("isleaf", "=", (Object)Boolean.TRUE).and(permService.getReadOrWritePermFilter(dimId, entityName, "id"));
        }
        return qf;
    }

    public Object getCellValue(Cell cell) {
        Object cellValue = cell.getValue();
        UserObject userObject = cell.getUserObject();
        if (userObject != null && userObject.containsKey("number")) {
            cellValue = userObject.get("number");
        }
        return cellValue;
    }

    private void afterSaveAction() {
        if ("true".equals(this.getPageCache().get(CLOSE_TAB_FLAG_KEY))) {
            this.closeTab(this.getReportTabInfoManager().getCurrSelectReportTabInfo().getTabKey());
            this.getPageCache().remove(CLOSE_TAB_FLAG_KEY);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)this.getPageCache().get(SWITCH_TAB_KEY))) {
            this.getReportTabInfoManager().setSelectReportTabInfo(this.getPageCache().get(SWITCH_TAB_KEY));
            IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
            this.enableYearPeriod(tab);
            this.cacherReportTabManager();
            this.getPageCache().remove(SWITCH_TAB_KEY);
            this.loadReport();
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)this.getPageCache().get(QUIT_VIEW))) {
            this.getPageCache().remove(QUIT_VIEW);
            this.getView().close();
        }
        if ("true".equals(this.getPageCache().get(SAVE_ACTION))) {
            this.getPageCache().remove(SAVE_ACTION);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"IntrMultiTabReportFillInPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5185\u90e8\u62b5\u9500\u586b\u62a5\u4fdd\u5b58", "IntrMultiTabReportFillInPlugin_8", "fi-bcm-formplugin", "WorkPaper Save"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"IntrMultiTabReportFillInPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
        }
        this.afterSaveSubAction();
    }

    protected abstract void afterSaveSubAction();

    protected IntrMergeParam getIntrParam(IntrReportTabInfo tab) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
        DynamicObject Scenario = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject year = (DynamicObject)this.getModel().getValue("year");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        IntrMergeParam param = new IntrMergeParam(new Pair((Object)model.getLong("id"), (Object)model.getString("shownumber")), tab.getTemplateId(), new Tuple((Object)entity.getLong("id"), (Object)entity.getString("number"), (Object)entity.getString("longnumber")), new Pair((Object)Scenario.getLong("id"), (Object)Scenario.getString("number")), new Pair((Object)year.getLong("id"), (Object)year.getString("number")), new Pair((Object)period.getLong("id"), (Object)period.getString("number")), new Pair((Object)currency.getLong("id"), (Object)currency.getString("number")));
        param.setModelNumber(model.getString("number"));
        return param;
    }

    private void initReportTabEnv(IntrReportPostmanByTemplate postman) {
        this.execRule(postman);
        this.getReportTabInfoManager().releaseAll();
        this.getReportTabInfoManager().addReportTabInfo4List(new IntrReportTabInfo(postman));
        IntrReportTabInfo tab = this.getReportTabInfoManager().getFirstReportTabInfo();
        this.getReportTabInfoManager().setSelectReportTabInfo(tab.getTabKey());
        this.contructReportTab();
        this.initTabLock(tab);
        this.cacherReportTabManager();
        Tab reporttab = (Tab)this.getControl(REPORT_TAB);
        reporttab.activeTab(tab.getTabKey());
        this.enableYearPeriod(tab);
    }

    @Override
    public void increaseReportTab(AbstractReportPostman pm) {
        String tabKey = pm.getTabKey(pm.getPairs().get(0));
        IntrReportPostmanByTemplate intrpm = (IntrReportPostmanByTemplate)pm;
        this.execRule(intrpm);
        IntrReportTabInfo tabInfo = new IntrReportTabInfo(intrpm);
        if (this.getReportTabInfoManager().addReportTabInfo4List(tabInfo)) {
            this.contructReportTab();
            this.initTabLock(tabInfo);
            this.cacherReportTabManager();
            Tab reporttab = (Tab)this.getControl(REPORT_TAB);
            reporttab.activeTab(tabKey);
        }
    }

    private void execRule(IntrReportPostmanByTemplate intrpm) {
        Long currencyId;
        Long periodId;
        Long yearId;
        Long sceneId;
        Long orgId;
        Long templateId;
        if (intrpm == null || intrpm.isReadonly() || !intrpm.isCslReport()) {
            return;
        }
        Long modelId = LongUtil.toLong((Object)intrpm.getModelPK());
        DynamicObject report = IntrReportHelper.getReportBaseInfo((Long)modelId, (Long)(templateId = LongUtil.toLong((Object)intrpm.getTemplatePK(null))), (Long)(orgId = LongUtil.toLong((Object)intrpm.getPairs().get((int)0).p1)), (Long)(sceneId = LongUtil.toLong((Object)intrpm.getScenarioPK())), (Long)(yearId = LongUtil.toLong((Object)intrpm.getYearPK())), (Long)(periodId = LongUtil.toLong((Object)intrpm.getPeriodPK())), (Long)(currencyId = LongUtil.toLong((Object)intrpm.getCurrencyPK())));
        if (report != null && !IntrConstant.RPT_EDITED_STATUS.contains(report.getString("reportstatus"))) {
            return;
        }
        Map dimValueMap = MapInitHelper.ofMap((Object)PresetConstant.ENTITY_DIM, (Object)orgId, (Object)PresetConstant.SCENE_DIM, (Object)sceneId, (Object)PresetConstant.FY_DIM, (Object)yearId, (Object)PresetConstant.PERIOD_DIM, (Object)periodId, (Object)PresetConstant.CURRENCY_DIM, (Object)currencyId, (Object)PresetConstant.PROCESS_DIM, (Object)MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)"ADJ").getId());
        ResultBox resultBox = PaperTemplateRuleHelper.execBizRule((Long)modelId, (Long)templateId, (Map)dimValueMap, (PaperTemplateRuleTypeEnum)PaperTemplateRuleTypeEnum.EXECWHENOPEN, (BizRuleExecuteTypeEnum)BizRuleExecuteTypeEnum.INTR_ONLY, null);
        Object[] result = (Object[])resultBox.getData();
        if (result != null && result.length > 0) {
            IntrReportHelper.clearSpread((Long)modelId, (Long)templateId, (Long)orgId, (Long)sceneId, (Long)yearId, (Long)periodId, (Long)currencyId);
        }
    }

    private void contructReportTab() {
        TabAp tabap = new TabAp();
        tabap.setKey(REPORT_TAB);
        tabap.setName(new LocaleString(REPORT_TAB));
        tabap.setGrow(0);
        ArrayList<String> keys = new ArrayList<String>();
        Iterator<IntrReportTabInfo> it = this.getReportTabInfoManager().iterator();
        while (it.hasNext()) {
            IntrReportTabInfo tab = it.next();
            TabPageAp page = new TabPageAp();
            page.setKey(tab.getTabKey());
            page.setName(new LocaleString(tab.getTabName()));
            keys.add(page.getKey());
            tabap.getItems().add(page);
        }
        Map features = tabap.createControl();
        HashMap<String, String> busyTips = new HashMap<String, String>(1);
        busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\u3002", (String)"IntrMultiTabReportFillInPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        features.put("busyTip", busyTips);
        this.getView().updateControlMetadata(REPORT_TAB, features);
        HashMap<String, Boolean> closeMap = new HashMap<String, Boolean>();
        closeMap.put("closable", true);
        keys.forEach(tabkey -> this.getView().updateControlMetadata(tabkey, closeMap));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (PROPER_CHANGE_SPEC_DEAL.contains(e.getProperty().getName())) {
            if (e.getChangeSet()[0].getNewValue() == null) {
                this.getModel().beginInit();
                this.getModel().setValue(e.getProperty().getName(), e.getChangeSet()[0].getOldValue());
                this.getModel().endInit();
                return;
            }
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            Long newTmplId = 0L;
            if (e.getChangeSet()[0].getOldValue() != null) {
                if ("year".equals(e.getProperty().getName()) || "period".equals(e.getProperty().getName())) {
                    Pair<String, Long> ckRes = this.checkEffect();
                    if (kd.bos.util.StringUtils.isNotEmpty((String)((String)ckRes.p1))) {
                        this.getView().showTipNotification((String)ckRes.p1);
                        this.getModel().beginInit();
                        this.getModel().setDataChanged(false);
                        this.getModel().getDataEntity().set(e.getProperty().getName(), e.getChangeSet()[0].getOldValue());
                        this.getView().updateView(e.getProperty().getName());
                        this.getModel().endInit();
                        return;
                    }
                    newTmplId = (Long)ckRes.p2;
                }
                this.releaseOldMutexLock(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), false);
                this.changCondition(e.getProperty().getName(), LongUtil.toLong((Object)newValue.get("id")), newTmplId);
            }
        }
    }

    protected Pair<String, Long> checkEffect() {
        IntrReportTabInfo irt = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        DynamicObject year = (DynamicObject)this.getModel().getValue("year");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
        ArrayList<DynamicObject> orgs = new ArrayList<DynamicObject>(16);
        FilterOrgStructParam param = new FilterOrgStructParam(irt.getModelId().longValue(), scenario.getLong("id"), year.getString("number"), period.getLong("id"));
        orgs.add(entity);
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, orgs);
        if (CollectionUtils.isEmpty(orgs)) {
            return Pair.onePair((Object)ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6240\u9009\u8d22\u5e74\u671f\u95f4\u672a\u751f\u6548\u3002", (String)"AbstractIntrReportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        }
        Set groupTmpIds = IntrTemplateHelper.getGroupTmplIds((Long)irt.getModelId(), (Set)Sets.newHashSet((Object[])new Long[]{irt.getTemplateId()}));
        PaperTmplChainFilter filter = new PaperTmplChainFilter(irt.getModelId(), PaperTemplateTypeEnum.INNERTRADE);
        filter.addFilter((AbstractPaperFilter)new VersionFilter(Long.valueOf(year.getLong("id")), Long.valueOf(period.getLong("id")))).addFilter((AbstractPaperFilter)new YearPeriodFilter(Long.valueOf(year.getLong("id")), Long.valueOf(period.getLong("id")))).addFilter((AbstractPaperFilter)new StatusFilter(Boolean.valueOf(true)));
        Set ids = filter.doFilter(groupTmpIds);
        boolean isRecodTmplId = false;
        if (CollectionUtils.isEmpty((Collection)ids)) {
            isRecodTmplId = true;
            DynamicObjectCollection fillReocrds = IntrReportHelper.getFillReocrd((Long)irt.getModelId(), (long)scenario.getLong("id"), (Set)Sets.newHashSet((Object[])new Long[]{year.getLong("id")}), (Set)Sets.newHashSet((Object[])new Long[]{period.getLong("id")}), (Set)Sets.newHashSet((Object[])new Long[]{irt.getEntityId()}), (Set)groupTmpIds);
            ids = fillReocrds.stream().map(e -> e.getLong("papertemplate")).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty((Collection)ids)) {
            filter.clearFilter();
            filter.addFilter((AbstractPaperFilter)new ReadOrWriteAuthFilter(Long.valueOf(this.getUserId())));
            ids = filter.doFilter(ids);
        }
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return Pair.onePair((Object)ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5728\u6240\u9009\u8d22\u5e74\u671f\u95f4\u672a\u751f\u6548\u3002", (String)"AbstractIntrReportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        }
        this.getView().setEnable(Boolean.valueOf(!isRecodTmplId), new String[]{"year", "period"});
        return Pair.onePair(null, ids.stream().findFirst().get());
    }

    private void changCondition(String keyName, Long id, Long newTmplId) {
        DynamicObject report;
        IntrReportTabInfo irt = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        boolean isNeedUpdateTempplateVersion = Boolean.FALSE;
        switch (keyName) {
            case "year": {
                irt.setYearId(id);
                isNeedUpdateTempplateVersion = Boolean.TRUE;
                break;
            }
            case "period": {
                irt.setPeriodId(id);
                isNeedUpdateTempplateVersion = Boolean.TRUE;
                break;
            }
            case "currency": {
                irt.setCurrencyId(id);
                break;
            }
        }
        if (isNeedUpdateTempplateVersion) {
            irt.changeTemplate(newTmplId, false);
        }
        if ((report = IntrReportHelper.getReportInfo((Long)irt.getModelId(), (Long)irt.getTemplateId(), (Long)irt.getEntityId(), (Long)irt.getScenarioId(), (Long)irt.getYearId(), (Long)irt.getPeriodId(), (Long)irt.getCurrencyId())) != null) {
            irt.changeReport(report.getLong("id"), report.getString("reportstatus"));
        }
        this.initTabLock(irt);
        this.cacherReportTabManager();
        this.loadSheetData();
    }

    private void enableYearPeriod(IntrReportTabInfo irt) {
        PaperTmplChainFilter filter = new PaperTmplChainFilter(irt.getModelId(), PaperTemplateTypeEnum.INNERTRADE);
        filter.addFilter((AbstractPaperFilter)new VersionFilter(irt.getYearId(), irt.getPeriodId(), true)).addFilter((AbstractPaperFilter)new OrgAssignFilter((Set)Sets.newHashSet((Object[])new Long[]{irt.getEntityId()}))).addFilter((AbstractPaperFilter)new SceneFilter(irt.getScenarioId())).addFilter((AbstractPaperFilter)new YearPeriodFilter(irt.getYearId(), irt.getPeriodId())).addFilter((AbstractPaperFilter)new StatusFilter(Boolean.valueOf(true)));
        this.getView().setEnable(Boolean.valueOf(!CollectionUtils.isEmpty((Collection)filter.doFilter((Set)Sets.newHashSet((Object[])new Long[]{irt.getTemplateId()})))), new String[]{"year", "period"});
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        String tabKey = e.getEventArgs();
        if (CMDNAMEKEY.equals(name)) {
            String selectKey = this.getReportTabInfoManager().getCurrSelectReportTabInfo().getTabKey();
            if (!tabKey.equals(selectKey)) {
                this.closeTab(tabKey);
            } else if (this.isModified()) {
                this.showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"IntrMultiTabReportFillInPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.format("%s,%s", CLOSE_TAB, tabKey));
            } else {
                this.closeTab(tabKey);
            }
        }
        if (CMDNAMEKEYS.equals(name)) {
            JSONArray keyArray = JSONArray.parseArray((String)tabKey);
            if (keyArray.size() == this.getReportTabInfoManager().getTabCount()) {
                this.getView().close();
            } else {
                for (Object o : keyArray) {
                    JSONObject jsonObject = (JSONObject)o;
                    String closeKey = jsonObject.getString("id");
                    this.closeTab(closeKey);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String[] str = e.getCallBackId().split(",");
        switch (str[0]) {
            case "close_tab": {
                if (MessageBoxResult.Yes == e.getResult()) {
                    this.getPageCache().put(CLOSE_TAB_FLAG_KEY, "true");
                    this.invokeSaveSpreadJsonEvent();
                    break;
                }
                this.setModified(false);
                this.closeTab(str[1]);
                break;
            }
            case "switch_tab": {
                if (MessageBoxResult.Yes == e.getResult()) {
                    this.getPageCache().put(SWITCH_TAB_KEY, str[1]);
                    this.invokeSaveSpreadJsonEvent();
                    break;
                }
                this.setModified(false);
                this.getReportTabInfoManager().setSelectReportTabInfo(str[1]);
                IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
                this.enableYearPeriod(tab);
                this.cacherReportTabManager();
                this.loadReport();
                break;
            }
            case "fresh_tab": {
                if (MessageBoxResult.Yes == e.getResult()) {
                    this.invokeSaveSpreadJsonEvent();
                    break;
                }
                this.setModified(false);
                this.loadSheetData();
                break;
            }
            case "change_condition": {
                if (MessageBoxResult.Yes == e.getResult()) {
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\u3002", (String)"IntrMultiTabReportFillInPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                    this.invokeSaveSpreadJsonEvent();
                    this.getPageCache().put(SAVE_ACTION, "true");
                    break;
                }
                this.setModified(false);
                break;
            }
            case "quit_view": {
                this.getPageCache().put(CONFIRM_CLOSE, CONFIRM_CLOSE);
                if (MessageBoxResult.Yes == e.getResult()) {
                    this.getPageCache().put(QUIT_VIEW, QUIT_VIEW);
                    this.invokeSaveSpreadJsonEvent();
                    break;
                }
                this.setModified(false);
                this.getView().close();
                break;
            }
            case "reset_table": {
                if (MessageBoxResult.Yes != e.getResult()) break;
                IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
                IntrReportHelper.resetTable((IntrMergeParam)this.getIntrParam(tab));
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6574\u8868\u91cd\u7f6e", "IntrMultiTabReportFillInPlugin_25", "fi-bcm-formplugin", "Reset Table"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(tab, ResManager.loadKDString((String)"\u6574\u8868\u91cd\u7f6e", (String)"IntrMultiTabReportFillInPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
                tab.changeTemplate(tab.getTemplateId(), true);
                tab.changeRptStyle(null);
                this.loadSheetData();
                this.setModified(false);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"IntrMultiTabReportFillInPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    protected String getLogDescription(IntrReportTabInfo tabInfo, String action) {
        return this.getLogDescription(tabInfo, action, true);
    }

    protected String getLogDescription(IntrReportTabInfo tabInfo, String action, boolean isSuccess) {
        if (isSuccess) {
            return this.getLogDescriptionMsg(tabInfo, String.format(ResManager.loadKDString((String)"%s\u6210\u529f", (String)"IntrMultiTabReportFillInPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), action));
        }
        return this.getLogDescriptionMsg(tabInfo, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25", (String)"AbstractIntrReportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), action));
    }

    protected String getLogDescriptionMsg(IntrReportTabInfo tabInfo, String message) {
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
        DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject year = (DynamicObject)this.getModel().getValue("year");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        return String.format("%1$s %2$s %3$s %4$s %5$s %6$s %7$s", entity.getString("number"), scenario.get("number"), year.get("number"), period.get("number"), tabInfo.getNumber(), tabInfo.getName(), message);
    }

    private void closeTab(String tabKey) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)tabKey)) {
            IntrReportTabManager reportTabManager = this.getReportTabInfoManager();
            IntrReportTabInfo tabInfo = reportTabManager.getCurrSelectReportTabInfo();
            this.releaseOldMutexLock(tabInfo, false);
            reportTabManager.releaseByKey(tabKey);
            this.cacherReportTabManager();
            String lastTabKey = reportTabManager.getLastTabKey();
            if (lastTabKey != null) {
                Tab tab = (Tab)this.getControl(REPORT_TAB);
                tab.activeTab(lastTabKey);
                this.getView().executeClientCommand(CMDNAMEKEY, new Object[]{tabKey});
            } else {
                this.getView().close();
            }
        }
    }

    protected void setModified(boolean isModified) {
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        if (isModified && (tab.isReadOnly() || tab.isLock() || IntrReportStatusEnum.COMPLETE.value.equals(tab.getStatus()) || IntrReportStatusEnum.REPORTED.value.equals(tab.getStatus()) || !this.isDCCurrency(tab).booleanValue())) {
            return;
        }
        this.getPageCache().put(IS_MODIFY, Boolean.toString(isModified));
    }

    protected boolean isModified() {
        String str = this.getPlugin().getPageCache().get(IS_MODIFY);
        return kd.bos.util.StringUtils.isEmpty((String)str) ? false : Boolean.parseBoolean(str);
    }

    protected void showConfirm(String msg, String callBackId) {
        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
    }

    protected void cacherReportTabManager() {
        this.cacheService.cacheReportTabInfoManager(this.getReportTabInfoManager());
    }

    protected IntrReportTabManager getReportTabInfoManager() {
        if (this.manager != null) {
            return this.manager;
        }
        this.manager = this.cacheService.getReportTabInfoManager();
        if (this.manager == null) {
            this.manager = new IntrReportTabManager();
        }
        return this.manager;
    }

    @Override
    public SpreadManager getSpreadModel() {
        if (this.currentManager != null) {
            return this.currentManager;
        }
        String data = this.getPageCache().getBigObject(INTR_SM_CACHE_KEY);
        if (kd.bos.util.StringUtils.isEmpty((String)data)) {
            return null;
        }
        this.currentManager = JsonSerializerUtil.toSpreadManager((String)data);
        return this.currentManager;
    }

    @Override
    public void cacheSpreadModel(SpreadManager sm) {
        this.currentManager = sm;
        this.isCacheSpreadModel = true;
    }

    @Override
    public void destory() {
        if (this.isCacheSpreadModel) {
            this.getPageCache().putBigObject(INTR_SM_CACHE_KEY, JsonSerializerUtil.toJson((SpreadManager)this.currentManager));
        }
        this.isCacheSpreadModel = false;
        super.destory();
    }
}

