/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.innertrade.report;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.CheckBox;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import org.apache.commons.collections4.CollectionUtils;

public class IntrAdjustProcessPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    public static final String PROCESSPANEL = "processpanel";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("model", this.getFormCustomParam("model"));
        this.initProcessList();
    }

    private void initProcessList() {
        String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
        ArrayList<IDNumberTreeNode> processList = new ArrayList<IDNumberTreeNode>(10);
        processList.add(MemberReader.findProcessMemberByNum((String)modelNumber, (String)"CCADJ"));
        IDNumberTreeNode ejeNode = MemberReader.findProcessMemberByNum((String)modelNumber, (String)"EJE");
        if (ejeNode.isLeaf()) {
            processList.add(ejeNode);
        } else {
            processList.addAll(ejeNode.getChildren());
        }
        processList.add(MemberReader.findProcessMemberByNum((String)modelNumber, (String)"ADJ"));
        processList.add(MemberReader.findProcessMemberByNum((String)modelNumber, (String)"CADJ"));
        Page page = new Page();
        Area area = new Area(PROCESSPANEL);
        area.setWidth(new LocaleString("300px"));
        for (IDNumberTreeNode process : processList) {
            CheckBox box = new CheckBox(String.format("%s - %s", process.getNumber(), process.getName()), process.getNumber());
            box.setNumber(process.getId().toString());
            box.setHeight(new LocaleString("35px"));
            box.setCustomStyle(fieldAp -> fieldAp.setStyle(this.getItemStyle()));
            area.addElement((Element)box);
        }
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        for (IDNumberTreeNode process : processList) {
            this.getModel().setValue(process.getNumber(), (Object)true);
        }
    }

    private Style getItemStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("15px");
        margin.setRight("0px");
        margin.setTop("0px");
        margin.setBottom("0px");
        style.setMargin(margin);
        return style;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String btnKey = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(btnKey)) {
            Area area = this.getPage(this.getView()).findAreaBySign(PROCESSPANEL);
            ArrayList<Long> processIds = new ArrayList<Long>(16);
            for (Element element : area.getElementListList()) {
                if (!(element instanceof CheckBox)) continue;
                CheckBox box = (CheckBox)element;
                if (!Boolean.parseBoolean(this.getModel().getValue(box.getSign()).toString())) continue;
                processIds.add(Long.valueOf(box.getNumber()));
            }
            if (CollectionUtils.isEmpty(processIds)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u5f55\u8fc7\u7a0b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IntrAdjustProcessPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(processIds);
            this.getView().setReturnData(processIds);
            this.getView().close();
        }
    }
}

