/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.innertrade.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrMergeParam;
import kd.fi.bcm.business.innertrade.model.IntrRow;
import kd.fi.bcm.business.innertrade.model.IntrTable;
import kd.fi.bcm.business.innertrade.report.IntrEntityHelper;
import kd.fi.bcm.business.innertrade.report.IntrMergeHelper;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.formplugin.innertrade.report.AbstractIntrReportPlugin;
import kd.fi.bcm.formplugin.innertrade.report.multi.IntrReportTabInfo;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.model.AskExcuteInfo;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import org.apache.commons.collections4.CollectionUtils;

public class IntrCslReportFillInPlugin
extends AbstractIntrReportPlugin {
    @Override
    public void initSubSpreadListener() {
        this.registerBeforeEvent(EventConstant.ActionName.ADD_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            if (this.checkIsHeadRow(excuteinfo)) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5934\u4ee5\u4e0a\u4e0d\u5141\u8bb8\u63d2\u884c\u548c\u5220\u884c\u3002", (String)"IntrCslReportFillInPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        });
        this.registerBeforeEvent(EventConstant.ActionName.REMOVE_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            if (this.checkIsHeadRow(excuteinfo)) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5934\u4ee5\u4e0a\u4e0d\u5141\u8bb8\u63d2\u884c\u548c\u5220\u884c\u3002", (String)"IntrCslReportFillInPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        });
        this.registerAfterEvent(EventConstant.ActionName.ADD_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.setModified(true);
            this.updateRowAndCol(excuteinfo);
            this.updateStyle(false);
        });
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
            this.setModified(true);
        });
    }

    private boolean checkIsHeadRow(AskExcuteInfo excuteinfo) {
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        if (CollectionUtils.isNotEmpty(excuteinfo.getOperationdata())) {
            for (Integer opRowNum : excuteinfo.getOperationdata()) {
                if (opRowNum >= (Integer)tab.getStartPoint().p1) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_caculate": {
                this.caculateData();
                break;
            }
        }
    }

    private void caculateData() {
        if (!this.validateCondition()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u641c\u7d22\u6761\u4ef6\u3002", (String)"IntrMultiTabReportFillInPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.validateData()) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\u3002", (String)"IntrMultiTabReportFillInPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
            DynamicObject ts = IntrTemplateHelper.getTemplateSpread((Long)tab.getModelId(), (Long)tab.getTemplateId());
            SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "report", ts.getString("spreadjson"));
            SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)ts.getString("data"));
            this.updateTemplateConfig(tab, sm);
            this.updateTab(tab, sm, IntrMergeHelper.caculateData((IntrMergeParam)this.getIntrParam(tab), this.getAllRowData(tab, this.getSpreadModel())));
            this.updateButtonAndStyle(tab);
            this.getView().hideLoading();
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u516c\u5f0f\u8ba1\u7b97", "IntrMultiTabReportFillInPlugin_14", "fi-bcm-formplugin", "Formula calculate"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), ResManager.loadKDString((String)"\u516c\u5f0f\u8ba1\u7b97", (String)"IntrMultiTabReportFillInPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"IntrMultiTabReportFillInPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected void updateStyle(boolean lock) {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.setBatch(true);
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        List<IntrField> head = tab.getFileds();
        Pair<Integer, Integer> startPoint = tab.getStartPoint();
        Sheet sheet = this.getEffectiveSheet(this.getSpreadModel());
        int rowSize = this.getMaxRowCount(sheet);
        for (IntrField intrField : head) {
            int colIndex = tab.getColIndex(intrField.getNumber());
            invoker.lockCell(0, colIndex, (Integer)startPoint.p1, 1);
            if (!lock && !intrField.isReadOnly()) continue;
            invoker.lockCell((Integer)startPoint.p1, colIndex, rowSize, 1);
        }
        invoker.startToInvoke();
    }

    @Override
    protected void handleMenuItem(boolean lockTable) {
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), "report", MapInitHelper.ofMap((Object)"isHide", (Object)false));
        ArrayList<Map> menuItems = new ArrayList<Map>(10);
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.deleteColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.deleteRows, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)lockTable));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRows, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)lockTable));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertColMany, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowMany, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)lockTable));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowOrColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)lockTable));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowOrColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.SUBMENU.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowsTop, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)lockTable));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowOrColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.SUBMENU.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowsBottom, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowOrColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.SUBMENU.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertColsLeft, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowOrColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.SUBMENU.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertColsRight, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.cols_insertColsLeft, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.colHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.cols_insertColsRight, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.colHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.rows_insertRowsTop, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.rowHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)lockTable));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.rows_insertRowsBottom, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.rowHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.sort, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.cellsFormat, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.hideRows, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.rowHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.unhideRows, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.rowHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.hideColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.colHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.unhideColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.colHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), this.getSpreadKey(), menuItems);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.addContextMenuItem("linkAdjust", ResManager.loadKDString((String)"\u8054\u67e5\u5206\u5f55", (String)"IntrMultiTabReportFillInPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport"});
        invoker.addContextMenuItem("linkHistory", ResManager.loadKDString((String)"\u8054\u67e5\u5386\u53f2", (String)"IntrCslReportFillInPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport"});
        invoker.startToInvoke();
    }

    @Override
    protected void updateTemplateConfig(IntrReportTabInfo tab, SpreadManager spreadManager) {
        Pair<Integer, Integer> startPoint = tab.getStartPoint();
        Sheet sheet = this.getEffectiveSheet(spreadManager);
        int rowSize = IntrConstant.TMP_INIT_ROW_COUNT;
        this.floatTemplateFormate(tab, spreadManager);
        this.setAddRowStyle(tab, sheet, (Integer)startPoint.p1, rowSize);
    }

    @Override
    protected void extendRowStyle(IntrReportTabInfo tab, Sheet newSheet, List<LinkedHashMap<String, Object>> values) {
        OptionalInt maxRow = values.stream().mapToInt(e -> Integer.parseInt(e.get("r").toString())).max();
        if (maxRow.isPresent()) {
            int maxRowCount = this.getMaxRowCount(newSheet);
            if (maxRow.getAsInt() > maxRowCount) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u6267\u884c\u516c\u5f0f\u8ba1\u7b97\u3002", (String)"IntrCslReportFillInPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.setAddRowStyle(tab, newSheet, maxRowCount, maxRow.getAsInt() - maxRowCount + 1);
            }
        }
    }

    protected void floatTemplateFormate(IntrReportTabInfo tab, SpreadManager spreadManager) {
        Sheet sheet = this.getEffectiveSheet(spreadManager);
        int maxRowCount = sheet.getMaxRowCount() > IntrConstant.TMP_INIT_ROW_COUNT ? sheet.getMaxRowCount() : IntrConstant.TMP_INIT_ROW_COUNT.intValue();
        SpreadClientInvoker.invokeBatchDelRow(this.getClientViewProxy(), this.getSpreadKey(), (Integer)tab.getStartPoint().p1 + 1, maxRowCount - (Integer)tab.getStartPoint().p1 - 1);
        SpreadClientInvoker.invokeBatchInsertRow(this.getClientViewProxy(), this.getSpreadKey(), (Integer)tab.getStartPoint().p1, maxRowCount - (Integer)tab.getStartPoint().p1 - 1, true);
    }

    private void setAddRowStyle(IntrReportTabInfo tab, Sheet sheet, int stratRow, int rowSize) {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.setBatch(Boolean.TRUE);
        List<IntrField> head = tab.getFileds();
        for (IntrField intrField : head) {
            int colIndex = tab.getColIndex(intrField.getNumber());
            Cell cell = sheet.getCell(stratRow, colIndex);
            cell.clearAllUserObject();
            if (intrField.isReadOnly() || !StringUtils.isNotEmpty((String)intrField.getShowType())) continue;
            int dst = 1;
            if ("F7".equals(intrField.getShowType())) {
                dst = 0;
            }
            invoker.setF7TypeCell(stratRow, colIndex, rowSize, 1, 0, dst);
        }
        invoker.startToInvoke();
    }

    @Override
    protected void insertRows(Sheet sheet, int copyIndex, int needtotalrows) {
        int realMaxRowCount = this.getMaxRowCount(sheet);
        if (needtotalrows > realMaxRowCount) {
            SpreadClientInvoker.invokeBatchInsertRow(this.getClientViewProxy(), this.getSpreadKey(), copyIndex, needtotalrows - realMaxRowCount, true);
            this.setAddRowStyle(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), sheet, realMaxRowCount, needtotalrows - realMaxRowCount);
        }
    }

    @Override
    protected int getMaxRowCount(Sheet sheet) {
        return sheet.getMaxRowCount();
    }

    @Override
    protected boolean validateData() {
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        String modelNumber = MemberReader.findModelNumberById((Object)tab.getModelId());
        Sheet sheet = this.getEffectiveSheet(this.getSpreadModel());
        Pair<Integer, Integer> point = tab.getStartPoint();
        List<IntrField> fileds = tab.getFileds();
        List requiredFields = fileds.stream().filter(IntrField::isRequired).collect(Collectors.toList());
        List<IntrField> dimFields = fileds.stream().filter(e -> "F7".equals(e.getShowType())).collect(Collectors.toList());
        List<IntrField> uniqueFields = fileds.stream().filter(IntrField::isUnique).collect(Collectors.toList());
        int maxRowCount = this.getMaxRowCount(sheet);
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>(16);
        Map<String, IDNumberTreeNode> entityMap = this.getEffectiveEntity(null);
        for (int i = ((Integer)point.p1).intValue(); i <= maxRowCount; ++i) {
            List row = sheet.getRow(i, Boolean.TRUE.booleanValue());
            if (this.isBlanRow(tab, row)) continue;
            for (IntrField field : requiredFields) {
                String reqField = field.getNumber();
                Object cellValue = this.getCellValue((Cell)row.get(tab.getColIndex(reqField)));
                if (cellValue != null && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cellValue.toString())) continue;
                String mergeName = IntrTemplateHelper.getTemplateInfo((Long)this.getModelId(), (Long)tab.getTemplateId()).getString("mergenode.name");
                String tip = String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\"%1$s\"\u8bbe\u7f6e\u4e86\"%2$s\"\u4e3a\u5fc5\u5f55\u9879\uff0c\u8bf7\u8865\u5145\u5b8c\u6574\u7b2c\"%3$s\"\u884c\u7684\u4fe1\u606f\u540e\u518d\u4fdd\u5b58\u3002", (String)"IntrMultiTabReportFillInPlugin_45", (String)"fi-bcm-formplugin", (Object[])new Object[0]), mergeName, field.getName(), i + 1);
                if (IntrConstant.FIELD_ORG_NUMBER.equals(reqField)) {
                    tip = String.format(ResManager.loadKDString((String)"\"%1$s\"\u4e3a\u5fc5\u5f55\u9879\uff0c\u8bf7\u8865\u5145\u5b8c\u6574\u7b2c\"%2$s\"\u884c\u7684\u4fe1\u606f\u540e\u518d\u4fdd\u5b58\u3002", (String)"IntrMultiTabReportFillInPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]), IntrConstant.getSellerName(), i + 1);
                }
                if (IntrConstant.FIELD_IC_NUMBER.equals(reqField)) {
                    tip = String.format(ResManager.loadKDString((String)"\"%1$s\"\u4e3a\u5fc5\u5f55\u9879\uff0c\u8bf7\u8865\u5145\u5b8c\u6574\u7b2c\"%2$s\"\u884c\u7684\u4fe1\u606f\u540e\u518d\u4fdd\u5b58\u3002", (String)"IntrMultiTabReportFillInPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]), IntrConstant.getBuyerName(), i + 1);
                }
                this.getView().showTipNotification(tip);
                return Boolean.FALSE;
            }
            if (!this.validateDim(modelNumber, tab, i, row, dimFields)) {
                return Boolean.FALSE;
            }
            DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
            Object sellNum = this.getCellValue((Cell)row.get(tab.getColIndex(IntrConstant.FIELD_ORG_NUMBER)));
            Object buyNum = this.getCellValue((Cell)row.get(tab.getColIndex(IntrConstant.FIELD_IC_NUMBER)));
            IDNumberTreeNode sellNode = entityMap.get(sellNum.toString());
            IDNumberTreeNode buyNode = entityMap.get(buyNum.toString());
            if (sellNode == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"[%1$s]\u5728\u6b64\u671f\u95f4\u672a\u751f\u6548\u6216\u4e0d\u53c2\u4e0e\u5f53\u524d\u7ec4\u7ec7\u7684\u5408\u5e76\uff0c\u8bf7\u68c0\u67e5\u7b2c%2$s\u884c\u7684\u6570\u636e\u540e\u518d\u4fdd\u5b58\u3002", (String)"IntrMultiTabReportFillInPlugin_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sellNum, i + 1));
                return Boolean.FALSE;
            }
            if (buyNode == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"[%1$s]\u5728\u6b64\u671f\u95f4\u672a\u751f\u6548\u6216\u4e0d\u53c2\u4e0e\u5f53\u524d\u7ec4\u7ec7\u7684\u5408\u5e76\uff0c\u8bf7\u68c0\u67e5\u7b2c%2$s\u884c\u7684\u6570\u636e\u540e\u518d\u4fdd\u5b58\u3002", (String)"IntrMultiTabReportFillInPlugin_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]), buyNum, i + 1));
                return Boolean.FALSE;
            }
            if (sellNode.getNumber().equals(buyNode.getNumber()) || !IntrEntityHelper.checkCommonParentEntity((String)entity.getString("longnumber"), (String)sellNode.getLongNumber(), (String)buyNode.getLongNumber())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9500\u552e\u65b9\u548c\u91c7\u8d2d\u65b9\u7684\u76f4\u63a5\u5171\u540c\u7236\u7ea7\u987b\u4e3a\u5f53\u524d\u7ec4\u7ec7[%1$s]\uff0c\u8bf7\u68c0\u67e5\u7b2c%2$s\u884c\u7684\u6570\u636e\u540e\u518d\u4fdd\u5b58\u3002", (String)"IntrMultiTabReportFillInPlugin_48", (String)"fi-bcm-formplugin", (Object[])new Object[0]), entity.getString("name"), i + 1));
                return Boolean.FALSE;
            }
            String uniKey = this.getUniqueKey(tab, uniqueFields, row);
            if (keyMap.containsKey(uniKey)) {
                String mergeName = IntrTemplateHelper.getTemplateInfo((Long)this.getModelId(), (Long)tab.getTemplateId()).getString("mergenode.name");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\"%1$s\"\u7684\u552f\u4e00\u5b57\u6bb5\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u540e\u518d\u4fdd\u5b58\uff1aLine:%2$s\u4e0eLine:%3$s\u91cd\u590d\u3002", (String)"IntrMultiTabReportFillInPlugin_46", (String)"fi-bcm-formplugin", (Object[])new Object[0]), mergeName, (Integer)keyMap.get(uniKey) + 1, i + 1));
                return Boolean.FALSE;
            }
            keyMap.put(uniKey, i);
        }
        return Boolean.TRUE;
    }

    private boolean isBlanRow(IntrReportTabInfo tab, List<Cell> row) {
        if (row.size() == 0) {
            return Boolean.TRUE;
        }
        for (Map.Entry<String, Integer> kv : tab.getFieldIndexMap().entrySet()) {
            Object cellValue = this.getCellValue(row.get(kv.getValue()));
            if (cellValue == null || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cellValue.toString())) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    protected List<IntrRow> getAllRowData(IntrReportTabInfo tab, SpreadManager spreadManager) {
        ArrayList<IntrRow> rows = new ArrayList<IntrRow>(16);
        Sheet sheet = this.getEffectiveSheet(spreadManager);
        List<IntrField> mergeFieldList = tab.getFileds();
        int maxRowCount = this.getMaxRowCount(sheet);
        for (int i = ((Integer)tab.getStartPoint().p1).intValue(); i <= maxRowCount; ++i) {
            List row = sheet.getRow(i, Boolean.TRUE.booleanValue());
            if (this.isBlanRow(tab, row)) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(mergeFieldList.size());
            for (IntrField field : mergeFieldList) {
                Object cellValue = this.getCellValue((Cell)row.get(tab.getColIndex(field.getNumber())));
                data.put(field.getNumber(), cellValue);
            }
            rows.add(new IntrRow(data, Integer.valueOf(i)));
        }
        return rows;
    }

    @Override
    protected void afterUpdateSpread(IntrReportTabInfo tab, IntrTable table, SpreadEasyInvoker invoker, Sheet sheet, List<IntrField> head) {
    }

    @Override
    protected boolean isClsReport() {
        return Boolean.TRUE;
    }

    @Override
    protected void afterSaveSubAction() {
    }
}

