/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.innertrade.report;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.ListColumn;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.report.IntrReportHelper;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.innertrade.IntrDimDisplayModeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class IntrHistoryPlugin
extends AbstractBaseListPlugin {
    private static final String CTL_BILLSTAP = "billlistap";

    @Override
    public void initialize() {
        super.initialize();
        HashMap<String, SingleF7TypeEnum> map = new HashMap<String, SingleF7TypeEnum>(16);
        this.asMapF7toType(Arrays.asList("scenario", "year", "period", "currency"), SingleF7TypeEnum.LEAF, map);
        map.put("entity", SingleF7TypeEnum.COMMON);
        this.initSingleMemberF7(map);
        List<IntrField> fieldList = this.getIntrFields();
        BillList billList = (BillList)this.getView().getControl(CTL_BILLSTAP);
        billList.addSetFilterListener(this::setFilter);
        String modelNumber = MemberReader.findModelNumberById((Object)this.getFormCustomParam("KEY_MODEL_ID"));
        Long sceneId = (Long)this.getFormCustomParam("scenario");
        Long currencyId = (Long)this.getFormCustomParam("currency");
        Integer scale = CurrencyScaleHandler.getCurrencyScale((String)MemberReader.findScenaMemberById((String)modelNumber, (Long)sceneId).getNumber(), (String)MemberReader.findCurrencyMemberById((String)modelNumber, (Long)currencyId).getNumber(), (String)modelNumber);
        StringBuilder formate = new StringBuilder("#.");
        for (int i = 0; i < scale; ++i) {
            formate.append("#");
        }
        billList.addCreateListColumnsListener(e -> {
            this.getFormCustomParam("KEY_MODEL_ID");
            List cols = e.getListColumns();
            int size = cols.size();
            for (int i = 0; i < fieldList.size(); ++i) {
                cols.add(this.createListColumn((IntrField)fieldList.get(i), i + size, formate.toString()));
            }
        });
        Map<String, IntrField> fieldMap = fieldList.stream().collect(Collectors.toMap(IntrField::getNumber, v -> v, (e1, e2) -> e2));
        billList.addPackageDataListener(e -> {
            if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
                IDNumberTreeNode node = null;
                IntrDimDisplayModeEnum displayMode = IntrDimDisplayModeEnum.NAME;
                String fieldKey = ((ColumnDesc)e.getSource()).getKey();
                if (PresetConstant.FY_DIM.equalsIgnoreCase(fieldKey)) {
                    node = MemberReader.findMemberByNumber((String)modelNumber, (String)PresetConstant.FY_DIM, (String)e.getRowData().getString(fieldKey));
                } else if (PresetConstant.PERIOD_DIM.equalsIgnoreCase(fieldKey)) {
                    node = MemberReader.findMemberByNumber((String)modelNumber, (String)PresetConstant.PERIOD_DIM, (String)e.getRowData().getString(fieldKey));
                } else {
                    IntrField field = (IntrField)fieldMap.get(fieldKey);
                    if (field != null && "F7".equals(field.getShowType())) {
                        node = MemberReader.findMemberByNumber((String)modelNumber, (String)((String)field.getDimInfo().p2), (String)e.getRowData().getString(field.getBoundField()));
                        displayMode = IntrDimDisplayModeEnum.NUMBERANDNAME;
                    }
                }
                if (node != null) {
                    e.setFormatValue((Object)IntrReportHelper.getDisplayName((String)node.getNumber(), (String)node.getName(), (IntrDimDisplayModeEnum)displayMode));
                }
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("model", this.getFormCustomParam("KEY_MODEL_ID"));
        this.getModel().setValue("entity", this.getFormCustomParam("entity"));
        this.getModel().setValue("scenario", this.getFormCustomParam("scenario"));
        this.getModel().setValue("year", this.getFormCustomParam("year"));
        this.getModel().setValue("period", this.getFormCustomParam("period"));
        this.getModel().setValue("currency", this.getFormCustomParam("currency"));
    }

    @Override
    public void registerListener(EventObject event) {
        super.registerListener(event);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "close": {
                this.getView().close();
                break;
            }
            case "refresh": {
                BillList billList = (BillList)this.getControl(CTL_BILLSTAP);
                billList.refresh();
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        DynamicObject modelDy = (DynamicObject)this.getModel().getValue("model");
        DynamicObject entityDy = (DynamicObject)this.getModel().getValue("entity");
        DynamicObject sceneDy = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject currencyDy = (DynamicObject)this.getModel().getValue("currency");
        QFBuilder qb = new QFBuilder();
        qb.add("modelnumber", "=", (Object)modelDy.getString("shownumber"));
        qb.add("datamodel", "=", this.getFormCustomParam("datamodel"));
        qb.add("org", "=", (Object)entityDy.getString("number"));
        qb.add("scenario", "=", (Object)sceneDy.getString("number"));
        qb.add("currency", "=", (Object)currencyDy.getString("number"));
        String extModelNum = (String)this.getFormCustomParam("datamodel");
        qb.add("extendsgroup", "=", (Object)IntrReportHelper.getGroupNumByModelNum((long)modelDy.getLong("id"), (String)extModelNum));
        qb.add("process", "=", (Object)"ADJ");
        qb.add("audittrail", "=", (Object)"EntityInput");
        List<Map<String, Object>> rowData = this.getQueryData();
        QFilter orqb = null;
        for (Map<String, Object> item : rowData) {
            QFilter itemQf = null;
            for (Map.Entry<String, Object> kv : item.entrySet()) {
                if (itemQf == null) {
                    itemQf = new QFilter(kv.getKey(), "=", kv.getValue());
                    continue;
                }
                itemQf.and(kv.getKey(), "=", kv.getValue());
            }
            if (orqb == null) {
                orqb = itemQf;
                continue;
            }
            orqb.or(itemQf);
        }
        e.getQFilters().addAll(qb.and(orqb).toList());
        e.setOrderBy("year asc,period asc");
    }

    private List<Map<String, Object>> getQueryData() {
        Object queryData = this.getFormCustomParam("queryData");
        if (queryData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u67e5\u8be2\u6570\u636e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"IntrHistoryPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return (List)this.deSerializedBytes(queryData.toString());
    }

    private List<IntrField> getIntrFields() {
        Object fields = this.getFormCustomParam("fields");
        if (fields == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"IntrHistoryPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return (List)this.deSerializedBytes(fields.toString());
    }

    private ListColumn createListColumn(IntrField field, int colIndex, String digitalFormate) {
        DecimalListColumn col = null;
        if (IntrConstant.DB_DIGITAL_DATA_TYPE.contains(field.getDataType())) {
            col = new DecimalListColumn();
            col.setNoDisplayScaleZero(false);
            col.setZeroShow(true);
            col.setDisplayFormatString(digitalFormate);
            if (DataTypeEnum.PROPORTION.getOIndex().equals(field.getDataType())) {
                col.setDisplayFormatString(digitalFormate + "%");
            }
        } else {
            col = new ListColumn();
            col.setTextAlign("center");
        }
        col.setCaption(new LocaleString(field.getName()));
        col.setKey(field.getBoundField());
        col.setListFieldKey(field.getBoundField());
        col.setFieldName(field.getBoundField());
        col.setSeq(colIndex);
        col.setVisible(11);
        return col;
    }
}

