/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.innertrade.report;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrMergeParam;
import kd.fi.bcm.business.innertrade.model.IntrRow;
import kd.fi.bcm.business.innertrade.model.IntrTable;
import kd.fi.bcm.business.innertrade.report.IntrMergeHelper;
import kd.fi.bcm.business.innertrade.report.IntrReportHelper;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.message.MessageBcmServiceHelper;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.formplugin.innertrade.report.AbstractIntrReportPlugin;
import kd.fi.bcm.formplugin.innertrade.report.multi.IntrReportTabInfo;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.UserObject;
import org.apache.commons.collections4.CollectionUtils;

public class IntrMultiTabReportFillInPlugin
extends AbstractIntrReportPlugin {
    public static final String GENERATE_DATA = "generate_data";
    private static final String RPT_LINK = UrlService.getDomainContextUrl() + "?formId=bcm_cslreportprocess&reportId=";

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_caculate": {
                if (this.isModified()) {
                    this.invokeSaveSpreadJsonEvent();
                    this.getPageCache().put(GENERATE_DATA, "true");
                    break;
                }
                this.generateData();
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u751f\u6210\u5e95\u7a3f", "IntrMultiTabReportFillInPlugin_13", "fi-bcm-formplugin", "Generate Draft"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), ResManager.loadKDString((String)"\u751f\u6210\u5e95\u7a3f", (String)"IntrMultiTabReportFillInPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"IntrMultiTabReportFillInPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_linkreport": {
                this.linkReport();
                break;
            }
            case "btn_smartnotice": {
                this.sendDiffNotice();
                break;
            }
        }
    }

    @Override
    public void initSubSpreadListener() {
    }

    @Override
    protected int getMaxRowCount(Sheet sheet) {
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        Integer rowCount = (Integer)tab.getStartPoint().p1;
        for (int i = ((Integer)tab.getStartPoint().p1).intValue(); i < sheet.getMaxRowCount() && !sheet.getCell(i, tab.getColIndex(IntrConstant.FIELD_ORG_NUMBER)).isNullValue(); ++i) {
            Integer n = rowCount;
            Integer n2 = rowCount = Integer.valueOf(rowCount + 1);
        }
        return rowCount;
    }

    private void generateData() {
        if (!this.validateCondition()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u641c\u7d22\u6761\u4ef6\u3002", (String)"IntrMultiTabReportFillInPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\u3002", (String)"IntrMultiTabReportFillInPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        IntrReportTabInfo csrt = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        DynamicObject ts = IntrTemplateHelper.getTemplateSpread((Long)csrt.getModelId(), (Long)csrt.getTemplateId());
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), "report", ts.getString("spreadjson"));
        SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)ts.getString("data"));
        IntrTemplateHelper.repairTableRow((SpreadManager)sm);
        this.updateTemplateConfig(csrt, sm);
        this.updateTab(csrt, sm, IntrMergeHelper.generateData((IntrMergeParam)this.getIntrParam(csrt)));
        this.updateButtonAndStyle(csrt);
        this.getView().hideLoading();
    }

    @Override
    protected void updateStyle(boolean lock) {
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.setBatch(true);
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        List<IntrField> head = tab.getFileds();
        Pair<Integer, Integer> startPoint = tab.getStartPoint();
        Sheet sheet = this.getEffectiveSheet(this.getSpreadModel());
        int rowSize = this.getMaxRowCount(sheet) - (Integer)startPoint.p1;
        for (IntrField intrField : head) {
            int colIndex = tab.getColIndex(intrField.getNumber());
            invoker.lockCell(0, colIndex, (Integer)startPoint.p1, 1);
            if (lock || intrField.isReadOnly()) {
                invoker.lockCell((Integer)startPoint.p1, colIndex, rowSize + 1, 1);
                continue;
            }
            invoker.lockCell((Integer)startPoint.p1 + rowSize, colIndex, 1, 1);
        }
        invoker.startToInvoke();
    }

    private void sendDiffNotice() {
        if (this.isModified()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e95\u7a3f\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u4fdd\u5b58\u540e\u518d\u6267\u884c\u667a\u80fd\u901a\u77e5\u3002", (String)"IntrMultiTabReportFillInPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        Set<Pair<String, String>> orgs = this.getIntrOrgs();
        if (CollectionUtils.isEmpty(orgs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u884c\u8fdb\u884c\u667a\u80fd\u901a\u77e5\u3002", (String)"IntrMultiTabReportFillInPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_intrreportnotice");
        param.getOpenStyle().setShowType(ShowType.Modal);
        if (this.getView().getParentView() != null) {
            param.setRootPageId(this.getView().getParentView().getPageId());
        }
        param.setCaption(ResManager.loadKDString((String)"\u901a\u77e5\u8bbe\u7f6e", (String)"IntrMultiTabReportFillInPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        param.setCustomParam("KEY_MODEL_ID", (Object)tab.getModelId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "smart_notice");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private Set<Pair<String, String>> getIntrOrgs() {
        SpreadSelector selector = this.getSpreadSelector();
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        Integer effectRowIndex = (Integer)tab.getStartPoint().p1;
        Sheet sheet = this.getEffectiveSheet(this.getSpreadModel());
        int orgIndex = tab.getColIndex(IntrConstant.FIELD_ORG_NUMBER);
        int icIndex = tab.getColIndex(IntrConstant.FIELD_IC_NUMBER);
        HashSet<Pair<String, String>> orgs = new HashSet<Pair<String, String>>(16);
        if (selector.getSelections() != null) {
            for (Map selection : selector.getSelections()) {
                Integer row = (Integer)selection.get("row");
                Integer rowCount = (Integer)selection.get("rowCount");
                Integer i = 0;
                while (i < rowCount) {
                    if (i >= effectRowIndex) {
                        Object cellOrgNum = sheet.getCell(row + i, orgIndex).getUserObject().get((Object)"number");
                        Object buyOrgNum = sheet.getCell(row + i, icIndex).getUserObject().get((Object)"number");
                        if (cellOrgNum != null && buyOrgNum != null) {
                            orgs.add((Pair<String, String>)Pair.onePair((Object)cellOrgNum.toString(), (Object)buyOrgNum.toString()));
                        }
                    }
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            }
        } else {
            String rangePosition = selector.getRangePosition();
            if (StringUtils.isEmpty((String)rangePosition)) {
                return orgs;
            }
            RangeModel range = SpreadAreaUtil.getRangModel((String)rangePosition);
            for (int i = range.getY_start(); i <= range.getY_end(); ++i) {
                if (i < effectRowIndex) continue;
                Object cellOrgNum = sheet.getCell(i, orgIndex).getUserObject().get((Object)"number");
                Object buyOrgNum = sheet.getCell(i, icIndex).getUserObject().get((Object)"number");
                if (cellOrgNum == null || buyOrgNum == null) continue;
                orgs.add((Pair<String, String>)Pair.onePair((Object)cellOrgNum.toString(), (Object)buyOrgNum.toString()));
            }
        }
        return orgs;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object data = evt.getReturnData();
        if ("smart_notice".equals(actionId)) {
            DynamicObject rpt;
            String content;
            String icOrgs;
            if (data == null) {
                return;
            }
            Map returnData = (Map)data;
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            DynamicObject scene = (DynamicObject)this.getModel().getValue("scenario");
            DynamicObject year = (DynamicObject)this.getModel().getValue("year");
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
            DynamicObject intrTmpl = IntrTemplateHelper.getTemplateInfo((Long)tab.getModelId(), (Long)tab.getTemplateId());
            DynamicObject sellExtTemplate = IntrTemplateHelper.getExtTemplate((Long)model.getLong("id"), (Long)intrTmpl.getLong("seller.id"), (Long)year.getLong("id"), (Long)period.getLong("id"));
            if (sellExtTemplate == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\uff1a%1$s\uff0c\u8d22\u5e74\uff1a%2$s\uff0c\u671f\u95f4\uff1a%3$s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u62d3\u5c55\u7ef4\u9500\u552e\u65b9\u62a5\u8868\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u62d3\u5c55\u7ef4\u62a5\u8868\u6a21\u677f\u7684\u6570\u636e\u3002", (String)"IntrMultiTabReportFillInPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]), intrTmpl.getString("seller.name"), year.getLong("name"), period.getLong("name")));
                return;
            }
            DynamicObject buyExtTemplate = IntrTemplateHelper.getExtTemplate((Long)model.getLong("id"), (Long)intrTmpl.getLong("purchaser.id"), (Long)year.getLong("id"), (Long)period.getLong("id"));
            if (buyExtTemplate == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\uff1a%1$s\uff0c\u8d22\u5e74\uff1a%2$s\uff0c\u671f\u95f4\uff1a%3$s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u62d3\u5c55\u7ef4\u91c7\u8d2d\u65b9\u62a5\u8868\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u62d3\u5c55\u7ef4\u62a5\u8868\u6a21\u677f\u7684\u6570\u636e\u3002", (String)"IntrMultiTabReportFillInPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]), intrTmpl.getString("purchaser.name"), year.getLong("name"), period.getLong("name")));
                return;
            }
            String title = ResManager.loadKDString((String)"\u5408\u5e76\u62a5\u8868\u5185\u90e8\u4ea4\u6613\u5e95\u7a3f\u6d88\u606f\u901a\u77e5", (String)"IntrMultiTabReportFillInPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String contentTemplate = (String)returnData.get("content");
            Boolean isSendSeller = (Boolean)returnData.get("isSendSeller");
            Boolean isSendbuyer = (Boolean)returnData.get("isSendBuyer");
            Set<Pair<String, String>> orgs = this.getIntrOrgs();
            HashMultimap sellMap = HashMultimap.create();
            HashMultimap buyMap = HashMultimap.create();
            for (Pair<String, String> orgPair : orgs) {
                sellMap.put(orgPair.p1, orgPair.p2);
                buyMap.put(orgPair.p2, orgPair.p1);
            }
            String modelNumber = model.getString("number");
            if (isSendSeller.booleanValue()) {
                for (String sellOrg : sellMap.keySet()) {
                    IDNumberTreeNode sellOrgNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)sellOrg);
                    icOrgs = sellMap.get((Object)sellOrg).stream().map(item -> MemberReader.findEntityMemberByNum((String)modelNumber, (String)item).getName()).collect(Collectors.joining(","));
                    content = this.getContent(contentTemplate, sellOrgNode.getName(), sellExtTemplate.getString("name"), year.getString("name"), period.getString("name"), icOrgs);
                    rpt = IntrReportHelper.getExtReport((Long)model.getLong("id"), (Long)sellExtTemplate.getLong("id"), (Long)sellOrgNode.getId(), (Long)scene.getLong("id"), (Long)year.getLong("id"), (Long)period.getLong("id"));
                    if (rpt == null) continue;
                    MessageBcmServiceHelper.sendSystemMessage((String)title, (String)content, (List)Lists.newArrayList((Object[])new Long[]{rpt.getLong("modifier.id")}), (String)(RPT_LINK + rpt.getLong("id")));
                }
            }
            if (isSendbuyer.booleanValue()) {
                for (String buyOrg : buyMap.keySet()) {
                    IDNumberTreeNode buyOrgNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)buyOrg);
                    icOrgs = buyMap.get((Object)buyOrg).stream().map(item -> MemberReader.findEntityMemberByNum((String)modelNumber, (String)item).getName()).collect(Collectors.joining(","));
                    content = this.getContent(contentTemplate, buyOrgNode.getName(), buyExtTemplate.getString("name"), year.getString("name"), period.getString("name"), icOrgs);
                    rpt = IntrReportHelper.getExtReport((Long)model.getLong("id"), (Long)buyExtTemplate.getLong("id"), (Long)buyOrgNode.getId(), (Long)scene.getLong("id"), (Long)year.getLong("id"), (Long)period.getLong("id"));
                    if (rpt == null) continue;
                    MessageBcmServiceHelper.sendSystemMessage((String)title, (String)content, (List)Lists.newArrayList((Object[])new Long[]{rpt.getLong("modifier.id")}), (String)(RPT_LINK + rpt.getLong("id")));
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u901a\u77e5\u53d1\u9001\u6210\u529f\u3002", (String)"IntrMultiTabReportFillInPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u667a\u80fd\u901a\u77e5", "IntrMultiTabReportFillInPlugin_42", "fi-bcm-formplugin", "Smart Notifications"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), ResManager.loadKDString((String)"\u667a\u80fd\u901a\u77e5", (String)"IntrMultiTabReportFillInPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
        }
    }

    private String getContent(String contentTemplate, String mcOrgName, String tmplName, String year, String period, String icOrgName) {
        if (StringUtils.isEmpty((String)contentTemplate)) {
            return contentTemplate;
        }
        Map messageParam = IntrConstant.getMessageParam();
        return contentTemplate.replace((CharSequence)messageParam.get("mcOrg"), this.formateParam(mcOrgName)).replace((CharSequence)messageParam.get("year"), this.formateParam(year)).replace((CharSequence)messageParam.get("period"), this.formateParam(period)).replace((CharSequence)messageParam.get("report"), this.formateParam(tmplName)).replace((CharSequence)messageParam.get("icOrg"), this.formateParam(icOrgName));
    }

    private String formateParam(String str) {
        return String.format("[%s]", str);
    }

    @Override
    protected void handleMenuItem(boolean lockTable) {
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), "report", MapInitHelper.ofMap((Object)"isHide", (Object)false));
        ArrayList<Map> menuItems = new ArrayList<Map>(10);
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.deleteColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.deleteRows, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRows, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertColMany, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowMany, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowOrColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.cols_insertColsLeft, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.colHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.cols_insertColsRight, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.colHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.rows_insertRowsTop, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.rowHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.rows_insertRowsBottom, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.rowHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.sort, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.cellsFormat, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.hideRows, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.rowHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.unhideRows, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.rowHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.hideColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.colHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.unhideColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.WORKAREA.k(), (Object)SpreadProperties.WorkAreaEnum.colHeader, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), this.getSpreadKey(), menuItems);
        SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
        invoker.addContextMenuItem("linkReport", ResManager.loadKDString((String)"\u8054\u67e5\u62a5\u8868", (String)"IntrMultiTabReportFillInPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport"});
        invoker.addContextMenuItem("linkAdjust", ResManager.loadKDString((String)"\u8054\u67e5\u5206\u5f55", (String)"IntrMultiTabReportFillInPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport"});
        invoker.addContextMenuItem("linkHistory", ResManager.loadKDString((String)"\u8054\u67e5\u5386\u53f2", (String)"IntrCslReportFillInPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport"});
        invoker.startToInvoke();
    }

    @Override
    protected void updateTemplateConfig(IntrReportTabInfo tab, SpreadManager spreadManager) {
        SpreadClientInvoker.invokeSetWorkbookOptions(this.getClientViewProxy(), this.getSpreadKey(), MapInitHelper.ofMap((Object)SpreadProperties.SetWorkbookOptions.allowExtendPasteRange.k(), (Object)false));
    }

    @Override
    protected void insertRows(Sheet sheet, int copyIndex, int needtotalrows) {
        int realMaxRowCount = Math.max(sheet.getMaxRowCount(), IntrConstant.TMP_INIT_ROW_COUNT);
        if (needtotalrows > realMaxRowCount) {
            SpreadClientInvoker.invokeBatchInsertRow(this.getClientViewProxy(), this.getSpreadKey(), copyIndex, needtotalrows - realMaxRowCount, true);
        }
    }

    @Override
    protected void afterUpdateSpread(IntrReportTabInfo tab, IntrTable table, SpreadEasyInvoker invoker, Sheet sheet, List<IntrField> head) {
        Pair<Integer, Integer> startPoint = tab.getStartPoint();
        for (IntrField intrField : head) {
            int colIndex = tab.getColIndex(intrField.getNumber());
            if (intrField.isReadOnly() || !StringUtils.isNotEmpty((String)intrField.getShowType())) continue;
            int dst = 1;
            if ("F7".equals(intrField.getShowType())) {
                dst = 0;
            }
            invoker.setF7TypeCell((Integer)startPoint.p1, colIndex, table.getRows().size(), 1, 0, dst);
        }
    }

    @Override
    protected List<IntrRow> getAllRowData(IntrReportTabInfo tab, SpreadManager spreadManager) {
        ArrayList<IntrRow> rows = new ArrayList<IntrRow>(16);
        Sheet sheet = this.getEffectiveSheet(spreadManager);
        Pair<Integer, Integer> point = tab.getStartPoint();
        List<IntrField> mergeFieldList = tab.getFileds();
        Integer rowIndex = (Integer)point.p1;
        int sellIndex = tab.getColIndex(IntrConstant.FIELD_ORG_NUMBER);
        while (true) {
            HashMap<String, Object> row = new HashMap<String, Object>(mergeFieldList.size());
            Object value = sheet.getCell(rowIndex.intValue(), sellIndex).getValue();
            if (value == null || StringUtils.isBlank((String)value.toString())) break;
            for (IntrField intrField : mergeFieldList) {
                String fieldNumber = intrField.getNumber();
                Cell cell = sheet.getCell(rowIndex.intValue(), tab.getColIndex(fieldNumber));
                UserObject userObject = cell.getUserObject();
                if (userObject != null && userObject.containsKey("number")) {
                    row.put(fieldNumber, userObject.get("number"));
                    continue;
                }
                row.put(fieldNumber, cell.getValue());
            }
            rows.add(new IntrRow(row));
            Integer n = rowIndex;
            Integer n2 = rowIndex = Integer.valueOf(rowIndex + 1);
        }
        return rows;
    }

    @Override
    protected boolean validateData() {
        IntrReportTabInfo tab = this.getReportTabInfoManager().getCurrSelectReportTabInfo();
        String modelNumber = MemberReader.findModelNumberById((Object)tab.getModelId());
        Sheet sheet = this.getEffectiveSheet(this.getSpreadModel());
        Pair<Integer, Integer> point = tab.getStartPoint();
        List<IntrField> fileds = tab.getFileds();
        List<IntrField> dimFields = fileds.stream().filter(e -> "F7".equals(e.getShowType())).collect(Collectors.toList());
        int sellIndex = tab.getColIndex(IntrConstant.FIELD_ORG_NUMBER);
        for (int i = ((Integer)point.p1).intValue(); i <= sheet.getMaxRowCount() && !sheet.getCell(i, sellIndex).isNullValue(); ++i) {
            List row = sheet.getRow(i, Boolean.TRUE.booleanValue());
            if (this.validateDim(modelNumber, tab, i, row, dimFields)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    protected boolean isClsReport() {
        return Boolean.FALSE;
    }

    @Override
    protected void extendRowStyle(IntrReportTabInfo tab, Sheet newSheet, List<LinkedHashMap<String, Object>> values) {
    }

    @Override
    protected void afterSaveSubAction() {
        if ("true".equals(this.getPageCache().get(GENERATE_DATA))) {
            this.getPageCache().remove(GENERATE_DATA);
            this.generateData();
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u751f\u6210\u5e95\u7a3f", "IntrMultiTabReportFillInPlugin_13", "fi-bcm-formplugin", "Generate Draft"), OPDescMultiLangEnumBridge.genUnTransBridge((String)this.getLogDescription(this.getReportTabInfoManager().getCurrSelectReportTabInfo(), ResManager.loadKDString((String)"\u751f\u6210\u5e95\u7a3f", (String)"IntrMultiTabReportFillInPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]))));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"IntrMultiTabReportFillInPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }
}

