/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.innertrade.report;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.innertrade.model.IntrMergeParam;
import kd.fi.bcm.business.innertrade.report.IntrReportHelper;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.papertemplate.filterchain.AbstractPaperFilter;
import kd.fi.bcm.business.papertemplate.filterchain.PaperTmplChainFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.SceneFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.StatusFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.VersionFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.YearPeriodFilter;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.business.tree.report.TemplateTreeNode;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.innertrade.IntrReportStatusEnum;
import kd.fi.bcm.common.enums.innertrade.IntrRptGenTypeEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.common.IRefreshList;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.innertrade.report.multi.IntrReportPostmanByTemplate;
import kd.fi.bcm.formplugin.report.IIncreaseReportTab;
import kd.fi.bcm.formplugin.util.FormShowUtil;
import kd.fi.bcm.formplugin.util.OrgUtils;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IntrReportListPlugin
extends AbstractBaseListPlugin
implements TabSelectListener,
TreeNodeClickListener,
IRefreshList {
    private static final String TABINFO_KEY = "tabinfo_key";
    private static final String CACHE_KEY = "cache_key";
    private static final String TREE_KEY = "tree_key";
    private static final String ROWCACHE_KEY = "rowcache_key";
    private static final String FOCUS_KEY = "focus_key";
    private static final String ENTITYSEARCHAP = "entitysearchap";
    private static final String TEMPLATESEARCHAP = "templatesearchap";
    private static final String treeview_entity = "treeview_entity";
    private static final String treeview_template = "treeview_template";
    private static final String cache_treeorg = "cache_treeentity";
    private static final String cache_treetemplate = "cache_treetemplate";
    private static final String tabap = "tabap";
    private static final String tabpageap_entity = "tabpageap_entity";
    private static final String tabpageap_template = "tabpageap_template";
    private static final String allsubordinate = "alllevel";
    private static final String directLevel = "directlevel";
    private static final String billlistap = "billlistap";
    private static final String selectorgs = "selectorgs";
    private static final String showorgtype_cache = "showorgtype";
    private static final String showtmptype_cache = "showtmptype";
    private static final String TABINFO_ORG = "orgTabInfo";
    private static final String TABINFO_TEMP = "tempTabInfo";
    private static final String btn_complete = "baritemap_ok";
    private static final String btn_cancel = "baritemap_cancel";
    private static final String btn_commit = "baritemap_submit";
    private static final String btn_sendback = "baritemap_return";
    private static final String btn_genadjust = "btn_genadjust";
    private static final String btn_refresh = "baritemap_refresh";
    private static final String btn_periodcopy = "btn_periodcopy";
    private static final String btn_multiexport = "btn_multiexport";
    private static final String model = "model";
    private static final String currency = "currency";
    private static final Set<String> dimKeys = Sets.newHashSet((Object[])new String[]{"scenario", "year", "period", "currency"});
    private static final String modelf7id = "modelf7id";
    private static final String scenariof7id = "scenariof7id";
    private static final String yearf7id = "yearf7id";
    private static final String periodf7id = "periodf7id";
    private static final String currencyf7id = "currencyf7id";
    private static final String modelCacheKey = "KEY_MODEL_ID";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String ID = "id";
    private static final String ctl_cslscheme = "cslscheme";
    private static final String entryentity = "entryentity";
    protected static final String ROWLLIST = "llist";
    protected static final String LFOCUS = "lfocus";
    protected static final String ROWRLIST = "rlist";
    protected static final String RFOCUS = "rfocus";
    private static final String treeview_id_cache = "treeEntity";
    public static final String PREFIX_TEMPLETE = "Innertrade_Template_";
    public static final String CATALOG_PERM_MAP = "catalogPermMap";
    public static final String TMPL_PERM_MAP = "tmplPermMap";
    public static final String READ_ONLY_TMPL_MAP = "readOnlyTmplMap";
    public static final String btn_reset = "btn_reset";
    private static final String RESET_TABLE = "reset_table";
    private static final Set<String> PERIOD_CHECK_BTNS = Sets.newHashSet((Object[])new String[]{"baritemap_ok", "baritemap_cancel", "baritemap_submit", "baritemap_return", "btn_genadjust", "btn_reset"});
    public static final String CATALOG_NOPERM_IDSET = "catalog_noperm_idset";
    public static final String TMPL_NOPERM_IDSET = "tmpl_noperm_idset";
    Set<IntrReportStatusEnum> RESET_STATUS = Sets.newHashSet((Object[])new IntrReportStatusEnum[]{IntrReportStatusEnum.UNWEAVE, IntrReportStatusEnum.EDITING, IntrReportStatusEnum.REJECTED});
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(IntrReportListPlugin.class);

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(new ArrayList<String>(dimKeys), SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(tabap);
        tab.addItemClickListener((ItemClickListener)this);
        tab.addTabSelectListener((TabSelectListener)this);
        TreeView orgTreeView = (TreeView)this.getControl(treeview_entity);
        orgTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView templateTreeView = (TreeView)this.getControl(treeview_template);
        templateTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners("searchbefore", "searchnext", "searchbefore1", "searchnext1");
        this.addSearchEnterListener(ENTITYSEARCHAP);
        this.addSearchEnterListener(TEMPLATESEARCHAP);
        EntryGrid eg = (EntryGrid)this.getControl(entryentity);
        eg.addHyperClickListener(this::hyperLinkClick);
        eg.addPagerClickListener(pagerClickEvent -> this.refreshEntryEntityList());
        BasedataEdit csl = (BasedataEdit)this.getControl(ctl_cslscheme);
        csl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cur = (BasedataEdit)this.getControl(currency);
        cur.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void addSearchEnterListener(String searchKey) {
        Search sl = (Search)this.getControl(searchKey);
        String temp = null;
        boolean isOrg = false;
        switch (searchKey) {
            case "entitysearchap": {
                temp = ROWLLIST;
                isOrg = true;
                break;
            }
            case "templatesearchap": {
                temp = ROWRLIST;
                break;
            }
        }
        final String finalTemp = temp;
        final boolean finalIsOrg = isOrg;
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                IntrReportListPlugin.this.getPageCache().put("searchValue", event.getText());
                if (event.getText() != null && !"".equals(event.getText())) {
                    IntrReportListPlugin.this.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim(), finalIsOrg);
                } else {
                    IntrReportListPlugin.this.getPageCache().put(finalTemp, null);
                    IntrReportListPlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        String f7Key = event.getProperty().getName();
        if (ctl_cslscheme.equals(f7Key)) {
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            QFilter qf = new QFilter(NUMBER, "!=", (Object)"DefaultRateScheme");
            listShowParameter.getListFilterParameter().setFilter(qf);
        }
        if (DimTypesEnum.CURRENCY.getNumber().equalsIgnoreCase(event.getProperty().getName())) {
            event.setCustomQFilters((List)Lists.newArrayList((Object[])new QFilter[]{new QFilter(NUMBER, "not in", (Object)IntrConstant.CURRENCYNUM).and(new QFilter("isleaf", "=", (Object)Boolean.TRUE))}));
        }
    }

    @Override
    public void setSingleF7Filter(BasedataEditSingleMemberF7 bdEdit) {
        super.setSingleF7Filter(bdEdit);
        if (DimTypesEnum.PERIOD.getNumber().equalsIgnoreCase(bdEdit.getDimNumber())) {
            Set<Long> range = this.getPeriodMemberByRange();
            QFilter qf = new QFilter(ID, "in", (Object)range.toArray());
            bdEdit.setCustomFilter(qf);
        } else if (DimTypesEnum.CURRENCY.getNumber().equalsIgnoreCase(bdEdit.getDimNumber())) {
            QFilter qf = new QFilter(NUMBER, "not in", (Object)IntrConstant.CURRENCYNUM).and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            bdEdit.setCustomFilter(qf);
        }
    }

    private Set<Long> getPeriodMemberByRange() {
        HashSet<Long> pk = new HashSet<Long>(12);
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("scenario");
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f!", (String)"AbstractMultiReportPlugin_149", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Long id = dynamicObject.getLong(ID);
        DynamicObjectCollection col = (DynamicObjectCollection)BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"id,sceneperiod", (QFilter[])new QFBuilder(ID, "=", (Object)id).toArray()).get("sceneperiod");
        if (col != null) {
            col.forEach(e -> pk.add(e.getDynamicObject("fbasedataid").getLong(ID)));
        }
        return pk;
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("searchbefore".equals(key) || "searchnext".equals(key) || "searchbefore1".equals(key) || "searchnext1".equals(key)) {
            int rowCount = 0;
            String currentTab = "";
            if ("searchbefore".equals(key) || "searchnext".equals(key)) {
                currentTab = tabpageap_entity;
            } else if ("searchbefore1".equals(key) || "searchnext1".equals(key)) {
                currentTab = tabpageap_template;
            }
            Map<String, String> tabMap = this.getTabMap(currentTab);
            if (tabMap == null || tabMap.isEmpty()) {
                return;
            }
            TreeView treeView = (TreeView)this.getControl(tabMap.get(TREE_KEY));
            TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)tabMap.get(CACHE_KEY));
            String rowcache = this.getPageCache().get(tabMap.get(ROWCACHE_KEY));
            String count = this.getPageCache().get(tabMap.get(FOCUS_KEY));
            if (count != null) {
                rowCount = Integer.parseInt(count);
            }
            if (rowcache == null) {
                this.getView().showTipNotification(MessageConstant.getNO_DATA());
                return;
            }
            if (this.getPageCache().get("searchValue") == null && "".equals(this.getPageCache().get("searchValue"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"ReportListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            List rowList = (List)SerializationUtils.fromJsonString((String)rowcache, List.class);
            if ("searchbefore".equals(key) || "searchbefore1".equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"ReportListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                --rowCount;
            } else if ("searchnext".equals(key) || "searchnext1".equals(key)) {
                if (rowList.size() - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"ReportListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ++rowCount;
            }
            if (!ObjectUtils.isEmpty(rowList.get(rowCount))) {
                String focusnode = String.valueOf(rowList.get(rowCount));
                this.getPageCache().put(tabMap.get(FOCUS_KEY), String.valueOf(rowCount));
                ITreeNode parent = treeModel.searchByNodeId(focusnode).getParent();
                String parentId = parent == null ? null : parent.getId();
                treeView.focusNode(new TreeNode(parentId, focusnode, ""));
                treeView.treeNodeClick(parentId, focusnode);
                while (parentId != null) {
                    String temp = parentId;
                    treeView.expand(temp);
                    if (treeModel.searchByNodeId(temp).getParent() == null) break;
                    parentId = treeModel.searchByNodeId(temp).getParent().getId();
                }
            }
        }
    }

    private Set<Long> getOrgRange() {
        HashSet<Long> orgRange = new HashSet<Long>();
        String scope_cache = (String)this.getValue("combofield");
        TabInfo orgTabInfo = this.getTabInfo(TABINFO_ORG);
        long selectOrgId = orgTabInfo.id;
        IDNumberTreeNode selectOrgTreeNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)selectOrgId);
        if ("Entity".equals(selectOrgTreeNode.getNumber())) {
            return orgRange;
        }
        if (StringUtil.equals((String)"me", (String)scope_cache)) {
            orgRange.add(selectOrgId);
            return orgRange;
        }
        TreeModel tm = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)cache_treeorg);
        OrgTreeNode root = (OrgTreeNode)tm.getRoot();
        ITreeNode treeNode = root.getTreeNode(selectOrgId + "", 99);
        if (allsubordinate.equals(scope_cache) && treeNode != null) {
            this.getAllChildren((ITreeNode<Object>)treeNode, orgRange);
        }
        return orgRange;
    }

    public void getAllChildren(ITreeNode<Object> root, Set<Long> set) {
        root.iterate(999, v -> {
            set.add(ConvertUtil.convertStrToLong((String)v.getId()));
            if (!v.isLeaf()) {
                List children = v.getChildren();
                for (ITreeNode child : children) {
                    set.add(ConvertUtil.convertStrToLong((String)child.getId()));
                }
            }
        });
    }

    public void tabSelected(TabSelectEvent arg0) {
        String currentTab = arg0.getTabKey();
        this.getPageCache().put("tabSelected", currentTab);
        if (tabpageap_entity.equals(currentTab)) {
            Label orgLabel = (Label)this.getView().getControl("templatelabel");
            String tempMessage = ResManager.loadKDString((String)"\u6a21\u677f\uff1a", (String)"ReportListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            orgLabel.setText(tempMessage + this.getTabInfo(TABINFO_TEMP).name);
            this.getPageCache().put(treeview_id_cache, treeview_entity);
        } else if (tabpageap_template.equals(currentTab)) {
            Label orgLabel = (Label)this.getView().getControl("orglabel");
            orgLabel.setText(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s", (String)"ReportListPlugin_113", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getTabInfo(TABINFO_ORG).name));
            this.getPageCache().put(treeview_id_cache, treeview_template);
        }
        this.refreshTree(null);
    }

    public TabInfo getTabInfo(String tabKey) {
        String tabCache = this.getPageCache().get(tabKey);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)tabCache)) {
            return (TabInfo)SerializationUtils.fromJsonString((String)tabCache, TabInfo.class);
        }
        return new TabInfo();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().deleteEntryData(entryentity);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), model);
        if (kd.bos.util.StringUtils.isEmpty((String)modelId)) {
            this.getPageCache().put(modelCacheKey, null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f53\u7cfb\u53ef\u4ee5\u4f7f\u7528\u3002", (String)"ReportListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.refreshBillByUserSelect(new ArrayList<String>(dimKeys), false);
        this.initCslschemeValue(modelId, false);
        if (!this.dealCurrencyF7()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6ca1\u6709\u9ed8\u8ba4\u5e01, \u8bf7\u5347\u7ea7\u4f53\u7cfb\u3002", (String)"ReportListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        modelId = this.getPageCache().get(modelCacheKey);
        this.cacheAllPermMap();
        String showOrgType = this.getModel().getValue(showorgtype_cache).toString();
        this.getPageCache().put(showorgtype_cache, showOrgType);
        String showtmptype = (String)this.getModel().getValue(showtmptype_cache);
        this.getPageCache().put(showtmptype_cache, showtmptype);
        this.getPageCache().put(treeview_id_cache, treeview_entity);
        if (this.checkDimOfUserSelected(false)) {
            String currentTab = this.getPageCache().get("tabSelected");
            if (currentTab == null) {
                Tab tab = (Tab)this.getControl(tabap);
                currentTab = tab.getCurrentTab();
                this.getPageCache().put("tabSelected", currentTab);
                this.getPageCache().put(treeview_id_cache, this.getTabMap(currentTab).get(TREE_KEY));
            }
            this.refreshNoSelectedTabTreeCache(tabpageap_entity);
            this.refreshNoSelectedTabTreeCache(tabpageap_template);
            this.refreshEntryEntityList();
        }
        this.checkGradeOrgScheme();
    }

    private void refreshAllTreeAndBill(boolean resetSelected) {
        this.getPageCache().remove(selectorgs);
        this.getPageCache().remove(cache_treetemplate);
        this.getPageCache().remove(cache_treeorg);
        this.getPageCache().remove(TABINFO_TEMP);
        this.getPageCache().remove(TABINFO_ORG);
        if (resetSelected) {
            this.getPageCache().remove(showorgtype_cache);
            this.getPageCache().remove("entityselectedNodeId");
            this.getPageCache().remove("templateselectedNodeId");
            this.getModel().beginInit();
            this.getModel().setValue("combofield", (Object)"me");
            this.getModel().setValue(showorgtype_cache, (Object)4);
            this.getModel().endInit();
        }
        this.getView().updateView("combofield");
        this.getView().updateView(showorgtype_cache);
        this.getView().updateView("flexpanelap24");
        TreeView tree = (TreeView)this.getControl(treeview_entity);
        tree.deleteAllNodes();
        TreeView tree2 = (TreeView)this.getControl(treeview_template);
        tree2.deleteAllNodes();
        if (this.checkDimOfUserSelected(false)) {
            this.buildLeftTree(tabpageap_entity);
            this.buildLeftTree(tabpageap_template);
        }
        this.refreshEntryEntityList();
    }

    private void refreshNoSelectedTabTreeCache(String currentTab) {
        AbstractTreeNode<Object> root = this.buildTreeCache(currentTab);
        if (root != null) {
            this.cacheTabInfo(root, currentTab);
            this.initTree(root, currentTab);
        }
    }

    private void cacheTabInfo(AbstractTreeNode<Object> root, String cacheTab) {
        TreeNode treeNode = this.findCacheNode(root, cacheTab);
        String cacheTabinfo = this.getTabMap(cacheTab).get(TABINFO_KEY);
        TabInfo tabInfo = this.getTabInfo(cacheTab);
        if (!treeNode.getId().equals("root")) {
            tabInfo.id = Long.parseLong(treeNode.getId());
            tabInfo.name = treeNode.getText();
            try {
                this.getPageCache().put(cacheTabinfo, SerializationUtils.toJsonString((Object)tabInfo));
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
    }

    private boolean dealCurrencyF7() {
        boolean dealStatus = true;
        QFilter qf = QFilter.of((String)"model =? and dimension.number=? and number=?", (Object[])new Object[]{this.getModelId(), DimTypesEnum.CURRENCY.getNumber(), "DC"});
        DynamicObject cur = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)ID, (QFilter[])new QFilter[]{qf});
        if (cur == null) {
            dealStatus = false;
        }
        return dealStatus;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (PERIOD_CHECK_BTNS.contains(itemKey)) {
            this.checkOrgPeriodOpen();
        }
        switch (itemKey) {
            case "baritemap_ok": {
                this.updateRptStatus(IntrReportStatusEnum.COMPLETE);
                break;
            }
            case "baritemap_cancel": {
                this.updateRptStatus(IntrReportStatusEnum.EDITING);
                break;
            }
            case "baritemap_submit": {
                this.updateRptStatus(IntrReportStatusEnum.REPORTED);
                break;
            }
            case "baritemap_return": {
                this.updateRptStatus(IntrReportStatusEnum.REJECTED);
                break;
            }
            case "btn_genadjust": {
                this.showAdjustProcessView();
                break;
            }
            case "btn_reset": {
                this.showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u662f\u5426\u6e05\u7a7a\u5e95\u7a3f\u6570\u636e\uff0c\u5e76\u5c06\u5e95\u7a3f\u7f16\u5236\u72b6\u6001\u91cd\u7f6e\u4e3a\u672a\u7f16\u5236\uff1f", (String)"IntrReportListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), RESET_TABLE);
                break;
            }
            case "baritemap_refresh": {
                this.refreshAllTreeAndBill(false);
                break;
            }
            case "btn_periodcopy": {
                this.getSelecteTmplOrgs();
                this.showPeriodCopyView();
                break;
            }
            case "btn_multiexport": {
                this.showMultiBatchExportView();
                break;
            }
        }
    }

    public void showMultiBatchExportView() {
        DynamicObject cslSchemeDy = (DynamicObject)this.getModel().getValue(ctl_cslscheme);
        DynamicObject sceneDy = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject yearDy = (DynamicObject)this.getModel().getValue("year");
        DynamicObject periodDy = (DynamicObject)this.getModel().getValue("period");
        DynamicObject cyDy = (DynamicObject)this.getModel().getValue(currency);
        if (sceneDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60c5\u666f", (String)"ReportListPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter fm = new FormShowParameter();
        fm.setParentFormId(this.getView().getFormShowParameter().getFormId());
        fm.setFormId("bcm_intrmutilexport");
        fm.setCustomParam(modelCacheKey, (Object)this.getModelId());
        fm.setCustomParam(ctl_cslscheme, (Object)(cslSchemeDy == null ? 0L : cslSchemeDy.getLong(ID)));
        fm.setCustomParam("scenario", (Object)sceneDy.getLong(ID));
        fm.setCustomParam("year", (Object)(yearDy == null ? 0L : yearDy.getLong(ID)));
        fm.setCustomParam("period", (Object)(periodDy == null ? 0L : periodDy.getLong(ID)));
        fm.setCustomParam(currency, (Object)(cyDy == null ? 0L : cyDy.getLong(ID)));
        DynamicObjectCollection entryData = this.getModel().getEntryEntity(entryentity);
        HashSet<Long> selectTmps = new HashSet<Long>(16);
        HashSet<Long> selectOrgs = new HashSet<Long>(16);
        EntryGrid eg = (EntryGrid)this.getControl(entryentity);
        int[] selectRows = eg.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject rowData = (DynamicObject)entryData.get(selectRows[i]);
                selectTmps.add(rowData.getLong("templateid"));
                selectOrgs.add(rowData.getLong("entityrealid"));
            }
        }
        if (!CollectionUtils.isEmpty(selectTmps)) {
            fm.setCustomParam("selecttemplate", (Object)selectTmps.toArray());
        }
        if (CollectionUtils.isEmpty(selectOrgs)) {
            String orgId = this.getPageCache().get("entityselectedNodeId");
            if (orgId != null && orgId.equals("root")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e0d\u53ef\u9009\u62e9root\u6839\u8282\u70b9\u3002", (String)"ReportListPlugin_84", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)orgId)) {
                fm.setCustomParam("org", (Object)new Long[]{Long.valueOf(orgId)});
            }
        } else {
            fm.setCustomParam("org", (Object)selectOrgs.toArray());
        }
        fm.setStatus(OperationStatus.EDIT);
        fm.setParentPageId(this.getView().getPageId());
        fm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(fm);
    }

    private void showPeriodCopyView() {
        DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject dyYear = (DynamicObject)this.getModel().getValue("year");
        DynamicObject dyPeriod = (DynamicObject)this.getModel().getValue("period");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_intrreportcopy");
        String title = String.format(ResManager.loadKDString((String)"\u4ece\u5176\u4ed6\u671f\u95f4\u590d\u5236\u5230%1$s%2$s", (String)"IntrReportListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dyYear.getString(NAME), dyPeriod.getString(NAME));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(model, this.getModelId());
        paramMap.put("scenario", scenario.getLong(ID));
        paramMap.put("year", dyYear.getLong(ID));
        paramMap.put("period", dyPeriod.getLong(ID));
        FormShowUtil.openDynamicPage(this.getView(), title, "bcm_intrreportcopy", paramMap, new CloseCallBack((IFormPlugin)this, "intrreportcopy"));
    }

    private void showAdjustProcessView() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_intradjustprocess");
        param.getOpenStyle().setShowType(ShowType.Modal);
        if (this.getView().getParentView() != null) {
            param.setRootPageId(this.getView().getParentView().getPageId());
        }
        param.setCaption(ResManager.loadKDString((String)"\u751f\u6210\u5206\u5f55", (String)"IntrReportListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        param.setCustomParam(modelCacheKey, (Object)this.getModelId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "generate_adjust");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionKey = evt.getActionId();
        Object returnData = evt.getReturnData();
        if ("intrreportcopy".equals(actionKey)) {
            this.copyIntrReport(returnData);
        }
        if ("generate_adjust".equals(actionKey) && returnData != null) {
            this.generateAdjust((List)returnData);
        }
        if ("taskcloseback".equals(actionKey)) {
            this.taskCompleteCallback(evt);
        }
    }

    public void taskCompleteCallback(ClosedCallBackEvent e) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Object returnData;
        Map result;
        if (e.getReturnData() != null && (result = (Map)(returnData = e.getReturnData())).containsKey("taskinfo") && kd.bos.util.StringUtils.isNotEmpty((String)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            JSONObject dataObj = (JSONObject)JSONObject.parse((String)data);
            String message = (String)dataObj.get((Object)"message");
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ec5\u5df2\u4e0a\u62a5\u72b6\u6001\u7684\u62b5\u9500\u5e95\u7a3f\u53ef\u751f\u6210\u5206\u5f55\uff0c\u751f\u6210\u5206\u5f55\u7ed3\u679c\uff1a", (String)"IntrReportListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), message, MessageTypes.Commit);
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u751f\u6210\u5206\u5f55", "IntrReportListPlugin_16", "fi-bcm-formplugin", "Generate Entries"), this.getLogDescriptionMsg(message));
        }
    }

    private void copyIntrReport(Object returnData) {
        if (returnData == null) {
            return;
        }
        Map param = (Map)returnData;
        HashMap<String, Long> f7IdMap = this.getF7id();
        if (f7IdMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5168\u641c\u7d22\u6761\u4ef6\u3002", (String)"IntrReportListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Multimap<Pair<Long, Long>, IDNumberTreeNode> tmplOrgs = this.checkAndGetTmplOrgs(param);
        IntrReportHelper.copyRptData((long)this.getModelId(), (long)RequestContext.get().getCurrUserId(), (Long)((Long)f7IdMap.get(scenariof7id)), (Long)((Long)f7IdMap.get(yearf7id)), (Long)((Long)f7IdMap.get(periodf7id)), (Long)Long.valueOf((String)param.get("yearId")), (Long)Long.valueOf((String)param.get("periodId")), tmplOrgs);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u7ec4\u7ec7\u548c\u6a21\u677f\u5bf9\u5e94\u7684\u672c\u5e01\u4f4d\u5e95\u7a3f\u6570\u636e\u5df2\u7ecf\u590d\u5236\u6210\u529f\uff0c\u8bf7\u5728\u5e95\u7a3f\u7f16\u5236\u4e2d\u8fdb\u884c\u6570\u636e\u67e5\u770b\u3002", (String)"IntrReportListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
        IDNumberTreeNode sourceYearNode = MemberReader.findFyMemberById((String)modelNumber, (Long)Long.valueOf((String)param.get("yearId")));
        IDNumberTreeNode sourcePeriodNode = MemberReader.findPeriodMemberById((String)modelNumber, (Long)Long.valueOf((String)param.get("periodId")));
        IDNumberTreeNode targetYearNode = MemberReader.findFyMemberById((String)modelNumber, (Long)((Long)f7IdMap.get(yearf7id)));
        IDNumberTreeNode targetPeriodNode = MemberReader.findPeriodMemberById((String)modelNumber, (Long)((Long)f7IdMap.get(periodf7id)));
        for (Pair tmplPair : tmplOrgs.keySet()) {
            DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)tmplPair.p1, (String)"bcm_papertemplate", (String)"id, number");
            String orgNumbers = tmplOrgs.get((Object)tmplPair).stream().map(IDNumberTreeNode::getNumber).collect(Collectors.joining(","));
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4ece\u5176\u4ed6\u671f\u95f4\u590d\u5236", "IntrReportListPlugin_35", "fi-bcm-formplugin", "Copy other period"), new OPDescMultiLangEnumBridge("\u6a21\u677f\u7f16\u7801\uff08%1$s\uff09\uff0c\u4ece%2$s%3$s\u590d\u5236\u6570\u636e\u5230%4$s%5$s\uff0c\u7ec4\u7ec7\u7f16\u7801\uff08%6$s\uff09\uff0c\u590d\u5236\u6210\u529f\u3002", "IntrReportListPlugin_36", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{dyn.getString(NUMBER), sourceYearNode.getName(), sourcePeriodNode.getName(), targetYearNode.getName(), targetPeriodNode.getName(), orgNumbers})));
        }
    }

    private Multimap<Pair<Long, Long>, IDNumberTreeNode> checkAndGetTmplOrgs(Map<String, String> param) {
        ArrayListMultimap result = ArrayListMultimap.create();
        HashMap<String, Long> f7IdMap = this.getF7id();
        if (f7IdMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5168\u641c\u7d22\u6761\u4ef6\u3002", (String)"IntrReportListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.checkOrgPeriodOpen();
        String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
        Multimap<Long, Long> tmplOrgs = this.getSelecteTmplOrgs();
        Set tmplIds = tmplOrgs.keySet();
        Map tplIdByVersioned = IntrTemplateHelper.getRightTplIdByVersioned((Long)this.getModelId(), (Long)Long.valueOf(param.get("yearId")), (Long)Long.valueOf(param.get("periodId")), (Set)tmplIds);
        Set versionKeySets = tplIdByVersioned.keySet();
        if (tmplIds.size() != versionKeySets.size()) {
            tmplIds.removeAll(versionKeySets);
            QFBuilder qfBuilder = new QFBuilder(model, "=", (Object)this.getModelId());
            qfBuilder.and(ID, "in", (Object)tmplIds);
            String versionNumbers = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,number", (QFilter[])qfBuilder.toArray()).stream().map(item -> item.getString(NUMBER)).collect(Collectors.joining(","));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e95\u7a3f\u6a21\u677f\u3010%s\u3011\u5728\u6570\u636e\u6765\u6e90\u7684\u671f\u95f4\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7248\u672c\u7684\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"IntrReportListPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]), versionNumbers));
        }
        HashSet<Long> distinctOrgs = new HashSet<Long>(16);
        for (Long tmplId : tmplIds) {
            Collection orgs = tmplOrgs.get((Object)tmplId);
            for (Long orgId : orgs) {
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)modelNumber, (Long)orgId);
                Long baseOrgId = orgNode.getBaseTreeNode().getId();
                if (distinctOrgs.add(orgId) && this.checkReadOnly(baseOrgId, tmplId)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%s\u3011\u60a8\u53ea\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"IntrReportListPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNode.getNumber()));
                }
                DynamicObject report = IntrReportHelper.getReportBaseInfo((Long)this.getModelId(), (Long)tmplId, (Long)baseOrgId, (Long)((Long)f7IdMap.get(scenariof7id)), (Long)((Long)f7IdMap.get(yearf7id)), (Long)((Long)f7IdMap.get(periodf7id)), (Long)MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)orgNode.getCurrency()).getId());
                if (report != null && IntrReportStatusEnum.COMPLETE.value.equals(report.getString("reportstatus"))) {
                    DynamicObject tmplInfo = IntrTemplateHelper.getTemplateInfo((Long)this.getModelId(), (Long)tmplId);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011\uff0c\u6a21\u677f\u3010%2$s\u3011\u5728\u5f53\u524d\u7684\u671f\u95f4\u5df2\u5b8c\u6210\u7f16\u5236\uff0c\u4e0d\u80fd\u8fdb\u884c\u6570\u636e\u590d\u5236\u3002", (String)"IntrReportListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNode.getNumber(), tmplInfo.getString(NUMBER)));
                }
                if (report != null && IntrReportStatusEnum.REPORTED.value.equals(report.getString("reportstatus"))) {
                    DynamicObject tmplInfo = IntrTemplateHelper.getTemplateInfo((Long)this.getModelId(), (Long)tmplId);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011\uff0c\u6a21\u677f\u3010%2$s\u3011\u5728\u5f53\u524d\u7684\u671f\u95f4\u5df2\u4e0a\u62a5\uff0c\u4e0d\u80fd\u8fdb\u884c\u6570\u636e\u590d\u5236\u3002", (String)"IntrReportListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNode.getNumber(), tmplInfo.getString(NUMBER)));
                }
                result.put((Object)Pair.onePair(tplIdByVersioned.get(tmplId), (Object)tmplId), (Object)orgNode);
            }
        }
        return result;
    }

    private Multimap<Long, Long> getSelecteTmplOrgs() {
        DynamicObjectCollection entryData = this.getModel().getEntryEntity(entryentity);
        EntryGrid eg = (EntryGrid)this.getControl(entryentity);
        int[] selectRows = eg.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"IntrReportListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        ArrayListMultimap result = ArrayListMultimap.create();
        String usageStr = ResManager.loadKDString((String)"\u5408\u5e76", (String)"IntrReportListPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        for (int i : selectRows) {
            DynamicObject rowData = (DynamicObject)entryData.get(i);
            if (usageStr.equals(rowData.getString("templateusage"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u662f\u5408\u5e76\u7c7b\u578b\u7684\u6a21\u677f\uff0c\u4e0d\u80fd\u4f7f\u7528\u201d\u4ece\u5176\u4ed6\u671f\u95f4\u590d\u5236\u201c\u529f\u80fd\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"IntrReportListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]), rowData.getString("templatenumber")));
            }
            result.put((Object)rowData.getLong("templateid"), (Object)rowData.getLong("entityrealid"));
        }
        return result;
    }

    private void resetTable() {
        Map<Long, Map<IntrReportStatusEnum, Set<FourTuple<Long, String, String, Long>>>> orgreportStatus = this.getReportStatus();
        Set unweaveRpts = orgreportStatus.values().stream().flatMap(m -> ((Set)m.get(IntrReportStatusEnum.UNWEAVE)).stream()).collect(Collectors.toSet());
        Set editingRpts = orgreportStatus.values().stream().flatMap(m -> ((Set)m.get(IntrReportStatusEnum.EDITING)).stream()).collect(Collectors.toSet());
        Set rejectedRpts = orgreportStatus.values().stream().flatMap(m -> ((Set)m.get(IntrReportStatusEnum.REJECTED)).stream()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(unweaveRpts) && CollectionUtils.isEmpty(editingRpts) && CollectionUtils.isEmpty(rejectedRpts)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u672a\u7f16\u5236\u3001\u7f16\u5236\u4e2d\u6216\u5df2\u6253\u56de\u72b6\u6001\u7684\u5e95\u7a3f\u5141\u8bb8\u8fdb\u884c\u6574\u8868\u91cd\u7f6e\u3002", (String)"IntrReportListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder message = new StringBuilder(16);
        orgreportStatus.forEach((orgid, reportStatus) -> {
            IDNumberTreeNode numberTreeNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)orgid);
            String orgInfo = numberTreeNode.getNumber() + " " + numberTreeNode.getName() + " ";
            for (Map.Entry kv : reportStatus.entrySet()) {
                if (this.RESET_STATUS.contains(kv.getKey())) {
                    for (FourTuple data : (Set)kv.getValue()) {
                        if (!this.checkReadOnly((Long)orgid, (Long)data.item1)) {
                            IntrReportHelper.resetTable((IntrMergeParam)this.getIntrParam((Long)data.item1, (Long)orgid));
                            message.append(orgInfo).append((String)data.item2).append(" ").append((String)data.item3).append("\uff1a").append(ResManager.loadKDString((String)"\u6574\u8868\u91cd\u7f6e\u6210\u529f\u3002", (String)"IntrReportListPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
                            continue;
                        }
                        message.append(orgInfo).append((String)data.item2).append(" ").append((String)data.item3).append("\uff1a").append(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9\u8be5\u5e95\u7a3f\u4e3a\u53ea\u8bfb\u6743\u9650\u3002", (String)"IntrReportListPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
                    }
                    continue;
                }
                for (FourTuple data : (Set)kv.getValue()) {
                    message.append(orgInfo).append((String)data.item2).append(" ").append((String)data.item3).append("\uff1a").append(ResManager.loadKDString((String)"\u6574\u8868\u91cd\u7f6e\u5931\u8d25\u3002", (String)"IntrReportListPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
                }
            }
        });
        this.getView().showMessage(ResManager.loadKDString((String)"\u4ec5\u672a\u7f16\u5236\u3001\u7f16\u5236\u4e2d\u6216\u5df2\u6253\u56de\u72b6\u6001\u7684\u5e95\u7a3f\u5141\u8bb8\u8fdb\u884c\u6574\u8868\u91cd\u7f6e\uff0c\u6574\u8868\u91cd\u7f6e\u7ed3\u679c\uff1a", (String)"IntrReportListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), message.toString(), MessageTypes.Commit);
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6574\u8868\u91cd\u7f6e", "IntrReportListPlugin_20", "fi-bcm-formplugin", "Reset Table"), this.getLogDescriptionMsg(message.toString()));
        this.refreshEntryEntityList();
    }

    protected void showConfirm(String msg, String callBackId) {
        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
    }

    private IntrMergeParam getIntrParam(Long templateId, Long orgid) {
        DynamicObject model = (DynamicObject)this.getModel().getValue(model);
        IDNumberTreeNode entity = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)orgid);
        DynamicObject Scenario = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject year = (DynamicObject)this.getModel().getValue("year");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        DynamicObject currency = (DynamicObject)this.getModel().getValue(currency);
        IntrMergeParam param = new IntrMergeParam(new Pair((Object)model.getLong(ID), (Object)model.getString("shownumber")), templateId, new Tuple((Object)entity.getId(), (Object)entity.getNumber(), (Object)entity.getLongNumber()), new Pair((Object)Scenario.getLong(ID), (Object)Scenario.getString(NUMBER)), new Pair((Object)year.getLong(ID), (Object)year.getString(NUMBER)), new Pair((Object)period.getLong(ID), (Object)period.getString(NUMBER)), new Pair((Object)currency.getLong(ID), (Object)currency.getString(NUMBER)));
        param.setModelNumber(model.getString(NUMBER));
        return param;
    }

    private void checkOrgPeriodOpen() {
        DynamicObjectCollection entryData = this.getModel().getEntryEntity(entryentity);
        EntryGrid eg = (EntryGrid)this.getControl(entryentity);
        int[] selectRows = eg.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"IntrReportListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Long> f7Map = this.getF7id();
        if (f7Map == null || f7Map.get(modelf7id) == null || f7Map.get(scenariof7id) == null || f7Map.get(yearf7id) == null || f7Map.get(periodf7id) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5168\u641c\u7d22\u6761\u4ef6\u3002", (String)"IntrReportListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject sceneDyn = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject yearDyn = (DynamicObject)this.getModel().getValue("year");
        DynamicObject periodDyn = (DynamicObject)this.getModel().getValue("period");
        if (LockScopeServiceHelper.isExistArchiving((long)((Long)f7Map.get(modelf7id)), (String)sceneDyn.getString(NUMBER), (String)yearDyn.getString(NUMBER), (String)periodDyn.getString(NUMBER))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u8d22\u5e74\u671f\u95f4%1$s_%2$s_%3$s\u7684\u5206\u9636\u6bb5\u9501\u5b9a\u5df2\u5728\u667a\u80fd\u5408\u5e76\u5f52\u6863\uff0c\u8bf7\u53cd\u5f52\u6863\u540e\u518d\u64cd\u4f5c\u3002", (String)"IntrReportListPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sceneDyn.getString(NUMBER), yearDyn.getString(NUMBER), periodDyn.getString(NUMBER)));
        }
        boolean periodManage = ConfigServiceHelper.getBoolParam((Long)((Long)f7Map.get(modelf7id)), (String)"CM012");
        if (periodManage) {
            HashSet<String> orgNumbers = new HashSet<String>(16);
            for (int i : selectRows) {
                DynamicObject rowData = (DynamicObject)entryData.get(i);
                orgNumbers.add(rowData.getString("entitynumber"));
            }
            Set statusOpen = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)((Long)f7Map.get(modelf7id)), orgNumbers, (Long)((Long)f7Map.get(scenariof7id)), (Long)((Long)f7Map.get(yearf7id)), (Long)((Long)f7Map.get(periodf7id)), (String)"datastatus");
            if (statusOpen.size() != orgNumbers.size()) {
                orgNumbers.removeIf(statusOpen::contains);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\"%s\"\u6ca1\u6709\u6253\u5f00\u6570\u636e\u671f\u95f4\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"IntrReportListPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", orgNumbers)));
            }
        }
    }

    private void generateAdjust(List<Long> processIds) {
        Map<Long, Map<IntrReportStatusEnum, Set<FourTuple<Long, String, String, Long>>>> orgReportStatus = this.getReportStatus();
        if (orgReportStatus.values().stream().mapToLong(m -> ((Set)m.get(IntrReportStatusEnum.REPORTED)).size()).sum() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62b5\u9500\u5e95\u7a3f\u4e0d\u662f\u5df2\u4e0a\u62a5\u72b6\u6001\uff0c\u4e0d\u53ef\u751f\u6210\u5206\u5f55\u3002", (String)"IntrReportListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> rpts = new ArrayList<Long>(16);
        StringBuilder message = new StringBuilder(16);
        orgReportStatus.forEach((orgid, reportStatus) -> {
            IDNumberTreeNode numberTreeNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)orgid);
            String orgInfo = numberTreeNode.getNumber() + " " + numberTreeNode.getName() + " ";
            Set reportedRpts = (Set)reportStatus.get(IntrReportStatusEnum.REPORTED);
            if (reportedRpts != null && !reportedRpts.isEmpty()) {
                for (FourTuple data : reportedRpts) {
                    if (!this.checkReadOnly((Long)orgid, (Long)data.item1)) {
                        rpts.add((Long)data.item4);
                        continue;
                    }
                    message.append(orgInfo).append((String)data.item2).append(" ").append((String)data.item3).append("\uff1a").append(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9\u8be5\u5e95\u7a3f\u4e3a\u53ea\u8bfb\u6743\u9650\u3002", (String)"IntrReportListPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
                }
            }
        });
        if (CollectionUtils.isNotEmpty(rpts)) {
            this.dispatchJob(rpts, processIds, message.toString());
        } else if (message.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ec5\u5df2\u4e0a\u62a5\u72b6\u6001\u7684\u62b5\u9500\u5e95\u7a3f\u53ef\u751f\u6210\u5206\u5f55\uff0c\u751f\u6210\u5206\u5f55\u7ed3\u679c\uff1a", (String)"IntrReportListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), message.toString(), MessageTypes.Commit);
            this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u751f\u6210\u5206\u5f55", "IntrReportListPlugin_16", "fi-bcm-formplugin", "Generate Entries"), this.getLogDescriptionMsg(message.toString()));
        }
    }

    private void dispatchJob(List<Long> reportIds, List<Long> processIds, String message) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u751f\u6210\u5206\u5f55", (String)"IntrReportListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.fi.bcm.business.innertrade.adjust.IntrAdjustTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reportIds", this.toByteSerialized(reportIds));
        params.put("processIds", this.toByteSerialized(processIds));
        params.put("isFormList", true);
        params.put("message", message);
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByUserId(this.getUserId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(this.getView().getPageId());
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)this.getView());
    }

    protected OPDescMultiLangEnumBridge getLogDescriptionMsg(String message) {
        DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject year = (DynamicObject)this.getModel().getValue("year");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        return OPDescMultiLangEnumBridge.genUnTransBridge((String)String.format("%1$s %2$s %3$s %4$s", scenario.get(NUMBER), year.get(NUMBER), period.get(NUMBER), message));
    }

    private void updateRptStatus(IntrReportStatusEnum statusEnum) {
        HashMap<String, Object> message = new HashMap<String, Object>(16);
        message.put("totalNum", 0);
        message.put("success", 0);
        message.put("info", new StringBuilder(16));
        Map<Long, Map<IntrReportStatusEnum, Set<FourTuple<Long, String, String, Long>>>> orgReportStatus = this.getReportStatus();
        orgReportStatus.forEach((orgid, reportStatus) -> {
            IDNumberTreeNode numberTreeNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)orgid);
            HashSet<FourTuple<Long, String, String, Long>> needDeal = new HashSet<FourTuple<Long, String, String, Long>>(14);
            if (IntrReportStatusEnum.COMPLETE == statusEnum) {
                needDeal.addAll((Collection)reportStatus.get(IntrReportStatusEnum.EDITING));
                needDeal.addAll((Collection)reportStatus.get(IntrReportStatusEnum.REJECTED));
            } else if (IntrReportStatusEnum.EDITING == statusEnum) {
                needDeal.addAll((Collection)reportStatus.get(IntrReportStatusEnum.COMPLETE));
            } else if (IntrReportStatusEnum.REPORTED == statusEnum) {
                needDeal.addAll((Collection)reportStatus.get(IntrReportStatusEnum.COMPLETE));
            } else if (IntrReportStatusEnum.REJECTED == statusEnum) {
                needDeal.addAll((Collection)reportStatus.get(IntrReportStatusEnum.REPORTED));
            }
            HashMap<Long, String> errortmpl = new HashMap<Long, String>(16);
            for (FourTuple fourTuple : needDeal) {
                try {
                    if (!this.checkReadOnly((Long)orgid, (Long)fourTuple.item1)) {
                        IntrReportHelper.updateStatus((Long)RequestContext.get().getCurrUserId(), (Long)((Long)fourTuple.item4), (String)statusEnum.value, (String)"2");
                        continue;
                    }
                    errortmpl.put((Long)fourTuple.item1, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9\u8be5\u5e95\u7a3f\u4e3a\u53ea\u8bfb\u6743\u9650\u3002", (String)"IntrReportListPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                catch (KDBizException e) {
                    errortmpl.put((Long)fourTuple.item1, e.getMessage());
                }
            }
            this.collectMsage(numberTreeNode, (Map<IntrReportStatusEnum, Set<FourTuple<Long, String, String, Long>>>)reportStatus, (Set<FourTuple<Long, String, String, Long>>)needDeal, (Map<Long, String>)errortmpl, statusEnum, (Map<String, Object>)message);
        });
        this.showResult(message);
        this.refreshEntryEntityList();
    }

    private void collectMsage(IDNumberTreeNode numberTreeNode, Map<IntrReportStatusEnum, Set<FourTuple<Long, String, String, Long>>> reportStatus, Set<FourTuple<Long, String, String, Long>> needDeal, Map<Long, String> errortmpl, IntrReportStatusEnum statusEnum, Map<String, Object> message) {
        int lastTotal = Integer.parseInt(message.get("totalNum").toString());
        int lastSuccess = Integer.parseInt(message.get("success").toString());
        StringBuilder lastInfo = (StringBuilder)message.get("info");
        String orgInfo = numberTreeNode.getNumber() + " " + numberTreeNode.getName() + " ";
        String statusInfo = "";
        String operationName = "";
        String englishName = "";
        switch (statusEnum) {
            case EDITING: {
                statusInfo = ResManager.loadKDString((String)"%1$s\uff1a\u64cd\u4f5c\u5931\u8d25\uff0c\u53ea\u80fd\u53d6\u6d88\u7f16\u5236\u72b6\u6001\u4e3a\u5b8c\u6210\u7684\u5e95\u7a3f\u3002", (String)"IntrReportListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                operationName = ResManager.loadKDString((String)"\u53d6\u6d88\u7f16\u5236\u5b8c\u6210", (String)"IntrReportListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                englishName = "Cancel completed";
                break;
            }
            case COMPLETE: {
                statusInfo = ResManager.loadKDString((String)"%1$s :\u64cd\u4f5c\u5931\u8d25\uff0c\u7f16\u5236\u5b8c\u6210\u53ea\u80fd\u64cd\u4f5c\u7f16\u5236\u4e2d\u6216\u88ab\u6253\u56de\u72b6\u6001\u7684\u5e95\u7a3f\u3002", (String)"IntrReportListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                operationName = ResManager.loadKDString((String)"\u7f16\u5236\u5b8c\u6210", (String)"IntrReportListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                englishName = "Compilation completed";
                break;
            }
            case REPORTED: {
                statusInfo = ResManager.loadKDString((String)"%1$s\uff1a\u64cd\u4f5c\u5931\u8d25\uff0c\u53ea\u80fd\u4e0a\u62a5\u7f16\u5236\u72b6\u6001\u4e3a\u5b8c\u6210\u7684\u5e95\u7a3f\u3002", (String)"IntrReportListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                operationName = ResManager.loadKDString((String)"\u4e0a\u62a5", (String)"IntrReportListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                englishName = "Report";
                break;
            }
            case REJECTED: {
                statusInfo = ResManager.loadKDString((String)"%1$s\uff1a\u64cd\u4f5c\u5931\u8d25\uff0c\u53ea\u80fd\u6253\u56de\u7f16\u5236\u72b6\u6001\u4e3a\u5df2\u4e0a\u62a5\u7684\u5e95\u7a3f\u3002", (String)"IntrReportListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                operationName = ResManager.loadKDString((String)"\u6253\u56de", (String)"IntrReportListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                englishName = "Call back";
                break;
            }
        }
        HashSet totalDatas = new HashSet(16);
        HashSet wrongStatus = new HashSet(16);
        reportStatus.values().forEach(set -> set.forEach(e -> {
            totalDatas.add(e);
            if (!needDeal.contains(e)) {
                wrongStatus.add(e);
            }
        }));
        lastTotal = totalDatas.size() + lastTotal;
        lastSuccess = needDeal.size() - errortmpl.size() + lastSuccess;
        Set success = needDeal.stream().filter(e -> !errortmpl.containsKey(e.item1)).collect(Collectors.toSet());
        Set error = needDeal.stream().filter(e -> errortmpl.containsKey(e.item1)).collect(Collectors.toSet());
        for (FourTuple data : success) {
            if (IntrReportStatusEnum.REJECTED != statusEnum) continue;
            lastInfo.append(String.format(ResManager.loadKDString((String)"%1$s :\u64cd\u4f5c\u6210\u529f\u3002", (String)"IntrReportListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgInfo + (String)data.item2 + " " + (String)data.item3)).append("\n");
        }
        for (FourTuple data : wrongStatus) {
            lastInfo.append(String.format(statusInfo, orgInfo + (String)data.item2 + " " + (String)data.item3)).append("\n");
        }
        for (FourTuple data : error) {
            lastInfo.append(String.format(ResManager.loadKDString((String)"%1$s :\u64cd\u4f5c\u5931\u8d25\uff0c%2$s", (String)"IntrReportListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgInfo + (String)data.item2 + " " + (String)data.item3, errortmpl.get(data.item1))).append("\n");
        }
        message.put("totalNum", lastTotal);
        message.put("success", lastSuccess);
        message.put("info", lastInfo);
        message.put("operationName", operationName);
        message.put("opKey", englishName);
    }

    private void showResult(Map<String, Object> message) {
        int lastTotal = Integer.parseInt(message.get("totalNum") == null ? "0" : message.get("totalNum").toString());
        int lastSuccess = Integer.parseInt(message.get("success") == null ? "0" : message.get("success").toString());
        StringBuilder lastInfo = message.get("info") == null ? new StringBuilder(16) : (StringBuilder)message.get("info");
        String operationName = message.get("operationName") == null ? "" : (String)message.get("operationName");
        String opKey = message.get("opKey") == null ? "" : (String)message.get("opKey");
        String title = String.format(ResManager.loadKDString((String)"\u5171\u64cd\u4f5c%1$d\u6761\u6570\u636e\uff0c\u5176\u4e2d\u6210\u529f%2$d\u6761\uff0c\u5931\u8d25%3$d\u6761\u3002", (String)"IntrReportListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), lastTotal, lastSuccess, lastTotal - lastSuccess);
        this.getView().showMessage(title, lastInfo.toString(), MessageTypes.Commit);
        String info = message.get("info") == null ? "" : message.get("info").toString();
        this.writeMultiLangLog(OpNameMultiLangEnumBridge.genOpNameBridge((MultiLangEnumBridge)OpNameMultiLangEnumBridge.genUnTransBridge((String)operationName), (String)opKey), this.getLogDescriptionMsg(info));
    }

    private Map<Long, Map<IntrReportStatusEnum, Set<FourTuple<Long, String, String, Long>>>> getReportStatus() {
        HashMap<Long, Map<IntrReportStatusEnum, Set<FourTuple<Long, String, String, Long>>>> result = new HashMap<Long, Map<IntrReportStatusEnum, Set<FourTuple<Long, String, String, Long>>>>(16);
        ArrayListMultimap orgGroupDatas = ArrayListMultimap.create();
        DynamicObjectCollection entryData = this.getModel().getEntryEntity(entryentity);
        EntryGrid eg = (EntryGrid)this.getControl(entryentity);
        int[] selectRows = eg.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"IntrReportListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        for (int i : selectRows) {
            DynamicObject rowData2 = (DynamicObject)entryData.get(i);
            orgGroupDatas.put((Object)rowData2.getLong("entityid"), (Object)rowData2);
        }
        Object object = orgGroupDatas.keySet().iterator();
        while (object.hasNext()) {
            Long orgId = (Long)object.next();
            HashMap<Long, FourTuple<Long, String, String, Long>> selectTmps = new HashMap<Long, FourTuple<Long, String, String, Long>>(16);
            orgGroupDatas.get((Object)orgId).forEach(rowData -> selectTmps.put(rowData.getLong("templateid"), new FourTuple((Object)rowData.getLong("templateid"), (Object)rowData.getString("templatenumber"), (Object)rowData.getString("templatename"), (Object)rowData.getLong("tradedataid"))));
            HashMap<IntrReportStatusEnum, Set<Object>> groupResult = new HashMap<IntrReportStatusEnum, Set<Object>>(16);
            groupResult.put(IntrReportStatusEnum.UNWEAVE, selectTmps.values().stream().filter(e -> (Long)e.item4 == 0L).collect(Collectors.toSet()));
            DynamicObject[] rpts = BusinessDataServiceHelper.load((String)"bcm_intrreportentity", (String)"id,papertemplate.id,entity,currency,reportstatus,completer,completetime,commitor,committime,firstcommittime,committimes,sendbacker,sendbacktime,sendbacktimes", (QFilter[])new QFilter[]{new QFilter(ID, "in", selectTmps.values().stream().filter(e -> (Long)e.item4 != 0L).map(e -> (Long)e.item4).collect(Collectors.toSet()))});
            Map<String, List<DynamicObject>> reportstatusMap = Arrays.stream(rpts).collect(Collectors.groupingBy(e -> e.getString("reportstatus")));
            groupResult.put(IntrReportStatusEnum.EDITING, this.mergeDataByStatus(IntrReportStatusEnum.EDITING, reportstatusMap, selectTmps));
            groupResult.put(IntrReportStatusEnum.COMPLETE, this.mergeDataByStatus(IntrReportStatusEnum.COMPLETE, reportstatusMap, selectTmps));
            groupResult.put(IntrReportStatusEnum.REPORTED, this.mergeDataByStatus(IntrReportStatusEnum.REPORTED, reportstatusMap, selectTmps));
            groupResult.put(IntrReportStatusEnum.REJECTED, this.mergeDataByStatus(IntrReportStatusEnum.REJECTED, reportstatusMap, selectTmps));
            result.put(orgId, groupResult);
        }
        return result;
    }

    private Set<FourTuple<Long, String, String, Long>> mergeDataByStatus(IntrReportStatusEnum statusEnum, Map<String, List<DynamicObject>> reportstatusMap, Map<Long, FourTuple<Long, String, String, Long>> selectTmps) {
        HashSet<FourTuple<Long, String, String, Long>> result = new HashSet<FourTuple<Long, String, String, Long>>(16);
        List<DynamicObject> list = reportstatusMap.get(statusEnum.value);
        if (list != null && list.size() > 0) {
            Set rptids = list.stream().map(e -> e.getLong(ID)).collect(Collectors.toSet());
            return selectTmps.values().stream().filter(e -> rptids.contains(e.item4)).collect(Collectors.toSet());
        }
        return result;
    }

    private void refreshTree(Long modelid) {
        String currentTab;
        DynamicObject modelDynamicObject;
        if (modelid == null && (modelDynamicObject = (DynamicObject)this.getModel().getValue(model)) != null) {
            modelid = modelDynamicObject.getLong(ID);
        }
        if ((currentTab = this.getPageCache().get("tabSelected")) == null) {
            Tab tab = (Tab)this.getControl(tabap);
            currentTab = tab.getCurrentTab();
            this.getPageCache().put("tabSelected", currentTab);
            this.getPageCache().put(treeview_id_cache, this.getTabMap(currentTab).get(TREE_KEY));
        }
        if (modelid != null) {
            this.buildLeftTree(currentTab);
            this.refreshEntryEntityList();
        } else {
            TreeView tree = (TreeView)this.getControl(this.getPageCache().get(treeview_id_cache));
            tree.deleteAllNodes();
        }
    }

    private void buildLeftTree(String currentTab) {
        AbstractTreeNode<Object> root = this.buildTreeCache(currentTab);
        if (root != null) {
            this.initTree(root, currentTab);
        }
    }

    private Set<Long> getTemplateIds(String selectedNodeId, boolean includeAllSubordinate, boolean includeDirectLevel) {
        HashSet<Long> templateIdSet = new HashSet<Long>();
        if (selectedNodeId != null && !selectedNodeId.isEmpty()) {
            TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)cache_treetemplate);
            if (treeModel == null) {
                return null;
            }
            TemplateTreeNode templateTreeNode = (TemplateTreeNode)treeModel.searchByNodeId(selectedNodeId);
            this.getTemplateIdsByTreeNode(templateTreeNode, includeAllSubordinate, includeDirectLevel, templateIdSet);
            return templateIdSet;
        }
        return null;
    }

    private void getTemplateIdsByTreeNode(TemplateTreeNode templateTreeNode, boolean includeAllSubordinate, boolean includeDirectLevel, Set<Long> templateIdSet) {
        if (templateTreeNode == null) {
            return;
        }
        if (templateTreeNode.isIstemplate()) {
            templateIdSet.add(Long.valueOf(templateTreeNode.getId()));
        } else {
            List treeNodeList = templateTreeNode.getChildren();
            for (ITreeNode node : treeNodeList) {
                if (((TemplateTreeNode)node).isIstemplate()) {
                    templateIdSet.add(Long.valueOf(node.getId()));
                    continue;
                }
                if (!includeAllSubordinate && !includeDirectLevel) continue;
                List childNodeList = node.getChildren();
                for (ITreeNode childNode : childNodeList) {
                    if (((TemplateTreeNode)childNode).isIstemplate()) {
                        templateIdSet.add(Long.valueOf(childNode.getId()));
                        continue;
                    }
                    if (!includeAllSubordinate) continue;
                    this.getTemplateIdsByTreeNode((TemplateTreeNode)childNode, includeAllSubordinate, includeDirectLevel, templateIdSet);
                }
            }
        }
    }

    private AbstractTreeNode<Object> buildTreeCache(String currentTab) {
        HashMap<String, Long> f7IdMap = this.getF7id();
        if (f7IdMap == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5168\u641c\u7d22\u6761\u4ef6\u3002", (String)"IntrReportListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)currentTab, (CharSequence)tabpageap_entity)) {
            String showType = this.getPageCache().get(showorgtype_cache);
            QFBuilder builder = new QFBuilder();
            builder.add("isleaf", "!=", (Object)true);
            DynamicObjectCollection doc = this.getCustomOrgDynamicObjectCollection(this.getModelId(), builder);
            OrgUtils.dealNoMergeOrgs(doc, this.getModel(), null);
            this.delOrgMenberPerm(doc, this.getModelId());
            this.cacheTree(doc);
            if (doc == null || doc.size() == 0) {
                TreeView tree = (TreeView)this.getControl(treeview_entity);
                tree.deleteAllNodes();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u6210\u5458\u6743\u9650\u3002", (String)"ReportListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return null;
            }
            OrgTreeNode root = TreeBuilder.getOrgCslTree((DynamicObjectCollection)doc, (String)showType, (boolean)this.isCsl());
            if (root != null) {
                root = (OrgTreeNode)TreeBuilder.setOpen((ITreeNode)root);
                TreeBuilder.setOpen((ITreeNode)root);
                this.cacheRoot(currentTab, (AbstractTreeNode<Object>)root);
                return root;
            }
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)currentTab, (CharSequence)tabpageap_template)) {
            DynamicObjectCollection rootNodecollection;
            String showType = this.getPageCache().get(showtmptype_cache);
            QFBuilder qFilters = new QFBuilder();
            qFilters.add(new QFilter("model.id", "=", (Object)this.getModelId()));
            qFilters.add(new QFilter("longnumber", "like", (Object)"root.InnerTrade%"));
            if (this.getPageCache().get(CATALOG_NOPERM_IDSET) != null) {
                List noPermCatlogPerm = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(CATALOG_NOPERM_IDSET));
                qFilters.add(new QFilter(ID, "not in", (Object)noPermCatlogPerm));
            }
            if ((rootNodecollection = QueryServiceHelper.query((String)"bcm_papertemplatecatalog", (String)"id,number,name,parent", (QFilter[])qFilters.toArray())) == null || rootNodecollection.size() == 0) {
                TreeView tree = (TreeView)this.getControl(treeview_template);
                tree.deleteAllNodes();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u6a21\u677f\u5206\u7c7b\u6216\u6a21\u677f\u6743\u9650\u3002", (String)"IntrReportListPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                QFBuilder filters = new QFBuilder();
                filters.add(new QFilter("model.id", "=", (Object)this.getModelId()));
                filters.add(new QFilter("templatecatalog.id", "in", rootNodecollection.stream().map(e -> e.getLong(ID)).collect(Collectors.toSet())));
                if (this.getPageCache().get(TMPL_NOPERM_IDSET) != null) {
                    Set noPermTmplPerm = (Set)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(TMPL_NOPERM_IDSET));
                    filters.add(new QFilter(ID, "not in", (Object)noPermTmplPerm));
                }
                DynamicObjectCollection tempColl = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,number,name,usage,templatecatalog,versionnumber", (QFilter[])filters.toArray(), (String)"number asc,sequence asc");
                Map tplIdByVersioned = IntrTemplateHelper.getRightTplIdByVersioned((Long)f7IdMap.get(modelf7id), (Long)f7IdMap.get(yearf7id), (Long)f7IdMap.get(periodf7id), tempColl.stream().map(e -> e.getLong(ID)).collect(Collectors.toSet()));
                tempColl.removeIf(e -> !tplIdByVersioned.values().contains(e.getLong(ID)));
                TemplateTreeNode root = new TemplateTreeNode("root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ReportListPlugin_83", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                Optional<DynamicObject> rootDy = rootNodecollection.stream().filter(e -> "InnerTrade".equals(e.getString(NUMBER))).findAny();
                if (rootDy.isPresent()) {
                    DynamicObject rootDyn = rootDy.get();
                    rootDyn.set("parent", (Object)"0");
                    root = new TemplateTreeNode(rootDyn.getString(ID), rootDyn.getString(NAME));
                    root = TreeBuilder.getTemplateTree((DynamicObjectCollection)rootNodecollection, (TemplateTreeNode)root, (DynamicObjectCollection)tempColl, (String)showType);
                    TreeBuilder.checkInvalidNode((TemplateTreeNode)root);
                    TemplateTreeNode newRoot = new TemplateTreeNode(root.getId(), root.getName(), root.getNumber(), false);
                    TreeBuilder.invaildTreeNode((boolean)true, (TemplateTreeNode)newRoot, (TemplateTreeNode)root);
                    root = (TemplateTreeNode)TreeBuilder.setOpen((ITreeNode)newRoot);
                }
                this.cacheRoot(currentTab, (AbstractTreeNode<Object>)root);
                return root;
            }
        }
        return null;
    }

    private void cacheRoot(String currentTab, AbstractTreeNode<Object> root) {
        if (root != null) {
            this.cacheTabInfo(root, currentTab);
            root.SetIsOpened(true);
            TreeModel treemodel = new TreeModel(root);
            treemodel.ache2page(this.getPageCache(), this.getTabMap(currentTab).get(CACHE_KEY));
        }
    }

    private void removeLeafNode(DynamicObjectCollection doc) {
        Iterator permIt = doc.iterator();
        while (permIt.hasNext()) {
            DynamicObject dd = (DynamicObject)permIt.next();
            if (!dd.getBoolean("isleaf")) continue;
            permIt.remove();
        }
    }

    private void initTree(AbstractTreeNode<Object> root, String currentTab) {
        TreeView tree = (TreeView)this.getControl(Objects.equals(tabpageap_entity, currentTab) ? treeview_entity : treeview_template);
        if (tabpageap_entity.equals(currentTab)) {
            tree.setRootVisible(false);
        }
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            treemodel.buildEntryTree(tree);
            if (root.getChildren() == null || root.getChildren().size() == 0) {
                return;
            }
            TreeNode selectnode = this.findCacheNode(root, currentTab);
            tree.focusNode(selectnode);
            if (tabpageap_entity.equals(currentTab)) {
                this.getPageCache().put(TABINFO_ORG, SerializationUtils.toJsonString((Object)new TabInfo(Long.parseLong(selectnode.getId()), selectnode.getText(), "0".equals(selectnode.getParentid()))));
                this.getPageCache().put("entityselectedNodeId", selectnode.getId());
                this.expandAllSelected((TreeModel<AbstractTreeNode<Object>>)treemodel, tree);
                treemodel.ache2page(this.getPageCache(), cache_treeorg);
            } else if (tabpageap_template.equals(currentTab)) {
                this.expandAllSelected((TreeModel<AbstractTreeNode<Object>>)treemodel, tree);
                treemodel.ache2page(this.getPageCache(), cache_treetemplate);
                this.getPageCache().put(TABINFO_TEMP, SerializationUtils.toJsonString((Object)new TabInfo(Long.parseLong(selectnode.getId()), selectnode.getText(), "0".equals(selectnode.getParentid()))));
                this.getPageCache().put("templateselectedNodeId", selectnode.getId());
            }
        }
    }

    private TreeNode findCacheNode(AbstractTreeNode<Object> root, String currentTab) {
        AbstractTreeNode firstTreeNode;
        String selectnode = null;
        if (tabpageap_entity.equals(currentTab)) {
            selectnode = GuidePageUtils.getUserSelectOrg(this.getView(), this.getUserId(), this.getModelId(), this.isCsl(), false);
            if (this.getPageCache().get(selectorgs) != null) {
                List selects = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(selectorgs));
                selectnode = (String)selects.get(selects.size() - 1);
            } else {
                ArrayList<String> selectnodes = new ArrayList<String>();
                if (selectnode == null && root.getChildren() != null && !root.getChildren().isEmpty()) {
                    firstTreeNode = (AbstractTreeNode)root.getChildren().get(0);
                    selectnode = firstTreeNode.getId();
                }
                selectnodes.add(selectnode);
                this.getPageCache().put(selectorgs, ObjectSerialUtil.toByteSerialized(selectnodes));
            }
        } else if (tabpageap_template.equals(currentTab)) {
            selectnode = this.getPageCache().get("templateselectedNodeId");
        }
        if (selectnode == null || selectnode.equals(root.getId())) {
            if (root.getChildren() != null && root.getChildren().size() > 0 && tabpageap_entity.equals(currentTab)) {
                AbstractTreeNode firstTreeNode2 = (AbstractTreeNode)root.getChildren().get(0);
                return new TreeNode(firstTreeNode2.getParent().getId(), firstTreeNode2.getId(), firstTreeNode2.getName());
            }
            return new TreeNode("0", root.getId(), root.getName());
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(root);
        while (!queue.isEmpty()) {
            ITreeNode node = (ITreeNode)queue.poll();
            List children = node.getChildren();
            if (node.getId().equals(selectnode)) {
                boolean isleaf = children == null || children.isEmpty();
                TreeNode result = new TreeNode(node.getParent().getId(), node.getId(), node.getName());
                result.setLeaf(isleaf);
                return result;
            }
            if (children.size() == 0) continue;
            for (ITreeNode child : children) {
                queue.add(child);
            }
        }
        if (tabpageap_template.equals(currentTab)) {
            this.getPageCache().put("templateselectedNodeId", root.getId());
        }
        if (tabpageap_entity.equals(currentTab)) {
            if (root.getChildren() != null && root.getChildren().size() > 0) {
                firstTreeNode = (AbstractTreeNode)root.getChildren().get(0);
                return new TreeNode(firstTreeNode.getParent().getId(), firstTreeNode.getId(), firstTreeNode.getName());
            }
            return new TreeNode("0", root.getId(), root.getName());
        }
        return new TreeNode("0", root.getId(), root.getName());
    }

    protected boolean isCsl() {
        return false;
    }

    private void expandAllSelected(TreeModel<AbstractTreeNode<Object>> treemodel, TreeView treeView) {
        if (treeview_entity.equals(treeView.getKey()) && this.getPageCache().get(selectorgs) != null) {
            List selects = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(selectorgs));
            OrgTreeNode root = (OrgTreeNode)treemodel.getRoot();
            for (String nodeid : selects) {
                OrgTreeNode node = (OrgTreeNode)treemodel.searchByNodeId(nodeid);
                if (node == null || node.getId() == null || node.getId().equals(root.getId())) continue;
                String parentid = node.getParent().getId();
                if (!parentid.equals(root.getId())) {
                    treeView.expand(parentid);
                    continue;
                }
                treeView.expand(node.getId());
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        String selectedNodeId = (String)arg0.getNodeId();
        if (selectedNodeId.isEmpty()) {
            return;
        }
        String treeviewId = this.getPageCache().get(treeview_id_cache);
        if (treeview_entity.equals(treeviewId)) {
            if (this.checkOrgMemberIsNoPerm(selectedNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u64cd\u4f5c\u5bf9\u5e94\u7684\u6210\u5458\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReportListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.getModel().deleteEntryData(entryentity);
                return;
            }
            TreeModel orgTreeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)cache_treeorg);
            List<String> selectnodes = new ArrayList<String>();
            if (this.getPageCache().get(selectorgs) != null) {
                selectnodes = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(selectorgs));
            }
            selectnodes.remove(selectedNodeId);
            selectnodes.add(selectedNodeId);
            this.getPageCache().put(selectorgs, ObjectSerialUtil.toByteSerialized(selectnodes));
            if (orgTreeModel == null) {
                this.getModel().deleteEntryData(entryentity);
                return;
            }
            UserSelectServiceHelper.setEntity((Long)this.getUserId(), (Long)this.getModelId(), (Object)selectedNodeId);
            this.getPageCache().put("entityselectedNodeId", selectedNodeId);
        } else if (treeview_template.equals(treeviewId)) {
            this.getPageCache().put("templateselectedNodeId", selectedNodeId);
        }
        this.treeNodeClickCache(selectedNodeId, treeviewId);
        this.refreshEntryEntityList();
    }

    private void treeNodeClickCache(String selectedNodeId, String treeviewId) {
        if (treeview_template.equals(treeviewId)) {
            Map<String, String> tabMap = this.getTabMap(tabpageap_template);
            TreeModel tempTreeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)tabMap.get(CACHE_KEY));
            AbstractTreeNode tempNode = (AbstractTreeNode)tempTreeModel.searchByNodeId(selectedNodeId);
            boolean isSelectRoot = ((TemplateTreeNode)tempNode).isIstemplate();
            this.getPageCache().put(TABINFO_TEMP, SerializationUtils.toJsonString((Object)new TabInfo("root".equals(selectedNodeId) ? 0L : Long.parseLong(selectedNodeId), tempNode.getName(), !isSelectRoot)));
        } else {
            TreeModel orgTreeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)cache_treeorg);
            OrgTreeNode orgNode = (OrgTreeNode)orgTreeModel.searchByNodeId(selectedNodeId);
            if (orgNode != null) {
                boolean isSelectRoot = orgNode.getParent() == null;
                this.getPageCache().put(TABINFO_ORG, SerializationUtils.toJsonString((Object)new TabInfo("root".equals(selectedNodeId) ? 0L : Long.parseLong(selectedNodeId), orgNode.getFinalname(), isSelectRoot)));
            }
        }
    }

    private Map<String, String> getTabMap(String tabpageap) {
        HashMap<String, String> map = new HashMap<String, String>(10);
        String tree = null;
        String tabInfo = null;
        String cache = null;
        String rowcache = null;
        String focus = null;
        switch (tabpageap) {
            case "tabpageap_template": {
                tabInfo = TABINFO_TEMP;
                tree = treeview_template;
                cache = cache_treetemplate;
                rowcache = ROWRLIST;
                focus = RFOCUS;
                break;
            }
            case "tabpageap_entity": {
                tabInfo = TABINFO_ORG;
                tree = treeview_entity;
                cache = cache_treeorg;
                rowcache = ROWLLIST;
                focus = LFOCUS;
                break;
            }
        }
        map.put(TREE_KEY, tree);
        map.put(TABINFO_KEY, tabInfo);
        map.put(CACHE_KEY, cache);
        map.put(FOCUS_KEY, focus);
        map.put(ROWCACHE_KEY, rowcache);
        return map;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (model.equals(propertyName)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.propertyChangedModelUse(new ArrayList<String>(dimKeys));
            this.cacheAllPermMap();
            if (newValue != null) {
                ThreadCache.put((Object)"getModelId", (Object)newValue.getLong(ID));
                if (!this.dealCurrencyF7()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6ca1\u6709\u9ed8\u8ba4\u5e01, \u8bf7\u5347\u7ea7\u4f53\u7cfb\u3002", (String)"ReportListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.initCslschemeValue(newValue.getString(ID), true);
                this.refreshAllTreeAndBill(true);
            }
        } else if (dimKeys.contains(propertyName)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            Boolean isSureReturn = this.propertyChangedDimUse(propertyName, newValue, false, true);
            if (!isSureReturn.booleanValue()) {
                return;
            }
            this.refreshAllTreeAndBill(true);
            if ("scenario".equals(propertyName)) {
                this.getModel().setValue("period", null);
            }
        } else {
            if (ctl_cslscheme.equals(propertyName)) {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.saveUserChangedCslscheme(newValue);
                this.refreshAllTreeAndBill(true);
                return;
            }
            if (showorgtype_cache.equals(propertyName)) {
                String showType = (String)this.getModel().getValue(showorgtype_cache);
                this.getPageCache().put(showorgtype_cache, showType);
                this.refreshTree(null);
            } else if (showtmptype_cache.equals(propertyName)) {
                String showType = (String)this.getModel().getValue(showtmptype_cache);
                this.getPageCache().put(showtmptype_cache, showType);
                this.refreshTree(null);
            }
        }
        this.refreshEntryEntityList();
    }

    private void cacheAllPermMap() {
        this.getPageCache().remove(CATALOG_PERM_MAP);
        this.getPageCache().remove(TMPL_PERM_MAP);
        this.getPageCache().remove(CATALOG_NOPERM_IDSET);
        this.getPageCache().remove(TMPL_NOPERM_IDSET);
        Boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)RequestContext.get().getCurrUserId(), (String)String.valueOf(this.getPageCache().get(modelCacheKey)));
        ArrayListMultimap catalogPerm = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_papertemplatecatalog", (String)String.valueOf(this.getPageCache().get(modelCacheKey)), (String)String.valueOf(RequestContext.get().getCurrUserId()));
        Map<Long, String> catalogPermMap = catalogPerm.entries().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> {
            if (Integer.parseInt(v1) < Integer.parseInt(v2)) {
                return v1;
            }
            return v2;
        }));
        ArrayList noPermCatlogPerm = new ArrayList(catalogPerm.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()));
        ArrayListMultimap tmplPerm = PermClassEntityHelper.getPermissionMapBatch((String)"bcm_papertemplate", (String)String.valueOf(this.getPageCache().get(modelCacheKey)), (String)String.valueOf(RequestContext.get().getCurrUserId()));
        Map<Long, String> tmplPermMap = tmplPerm.entries().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> {
            if (Integer.parseInt(v1) < Integer.parseInt(v2)) {
                return v1;
            }
            return v2;
        }));
        HashSet noPermTempPerm = new HashSet(tmplPerm.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()));
        this.getPageCache().put(CATALOG_PERM_MAP, ObjectSerialUtil.toByteSerialized(catalogPermMap));
        this.getPageCache().put(TMPL_PERM_MAP, ObjectSerialUtil.toByteSerialized(tmplPermMap));
        if (!adminUserBol.booleanValue() && CollectionUtils.isNotEmpty(noPermCatlogPerm)) {
            this.getPageCache().put(CATALOG_NOPERM_IDSET, ObjectSerialUtil.toByteSerialized(noPermCatlogPerm));
        }
        if (!adminUserBol.booleanValue() && CollectionUtils.isNotEmpty(noPermTempPerm)) {
            this.getPageCache().put(TMPL_NOPERM_IDSET, ObjectSerialUtil.toByteSerialized(noPermTempPerm));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        block4 : switch (callBackId = evt.getCallBackId()) {
            case "btn_delete": {
                switch (evt.getResult()) {
                    case Yes: {
                        this.getView().showMessage("");
                        this.refreshList();
                        break block4;
                    }
                    case Cancel: {
                        break block4;
                    }
                }
                break;
            }
            case "reset_table": {
                if (!evt.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.resetTable();
                break;
            }
        }
    }

    private HashMap<String, Long> getF7id() {
        DynamicObject modelDynamicObject = (DynamicObject)this.getModel().getValue(model);
        DynamicObject scenarioDynamicObject = (DynamicObject)this.getModel().getValue("scenario");
        DynamicObject fyearDynamicObject = (DynamicObject)this.getModel().getValue("year");
        DynamicObject periodDynamicObject = (DynamicObject)this.getModel().getValue("period");
        DynamicObject currencyDynamicObject = (DynamicObject)this.getModel().getValue(currency);
        if (modelDynamicObject == null || scenarioDynamicObject == null || fyearDynamicObject == null || periodDynamicObject == null || currencyDynamicObject == null) {
            return null;
        }
        HashMap<String, Long> map = new HashMap<String, Long>(9);
        map.put(modelf7id, modelDynamicObject.getLong(ID));
        map.put(scenariof7id, scenarioDynamicObject.getLong(ID));
        map.put("bcm_scenemembertree", scenarioDynamicObject.getLong("dimension.id"));
        map.put(yearf7id, fyearDynamicObject.getLong(ID));
        map.put("bcm_fymembertree", fyearDynamicObject.getLong("dimension.id"));
        map.put(periodf7id, periodDynamicObject.getLong(ID));
        map.put("bcm_periodmembertree", periodDynamicObject.getLong("dimension.id"));
        map.put(currencyf7id, currencyDynamicObject.getLong(ID));
        map.put("bcm_currencymembertree", currencyDynamicObject.getLong("dimension.id"));
        return map;
    }

    private QFilter getFilter(HashMap<String, Long> F7idMap) {
        if (F7idMap != null) {
            QFilter qFiltermodelid = new QFilter(model, "=", (Object)F7idMap.get(modelf7id));
            QFilter qFilterscenarioid = new QFilter("scenario", "=", (Object)F7idMap.get(scenariof7id));
            QFilter qFilterfyearid = new QFilter("year", "=", (Object)F7idMap.get(yearf7id));
            QFilter qFilterperiodid = new QFilter("period", "=", (Object)F7idMap.get(periodf7id));
            return qFiltermodelid.and(qFilterscenarioid).and(qFilterfyearid).and(qFilterperiodid);
        }
        return null;
    }

    private void refreshEntryEntityList() {
        this.getModel().deleteEntryData(entryentity);
        if (!this.checkDimOfUserSelected(true)) {
            return;
        }
        HashMap<String, Long> f7IdMap = this.getF7id();
        if (f7IdMap != null && !f7IdMap.isEmpty()) {
            LinkedHashMultimap<Long, DynamicObject> orgTemp = this.getAllTemplateByOrg(f7IdMap);
            this.filterByPerm(orgTemp);
            if (!orgTemp.isEmpty()) {
                Map<Long, Long> orgMap = this.getRealBaseOrgMap();
                ArrayListMultimap<Long, DynamicObject> innerTradeRpts = this.getInnerTradeRpts(f7IdMap, orgTemp.values().stream().map(e -> e.getLong(ID)).collect(Collectors.toSet()), orgTemp.keySet());
                this.getModel().beginInit();
                int row = 0;
                this.getModel().batchCreateNewEntryRow(entryentity, orgTemp.entries().size());
                for (Map.Entry entry : orgTemp.entries()) {
                    Long entityId = (Long)entry.getKey();
                    DynamicObject tempObj = (DynamicObject)entry.getValue();
                    DynamicObject rptObj = this.getIntrRptByOrg(entityId, tempObj.getLong(ID), innerTradeRpts);
                    DynamicObject rowObj = this.getModel().getEntryRowEntity(entryentity, row);
                    rowObj.set("templateid", (Object)tempObj.getString(ID));
                    rowObj.set("templatenumber", tempObj.get(NUMBER));
                    rowObj.set("templatename", tempObj.get(NAME));
                    String usageStr = ResManager.loadKDString((String)"\u5408\u5e76", (String)"IntrReportListPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    if ("1".equals(tempObj.getString("usage"))) {
                        usageStr = ResManager.loadKDString((String)"\u5f55\u5165", (String)"IntrReportListPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    }
                    rowObj.set("templateusage", (Object)usageStr);
                    rowObj.set("templatecatalog", tempObj.get("templatecatalog"));
                    rowObj.set("version", (Object)String.format("V%.1f", Float.valueOf(tempObj.getBigDecimal("versionnumber").floatValue())));
                    if (rptObj != null) {
                        rowObj.set("tradedataid", rptObj.get(ID));
                        rowObj.set("entitynumber", rptObj.get("entity.number"));
                        rowObj.set("entityname", rptObj.get("entity.name"));
                        rowObj.set("entityid", rptObj.get("entity.id"));
                        rowObj.set("entityrealid", (Object)orgMap.get(rptObj.getLong("entity.id")));
                        rowObj.set("completestatus", rptObj.get("reportstatus"));
                        rowObj.set("completer", rptObj.get("modifier"));
                        rowObj.set("completetime", rptObj.get("modifytime"));
                        rowObj.set("rejectcount", rptObj.get("sendbacktimes"));
                        rowObj.set("rejecter", rptObj.get("sendbacker"));
                        rowObj.set("rejecttime", rptObj.get("sendbacktime"));
                        rowObj.set("commiter", rptObj.get("commitor"));
                        rowObj.set("committime", rptObj.get("committime"));
                        rowObj.set("firstcommittime", rptObj.get("firstcommittime"));
                        rowObj.set("commitcount", rptObj.get("committimes"));
                        rowObj.set("gentype", rptObj.get("gentype"));
                    } else {
                        rowObj.set("completestatus", (Object)IntrReportStatusEnum.UNWEAVE.value);
                        rowObj.set("gentype", (Object)IntrRptGenTypeEnum.AUTO.value);
                        IDNumberTreeNode entity = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_entitymembertree", (Long)entityId);
                        if (entity != null && entity.getId() != -1L) {
                            rowObj.set("entitynumber", (Object)entity.getNumber());
                            rowObj.set("entityname", (Object)entity.getName());
                            rowObj.set("entityid", (Object)entity.getId());
                            rowObj.set("entityrealid", (Object)orgMap.get(entity.getId()));
                        }
                    }
                    ++row;
                }
                this.getModel().endInit();
                this.getView().updateView(entryentity);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{entryentity});
            }
        }
    }

    private Map<Long, Long> getRealBaseOrgMap() {
        String modelNum = this.getCurModelNumber();
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        Set<Long> realOrgIds = this.getOrgRange();
        for (Long realOrgId : realOrgIds) {
            IDNumberTreeNode realNode = MemberReader.findEntityMemberById((String)modelNum, (Long)realOrgId);
            Long baseId = realNode.getBaseTreeNode().getId();
            if (result.get(baseId) != null) {
                if (realNode.isShare()) continue;
                result.put(baseId, realOrgId);
                continue;
            }
            result.put(baseId, realOrgId);
        }
        return result;
    }

    private DynamicObject getIntrRptByOrg(Long entityId, Long tempId, ArrayListMultimap<Long, DynamicObject> innerTradeRpts) {
        Optional<DynamicObject> object;
        if (innerTradeRpts.get((Object)entityId) != null && (object = innerTradeRpts.get((Object)entityId).stream().filter(e -> Objects.equals(e.getLong("papertemplate.id"), tempId)).findAny()).isPresent()) {
            return object.get();
        }
        return null;
    }

    private void filterByPerm(LinkedHashMultimap<Long, DynamicObject> orgTempMap) {
        this.getPageCache().remove(READ_ONLY_TMPL_MAP);
        Boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel((long)RequestContext.get().getCurrUserId(), (String)String.valueOf(this.getPageCache().get(modelCacheKey)));
        if (adminUserBol.booleanValue()) {
            return;
        }
        Map catalogPermMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(CATALOG_PERM_MAP));
        Map tmplPermMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(TMPL_PERM_MAP));
        LinkedHashMultimap noPermMap = LinkedHashMultimap.create();
        LinkedHashMultimap readonlyMap = LinkedHashMultimap.create();
        Long entityDimensionId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)PresetConstant.ENTITY_DIM);
        PermissionService permService = PermissionServiceImpl.getInstance((Long)this.getModelId());
        orgTempMap.forEach((orgid, dyn) -> {
            Long catalogId = dyn.getLong("templatecatalog.id");
            Long id = dyn.getLong(ID);
            if (this.compareValue((String)catalogPermMap.get(catalogId), PermClassEntityHelper.PermClassEnum.NOPERM) || this.compareValue((String)tmplPermMap.get(id), PermClassEntityHelper.PermClassEnum.NOPERM) || permService.isAllNoPerm(entityDimensionId, "bcm_entitymembertree", (Collection)Sets.newHashSet((Object[])new Long[]{orgid}))) {
                noPermMap.put(orgid, dyn);
            } else if (!noPermMap.containsKey(orgid) && permService.isAllReadPerm(entityDimensionId, "bcm_entitymembertree", (Collection)Sets.newHashSet((Object[])new Long[]{orgid}))) {
                readonlyMap.put(orgid, (Object)id);
            }
        });
        noPermMap.forEach((x$0, x$1) -> orgTempMap.remove(x$0, x$1));
        this.getPageCache().put(READ_ONLY_TMPL_MAP, ObjectSerialUtil.toByteSerialized((Object)readonlyMap));
    }

    private boolean compareValue(String value, PermClassEntityHelper.PermClassEnum perm) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return perm.getValue().equals(value);
    }

    private ArrayListMultimap<Long, DynamicObject> getInnerTradeRpts(HashMap<String, Long> f7IdMap, Set<Long> tempids, Set<Long> orgIds) {
        ArrayListMultimap result = ArrayListMultimap.create();
        QFilter filter = this.getFilter(f7IdMap);
        if (filter != null) {
            filter.and(new QFilter("entity.id", "in", orgIds));
            filter.and(new QFilter("papertemplate.id", "in", tempids));
            DynamicObject[] rpts = BusinessDataServiceHelper.load((String)"bcm_intrreportentity", (String)"id,papertemplate.id,entity,currency,reportstatus,modifier,modifytime,completer,completetime,commitor,committime,firstcommittime,committimes,sendbacker,sendbacktime,sendbacktimes,gentype", (QFilter[])new QFilter[]{filter});
            if (rpts != null && rpts.length > 0) {
                DynamicObject currencyF7model = (DynamicObject)this.getModel().getValue(currency);
                boolean isEcCurrency = CurrencyEnum.EC.number.equals(currencyF7model.getString(NUMBER)) || CurrencyEnum.DC.number.equals(currencyF7model.getString(NUMBER));
                for (DynamicObject e : rpts) {
                    if (!isEcCurrency && !Objects.equals(currencyF7model.getLong(ID), e.getLong("currency.id"))) continue;
                    result.put((Object)e.getLong("entity.id"), (Object)e);
                }
            }
        }
        return result;
    }

    private LinkedHashMultimap<Long, DynamicObject> getAllTemplateByOrg(HashMap<String, Long> f7IdMap) {
        Set selectOrgIdSet = QueryMemberDetailsHelper.change2BaseMember(this.getOrgRange());
        Set<Long> templateIds = this.getTemplateIds(this.getTabInfo(TABINFO_TEMP).id + "", true, false);
        PaperTmplChainFilter tmplFilter = new PaperTmplChainFilter(Long.valueOf(this.getModelId()), PaperTemplateTypeEnum.INNERTRADE);
        tmplFilter.addFilter((AbstractPaperFilter)new VersionFilter(f7IdMap.get(yearf7id), f7IdMap.get(periodf7id))).addFilter((AbstractPaperFilter)new SceneFilter(f7IdMap.get(scenariof7id))).addFilter((AbstractPaperFilter)new YearPeriodFilter(f7IdMap.get(yearf7id), f7IdMap.get(periodf7id))).addFilter((AbstractPaperFilter)new StatusFilter(Boolean.valueOf(true)));
        Set filterIds = tmplFilter.doFilter(templateIds);
        LinkedHashMultimap orgTmpIds = IntrTemplateHelper.queryDispensedTmpls((Long)f7IdMap.get(modelf7id), (Set)selectOrgIdSet, (Set)filterIds);
        Set groupTmpIds = IntrTemplateHelper.getGroupTmplIds((Long)this.getModelId(), templateIds);
        DynamicObjectCollection fillReocrd = IntrReportHelper.getFillReocrd((Long)this.getModelId(), (long)f7IdMap.get(scenariof7id), (Set)Sets.newHashSet((Object[])new Long[]{f7IdMap.get(yearf7id)}), (Set)Sets.newHashSet((Object[])new Long[]{f7IdMap.get(periodf7id)}), (Set)selectOrgIdSet, (Set)groupTmpIds);
        fillReocrd.forEach(e -> orgTmpIds.put((Object)e.getLong("entity"), (Object)e.getLong("papertemplate")));
        LinkedHashMultimap<Long, Long> listMultimap = this.dealOrgOrder((LinkedHashMultimap<Long, Long>)orgTmpIds);
        Set tmplIds = listMultimap.entries().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        Map<Long, Object> result = new HashMap<Long, DynamicObject>(16);
        if (tmplIds != null && !tmplIds.isEmpty()) {
            QFilter filter = new QFilter(model, "=", (Object)f7IdMap.get(modelf7id));
            filter.and(new QFilter(ID, "in", tmplIds));
            DynamicObject[] temps = BusinessDataServiceHelper.load((String)"bcm_papertemplate", (String)"id,number,name,usage,templatecatalog,versionnumber", (QFilter[])new QFilter[]{filter}, (String)"sequence asc,number asc,versionnumber asc");
            if (temps != null && temps.length > 0) {
                result = Arrays.stream(temps).collect(Collectors.toMap(e -> e.getLong(ID), k -> k, (u, v) -> u, LinkedHashMap::new));
            }
        }
        LinkedHashMultimap orgTempMap = LinkedHashMultimap.create();
        for (Long orgId : listMultimap.keySet()) {
            Set tempIds = listMultimap.get((Object)orgId);
            result.forEach((k, v) -> {
                if (tempIds.contains(k)) {
                    orgTempMap.put((Object)orgId, v);
                }
            });
        }
        return orgTempMap;
    }

    private LinkedHashMultimap<Long, Long> dealOrgOrder(LinkedHashMultimap<Long, Long> map) {
        List listKeys;
        if (map.size() > 0 && (listKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_entitymembertree", (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)map.keySet())}, (String)"longnumber asc", (int)-1)).size() > 0) {
            LinkedHashMultimap newOrderMultimap = LinkedHashMultimap.create();
            listKeys.forEach(orgId -> {
                Set tempids = map.get((Object)ConvertUtil.convertObjToLong((Object)orgId));
                if (tempids != null) {
                    tempids.forEach(t -> newOrderMultimap.put((Object)ConvertUtil.convertObjToLong((Object)orgId), t));
                }
            });
            return newOrderMultimap;
        }
        return map;
    }

    private boolean checkDimOfUserSelected(boolean mustOrgSelect) {
        String modelid = this.getPageCache().get(modelCacheKey);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)modelid)) {
            return false;
        }
        IDataModel dataModel = this.getModel();
        DynamicObject cslschemeDyn = (DynamicObject)dataModel.getValue(ctl_cslscheme);
        if (cslschemeDyn == null) {
            return false;
        }
        DynamicObject scenceDyn = (DynamicObject)dataModel.getValue("scenario");
        if (scenceDyn == null) {
            return false;
        }
        DynamicObject yearDyn = (DynamicObject)dataModel.getValue("year");
        if (yearDyn == null) {
            return false;
        }
        DynamicObject periodDyn = (DynamicObject)dataModel.getValue("period");
        if (periodDyn == null) {
            return false;
        }
        DynamicObject currencyDyn = (DynamicObject)dataModel.getValue(currency);
        if (currencyDyn == null) {
            return false;
        }
        return !mustOrgSelect || !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)this.getPageCache().get("entityselectedNodeId"));
    }

    private void searchMember(String text, boolean isentity) {
        TreeModel treeModel;
        TreeView treeView;
        ArrayList<String> list = new ArrayList<String>(10);
        if (isentity) {
            treeView = (TreeView)this.getControl(treeview_entity);
            treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)cache_treeorg);
        } else {
            treeView = (TreeView)this.getControl(treeview_template);
            treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)cache_treetemplate);
        }
        if (treeModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"ReportListPlugin_82", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ITreeNode root = treeModel.getRoot();
        List lists = treeModel.seekAllChildrenIf(root.getId(), p -> p.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH)));
        for (AbstractTreeNode node : lists) {
            list.add(node.getId());
        }
        if (list.size() > 0) {
            if (isentity) {
                this.getPageCache().put(ROWLLIST, SerializationUtils.toJsonString(list));
                this.getPageCache().put(LFOCUS, "0");
            } else {
                this.getPageCache().put(ROWRLIST, SerializationUtils.toJsonString(list));
                this.getPageCache().put(RFOCUS, "0");
            }
            String focusnode = (String)list.get(0);
            ITreeNode parent = ((AbstractTreeNode)treeModel.searchByNodeId(focusnode)).getParent();
            String parentId = parent == null ? null : parent.getId();
            treeView.focusNode(new TreeNode(parentId, focusnode, ""));
            treeView.treeNodeClick(parentId, focusnode);
            while (parentId != null) {
                String temp = parentId;
                treeView.expand(temp);
                if (((AbstractTreeNode)treeModel.searchByNodeId(temp)).getParent() != null) {
                    parentId = ((AbstractTreeNode)treeModel.searchByNodeId(temp)).getParent().getId();
                    continue;
                }
                break;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"ReportListPlugin_82", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void refreshList() {
        this.refreshAllTreeAndBill(true);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if ("templatenumber".equals(e.getFieldName())) {
            DynamicObject rowData = this.getModel().getEntryRowEntity(entryentity, e.getRowIndex());
            String usage = IntrTemplateHelper.getTemplateInfo((Long)this.getModelId(), (Long)rowData.getLong("templateid")).getString("usage");
            boolean isCslReport = "1".equals(usage);
            HashMap<String, Long> f7Map = this.getF7id();
            if (f7Map != null) {
                IntrReportPostmanByTemplate param = new IntrReportPostmanByTemplate(rowData.getLong("templateid"), f7Map.get(scenariof7id), f7Map.get(yearf7id), f7Map.get(periodf7id), f7Map.get(currencyf7id), f7Map.get(modelf7id), isCslReport);
                param.setReadonly(this.checkReadOnly(rowData.getLong("entityid"), rowData.getLong("templateid")));
                param.addPair(rowData.getLong("entityrealid"), rowData.getString("entitynumber"));
                param.addPair(rowData.getString("templatenumber"), rowData.getString("templatename"));
                IFormView mainPageView = this.getView().getMainView();
                IFormView parentView = this.getView().getParentView();
                String menuPageID = this.getMenuPageId(param);
                if (mainPageView == null || mainPageView.getView(menuPageID) == null) {
                    FormShowParameter formShowParameter = new FormShowParameter();
                    if (isCslReport) {
                        formShowParameter.setFormId("bcm_intrcslreport");
                    } else {
                        formShowParameter.setFormId("bcm_innertradereport");
                    }
                    formShowParameter.setCustomParam("reportpostman", (Object)ObjectSerialUtil.toByteSerialized((Object)param));
                    String caption = "";
                    caption = isCslReport ? ResManager.loadKDString((String)"\u5185\u90e8\u62b5\u9500\u586b\u62a5\uff08\u5f55\u5165\uff09", (String)"IntrReportListPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5185\u90e8\u62b5\u9500\u586b\u62a5\uff08\u5408\u5e76\uff09", (String)"IntrReportListPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    formShowParameter.setCaption(caption + " : " + rowData.getString("entityname"));
                    formShowParameter.setPageId(menuPageID);
                    formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
                    formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
                    if (parentView != null && mainPageView != null) {
                        formShowParameter.setParentPageId(parentView.getPageId());
                        formShowParameter.setParentFormId(parentView.getEntityId());
                        parentView.showForm(formShowParameter);
                        this.getView().sendFormAction(parentView);
                    } else {
                        this.getView().showForm(formShowParameter);
                    }
                } else {
                    IFormView childFormView = mainPageView.getView(menuPageID);
                    childFormView.activate();
                    FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childFormView.getService(FormViewPluginProxy.class);
                    IntrReportPostmanByTemplate pm = param;
                    pluginProxy.getPlugIns().forEach(item -> {
                        if (IIncreaseReportTab.class.isAssignableFrom(item.getClass())) {
                            ((IIncreaseReportTab)IIncreaseReportTab.class.cast(item)).increaseReportTab(pm);
                        }
                    });
                    this.getView().sendFormAction(childFormView);
                }
            }
        }
    }

    private boolean checkReadOnly(Long orgId, Long templateId) {
        LinkedHashMultimap readOnlyMap;
        String readOnlyStr = this.getPageCache().get(READ_ONLY_TMPL_MAP);
        if (StringUtils.isNotBlank((CharSequence)readOnlyStr) && (readOnlyMap = (LinkedHashMultimap)ObjectSerialUtil.deSerializedBytes((String)readOnlyStr)) != null && readOnlyMap.size() > 0 && readOnlyMap.containsEntry((Object)orgId, (Object)templateId)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getMenuPageId(IntrReportPostmanByTemplate param) {
        return PREFIX_TEMPLETE + param.getEntityPK(param.getPairs().get(0)) + "_" + this.getView().getPageId() + param.isCslReport() + "_" + this.getF7NumKey(param);
    }

    private String getF7NumKey(IntrReportPostmanByTemplate pm) {
        String modelNum = ((DynamicObject)this.getModel().getValue(model)).getString(NUMBER);
        ArrayList otherDim = Lists.newArrayList((Object[])new String[]{MemberReader.findScenaMemberById((String)modelNum, (Long)((Long)pm.getScenarioPK())).getNumber(), MemberReader.findFyMemberById((String)modelNum, (Long)((Long)pm.getYearPK())).getNumber(), MemberReader.findPeriodMemberById((String)modelNum, (Long)((Long)pm.getPeriodPK())).getNumber(), MemberReader.findCurrencyMemberById((String)modelNum, (Long)((Long)pm.getCurrencyPK())).getNumber()});
        return Joiner.on((char)'-').join((Iterable)otherDim);
    }

    static class TabInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty
        private long id;
        @JsonProperty
        private String name;
        @JsonProperty
        private boolean isSelcectRoot = true;

        TabInfo() {
            this.name = ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"ReportListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }

        TabInfo(long id, String name, boolean isSelcectRoot) {
            this.id = id;
            this.name = name;
            this.isSelcectRoot = isSelcectRoot;
        }

        public static long getSerialVersionUID() {
            return 1L;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isSelcectRoot() {
            return this.isSelcectRoot;
        }

        public void setSelcectRoot(boolean selcectRoot) {
            this.isSelcectRoot = selcectRoot;
        }
    }
}

