/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.innertrade.report.multi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrTplDimScope;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.innertrade.report.QueryIntrDataHelper;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.innertrade.IntrDimDisplayModeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.common.util.ToStringHelper;
import kd.fi.bcm.formplugin.innertrade.report.multi.IntrReportPostmanByTemplate;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class IntrReportTabInfo
implements Serializable {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(IntrReportTabInfo.class);
    private static final long serialVersionUID = -8065859910169822267L;
    private String tabKey;
    private String tabName;
    private Long modelId;
    private Long entityId;
    private Long entityStorageId;
    private Long entityCurrencyId;
    private Long scenarioId;
    private boolean isCslReport = false;
    private Long yearId;
    private Long periodId;
    private Long currencyId;
    private boolean isSelected = false;
    private boolean readOnly = false;
    private boolean lock = false;
    private Long reportId;
    private String status;
    private Long templateId;
    private String number;
    private String name;
    private List<Cell> headRow;
    private Pair<Integer, Integer> startPoint = Pair.onePair((Object)1, (Object)0);
    private String areaPoint;
    private Map<String, Integer> fieldIndexMap;
    private int colSize = 0;
    private List<IntrField> fileds = null;
    private Map<String, IntrField> fileMap = null;
    private Map<String, IntrTplDimScope> dimScopeMap;
    private Date showTipDate;

    public IntrReportTabInfo(IntrReportPostmanByTemplate pm) {
        this.tabKey = pm.getTabKey(pm.getPairs().get(0));
        this.tabName = pm.getPairs().get((int)1).p2.toString();
        this.modelId = LongUtil.toLong((Object)pm.getModelPK());
        this.reportId = null;
        this.entityStorageId = this.entityId = LongUtil.toLong((Object)pm.getPairs().get((int)0).p1);
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)this.modelId), (Long)this.entityId);
        if (orgNode.isShare()) {
            this.entityStorageId = orgNode.getCopyfromId();
        }
        this.scenarioId = LongUtil.toLong((Object)pm.getScenarioPK());
        this.yearId = LongUtil.toLong((Object)pm.getYearPK());
        this.periodId = LongUtil.toLong((Object)pm.getPeriodPK());
        this.currencyId = LongUtil.toLong((Object)pm.getCurrencyPK());
        this.entityCurrencyId = OrgCurrencyServiceHelper.getCurrencyDynById((Long)this.entityId, (Long)this.yearId, (Long)this.periodId).getLong("id");
        this.readOnly = pm.isReadonly();
        this.isCslReport = pm.isCslReport();
        this.changeTemplate(LongUtil.toLong((Object)pm.getTemplatePK(null)), false);
        this.changeReport(null, null);
    }

    public final void changeTemplate(Long tmplId, boolean isForceUpdate) {
        if (isForceUpdate || this.templateId == null || !this.templateId.equals(tmplId)) {
            this.fileds = null;
            this.fieldIndexMap = null;
            this.fileMap = null;
            this.startPoint = null;
            this.colSize = 0;
            this.dimScopeMap = null;
            this.templateId = tmplId;
            DynamicObject ts = IntrTemplateHelper.getAllTemplateInfo((Long)this.getModelId(), (Long)tmplId);
            this.number = ts.getString("number");
            this.name = ts.getString("name");
            this.showTipDate = (Date)JsonSerializerUtil.toSpreadManager((String)ts.getString("data")).getBook().getSheet(0).getUserObject("intr_show_tip_date");
            this.areaPoint = ts.getString("areapoint");
            if (StringUtils.isNotBlank((CharSequence)this.getAreaPoint())) {
                RangeModel range = SpreadAreaUtil.getRangModel((String)this.getAreaPoint());
                this.startPoint = Pair.onePair((Object)(range.getY_start() + 1), (Object)range.getX_start());
                this.colSize = range.getColSize();
            }
            this.fileds = this.getMergeFileds(tmplId, this.isCslReport);
            this.fileMap = this.fileds.stream().collect(Collectors.toMap(IntrField::getNumber, item -> item));
            this.dimScopeMap = IntrTemplateHelper.getDimScope((Long)this.templateId);
        }
    }

    private List<IntrField> getMergeFileds(long tmplId, boolean isCslReport) {
        List intrFields = new ArrayList(16);
        intrFields = isCslReport ? QueryIntrDataHelper.queryMergeFieldsForCsl((Long)tmplId) : QueryIntrDataHelper.queryMergeFieldsForMerge((Long)tmplId);
        return intrFields;
    }

    public void changeRptStyle(SpreadManager sm) {
        this.fieldIndexMap = null;
        this.headRow = new ArrayList<Cell>(1);
        if (sm != null) {
            this.headRow = sm.getBook().getSheet(0).getRow((Integer)this.getStartPoint().p1 - 1, true);
            this.fileds = this.fileds.stream().sorted(Comparator.comparingInt(e -> this.getColIndex(e.getNumber()))).collect(Collectors.toList());
        }
    }

    public final void changeReport(Long rptId, String status) {
        this.reportId = rptId;
        this.status = status;
    }

    public Map<String, Integer> getFieldIndexMap() {
        if (this.fieldIndexMap == null && !CollectionUtil.isEmpty(this.headRow) && this.getStartPoint() != null) {
            this.fieldIndexMap = new HashMap<String, Integer>(16);
            RangeModel range = SpreadAreaUtil.getRangModel((String)this.getAreaPoint());
            this.fieldIndexMap.put(IntrConstant.FIELD_ORG_NUMBER, (Integer)this.getStartPoint().p2);
            this.fieldIndexMap.put(IntrConstant.FIELD_IC_NUMBER, (Integer)this.getStartPoint().p2 + 1);
            for (int i = ((Integer)this.getStartPoint().p2).intValue(); i <= range.getX_end(); ++i) {
                Cell cell = this.headRow.get(i);
                if (cell.getUserObject() == null || cell.getUserObject().size() <= 0 || cell.getUserObject("number") == null) continue;
                String number = cell.getUserObject("number").toString();
                if (IntrConstant.FIELD_ORG_NUMBER.equalsIgnoreCase(number)) {
                    number = IntrConstant.FIELD_ORG_NUMBER;
                }
                if (IntrConstant.FIELD_IC_NUMBER.equalsIgnoreCase(number)) {
                    number = IntrConstant.FIELD_IC_NUMBER;
                }
                this.fieldIndexMap.put(number, i);
            }
        }
        return this.fieldIndexMap;
    }

    public int getColIndex(String fieldNumber) {
        Integer index = this.getFieldIndexMap().get(fieldNumber);
        if (index == null) {
            log.error(String.format("\u627e\u4e0d\u5230\u5b57\u6bb5number=\"%s\"\u7684\u5217\u4e0b\u6807,areaPoint=\"%s\",startPoint=\"%s\",\u6a21\u677f\u7684\u7f16\u7801=%s\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u914d\u7f6e\u3002", fieldNumber, this.areaPoint, this.startPoint, this.getNumber()));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5b57\u6bb5\u201c%s\u201d\u7684\u5217\u4e0b\u6807\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u914d\u7f6e\u3002", (String)"IntrReportTabInfo_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), fieldNumber));
        }
        return index;
    }

    public IntrField getField(int col) {
        String fieldNumber = null;
        Cell cell = this.headRow.get(col);
        if (cell.getUserObject() != null && cell.getUserObject().size() > 0 && cell.getUserObject("number") != null) {
            fieldNumber = cell.getUserObject("number").toString();
        }
        if (fieldNumber == null) {
            if (col == (Integer)this.getStartPoint().p2) {
                fieldNumber = IntrConstant.FIELD_ORG_NUMBER;
            } else if (col == (Integer)this.getStartPoint().p2 + 1) {
                fieldNumber = IntrConstant.FIELD_IC_NUMBER;
            }
        }
        return this.getFieldByNumber(fieldNumber);
    }

    public IntrField getFieldByNumber(String fieldNumber) {
        IntrField field = this.fileMap.get(fieldNumber);
        if (field == null) {
            log.error(String.format("\u627e\u4e0d\u5230\u5b57\u6bb5number=\"%s\"\u7684\u5b57\u6bb5\u914d\u7f6e,areaPoint=\"%s\",startPoint=\"%s\",\u6a21\u677f\u7684\u7f16\u7801=%s\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u914d\u7f6e\u3002", fieldNumber, this.areaPoint, this.startPoint, this.getNumber()));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5b57\u6bb5\u201c%s\u201d\u7684\u5b57\u6bb5\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u914d\u7f6e\u3002", (String)"IntrReportTabInfo_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), fieldNumber));
        }
        return field;
    }

    public Set<Long> getMemberIds(String fieldNum) {
        if (this.dimScopeMap.get(fieldNum) == null) {
            return null;
        }
        return this.dimScopeMap.get(fieldNum).getMemberIds();
    }

    public List<Object> getEnums(String fieldNum) {
        if (this.dimScopeMap.get(fieldNum) == null) {
            return null;
        }
        return this.dimScopeMap.get(fieldNum).getEnumList();
    }

    public IntrDimDisplayModeEnum getDisplayMode(String fieldNum) {
        if (this.dimScopeMap.get(fieldNum) == null || this.dimScopeMap.get(fieldNum).getDisplayMode() == null) {
            return IntrDimDisplayModeEnum.NUMBERANDNAME;
        }
        return this.dimScopeMap.get(fieldNum).getDisplayMode();
    }

    public boolean isFix(String fieldNum) {
        if (this.dimScopeMap.get(fieldNum) == null) {
            return false;
        }
        return this.dimScopeMap.get(fieldNum).isFix();
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public int getColSize() {
        return this.colSize;
    }

    public String getTabName() {
        return this.tabName;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public String getTabKey() {
        return this.tabKey;
    }

    public String getSpeadCacheKey() {
        return String.format("%s_%s_%s_%s_%s", this.getScenarioId(), this.getYearId(), this.getPeriodId(), this.getCurrencyId(), this.getTemplateId());
    }

    public Long getReportId() {
        return this.reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public Long getScenarioId() {
        return this.scenarioId;
    }

    public Long getYearId() {
        return this.yearId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public void setYearId(Long yearId) {
        this.yearId = yearId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public List<Cell> getHeadRow() {
        return this.headRow;
    }

    public void setHeadRow(List<Cell> headRow) {
        this.headRow = headRow;
    }

    public String toString() {
        return ToStringHelper.reflectionToString((Object)this);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStartPoint(Pair<Integer, Integer> startPoint) {
        this.startPoint = startPoint;
    }

    public Pair<Integer, Integer> getStartPoint() {
        return this.startPoint;
    }

    public String getAreaPoint() {
        return this.areaPoint;
    }

    public Long getEntityCurrencyId() {
        return this.entityCurrencyId;
    }

    public void setEntityCurrencyId(Long entityCurrencyId) {
        this.entityCurrencyId = entityCurrencyId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public boolean isCslReport() {
        return this.isCslReport;
    }

    public List<IntrField> getFileds() {
        return this.fileds;
    }

    public Map<String, IntrTplDimScope> getDimScopeMap() {
        return this.dimScopeMap;
    }

    public Map<String, IntrField> getFileMap() {
        return this.fileMap;
    }

    public Date getShowTipDate() {
        return this.showTipDate;
    }

    public Long getEntityStorageId() {
        return this.entityStorageId;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.tabKey).toHashCode();
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (obj instanceof IntrReportTabInfo) {
            IntrReportTabInfo o = (IntrReportTabInfo)obj;
            isEquals = new EqualsBuilder().append((Object)this.tabKey, (Object)o.getTabKey()).isEquals();
        }
        return isEquals;
    }
}

