/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.innertrade.report.multi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.fi.bcm.formplugin.innertrade.report.multi.IntrReportTabInfo;
import org.apache.commons.collections4.CollectionUtils;

public class IntrReportTabManager
implements Serializable {
    private static final long serialVersionUID = 1404403617687847395L;
    private List<IntrReportTabInfo> tabs = new ArrayList<IntrReportTabInfo>();

    public boolean addReportTabInfo(IntrReportTabInfo tab) {
        if (this.tabs.contains(tab)) {
            return false;
        }
        return this.tabs.add(tab);
    }

    public boolean addReportTabInfo4List(IntrReportTabInfo tab) {
        boolean hasExists = this.tabs.stream().anyMatch(e -> e.getTabKey().equals(tab.getTabKey()));
        if (!hasExists) {
            this.tabs.add(tab);
        }
        return !hasExists;
    }

    public IntrReportTabInfo searchTab(String tabKey) {
        for (IntrReportTabInfo t : this.tabs) {
            if (!tabKey.equals(t.getTabKey())) continue;
            return t;
        }
        return null;
    }

    public void releaseAll() {
        this.tabs.clear();
    }

    public void releaseByKey(String key) {
        int index = -1;
        for (int i = 0; i < this.tabs.size(); ++i) {
            IntrReportTabInfo tab = this.tabs.get(i);
            if (!tab.getTabKey().equals(key)) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.tabs.remove(index);
        }
    }

    public String getLastTabKey() {
        if (CollectionUtils.isNotEmpty(this.tabs)) {
            return this.tabs.get(this.tabs.size() - 1).getTabKey();
        }
        return null;
    }

    public Iterator<IntrReportTabInfo> iterator() {
        return this.tabs.iterator();
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public void setSelectReportTabInfo(String tabKey) {
        this.tabs.forEach(e -> e.setSelected(e.getTabKey().equals(tabKey)));
    }

    public IntrReportTabInfo getCurrSelectReportTabInfo() {
        for (IntrReportTabInfo tab : this.tabs) {
            if (!tab.isSelected()) continue;
            return tab;
        }
        return null;
    }

    public IntrReportTabInfo getFirstReportTabInfo() {
        return this.tabs.size() > 0 ? this.tabs.get(0) : null;
    }

    public IntrReportTabInfo searchTabByTemplateId(Object templateId) {
        if (templateId != null) {
            for (IntrReportTabInfo tab : this.tabs) {
                if (!templateId.equals(tab.getTemplateId())) continue;
                return tab;
            }
        }
        return this.getFirstReportTabInfo();
    }

    public List<IntrReportTabInfo> getTabs() {
        return this.tabs;
    }
}

