/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.formplugin.report.util.DataCollectUtil;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public class AutoDataCollectByOrgPlugin
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dys = e.getDataEntities();
        if (dys.length == 0) {
            return;
        }
        long orgid = dys[0].getLong("id");
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_entitymembertree", (String)"model.id,model.number", (QFilter[])new QFilter[]{QFilter.of((String)"id = ?", (Object[])new Object[]{orgid})});
        if (model == null) {
            return;
        }
        long modelId = model.getLong("model.id");
        Date date = TimeServiceHelper.now();
        int year = DateTimeUtils.getYear((Date)date);
        int month = DateTimeUtils.getMonth((Date)date);
        String periodNum = month < 10 ? "M_M0" + month : "M_M" + month;
        DynamicObject periodObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (QFilter[])new QFilter[]{QFilter.of((String)"model = ? and number = ?", (Object[])new Object[]{modelId, periodNum})});
        if (periodObj == null) {
            return;
        }
        HashMap<String, ArrayList<DynamicObject>> periodDys = new HashMap<String, ArrayList<DynamicObject>>();
        HashMap orgPeriod = new HashMap();
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        DynamicObject[] orgPeriodMap = BusinessDataServiceHelper.load((String)"bcm_org_period", (String)"org,period", (QFilter[])filter.toArray());
        for (DynamicObject entity : orgPeriodMap) {
            String orgList = entity.getString("org");
            if (StringUtils.isEmpty((String)orgList)) continue;
            List list = SerializationUtils.fromJsonStringToList((String)orgList, Map.class);
            String periodId = entity.getString("period.id");
            for (Object o : list) {
                Map map = (Map)o;
                new MembRangeItem("bcm_entitymembertree", Long.valueOf(Long.parseLong((String)map.get("id"))), (String)map.get("number"), RangeEnum.getRangeByVal((int)Integer.parseInt((String)map.get("scope"))), !StringUtils.isEmpty((String)((String)map.get("pid"))), (Object)modelId).matchItems(m -> orgPeriod.put(m.number, periodId));
            }
        }
        if (orgPeriodMap.length == 0) {
            this.excuteDataCollect(dys, year, modelId, periodObj);
        } else {
            for (DynamicObject dy : dys) {
                String orgNum = dy.getString("number");
                String periodKey = (String)orgPeriod.get(orgNum);
                if (periodKey != null) {
                    this.addMutMap(periodDys, periodKey, dy);
                    continue;
                }
                String periodKeyOrigin = periodObj.getString("id");
                this.addMutMap(periodDys, periodKeyOrigin, dy);
            }
            for (Map.Entry entry : periodDys.entrySet()) {
                QFilter qf = new QFilter("id", "=", entry.getKey());
                DynamicObject periodNew = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (QFilter[])new QFilter[]{qf});
                String currentPeriod = periodNew.getString("number");
                if (!"LastPeriod".equals(currentPeriod)) {
                    this.excuteDataCollect(((ArrayList)entry.getValue()).toArray(new DynamicObject[0]), year, modelId, periodNew);
                    continue;
                }
                String[] yearPeriod = PeriodUtils.getLastPeriodIncludeYear((String)model.getString("model.number"), (String)("FY" + year), (String)periodObj.getString("number"), (boolean)false);
                periodNew = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (QFilter[])new QFilter[]{QFilter.of((String)"model = ? and number = ?", (Object[])new Object[]{modelId, yearPeriod[1]})});
                this.excuteDataCollect(((ArrayList)entry.getValue()).toArray(new DynamicObject[0]), Integer.parseInt(yearPeriod[0].substring(2)), modelId, periodNew);
            }
        }
    }

    private void excuteDataCollect(DynamicObject[] dys, int year, long modelId, DynamicObject periodObj) {
        String yearNum = "FY" + year;
        DynamicObject modelObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (QFilter[])new QFilter[]{QFilter.of((String)"id = ?", (Object[])new Object[]{modelId})});
        DynamicObject scenarioObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_scenemembertree", (QFilter[])new QFilter[]{QFilter.of((String)"model = ? and number = ?", (Object[])new Object[]{modelId, "MRpt"})});
        DynamicObject fyObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_fymembertree", (QFilter[])new QFilter[]{QFilter.of((String)"model = ? and number = ?", (Object[])new Object[]{modelId, yearNum})});
        HashSet<Long> orgids = new HashSet<Long>(16);
        for (DynamicObject dy : dys) {
            orgids.add(dy.getLong("id"));
        }
        Map orgMap = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense((Long)modelId);
        HashMultimap organdtmp = HashMultimap.create();
        for (Map.Entry entry : orgMap.entrySet()) {
            long templateId = (Long)entry.getKey();
            Iterator iterator = ((Set)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                long orgId = (Long)iterator.next();
                if (!orgids.contains(orgId)) continue;
                organdtmp.put((Object)orgId, (Object)templateId);
            }
        }
        DataCollectUtil.easyBatchExecuteDC(null, (Multimap<Long, Long>)organdtmp, null, modelObj, scenarioObj, fyObj, periodObj, true, true, null);
    }

    private void addMutMap(Map<String, ArrayList<DynamicObject>> periodDys, String periodKey, DynamicObject dy) {
        if (periodDys.containsKey(periodKey)) {
            periodDys.get(periodKey).add(dy);
        } else {
            ArrayList<DynamicObject> dyFirst = new ArrayList<DynamicObject>();
            dyFirst.add(dy);
            periodDys.put(periodKey, dyFirst);
        }
    }
}

