/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.formula.register.FormulaConfig;
import kd.fi.bcm.business.formula.register.FormulaRegister;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.invest.InvFormulaLogTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.util.CollectCalculateHelp;

public class DataCollectLogPlugin
extends AbstractBaseListPlugin {
    private static final Set<String> dimKeys = Sets.newHashSet((Object[])new String[]{"scenario", "year", "period"});
    private static final String LOG_TYPE = "logtype";

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(new ArrayList<String>(dimKeys), SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
        this.setBillFromId();
    }

    private void setBillFromId() {
        if (this.getPageCache().get(LOG_TYPE) != null) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.getContext().getEntryEntityDtos().clear();
            InvFormulaLogTypeEnum logTypeEnum = InvFormulaLogTypeEnum.getEnumByNumber((String)((String)this.getModel().getValue(LOG_TYPE)));
            if (logTypeEnum != null) {
                billList.setBillFormId(logTypeEnum.getLogEntity());
                billList.setEntityId(logTypeEnum.getLogEntity());
                billList.setEntryEntity(logTypeEnum.getLogEntity());
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!this.isExitModel()) {
            return;
        }
        this.initF7FromParent();
        this.getPageCache().put(LOG_TYPE, "0");
    }

    private void initF7FromParent() {
        if (StringUtils.isEmpty((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")))) {
            return;
        }
        long modelId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        Object yearId = this.getView().getFormShowParameter().getCustomParams().get(DimTypesEnum.YEAR.getNumber());
        Object periodId = this.getView().getFormShowParameter().getCustomParams().get(DimTypesEnum.PERIOD.getNumber());
        Object sceneId = this.getView().getFormShowParameter().getCustomParams().get(DimTypesEnum.SCENARIO.getNumber());
        this.getModel().endInit();
        this.getModel().setValue("model", (Object)modelId);
        this.getModel().setValue("scenario", sceneId);
        this.getModel().setValue("year", yearId);
        this.getModel().setValue("period", periodId);
        Object logtype = this.getView().getFormShowParameter().getCustomParams().get(LOG_TYPE);
        if (logtype != null) {
            this.getModel().setValue(LOG_TYPE, logtype);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{LOG_TYPE, "model", "scenario", "year", "period"});
        }
    }

    private QFilter getOrgTemFilter() {
        JSONArray json;
        Map tmap = this.getView().getFormShowParameter().getCustomParams();
        QFilter filter = null;
        if (!ObjectUtils.isEmpty(tmap.get("orgNumbers")) && (json = (JSONArray)tmap.get("orgNumbers")).size() > 0) {
            filter = new QFilter("org.number", "in", (Object)json.toArray());
        }
        if (!ObjectUtils.isEmpty(tmap.get("temNumbers")) && (json = (JSONArray)tmap.get("temNumbers")).size() > 0) {
            if (filter != null) {
                filter.and(new QFilter("template.number", "in", (Object)json.toArray()));
            } else {
                filter = new QFilter("template.number", "in", (Object)json.toArray());
            }
        }
        if (!ObjectUtils.isEmpty(tmap.get("temIds")) && (json = (JSONArray)tmap.get("temIds")).size() > 0) {
            if (filter != null) {
                filter.and(new QFilter("template.id", "in", (Object)json.toArray()));
            } else {
                filter = new QFilter("template.id", "in", (Object)json.toArray());
            }
        }
        return filter;
    }

    public boolean isExitModel() {
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelid)) {
            QFilter filter = new QFilter("reporttype", "=", (Object)"1");
            if (this.isRPT()) {
                filter.or(new QFilter("reportType", "=", (Object)ApplicationTypeEnum.RPT.getOIndex())).or(new QFilter("reportType", "=", (Object)"5"));
            }
            if (!QueryServiceHelper.exists((String)"bcm_model", (QFilter[])new QFilter[]{filter})) {
                this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
                return false;
            }
        }
        return true;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getChangeSet()[0].getNewValue() == e.getChangeSet()[0].getOldValue()) {
            return;
        }
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            this.propertyChangedModelUse(new ArrayList<String>(dimKeys));
            this.refreshBillList();
        } else if (dimKeys.contains(key)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            Boolean isSureReturn = this.propertyChangedDimUse(key, newValue, false, false);
            if (!isSureReturn.booleanValue()) {
                return;
            }
            this.refreshBillList();
        } else if (LOG_TYPE.equals(key)) {
            this.refreshBillList();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "refresh": {
                this.refreshBillList();
                break;
            }
            case "clear": {
                this.clearLog();
                this.refreshBillList();
                break;
            }
            case "delete": {
                this.deleteLog();
                this.refreshBillList();
                break;
            }
            case "bar_register": {
                FormulaRegister.reExternalFormulaResister();
                FormulaConfig.getInstance().redoReadConfig();
                FormulaRegister.changeInnerRegisterFormulas((boolean)ConfigServiceHelper.getGlobalBoolParam((String)"isTPEnableExcelFormula"));
                Set canBatchFormulaNums = DataCollectUtil.getCanBatchFormulaNums();
                CollectCalculateHelp.batchSupportFormulas.addAll(canBatchFormulaNums);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u516c\u5f0f\u6ce8\u518c\u5df2\u5b8c\u6210\u3002", (String)"DataCollectedNewPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void deleteLog() {
        ArrayList<Long> selectRowsId = new ArrayList<Long>();
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection cos = billlistap.getSelectedRows();
        for (ListSelectedRow listSelectedRow : cos) {
            selectRowsId.add(Long.valueOf(listSelectedRow.getPrimaryKeyValue().toString()));
        }
        if (null == selectRowsId || selectRowsId.size() <= 0) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", selectRowsId);
        DeleteServiceHelper.delete((String)"bcm_datacollectlog", (QFilter[])new QFilter[]{qFilter});
        this.refreshBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"DataCollectLogPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5220\u9664", "DataCollectLogPlugin_2", "fi-bcm-formplugin", "Delete"), new OPDescMultiLangEnumBridge("\u5220\u9664\u6210\u529f", "DataCollectLogPlugin_1", "fi-bcm-formplugin", null));
    }

    private void clearLog() {
        QFilter modelQFilter = new QFilter("model", "=", (Object)this.getModelId());
        modelQFilter.and(new QFilter(LOG_TYPE, "=", this.getModel().getValue(LOG_TYPE)));
        DeleteServiceHelper.delete((String)"bcm_datacollectlog", (QFilter[])new QFilter[]{modelQFilter, PermClassEntityHelper.getNoPermMemberFilter((Long)this.getModelId())});
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u6e05\u7a7a", "DataCollectLogPlugin_3", "fi-bcm-formplugin", "Clear"), new OPDescMultiLangEnumBridge("\u6e05\u7a7a\u6210\u529f", "DataCollectLogPlugin_4", "fi-bcm-formplugin", null));
    }

    private void refreshBillList() {
        this.setBillFromId();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
        billList.setOrderBy("collecttime desc");
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        QFilter orgTemFilter;
        super.setFilter(e);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        QFilter dimFilter = this.getDimsQilter();
        filterList.add(dimFilter);
        for (int i = filterList.size() - 1; i > -1; --i) {
            QFilter filter = (QFilter)filterList.get(i);
            String property = filter.getProperty();
            if (!"execstatus".equals(property)) continue;
            filterList.remove(filter);
            Iterator value = filter.getValue();
            QFilter execstatusfilter = value.getClass().equals(String.class) ? this.getExecststusFilter(String.valueOf(value), dimFilter) : this.getExecststusFilter(String.valueOf(((ArrayList)((Object)value)).get(0)), dimFilter);
            if (execstatusfilter == null) continue;
            filterList.add(execstatusfilter);
        }
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DataCollectLogPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        QFilter orgMeberFilter = PermClassEntityHelper.getNoPermMemberFilter((Long)Long.parseLong(modelId));
        if (orgMeberFilter != null) {
            filterList.add(orgMeberFilter);
        }
        QFBuilder qfBuilder = new QFBuilder();
        for (QFilter tem : filterList) {
            if (qfBuilder.size() == 0) {
                qfBuilder.add(tem);
                continue;
            }
            qfBuilder.and(tem);
        }
        if ("0".equals(this.getModel().getValue(LOG_TYPE))) {
            qfBuilder.or("model", "=", (Object)0L);
        }
        if ((orgTemFilter = this.getOrgTemFilter()) != null) {
            qfBuilder.add(orgTemFilter);
        }
        e.setCustomQFilters(qfBuilder.toList());
    }

    @Override
    public String getPermEntity(String entityId) {
        return "bcm_datacollection";
    }

    @Override
    public String getPermOpKey(String opKey) {
        if (opKey.equals("clear") || opKey.equals("delete")) {
            opKey = "bar_clear";
        }
        return opKey;
    }

    private QFilter getDimsQilter() {
        QFilter filter = new QFilter("1", "=", (Object)1);
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
        String scenarioId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
        String yearId = UserSelectUtil.getF7SelectId(this.getView(), "year");
        String periodId = UserSelectUtil.getF7SelectId(this.getView(), "period");
        if (StringUtils.isEmpty((CharSequence)modelId) || StringUtils.isEmpty((CharSequence)scenarioId) || StringUtils.isEmpty((CharSequence)yearId) || StringUtils.isEmpty((CharSequence)periodId)) {
            filter.and(new QFilter("1", "=", (Object)0));
        } else {
            filter.and(new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId)));
            filter.and(new QFilter("scenario", "=", (Object)LongUtil.toLong((Object)scenarioId)));
            filter.and(new QFilter("fy", "=", (Object)LongUtil.toLong((Object)yearId)));
            filter.and(new QFilter("period", "=", (Object)LongUtil.toLong((Object)periodId)));
            filter.and(new QFilter(LOG_TYPE, "=", this.getModel().getValue(LOG_TYPE)));
        }
        return filter;
    }

    private QFilter getExecststusFilter(String value, QFilter dimFilter) {
        QFilter filter = null;
        switch (value) {
            case "last": {
                DynamicObjectCollection collectlog = QueryServiceHelper.query((String)"bcm_datacollectlog", (String)"id,collecttime", (QFilter[])new QFilter[]{dimFilter}, (String)"collecttime desc", (int)1);
                if (collectlog == null || collectlog.size() <= 0) {
                    return null;
                }
                filter = new QFilter("collecttime", "=", ((DynamicObject)collectlog.get(0)).get("collecttime"));
            }
        }
        return filter;
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }
}

