/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.DataCollectRecordEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class DataCollectProgressPlugin
extends AbstractBaseListPlugin
implements ProgresssListener {
    private static final String model = "model";
    private static final String scenario = "scenario";
    private static final String year = "year";
    private static final String period = "period";
    private List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    private static final String BILL_LIST_AP = "billlistap";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String REMAINDER = "remainder";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("datacollectbar");
        ((ProgressBar)this.getControl(PROGRESSBARAP)).addProgressListener((ProgresssListener)this);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addPackageDataListener(this::packageData);
        HashMap map = new HashMap(16);
        this.asMapF7toType(this.dimKeys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam(model);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        this.getModel().setValue(model, (Object)modelId);
        this.getModel().setValue(scenario, this.getView().getFormShowParameter().getCustomParam(scenario));
        this.getModel().setValue(year, this.getView().getFormShowParameter().getCustomParam(year));
        this.getModel().setValue(period, this.getView().getFormShowParameter().getCustomParam(period));
        this.refreshBill();
    }

    @Override
    public long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(model);
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataCollectProcessPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return model.getLong("id");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("close", "refresh");
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addAfterBindDataListener(this::afterBindData);
    }

    public void packageData(PackageDataEvent e) {
        String key;
        super.packageData(e);
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass()) && REMAINDER.equals(key = ((ColumnDesc)e.getSource()).getKey())) {
            int count = e.getRowData().getInt(REMAINDER);
            if (count == 0) {
                e.setFormatValue((Object)DataCollectRecordEnum.EXECUTED.getValue());
            } else {
                e.setFormatValue((Object)DataCollectRecordEnum.EXCUTING.getValue());
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.selectRows(0);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (!billList.getSelectedRows().isEmpty()) {
            long recordId = (Long)billList.getSelectedRows().get(0).getPrimaryKeyValue();
            this.dealProgressInfo(recordId, true, null);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "close": {
                this.getView().close();
                break;
            }
            case "refresh": {
                this.refreshBill();
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        BillList billList;
        String propertyName = e.getProperty().getName();
        boolean willReflesh = true;
        if (scenario.equals(propertyName)) {
            this.getModel().getDataEntity().set(period, null);
            willReflesh = false;
        } else if (model.equals(propertyName)) {
            this.getModel().getDataEntity().set(scenario, null);
            this.getModel().getDataEntity().set(year, null);
            this.getModel().getDataEntity().set(period, null);
            willReflesh = false;
        } else if ("showsuccess".equals(propertyName) && !(billList = (BillList)this.getView().getControl(BILL_LIST_AP)).getSelectedRows().isEmpty()) {
            long recordId = (Long)billList.getSelectedRows().get(0).getPrimaryKeyValue();
            this.dealProgressInfo(recordId, true, null);
        }
        if (willReflesh) {
            this.refreshBill();
        } else {
            this.getView().updateView();
        }
    }

    private void dealProgressInfo(Long recordId, boolean isClick, ProgressEvent evt) {
        String progressStr;
        int percent;
        DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)"bcm_collectrecord", (String)"model, count, remainder, createtime, endtime, group, creator.name");
        Long modelId = record.getLong("model.id");
        int count = record.getInt("count");
        Long groupId = record.getLong("group");
        QFilter qFilter = new QFilter(model, "=", (Object)modelId).and("group", "=", (Object)groupId);
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        DynamicObjectCollection dataCollects = QueryServiceHelper.query((String)"bcm_datacollect", (String)"collectstatus", (QFilter[])qFilter.toArray());
        int left = (int)dataCollects.stream().filter(e -> !Character.toString(DataCollectRecordEnum.EXECUTED.index).equals(e.getString("collectstatus"))).count();
        int finish = count - left;
        if (left == 0) {
            percent = 100;
            progressStr = ResManager.loadKDString((String)"\u5b8c\u6210", (String)"DataCollectProcessPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            if (record.getInt(REMAINDER) != 0) {
                record.set(REMAINDER, (Object)0);
                record.set("endtime", (Object)record.getDate("endtime"));
                BusinessDataWriter.update((IDataEntityType)record.getDataEntityType(), (Object[])new Object[]{record});
                this.refreshById(recordId);
            }
            bar.stop();
        } else {
            percent = finish * 100 / count;
            progressStr = String.format(ResManager.loadKDString((String)"\u8fdb\u5ea6: %s", (String)"DataCollectProcessPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), percent + "%");
            bar.start();
        }
        String countStr = String.format(ResManager.loadKDString((String)"\u53d6\u6570\u62a5\u8868\uff1a%1d\u5f20\uff0c\u5df2\u5904\u7406\uff1a%2d\u5f20\u3002", (String)"DataCollectProcessPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), count, finish);
        if (evt != null) {
            evt.setProgress(percent);
            evt.setText(progressStr);
        } else {
            bar.setPercent(percent, progressStr);
        }
        this.setProgressInfo(record, countStr);
    }

    private void setProgressInfo(DynamicObject record, String count) {
        Date beginTime = record.getDate("createtime");
        Date endTime = record.getDate("endtime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ((Label)this.getControl("username")).setText(record.getString("creator.name"));
        ((Label)this.getControl("count")).setText(count);
        ((Label)this.getControl("begintime")).setText(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\uff1a%s", (String)"DataCollectProcessPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sdf.format(beginTime)));
        String costTimeStr = "";
        if (endTime != null) {
            costTimeStr = this.dealCostTime(beginTime, endTime, sdf, costTimeStr);
        } else {
            ((Label)this.getControl("overtime")).setText("");
        }
        ((Label)this.getControl("costtime")).setText(costTimeStr);
    }

    private String dealCostTime(Date beginTime, Date endTime, SimpleDateFormat sdf, String costTimeStr) {
        Long costTalTime = (endTime.getTime() - beginTime.getTime()) / 1000L;
        Long hours = costTalTime / 3600L;
        Long min = (costTalTime - hours * 3600L) / 60L;
        Long second = costTalTime - hours * 3600L - min * 60L;
        if (hours > 0L) {
            costTimeStr = costTimeStr + String.format(ResManager.loadKDString((String)"%s \u5c0f\u65f6 ", (String)"DataCollectProcessPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), hours);
        }
        if (min > 0L) {
            costTimeStr = costTimeStr + String.format(ResManager.loadKDString((String)"%s \u5206\u949f ", (String)"DataCollectProcessPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), min);
        }
        costTimeStr = costTimeStr + String.format(ResManager.loadKDString((String)"%s \u79d2", (String)"DataCollectProcessPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), second);
        ((Label)this.getControl("overtime")).setText(String.format(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\uff1a%s", (String)"DataCollectProcessPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sdf.format(endTime)));
        return String.format(ResManager.loadKDString((String)"\u8017\u65f6\uff1a%s", (String)"DataCollectProcessPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), costTimeStr);
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        if (PROGRESSBARAP.equals(control.getKey())) {
            try {
                BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
                if (!billList.getSelectedRows().isEmpty()) {
                    long progressId = (Long)billList.getSelectedRows().get(0).getPrimaryKeyValue();
                    this.dealProgressInfo(progressId, false, progressEvent);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    private void refreshBill() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        FilterParameter fp = new FilterParameter();
        long modelId = this.getModelId();
        if (this.getModel().getValue(year) == null || this.getModel().getValue(scenario) == null || this.getModel().getValue(period) == null) {
            return;
        }
        DynamicObject yearObj = (DynamicObject)this.getModel().getValue(year);
        QFilter filter = new QFilter(model, "=", (Object)modelId);
        filter.and(year, "=", (Object)yearObj.getLong("id"));
        DynamicObject scen = (DynamicObject)this.getModel().getValue(scenario);
        filter.and(scenario, "=", (Object)scen.getLong("id"));
        DynamicObject periodObj = (DynamicObject)this.getModel().getValue(period);
        filter.and(period, "=", (Object)periodObj.getLong("id"));
        boolean isAdmin = MemberPermHelper.ifUserHasRootPermByModel((long)RequestContext.get().getCurrUserId(), (String)String.valueOf(modelId));
        if (!isAdmin) {
            filter.and("creator", "=", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId()));
        }
        if (((Boolean)this.getModel().getValue("showsuccess")).booleanValue()) {
            filter.and(REMAINDER, "=", (Object)0);
        } else {
            filter.and(REMAINDER, "!=", (Object)0);
        }
        fp.setFilter(filter);
        fp.setOrderBy("createtime desc");
        billList.setFilterParameter(fp);
        billList.refresh();
        billList.selectRows(0);
    }

    private void refreshById(Long groupId) {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        FilterParameter fp = new FilterParameter();
        fp.setFilter(new QFilter("id", "=", (Object)groupId));
        billList.setFilterParameter(fp);
        billList.refresh();
    }
}

