/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DataCollectRecordEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.report.util.DataCollectUtil;
import org.apache.commons.collections.CollectionUtils;

public class DataScreenPlanPlugin
extends AbstractBaseListPlugin
implements BeforeF7SelectListener {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(DataScreenPlanPlugin.class);
    private static final String ROWCOUNT = "rowcount";
    private static final String CLOSE = "close";
    private static final String SAVE = "save";
    private static final String EXECSTATUS = "execstatus";
    public static final String ENTRYENTITY = "entryentity";

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit organization = (BasedataEdit)this.getControl("entity");
        BasedataEdit catalog = (BasedataEdit)this.getControl("catalog");
        BasedataEdit template = (BasedataEdit)this.getControl("template");
        BasedataEdit permclass = (BasedataEdit)this.getControl("permclass");
        organization.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        catalog.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        template.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        permclass.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        permclass.setF7BatchFill(Boolean.FALSE.booleanValue());
        this.addClickListeners("btn_ok", "btn_cancel", EXECSTATUS);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getmodelId());
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int rowcount = (Integer)entryGrid.getEntryData().getData().get(ROWCOUNT);
        if (rowcount != 0) {
            this.getView().getPageCache().put(ROWCOUNT, ROWCOUNT);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_ok": {
                this.operaPlans();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
                break;
            }
            case "execstatus": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("bcm_execstatus");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EXECSTATUS));
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("scope".equals(propName)) {
            ChangeData data = e.getChangeSet()[0];
            int index = data.getRowIndex();
            if ("2".equals(data.getNewValue())) {
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"permclass"});
            } else {
                this.getModel().setValue("permclass", null, index);
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"permclass"});
            }
        }
        this.getView().getPageCache().put("ischange", "true");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        block5: {
            int[] selectRows;
            String operationKey;
            block4: {
                super.afterDoOperation(afterDoOperationEventArgs);
                operationKey = afterDoOperationEventArgs.getOperateKey();
                if (!"deleteentry".equals(operationKey)) break block4;
                this.getView().getPageCache().put("ischange", "true");
                DynamicObjectCollection data = this.getModel().getEntryEntity(ENTRYENTITY);
                int index = 0;
                for (DynamicObject one : data) {
                    if ("2".equals(one.getString("scope"))) {
                        this.getView().setEnable(Boolean.TRUE, index, new String[]{"permclass"});
                    } else {
                        this.getView().setEnable(Boolean.FALSE, index, new String[]{"permclass"});
                    }
                    ++index;
                }
                break block5;
            }
            if (!"newentry".equals(operationKey)) break block5;
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
            for (int selectRow : selectRows = entry.getSelectRows()) {
                DynamicObject dy = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow);
                if ("2".equals(dy.getString("scope"))) continue;
                this.getView().setEnable(Boolean.FALSE, selectRow, new String[]{"permclass"});
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getView().getPageCache().get(SAVE) == null && this.getView().getPageCache().get(CLOSE) == null && this.getView().getPageCache().get("ischange") != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u4e0d\u4f1a\u4fdd\u5b58\uff0c\u786e\u8ba4\u5173\u95ed\u7a97\u53e3\u3002", (String)"DataScreenPlanPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CLOSE, (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof DeleteEntry) {
            long userId = this.getUserId();
            boolean isAdmin = MemberPermHelper.ifUserHasRootPermByModel((long)userId, (String)String.valueOf(this.getmodelId()));
            if (isAdmin) {
                return;
            }
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = entry.getSelectRows();
            Set<Long> readOnlyIds = DataCollectUtil.getOnlyReadPermSceenIds(this.getmodelId());
            for (int selectRow : selectRows) {
                DynamicObject dy = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow);
                long creator = dy.getLong("creator");
                String scope = dy.getString("scope");
                if (("2".equals(scope) || creator == 0L || userId == creator) && (!"2".equals(scope) || !readOnlyIds.contains(dy.getLong("id")))) continue;
                String planname = dy.getString("planname");
                String msg = String.format(ResManager.loadKDString((String)"%s \u65b9\u6848, \u4ec5\u521b\u5efa\u8005\u6216\u4f53\u7cfb\u7ba1\u7406\u5458\u6216\u6709\u5199\u5165\u6743\u9650\u53ef\u5220\u9664\u3002", (String)"DataScreenPlanPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), planname);
                this.getView().showTipNotification(msg);
                args.setCancel(true);
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CLOSE.equals(callBackId) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.getView().getPageCache().remove(ROWCOUNT);
            this.getView().getPageCache().put(CLOSE, CLOSE);
            this.getView().close();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        if (returnData != null) {
            if (EXECSTATUS.equals(actionId)) {
                List execStatus = (List)JSON.parseObject((String)returnData.toString(), List.class);
                StringBuilder stringBuilder = new StringBuilder();
                if (execStatus.size() > 0) {
                    this.getExecStatus(execStatus, stringBuilder);
                    this.getModel().setValue(EXECSTATUS, (Object)stringBuilder.toString(), currentRowIndex);
                }
            } else if ("permclass".equals(actionId)) {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
                if (rows.isEmpty()) {
                    return;
                }
                this.getModel().setItemValueByID("permclass", rows.get(0).getPrimaryKeyValue(), this.getModel().getEntryCurrentRowIndex(ENTRYENTITY));
            }
        }
    }

    private void operaPlans() {
        DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRYENTITY);
        Long userId = LongUtil.toLong((Object)RequestContext.get().getUserId());
        Long modelId = this.getmodelId();
        boolean isAdmin = MemberPermHelper.ifUserHasRootPermByModel((long)userId, (String)String.valueOf(modelId));
        Object dataLists = datas;
        if (!isAdmin) {
            dataLists = datas.stream().filter(e -> e.getLong("creator") == userId.longValue() || e.getLong("creator") == 0L).collect(Collectors.toList());
        }
        ArrayList<Pair> updatePlans = new ArrayList<Pair>(16);
        ArrayList<Pair> addPlans = new ArrayList<Pair>(16);
        ArrayList<String> nameList = new ArrayList<String>(16);
        DynamicObject[] existPlans = this.queryExistPlans(isAdmin, userId);
        if (existPlans.length == 0 && dataLists.isEmpty()) {
            this.getView().close();
            return;
        }
        Map<Long, DynamicObject> existPlanDys = Arrays.stream(existPlans).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        Iterator iterator = dataLists.iterator();
        while (iterator.hasNext()) {
            DynamicObject plan;
            long id;
            DynamicObject data = (DynamicObject)iterator.next();
            String planName = data.getLocaleString("planname").getLocaleValue();
            if (StringUtils.isEmpty((String)planName)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataScreenPlanPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (nameList.contains(planName)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u65b9\u6848\u540d\u79f0\u91cd\u590d\u3002", (String)"DataScreenPlanPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), planName));
                return;
            }
            nameList.add(planName);
            if (data.getDynamicObjectCollection("entity").size() == 0 && data.getDynamicObjectCollection("catalog").size() == 0 && data.getDynamicObjectCollection("template").size() == 0 && StringUtils.isEmpty((String)data.getString(EXECSTATUS))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3001\u6a21\u677f\u5206\u7c7b\u3001\u6a21\u677f\u548c\u6267\u884c\u72b6\u6001\u4e0d\u80fd\u5168\u4e3a\u7a7a\u3002", (String)"DataScreenPlanPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String scope = data.getString("scope");
            scope = StringUtils.isEmpty((String)scope) ? "0" : scope;
            DynamicObject permclass = data.getDynamicObject("permclass");
            if ("2".equals(scope) && permclass == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ef\u89c1\u8303\u56f4\u4e3a\u6743\u9650\u7c7b\u65f6\uff0c\u6743\u9650\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataScreenPlanPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Set entitySet = data.getDynamicObjectCollection("entity").stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toSet());
            Set catalogSet = data.getDynamicObjectCollection("catalog").stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toSet());
            Set templateSet = data.getDynamicObjectCollection("template").stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toSet());
            String entityIds = JSON.toJSONString(entitySet);
            String catalogIds = JSON.toJSONString(catalogSet);
            String templateIds = JSON.toJSONString(templateSet);
            String execStatusStr = data.getString(EXECSTATUS);
            String execStatus = "";
            if (StringUtils.isNotEmpty((String)execStatusStr)) {
                List<String> statusList = Arrays.asList(execStatusStr.split(";"));
                ArrayList<Integer> status = new ArrayList<Integer>();
                for (DataCollectRecordEnum value : DataCollectRecordEnum.values()) {
                    if (!statusList.contains(value.getValue())) continue;
                    status.add(value.index - 48);
                }
                execStatus = JSON.toJSONString(status);
            }
            if ((id = data.getLong("id")) != 0L) {
                plan = existPlanDys.remove(id);
                if (plan == null) continue;
                this.updatePlan(plan, planName, entityIds, templateIds, catalogIds, execStatus, scope);
                Pair one = new Pair((Object)plan, "2".equals(plan.getString("scope")) ? data.getDynamicObject("permclass") : null);
                updatePlans.add(one);
                continue;
            }
            Pair one = new Pair((Object)plan, "2".equals((plan = this.collectPlan(modelId, planName, entityIds, templateIds, catalogIds, execStatus, scope, permclass)).getString("scope")) ? data.getDynamicObject("permclass") : null);
            addPlans.add(one);
        }
        if (existPlanDys.isEmpty() && updatePlans.isEmpty() && addPlans.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                if (!existPlanDys.isEmpty()) {
                    DeleteServiceHelper.delete((String)"bcm_datacollectplan", (QFilter[])new QFilter("id", "in", existPlanDys.keySet()).toArray());
                }
                DynamicObject[] plans = this.queryExistPlans();
                HashMap<String, Long> name2id = new HashMap<String, Long>(10);
                for (DynamicObject plan : plans) {
                    name2id.put(plan.getLocaleString("planname").getLocaleValue(), plan.getLong("id"));
                }
                if (!updatePlans.isEmpty()) {
                    for (Pair dy : updatePlans) {
                        Long id;
                        String planname = ((DynamicObject)dy.p1).getLocaleString("planname").getLocaleValue();
                        if (!name2id.containsKey(planname) || (id = (Long)name2id.get(planname)).longValue() == ((DynamicObject)dy.p1).getLong("id")) continue;
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"DataScreenPlanPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), planname));
                    }
                    List<DynamicObject> data = updatePlans.stream().map(s -> (DynamicObject)s.p1).collect(Collectors.toList());
                    SaveServiceHelper.update((DynamicObject[])data.toArray(new DynamicObject[updatePlans.size()]));
                    updatePlans.stream().forEach(s -> PermClassEntityHelper.savePermClass((String)"bcm_datacollectplan", (Object)((DynamicObject)s.p1).getLong("id"), (Object)modelId, (Object)s.p2));
                }
                if (!addPlans.isEmpty()) {
                    List addNames = addPlans.stream().map(e -> ((DynamicObject)e.p1).getLocaleString("planname").getLocaleValue()).collect(Collectors.toList());
                    for (String saveName : addNames) {
                        if (!name2id.containsKey(saveName)) continue;
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"DataScreenPlanPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), saveName));
                    }
                    List<DynamicObject> data = addPlans.stream().map(s -> (DynamicObject)s.p1).collect(Collectors.toList());
                    SaveServiceHelper.save((DynamicObject[])data.toArray(new DynamicObject[addPlans.size()]));
                    addPlans.stream().filter(s -> "2".equals(((DynamicObject)s.p1).getString("scope"))).forEach(s -> PermClassEntityHelper.savePermClass((String)"bcm_datacollectplan", (Object)((DynamicObject)s.p1).getLong("id"), (Object)modelId, (Object)s.p2));
                }
            }
            catch (Exception e2) {
                tx.markRollback();
                this.getView().showErrorNotification(e2.getMessage());
                log.error(ThrowableHelper.toString((Exception)e2));
                if (tx != null) {
                    if (var12_12 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var12_12.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
        this.getView().returnDataToParent((Object)true);
        this.getView().getPageCache().put(SAVE, SAVE);
        this.getView().close();
    }

    private DynamicObject[] queryExistPlans() {
        ArrayList<Long> modelIds = new ArrayList<Long>(2);
        Long modelId = this.getmodelId();
        modelIds.add(0L);
        modelIds.add(modelId);
        QFilter qFilter = new QFilter("model", "in", modelIds);
        DynamicObject[] existPlans = BusinessDataServiceHelper.load((String)"bcm_datacollectplan", (String)"mulcatalog,planname, mulentity, multemplate, execstatus, creator, scope", (QFilter[])qFilter.toArray());
        return existPlans;
    }

    private DynamicObject[] queryExistPlans(boolean isAdmin, Long userId) {
        Long modelId = this.getmodelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (userId != 0L && !isAdmin) {
            qFilter.and("creator", "=", (Object)userId);
        }
        DynamicObject[] existPlans = BusinessDataServiceHelper.load((String)"bcm_datacollectplan", (String)"mulcatalog,planname, mulentity, multemplate, execstatus, creator, scope", (QFilter[])qFilter.toArray());
        return existPlans;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildEntry();
    }

    private DynamicObject collectPlan(Long modelId, String planName, String mulentity, String multemplate, String mulcatalog, String execStatus, String scope, DynamicObject permclass) {
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datacollectplan");
        dy.set("model", (Object)modelId);
        dy.set("planname", (Object)new LocaleString(planName));
        dy.set("mulentity", (Object)mulentity);
        dy.set("multemplate", (Object)multemplate);
        dy.set("mulcatalog", (Object)mulcatalog);
        dy.set(EXECSTATUS, (Object)execStatus);
        dy.set("creator", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId()));
        dy.set("scope", (Object)scope);
        return dy;
    }

    private void updatePlan(DynamicObject dy, String planName, String mulentity, String multemplate, String mulcatalog, String execStatus, String scope) {
        dy.set("planname", (Object)new LocaleString(planName));
        dy.set("mulentity", (Object)mulentity);
        dy.set("multemplate", (Object)multemplate);
        dy.set("mulcatalog", (Object)mulcatalog);
        dy.set(EXECSTATUS, (Object)execStatus);
        dy.set("scope", (Object)scope);
    }

    private void buildEntry() {
        DynamicObjectCollection plans;
        IDataModel model = this.getModel();
        Long modelId = this.getmodelId();
        long userId = this.getUserId();
        boolean isAdmin = MemberPermHelper.ifUserHasRootPermByModel((long)userId, (String)String.valueOf(this.getmodelId()));
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        if (!isAdmin) {
            qf.and("creator", "=", (Object)userId);
            qf.or(new QFilter("model", "=", (Object)modelId).and("scope", "=", (Object)Character.valueOf('1')));
            qf.or(new QFilter("model", "=", (Object)modelId).and("scope", "=", (Object)Character.valueOf('2')).and("id", "not in", DataCollectUtil.getNoPermSceenIds(modelId)));
        }
        if (CollectionUtils.isEmpty((Collection)(plans = QueryServiceHelper.query((String)"bcm_datacollectplan", (String)"id, planname, mulentity, multemplate, mulcatalog,execstatus,scope, creator", (QFilter[])new QFilter[]{qf})))) {
            return;
        }
        int[] rows = model.batchCreateNewEntryRow(ENTRYENTITY, plans.size());
        Set<Long> readOnlyIds = DataCollectUtil.getOnlyReadPermSceenIds(modelId);
        for (int i = 0; i < plans.size(); ++i) {
            String scope;
            List mulcatalog;
            List multemplate;
            List mulentity;
            int rowNum = rows[i];
            DynamicObject plan = (DynamicObject)plans.get(i);
            model.setValue("planname", plan.get("planname"), rowNum);
            if (StringUtils.isNotEmpty((String)plan.getString("mulentity")) && (mulentity = (List)JSON.parseObject((String)plan.getString("mulentity"), List.class)).size() > 0) {
                model.setValue("entity", (Object)mulentity.toArray(), rowNum);
            }
            if (StringUtils.isNotEmpty((String)plan.getString("multemplate")) && (multemplate = (List)JSON.parseObject((String)plan.getString("multemplate"), List.class)).size() > 0) {
                model.setValue("template", (Object)multemplate.toArray(), rowNum);
            }
            if (StringUtils.isNotEmpty((String)plan.getString("mulcatalog")) && (mulcatalog = (List)JSON.parseObject((String)plan.getString("mulcatalog"), List.class)).size() > 0) {
                model.setValue("catalog", (Object)mulcatalog.toArray(), rowNum);
            }
            if (StringUtils.isNotEmpty((String)plan.getString(EXECSTATUS))) {
                List execStatus = (List)JSON.parseObject((String)plan.getString(EXECSTATUS), List.class);
                StringBuilder stringBuilder = new StringBuilder();
                if (execStatus.size() > 0) {
                    this.getExecStatus(execStatus, stringBuilder);
                    model.setValue(EXECSTATUS, (Object)stringBuilder.toString(), rowNum);
                }
            }
            scope = StringUtils.isEmpty((String)(scope = plan.getString("scope"))) ? "0" : scope;
            model.setValue("scope", (Object)scope, rowNum);
            if (!"2".equals(scope)) {
                this.getView().setEnable(Boolean.FALSE, rowNum, new String[]{"permclass"});
            } else {
                model.setValue("permclass", (Object)this.getPermclassId(plan.getLong("id"), modelId), rowNum);
            }
            long creator = plan.getLong("creator");
            model.setValue("creator", (Object)creator, rowNum);
            model.setValue("id", (Object)plan.getLong("id"), rowNum);
            model.setValue("user", (Object)plan.getLong("creator"), rowNum);
            if (isAdmin || ("2".equals(scope) || creator == userId) && (!"2".equals(scope) || !readOnlyIds.contains(plan.getLong("id")))) continue;
            this.getView().setEnable(Boolean.valueOf(false), rowNum, new String[]{"planname", "entity", "catalog", "template", EXECSTATUS, "scope", "permclass"});
        }
    }

    private void getExecStatus(List<Integer> execStatus, StringBuilder stringBuilder) {
        DataCollectRecordEnum[] values;
        for (DataCollectRecordEnum value : values = DataCollectRecordEnum.values()) {
            if (!execStatus.contains(value.index - 48)) continue;
            stringBuilder.append(value.getValue()).append(";");
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        Long modelId = this.getmodelId();
        ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listParameter = parameter.getListFilterParameter();
        parameter.setShowApproved(false);
        FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals("catalog")) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"FormulaParamListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            formShowParameter.setFormId("bos_listf7");
        }
        if (modelId == null) {
            this.modelFilterNull(listParameter);
            return;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        List qFilterList = listParameter.getQFilters();
        qFilterList.add(qFilter);
        DynamicObjectCollection havePermOrgSet = TemplateRangeService.getHavePermOrgSet((Object)modelId);
        Set orgIds = havePermOrgSet.stream().map(org -> org.getLong("id")).collect(Collectors.toSet());
        Map catalogs = BusinessDataServiceHelper.loadFromCache((String)"bcm_templatecatalog", (String)"id", (QFilter[])qFilter.toArray());
        Set catalogIds = catalogs.values().stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (key.equals("entity")) {
            listParameter.getQFilters().add(new QFilter("id", "in", orgIds));
        } else if (key.equals("catalog")) {
            QFilter filter = new QFilter("id", "in", catalogIds);
            qFilterList.add(new QFilter("catalogtype", "=", (Object)(TemplateCatalogTypeEnum.TEMPLATECATALOG.getType() + "")));
            qFilterList.add(filter);
        } else if (key.equals("template")) {
            Set<Long> perm = this.getPerm();
            qFilterList.add(new QFilter("id", "not in", perm));
            qFilterList.add(new QFilter("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType()));
            listParameter.setOrderBy("sequence");
        } else if (key.equals("permclass")) {
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "permclass"));
        }
    }

    private Long getmodelId() {
        JSONObject model = (JSONObject)this.getView().getFormShowParameter().getCustomParams().get("model");
        Long modelId = model.getLong("id");
        return modelId;
    }

    private void modelFilterNull(ListFilterParameter listParameter) {
        List qFilterList = listParameter.getQFilters();
        QFilter filter = new QFilter("model", "=", null);
        qFilterList.add(filter);
    }

    private Set<Long> getPerm() {
        boolean modelManager = MemberPermHelper.isModelManager((Long)this.getModelId());
        HashSet<Long> set = new HashSet<Long>();
        if (modelManager) {
            return set;
        }
        ArrayListMultimap map = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)String.valueOf(this.getModelId()), (String)String.valueOf(this.getUserId()));
        Collection entries = map.entries();
        for (Map.Entry entrie : entries) {
            if (!DataTypeEnum.NO.getIndex().equals(entrie.getKey())) continue;
            set.add((Long)entrie.getValue());
        }
        return set;
    }

    private Long getPermclassId(Long entityId, Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("entityname", "=", (Object)"bcm_datacollectplan");
        qFilter.and("entityid", "=", (Object)entityId);
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_permclass_entity", (String)"permclass,permclass.number", (QFilter[])qFilter.toArray());
        if (Objects.isNull(dy)) {
            return 0L;
        }
        return dy.getLong("permclass.id");
    }
}

