/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimmensionMappingEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.spread.common.util.StringUtil;

public class DimensionMappingPlugin
extends AbstractBaseListPlugin
implements TabSelectListener {
    public static final String FLOAT_TAB = "floattab";
    public static final String ENTRYENTITY = "entryentity";
    private static final String CLOSE = "close";
    private static final String SAVE = "save";
    private static final String COMMONASSIST = "commonassist";
    private static final String PARAM = "param";
    private static final String FORMULA = "formula";

    private String getOperationDimensionMapping() {
        return ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570-\u7ef4\u5ea6\u6620\u5c04", (String)"DimensionMappingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"DimensionMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(COMMONASSIST, PARAM);
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit pagedim;
        super.registerListener(e);
        this.addClickListeners("btn_save");
        BasedataEdit edit = (BasedataEdit)this.getControl("owndim");
        if (edit != null) {
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((pagedim = (BasedataEdit)this.getControl("pagedim")) != null) {
            pagedim.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.buildEntry();
        this.refleshFilterIdList();
    }

    private String getTabKey() {
        Tab tab = (Tab)this.getControl("tabap");
        return tab.getCurrentTab();
    }

    private boolean isFloatTab() {
        return FLOAT_TAB.equals(this.getTabKey());
    }

    private char getMappingType() {
        DimmensionMappingEnum[] enums;
        String tabKey = this.getTabKey();
        for (DimmensionMappingEnum mappingEnum : enums = DimmensionMappingEnum.values()) {
            if (!mappingEnum.getValue().equals(tabKey)) continue;
            return mappingEnum.getIndex();
        }
        return DimmensionMappingEnum.FLOAT.getIndex();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtil.equals((String)key, (String)"btn_save")) {
            String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
            QFBuilder builder = new QFBuilder("model", "=", (Object)LongUtil.toLong((Object)modelId));
            char mappingType = this.getMappingType();
            builder.add("isfloat", "=", (Object)Character.valueOf(mappingType));
            DeleteServiceHelper.delete((String)"bcm_dimensionmapnew", (QFilter[])builder.toArray());
            DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRYENTITY);
            ArrayList<DynamicObject> dimMaps = new ArrayList<DynamicObject>();
            boolean isCommonTab = mappingType == DimmensionMappingEnum.COMMON.getIndex();
            boolean isDimMapTab = mappingType == DimmensionMappingEnum.FLOAT.getIndex() || mappingType == DimmensionMappingEnum.UNFLOAT.getIndex();
            boolean isFormulaTab = mappingType == DimmensionMappingEnum.FORMULA.getIndex();
            for (DynamicObject data : datas) {
                String bcmDim;
                String mapDimValue;
                String dimType;
                boolean isFormulaTabCheck;
                String ownDim = data.getString("owndim.id");
                String pageDim = data.getString("pagedim.id");
                String otherDim = data.getString("otherdim.id");
                String commonAssist = data.getString("commonassistpojo");
                String common = data.getString(COMMONASSIST);
                String formula = data.getString(FORMULA);
                String param = data.getString(PARAM);
                boolean dimTabCheck = !isDimMapTab || isDimMapTab && ownDim != null && otherDim != null;
                boolean commonTabCheck = !isCommonTab || isCommonTab && StringUtils.isNotEmpty((CharSequence)pageDim) && StringUtils.isNotEmpty((CharSequence)commonAssist) && StringUtils.isNotEmpty((CharSequence)common);
                boolean bl = isFormulaTabCheck = !isFormulaTab || isFormulaTab && StringUtils.isNotEmpty((CharSequence)ownDim) && StringUtils.isNotEmpty((CharSequence)param) && StringUtils.isNotEmpty((CharSequence)formula);
                if (!dimTabCheck || !commonTabCheck || !isFormulaTabCheck) continue;
                String formulaNum = " ";
                if (isDimMapTab) {
                    dimType = "dimensionmap";
                    mapDimValue = otherDim;
                    bcmDim = ownDim;
                } else if (isCommonTab) {
                    dimType = COMMONASSIST;
                    mapDimValue = commonAssist;
                    bcmDim = pageDim;
                } else {
                    dimType = COMMONASSIST;
                    mapDimValue = param;
                    bcmDim = ownDim;
                    formulaNum = formula;
                }
                dimMaps.add(this.getDimmembMappingDynamicObject(bcmDim, mapDimValue, mappingType, dimType, formulaNum));
            }
            SaveServiceHelper.save((DynamicObject[])dimMaps.toArray(new DynamicObject[0]));
            this.buildEntry();
            ThreadCache.put((Object)"getModelId", (Object)LongUtil.toLong((Object)modelId));
            switch (mappingType) {
                case '0': {
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u516c\u5f0f\u53d6\u6570-\u7ef4\u5ea6\u6620\u5c04", "DimensionMappingPlugin_0", "fi-bcm-formplugin", "Formula retrieval dimension mapping"), new OPDescMultiLangEnumBridge("\u56fa\u5b9a\u7ef4\u5ea6\u6620\u5c04\u4fdd\u5b58\u6210\u529f", "DimensionMappingPlugin_14", "fi-bcm-formplugin", null));
                    break;
                }
                case '1': {
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u516c\u5f0f\u53d6\u6570-\u7ef4\u5ea6\u6620\u5c04", "DimensionMappingPlugin_0", "fi-bcm-formplugin", "Formula retrieval dimension mapping"), new OPDescMultiLangEnumBridge("\u6d6e\u52a8\u7ef4\u5ea6\u6620\u5c04\u4fdd\u5b58\u6210\u529f", "DimensionMappingPlugin_13", "fi-bcm-formplugin", null));
                    break;
                }
                case '2': {
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u516c\u5f0f\u53d6\u6570-\u7ef4\u5ea6\u6620\u5c04", "DimensionMappingPlugin_0", "fi-bcm-formplugin", "Formula retrieval dimension mapping"), new OPDescMultiLangEnumBridge("\u516c\u5171\u7ef4\u5ea6\u6620\u5c04\u4fdd\u5b58\u6210\u529f", "DimensionMappingPlugin_15", "fi-bcm-formplugin", null));
                    break;
                }
                case '3': {
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u516c\u5f0f\u53d6\u6570-\u7ef4\u5ea6\u6620\u5c04", "DimensionMappingPlugin_0", "fi-bcm-formplugin", "Formula retrieval dimension mapping"), new OPDescMultiLangEnumBridge("\u6d6e\u52a8\u53c2\u6570\u6620\u5c04\u4fdd\u5b58\u6210\u529f", "DimensionMappingPlugin_16", "fi-bcm-formplugin", null));
                    break;
                }
            }
            this.getView().getPageCache().put(SAVE, SAVE);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DimensionMappingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if (StringUtil.equals((String)key, (String)COMMONASSIST)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_commonassist");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, COMMONASSIST));
            this.getView().showForm(formShowParameter);
        } else if (StringUtil.equals((String)key, (String)PARAM)) {
            DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRYENTITY);
            HashMap<String, List> formual2param = new HashMap<String, List>(10);
            for (DynamicObject data : datas) {
                String common = data.getString(PARAM);
                if (!common.contains("|")) continue;
                String formulaNum = data.getString(FORMULA);
                String[] split = common.split("\\|");
                if (split.length != 2) continue;
                String param = split[1];
                formual2param.computeIfAbsent(formulaNum, e -> new ArrayList(10)).add(param);
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_formula_map");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PARAM));
            formShowParameter.setCustomParam("model", this.getView().getFormShowParameter().getCustomParam("modelId"));
            formShowParameter.setCustomParam("formula2param", formual2param);
            this.getView().showForm(formShowParameter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        if (returnData != null) {
            DynamicObject dynamicObject = (DynamicObject)returnData;
            if (COMMONASSIST.equals(actionId)) {
                HashMap<String, String> pojo = new HashMap<String, String>();
                pojo.put("commonAssistNumber", dynamicObject.getString("commonAssistNumber"));
                pojo.put("commonAssistName", dynamicObject.getString("commonAssistName"));
                pojo.put("accountTableNumber", dynamicObject.getString("accountTableNumber"));
                pojo.put("accountTableName", dynamicObject.getString("accountTableName"));
                pojo.put("commonAssistKey", dynamicObject.getString("commonAssistKey"));
                this.getModel().setValue("commonassistpojo", (Object)JSON.toJSONString(pojo), currentRowIndex);
                String value = String.join((CharSequence)"|", dynamicObject.getString("accountTableName"), dynamicObject.getString("commonAssistName"));
                this.getModel().setValue(COMMONASSIST, (Object)value, currentRowIndex);
            } else if (StringUtil.equals((String)actionId, (String)PARAM)) {
                String paramnumber = dynamicObject.getString("paramnumber");
                String name2number = dynamicObject.getString("paramname") + "|" + paramnumber;
                this.getModel().setValue(PARAM, (Object)name2number, currentRowIndex);
                this.getModel().setValue(FORMULA, dynamicObject.get("formulanumber"), currentRowIndex);
            }
        }
    }

    private DynamicObject getDimmembMappingDynamicObject(String ownDim, String mapDimValue, char mappingType, String dimType, String formula) {
        DynamicObject dimmembMappingDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimensionmapnew");
        dimmembMappingDynamicObject.set("model", this.getView().getFormShowParameter().getCustomParam("modelId"));
        dimmembMappingDynamicObject.set("dimension", (Object)ownDim);
        dimmembMappingDynamicObject.set(dimType, (Object)mapDimValue);
        dimmembMappingDynamicObject.set("isfloat", (Object)Character.valueOf(mappingType));
        dimmembMappingDynamicObject.set(FORMULA, (Object)formula);
        return dimmembMappingDynamicObject;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildEntry();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (StringUtil.equals((String)afterDoOperationEventArgs.getOperateKey(), (String)"deleteentry")) {
            this.refleshFilterIdList();
            this.getView().getPageCache().put("ischange", "true");
        }
    }

    private void buildEntry() {
        IDataModel model = this.getModel();
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
        QFBuilder builder = new QFBuilder("model", "=", (Object)LongUtil.toLong((Object)modelId));
        char mappingType = this.getMappingType();
        char commonIndex = DimmensionMappingEnum.COMMON.getIndex();
        char floatIndex = DimmensionMappingEnum.FLOAT.getIndex();
        char unfloatIndex = DimmensionMappingEnum.UNFLOAT.getIndex();
        if (mappingType == commonIndex) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{COMMONASSIST, "pagedim"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"otherdim", "owndim", PARAM, FORMULA});
        } else if (mappingType == floatIndex || mappingType == unfloatIndex) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"otherdim", "owndim"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{COMMONASSIST, "pagedim", PARAM, FORMULA});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"owndim", PARAM, FORMULA});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"otherdim", COMMONASSIST, "pagedim"});
        }
        builder.add("isfloat", "=", (Object)Character.valueOf(mappingType));
        DynamicObjectCollection dimensionMap = QueryServiceHelper.query((String)"bcm_dimensionmapnew", (String)"dimension,dimensionmap,commonassist,formula", (QFilter[])builder.toArray());
        model.deleteEntryData(ENTRYENTITY);
        if (dimensionMap == null || dimensionMap.size() <= 0) {
            return;
        }
        int[] rows = model.batchCreateNewEntryRow(ENTRYENTITY, dimensionMap.size());
        char formulaIndex = DimmensionMappingEnum.FORMULA.getIndex();
        for (int i = 0; i < dimensionMap.size(); ++i) {
            int rowNum = rows[i];
            DynamicObject dimensionMember = (DynamicObject)dimensionMap.get(i);
            if (mappingType == commonIndex) {
                String commonassistStr = dimensionMember.getString(COMMONASSIST);
                JSONObject commonAssist = JSON.parseObject((String)commonassistStr);
                String value = String.join((CharSequence)"|", commonAssist.getString("accountTableName"), commonAssist.getString("commonAssistName"));
                model.setValue(COMMONASSIST, (Object)value, rowNum);
                model.setValue("commonassistpojo", (Object)commonassistStr, rowNum);
                model.setValue("pagedim", dimensionMember.get("dimension"), rowNum);
                continue;
            }
            if (mappingType == formulaIndex) {
                String paramInfoStr = dimensionMember.getString(COMMONASSIST);
                String formulaNum = dimensionMember.getString(FORMULA);
                model.setValue(PARAM, (Object)paramInfoStr, rowNum);
                model.setValue(FORMULA, (Object)formulaNum, rowNum);
                model.setValue("owndim", dimensionMember.get("dimension"), rowNum);
                continue;
            }
            model.setValue("owndim", dimensionMember.get("dimension"), rowNum);
            model.setValue("otherdim", dimensionMember.get("dimensionmap"), rowNum);
        }
        this.refleshFilterIdList();
    }

    private void refleshFilterIdList() {
        ArrayList<Long> list = new ArrayList<Long>(10);
        DynamicObjectCollection data = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject dat : data) {
            list.add(dat.getLong("otherdim.id"));
        }
        if (!list.isEmpty()) {
            ItemClassEdit icd = (ItemClassEdit)this.getControl("otherdim");
            QFilter filter = new QFilter("id", "not in", list);
            icd.setQFilter(filter);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getView().getPageCache().put("ischange", "true");
        String name = e.getProperty().getName();
        if (StringUtil.equals((String)name, (String)"otherdim") || StringUtil.equals((String)name, (String)"owndim")) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newValue == null) {
                this.getModel().setValue(name, (Object)oldValue, e.getChangeSet()[0].getRowIndex());
            }
            if (StringUtil.equals((String)name, (String)"otherdim")) {
                this.refleshFilterIdList();
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (StringUtil.equals((String)key, (String)"owndim") || StringUtil.equals((String)key, (String)"pagedim")) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            qFilterList.add(new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelId"))));
            if (this.isFloatTab()) {
                qFilterList.add(new QFilter("number", "=", (Object)DimEntityNumEnum.INTERCOMPANY.getNumber()).or("issysdimension", "=", (Object)false));
            }
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getView().getPageCache().get(SAVE) == null && this.getView().getPageCache().get(CLOSE) == null && this.getView().getPageCache().get("ischange") != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"DimensionMappingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CLOSE, (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CLOSE.equals(callBackId) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.getView().getPageCache().put(CLOSE, CLOSE);
            this.getView().close();
        }
    }
}

