/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.enums.DimmensionMappingEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public class DimensionMappingPluginNew
extends AbstractBaseListPlugin {
    public static final String BTN_SAVE = "btn_save";
    public static final String BTN_REFRESH = "btn_refresh";
    public static final String BTN_ENABLE = "btn_enable";
    public static final String BTN_DISABLE = "btn_disable";
    public static final String F7_MODEL = "model";
    public static final String ENTRYENTITY = "treeentryentity";
    public static final String FIELD_MAPPINGID = "mappingid";
    public static final String FIELD_DATASOURCE = "datasource";
    public static final String FIELD_MARKCODE = "markcode";
    public static final String FIELD_ISFLOAT = "isfloat";
    public static final String FIELD_OWNDIM = "owndim";
    public static final String FIELD_ASSTID = "asstid";
    public static final String FIELD_OTHERDIM = "otherdim";
    public static final String FIELD_FORMULA = "formula";
    public static final String FIELD_PARAM = "param";
    public static final String FIELD_REFTYPE = "reftype";
    public static final String FIELD_REFID = "refid";
    public static final String FIELD_REFDETAILID = "refdetailid";
    public static final String FIELD_REFDESC = "refdesc";
    public static final String FIELD_CREATORID = "creatorid";
    public static final String FIELD_CREATETIME = "createtime";
    public static final String FIELD_MODIFIERID = "modifierid";
    public static final String FIELD_MODIFIEDTIME = "modifiedtime";
    public static final String FIELD_ISENABLE = "isenable";
    public static final String DATASOURCE_1 = "1";
    public static final String DATASOURCE_2 = "2";
    public static final String STATUS_ENABLE = "1";
    public static final String STATUS_DISABLE = "0";
    public static final String UPDATE_MAPPINGID_SET = "updateMappingIdSet";
    private Set<String> markCodeSet = new HashSet<String>(10);

    private String getOperationDimensionMapping() {
        return ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570-\u7ef4\u5ea6\u6620\u5c04", (String)"DimensionMappingPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(FIELD_OTHERDIM, FIELD_REFDESC);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit edit = (BasedataEdit)this.getControl(FIELD_OWNDIM);
        if (edit != null) {
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
        if (modelId != null && modelId != 0L) {
            this.getModel().setValue(F7_MODEL, (Object)modelId);
            this.initEntry();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtil.equals((String)key, (String)BTN_SAVE)) {
            if (this.checkData()) {
                this.saveDimensionMapping();
                this.initEntry();
            }
        } else if (StringUtil.equals((String)key, (String)BTN_REFRESH)) {
            this.initEntry();
        } else if (StringUtil.equals((String)key, (String)BTN_ENABLE)) {
            this.updateEnableStatus("1");
            this.initEntry();
        } else if (StringUtil.equals((String)key, (String)BTN_DISABLE)) {
            this.updateEnableStatus(STATUS_DISABLE);
            this.initEntry();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (F7_MODEL.equals(key) || FIELD_DATASOURCE.equals(key)) {
            this.initEntry();
        } else {
            if (FIELD_REFDESC.equals(key)) {
                int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
                String refdesc = (String)this.getModel().getValue(FIELD_REFDESC, currentRow);
                if (StringUtils.isEmpty((String)refdesc)) {
                    this.getModel().setValue(FIELD_REFTYPE, (Object)"");
                    this.getModel().setValue(FIELD_REFID, (Object)0L);
                    this.getModel().setValue(FIELD_REFDETAILID, (Object)0L);
                }
            }
            this.addUpdateSet();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof DeleteEntry) {
            int[] selectIndexs;
            for (int currentRow : selectIndexs = ((EntryGrid)this.getView().getControl(ENTRYENTITY)).getSelectRows()) {
                String val;
                String enable = (String)this.getModel().getValue(FIELD_ISENABLE, currentRow);
                if (!StringUtils.equals((String)enable, (String)(val = ResManager.loadKDString((String)"\u662f", (String)"SaveDimMemberHelper_8", (String)"fi-bcm-business", (Object[])new Object[0])))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u7684\u8bb0\u5f55\u65e0\u6cd5\u5220\u9664\u3002", (String)"DimensionMappingPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private void addUpdateSet() {
        int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        Long mappingId = (Long)this.getModel().getValue(FIELD_MAPPINGID, currentRow);
        if (mappingId != 0L) {
            HashSet<Long> updateSet = (HashSet<Long>)JSON.parseObject((String)this.getPageCache().get(UPDATE_MAPPINGID_SET), HashSet.class);
            if (updateSet == null) {
                updateSet = new HashSet<Long>(10);
            }
            if (!updateSet.contains(mappingId)) {
                updateSet.add(mappingId);
                this.getPageCache().put(UPDATE_MAPPINGID_SET, SerializationUtils.toJsonString(updateSet));
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtil.equals((String)key, (String)FIELD_OTHERDIM)) {
            this.clickOtherDimension();
        } else if (StringUtil.equals((String)key, (String)FIELD_REFDESC)) {
            this.clickRefMapping();
        }
    }

    private void clickOtherDimension() {
        String datasource = (String)this.getModel().getValue(FIELD_DATASOURCE);
        if (StringUtil.equals((String)datasource, (String)"1")) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_other_dimension");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            formShowParameter.setCustomParam(F7_MODEL, (Object)this.getModelId());
            formShowParameter.setCustomParam(FIELD_ISFLOAT, this.getModel().getValue(FIELD_ISFLOAT, currentRowIndex));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIELD_OTHERDIM));
            this.getView().showForm(formShowParameter);
        } else if (StringUtil.equals((String)datasource, (String)DATASOURCE_2)) {
            DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRYENTITY);
            HashMap<String, List> formual2param = new HashMap<String, List>(10);
            for (DynamicObject data : datas) {
                String common = data.getString(FIELD_OTHERDIM);
                if (!common.contains("|")) continue;
                String formulaNum = data.getString(FIELD_FORMULA);
                String[] split = common.split("\\|");
                if (split.length != 2) continue;
                String param = split[1];
                formual2param.computeIfAbsent(formulaNum, e -> new ArrayList(10)).add(param);
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_formula_map");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u5bf9\u8d26\u53d6\u6570\u516c\u5f0f\u53c2\u6570", (String)"DimensionMappingPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIELD_OTHERDIM));
            formShowParameter.setCustomParam(F7_MODEL, (Object)this.getModelId());
            formShowParameter.setCustomParam("formula2param", formual2param);
            this.getView().showForm(formShowParameter);
        }
    }

    private void clickRefMapping() {
        IDataModel dataModel = this.getModel();
        int currentRowIndex = dataModel.getEntryCurrentRowIndex(ENTRYENTITY);
        String markCode = (String)dataModel.getValue(FIELD_MARKCODE, currentRowIndex);
        Object ownDim = dataModel.getValue(FIELD_OWNDIM, currentRowIndex);
        Object otherDim = dataModel.getValue(FIELD_OTHERDIM, currentRowIndex);
        if (StringUtils.isEmpty((String)markCode) || ownDim == null || otherDim == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u8bc6\u7801\u3001\u672c\u65b9\u7ef4\u5ea6\u3001\u5bf9\u65b9\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimensionMappingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_reference_mapping");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        Long refId = (Long)dataModel.getValue(FIELD_REFID, currentRowIndex);
        Long refDetailId = (Long)dataModel.getValue(FIELD_REFDETAILID, currentRowIndex);
        formShowParameter.setCustomParam(F7_MODEL, (Object)this.getModelId());
        formShowParameter.setCustomParam(FIELD_REFID, (Object)String.valueOf(refId));
        formShowParameter.setCustomParam(FIELD_REFDETAILID, (Object)String.valueOf(refDetailId));
        formShowParameter.setCustomParam(FIELD_REFTYPE, dataModel.getValue(FIELD_REFTYPE, currentRowIndex));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIELD_REFDESC));
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        IDataModel dataModel = this.getModel();
        int currentRowIndex = dataModel.getEntryCurrentRowIndex(ENTRYENTITY);
        if (FIELD_OTHERDIM.equals(actionId)) {
            DynamicObject dynamicObject = (DynamicObject)returnData;
            String datasource = (String)dataModel.getValue(FIELD_DATASOURCE);
            if (StringUtil.equals((String)datasource, (String)"1")) {
                String source = dynamicObject.getString("childsource");
                if (StringUtil.equals((String)source, (String)"1")) {
                    dataModel.setValue(FIELD_ASSTID, (Object)dynamicObject.getLong(FIELD_ASSTID), currentRowIndex);
                    String value = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\uff1a%1$s", (String)"DimensionMappingPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dynamicObject.getString("name"));
                    dataModel.setValue(FIELD_OTHERDIM, (Object)value, currentRowIndex);
                    dataModel.setValue(FIELD_ISFLOAT, (Object)Character.valueOf(DimmensionMappingEnum.FLOAT.index), currentRowIndex);
                } else if (StringUtil.equals((String)source, (String)DATASOURCE_2)) {
                    HashMap<String, String> pojo = new HashMap<String, String>();
                    pojo.put("commonAssistNumber", dynamicObject.getString("number"));
                    pojo.put("commonAssistName", dynamicObject.getString("name"));
                    pojo.put("accountTableNumber", dynamicObject.getString("accountTableNumber"));
                    pojo.put("accountTableName", dynamicObject.getString("accountTableName"));
                    pojo.put("commonAssistKey", dynamicObject.getString("commonAssistKey"));
                    dataModel.setValue("commonassistpojo", (Object)JSON.toJSONString(pojo), currentRowIndex);
                    String value = String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\uff1a%1$s", (String)"DimensionMappingPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dynamicObject.getString("name"));
                    dataModel.setValue(FIELD_OTHERDIM, (Object)value, currentRowIndex);
                    dataModel.setValue(FIELD_ISFLOAT, (Object)Character.valueOf(DimmensionMappingEnum.COMMON.index), currentRowIndex);
                }
            } else if (StringUtil.equals((String)datasource, (String)DATASOURCE_2)) {
                String paramnumber = dynamicObject.getString("paramnumber");
                String name2number = dynamicObject.getString("paramname") + "|" + paramnumber;
                dataModel.setValue(FIELD_OTHERDIM, (Object)name2number, currentRowIndex);
                dataModel.setValue(FIELD_FORMULA, dynamicObject.get("formulanumber"), currentRowIndex);
                dataModel.setValue(FIELD_PARAM, (Object)name2number, currentRowIndex);
                dataModel.setValue(FIELD_ISFLOAT, (Object)Character.valueOf(DimmensionMappingEnum.FORMULA.index), currentRowIndex);
            }
        } else if (FIELD_REFDESC.equals(actionId)) {
            Map returnMap = (Map)returnData;
            dataModel.setValue(FIELD_REFTYPE, returnMap.get("refType"), currentRowIndex);
            dataModel.setValue(FIELD_REFDESC, returnMap.get(FIELD_REFDESC), currentRowIndex);
            dataModel.setValue(FIELD_REFID, returnMap.get(FIELD_REFID), currentRowIndex);
            dataModel.setValue(FIELD_REFDETAILID, returnMap.get(FIELD_REFDETAILID), currentRowIndex);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listParameter = parameter.getListFilterParameter();
        List qFilters = listParameter.getQFilters();
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (StringUtil.equals((String)key, (String)FIELD_OWNDIM)) {
            qFilters.add(new QFilter(F7_MODEL, "=", (Object)this.getModelId()));
            if (this.getModelId() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MemberMappingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void initEntry() {
        this.markCodeSet.clear();
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        String prifix = "S";
        String datasource = (String)this.getModel().getValue(FIELD_DATASOURCE);
        if (StringUtil.equals((String)datasource, (String)"1")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_FORMULA});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FIELD_REFDESC});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FIELD_FORMULA});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_REFDESC});
            prifix = "F";
        }
        DynamicObject[] dimensionObjects = this.loadDimensionMapFromDB();
        if (dimensionObjects == null || dimensionObjects.length == 0) {
            return;
        }
        int[] rows = model.batchCreateNewEntryRow(ENTRYENTITY, dimensionObjects.length);
        for (int i = 0; i < dimensionObjects.length; ++i) {
            int rowNum = rows[i];
            DynamicObject dimensionMember = dimensionObjects[i];
            model.setValue(FIELD_MAPPINGID, dimensionMember.get("id"), rowNum);
            String markCode = dimensionMember.getString(FIELD_MARKCODE);
            if (StringUtils.isEmpty((String)markCode)) {
                markCode = prifix + (rowNum + 1);
            }
            model.setValue(FIELD_MARKCODE, (Object)markCode, rowNum);
            this.getView().setEnable(Boolean.valueOf(false), rowNum, new String[]{FIELD_MARKCODE});
            String floatType = ((String)dimensionMember.get(FIELD_ISFLOAT)).trim();
            DimmensionMappingEnum mappingEnum = DimmensionMappingEnum.getDescByIndex((String)floatType);
            model.setValue(FIELD_ISFLOAT, (Object)floatType, rowNum);
            model.setValue(FIELD_OWNDIM, dimensionMember.get("dimension"), rowNum);
            switch (mappingEnum) {
                case FLOAT: 
                case UNFLOAT: {
                    Long asstactTypeId = dimensionMember.getLong("dimensionmap.id");
                    model.setValue(FIELD_OTHERDIM, (Object)this.getAsstactTypeValue(asstactTypeId), rowNum);
                    model.setValue(FIELD_ASSTID, (Object)asstactTypeId, rowNum);
                    break;
                }
                case COMMON: {
                    String commonassist = dimensionMember.getString("commonassist");
                    model.setValue("commonassistpojo", (Object)commonassist, rowNum);
                    model.setValue(FIELD_OTHERDIM, (Object)this.getCommonAssistsValue(commonassist), rowNum);
                    break;
                }
                case FORMULA: {
                    model.setValue(FIELD_PARAM, dimensionMember.get("commonassist"), rowNum);
                    model.setValue(FIELD_FORMULA, dimensionMember.get(FIELD_FORMULA), rowNum);
                    model.setValue(FIELD_OTHERDIM, dimensionMember.get("commonassist"), rowNum);
                    break;
                }
            }
            model.setValue(FIELD_REFDESC, dimensionMember.get(FIELD_REFDESC), rowNum);
            model.setValue(FIELD_REFTYPE, dimensionMember.get(FIELD_REFTYPE), rowNum);
            model.setValue(FIELD_REFID, dimensionMember.get(FIELD_REFID), rowNum);
            model.setValue(FIELD_REFDETAILID, dimensionMember.get(FIELD_REFDETAILID), rowNum);
            model.setValue(FIELD_CREATORID, dimensionMember.get(FIELD_CREATORID), rowNum);
            model.setValue(FIELD_CREATETIME, dimensionMember.get(FIELD_CREATETIME), rowNum);
            model.setValue(FIELD_MODIFIERID, dimensionMember.get(FIELD_MODIFIERID), rowNum);
            model.setValue(FIELD_MODIFIEDTIME, dimensionMember.get(FIELD_MODIFIEDTIME), rowNum);
            String enable = dimensionMember.getString(FIELD_ISENABLE);
            if (StringUtils.isEmpty((String)enable) || StringUtils.equals((String)enable, (String)"1")) {
                model.setValue(FIELD_ISENABLE, (Object)ResManager.loadKDString((String)"\u662f", (String)"SaveDimMemberHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]), rowNum);
                this.getView().setEnable(Boolean.valueOf(false), rowNum, new String[]{FIELD_OWNDIM});
                this.getView().setEnable(Boolean.valueOf(false), rowNum, new String[]{FIELD_OTHERDIM});
                this.getView().setEnable(Boolean.valueOf(false), rowNum, new String[]{FIELD_REFDESC});
                continue;
            }
            model.setValue(FIELD_ISENABLE, (Object)ResManager.loadKDString((String)"\u5426", (String)"SaveDimMemberHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), rowNum);
        }
        this.getPageCache().remove(UPDATE_MAPPINGID_SET);
    }

    private String getAsstactTypeValue(Long asstactTypeId) {
        String selectFields = "id,number,name";
        QFilter qFilter = new QFilter("id", "=", (Object)asstactTypeId);
        DynamicObjectCollection assts = QueryServiceHelper.query((String)"bd_asstacttype", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"number");
        if (assts == null || assts.size() == 0) {
            return null;
        }
        String value = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\uff1a%1$s", (String)"DimensionMappingPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((DynamicObject)assts.get(0)).getString("name"));
        return value;
    }

    private String getCommonAssistsValue(String commonassist) {
        JSONObject dataObj = (JSONObject)JSONObject.parse((String)commonassist);
        String value = String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\uff1a%1$s", (String)"DimensionMappingPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dataObj.getString("commonAssistName"));
        return value;
    }

    private DynamicObject[] loadDimensionMapFromDB() {
        QFBuilder builder = new QFBuilder(F7_MODEL, "=", (Object)this.getModelId());
        String datasource = (String)this.getModel().getValue(FIELD_DATASOURCE);
        if (StringUtil.equals((String)datasource, (String)"1")) {
            builder.add(new QFilter(FIELD_ISFLOAT, "in", (Object)new String[]{STATUS_DISABLE, "1", DATASOURCE_2}));
        } else {
            builder.add(new QFilter(FIELD_ISFLOAT, "in", (Object)new String[]{"3"}));
        }
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"bcm_dimensionmapnew", (String)"id,model,isfloat,dimension,dimensionmap,commonassist,formula,markcode,reftype,refid,refdetailid,refdesc,creatorid,createtime,modifierid,modifiedtime,isenable", (QFilter[])builder.toArray(), (String)FIELD_MARKCODE);
        return datas;
    }

    private void saveDimensionMapping() {
        ArrayList<DynamicObject> addMappings = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> updateMappings = new ArrayList<DynamicObject>(16);
        DynamicObject[] oldDimension = this.loadDimensionMapFromDB();
        Map<Long, DynamicObject> oldDimensionMap = Arrays.stream(oldDimension).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject dimension : datas) {
            Long id = dimension.getLong(FIELD_MAPPINGID);
            if (id == 0L) {
                DynamicObject addObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimensionmapnew");
                this.convertDimensionMap(addObject, dimension);
                addObject.set(FIELD_CREATORID, (Object)RequestContext.get().getCurrUserId());
                addObject.set(FIELD_CREATETIME, (Object)new Date());
                addObject.set(FIELD_MODIFIERID, (Object)RequestContext.get().getCurrUserId());
                addObject.set(FIELD_MODIFIEDTIME, (Object)new Date());
                addObject.set(FIELD_ISENABLE, (Object)STATUS_DISABLE);
                addMappings.add(addObject);
                continue;
            }
            DynamicObject updateObject = oldDimensionMap.remove(id);
            HashSet updateSet = (HashSet)JSON.parseObject((String)this.getPageCache().get(UPDATE_MAPPINGID_SET), HashSet.class);
            if (updateSet != null && updateSet.contains(id)) {
                this.convertDimensionMap(updateObject, dimension);
                updateObject.set(FIELD_MODIFIERID, (Object)RequestContext.get().getCurrUserId());
                updateObject.set(FIELD_MODIFIEDTIME, (Object)new Date());
                updateMappings.add(updateObject);
                continue;
            }
            if (!StringUtils.isEmpty((String)updateObject.getString(FIELD_MARKCODE))) continue;
            updateObject.set(FIELD_MARKCODE, dimension.get(FIELD_MARKCODE));
            updateMappings.add(updateObject);
        }
        try (TXHandle tx = TX.required();){
            try {
                if (updateMappings.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])updateMappings.toArray(new DynamicObject[updateMappings.size()]));
                }
                if (addMappings.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])addMappings.toArray(new DynamicObject[addMappings.size()]));
                }
                if (oldDimensionMap.size() > 0) {
                    DeleteServiceHelper.delete((String)"bcm_dimensionmapnew", (QFilter[])new QFilter("id", "in", oldDimensionMap.keySet()).toArray());
                }
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u516c\u5f0f\u53d6\u6570-\u7ef4\u5ea6\u6620\u5c04", "DimensionMappingPlugin_0", "fi-bcm-formplugin", "Formula retrieval dimension mapping"), new OPDescMultiLangEnumBridge("\u7ef4\u5ea6\u6620\u5c04\u4fdd\u5b58\u6210\u529f", "DimensionMappingPlugin_18", "fi-bcm-formplugin", null));
            }
            catch (Exception e2) {
                tx.markRollback();
                log.error(ThrowableHelper.toString((Exception)e2));
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MemberMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void convertDimensionMap(DynamicObject tableObject, DynamicObject dataObject) {
        String isfloat = (String)dataObject.get(FIELD_ISFLOAT);
        tableObject.set(FIELD_ISFLOAT, (Object)isfloat);
        tableObject.set(F7_MODEL, (Object)this.getModelId());
        tableObject.set("dimension", dataObject.get(FIELD_OWNDIM));
        if (StringUtil.equals((String)isfloat, (String)String.valueOf(DimmensionMappingEnum.UNFLOAT.index)) || StringUtil.equals((String)isfloat, (String)String.valueOf(DimmensionMappingEnum.FLOAT.index))) {
            tableObject.set("dimensionmap", (Object)dataObject.getLong(FIELD_ASSTID));
        } else if (StringUtil.equals((String)isfloat, (String)String.valueOf(DimmensionMappingEnum.COMMON.index))) {
            tableObject.set("commonassist", dataObject.get("commonassistpojo"));
        } else if (StringUtil.equals((String)isfloat, (String)String.valueOf(DimmensionMappingEnum.FORMULA.index))) {
            tableObject.set("commonassist", dataObject.get(FIELD_PARAM));
            tableObject.set(FIELD_FORMULA, dataObject.get(FIELD_FORMULA));
        }
        tableObject.set(FIELD_MARKCODE, dataObject.get(FIELD_MARKCODE));
        String refdesc = dataObject.getString(FIELD_REFDESC);
        if (StringUtils.isEmpty((String)refdesc)) {
            tableObject.set(FIELD_REFTYPE, (Object)"");
            tableObject.set(FIELD_REFDESC, (Object)"");
            tableObject.set(FIELD_REFID, (Object)0L);
            tableObject.set(FIELD_REFDETAILID, (Object)0L);
        } else {
            tableObject.set(FIELD_REFTYPE, dataObject.get(FIELD_REFTYPE));
            tableObject.set(FIELD_REFDESC, dataObject.get(FIELD_REFDESC));
            tableObject.set(FIELD_REFID, dataObject.get(FIELD_REFID));
            tableObject.set(FIELD_REFDETAILID, dataObject.get(FIELD_REFDETAILID));
        }
    }

    private boolean checkData() {
        DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject dimension : datas) {
            String markCode = dimension.getString(FIELD_MARKCODE);
            if (!this.checkMarkCode(markCode)) {
                return false;
            }
            if (this.checkRefMapping(dimension)) continue;
            return false;
        }
        return true;
    }

    private boolean checkRefMapping(DynamicObject dimension) {
        String[] refArray;
        String refDesc = dimension.getString(FIELD_REFDESC);
        if (StringUtils.isEmpty((String)refDesc)) {
            return true;
        }
        String isFloat = dimension.getString(FIELD_ISFLOAT);
        if (StringUtils.equals((String)isFloat, (String)String.valueOf(DimmensionMappingEnum.COMMON.index))) {
            return true;
        }
        int refIndex = refDesc.lastIndexOf("\uff1a");
        if (refIndex != -1) {
            refDesc = refDesc.substring(refIndex + 1);
        }
        if ((refIndex = refDesc.lastIndexOf(" ")) != -1) {
            refDesc = refDesc.substring(refIndex + 1);
        }
        if ((refArray = refDesc.split("->")).length != 2) {
            return false;
        }
        String refOwnDim = refArray[0];
        String refOtherDim = refArray[1];
        DynamicObject owndim = (DynamicObject)dimension.get(FIELD_OWNDIM);
        String owndimName = owndim.getString("name");
        String otherDimName = dimension.getString(FIELD_OTHERDIM);
        int otherDimIndex = otherDimName.lastIndexOf("\uff1a");
        if (otherDimIndex != -1) {
            otherDimName = otherDimName.substring(otherDimIndex + 1);
        }
        if (!StringUtils.equals((String)refOwnDim, (String)owndimName) || !StringUtils.equals((String)refOtherDim, (String)otherDimName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f15\u7528\u7684\u516c\u5171\u6620\u5c04\u7ef4\u5ea6\u6620\u5c04\u9700\u4e0e\u7ef4\u5ea6\u6620\u5c04\u4fdd\u6301\u4e00\u81f4\u3002", (String)"DimensionMappingPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkMarkCode(String markCode) {
        if (this.markCodeSet.contains(markCode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u8bc6\u7801\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"DimensionMappingPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!BCMNumberRule.checkNumber((String)markCode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u8bc6\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimensionMappingPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.markCodeSet.add(markCode);
        return true;
    }

    private void updateEnableStatus(String status) {
        DynamicObject[] datas;
        int[] selectIndexs = ((EntryGrid)this.getView().getControl(ENTRYENTITY)).getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"CheckUpChkListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel dataModel = this.getModel();
        HashSet<Object> mappingIdSet = new HashSet<Object>(16);
        for (int row : selectIndexs) {
            mappingIdSet.add(dataModel.getValue(FIELD_MAPPINGID, row));
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", mappingIdSet);
        qfBuilder.add(F7_MODEL, "=", (Object)this.getModelId());
        for (DynamicObject data : datas = BusinessDataServiceHelper.load((String)"bcm_dimensionmapnew", (String)"modifierid,modifiedtime,isenable", (QFilter[])qfBuilder.toArray())) {
            data.set(FIELD_MODIFIERID, (Object)RequestContext.get().getCurrUserId());
            data.set(FIELD_MODIFIEDTIME, (Object)new Date());
            data.set(FIELD_ISENABLE, (Object)status);
        }
        SaveServiceHelper.save((DynamicObject[])datas);
        if (StringUtil.equals((String)"1", (String)status)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"CheckUpChkListPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"CheckUpChkListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }
}

