/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.intergration.util.EADataPushUtil;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections.CollectionUtils;

public class EADataPushBillPlugin
extends AbstractBaseFormPlugin
implements ClickListener,
DynamicPage {
    private static final Log log = LogFactory.getLog(EADataPushBillPlugin.class);
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String MODEL = "model";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_SCOPE = "scope";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_FMONEY = "FMONEY";
    private static final String FLEX_PANE_LAP5 = "flexpanelap5";
    private static final String FLEX_PANE_LAP2 = "flexpanelap2";
    private static final String EXPR_TYPE = "exprtype";
    private static final String SEPARATOR = "separator";
    private static final String FILE_NAME = "filename";
    private static final String PAGE_PANEL = "pagepanel";
    private static final String action_save = "action_save";
    private static final String action_save_as = "action_save_as";
    private static final String action_scheme = "action_scheme";
    private static final String DIM_KEY = "dimKey";
    private static final String SCHEME_NAME = "schemename";
    private static final String comDImEntry = "commembentry";
    private static final String BCM_DIMENSION_DATA = "bcm_dimension_data";
    private static final String DIM_MEMBER_KEY = "dim_member_key_";
    private static final String TABLE_PREFIX = "t_bcm_ea_";
    private static final String DEFAULT_CURRENCY_ANALYS = "default_currency_analys";
    private static final String ALREADY_EXIST_SCHEME = "already_exist_scheme";
    private static final String IS_CONTAIN_DY_DATA = "iscontaindydata";
    private boolean isCloseTipWindow = false;
    private static final String ISMANAGER = "ISMANAGER";
    private static final String PARENTFORMID = "parentFormId";
    private static final String IS_CONTAIN_TITLE = "iscontaintitle";
    private static final String RELAT_TABLE_PREFIX = "relattableprefix";
    private List<String> mustInputs = Lists.newArrayList((Object[])new String[]{DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.ACCOUNT.getNumber(), DimTypesEnum.ENTITY.getNumber()});

    private String getOperationExportFile() {
        return ResManager.loadKDString((String)"\u5bfc\u51fa\u5e73\u9762\u6587\u4ef6", (String)"EADataPushBillPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationStatusSuccess() {
        return ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f", (String)"EADataPushBillPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationExportDb() {
        return ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5e93", (String)"EADataPushBillPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_confirm", "btnaddf7", "btndelf7", "btnaddcol", "btndelcol", "btnresetcol");
        this.addItemClickListeners("toolbarap", "btn_exp_scheme", "btn_save_as", "btn_save", "btn_scheme_rate", "btn_quit", "btn_exp_dim");
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
        if (MODEL.equals(name)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String billFormId = "";
            if (this.getView() != null && this.getView().getFormShowParameter().getCustomParams().containsKey(PARENTFORMID)) {
                billFormId = (String)this.getView().getFormShowParameter().getCustomParam(PARENTFORMID);
            }
            ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
            showParameter.setCustomParam(ISMANAGER, (Object)MemberPermHelper.isManager((ApplicationTypeEnum)application, (String)billFormId));
            Set modelIds = MemberPermHelper.getLimitedModelListByUser((String)billFormId, (ApplicationTypeEnum)application);
            QFilter qFilter = new QFilter("id", "in", (Object)modelIds);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(qFilter);
            ApplicationTypeEnum sign = ModelUtil.queryApp((IFormView)this.getView());
            QFilter qf = null;
            if (ApplicationTypeEnum.CM == sign) {
                qf = new QFilter("model.ReportType", "=", (Object)ApplicationTypeEnum.CM.getOIndex());
            } else if (ApplicationTypeEnum.RPT == sign) {
                qf = new QFilter("model.ReportType", "=", (Object)ApplicationTypeEnum.PUB.getOIndex()).or(new QFilter("model.ReportType", "=", (Object)ApplicationTypeEnum.RPT.getOIndex()));
            }
            qFilters.add(qf);
            beforeF7SelectEvent.setCustomQFilters(qFilters);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        List<String> dims = this.getDims().get("dims");
        String dim = this.checkAndGetKey(dims, key);
        if (dim != null) {
            this.openMultiF7(key, dim);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (("btn_exp_scheme".equals(itemKey) || "btn_save".equals(itemKey) || "btn_save_as".equals(itemKey) || "btn_exp_dim".equals(itemKey)) && this.checkDimIsEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3001\u79d1\u76ee\u3001\u8d22\u5e74\u3001\u671f\u95f4\u3002", (String)"EADataPushBillPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        switch (itemKey) {
            case "btn_exp_scheme": {
                String exprType = this.getModel().getValue(EXPR_TYPE).toString();
                SQLBuilder sql = this.dealWithSqlEnvironment();
                if ("1".equals(exprType)) {
                    this.dealWithExp(sql);
                    this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa\u5e73\u9762\u6587\u4ef6", "EADataPushBillPlugin_0", FI_BCM_FORMPLUGIN, "Export flat file"), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "EADataPushBillPlugin_2", FI_BCM_FORMPLUGIN, null));
                    break;
                }
                String msg = this.validate();
                if (kd.bos.util.StringUtils.isNotEmpty((String)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                this.dealWithExp(sql);
                this.createMemberTableAndExpData();
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u5bfc\u51fa\u6570\u636e\u5e93", "EADataPushBillPlugin_1", FI_BCM_FORMPLUGIN, "Export database"), new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "EADataPushBillPlugin_2", FI_BCM_FORMPLUGIN, null));
                break;
            }
            case "btn_scheme_list": {
                this.showSchemePage(action_scheme);
                break;
            }
            case "btn_save": {
                if (this.getPageCache().get(ALREADY_EXIST_SCHEME) != null) {
                    this.saveAlreadyExistScheme();
                    break;
                }
                this.showBasePage(action_save);
                break;
            }
            case "btn_save_as": {
                if (this.getPageCache().get(ALREADY_EXIST_SCHEME) != null) {
                    this.showBasePage(action_save_as);
                    break;
                }
                this.showBasePage(action_save);
                break;
            }
            case "btn_quit": {
                this.getView().close();
                break;
            }
        }
    }

    private String validate() {
        if (this.isContainChinese()) {
            return ResManager.loadKDString((String)"\u6570\u636e\u5e93\u8868\u524d\u7f00\u4e0d\u53ef\u5305\u542b\u4e2d\u6587\u3002", (String)"EADataPushBillPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        }
        if ("0".equals(this.getModel().getValue(EXPR_TYPE).toString())) {
            String tableName = this.getModel().getValue(RELAT_TABLE_PREFIX).toString();
            if (kd.bos.util.StringUtils.isEmpty((String)tableName)) {
                return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u636e\u5e93\u8868\u540d\u3002", (String)"EADataPushBillPlugin_19", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            }
            if (!tableName.startsWith(TABLE_PREFIX)) {
                return ResManager.loadKDString((String)"\u6570\u636e\u5e93\u8868\u540d\u5fc5\u987b\u4ee5\u201ct_bcm_ea_\u201d\u5f00\u5934\uff0c\u8bf7\u7f16\u8f91\u540e\u518d\u63d0\u4ea4\u3002", (String)"EADataPushBillPlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            }
        }
        return "";
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(new ArrayList<String>(10), false);
        this.createF7Page();
        this.initComboText();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_PANE_LAP2});
        this.getModel().setValue(IS_CONTAIN_DY_DATA, (Object)false);
        this.getPageCache().put(IS_CONTAIN_DY_DATA, String.valueOf(false));
        this.getModel().setValue(FILE_NAME, (Object)String.format(ResManager.loadKDString((String)"\u63d0\u53d6\u6570\u636e_%s", (String)"EADataPushBillPlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), DateTimeFormatter.ofPattern("yyyyMMdd").format(LocalDateTime.now())));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        this.getPageCache().put("isCloseTipWindow", String.valueOf(this.isCloseTipWindow));
        if (MODEL.equalsIgnoreCase(key)) {
            String modelId = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
            if (modelId == null) {
                this.getModel().setValue(MODEL, (Object)this.getPageCache().get("KEY_MODEL_ID"));
                return;
            }
            if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                return;
            }
            this.getPageCache().put("KEY_MODEL_ID", modelId);
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
            Page page = this.getPage(this.getView());
            Area rowArea = page.findAreaBySign(PAGE_PANEL);
            ArrayList<String> needDel = new ArrayList<String>(10);
            List elementList = rowArea.getElementListList();
            for (Element element : elementList) {
                needDel.add(element.getSign());
            }
            needDel.forEach(sign -> rowArea.removeElememt(sign));
            this.createF7Page();
            this.createDataTableName();
        } else if (IS_CONTAIN_DY_DATA.equals(key)) {
            boolean isContainDyData = this.getModel().getDataEntity().getBoolean(IS_CONTAIN_DY_DATA);
            this.getPageCache().put(IS_CONTAIN_DY_DATA, String.valueOf(isContainDyData));
        } else if (this.getDims().get("dims").contains(key.toLowerCase(Locale.ENGLISH))) {
            String newValue = (String)this.getModel().getValue(key.toLowerCase(Locale.ENGLISH));
            if (kd.bos.util.StringUtils.isEmpty((String)newValue)) {
                this.getPageCache().remove(key.toLowerCase(Locale.ENGLISH));
            }
        } else if (EXPR_TYPE.equals(key)) {
            String value = (String)this.getModel().getValue(EXPR_TYPE);
            if ("0".equals(value)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_PANE_LAP2});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_PANE_LAP5});
                ((TextEdit)this.getControl(RELAT_TABLE_PREFIX)).setMustInput(true);
                this.setTableName();
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_PANE_LAP2});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_PANE_LAP5});
                ((TextEdit)this.getControl(RELAT_TABLE_PREFIX)).setMustInput(false);
            }
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        if (this.getPage(this.getView()) != null) {
            Element c = this.getPage(this.getView()).findElementBySign(ctrlKey);
            if (c != null && TextEditElement.class.isAssignableFrom(c.getClass())) {
                TextEdit edit = new TextEdit();
                edit.setKey(ctrlKey);
                edit.setModel(this.getModel());
                edit.setView(this.getView());
                edit.addClickListener((ClickListener)this);
                e.setControl((Control)edit);
            } else if (c != null) {
                e.setControl(c.getControl(this.getView()));
            }
        }
    }

    private void createF7Page() {
        Page oldPage = this.getPage(this.getView());
        if (oldPage != null) {
            oldPage.clearOldValue((AbstractFormPlugin)this);
        }
        Page page = new Page();
        page.addArea(this.initPageViewPanel(PAGE_PANEL));
        this.resetElementStyle(page.getAreaList());
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        List elementListList = ((Area)page.getAreaList().get(0)).getElementListList();
        elementListList.forEach(element -> {
            String sign = element.getSign();
            this.getPageCache().remove(sign);
            this.getModel().setValue(sign, null);
            this.getView().updateView(sign);
        });
        this.getModel().setValue(SCHEME_NAME, null);
        this.getPageCache().remove(ALREADY_EXIST_SCHEME);
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get("isCloseTipWindow") != null) {
            this.getModel().setDataChanged(!"true".equals(this.getPageCache().get("isCloseTipWindow")));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection doc;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (action_save.equals(actionId)) {
            this.handelBaseBack(closedCallBackEvent, true, false);
            return;
        }
        if (action_save_as.equals(actionId)) {
            this.handelBaseBack(closedCallBackEvent, false, true);
            return;
        }
        if (action_scheme.equals(actionId)) {
            this.handelSchemeBack(closedCallBackEvent);
            return;
        }
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskcloseback")) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
            return;
        }
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskfileback")) {
            String allExported;
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            this.taskCallBack(closedCallBackEvent.getReturnData());
            Gson gson = new Gson();
            JsonObject jsonObject = (JsonObject)gson.fromJson(String.valueOf(closedCallBackEvent.getReturnData()), JsonObject.class);
            String url = ((JsonObject)gson.fromJson(jsonObject.get("taskinfo").getAsJsonObject().get("data").getAsString(), JsonObject.class)).get("url").getAsString();
            if (kd.bos.util.StringUtils.isNotEmpty((String)url)) {
                this.downloadFile(url, "bcm_ea_datapush_form", "3TP3S5M+NPWB");
            }
            if ((allExported = ((JsonObject)gson.fromJson(jsonObject.get("taskinfo").getAsJsonObject().get("data").getAsString(), JsonObject.class)).get("allExportedFlag").getAsString()).equals(Boolean.TRUE.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u8d85\u65f6\uff0c\u6570\u636e\u672a\u5b8c\u5168\u5bfc\u51fa\u3002", (String)"EADataPushBillPlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            return;
        }
        List<String> dims = this.getDims().get("dims");
        if (this.checkAndGetKey(dims, actionId) != null && (doc = (DynamicObjectCollection)closedCallBackEvent.getReturnData()) != null) {
            StringBuilder sb = new StringBuilder();
            ArrayList list = new ArrayList(10);
            for (DynamicObject dot : doc) {
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("id", dot.get(4).toString());
                map.put(FIELD_SCOPE, dot.get(5).toString());
                map.put(FIELD_NUMBER, dot.get(2).toString());
                map.put(FIELD_NAME, dot.get(3).toString());
                map.put("pid", dot.get(6).toString());
                this.buildPageViewShowName(sb, dot.get(3).toString(), dot.getInt(5));
                map.put(DIM_KEY, actionId);
                list.add(map);
            }
            if (kd.bos.util.StringUtils.isEmpty((String)sb.toString())) {
                this.getModel().setValue(actionId, (Object)sb.toString());
                this.getPageCache().remove(actionId);
            } else {
                this.getModel().setValue(actionId, (Object)sb.substring(0, sb.length() - 1));
                this.getPageCache().put(actionId, SerializationUtils.toJsonString(list));
            }
        }
    }

    private Area initPageViewPanel(String item) {
        Area area = new Area(item);
        area.setShowLabel(true);
        ArrayList dims = new ArrayList(10);
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getModelId());
        DynamicObjectCollection dyObject = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,name,number,shortnumber,issysdimension,membermodel,dseq", (QFilter[])qFilter.toArray());
        List<DynamicObject> dySortList = EADataPushUtil.sortDims(dyObject);
        dySortList.forEach(dyList -> {
            TextEditElement f7 = new TextEditElement(dyList.getString(FIELD_NAME), dyList.getString(FIELD_NUMBER).toLowerCase(Locale.ENGLISH), dyList.getString("membermodel"));
            f7.setWidth(new LocaleString("306px"));
            f7.setShowLabel(true);
            f7.setHeight(new LocaleString("34px"));
            f7.setFieldTextAlign("left");
            f7.setLabelWidth(new LocaleString("29.5%"));
            f7.setEditStyle(1);
            f7.setFontSize(12);
            if (this.mustInputs.contains(dyList.getString(FIELD_NUMBER))) {
                f7.setMustInput(true);
            }
            area.addElement((Element)f7);
            dims.add(dyList.getString(FIELD_NUMBER).toLowerCase(Locale.ENGLISH));
        });
        this.getPageCache().put(BCM_DIMENSION_DATA, ObjectSerialUtil.toByteSerialized((Object)dyObject));
        log.info("\u7ef4\u7684\u6807\u5fd7dims\uff1a" + dims);
        return area;
    }

    private Map<String, List<String>> getDims() {
        HashMap<String, List<String>> mapData = new HashMap<String, List<String>>(16);
        ArrayList dims = new ArrayList(10);
        ArrayList dimsUpperCase = new ArrayList(10);
        ArrayList dimsIdList = new ArrayList(10);
        ArrayList dimsMemberModelList = new ArrayList(10);
        String dimensionData = this.getPageCache().get(BCM_DIMENSION_DATA);
        DynamicObjectCollection dyObjectList = (DynamicObjectCollection)ObjectSerialUtil.deSerializedBytes((String)dimensionData);
        List<DynamicObject> dynamicObjects = EADataPushUtil.sortDims(dyObjectList);
        dynamicObjects.forEach(dyObj -> {
            dimsIdList.add(dyObj.getString("id"));
            dims.add(dyObj.getString(FIELD_NUMBER).toLowerCase(Locale.ENGLISH));
            dimsUpperCase.add(dyObj.getString(FIELD_NUMBER));
            dimsMemberModelList.add(dyObj.getString("membermodel"));
        });
        mapData.put("dims", dims);
        mapData.put("dimsUpperCase", dimsUpperCase);
        mapData.put("dimsIdList", dimsIdList);
        mapData.put("dimsMemberModelList", dimsMemberModelList);
        return mapData;
    }

    private void resetElementStyle(List<Area> areas) {
        for (Area area : areas) {
            for (Element element : area.getElementListList()) {
                this.setDefaultStyle(element);
            }
        }
    }

    private void setDefaultStyle(Element element) {
        Style style = new Style();
        Margin margin = new Margin();
        Padding padding = new Padding();
        padding.setRight("14px");
        padding.setLeft("4px");
        padding.setTop("14px");
        margin.setLeft("10px");
        margin.setRight("1px");
        margin.setTop("1px");
        margin.setBottom("10px");
        style.setMargin(margin);
        style.setPadding(padding);
        element.setStyle(style);
    }

    private void openMultiF7(String key, String dim) {
        FormShowParameter para = new FormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String dseq = "";
        String name = "";
        DynamicObjectCollection dyObject = (DynamicObjectCollection)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(BCM_DIMENSION_DATA));
        for (DynamicObject dy : dyObject) {
            if (!key.equals(dy.getString(FIELD_NUMBER).toLowerCase(Locale.ENGLISH))) continue;
            name = dy.getString(FIELD_NAME);
            dseq = dy.getString("dseq").toLowerCase(Locale.ENGLISH);
        }
        params.put("dimension", dseq + "");
        params.put("sign", key);
        if ("Account".equalsIgnoreCase(dim)) {
            params.put("isUpDownBtn", true);
        }
        params.put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        para.setCustomParams(params);
        if ("InternalCompany".equalsIgnoreCase(dim)) {
            para.setFormId("bcm_mulmemberf7_tem_ic");
        } else {
            para.setFormId("bcm_mulmemberf7base_tem");
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCaption(String.format(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - %s", (String)"EADataPushBillPlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), name));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private String checkAndGetKey(List<String> dims, String key) {
        for (String dim : dims) {
            if (!key.startsWith(dim)) continue;
            return dim;
        }
        return null;
    }

    private void dealWithExp(SQLBuilder sql) {
        List<String> tableFieIdList = this.getDims().get("dimsUpperCase");
        log.info("dealWithExp\u751f\u6210\u52a8\u6001sql:" + JSON.toJSONString((Object)sql));
        DynamicObject modelObj = QueryServiceHelper.queryOne((String)"bcm_model", (String)"shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getModelId())});
        String fileName = modelObj.getString("shownumber");
        List<String> selectFieldList = tableFieIdList;
        if (CollectionUtils.isEmpty(selectFieldList)) {
            log.info("\u8bf7\u9009\u62e9\u9875\u9762\u67e5\u8be2\u6761\u4ef6\uff01");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9875\u9762\u7684\u67e5\u8be2\u6761\u4ef6\u3002", (String)"EADataPushBillPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        sql.addSelectField(selectFieldList.toArray(new String[0]));
        String isContainDyData = this.getPageCache().get(IS_CONTAIN_DY_DATA);
        sql.setExcludeDynaData(!Boolean.parseBoolean(isContainDyData));
        selectFieldList.add(FIELD_FMONEY);
        this.dispatch(tableFieIdList, sql, selectFieldList, fileName);
    }

    private SQLBuilder dealWithSqlEnvironment() {
        Long modelId = this.getModelId();
        String modelNumber = QueryDimensionServiceHelper.getModelNumber((long)modelId);
        SQLBuilder sql = new SQLBuilder(modelNumber);
        Map<String, List<String>> mapData = this.getDims();
        List<String> dims = mapData.get("dims");
        List<String> tableFieIdList = mapData.get("dimsUpperCase");
        List<String> dimsMemberModelList = mapData.get("dimsMemberModelList");
        for (int i = 0; i < dims.size(); ++i) {
            String tableFieId = tableFieIdList.get(i);
            String actionId = dims.get(i);
            String memberModel = dimsMemberModelList.get(i);
            List filterList = new ArrayList(10);
            if (kd.bos.util.StringUtils.isNotEmpty((String)this.getPageCache().get(actionId))) {
                filterList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(actionId), List.class);
            }
            ArrayList filterValueList = new ArrayList(10);
            HashSet entityIdNodeSet = new HashSet(16);
            Set<Object> processNumNodeSet = new HashSet(16);
            for (Map dataMap : filterList) {
                if (!actionId.equals(dataMap.get(DIM_KEY))) continue;
                String range = (String)dataMap.get(FIELD_SCOPE);
                if ("10".equals(range)) {
                    filterValueList.add(dataMap.get(FIELD_NUMBER));
                    if ("Entity".equalsIgnoreCase(actionId)) {
                        entityIdNodeSet.add(dataMap.get("id"));
                    }
                    if (!"Process".equalsIgnoreCase(actionId)) continue;
                    processNumNodeSet.add(dataMap.get(FIELD_NUMBER));
                    continue;
                }
                String member = MemberReader.findMemberById((long)modelId, (String)memberModel, (Long)Long.parseLong((String)dataMap.get("id"))).getNumber();
                Map result = QueryMemberDetailsHelper.getMemberIdsByRange((String)memberModel, (Long)Long.parseLong((String)dataMap.get("id")), (String)member, (int)Integer.parseInt(range), (String)String.valueOf(modelId), (DetailTypeEnum)DetailTypeEnum.OTHERS);
                if ("Entity".equalsIgnoreCase(actionId)) {
                    entityIdNodeSet.addAll((Collection)result.get("ids"));
                }
                if ("Process".equalsIgnoreCase(actionId)) {
                    processNumNodeSet = (Set)result.get("numbers");
                }
                ((Set)result.get("numbers")).forEach(data -> filterValueList.add(data));
            }
            if (CollectionUtils.isNotEmpty(filterValueList)) {
                sql.addFilter(tableFieId, filterValueList.toArray(new String[0]));
            }
            if (CollectionUtils.isNotEmpty(entityIdNodeSet)) {
                this.getPageCache().put("entityIdNodeSet", SerializationUtils.toJsonString(entityIdNodeSet));
            }
            if (CollectionUtils.isNotEmpty(processNumNodeSet)) {
                this.getPageCache().put("processNumNodeList", SerializationUtils.toJsonString(processNumNodeSet));
            } else if ("Process".equalsIgnoreCase(actionId) && processNumNodeSet.isEmpty()) {
                List<String> processNumNodeList = EADataPushUtil.queryDataByDime(sql, this.getModelId(), "Process", "bcm_processmembertree");
                this.getPageCache().put("processNumNodeList", SerializationUtils.toJsonString(processNumNodeList));
            }
            this.getPageCache().put(DIM_MEMBER_KEY + actionId, SerializationUtils.toJsonString(filterValueList));
        }
        return sql;
    }

    private void dispatch(List<String> tableFieIdList, SQLBuilder sql, List<String> selectFieldList, String fileName) {
        JobInfo jobInfo = new JobInfo();
        String appId = this.getModel().getDataEntityType().getAppId();
        jobInfo.setAppId(appId);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"EA\u751f\u6210\u6570\u636e\u63a8\u9001\u4efb\u52a1\u3002", (String)"EADataPushBillPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String exprType = this.getModel().getValue(EXPR_TYPE).toString();
        String taskClassname = "1".equals(exprType) ? "kd.fi.bcm.formplugin.intergration.EADataPushDownloadFile" : "kd.fi.bcm.formplugin.intergration.EADataPushDBTask";
        jobInfo.setTaskClassname(taskClassname);
        Gson gson = new Gson();
        String sqlStr = gson.toJson((Object)sql);
        params.put("tableFieIdList", tableFieIdList);
        params.put("sql", sqlStr);
        params.put("selectFieldList", selectFieldList);
        String tableName = "1".equals(exprType) ? fileName : this.getModel().getValue(RELAT_TABLE_PREFIX).toString();
        params.put("table", tableName);
        params.put("modelId", this.getModelId());
        List entityIdStrList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("entityIdNodeSet"), List.class);
        List<Long> entityIdList = entityIdStrList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List processNumNodeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("processNumNodeList"), List.class);
        Map<String, Set<String>> DCCurrencyMap = EADataPushUtil.getDCCurrency(this.getModelId(), entityIdList, processNumNodeList);
        Map<String, String> nodeCurrMap = EADataPushUtil.addNodeCurrency(sql.getCubecatalog(), entityIdList);
        params.put("DCCurrencyMap", SerializationUtils.toJsonString(DCCurrencyMap));
        params.put("nodeCurrMap", SerializationUtils.toJsonString(nodeCurrMap));
        List<String> orgEntityList = EADataPushUtil.queryDataByDime(sql, this.getModelId(), "Entity", "bcm_entitymembertree");
        params.put("orgEntityList", SerializationUtils.toJsonString(orgEntityList));
        String actionId = "taskcloseback";
        if ("1".equals(exprType)) {
            String containTitle = null != this.getModel().getValue(IS_CONTAIN_TITLE) ? this.getModel().getValue(IS_CONTAIN_TITLE).toString() : "";
            params.put("containTitle", containTitle);
            String separator = "1".equals(this.getModel().getValue(SEPARATOR)) ? "," : ";";
            params.put(SEPARATOR, separator);
            String filename = null != this.getModel().getValue(FILE_NAME) ? this.getModel().getValue(FILE_NAME).toString() : "";
            params.put(FILE_NAME, filename);
            int entityIndex = 0;
            for (int j = 0; j < selectFieldList.size(); ++j) {
                if (!"Entity".equals(selectFieldList.get(j))) continue;
                entityIndex = j;
                break;
            }
            params.put("entityIndex", entityIndex);
            params.put("clientViewProxy", this.getClientViewProxy());
            actionId = "taskfileback";
        }
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        log.info("dispatch\u4f20\u8f93\u6570\u636e:" + jobInfo);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setTimeout(3600);
        clientJobInfo.setParentPageId(this.getView().getPageId());
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)this.getView());
    }

    private void taskCallBack(Object returnData) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            JSONObject jsonData = JSON.parseObject((String)data);
            if (Boolean.FALSE.toString().equals(jsonData.getString("success"))) {
                this.getView().showTipNotification(jsonData.getString("message"));
            } else {
                this.getView().showMessage(jsonData.getString("message"));
            }
            this.saveOpeLogOfOlaoData(jsonData.getString("success"), jsonData.getString("message"), jsonData.getInteger("totalnum"));
        }
    }

    private void saveOpeLogOfOlaoData(String opeResult, String reason, Integer totalnum) {
        BatchProcessHelper.handleAsync(() -> {
            DynamicObject dyLog = BusinessDataServiceHelper.newDynamicObject((String)"bcm_olapdata_opelog");
            long modelId = this.getModelId();
            dyLog.set(MODEL, (Object)modelId);
            boolean isSuccess = Boolean.TRUE.toString().equals(opeResult);
            dyLog.set("operesult", (Object)(isSuccess ? "1" : "2"));
            String expType = (String)this.getModel().getValue(EXPR_TYPE);
            dyLog.set("opetype", (Object)expType);
            dyLog.set("reason", (Object)(isSuccess ? "" : reason));
            dyLog.set("dimcombs", (Object)this.compDims(modelId));
            String cacheValue = this.getPageCache().get(ALREADY_EXIST_SCHEME);
            if (kd.bos.util.StringUtils.isNotEmpty((String)cacheValue)) {
                JSONObject object = JSONObject.parseObject((String)cacheValue);
                dyLog.set("scheme", (Object)(kd.bos.util.StringUtils.isEmpty((String)((String)object.get((Object)"schemeId"))) || "0".equals(object.get((Object)"schemeId")) ? 0L : Long.parseLong(object.get((Object)"schemeId").toString())));
            }
            dyLog.set("tablename", "0".equals(expType) ? this.getModel().getValue(RELAT_TABLE_PREFIX) : "");
            dyLog.set(FILE_NAME, "1".equals(expType) ? this.getModel().getValue(FILE_NAME) : "");
            dyLog.set(IS_CONTAIN_DY_DATA, (Object)((Boolean)this.getModel().getValue(IS_CONTAIN_DY_DATA) != false ? "1" : "0"));
            dyLog.set("totalnum", (Object)totalnum);
            dyLog.set("traceid", (Object)RequestContext.get().getTraceId());
            dyLog.set("creator", (Object)RequestContext.get().getCurrUserId());
            dyLog.set("createtime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyLog});
        });
    }

    private String compDims(long modelId) {
        StringBuilder sb = new StringBuilder();
        try {
            Map<String, String> dimNum2Names = MemberReader.getDimensionNumber2nameMap((String)MemberReader.findModelNumberById((Object)modelId)).values().stream().map(x -> x.split(";")).collect(Collectors.toMap(k -> k[0], v -> v[1], (k, v) -> k));
            for (Map.Entry<String, String> next : dimNum2Names.entrySet()) {
                List dimsMemberNameList;
                String dimNum = next.getKey();
                String dimName = next.getValue();
                String jsonDims = this.getPageCache().get(dimNum.toLowerCase(Locale.ENGLISH));
                if (!kd.bos.util.StringUtils.isNotEmpty((String)jsonDims) || !CollectionUtils.isNotEmpty((Collection)(dimsMemberNameList = (List)SerializationUtils.fromJsonString((String)jsonDims, List.class)))) continue;
                sb.append(dimNum).append(" ").append(dimName).append(":");
                for (Map memMaps : dimsMemberNameList) {
                    String memNum = (String)memMaps.get(FIELD_NUMBER);
                    String memName = (String)memMaps.get(FIELD_NAME);
                    sb.append(memNum).append(" ").append(memName).append(";");
                }
                sb.append(" ");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return sb.toString();
    }

    private void buildPageViewShowName(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.VALUE_10) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"EADataPushBillPlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(",");
        }
    }

    private void showBasePage(String action) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_ea_datapushschempop");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u57fa\u672c\u4fe1\u606f", (String)"AbstractRptAdjustQueryPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        IDataModel model = this.getModel();
        if (action_save_as.equals(action)) {
            formShowParameter.setCustomParam(SCHEME_NAME, model.getValue(SCHEME_NAME));
        }
        formShowParameter.setCustomParam("applyscope", (Object)"1");
        formShowParameter.setCustomParam(MODEL, (Object)this.getModelId());
        formShowParameter.setCustomParam("tablename", this.getModel().getValue(RELAT_TABLE_PREFIX));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, action));
        this.getView().showForm(formShowParameter);
    }

    private void saveAlreadyExistScheme() {
        Map mapData = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALREADY_EXIST_SCHEME), Map.class);
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        if (kd.bos.util.StringUtils.isEmpty((String)((String)mapData.get("schemeName")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7f13\u5b58\u4e22\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"EADataPushBillPlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        returnData.put(FIELD_NAME, this.getModel().getValue(SCHEME_NAME).toString());
        returnData.put(FIELD_NUMBER, (String)mapData.get("schemeNumber"));
        returnData.put("applyscope", (String)mapData.get("schemeApplyScope"));
        returnData.put("description", (String)mapData.get("schemeDescription"));
        Object exprtype = this.getModel().getValue(EXPR_TYPE);
        returnData.put("tablename", "0".equals(exprtype) ? this.getModel().getValue(RELAT_TABLE_PREFIX).toString() : "");
        this.actionSave(returnData, true, true);
    }

    private void showSchemePage(String action) {
        ListShowParameter formShowParameter = new ListShowParameter();
        String cacheValue = this.getPageCache().get(ALREADY_EXIST_SCHEME);
        if (kd.bos.util.StringUtils.isNotEmpty((String)cacheValue)) {
            JSONObject object = JSONObject.parseObject((String)cacheValue);
            String schemeId = (String)object.get((Object)"schemeId");
            formShowParameter.setCustomParam("schemeId", (Object)schemeId);
        }
        formShowParameter.setFormId("bcm_ea_datapushschemlist");
        formShowParameter.setBillFormId("bcm_ea_datapushschemdata");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u5217\u8868", (String)"EADataPushBillPlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, action));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void handelBaseBack(ClosedCallBackEvent closedCallBackEvent, boolean isSave, boolean isNotAdd) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            this.actionSave(returnData, isSave, isNotAdd);
        }
    }

    private void handelSchemeBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        this.isCloseTipWindow = true;
        Page page = this.getPage(this.getView());
        Area rowArea = page.findAreaBySign(PAGE_PANEL);
        ArrayList<String> needDel = new ArrayList<String>(10);
        List elementList = rowArea.getElementListList();
        for (Element element : elementList) {
            needDel.add(element.getSign());
        }
        needDel.forEach(sign -> rowArea.removeElememt(sign));
        this.createF7Page();
        String schemeId = (String)returnData.get("schemeId");
        this.initDefaultMemberFromModel(schemeId, needDel);
        this.getModel().setValue(SCHEME_NAME, returnData.get("schemeName"));
        this.getModel().setValue(RELAT_TABLE_PREFIX, returnData.get(RELAT_TABLE_PREFIX));
        this.getPageCache().put(ALREADY_EXIST_SCHEME, SerializationUtils.toJsonString((Object)returnData));
        this.getModel().setValue(EXPR_TYPE, returnData.get(EXPR_TYPE));
        this.getModel().setValue(IS_CONTAIN_DY_DATA, (Object)Boolean.valueOf((String)returnData.get(IS_CONTAIN_DY_DATA)));
        this.getModel().setValue(IS_CONTAIN_TITLE, returnData.get(IS_CONTAIN_TITLE));
        this.getModel().setValue(SEPARATOR, returnData.get(SEPARATOR));
    }

    private void actionSave(Map<String, String> returnData, boolean isSave, boolean isNotAdd) {
        String opName = isSave ? ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractRptAdjustQueryPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53e6\u5b58\u4e3a\u6210\u529f", (String)"EADataPushBillPlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
        try (TXHandle tx = TX.required((String)"bcm_ea_datapushschemdata");){
            try {
                DynamicObject plan = null;
                if (isNotAdd && isSave) {
                    QFilter filter = new QFilter(FIELD_NUMBER, "=", (Object)returnData.get(FIELD_NUMBER));
                    filter.and(MODEL, "=", (Object)this.getModelId());
                    long id = QueryServiceHelper.queryOne((String)"bcm_ea_datapushschemdata", (String)"id", (QFilter[])filter.toArray()).getLong("id");
                    plan = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_ea_datapushschemdata");
                } else {
                    plan = BusinessDataServiceHelper.newDynamicObject((String)"bcm_ea_datapushschemdata");
                }
                plan.set(FIELD_NAME, (Object)returnData.get(FIELD_NAME));
                plan.set(FIELD_NUMBER, (Object)returnData.get(FIELD_NUMBER));
                plan.set("applyscope", (Object)returnData.get("applyscope"));
                plan.set("description", (Object)returnData.get("description"));
                plan.set("tablename", (Object)returnData.get("tablename"));
                plan.set(MODEL, (Object)this.getModelId());
                String userId = RequestContext.get().getUserId();
                Date nowDate = TimeServiceHelper.now();
                if (!isNotAdd || !isSave) {
                    plan.set("creator", (Object)userId);
                    plan.set("createtime", (Object)nowDate);
                }
                plan.set("modifier", (Object)userId);
                plan.set("modifytime", (Object)nowDate);
                plan.set(EXPR_TYPE, (Object)this.getModel().getValue(EXPR_TYPE).toString());
                plan.set(IS_CONTAIN_DY_DATA, (Object)(this.getModel().getDataEntity().getBoolean(IS_CONTAIN_DY_DATA) ? "1" : "0"));
                plan.set(IS_CONTAIN_TITLE, (Object)this.getModel().getValue(IS_CONTAIN_TITLE).toString());
                plan.set(SEPARATOR, (Object)this.getModel().getValue(SEPARATOR).toString());
                DynamicObjectCollection coll = plan.getDynamicObjectCollection(comDImEntry);
                coll.clear();
                Map<String, List<String>> mapData = this.getDims();
                List<String> dims = mapData.get("dims");
                List<String> dimsIdList = mapData.get("dimsIdList");
                for (int i = 0; i < dims.size(); ++i) {
                    String key = dims.get(i);
                    if (kd.bos.util.StringUtils.isEmpty((String)this.getPageCache().get(key))) continue;
                    List list = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(key), List.class);
                    for (Map map : list) {
                        String pid = map.get("pid") == null ? null : ((String)map.get("pid")).trim();
                        Long mid = Long.valueOf((String)map.get("id"));
                        int range = Integer.parseInt((String)map.get(FIELD_SCOPE));
                        DynamicObject entry = new DynamicObject(coll.getDynamicObjectType());
                        entry.set("comdimension", (Object)dimsIdList.get(i));
                        entry.set("seq", (Object)i);
                        entry.set("commembid", (Object)mid);
                        entry.set("range", (Object)range);
                        entry.set("pid", kd.bos.util.StringUtils.isEmpty((String)pid) ? Long.valueOf(0L) : pid);
                        coll.add((Object)entry);
                    }
                }
                Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plan});
                if (result != null && result.length > 0) {
                    DynamicObject afterSavePlan = (DynamicObject)result[0];
                    HashMap<String, String> returnPlan = new HashMap<String, String>(16);
                    returnPlan.put("schemeId", String.valueOf(afterSavePlan.getPkValue()));
                    returnPlan.put("schemeName", afterSavePlan.getString(FIELD_NAME));
                    returnPlan.put("schemeNumber", afterSavePlan.getString(FIELD_NUMBER));
                    returnPlan.put("schemeModel", afterSavePlan.getString(MODEL));
                    returnPlan.put("schemeApplyScope", afterSavePlan.getString("applyscope"));
                    returnPlan.put("schemeDescription", afterSavePlan.getString("description"));
                    returnPlan.put("schemeCreator", afterSavePlan.getString("creator"));
                    returnPlan.put("tablename", afterSavePlan.getString("tablename"));
                    returnPlan.put(EXPR_TYPE, afterSavePlan.getString(EXPR_TYPE));
                    returnPlan.put("isextractdata", afterSavePlan.getString("isextractdata"));
                    returnPlan.put(IS_CONTAIN_DY_DATA, afterSavePlan.getString(IS_CONTAIN_DY_DATA));
                    returnPlan.put(IS_CONTAIN_TITLE, afterSavePlan.getString(IS_CONTAIN_TITLE));
                    returnPlan.put(SEPARATOR, afterSavePlan.getString(SEPARATOR));
                    this.getPageCache().put(ALREADY_EXIST_SCHEME, SerializationUtils.toJsonString(returnPlan));
                }
                this.getModel().setValue(SCHEME_NAME, (Object)returnData.get(FIELD_NAME));
                this.getView().showSuccessNotification(opName);
                this.isCloseTipWindow = true;
                this.getPageCache().put("isCloseTipWindow", String.valueOf(this.isCloseTipWindow));
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void initDefaultMemberFromModel(String schemeId, List<String> needDel) {
        DynamicObject scheDy = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_ea_datapushschemdata");
        Map<String, List<Map<String, String>>> f7data = EADataPushUtil.buildDefaultF7Data(scheDy, this.getModelId());
        if (f7data.size() < 1) {
            return;
        }
        for (Map.Entry<String, List<Map<String, String>>> f7Entry : f7data.entrySet()) {
            String key = f7Entry.getKey();
            List<Map<String, String>> list = f7Entry.getValue();
            StringBuilder sb = new StringBuilder();
            for (Map<String, String> map : list) {
                this.buildPageViewShowName(sb, map.get(FIELD_NAME), Integer.parseInt(map.get(FIELD_SCOPE)));
            }
            this.getPageCache().put(key, SerializationUtils.toJsonString(list));
            this.getModel().setValue(key, (Object)sb.substring(0, sb.length() - 1));
            this.getView().updateView(key);
        }
        needDel.forEach(sign -> {
            if (!f7data.containsKey(sign)) {
                this.getPageCache().remove(sign);
                this.getModel().setValue(sign, null);
                this.getView().updateView(sign);
            }
        });
    }

    private boolean checkDimIsEmpty() {
        boolean result = false;
        for (String dim : this.mustInputs) {
            String value = this.getPageCache().get(dim.toLowerCase(Locale.ENGLISH));
            if (!kd.bos.util.StringUtils.isEmpty((String)value)) continue;
            result = true;
        }
        return result;
    }

    protected void refreshBillByUserSelect(List<String> dimKeys, Boolean isOnlyLeaf) {
        if (GuidePageUtils.refreshBillByUserSelect4List(dimKeys, this.getView())) {
            return;
        }
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), MODEL);
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        Object modelIdCust = showParam.getCustomParam("modelIdCust");
        if (modelIdCust == null) {
            return;
        }
        if (modelIdCust.equals(0)) {
            if (kd.bos.util.StringUtils.isEmpty((String)modelId)) {
                this.getPageCache().put("KEY_MODEL_ID", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f53\u7cfb\u53ef\u4ee5\u4f7f\u7528\u3002", (String)"EADataPushBillPlugin_13", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                ApplicationTypeEnum application;
                this.getModel().setValue(MODEL, (Object)modelId);
                this.getPageCache().put("KEY_MODEL_ID", modelId);
                SingleMemberF7Util.cacheModelPrem(this.getPageCache(), Long.valueOf(modelId), this.getApplicationType());
                ArrayList<String> dimensions = new ArrayList<String>(10);
                for (String key : dimKeys) {
                    dimensions.add(UserSelectUtil.getDimensionByKey(key));
                    dimensions.add(UserSelectUtil.getDimensionByKey(key) + ".membermodel");
                    dimensions.add(key + ".isleaf");
                }
                String selectFileds = UserSelectUtil.buildOtherSelectFileds(dimensions);
                DynamicObject userSelect = UserSelectUtil.getUserSelectDynamicObject(selectFileds, application = ModelUtil.queryApp((IFormView)this.getView()));
                if (userSelect == null || !modelId.equals(userSelect.getString(MODEL))) {
                    return;
                }
                PermissionService permSerivce = PermissionServiceImpl.getInstance((Long)LongUtil.toLong((Object)modelId));
                this.getModel().beginInit();
                for (String key : dimKeys) {
                    boolean isNoPerm;
                    SysDimensionEnum dim;
                    Long memberId = userSelect.getLong(key);
                    if (memberId == 0L || !QueryServiceHelper.exists((String)(dim = SysDimensionEnum.getEnumByLowerCaseNumber((String)key)).getMemberTreefrom(), (QFilter[])QFilter.of((String)"model = ? and id = ?", (Object[])new Object[]{Long.valueOf(modelId), memberId}).toArray()) || (isNoPerm = permSerivce.isAllNoPerm(Long.valueOf(userSelect.getLong(UserSelectUtil.getDimensionByKey(key))), userSelect.getString(UserSelectUtil.getDimensionByKey(key) + ".membermodel"), (Collection)Lists.newArrayList((Object[])new Long[]{memberId}))) || isOnlyLeaf.booleanValue() && !userSelect.getBoolean(key + ".isleaf")) continue;
                    this.getModel().setValue(key, (Object)memberId);
                }
                this.getModel().endInit();
            }
        } else {
            this.getModel().setValue(MODEL, (Object)ConvertUtil.convertObjToLong((Object)modelIdCust));
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelIdCust));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMemberTableAndExpData() {
        String memberKey = "EA_MEMBER_TABLE_KEY_PREFIX_" + this.getModelId();
        try {
            Object key = AppCacheServiceHelper.get((String)memberKey);
            if (key == null || "".equals(key.toString())) {
                AppCacheServiceHelper.put((String)memberKey, (Object)"1", (int)300);
                Long modelId = this.getModelId();
                Map<String, List<String>> mapData = this.getDims();
                List<String> dims = mapData.get("dims");
                List<String> dimsMemberModelList = mapData.get("dimsMemberModelList");
                List<String> dimsUpperCase = mapData.get("dimsUpperCase");
                Map numberMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)modelId));
                HashMap num2shortMap = new HashMap(numberMap.size());
                numberMap.entrySet().forEach(e -> num2shortMap.put(((String)e.getValue()).toLowerCase(Locale.ENGLISH), e.getKey()));
                DynamicObject modelObj = QueryServiceHelper.queryOne((String)"bcm_model", (String)"shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
                for (int i = 0; i < dims.size(); ++i) {
                    String actionId = dims.get(i);
                    String dimsMemberModel = dimsMemberModelList.get(i);
                    List dimsMemberNameList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(DIM_MEMBER_KEY + actionId), List.class);
                    String baseTable = "";
                    String tablePostfix = "";
                    for (SysDimensionEnum sysDimensionEnum : SysDimensionEnum.values()) {
                        if (!sysDimensionEnum.getMemberTreefrom().equals(dimsMemberModel)) continue;
                        baseTable = sysDimensionEnum.getMemberTreetable();
                        tablePostfix = sysDimensionEnum.getShortnumber();
                        break;
                    }
                    if ("t_bcm_structofdefined".equalsIgnoreCase(baseTable)) {
                        tablePostfix = (String)num2shortMap.get(actionId);
                    }
                    String newTable = TABLE_PREFIX + modelObj.getString("shownumber") + "_" + tablePostfix;
                    this.dropTable(newTable);
                    String DDLSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '" + newTable + "')  " + this.getTableName(newTable, actionId);
                    DB.execute((DBRoute)new DBRoute("bcm"), (String)DDLSql);
                    DB.execute((DBRoute)new DBRoute("bcm"), (String)("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'PK_" + newTable + "') ALTER  TABLE " + newTable + " ADD CONSTRAINT PK_" + newTable + " PRIMARY KEY( FID );"));
                    log.info("\u8f93\u51fa\u7ef4\u5ea6\u6570\u636e\u8868\uff1a" + newTable);
                    String transferSql = "insert into " + newTable + " select " + this.getSelectFile(actionId) + " from " + baseTable + " WHERE FMODELID =" + modelId;
                    String sqlAppend = kd.bos.util.StringUtils.isNotEmpty((String)this.getPageCache().get(actionId)) ? " and  FNUMBER in (" + this.getPlaceholder(dimsMemberNameList) + ");" : ("bcm_userdefinedmembertree".equals(dimsMemberModel) ? " and flongnumber like '" + dimsUpperCase.get(i) + "%'" : "");
                    DB.execute((DBRoute)new DBRoute("bcm"), (String)(transferSql + sqlAppend));
                }
            }
        }
        finally {
            AppCacheServiceHelper.remove((String)memberKey);
        }
    }

    private void dropTable(String table) {
        boolean flag = DB.exitsTable((DBRoute)DBRoute.of((String)"bcm"), (String)table);
        if (flag) {
            String dropSql = "drop table " + table;
            DB.execute((DBRoute)new DBRoute("bcm"), (String)dropSql);
            log.info("\u7ef4\u5ea6\u6570\u636e\u6e05\u9664\u8868\u6210\u529f! DBRoute:bcm table:" + table);
        }
    }

    private String getTableName(String table, String actionId) {
        String entity = ", FISINDEPENDENTORG char(1) NOT NULL DEFAULT '0', FCTRLORGID bigint NOT NULL DEFAULT '0', FCURRENCYID bigint NOT NULL DEFAULT '0' ";
        String account = ", FACCOUNTTYPE varchar(2) NOT NULL DEFAULT '', FDRCRDIRECT char(1) NOT NULL DEFAULT '', FISPARTICIPMERGE char(1) NOT NULL DEFAULT '0' ";
        String currencyField = "CREATE TABLE  " + table + " (  FID  bigint NOT NULL DEFAULT 0,  FNUMBER VARCHAR(50) DEFAULT '' NOT NULL,  FNAME  VARCHAR(600) DEFAULT '' NOT NULL,  FPARENTID  bigint NOT NULL DEFAULT 0,  FAGGOPRT  VARCHAR(10) DEFAULT '' NOT NULL,  FISLEAF  VARCHAR(2) DEFAULT '' NOT NULL,  FSTORAGETYPE  char(1) NOT NULL DEFAULT '0',  FDESCRIPTION  VARCHAR(350) ";
        String end = " )";
        if ("Entity".equalsIgnoreCase(actionId)) {
            return currencyField + entity + end;
        }
        if ("Account".equalsIgnoreCase(actionId)) {
            return currencyField + account + end;
        }
        return currencyField + end;
    }

    private String getSelectFile(String actionId) {
        String selectEntityField = ",FISINDEPENDENTORG,FCTRLORGID,FCURRENCYID";
        String selectAccountField = ",FACCOUNTTYPE,FDRCRDIRECT,FISPARTICIPMERGE";
        String selectCurrencyField = "FID,FNUMBER,FNAME,FPARENTID,FAGGOPRT,FISLEAF,FSTORAGETYPE,FDESCRIPTION";
        if ("Entity".equalsIgnoreCase(actionId)) {
            return selectCurrencyField + selectEntityField;
        }
        if ("Account".equalsIgnoreCase(actionId)) {
            return selectCurrencyField + selectAccountField;
        }
        return selectCurrencyField;
    }

    private String getPlaceholder(List<String> dimsMemberNameList) {
        StringBuilder strId = new StringBuilder();
        dimsMemberNameList.forEach(str -> strId.append('\'').append((String)str).append("',"));
        return strId.substring(0, strId.length() - 1);
    }

    private boolean isContainChinese() {
        String tablePreFix = this.getModel().getValue(RELAT_TABLE_PREFIX).toString();
        Pattern pat = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher matcher = pat.matcher(tablePreFix.trim());
        return matcher.find();
    }

    private void setTableName() {
        DynamicObject modelObj = QueryServiceHelper.queryOne((String)"bcm_model", (String)"shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getModelId())});
        if (modelObj == null) {
            return;
        }
        String tablename = TABLE_PREFIX + modelObj.getString("shownumber") + "_fact";
        this.getModel().setValue(RELAT_TABLE_PREFIX, (Object)tablename);
    }

    private void initComboText() {
        ComboEdit comboEdit = (ComboEdit)this.getControl(EXPR_TYPE);
        ComboProp comboProp = (ComboProp)comboEdit.getProperty();
        if (!ConfigServiceHelper.getGlobalBoolParam((String)"isOpenDbExport")) {
            List newList = comboProp.getComboItems().stream().filter(x -> "1".equals(x.getValue())).map(y -> new ComboItem(y.getName(), y.getValue())).collect(Collectors.toList());
            comboEdit.setComboItems(newList);
        }
    }

    private void createDataTableName() {
        long modelId = this.getModelId();
        String modelNumber = MemberReader.findModelSNumberById((Object)modelId);
        this.getModel().setValue(RELAT_TABLE_PREFIX, (Object)(TABLE_PREFIX + modelNumber + "_fact"));
    }
}

