/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MDResultSetReader;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.formplugin.intergration.util.EADataPushUtil;

public class EADataPushDBTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(EADataPushDBTask.class);
    private static final String EA_TABLE_KEY_PREFIX = "EA_TABLE_KEY_PREFIX_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        List tableFieIdList = (List)params.get("tableFieIdList");
        String sqlStr = params.get("sql").toString();
        List selectFieldList = (List)params.get("selectFieldList");
        String table = params.get("table").toString();
        Long modelId = Long.valueOf(params.get("modelId").toString());
        Map DCCurrencyMap = (Map)SerializationUtils.fromJsonString((String)params.get("DCCurrencyMap").toString(), Map.class);
        Map nodeCurrMap = (Map)SerializationUtils.fromJsonString((String)params.get("nodeCurrMap").toString(), Map.class);
        List orgEntityList = (List)SerializationUtils.fromJsonString((String)params.get("orgEntityList").toString(), List.class);
        log.info("EA\u6570\u636e\u5bfc\u51fa\u6267\u884csql: " + sqlStr);
        StringBuilder message = new StringBuilder();
        try {
            Object key = AppCacheServiceHelper.get((String)(EA_TABLE_KEY_PREFIX + table));
            if (key == null || "".equals(key.toString())) {
                AppCacheServiceHelper.put((String)(EA_TABLE_KEY_PREFIX + table), (Object)"1", (int)1200);
                log.info("EA\u6570\u636e\u5bfc\u51fa\u83b7\u53d6\u5230\u7684\u7ec4\u7ec7\u6570: " + orgEntityList.toString());
                long startTime = System.currentTimeMillis();
                int totalData = this.runInThread(sqlStr, orgEntityList, selectFieldList, table, tableFieIdList, modelId, DCCurrencyMap, nodeCurrMap);
                message.append(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u6210\u529f,\u603b\u6570\u636e:%s\u3002", (String)"EADataPushDBTask_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), totalData));
                long timeConsuming = System.currentTimeMillis() - startTime;
                log.info("\u603b\u5171\u8017\u65f6:" + timeConsuming);
                message.append(String.format(ResManager.loadKDString((String)"\u603b\u5171\u8017\u65f6:%s\u6beb\u79d2", (String)"EADataPushDBTask_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), timeConsuming));
                result.put("success", "true");
                result.put("message", message.toString());
                result.put("totalnum", totalData);
            } else {
                message.append(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u6570\u636e\u6b63\u5728\u63a8\u9001\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"EADataPushDBTask_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                result.put("success", "false");
                result.put("message", message.toString());
                result.put("totalnum", 0);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Object)("EADataPushDBTask\u6267\u884c\u4efb\u52a1\u62a5\u9519:" + e));
            result.put("success", "false");
            result.put("message", e.getMessage());
            result.put("totalnum", 0);
        }
        finally {
            AppCacheServiceHelper.remove((String)(EA_TABLE_KEY_PREFIX + table));
            this.feedbackCustomdata(result);
        }
    }

    private int runInThread(String sqlStr, List<String> entities, List<String> selectFieldList, String table, List<String> tableFieIdList, Long modelId, Map<String, List<String>> DCCurrencyMap, Map<String, String> nodeCurrMap) {
        EADataPushUtil.dropTable(table);
        EADataPushUtil.createTable(EADataPushUtil.addFToFieId(tableFieIdList), table);
        ArrayList<Callable<Integer>> runners = new ArrayList<Callable<Integer>>(entities.size());
        Counter counter = new Counter();
        if (entities.size() > 1) {
            counter.total = entities.size();
        } else {
            counter.countType = 1;
        }
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        ReentrantReadWriteLock.ReadLock r = rwLock.readLock();
        ReentrantReadWriteLock.WriteLock w = rwLock.writeLock();
        for (String entity : entities) {
            runners.add(() -> {
                ArrayList<Object[]> resultList = new ArrayList<Object[]>(1024);
                Gson gson = new Gson();
                SQLBuilder sql = (SQLBuilder)gson.fromJson(sqlStr, SQLBuilder.class);
                sql.getFilters().removeIf(pair -> "Entity".equalsIgnoreCase((String)pair.p1));
                sql.getFilters().add(new Pair((Object)"Entity", (Object)new String[]{entity}));
                ArrayList<Object> sqlParams = new ArrayList<Object>(16);
                int totalCount = 0;
                Map<String, String> dataMap = EADataPushUtil.dealWithDataByProcess(sql, modelId);
                boolean isContainsEIRpt = dataMap.containsKey("isContainsEIRpt");
                boolean isContainsERAdj = dataMap.containsKey("isContainsERAdj");
                EADataPushUtil.transformSqlByECOrDC(sql, DCCurrencyMap, nodeCurrMap, entity);
                int processIndex = EADataPushUtil.getSelectFieldIndex(selectFieldList, "process") + 1;
                if (counter.countType == 1) {
                    MDResultSet result = OlapServiceHelper.queryData((SQLBuilder)sql);
                    counter.total = result.getCount();
                    result = null;
                }
                try (MDResultSetReader resultSet = OlapServiceHelper.queryDataReader((SQLBuilder)sql);){
                    while (resultSet.next()) {
                        sqlParams.clear();
                        sqlParams.add(GlobalIdUtil.genGlobalLongId());
                        Row row = resultSet.getRow();
                        selectFieldList.forEach(e -> {
                            String value = row.getString(e);
                            sqlParams.add(value);
                        });
                        String currency = row.getString("Currency");
                        String process = row.getString("Process");
                        if (isContainsEIRpt && "IRpt".equals(process) && currency.equalsIgnoreCase((String)nodeCurrMap.get(entity))) {
                            sqlParams.set(processIndex, "EIRpt");
                        } else if (isContainsERAdj && "RAdj".equals(process) && currency.equalsIgnoreCase((String)nodeCurrMap.get(entity))) {
                            sqlParams.set(processIndex, "ERAdj");
                        }
                        resultList.add(sqlParams.toArray());
                        if (counter.countType != 1 || ++counter.completedCount % 5000 != 0) continue;
                        this.feedBack(counter);
                    }
                    this.reckonCounter(counter, r, w);
                }
                totalCount = EADataPushUtil.pollAndInsertData(resultList, totalCount, EADataPushUtil.addFToFieId(selectFieldList), table);
                return totalCount;
            });
        }
        List countList = ThreadPoolService.runInWaiting4Thread((Callable[])runners.toArray(new Callable[0]));
        int totalData = 0;
        for (int i = 0; i < countList.size(); ++i) {
            totalData += ((Integer)countList.get(i)).intValue();
        }
        return totalData;
    }

    private void feedBack(Counter counter) {
        String cont = counter.countType == 0 ? ResManager.loadKDString((String)"\u4e2a\u7ec4\u7ec7\u6570\u636e", (String)"EADataPushDBTask_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6761\u6570\u636e", (String)"EADataPushDBTask_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String desc = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5bfc\u6570\u4e1a\u52a1\uff0c\u5df2\u5bfc\u51fa%1$s%2$s\u3002", (String)"EADataPushDBTask_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), counter.completedCount, cont);
        this.feedbackProgress(100 * counter.completedCount / counter.total, desc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reckonCounter(Counter counter, ReentrantReadWriteLock.ReadLock r, ReentrantReadWriteLock.WriteLock w) {
        if (counter.countType == 1) {
            this.feedBack(counter);
        } else if (counter.countType == 0) {
            w.lock();
            try {
                ++counter.completedCount;
            }
            finally {
                w.unlock();
            }
            r.lock();
            try {
                this.feedBack(counter);
            }
            finally {
                r.unlock();
            }
        }
    }

    private static class Counter {
        int total = 0;
        int completedCount = 0;
        int countType = 0;

        private Counter() {
        }
    }
}

