/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MDResultSetReader;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class EADataPushDownloadFile
extends AbstractTask {
    private static final Log log = LogFactory.getLog(EADataPushDownloadFile.class);
    private static final String enter = "\r\n";
    private static final String TIP_DATA = "!DATA";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        StringBuilder message = new StringBuilder();
        Map<String, Object> result = null;
        try {
            result = this.downloadData(map);
            if (result.get("url") != null && StringUtils.isNotEmpty((String)result.get("url").toString())) {
                message.append(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u6210\u529f,\u603b\u6570\u636e\uff1a%1$s\uff0c\u603b\u5171\u8017\u65f6\uff1a%s\u6beb\u79d2\u3002", (String)"EADataPushDownloadFile_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), result.get("totalData"), result.get("totalTime")));
                result.put("success", "true");
                result.put("totalnum", result.get("totalData"));
            } else {
                message.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"EADataPushDownloadFile_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                result.put("success", "false");
                result.put("totalnum", 0);
            }
            result.put("message", message.toString());
        }
        catch (Exception e) {
            log.error("EADataPushDownloadFile\u6267\u884c\u4efb\u52a1\u62a5\u9519:" + e);
            if (result != null) {
                result.put("success", "false");
                result.put("message", e.getMessage());
                result.put("totalnum", 0);
            }
        }
        finally {
            this.feedbackCustomdata(result);
        }
    }

    public Map<String, Object> downloadData(Map<String, Object> params) {
        Gson gson = new Gson();
        String sqlStr = params.get("sql").toString();
        SQLBuilder sql = (SQLBuilder)gson.fromJson(sqlStr, SQLBuilder.class);
        List selectFieldList = (List)params.get("selectFieldList");
        String containTitle = params.get("containTitle").toString();
        String tableName = params.get("table").toString();
        String fileName = params.get("filename").toString();
        String separator = params.get("separator").toString();
        Map DCCurrencyMap = (Map)SerializationUtils.fromJsonString((String)params.get("DCCurrencyMap").toString(), Map.class);
        Map nodeCurrMap = (Map)SerializationUtils.fromJsonString((String)params.get("nodeCurrMap").toString(), Map.class);
        String defaultFileName = "Data" + tableName + DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
        String mergeFileName = StringUtils.isEmpty((String)fileName) ? defaultFileName : fileName;
        Long modelId = Long.valueOf(params.get("modelId").toString());
        List orgEntityList = (List)SerializationUtils.fromJsonString((String)params.get("orgEntityList").toString(), List.class);
        long startTime = System.currentTimeMillis();
        StringBuilder topNameSb = new StringBuilder();
        if ("0".equals(containTitle)) {
            EADataPushDownloadFile.dealWithFileTop(topNameSb, sql, separator);
        } else {
            String tips = "!DATA!" + separator + '!' + Boolean.FALSE;
            EADataPushDownloadFile.dealWithSb(topNameSb, Lists.newArrayList((Object[])new String[]{tips}));
        }
        Map<String, Object> resultMap = this.runInThread(sqlStr, orgEntityList, selectFieldList, separator, mergeFileName, topNameSb.toString(), modelId, DCCurrencyMap, nodeCurrMap, containTitle);
        long totalTime = System.currentTimeMillis() - startTime;
        resultMap.put("totalTime", totalTime);
        log.info("EA\u6570\u636e\u5bfc\u51fa\u83b7\u53d6\u5230\u7684\u7ec4\u7ec7\u6570: " + orgEntityList);
        log.info("EA\u6570\u636e\u63d0\u53d6\u5bfc\u51fa\u6587\u4ef6\u603b\u5171\u8017\u65f6:" + totalTime);
        return resultMap;
    }

    private Map<String, Object> runInThread(String sqlStr, List<String> entities, List<String> selectFieldList, String separator, String mergeFileName, String topName, Long modelId, Map<String, List<String>> DCCurrencyMap, Map<String, String> nodeCurrMap, String containTitle) {
        ConcurrentHashMap allExported = new ConcurrentHashMap(16);
        File dataFile = this.makeFileDir(mergeFileName);
        ArrayList<Callable<Integer>> runners = new ArrayList<Callable<Integer>>(entities.size());
        Counter counter = new Counter();
        if (entities.size() > 1) {
            counter.total = entities.size();
        } else {
            counter.countType = 1;
        }
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        ReentrantReadWriteLock.ReadLock r = rwLock.readLock();
        ReentrantReadWriteLock.WriteLock w = rwLock.writeLock();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (String entity : entities) {
            runners.add(() -> {
                Gson gson = new Gson();
                SQLBuilder sql = (SQLBuilder)gson.fromJson(sqlStr, SQLBuilder.class);
                sql.getFilters().removeIf(pair -> "Entity".equalsIgnoreCase((String)pair.p1));
                sql.getFilters().add(new Pair((Object)"Entity", (Object)new String[]{entity}));
                this.transformSqlByECOrDC(sql, DCCurrencyMap, nodeCurrMap, entity);
                Map<String, String> dataMap = this.dealWithDataByProcess(sql, modelId);
                boolean isContainsEIRpt = dataMap.containsKey("isContainsEIRpt");
                boolean isContainsERAdj = dataMap.containsKey("isContainsERAdj");
                if (counter.countType == 1) {
                    MDResultSet result = OlapServiceHelper.queryData((SQLBuilder)sql);
                    counter.total = result.getCount();
                    result = null;
                }
                int cutCount = 0;
                try (MDResultSetReader resultSet = OlapServiceHelper.queryDataReader((SQLBuilder)sql);){
                    StringBuilder sb = new StringBuilder();
                    StringBuilder dataSb = new StringBuilder();
                    while (resultSet.next()) {
                        dataSb.setLength(0);
                        Row row = resultSet.getRow();
                        for (int i = 0; i < selectFieldList.size(); ++i) {
                            String selectField = (String)selectFieldList.get(i);
                            String value = i == selectFieldList.size() - 1 ? "" : separator;
                            dataSb.append(row.getString(selectField)).append(value);
                        }
                        String currency = row.getString("Currency");
                        String process = row.getString("Process");
                        if (isContainsEIRpt && "IRpt".equals(process)) {
                            if (!currency.equalsIgnoreCase((String)nodeCurrMap.get(entity))) continue;
                            String EIRptStr = dataSb.toString().replace(separator + "IRpt" + separator, separator + "EIRpt" + separator);
                            sb.append(EIRptStr).append(enter);
                        } else if (isContainsERAdj && "RAdj".equals(process)) {
                            if (!currency.equalsIgnoreCase((String)nodeCurrMap.get(entity))) continue;
                            String RAdjStr = dataSb.toString().replace(separator + "RAdj" + separator, separator + "ERAdj" + separator);
                            sb.append(RAdjStr).append(enter);
                        } else {
                            sb.append((CharSequence)dataSb).append(enter);
                        }
                        ++cutCount;
                        if (counter.countType != 1 || ++counter.completedCount % 5000 != 0) continue;
                        this.feedBack(counter);
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    this.saveTempFile(out, dataFile, sb.toString(), topName);
                    allExported.put(entity, "true");
                    this.reckonCounter(counter, r, w);
                }
                return cutCount;
            });
        }
        List countList = ThreadPoolService.runInWaiting4Thread((Callable[])runners.toArray(new Callable[0]));
        int totalData = 0;
        for (int i = 0; i < countList.size(); ++i) {
            totalData += ((Integer)countList.get(i)).intValue();
        }
        boolean aFalse = allExported.values().stream().anyMatch(x -> x.equals("false"));
        resultMap.put("url", this.uploadFile(dataFile));
        resultMap.put("totalData", totalData);
        resultMap.put("allExportedFlag", aFalse);
        return resultMap;
    }

    private File makeFileDir(String mergeFileName) {
        File dataFile;
        File dataFileDir = new File(FileUtils.getTempDirectory() + File.separator + "eaTemp" + File.separator);
        if (!dataFileDir.exists()) {
            try {
                FileUtils.forceMkdir((File)dataFileDir);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        if ((dataFile = new File(dataFileDir, String.format("%s.%s", mergeFileName, "txt"))).exists() && !dataFile.delete()) {
            log.error("file delete failed");
        }
        return dataFile;
    }

    private void clearTempFile(File tempDir) {
        try {
            FileUtils.forceDelete((File)tempDir);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String uploadFile(File dataFile) {
        InputStream is = null;
        String url = "";
        try {
            if (dataFile.exists()) {
                is = new FileInputStream(dataFile);
                url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(dataFile.getName(), is, 3600);
            }
        }
        catch (Exception e) {
            log.error("mergeFile\u751f\u6210\u6587\u4ef6\u62a5\u9519:" + e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            this.clearTempFile(dataFile);
        }
        return url;
    }

    private synchronized void saveTempFile(ByteArrayOutputStream out, File dataFile, String data, String topName) {
        FileOutputStream fileOutputStream = null;
        try {
            if (dataFile.exists()) {
                fileOutputStream = new FileOutputStream(dataFile, true);
            } else if (dataFile.createNewFile()) {
                fileOutputStream = new FileOutputStream(dataFile);
                fileOutputStream.write(topName.getBytes());
            } else {
                return;
            }
            out.write(data.getBytes());
            fileOutputStream.write(out.toByteArray());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void dealWithFileTop(StringBuilder sb, SQLBuilder sql, String separator) {
        ArrayList<String> fileTopList = new ArrayList<String>(10);
        HashMap map = Maps.newHashMap();
        map.put("Scenario", "Scenario");
        map.put("Year", "Year");
        map.put("Period", "Period");
        List pairList = sql.getFilters();
        StringBuilder dimFileSb = new StringBuilder();
        pairList.forEach(pair -> {
            if (map.containsKey(pair.p1)) {
                dimFileSb.append((String)pair.p1).append("=").append(Arrays.toString((Object[])pair.p2)).append(";");
            }
        });
        String dimFile = "#!" + dimFileSb.substring(0, dimFileSb.length() - 1);
        String tips = "!DATA!" + separator + '!' + Boolean.TRUE;
        fileTopList.add(tips);
        fileTopList.add(dimFile);
        EADataPushDownloadFile.dealWithSb(sb, fileTopList);
    }

    public static void dealWithSb(StringBuilder sb, List<String> fileContentList) {
        for (String fileContent : fileContentList) {
            sb.append(fileContent).append(enter);
        }
    }

    public Map<String, String> dealWithDataByProcess(SQLBuilder sql, Long modelId) {
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        List<Object> processList = new ArrayList(16);
        List processPairs = sql.getFilters().stream().filter(pair -> "Process".equalsIgnoreCase((String)pair.p1)).collect(Collectors.toList());
        if (processPairs == null || processPairs.size() == 0) {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            DynamicObjectCollection entityList = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"number", (QFilter[])new QFilter[]{filter});
            for (DynamicObject entity : entityList) {
                processList.add(entity.getString("number"));
            }
        } else {
            processList = Arrays.asList((Object[])((Pair)processPairs.get((int)0)).p2);
        }
        if ((processList = processList.stream().distinct().collect(Collectors.toList())).contains("EIRpt")) {
            dataMap.put("isContainsEIRpt", "1");
            Collections.replaceAll(processList, "EIRpt", "IRpt");
        }
        if (processList.contains("ERAdj")) {
            dataMap.put("isContainsERAdj", "1");
            Collections.replaceAll(processList, "ERAdj", "RAdj");
        }
        if (processPairs != null && processPairs.size() > 0) {
            processList = processList.stream().distinct().collect(Collectors.toList());
            sql.getFilters().removeIf(pair -> "Process".equalsIgnoreCase((String)pair.p1));
            sql.getFilters().add(new Pair((Object)"Process", (Object)processList.toArray(new String[0])));
        }
        log.info("queryDataByProcess\u8f93\u51fadataMap:" + ((Object)dataMap).toString());
        return dataMap;
    }

    private void transformSqlByECOrDC(SQLBuilder sql, Map<String, List<String>> DCCurrencyMap, Map<String, String> nodeCurrMap, String entity) {
        List currencyPairs = sql.getFilters().stream().filter(pair -> "Currency".equalsIgnoreCase((String)pair.p1)).collect(Collectors.toList());
        List<Object> currencyData = currencyPairs.size() == 0 ? new ArrayList() : Arrays.asList((Object[])((Pair)currencyPairs.get((int)0)).p2);
        ArrayList<String> currencyList = new ArrayList<String>(currencyData);
        if (currencyList.size() == 0 || !currencyList.contains("EC") && !currencyList.contains("DC")) {
            return;
        }
        if (currencyList.contains("EC")) {
            currencyList.add(nodeCurrMap.get(entity));
            log.info("\u7ec4\u7ec7:" + entity + "\u89e3\u6790\u51faEC:" + nodeCurrMap.get(entity));
        }
        if (currencyList.contains("DC")) {
            List<String> setDCData = DCCurrencyMap.get(entity);
            currencyList.addAll(setDCData);
            log.info("\u7ec4\u7ec7:" + entity + "\u89e3\u6790\u51faDC:" + setDCData);
        }
        List<String> dupCyList = currencyList.stream().distinct().collect(Collectors.toList());
        sql.getFilters().removeIf(pair -> "Currency".equalsIgnoreCase((String)pair.p1));
        sql.getFilters().add(new Pair((Object)"Currency", (Object)dupCyList.toArray(new String[0])));
    }

    private void feedBack(Counter counter) {
        String cont = counter.countType == 0 ? ResManager.loadKDString((String)"\u4e2a\u7ec4\u7ec7\u6570\u636e", (String)"EADataPushDBTask_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6761\u6570\u636e", (String)"EADataPushDBTask_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String desc = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5bfc\u6570\u4e1a\u52a1\uff0c\u5df2\u5bfc\u51fa%1$s%2$s\u3002", (String)"EADataPushDBTask_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), counter.completedCount, cont);
        this.feedbackProgress(100 * counter.completedCount / counter.total, desc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reckonCounter(Counter counter, ReentrantReadWriteLock.ReadLock r, ReentrantReadWriteLock.WriteLock w) {
        if (counter.countType == 1) {
            this.feedBack(counter);
        } else if (counter.countType == 0) {
            w.lock();
            try {
                ++counter.completedCount;
            }
            finally {
                w.unlock();
            }
            r.lock();
            try {
                this.feedBack(counter);
            }
            finally {
                r.unlock();
            }
        }
    }

    private static String getUrl(String fileName, InputStream io) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        RequestContext rc = RequestContext.getOrCreate();
        String tempFilePath = FileNameUtils.getExportFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (String)"cm", (String)UUID.randomUUID().toString(), (String)fileName);
        String url = service.upload(new FileItem(fileName, tempFilePath, io));
        return url;
    }

    private static class Counter {
        int total = 0;
        int completedCount = 0;
        int countType = 0;

        private Counter() {
        }
    }
}

