/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.adjust.report.AbstractAdjustBasePlugin;

public class EADataPushSchemBasePlugin
extends AbstractAdjustBasePlugin {
    private static final Log log = LogFactory.getLog(EADataPushSchemBasePlugin.class);
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static Pattern pattern = Pattern.compile("[A-Za-z0-9_]+");

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_ok");
    }

    @Override
    public void afterBindData(EventObject e) {
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        IDataModel model = this.getModel();
        if (customParams.get("schemename") != null) {
            String schemeName = customParams.get("schemename").toString();
            QFilter qFilter = new QFilter("name", "=", (Object)schemeName);
            DynamicObject dyObj = QueryServiceHelper.queryOne((String)"bcm_ea_datapushschemdata", (String)"id,name,number,model,applyscope,creator", (QFilter[])qFilter.toArray());
            if (dyObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5c1a\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u53e6\u5b58\u4e3a\u3002", (String)"EADataPushSchemBasePlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            model.setValue("description", dyObj.get("applyscope"));
            this.getPageCache().put("save_as", "1");
            this.getPageCache().put("creator", dyObj.get("creator").toString());
        }
        this.getPageCache().put("model", String.valueOf(customParams.get("model")));
        this.getPageCache().put("tablename", String.valueOf(customParams.get("tablename")));
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        IFormView view = this.getView();
        if (evt.getSource() instanceof Button) {
            if ("btn_ok".equals(((Button)evt.getSource()).getKey())) {
                if (!this.validate()) {
                    HashMap<String, Object> returnData = new HashMap<String, Object>(16);
                    IDataModel model = this.getModel();
                    returnData.put("number", model.getValue("number"));
                    returnData.put("name", model.getValue("name"));
                    returnData.put("applyscope", model.getValue("applyscope"));
                    returnData.put("description", model.getValue("description"));
                    returnData.put("tablename", this.getPageCache().get("tablename"));
                    String creator = this.getPageCache().get("creator");
                    if (null != creator && !"".equals(creator)) {
                        returnData.put("creator", creator);
                    }
                    view.returnDataToParent(returnData);
                    view.close();
                }
            } else {
                view.close();
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    private boolean validate() {
        DynamicObject dyObj = this.getModel().getDataEntity();
        String number = dyObj.getString("number");
        String name = dyObj.getString("name");
        StringBuilder msg = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)number) || StringUtils.isEmpty((CharSequence)number.trim())) {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7f16\u7801\u3002", (String)"EADataPushSchemBasePlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)name.trim())) {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0\u3002", (String)"EADataPushSchemBasePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (msg.length() > 0) {
            this.getView().showTipNotification(msg.toString());
            return true;
        }
        if (!this.formatYes(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u6570\u5b57\uff0c\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\u3002", (String)"EADataPushSchemBasePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return true;
        }
        QFilter filter1 = new QFilter("number", "=", (Object)number.trim());
        QFilter filter2 = new QFilter("name", "=", (Object)name);
        if (this.getPageCache().get("model") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5c1a\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u53e6\u5b58\u4e3a\u3002", (String)"EADataPushSchemBasePlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return true;
        }
        QFilter filter3 = new QFilter("model", "=", (Object)Long.valueOf(this.getPageCache().get("model")));
        if (QueryServiceHelper.exists((String)"bcm_ea_datapushschemdata", (QFilter[])new QFilter[]{filter1, filter3})) {
            msg.append(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\u3002", (String)"EADataPushSchemBasePlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (QueryServiceHelper.exists((String)"bcm_ea_datapushschemdata", (QFilter[])new QFilter[]{filter2, filter3})) {
            msg.append(ResManager.loadKDString((String)"\u540d\u79f0\u91cd\u590d\u3002", (String)"EADataPushSchemBasePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (msg.length() > 0) {
            this.getView().showTipNotification(msg.toString());
            return true;
        }
        return false;
    }

    private boolean formatYes(String number) {
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            return false;
        }
        return !number.contains("..") && !number.startsWith(".");
    }
}

