/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class EaDataPushSchemQueryListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(EaDataPushSchemQueryListPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"btn_delete", "btn_confirm"});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String modelId = this.getPageCache().get("modelId");
        if (StringUtils.isNotEmpty((CharSequence)modelId)) {
            QFilter qcf4Model = new QFilter("model", "=", (Object)Long.parseLong(modelId));
            e.getQFilters().add(qcf4Model);
        } else {
            QFilter none = new QFilter("1", "=", (Object)"0");
            e.getQFilters().add(none);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String modelId = customParams.get("modelId").toString();
        this.getPageCache().put("modelId", modelId);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("model".equals(e.getProperty().getName())) {
            String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
            if (modelId != null) {
                if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                this.getPageCache().put("KEY_MODEL_ID", modelId);
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
            } else {
                this.getModel().setValue("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectModels = billList.getSelectedRows();
        if (0 < selectModels.size()) {
            Object permId = selectModels.get(0).getPrimaryKeyValue();
            if ("btn_delete".equals(itemKey)) {
                Long id = Long.parseLong(permId.toString());
                String msg = this.validateScheme(id);
                if (StringUtils.isNotEmpty((CharSequence)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                QFilter filter = new QFilter("id", "=", (Object)id);
                DeleteServiceHelper.delete((String)"bcm_ea_datapushschemdata", (QFilter[])new QFilter[]{filter});
                billList.clearSelection();
                billList.refresh();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5220\u9664\u6210\u529f\u3002", (String)"EaDataPushSchemQueryListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else if ("btn_confirm".equals(itemKey)) {
                this.doConfirm(Long.parseLong(permId.toString()));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"EaDataPushSchemQueryListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private String validateScheme(long id) {
        long originId;
        Object schemeId = this.getView().getFormShowParameter().getCustomParam("schemeId");
        if (schemeId != null && id == (originId = Long.parseLong(schemeId.toString()))) {
            return ResManager.loadKDString((String)"\u5e94\u7528\u4e2d\u7684\u65b9\u6848\u4e0d\u53ef\u5220\u9664\u3002", (String)"EaDataPushSchemQueryListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        QFilter qf = new QFilter("datapushscheme", "=", (Object)id);
        if (QueryServiceHelper.exists((String)"bcm_dspparamentity", (QFilter[])qf.toArray())) {
            return ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u7ecf\u88ab\u667a\u80fd\u8c03\u5ea6\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01", (String)"EaDataPushSchemQueryListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Long selectId = (Long)((BillList)args.getHyperLinkClickEvent().getSource()).getSelectedRows().getPrimaryKeyValues()[0];
        this.doConfirm(selectId);
    }

    private void doConfirm(Long selectId) {
        QFilter qFilter = new QFilter("id", "=", (Object)selectId);
        DynamicObject dyObj = QueryServiceHelper.queryOne((String)"bcm_ea_datapushschemdata", (String)"id,name,number,model,applyscope,description,creator,tablename,exprtype,isextractdata,iscontaindydata,iscontaintitle,separator", (QFilter[])qFilter.toArray());
        IFormView view = this.getView();
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        returnData.put("schemeId", String.valueOf(selectId));
        returnData.put("schemeName", dyObj.getString("name"));
        returnData.put("schemeNumber", dyObj.getString("number"));
        returnData.put("schemeModel", dyObj.getString("model"));
        returnData.put("schemeApplyScope", dyObj.getString("applyscope"));
        returnData.put("schemeDescription", dyObj.getString("description"));
        returnData.put("schemeCreator", dyObj.getString("creator"));
        returnData.put("relattableprefix", dyObj.getString("tablename"));
        returnData.put("exprtype", dyObj.getString("exprtype"));
        returnData.put("isextractdata", dyObj.getString("isextractdata"));
        returnData.put("iscontaindydata", dyObj.getString("iscontaindydata"));
        returnData.put("iscontaintitle", dyObj.getString("iscontaintitle"));
        returnData.put("separator", dyObj.getString("separator"));
        view.returnDataToParent(returnData);
        view.close();
    }
}

