/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.time.LocalDate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class EasMemberMapExportPlugin
extends AbstractBaseFormPlugin {
    public String export(String routeAppId, String formId, Long modelId, Object[] ids, Long template) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        ExportWriterFormat format = ExportUtil.getExportWriterFormatAndWriteHead((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (String)routeAppId, (Object)formId, (Object)template, (Object)formId);
        if (format == null) {
            return null;
        }
        int rowIndex = 4;
        DynamicObject[] arrDimMapping = BusinessDataServiceHelper.load((String)formId, (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)formId).getAllFields().keySet()), (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        String json = SerializationUtils.toJsonString((Object)arrDimMapping);
        JSONArray billArr = JSONArray.parseArray((String)json);
        String fileName = this.genFileName(template, formId, "");
        try (TraceSpan span = Tracer.create((String)"bcmexport", (String)"export");){
            for (int i = 0; i < billArr.size(); ++i) {
                JSONObject bill = billArr.getJSONObject(i);
                int offset = ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (JSONObject)bill, (int)rowIndex, (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
                if (offset > 1) {
                    rowIndex += offset;
                    continue;
                }
                ++rowIndex;
            }
        }
        return ExportUtil.writeFile((SXSSFWorkbook)wb, (String)fileName);
    }

    private String genFileName(Long template, String billFormId, String fileNamePrefix) {
        String fileName = fileNamePrefix;
        DynamicObject templateData = null;
        if (template > 0L) {
            templateData = BusinessDataServiceHelper.loadSingle((Object)template, (String)"bos_importtemplate");
        }
        if (templateData != null) {
            fileName = fileName + templateData.get("name");
        } else {
            BillEntityType listEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
            fileName = fileName + listEntityType.getDisplayName();
        }
        LocalDate now = LocalDate.now();
        fileName = fileName + String.format("_%02d%02d", now.getMonthValue(), now.getDayOfMonth()) + ".xlsx";
        return fileName;
    }
}

