/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.dimension.data.MemberMsgCache;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class EasMemberMapImportPlugin
extends AbstractBaseFormPlugin
implements IImportPlugin {
    private Long modelId = 0L;
    private DynamicObject createData;

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        return this.invalidate(data, importlogs);
    }

    private boolean invalidate(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        try {
            JSONObject modelJson = (JSONObject)data.get("model");
            if (modelJson == null || modelJson.isEmpty()) {
                String msg = ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EasMemberMapImportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                importlogs.add(new ImportLogger.ImportLog(msg));
                return false;
            }
            String modelNumber = (String)modelJson.get((Object)"shownumber");
            DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id", (QFilter[])new QFilter("shownumber", "=", (Object)modelNumber).toArray());
            if (model == null) {
                String msg = ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"EasMemberMapImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                importlogs.add(new ImportLogger.ImportLog(msg));
                return false;
            }
            this.modelId = model.getLong("id");
            ThreadCache.put((Object)"getModelId", (Object)this.modelId);
            QFilter modelQfilter = new QFilter("model", "=", (Object)this.modelId);
            QFilter dimNumQfilter = new QFilter("number", "=", data.get("dimensionnumber"));
            DynamicObject dimensionDyn = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id,number,membermodel", (QFilter[])new QFilter[]{modelQfilter, dimNumQfilter});
            if (dimensionDyn == null) {
                String msg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"EasMemberMapImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                importlogs.add(new ImportLogger.ImportLog(msg));
                return false;
            }
            QFilter memberNumQfilter = new QFilter("number", "in", (Object)new String[]{data.get("parentnumber").toString().trim(), data.get("membernumber").toString().trim()});
            DynamicObjectCollection memberDyn = QueryServiceHelper.query((String)dimensionDyn.getString("membermodel"), (String)"id,number", (QFilter[])new QFilter[]{modelQfilter, memberNumQfilter});
            if (memberDyn == null || memberDyn.size() < 2) {
                String msg = ResManager.loadKDString((String)"\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"EasMemberMapImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                importlogs.add(new ImportLogger.ImportLog(msg));
                return false;
            }
            QFilter tmplNumQfilter = new QFilter("number", "=", data.get("tmpnumber"));
            DynamicObjectCollection tmplDyn = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{modelQfilter, tmplNumQfilter});
            if (tmplDyn == null || tmplDyn.size() == 0) {
                String msg = ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"EasMemberMapImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                importlogs.add(new ImportLogger.ImportLog(msg));
                return false;
            }
            return true;
        }
        catch (NullPointerException e) {
            log.error("EasMemberMapImportPlugin :", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570parentnumber,membernumber\u53ef\u80fd\u6ca1\u586b\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u7684\u6587\u4ef6\u3002", (String)"EasMemberMapImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            importlogs.add(new ImportLogger.ImportLog(msg));
            return false;
        }
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        String action;
        switch (action = (String)option.get("importtype")) {
            case "overridenew": {
                return this.overridenew(data, option, importlogs);
            }
            case "override": {
                return this.override(data, option, importlogs);
            }
            case "new": {
                return this.addNew(data, option, importlogs);
            }
        }
        return new ArrayList<Object>();
    }

    private List<Object> addNew(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        ArrayList<Object> success = new ArrayList<Object>();
        DynamicObjectCollection temp = QueryServiceHelper.query((String)"bcm_easmembermap", (String)"id", (QFilter[])this.getUniqueFilters(data));
        try (TXHandle tx = TX.required();){
            if (temp == null || temp.isEmpty()) {
                DynamicObject newDyn = this.buildDyn(data, option, importlogs, false);
                DynamicObject[] sucessIds = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDyn});
                success.add(sucessIds[0].get("id"));
            } else {
                String msg = ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"EasMemberMapImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                importlogs.add(new ImportLogger.ImportLog(msg));
            }
        }
        catch (Exception e) {
            importlogs.add(new ImportLogger.ImportLog(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20)));
        }
        this.writeMultiLangLogWithEntityNumber("bcm_easmembermap", new OpNameMultiLangEnumBridge("\u5bfc\u5165", "EasMemberMapImportPlugin_7", "fi-bcm-formplugin", "addNew"), new OPDescMultiLangEnumBridge("\u4f53\u7cfb", "EasMemberMapImportPlugin_8", "fi-bcm-formplugin"));
        return success;
    }

    private List<Object> override(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        ArrayList<Object> success;
        block15: {
            success = new ArrayList<Object>();
            try (TXHandle tx = TX.required();){
                try {
                    if (this.deleteRepeatData(data)) {
                        DynamicObject newDyn = this.buildDyn(data, option, importlogs, true);
                        DynamicObject[] sucessIds = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDyn});
                        success.add(sucessIds[0].get("id"));
                        break block15;
                    }
                    String msg = ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8986\u76d6\u5931\u8d25\u3002", (String)"EasMemberMapImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    importlogs.add(new ImportLogger.ImportLog(msg));
                }
                catch (Exception e) {
                    importlogs.add(new ImportLogger.ImportLog(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20)));
                    tx.markRollback();
                }
            }
        }
        this.writeMultiLangLogWithEntityNumber("bcm_easmembermap", new OpNameMultiLangEnumBridge("\u5bfc\u5165", "EasMemberMapImportPlugin_7", "fi-bcm-formplugin", "override"), new OPDescMultiLangEnumBridge("\u4f53\u7cfb", "EasMemberMapImportPlugin_8", "fi-bcm-formplugin"));
        return success;
    }

    public boolean deleteRepeatData(Map<String, Object> data) {
        QFilter[] filters = this.getUniqueFilters(data);
        this.createData = BusinessDataServiceHelper.loadSingle((String)"bcm_easmembermap", (String)"id,creator,createtime", (QFilter[])filters);
        if (this.createData != null) {
            DeleteServiceHelper.delete((String)"bcm_easmembermap", (QFilter[])filters);
            return true;
        }
        return false;
    }

    private List<Object> overridenew(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        ArrayList<Object> success = new ArrayList<Object>();
        try (TXHandle tx = TX.required();){
            try {
                boolean isModify = this.deleteRepeatData(data);
                DynamicObject newDyn = this.buildDyn(data, option, importlogs, isModify);
                DynamicObject[] sucessIds = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDyn});
                success.add(sucessIds[0].get("id"));
            }
            catch (Exception e) {
                importlogs.add(new ImportLogger.ImportLog(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)20)));
                tx.markRollback();
            }
        }
        this.writeMultiLangLogWithEntityNumber("bcm_easmembermap", new OpNameMultiLangEnumBridge("\u5bfc\u5165", "EasMemberMapImportPlugin_7", "fi-bcm-formplugin", "overridenew"), new OPDescMultiLangEnumBridge("\u4f53\u7cfb", "EasMemberMapImportPlugin_8", "fi-bcm-formplugin"));
        return success;
    }

    private DynamicObject buildDyn(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs, boolean isModify) {
        String dimnum = data.get("dimensionnumber").toString().trim();
        DimensionMsgCache dim = new DimensionMsgCache(this.modelId.longValue());
        MemberMsgCache members = new MemberMsgCache(this.modelId.longValue());
        members.setSelectfiled(dimnum, "id,name");
        members.setFilter(dimnum, "number", data.get("membernumber"));
        members.setFilter(dimnum, "number", data.get("parentnumber"));
        DynamicObject dyn = this.createData == null ? BusinessDataServiceHelper.newDynamicObject((String)"bcm_easmembermap") : this.createData;
        dyn.set("model", (Object)this.modelId);
        dyn.set("easname", (Object)data.get("easname").toString().trim());
        dyn.set("membernumber", data.get("membernumber"));
        dyn.set("dimensionnumber", data.get("dimensionnumber"));
        dyn.set("parentnumber", data.get("parentnumber"));
        dyn.set("tmpnumber", data.get("tmpnumber"));
        dyn.set("tmpname", data.get("tmpname"));
        dyn.set("dimensionname", (Object)dim.getName(data.get("dimensionnumber").toString()));
        dyn.set("membername", members.getMsg(dimnum, data.get("membernumber").toString(), "name"));
        dyn.set("dimension", (Object)dim.getDimId(dimnum));
        dyn.set("floatarea", data.get("floatarea"));
        if (data.get("parentnumber") != null) {
            dyn.set("parentid", members.getMsg(dimnum, data.get("parentnumber").toString(), "id"));
            dyn.set("parentname", members.getMsg(dimnum, data.get("parentnumber").toString(), "name"));
        }
        dyn.set("tmplid", (Object)this.getTmlpid(data.get("tmpnumber").toString(), data.get("tmplid")));
        dyn.set("memberid", members.getMsg(dimnum, data.get("membernumber").toString(), "id"));
        dyn.set("modifytime", (Object)TimeServiceHelper.now());
        dyn.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
        if (!isModify) {
            dyn.set("createtime", (Object)TimeServiceHelper.now());
            dyn.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        }
        return dyn;
    }

    private Long getTmlpid(String tmplnumber, Object tmpid) {
        if (tmpid != null && Long.parseLong(tmpid.toString()) != 0L && QueryServiceHelper.exists((String)"bcm_templateentity", (Object)tmpid)) {
            return Long.parseLong(tmpid.toString());
        }
        DynamicObjectCollection tmps = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,versionnumber", (QFilter[])new QFilter[]{QFilter.of((String)"model=?", (Object[])new Object[]{this.modelId}), new QFilter("number", "=", (Object)tmplnumber)}, (String)"versionnumber desc");
        return ((DynamicObject)tmps.stream().findFirst().get()).getLong("id");
    }

    private QFilter[] getUniqueFilters(Map<String, Object> data) {
        QFilter modelFilter = new QFilter("model", "=", (Object)this.modelId);
        String easname = data.get("easname").toString().trim();
        String dimensionnumber = data.get("dimensionnumber").toString().trim();
        String tmpnumber = data.get("tmpnumber").toString().trim();
        String parentnumber = data.get("parentnumber").toString().trim();
        QFilter nameQf = new QFilter("easname", "=", (Object)easname).and("dimensionnumber", "=", (Object)dimensionnumber).and("tmpnumber", "=", (Object)tmpnumber).and("parentnumber", "=", (Object)parentnumber);
        return new QFilter[]{modelFilter, nameQf};
    }
}

