/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.dimension.data.MemberMsgCache;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.intergration.EasMemberMapExportPlugin;

public class EasMemberMapListPlugin
extends AbstractBaseListPlugin {
    private static final String EASMAPPINGEDIT = "easmappingedit";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter model = new QFilter("model", "=", (Object)this.getModelId());
        e.getQFilters().add(model);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String opkey = evt.getItemKey();
        if ("bar_update".equals(opkey)) {
            long memberid;
            long parentid;
            String dimnumber;
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bcm_easmembermap", (String)"memberid,membername,dimensionnumber,dimensionname,parentid,parentname", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())});
            DimensionMsgCache dim = new DimensionMsgCache(this.getModelId());
            MemberMsgCache mems = new MemberMsgCache(this.getModelId());
            mems.setIdAsKey(true);
            for (DynamicObject obj : objs) {
                dimnumber = obj.getString("dimensionnumber");
                parentid = obj.getLong("parentid");
                memberid = obj.getLong("memberid");
                mems.setSelectfiled(dimnumber, "id,name");
                mems.setFilter(dimnumber, "id", (Object)parentid);
                mems.setFilter(dimnumber, "id", (Object)memberid);
            }
            for (DynamicObject obj : objs) {
                dimnumber = obj.getString("dimensionnumber");
                parentid = obj.getLong("parentid");
                memberid = obj.getLong("memberid");
                obj.set("membername", mems.getMsg(dimnumber, memberid, "name"));
                obj.set("parentname", mems.getMsg(dimnumber, parentid, "name"));
                obj.set("dimensionname", (Object)dim.getName(dimnumber));
            }
            SaveServiceHelper.save((DynamicObject[])objs);
            BillList bl = (BillList)this.getControl("billlistap");
            bl.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u5b8c\u6210\u3002", (String)"EasMemberMapListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
        }
        if ("bar_reflesh".equals(opkey)) {
            BillList bl = (BillList)this.getControl("billlistap");
            bl.refresh();
        }
        if ("bar_edit".equals(opkey)) {
            this.showEditMappingForm();
        }
        if ("btn_export".equals(opkey)) {
            this.barexport();
        }
    }

    private void barexport() {
        if (this.getSelectMap() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u6210\u5458\u6620\u5c04\u3002", (String)"EasMemberMapListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.exportMapping(this.getSelectMap());
    }

    private void exportMapping(Object[] selectMapIds) {
        long modelId = this.getModelId();
        QFilter[] filters = new QFilter[]{new QFilter("bizobject.number", "=", (Object)"bcm_easmembermap"), new QFilter("templatetype", "=", (Object)"IMPT").or(new QFilter("templatetype", "is null", null))};
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])filters, (String)"", (int)2);
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            EasMemberMapExportPlugin exportor = new EasMemberMapExportPlugin();
            String url = exportor.export(routeAppId, "bcm_easmembermap", modelId, selectMapIds, (Long)pkIds.get(0));
            this.downloadFile(url, "bcm_isschemelist", "4715a0df000000ac");
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"IO\u5f02\u5e38\u3002", (String)"EasMemberMapListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private Object[] getSelectMap() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        this.getModel().getDataEntity();
        if (rows.size() > 0) {
            return rows.getPrimaryKeyValues();
        }
        return null;
    }

    private void showEditMappingForm() {
        BillList bl = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = bl.getSelectedRows();
        if (list.size() <= 0) {
            this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u884c\u3002", (String)"EasMemberMapListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (String)"EasMemberMapListPlugin_1"));
            return;
        }
        Object[] rows = list.getPrimaryKeyValues();
        IFormView mainPageView = this.getView().getMainView();
        String pageId = "easmapsetting" + mainPageView.getPageId();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_easmapsetting");
        parameter.setCustomParam("rows", (Object)rows);
        parameter.setPageId(pageId);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EASMAPPINGEDIT));
        IFormView appPageView = this.getView().getParentView();
        appPageView.showForm(parameter);
        this.getView().sendFormAction(appPageView);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (EASMAPPINGEDIT.equals(actionId)) {
            BillList bl = (BillList)this.getControl("billlistap");
            bl.refresh();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Boolean success = Boolean.FALSE;
        OperationResult operationResult = e.getOperationResult();
        if (e.getOperationResult() != null) {
            success = operationResult.isSuccess();
        }
        if ("delete".equalsIgnoreCase(e.getOperateKey()) && success.booleanValue()) {
            this.writeLogWithEntityNumber("bcm_easmembermap", new OpNameMultiLangEnumBridge("\u5220\u9664", "EasMemberMapListPlugin_4", "fi-bcm-formplugin", "delete"), new OPDescMultiLangEnumBridge("\u4f53\u7cfb", "EasMemberMapListPlugin_5", "fi-bcm-formplugin", null));
        }
    }
}

