/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.dimension.data.MemberMsgCache;
import kd.fi.bcm.business.dimension.data.MemberNumToIdCache;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.CommonSqlMsgUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.MembAddPositionEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.util.WriteExcelUtil;
import kd.fi.bcm.formplugin.report.floatreport.FloatLogicImpl;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.util.DynamicUtils;

public class EasMemberMapPlugin
extends AbstractBaseFormPlugin {
    private String ENTRYENTITY = "entryentity";
    private DimensionMsgCache dim;
    private MemberNumToIdCache nameids;
    private Map<String, SpreadManager> sms;
    private Table<Long, Long, Long> shareList;
    private Map<String, Long> parentidmap = new HashMap<String, Long>();

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_ok");
        ItemClassEdit f7 = (ItemClassEdit)this.getControl("member");
        ItemClassEdit parent = (ItemClassEdit)this.getControl("parent");
        f7.addBeforeF7SelectListener(this::beforeMemberF7);
        parent.addBeforeF7SelectListener(this::beforeMemberF7);
        BasedataEdit bs = (BasedataEdit)this.getControl("dimension");
        BasedataEdit tmp = (BasedataEdit)this.getControl("tmp");
        bs.addBeforeF7SelectListener(this::modelFilter);
        tmp.addBeforeF7SelectListener(this::modelFilter);
        this.addItemClickListeners("advcontoolbarap");
    }

    private void beforeMemberF7(BeforeF7SelectEvent beforeF7SelectEvent) {
        int[] selects = ((EntryGrid)this.getControl(this.ENTRYENTITY)).getSelectRows();
        if (selects.length == 0) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("dimension", "=", ((DynamicObject)this.getModel().getValue("dimension", beforeF7SelectEvent.getRow())).get("id")));
        DynamicObject obj = this.getModel().getEntryEntity(this.ENTRYENTITY, selects[0], selects[0] + 1)[0];
        String dim = obj.getString("dimension.number");
        String floatarea = obj.getString("floatarea");
        String tmp = obj.getString("tmp.id");
        if (tmp != null) {
            TemplateModel template = TemplateUtil.getTempModel((Object)tmp);
            SpreadManager tsm = JsonSerializerUtil.toSpreadManager((String)template.getRptData());
            qFilterList.add(this.getFilter(tsm, floatarea, dim));
        }
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    private void modelFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int row = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "dimension": {
                String number = ((DynamicObject)e.getChangeSet()[0].getNewValue()).getString("number");
                this.getModel().setValue("dimtype", (Object)DimEntityNumEnum.getEntieyNumByNumber((String)number), row);
                break;
            }
            case "isadd": {
                if (!Boolean.parseBoolean(e.getChangeSet()[0].getNewValue().toString())) break;
                this.getModel().setValue("member", null, row);
                break;
            }
            case "member": {
                this.getModel().setValue("isadd", (Object)false, row);
                this.getModel().setValue("shareparent", null, row);
                break;
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getFormCustomParam("rows") != null) {
            Object[] ids = ((JSONArray)this.getFormCustomParam("rows")).toArray();
            this.loadData(ids);
        } else {
            String modelid = (String)this.getFormCustomParam("modelid");
            if (StringUtils.isEmpty((String)modelid)) {
                return;
            }
            DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(modelid), (String)"bcm_model", (String)"number");
            String modelNum = model.getString("number");
            this.getPageCache().put("KEY_MODEL_ID", modelid);
            this.dim = new DimensionMsgCache(this.getModelId());
            this.nameids = new MemberNumToIdCache(this.getModelId());
            this.nameids.setNeedStoragetype(true);
            this.nameids.setCustomkey("name");
            List<Map<String, String>> msg = this.getMsg();
            if (msg.size() == 0) {
                return;
            }
            this.getModel().batchCreateNewEntryRow(this.ENTRYENTITY, msg.size());
            Map<String, Long> tmpmap = this.getTmpMap(msg);
            this.cacheSm(tmpmap);
            Map<String, Long> idmap = this.autoMatchMember(msg);
            int i = 0;
            for (Map<String, String> map : msg) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"tmp", "easname", "dimension", "org"});
                String name = map.get("easname");
                this.getModel().setValue("easname", (Object)name, i);
                String dimnumber = map.get("dimnumer");
                String tmpnumber = map.get("tempnumber");
                String floatarea = map.get("floatarea");
                String orgNum = map.get("org");
                this.getModel().setValue("dimension", (Object)this.dim.getDimId(dimnumber), i);
                this.getModel().setValue("tmp", (Object)tmpmap.get(tmpnumber), i);
                this.getModel().setValue("dimtype", (Object)DimEntityNumEnum.getEntieyNumByNumber((String)dimnumber), i);
                this.getModel().setValue("floatarea", (Object)floatarea, i);
                IDNumberTreeNode m = MemberReader.findMemberByNumber((String)modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (String)orgNum);
                this.getModel().setValue("org", (Object)m.getName(), i);
                long parentid = this.getParent(tmpnumber, floatarea, dimnumber);
                if (idmap.get(dimnumber + name) != null) {
                    long mapmemid = idmap.get(dimnumber + name);
                    if (parentid != 0L) {
                        this.getModel().setValue("parent", (Object)parentid, i);
                    }
                    this.getModel().setValue("member", (Object)mapmemid, i);
                    this.getModel().setValue("isadd", (Object)false, i);
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"isadd", "parent"});
                    if (this.getShareList().get((Object)mapmemid, (Object)parentid) != null) {
                        this.getModel().setValue("shareparent", (Object)parentid, i);
                    }
                } else if (parentid != 0L) {
                    this.getModel().setValue("parent", (Object)parentid, i);
                    this.getModel().setValue("isadd", (Object)true, i);
                } else {
                    this.getModel().setValue("isadd", (Object)false, i);
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"isadd", "parent"});
                }
                ++i;
            }
        }
    }

    private void loadData(Object[] ids) {
        DynamicObject[] docs = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_easmembermap"));
        List mappingList = Arrays.stream(docs).collect(Collectors.toList());
        if (mappingList.size() > 0) {
            this.getModel().batchCreateNewEntryRow(this.ENTRYENTITY, mappingList.size());
            int index = 0;
            for (DynamicObject mapping : mappingList) {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"tmp", "easname", "dimension"});
                this.getModel().getEntryRowEntity("entryentity", index).set("id", (Object)mapping.getLong("id"));
                this.getModel().setValue("easname", (Object)mapping.getString("easname"), index);
                this.getModel().setValue("dimension", (Object)mapping.getLong("dimension"), index);
                this.getModel().setValue("tmp", (Object)mapping.getLong("tmplid"), index);
                this.getModel().setValue("floatarea", (Object)mapping.getString("floatarea"), index);
                this.getModel().setValue("dimtype", (Object)DimEntityNumEnum.getEntieyNumByNumber((String)mapping.getString("dimensionnumber")), index);
                this.getModel().setValue("member", (Object)mapping.getLong("memberid"), index);
                this.getModel().setValue("parent", (Object)mapping.getLong("parentid"), index);
                this.getModel().setValue("isadd", (Object)false, index);
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"isadd", "parent"});
                ++index;
            }
        }
    }

    private Map<String, Long> getTmpMap(List<Map<String, String>> msg) {
        ArrayList<String> tmpnumbers = new ArrayList<String>(10);
        for (Map<String, String> map : msg) {
            String tmpnumber = map.get("tempnumber");
            tmpnumbers.add(tmpnumber);
        }
        Map tmps = BusinessDataServiceHelper.loadFromCache((String)"bcm_templateentity", (String)"id,number", (QFilter[])new QFilter[]{QFilter.of((String)"model=?", (Object[])new Object[]{this.getModelId()}), new QFilter("number", "in", tmpnumbers)});
        HashMap<String, Long> tmpmap = new HashMap<String, Long>(16);
        HashSet<Long> templateIds = new HashSet<Long>(16);
        for (DynamicObject o : tmps.values()) {
            if (tmpmap.containsKey(o.getString("number"))) continue;
            tmpmap.put(o.getString("number"), o.getLong("id"));
            templateIds.add(o.getLong("id"));
        }
        Map rightTmpIds = TemplateUtil.getRightTplIdByVersioned((Long)this.getModelId(), (Long)this.getYearid(), (Long)this.getPeriodid(), templateIds);
        tmpmap.replaceAll((k, v) -> (Long)rightTmpIds.get(v));
        return tmpmap;
    }

    private long getYearid() {
        Object y = this.getFormCustomParam("year");
        return Long.parseLong(y.toString());
    }

    private long getPeriodid() {
        Object y = this.getFormCustomParam("period");
        return Long.parseLong(y.toString());
    }

    private void cacheSm(Map<String, Long> tmpmap) {
        ArrayList<String> error = new ArrayList<String>(10);
        this.sms = new HashMap<String, SpreadManager>();
        for (Map.Entry<String, Long> entry : tmpmap.entrySet()) {
            String tmpnum = entry.getKey();
            try {
                TemplateModel template = TemplateUtil.getTempModel((Object)entry.getValue());
                SpreadManager tsm = JsonSerializerUtil.toSpreadManager((String)template.getRptData());
                this.sms.put(tmpnum, tsm);
            }
            catch (Exception e) {
                error.add(tmpnum);
            }
        }
        if (error.size() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u8df3\u8fc7\u5b58\u5728\u95ee\u9898\u7684\u6a21\u677f\uff1a%s\u3002", (String)"EasMemberMapPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), error));
        }
    }

    private SpreadManager getSm(String tmpnum) {
        return this.sms.get(tmpnum);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_ok".equals(key)) {
            this.dim = new DimensionMsgCache(this.getModelId());
            DynamicObjectCollection doc = this.getModel().getEntryEntity(this.ENTRYENTITY);
            HashMultimap needToAddmap = HashMultimap.create();
            ArrayList<DynamicObject> easmembermap = new ArrayList<DynamicObject>();
            HashMap<Pair, Pair> tmpAndFloatMap = new HashMap<Pair, Pair>();
            int i = 0;
            int[] selects = ((EntryGrid)this.getControl(this.ENTRYENTITY)).getSelectRows();
            HashSet<String> easName4OpLog = new HashSet<String>(selects.length);
            for (int select : selects) {
                i = select + 1;
                DynamicObject obj2 = (DynamicObject)doc.get(select);
                boolean isadd = obj2.getBoolean("isadd");
                if (obj2.getDynamicObject("dimension") == null) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b2c%s\u884c\u7ef4\u5ea6\u3002", (String)"EasMemberMapPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i));
                    return;
                }
                String dimension = obj2.getDynamicObject("dimension").getString("number");
                String easname = obj2.getString("easname");
                if (StringUtils.isEmpty((String)easname)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%S\u884ceas\u540d\u79f0\u3002", (String)"EasMemberMapPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i));
                    return;
                }
                easName4OpLog.add(easname);
                if (isadd) {
                    if (obj2.getDynamicObject("parent") == null) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b2c%s\u884c\u4e0a\u7ea7\u6210\u5458\u3002", (String)"EasMemberMapPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i));
                        return;
                    }
                    this.needAdd((Multimap<String, DynamicObject>)needToAddmap, dimension, obj2);
                    Long parentid = obj2.getDynamicObject("parent").getLong("id");
                    String floatarea = obj2.getString("floatarea");
                    tmpAndFloatMap.put(Pair.onePair((Object)easname, (Object)parentid), Pair.onePair((Object)floatarea, (Object)obj2.getDynamicObject("tmp")));
                    continue;
                }
                long mapmemberId = obj2.getLong("member.id");
                long shareparent = obj2.getLong("shareparent.id");
                if (shareparent != 0L) {
                    long shareMemberId = (Long)this.getShareList().get((Object)mapmemberId, (Object)shareparent);
                    if (shareMemberId == 0L) {
                        shareMemberId = GlobalIdUtil.genGlobalLongId();
                        this.getShareList().put((Object)mapmemberId, (Object)shareparent, (Object)shareMemberId);
                    }
                    mapmemberId = shareMemberId;
                }
                if (mapmemberId == 0L) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b2c%s\u884c\u6210\u5458\u3002", (String)"EasMemberMapPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i));
                    return;
                }
                DynamicObject easmap = obj2.getLong("id") == 0L ? BusinessDataServiceHelper.newDynamicObject((String)"bcm_easmembermap") : BusinessDataServiceHelper.loadSingle((Object)obj2.getLong("id"), (String)"bcm_easmembermap");
                easmap.set("easname", (Object)easname);
                easmap.set("memberid", (Object)mapmemberId);
                easmap.set("membernumber", (Object)obj2.getDynamicObject("member").getString("number"));
                if (obj2.getDynamicObject("tmp") != null) {
                    easmap.set("tmplid", (Object)obj2.getDynamicObject("tmp").getLong("id"));
                    easmap.set("tmpnumber", (Object)obj2.getDynamicObject("tmp").getString("number"));
                    easmap.set("tmpname", (Object)obj2.getDynamicObject("tmp").getString("name"));
                }
                easmap.set("dimension", (Object)obj2.getDynamicObject("dimension").getString("id"));
                easmap.set("dimensionnumber", (Object)obj2.getDynamicObject("dimension").getString("number"));
                easmap.set("model", (Object)this.getModelId());
                easmap.set("membername", (Object)obj2.getDynamicObject("member").getString("name"));
                easmap.set("dimensionname", (Object)obj2.getDynamicObject("dimension").getString("name"));
                if (obj2.getDynamicObject("parent") != null) {
                    easmap.set("parentid", (Object)obj2.getDynamicObject("parent").getLong("id"));
                    easmap.set("parentnumber", (Object)obj2.getDynamicObject("parent").getString("number"));
                    easmap.set("parentname", (Object)obj2.getDynamicObject("parent").getString("name"));
                }
                easmap.set("floatarea", (Object)obj2.getString("floatarea"));
                CommonSqlMsgUtil.create((DynamicObject)easmap);
                easmembermap.add(easmap);
            }
            try (TXHandle tx = TX.required((String)"bcm_easmembermapp_save");){
                try {
                    Multimap<String, DynamicObject> treemembers = this.saveMember((Multimap<String, DynamicObject>)needToAddmap);
                    this.dealSharMemAfterSave(treemembers);
                    treemembers.values().forEach(obj -> this.setEasMemberMap((DynamicObject)obj, (List<DynamicObject>)easmembermap, (Map<Pair<String, Long>, Pair<String, DynamicObject>>)tmpAndFloatMap));
                    SaveServiceHelper.save((DynamicObject[])easmembermap.toArray(new DynamicObject[0]));
                    this.saveShareMember();
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
            this.getModel().deleteEntryRows(this.ENTRYENTITY, selects);
            this.writeMultiLangLogWithEntityNumber("bcm_easmembermap", new OpNameMultiLangEnumBridge("\u4fee\u6539", "EasMemberMapPlugin_19", "fi-bcm-formplugin", "modify"), new OPDescMultiLangEnumBridge("\u4f53\u7cfb\u4fee\u6539\u6210\u529f\u3002EAS\u6210\u5458\u540d\u79f0\uff1a%s\u3002", "EasMemberMapPlugin_20", "fi-bcm-formplugin", new String[]{((Object)easName4OpLog).toString()}));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"EasMemberMapPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void dealSharMemAfterSave(Multimap<String, DynamicObject> treemembers) {
        if (treemembers.size() > 0) {
            for (String dim : treemembers.keySet()) {
                Collection dynamicObjects = treemembers.get((Object)dim);
                for (DynamicObject memObj : dynamicObjects) {
                    DynamicObject parent = memObj.getDynamicObject("parent");
                    if (parent == null) continue;
                    QFilter filter1 = new QFilter("model", "=", (Object)this.getModelId());
                    QFilter filter2 = new QFilter("storagetype", "=", (Object)StorageTypeEnum.SHARE.getOIndex());
                    QFilter filter3 = new QFilter("number", "=", (Object)parent.getString("number"));
                    QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
                    DynamicObject shareParentObj = QueryServiceHelper.queryOne((String)memObj.getDynamicObjectType().getName(), (String)"id,parent,member", (QFilter[])filters);
                    if (shareParentObj == null) continue;
                    long mapmemberId = memObj.getLong("id");
                    long shareparentId = shareParentObj.getLong("id");
                    long shareMemberId = GlobalIdUtil.genGlobalLongId();
                    this.getShareList().put((Object)mapmemberId, (Object)shareparentId, (Object)shareMemberId);
                }
            }
        }
    }

    private void setEasMemberMap(DynamicObject obj, List<DynamicObject> easmembermap, Map<Pair<String, Long>, Pair<String, DynamicObject>> tmpAndFloatMap) {
        DynamicObject easmap = BusinessDataServiceHelper.newDynamicObject((String)"bcm_easmembermap");
        String name = obj.getString("name");
        DynamicObject parent = (DynamicObject)obj.get("parent");
        Pair<String, DynamicObject> tmpAndFloat = tmpAndFloatMap.get(Pair.onePair((Object)name, (Object)parent.getLong("id")));
        easmap.set("easname", (Object)name);
        easmap.set("memberid", (Object)obj.getLong("id"));
        easmap.set("membernumber", (Object)obj.getString("number"));
        easmap.set("tmpnumber", (Object)((DynamicObject)tmpAndFloat.p2).getString("number"));
        easmap.set("tmpname", (Object)((DynamicObject)tmpAndFloat.p2).getString("name"));
        easmap.set("dimension", obj.get("dimension"));
        String dimnumber = this.dim.getNUmberById(obj.getLong("dimension"));
        easmap.set("dimensionnumber", (Object)dimnumber);
        easmap.set("parentid", (Object)parent.getLong("id"));
        easmap.set("parentnumber", (Object)parent.getString("number"));
        easmap.set("model", (Object)this.getModelId());
        easmap.set("membername", (Object)obj.getString("name"));
        easmap.set("parentname", (Object)parent.getString("name"));
        easmap.set("dimensionname", (Object)this.dim.getName(dimnumber));
        easmap.set("tmplid", (Object)((DynamicObject)tmpAndFloat.p2).getLong("id"));
        easmap.set("floatarea", tmpAndFloat.p1);
        CommonSqlMsgUtil.create((DynamicObject)easmap);
        easmembermap.add(easmap);
    }

    private void needAdd(Multimap<String, DynamicObject> needToAddmap, String dimension, DynamicObject obj) {
        boolean notAdd = needToAddmap.get((Object)dimension).stream().anyMatch(d -> d.getString("easname").equals(obj.getString("easname")) && d.getString("parent_id").equals(obj.getString("parent_id")));
        if (!notAdd) {
            needToAddmap.put((Object)dimension, (Object)obj);
        }
    }

    private void saveShareMember() {
        if (this.getShareList().size() == 0) {
            return;
        }
        ArrayList<Long> loadids = new ArrayList<Long>();
        Iterator iterator = this.getShareList().rowKeySet().iterator();
        while (iterator.hasNext()) {
            long memId = (Long)iterator.next();
            Iterator iterator2 = this.getShareList().row((Object)memId).keySet().iterator();
            while (iterator2.hasNext()) {
                long parentId = (Long)iterator2.next();
                if ((Long)this.getShareList().get((Object)memId, (Object)parentId) == 0L) continue;
                loadids.add(memId);
                loadids.add(parentId);
            }
        }
        DynamicObjectCollection dseq = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"dseq,parent.id", (QFilter[])new QFilter[]{new QFilter("parent", "in", loadids)}, (String)"dseq desc", (int)1);
        HashMap<Long, Integer> seqmap = new HashMap<Long, Integer>();
        for (DynamicObject seq : dseq) {
            seqmap.put(seq.getLong("parent.id"), seq.getInt("dseq"));
        }
        HashMap objs = new HashMap(16);
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"bcm_userdefinedmembertree", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_userdefinedmembertree").getAllFields().keySet()), (QFilter[])new QFilter[]{new QFilter("id", "in", loadids)});
        Arrays.stream(dynObjs).forEach(dyn -> objs.put(dyn.getLong("id"), dyn));
        ArrayList<DynamicObject> shareMembers = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> parents = new ArrayList<DynamicObject>();
        Iterator iterator3 = this.getShareList().rowKeySet().iterator();
        while (iterator3.hasNext()) {
            long memId = (Long)iterator3.next();
            Iterator iterator4 = this.getShareList().row((Object)memId).keySet().iterator();
            while (iterator4.hasNext()) {
                long parentId = (Long)iterator4.next();
                long newid = (Long)this.getShareList().get((Object)memId, (Object)parentId);
                if (newid == 0L) continue;
                DynamicObject orimem = (DynamicObject)objs.get(memId);
                DynamicObject parent = (DynamicObject)objs.get(parentId);
                int seq = 1;
                if (seqmap.containsKey(parentId)) {
                    seq = (Integer)seqmap.get(parentId) + 1;
                }
                seqmap.put(parentId, seq);
                DynamicObject newObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)orimem, (boolean)true, (boolean)true);
                newObj.set("id", (Object)newid);
                newObj.set("storagetype", (Object)StorageTypeEnum.SHARE.index);
                parent.set("isleaf", (Object)0);
                newObj.set("parent", (Object)parent);
                newObj.set("level", (Object)(parent.getInt("level") + 1));
                newObj.set("longnumber", (Object)(parent.get("longnumber") + String.valueOf('!') + orimem.getString("number")));
                newObj.set("dseq", (Object)(++seq));
                newObj.set("issysmember", (Object)DimMemTypeEnum.SHAREMEM.getIndex());
                newObj.set("copyfrom", (Object)orimem);
                shareMembers.add(newObj);
                parents.add(parent);
            }
        }
        SaveServiceHelper.save((DynamicObject[])shareMembers.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])parents.toArray(new DynamicObject[0]));
    }

    private List<Map<String, String>> getMsg() {
        List list = (List)this.getFormCustomParam("easmsg");
        HashSet<Map<String, String>> reportSet = new HashSet<Map<String, String>>();
        if (this.getModelId() != 0L) {
            reportSet.addAll(list);
            this.filterExistMap(reportSet);
        }
        return Lists.newArrayList(reportSet);
    }

    private void filterExistMap(Set<Map<String, String>> reportSet) {
        HashSet<String> dimnumber = new HashSet<String>(16);
        HashSet<String> easname = new HashSet<String>(16);
        HashSet<String> tempnumbers = new HashSet<String>(16);
        for (Map<String, String> map : reportSet) {
            dimnumber.add(map.get("dimnumer"));
            easname.add(map.get("easname"));
            tempnumbers.add(map.get("tempnumber"));
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)this.getModelId());
        qfBuilder.add("dimensionnumber", "in", dimnumber);
        qfBuilder.add("easname", "in", easname);
        qfBuilder.add("tmpnumber", "in", tempnumbers);
        DynamicObjectCollection col1 = QueryServiceHelper.query((String)"bcm_easmembermap", (String)"easname,dimensionnumber,membernumber,tmpnumber,parentnumber", (QFilter[])qfBuilder.toArray());
        this.checkMemberIsExist(col1);
        HashSet<String> currentKey = new HashSet<String>(16);
        Map<String, Map<String, String>> parentMap = this.getParentMap(tempnumbers);
        Iterator<Map<String, String>> iterator = reportSet.iterator();
        while (iterator.hasNext()) {
            Map<String, String> m = iterator.next();
            String parentnumber = parentMap.get(m.get("tempnumber") + m.get("floatarea")).get(m.get("dimnumer"));
            boolean exist = col1.stream().anyMatch(dyn -> dyn.getString("easname").equals(m.get("easname")) && dyn.getString("dimensionnumber").equals(m.get("dimnumer")) && dyn.getString("tmpnumber").equals(m.get("tempnumber")) && (StringUtil.isEmptyString((String)dyn.getString("parentnumber")) || !StringUtil.isEmptyString((String)parentnumber) && dyn.getString("parentnumber").equals(parentnumber)));
            String key = m.get("easname").concat(m.get("dimnumer")).concat(m.get("tempnumber")).concat(parentnumber);
            if (exist || currentKey.contains(key)) {
                iterator.remove();
            }
            currentKey.add(key);
        }
    }

    private void checkMemberIsExist(DynamicObjectCollection col1) {
        HashMap members = new HashMap(16);
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)this.getModelId(), (String)"bcm_model", (String)"number");
        col1.forEach(c -> {
            if (!MemberReader.isExistMember((String)model.getString("number"), (String)c.getString("dimensionnumber"), (String)c.getString("membernumber"))) {
                members.putIfAbsent(c.getString("dimensionnumber"), new HashSet(16));
                ((Set)members.get(c.getString("dimensionnumber"))).add(c.getString("membernumber"));
            }
        });
        if (members.size() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6620\u5c04\u4e2d\u4e0b\u5217\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u9664\u5bf9\u5e94\u6210\u5458\u6620\u5c04\u91cd\u65b0\u91c7\u96c6\uff1a%s\u3002", (String)"EasMemberMapPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), JSON.toJSONString(members)), Integer.valueOf(30000));
        }
    }

    private Map<String, Map<String, String>> getParentMap(Set<String> tempnumbers) {
        HashMap<String, Map<String, String>> parentMap = new HashMap<String, Map<String, String>>();
        Long modelId = this.getModelId();
        Long yearId = this.getYearid();
        Long periodId = this.getPeriodid();
        QFBuilder qfb = new QFBuilder("model", "=", (Object)modelId);
        qfb.add("number", "in", tempnumbers);
        Collection dyncol = BusinessDataServiceHelper.loadFromCache((String)"bcm_templateentity", (String)"id,number,versionnumber", (QFilter[])qfb.toArray()).values();
        HashSet ids = new HashSet();
        dyncol.forEach(dyn -> ids.add(dyn.getLong("id")));
        Collection tmplids = TemplateUtil.getRightTplIdByVersioned((Long)modelId, (Long)yearId, (Long)periodId, ids).values();
        ArrayList models = new ArrayList();
        tmplids.forEach(e -> models.add(TemplateServiceHelper.getTemplateModelById((Object)e)));
        for (TemplateModel model : models) {
            String tmplNumber = model.getNumber();
            SpreadManager spread = JsonSerializerUtil.toSpreadManager((String)model.getRptData());
            if (!DynamicUtils.isDynamicReport((SpreadManager)spread)) continue;
            boolean isDirectHoriz = DynamicUtils.isDirectHoriz((SpreadManager)spread);
            for (PositionInfo p : FloatLogicImpl.sortPositionInfo(spread.getAreaManager().getPostionInfoSet(), isDirectHoriz)) {
                if (!p.isFloatPosition()) continue;
                for (BasePointInfo basePoint : FloatLogicImpl.sortBasePoint(p.getBasePoints())) {
                    String dynaRange = basePoint.getDynaRange();
                    HashMap<String, String> dimMap = new HashMap<String, String>();
                    for (BasePointInnerLineInfo line : basePoint.getBasePointInnerLineInfo()) {
                        if (!line.isFloated()) continue;
                        dimMap.put(line.getDimension().getNumber(), line.getMemberAddOf() == null ? "" : line.getMemberAddOf().getNumber());
                    }
                    parentMap.put(tmplNumber + dynaRange, dimMap);
                }
            }
        }
        return parentMap;
    }

    private long getParent(String tmpnum, String floatarea, String dinumber) {
        SpreadManager tsm = this.getSm(tmpnum);
        if (!DimEntityNumEnum.getEntieyNumByNumber((String)dinumber).equals("bcm_userdefinedmembertree")) {
            return 0L;
        }
        String key = tmpnum + floatarea + dinumber;
        if (this.parentidmap.get(key) != null) {
            return this.parentidmap.get(key);
        }
        for (PositionInfo p : tsm.getAreaManager().getPostionInfoSet()) {
            for (BasePointInfo b : p.getBasePoints()) {
                if (!b.getDynaRange().equals(floatarea)) continue;
                for (BasePointInnerLineInfo in : b.getBasePointInnerLineInfo()) {
                    if (!in.getDimension().getNumber().equals(dinumber) || in.getMemberAddOf() == null) continue;
                    long id = ((DimMember)in.getMemberAddOf()).getId();
                    if (in.getAddPositionEnum() == MembAddPositionEnum.DirectChild) {
                        return id;
                    }
                    DynamicObject obj = QueryServiceHelper.queryOne((String)DimEntityNumEnum.getEntieyNumByNumber((String)in.getDimension().getNumber()), (String)"parent.id", (QFilter[])new QFilter[]{QFilter.of((String)"id=?", (Object[])new Object[]{id})});
                    this.parentidmap.put(key, obj.getLong("parent.id"));
                    return obj.getLong("parent.id");
                }
            }
        }
        return 0L;
    }

    private Multimap<String, DynamicObject> saveMember(Multimap<String, DynamicObject> needToAddmap) {
        HashMultimap members = HashMultimap.create();
        HashMultimap treemembers = HashMultimap.create();
        HashMultimap membernumber = HashMultimap.create();
        for (String dimnumber : needToAddmap.keySet()) {
            String entity = DimEntityNumEnum.getEntieyNumByNumber((String)dimnumber);
            HashSet<Long> parentids = new HashSet<Long>(16);
            for (DynamicObject row : needToAddmap.get((Object)dimnumber)) {
                parentids.add(row.getDynamicObject("parent").getLong("id"));
            }
            DynamicObjectCollection dseq = QueryServiceHelper.query((String)entity, (String)"dseq,parent.id", (QFilter[])new QFilter[]{new QFilter("parent", "in", parentids)}, (String)"dseq desc", (int)1);
            DynamicObject[] levels = BusinessDataServiceHelper.load((String)entity, (String)"id,longnumber,level,isleaf", (QFilter[])new QFilter[]{new QFilter("id", "in", parentids)});
            HashMap<Long, Integer> seqmap = new HashMap<Long, Integer>(16);
            HashMap<Long, Integer> levelmap = new HashMap<Long, Integer>(16);
            HashMap<Long, String> longnumbermap = new HashMap<Long, String>(16);
            for (DynamicObject seq : dseq) {
                seqmap.put(seq.getLong("parent.id"), seq.getInt("dseq"));
            }
            for (DynamicObject le : levels) {
                levelmap.put(le.getLong("id"), le.getInt("level"));
                longnumbermap.put(le.getLong("id"), le.getString("longnumber"));
                le.set("isleaf", (Object)0);
            }
            SaveServiceHelper.save((DynamicObject[])levels);
            DynamicObject temp = BusinessDataServiceHelper.newDynamicObject((String)entity);
            temp.set("createtime", (Object)TimeServiceHelper.now());
            String[] numbers = CodeRuleUtil.getDimensionNumber(entity, temp, needToAddmap.get((Object)dimnumber).size());
            int i = 0;
            for (DynamicObject row : needToAddmap.get((Object)dimnumber)) {
                String number = dimnumber + numbers[i];
                membernumber.put((Object)dimnumber, (Object)number);
                long parent = row.getDynamicObject("parent").getLong("id");
                String easname = row.getString("easname");
                int level = (Integer)levelmap.get(parent) + 1;
                int seq = seqmap.get(parent) == null ? i + 1 : (Integer)seqmap.get(parent) + i + 1;
                String longnumber = (String)longnumbermap.get(parent);
                DynamicObject member = this.createMember(easname, dimnumber, number);
                DynamicObject treemember = this.createTreeMember(member, dimnumber, seq, level, longnumber, row.getDynamicObject("parent"));
                members.put((Object)dimnumber, (Object)member);
                treemembers.put((Object)dimnumber, (Object)treemember);
                ++i;
            }
        }
        DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"number", (QFilter[])new QFilter[]{QFilter.of((String)"id=?", (Object[])new Object[]{this.getModelId()})});
        for (String key : members.keySet()) {
            SaveServiceHelper.save((DynamicObject[])members.get((Object)key).toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])treemembers.get((Object)key).toArray(new DynamicObject[0]));
            Collection dynamicObjects = treemembers.get((Object)key);
            ArrayList<Tuple> list = new ArrayList<Tuple>(dynamicObjects.size());
            for (DynamicObject treeMember : dynamicObjects) {
                list.add(Tuple.create((Object)treeMember.getString("number"), (Object)treeMember.getInt("aggoprt"), (Object)DimensionServiceHelper.getMemberNumber((String)DimEntityNumEnum.getEntieyNumByNumber((String)key), (Object)((DynamicObject)treeMember.get("parent")).getLong("id"))));
            }
            OlapServiceHelper.batchCreateDimensionMembers((String)model.getString("number"), (String)key, list);
        }
        return treemembers;
    }

    private DynamicObject createMember(String easname, String dimnumber, String number) {
        String entity = "bcm_userdefinedmember";
        DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)entity);
        DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)member);
        member.set("number", (Object)number);
        member.set("name", (Object)easname);
        member.set("model", (Object)this.getModelId());
        member.set("dimension", (Object)this.dim.getDimId(dimnumber));
        return member;
    }

    private DynamicObject createTreeMember(DynamicObject member, String dimnumber, int seq, int level, String palongnumber, DynamicObject parent) {
        String number = member.getString("number");
        String name = member.getString("name");
        String entity = DimEntityNumEnum.getEntieyNumByNumber((String)dimnumber);
        DynamicObject treeMem = BusinessDataServiceHelper.newDynamicObject((String)entity);
        DimensionServiceHelper.initDimensionDyObject((DynamicObject)treeMem);
        treeMem.set("model", (Object)this.getModelId());
        treeMem.set("dimension", (Object)this.dim.getDimId(dimnumber));
        treeMem.set("level", (Object)level);
        treeMem.set("member", (Object)member);
        treeMem.set("parent", (Object)parent);
        treeMem.set("storagetype", (Object)StorageTypeEnum.STORAGE.index);
        treeMem.set("aggoprt", (Object)"1");
        treeMem.set("isleaf", (Object)true);
        treeMem.set("longnumber", (Object)(palongnumber + '!' + number));
        treeMem.set("number", (Object)number);
        treeMem.set("name", (Object)name);
        treeMem.set("issysmember", (Object)DimMemTypeEnum.INTEGRATION.getIndex());
        treeMem.set("dseq", (Object)seq);
        treeMem.set("description", (Object)ResManager.loadKDString((String)"\u96c6\u6210\u65b0\u589e", (String)"EasMemberMapPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        treeMem.set("datatype", (Object)"0");
        return treeMem;
    }

    private Map<String, Long> autoMatchMember(List<Map<String, String>> msg) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        HashMap<String, String> withoutnumbernamemap = new HashMap<String, String>(16);
        HashMap<String, String> chinesenamemap = new HashMap<String, String>(16);
        HashMultimap names = HashMultimap.create();
        MemberMsgCache members = new MemberMsgCache(this.getModelId());
        members.setCustomKey("name");
        ArrayList<String> scopekeys = new ArrayList<String>();
        for (Map<String, String> map : msg) {
            String dimnumber = map.get("dimnumer");
            String tmpnumber = map.get("tempnumber");
            String name = map.get("easname");
            String withoutnumbername = this.removeEndNumber(name);
            String chinesename = withoutnumbername.replaceAll("\\(", "\uff08").replaceAll("\\)", "\uff09");
            withoutnumbernamemap.put(name, withoutnumbername);
            chinesenamemap.put(name, chinesename);
            members.setFilter(dimnumber, "name", (Object)name);
            members.setFilter(dimnumber, "name", (Object)withoutnumbername);
            members.setFilter(dimnumber, "name", (Object)chinesename);
            if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimnumber)) {
                names.put((Object)dimnumber, (Object)name);
                continue;
            }
            String floatarea = map.get("floatarea");
            String key = (String)tmpnumber + "&" + floatarea + "&" + dimnumber;
            scopekeys.add(key);
            this.nameids.setFilter(dimnumber, "name", (Object)name);
            this.nameids.setFilter(dimnumber, "name", (Object)withoutnumbername);
            this.nameids.setFilter(dimnumber, "name", (Object)chinesename);
            names.put((Object)key, (Object)name);
        }
        Map<String, Set<Long>> scopes = this.getScopeMap(scopekeys);
        for (String dimNum : names.keySet()) {
            if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNum)) {
                members.setSelectfiled(dimNum, "id,name");
                members.addCustomFilter(dimNum, QFilter.of((String)"storagetype !=?", (Object[])new Object[]{StorageTypeEnum.SHARE.index}));
                for (String oriname : names.get((Object)dimNum)) {
                    Object o = members.getMsg(dimNum, oriname, "id");
                    if (StringUtils.isEmpty((String)o.toString()) && StringUtils.isEmpty((String)(o = members.getMsg(dimNum, (String)withoutnumbernamemap.get(oriname), "id")).toString())) {
                        o = members.getMsg(dimNum, (String)chinesenamemap.get(oriname), "id");
                    }
                    if (StringUtils.isEmpty((String)o.toString())) continue;
                    result.put(dimNum + oriname, Long.valueOf(o.toString()));
                }
                continue;
            }
            String[] dimandscope = dimNum.split("&");
            if (dimandscope.length < 3) continue;
            String scopekey = dimNum;
            dimNum = dimandscope[2];
            String tmpnum = dimandscope[0];
            String floatarea = dimandscope[1];
            long parentid = this.getParent(tmpnum, floatarea, dimNum);
            Set<Long> scopeids = scopes.get(scopekey);
            this.nameids.setFilter(dimNum, "parent", (Object)parentid);
            for (String oriname : names.get((Object)scopekey)) {
                long id = this.checkIdInscope(this.nameids.getIds(dimNum, oriname), scopeids);
                if (id == -1L || id == 0L && ((id = this.checkIdInscope(this.nameids.getIds(dimNum, (String)withoutnumbernamemap.get(oriname)), scopeids)) == -1L || id == 0L && ((id = this.checkIdInscope(this.nameids.getIds(dimNum, (String)chinesenamemap.get(oriname)), scopeids)) == 0L || id == -1L))) continue;
                result.put(dimNum + oriname, id);
            }
        }
        this.cacheShareList();
        return result;
    }

    private long checkIdInscope(Set<Long> ids, Set<Long> scope) {
        if (ids == null || ids.size() == 0) {
            return 0L;
        }
        if (scope == null) {
            return ids.iterator().next();
        }
        for (long id : ids) {
            if (!scope.contains(id)) continue;
            return id;
        }
        return -1L;
    }

    private Map<String, Set<Long>> getScopeMap(List<String> scopekeys) {
        HashMap<String, Set<Long>> scopes = new HashMap<String, Set<Long>>();
        for (String scopekey : scopekeys) {
            String[] msgs = scopekey.split("&");
            String tmpnumber = msgs[0];
            String floatarea = msgs[1];
            String dimnumber = msgs[2];
            SpreadManager sm = this.getSm(tmpnumber);
            BasePointInnerLineInfo in = this.searchInnerInfo(sm, floatarea, dimnumber);
            if (in == null) continue;
            Set<Long> ids = this.getInScopeMember(in);
            scopes.put(scopekey, ids);
        }
        return scopes;
    }

    private String removeEndNumber(String name) {
        char c;
        for (int i = name.length() - 1; i > 0 && ((c = name.charAt(i)) >= '0' && c <= '9' || c == '@' || c == '#' || c == '&' || c == '$'); --i) {
            name = name.substring(0, i);
        }
        return name;
    }

    private QFilter getFilter(SpreadManager tsm, String floatarea, String dinumber) {
        BasePointInnerLineInfo in;
        if (this.dim == null) {
            this.dim = new DimensionMsgCache(this.getModelId());
        }
        if ((in = this.searchInnerInfo(tsm, floatarea, dinumber)) != null) {
            return this.getFilterByInnerInfo(in, this.getModelId(), this.dim.getDimId(dinumber));
        }
        return QFilter.of((String)"model = ?", (Object[])new Object[]{this.getModelId()});
    }

    private QFilter getFilterByInnerInfo(BasePointInnerLineInfo info, long modelid, long dimensionId) {
        List scope = info.getDynaMembScopes();
        if (scope.size() == 0) {
            return null;
        }
        QFilter qf = null;
        for (DynaMembScopeInfo scinfo : scope) {
            MembRangeItem item = new MembRangeItem(scinfo.getMember().getDimension().getUqCode(), Long.valueOf(((DimMember)scinfo.getMember()).getId()), scinfo.getMember().getNumber(), scinfo.getRangeId(), scinfo.isCustom(), (Object)modelid);
            if (qf == null) {
                qf = item.buildFilterByScope();
                continue;
            }
            qf.or(item.buildFilterByScope());
        }
        return qf;
    }

    private BasePointInnerLineInfo searchInnerInfo(SpreadManager sm, String floatarea, String dimnum) {
        for (PositionInfo p : sm.getAreaManager().getPostionInfoSet()) {
            for (BasePointInfo b : p.getBasePoints()) {
                if (!b.getDynaRange().equals(floatarea)) continue;
                for (BasePointInnerLineInfo in : b.getBasePointInnerLineInfo()) {
                    if (!in.getDimension().getNumber().equals(dimnum)) continue;
                    return in;
                }
            }
        }
        return null;
    }

    public Set<Long> getInScopeMember(BasePointInnerLineInfo info) {
        List scope = info.getDynaMembScopes();
        HashSet<Long> ids = new HashSet<Long>();
        if (scope.size() != 0) {
            for (DynaMembScopeInfo scinfo : scope) {
                if (scinfo.isCustom()) {
                    ids.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange((String)"bcm_definedpropertyvalue", (Long)((DimMember)scinfo.getMember()).getId(), (String)scinfo.getMember().getNumber(), (int)scinfo.getRangeId(), (String)String.valueOf(this.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
                    continue;
                }
                ids.addAll(QueryMemberDetailsHelper.queryMemberIdsByRange((String)scinfo.getMember().getDimension().getUqCode(), (Long)((DimMember)scinfo.getMember()).getId(), (int)scinfo.getRangeId(), (String)String.valueOf(this.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
            }
        } else {
            return null;
        }
        return ids;
    }

    private Table<Long, Long, Long> getShareList() {
        if (this.shareList == null) {
            String sl = this.getPageCache().get("sharelist");
            this.shareList = StringUtils.isEmpty((String)sl) ? HashBasedTable.create() : (Table)ObjectSerialUtil.deSerializedBytes((String)sl);
        }
        return this.shareList;
    }

    private void cacheShareList() {
        if (this.shareList == null) {
            this.shareList = HashBasedTable.create();
        }
        this.getPageCache().put("sharelist", ObjectSerialUtil.toByteSerialized(this.shareList));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_import": {
                ArrayList<List<String>> list = new ArrayList<List<String>>();
                DynamicObjectCollection doc = this.getModel().getEntryEntity(this.ENTRYENTITY);
                ArrayList<String> head = new ArrayList<String>();
                head.add(ResManager.loadKDString((String)"eas\u540d\u79f0", (String)"EasMemberMapPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                head.add(ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"EasMemberMapPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                head.add(ResManager.loadKDString((String)"\u82cd\u7a79\u6210\u5458\u7f16\u7801", (String)"EasMemberMapPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                head.add(ResManager.loadKDString((String)"\u82cd\u7a79\u6210\u5458\u540d\u79f0", (String)"EasMemberMapPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                head.add(ResManager.loadKDString((String)"\u82cd\u7a79\u4e0a\u7ea7\u6210\u5458\u7f16\u7801", (String)"EasMemberMapPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                head.add(ResManager.loadKDString((String)"\u82cd\u7a79\u4e0a\u7ea7\u6210\u5458\u540d\u79f0", (String)"EasMemberMapPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                head.add(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801", (String)"EasMemberMapPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                head.add(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0", (String)"EasMemberMapPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                list.add(head);
                for (DynamicObject obj : doc) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(obj.getString("easname"));
                    data.add(obj.getString("dimension.number"));
                    data.add(obj.getString("member.number"));
                    data.add(obj.getString("member.name"));
                    data.add(obj.getString("parent.number"));
                    data.add(obj.getString("parent.name"));
                    data.add(obj.getString("tmp.number"));
                    data.add(obj.getString("tmp.name"));
                    list.add(data);
                }
                WriteExcelUtil.writeExcel(this.getView(), list, ResManager.loadKDString((String)"\u5bfc\u51fa.xlsx", (String)"EasMemberMapPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

