/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class FormulaParamMapPlugin
extends AbstractBaseFormPlugin {
    public static final String ENTRYENTITY = "entryentity";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners("btn_ok");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.bulidEntry();
    }

    private void bulidEntry() {
        List formulas = DataCollectUtil.getCanParamFloatFormulas();
        if (formulas.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u914d\u7f6e\u6620\u5c04\u7684\u516c\u5f0f\u3002", (String)"FormulaParamMapPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, List<DynamicObject>> formula2dimensionMap = this.getDimensionMap();
        Map formula2param = (Map)this.getView().getFormShowParameter().getCustomParam("formula2param");
        int rowSize = 0;
        HashMap<String, Map<String, String>> formula2FloatParamMaps = new HashMap<String, Map<String, String>>(10);
        for (Formula formula : formulas) {
            String floatParamStr = formula.getFloatParam();
            if (StringUtils.isEmpty((String)floatParamStr)) continue;
            Map floatParams = (Map)JSON.parseObject((String)floatParamStr, Map.class);
            String formulaNumber = formula.getNumber();
            this.removeExistParam(formula2dimensionMap, floatParams, formulaNumber, formula2param);
            rowSize += floatParams.size();
            formula2FloatParamMaps.put(formulaNumber, floatParams);
        }
        if (rowSize > 0) {
            this.creatEntryRow(rowSize, formula2FloatParamMaps);
        }
    }

    private void creatEntryRow(int rowSize, Map<String, Map<String, String>> formula2FloatParamMaps) {
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(ENTRYENTITY, rowSize);
        int index = 0;
        for (Map.Entry<String, Map<String, String>> formulaInfos : formula2FloatParamMaps.entrySet()) {
            String formulaNumber = formulaInfos.getKey();
            Map<String, String> infos = formulaInfos.getValue();
            for (Map.Entry<String, String> entry : infos.entrySet()) {
                model.setValue("formulanumber", (Object)formulaNumber, index);
                model.setValue("paramnumber", (Object)entry.getKey(), index);
                model.setValue("paramname", (Object)entry.getValue(), index);
                ++index;
            }
        }
    }

    private void removeExistParam(Map<String, List<DynamicObject>> formula2dimensionMap, Map<String, String> floatParams, String formulaNumber, Map<String, List<String>> formula2param) {
        if (formula2param.containsKey(formulaNumber)) {
            List<String> params = formula2param.get(formulaNumber);
            for (String param : params) {
                floatParams.remove(param);
            }
        }
    }

    private Map<String, List<DynamicObject>> getDimensionMap() {
        Object modelId = this.getView().getFormShowParameter().getCustomParam("model");
        QFBuilder builder = new QFBuilder("model", "=", (Object)LongUtil.toLong((Object)modelId));
        builder.add("isfloat", "=", (Object)Character.valueOf('3'));
        DynamicObjectCollection dimensionMap = QueryServiceHelper.query((String)"bcm_dimensionmapnew", (String)"commonassist,formula", (QFilter[])builder.toArray());
        Map<String, List<DynamicObject>> formula2dimensionMap = dimensionMap.stream().collect(Collectors.groupingBy(dy -> dy.getString("formula")));
        return formula2dimensionMap;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        int row = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        if ("btn_ok".equals(key)) {
            DynamicObject selectedRow = this.getModel().getEntryRowEntity(ENTRYENTITY, row);
            this.getView().returnDataToParent((Object)selectedRow);
            this.getView().close();
        }
    }
}

