/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.util.ISImportModeUtil;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class IntegrationListPlugin
extends AbstractBaseListPlugin {
    private static final String CTL_TEMPLATECATALOG = "templatecatalog";
    private static final String CTL_BILLLISTAP = "billlistap";
    public static final String BCM_CATALOG_TYPE = "1";
    private static final String DI_CATALOG_TYPE = "2";
    Long modelId = 0L;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_ok", "btn_cancel");
        TreeView treeView = (TreeView)this.getControl(CTL_TEMPLATECATALOG);
        final BillList billList = (BillList)this.getControl(CTL_BILLLISTAP);
        billList.addSetFilterListener(this::setFilter);
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                IntegrationListPlugin.this.getPageCache().put("focusnodeid", evt.getNodeId().toString());
                billList.clearSelection();
                IntegrationListPlugin.this.refreshBillList();
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        if (this.modelId == null) {
            this.modelId = 0L;
        }
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter("model", "=", (Object)this.modelId);
        fp.setFilter(filter);
        BillList billList = (BillList)this.getControl(CTL_BILLLISTAP);
        billList.setMulti(false);
        billList.setFilterParameter(fp);
        this.refreshTree();
        this.refreshBillList();
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(this.getFilter());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_ok".equals(key)) {
            BillList billList = (BillList)this.getView().getControl(CTL_BILLLISTAP);
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows == null || rows.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u65b9\u6848\u518d\u64cd\u4f5c\u3002", (String)"ISSchemeListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return;
            }
            this.getView().returnDataToParent(rows.get(0).getPrimaryKeyValue());
            this.getView().close();
        }
    }

    public QFilter getFilter() {
        String nodeid = this.getPageCache().get("focusnodeid");
        if (nodeid == null) {
            return new QFilter(BCM_CATALOG_TYPE, "=", (Object)0);
        }
        QFilter qFilter = new QFilter(CTL_TEMPLATECATALOG, "=", (Object)ConvertUtil.convertStrToLong((String)nodeid));
        qFilter.and("id", "not in", (Object)DIIntegrationUtil.getCurrentUserReadAndNoPermAndDisableScheme((Long)this.modelId));
        return qFilter;
    }

    public void refreshBillList() {
        ISImportModeUtil.getAllReplaceImport((long)this.modelId);
        BillList billList = (BillList)this.getControl(CTL_BILLLISTAP);
        billList.refresh();
        billList.clearSelection();
    }

    private void refreshTree() {
        TreeView tree = (TreeView)this.getControl(CTL_TEMPLATECATALOG);
        tree.deleteAllNodes();
        this.initTree();
    }

    private void initTree() {
        TreeNode schemecatalog = new TreeNode();
        String algoKey = this.getClass().getName();
        String entityName = "bcm_schemecatalog";
        String selectFields = "id,name,number,parent";
        QFilter fmodelid = new QFilter("model", "=", (Object)this.modelId);
        QFilter typeQf = new QFilter("type", "!=", (Object)DI_CATALOG_TYPE);
        QFilter[] filters = new QFilter[]{fmodelid, typeQf};
        String orderBys = "id";
        Long rootid = null;
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        ArrayList treeList = new ArrayList(10);
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put("id", task.get("id").toString());
                memberMap.put("number", (String)task.get("number"));
                memberMap.put("name", (String)task.get("name"));
                memberMap.put("parentid", task.get("parent").toString());
                treeList.add(memberMap);
                if (!"0".equals(task.get("parent").toString())) continue;
                rootid = task.getLong("id");
                this.getPageCache().put("focusnodeid", rootid.toString());
                this.getPageCache().put("headnodeid", rootid.toString());
            }
        } else {
            rootid = GlobalIdUtil.genGlobalLongId();
            IntegrationListPlugin.setDefaultRootNode(String.valueOf(this.modelId), rootid);
            this.getPageCache().put("focusnodeid", rootid.toString());
            this.getPageCache().put("headnodeid", rootid.toString());
        }
        schemecatalog.setId(rootid != null ? rootid.toString() : "");
        schemecatalog.setParentid("");
        schemecatalog.setText(ResManager.loadKDString((String)"\u65b9\u6848\u5206\u7c7b", (String)"ISSchemeListPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("treelist", SerializationUtils.toJsonString(treeList));
        BCMTreeUtils.setEntryNode((TreeNode)schemecatalog, treeList, (String)(rootid != null ? rootid.toString() : ""));
        BCMTreeUtils.spreadAllNode((TreeNode)schemecatalog);
        TreeView tree = (TreeView)this.getControl(CTL_TEMPLATECATALOG);
        tree.addNode(schemecatalog);
        tree.focusNode(schemecatalog);
    }

    private static void setDefaultRootNode(String modelid, Long rootid) {
        DynamicObject catalogTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_schemecatalog");
        catalogTree.set("id", (Object)rootid);
        catalogTree.set("number", (Object)"root");
        catalogTree.set("model", (Object)ConvertUtil.convertStrToLong((String)modelid));
        catalogTree.set("name", (Object)ResManager.loadKDString((String)"\u65b9\u6848\u5206\u7c7b", (String)"ISSchemeListPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        catalogTree.set("parent", (Object)0);
        catalogTree.set("longnumber", (Object)"root");
        catalogTree.set("status", (Object)"C");
        catalogTree.set("enable", (Object)1);
        catalogTree.set("type", (Object)BCM_CATALOG_TYPE);
        catalogTree.set("modifier", (Object)RequestContext.get().getUserId());
        catalogTree.set("creator", (Object)RequestContext.get().getUserId());
        catalogTree.set("modifytime", (Object)TimeServiceHelper.now());
        catalogTree.set("createtime", (Object)TimeServiceHelper.now());
        BusinessDataWriter.save((IDataEntityType)catalogTree.getDynamicObjectType(), (Object[])new Object[]{catalogTree});
    }
}

