/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class MemberMappingPlugin
extends AbstractBaseListPlugin {
    public static final String ENTRYENTITY = "entryentity";
    public static final String BCMMEMBER = "bcmmember";
    public static final String ASSTTYPE = "assttype";
    public static final String ASSTMEMBER = "asstmember";
    private static final String CLOSE = "close";
    private static final String SAVE = "save";

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit bcmdim = (BasedataEdit)this.getControl("bcmdim");
        bcmdim.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners("btn_ok", "btn_cancel", BCMMEMBER, ASSTTYPE);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter listParameter = parameter.getListFilterParameter();
        List qFilters = listParameter.getQFilters();
        long modelId = this.getCustomParamModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MemberMappingPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if ("bcmdim".equals(beforeF7SelectEvent.getProperty().getName())) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            Object asstType = this.getModel().getValue(ASSTTYPE, currentRowIndex);
            Long periodId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Period");
            Long entityId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
            ArrayList<Long> dimIds = new ArrayList<Long>();
            if (asstType != null && StringUtils.isNotEmpty((CharSequence)asstType.toString())) {
                if (ResManager.loadKDString((String)"\u671f\u95f4", (String)"AccountDimPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(asstType.toString())) {
                    dimIds.add(periodId);
                } else if (ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"AccountDimPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(asstType.toString())) {
                    dimIds.add(entityId);
                }
            } else {
                dimIds.add(periodId);
                dimIds.add(entityId);
            }
            qFilters.add(new QFilter("id", "in", dimIds));
        }
    }

    private Long getCustomParamModelId() {
        Object modelId = this.getView().getFormShowParameter().getCustomParams().get("modelId");
        if (modelId == null) {
            return 0L;
        }
        return LongUtil.toLong(modelId);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildEntrby();
    }

    private void buildEntrby() {
        IDataModel model = this.getModel();
        DynamicObject[] memberDims = BusinessDataServiceHelper.load((String)"bcm_membermapentity", (String)"id, bcmdim, bcmdim.membermodel, bcmmember, assttype, asstmember, model", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getCustomParamModelId())});
        if (memberDims.length == 0) {
            return;
        }
        int[] rows = model.batchCreateNewEntryRow(ENTRYENTITY, memberDims.length);
        for (int i = 0; i < memberDims.length; ++i) {
            int rowNum = rows[i];
            DynamicObject dimMapping = memberDims[i];
            model.setValue("id", dimMapping.get("id"), rowNum);
            model.setValue("bcmdim", (Object)dimMapping.getLong("bcmdim.id"), rowNum);
            model.setValue(BCMMEMBER, (Object)dimMapping.getString(BCMMEMBER), rowNum);
            model.setValue(ASSTTYPE, (Object)dimMapping.getString(ASSTTYPE), rowNum);
            model.setValue(ASSTMEMBER, (Object)dimMapping.getString(ASSTMEMBER), rowNum);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        Object bcmdim = this.getModel().getValue("bcmdim", currentRowIndex);
        FormShowParameter formShowParameter = new FormShowParameter();
        switch (key) {
            case "bcmmember": {
                if (bcmdim == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u7684\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MemberMappingPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                formShowParameter.setFormId("bcm_singlemember");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BCMMEMBER));
                DynamicObject dim = (DynamicObject)this.getModel().getValue("bcmdim", currentRowIndex);
                formShowParameter.setCustomParam("entity", (Object)dim.getString("membermodel"));
                formShowParameter.setCustomParam("modelId", (Object)this.getCustomParamModelId());
                formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getCustomParamModelId());
                formShowParameter.setCustomParam("dimId", (Object)dim.getLong("id"));
                formShowParameter.setCustomParam("f7Value", (Object)dim.getInt("dseq"));
                this.getView().showForm(formShowParameter);
                break;
            }
            case "assttype": {
                formShowParameter.setFormId("bcm_accountdim");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ASSTTYPE));
                if (bcmdim != null) {
                    formShowParameter.setCustomParam("dim", (Object)((DynamicObject)bcmdim).getString("number"));
                }
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    private String getOperationMemMapping() {
        return ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570-\u6210\u5458\u6620\u5c04", (String)"DimensionMappingPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private void operaMemberMapping() {
        DynamicObjectCollection datas = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList mappingDatas = new ArrayList(16);
        ArrayList<DynamicObject> updateMappings = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> addMappings = new ArrayList<DynamicObject>(16);
        Long modelId = this.getCustomParamModelId();
        DynamicObject[] oldMapping = BusinessDataServiceHelper.load((String)"bcm_membermapentity", (String)"id, bcmdim, bcmdim.membermodel, bcmmember, assttype, asstmember, model, model,formula, creator, modifier", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        Map<Long, DynamicObject> oldMemberMap = Arrays.stream(oldMapping).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        for (DynamicObject data : datas) {
            DynamicObject bcmDim = (DynamicObject)data.get("bcmdim");
            long id = data.getLong("id");
            if (id != 0L) {
                DynamicObject mapping = oldMemberMap.remove(id);
                this.updateMapping(mapping, bcmDim.getLong("id"), data.getString(BCMMEMBER), data.getString(ASSTTYPE), data.getString(ASSTMEMBER), " ");
                updateMappings.add(mapping);
                continue;
            }
            addMappings.add(this.genMapping(bcmDim.getLong("id"), data.getString(BCMMEMBER), data.getString(ASSTTYPE), data.getString(ASSTMEMBER), " "));
        }
        try (TXHandle tx = TX.required();){
            try {
                if (updateMappings.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])updateMappings.toArray(new DynamicObject[mappingDatas.size()]));
                }
                if (addMappings.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])addMappings.toArray(new DynamicObject[mappingDatas.size()]));
                }
                if (oldMemberMap.size() > 0) {
                    DeleteServiceHelper.delete((String)"bcm_membermapentity", (QFilter[])new QFilter("id", "in", oldMemberMap.keySet()).toArray());
                }
            }
            catch (Exception e2) {
                tx.markRollback();
                log.error(ThrowableHelper.toString((Exception)e2));
            }
        }
        ThreadCache.put((Object)"getModelId", (Object)modelId);
        this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u516c\u5f0f\u53d6\u6570-\u6210\u5458\u6620\u5c04", "DimensionMappingPlugin_12", "fi-bcm-formplugin", "Formula retrieval member mapping"), new OPDescMultiLangEnumBridge("\u6210\u5458\u6620\u5c04\u4fdd\u5b58\u6210\u529f", "DimensionMappingPlugin_17", "fi-bcm-formplugin", null));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MemberMappingPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private DynamicObject updateMapping(DynamicObject dy, long bcmdim, String bcmMember, String assttype, String asstmember, String formula) {
        dy.set("bcmdim", (Object)bcmdim);
        dy.set("model", (Object)this.getCustomParamModelId());
        dy.set(BCMMEMBER, (Object)bcmMember);
        dy.set(ASSTTYPE, (Object)assttype);
        dy.set(ASSTMEMBER, (Object)asstmember);
        dy.set("formula", (Object)"acct,acctcf,acctage");
        dy.set("creator", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId()));
        dy.set("modifier", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId()));
        return dy;
    }

    private DynamicObject genMapping(long bcmdim, String bcmMember, String assttype, String asstmember, String formula) {
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_membermapentity");
        dy.set("bcmdim", (Object)bcmdim);
        dy.set("model", (Object)this.getCustomParamModelId());
        dy.set(BCMMEMBER, (Object)bcmMember);
        dy.set(ASSTTYPE, (Object)assttype);
        dy.set(ASSTMEMBER, (Object)asstmember);
        dy.set("formula", (Object)"acct,acctcf,acctage");
        dy.set("creator", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId()));
        dy.set("modifier", (Object)LongUtil.toLong((Object)RequestContext.get().getUserId()));
        return dy;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        if (returnData != null) {
            DynamicObject dynamicObject = (DynamicObject)returnData;
            if (BCMMEMBER.equals(actionId)) {
                this.getModel().setValue(BCMMEMBER, dynamicObject.get("number"), currentRowIndex);
            } else if (ASSTTYPE.equals(actionId)) {
                this.getModel().setValue(ASSTTYPE, dynamicObject.get("name"), currentRowIndex);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("donothing".equals(key) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().getPageCache().put(SAVE, SAVE);
            this.operaMemberMapping();
        } else if ("deleteentry".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getView().getPageCache().put("ischange", "true");
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getView().getPageCache().put("ischange", "true");
        if ("bcmdim".equals(e.getProperty().getName())) {
            e.getProperty();
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            this.getModel().setValue(BCMMEMBER, null, currentRowIndex);
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getView().getPageCache().get(SAVE) == null && this.getView().getPageCache().get(CLOSE) == null && this.getView().getPageCache().get("ischange") != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"MemberMappingPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CLOSE, (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CLOSE.equals(callBackId) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.getView().getPageCache().put(CLOSE, CLOSE);
            this.getView().close();
        }
    }
}

