/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgNameListPlugin
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                try {
                    Object d2;
                    ArrayList<String> orgIds = new ArrayList<String>();
                    ArrayList<String> curIds = new ArrayList<String>();
                    for (DynamicObject row : rows) {
                        orgIds.add(row.getString("orgunit"));
                        curIds.add(row.getString("currency"));
                    }
                    HashMap<String, String> orgMap = new HashMap<String, String>();
                    QFilter filter = new QFilter("soid", "in", orgIds);
                    try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgNameListPlugin.org", (String)"ds_orgunit", (String)"soid,name", (QFilter[])new QFilter[]{filter}, null);){
                        for (Object d2 : ds) {
                            orgMap.put(d2.getString("soid"), d2.getString("name"));
                        }
                    }
                    HashMap<String, String> curMap = new HashMap<String, String>();
                    QFilter filter2 = new QFilter("soid", "in", curIds);
                    DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgNameListPlugin.cur", (String)"ds_currency", (String)"soid,name", (QFilter[])new QFilter[]{filter2}, null);
                    d2 = null;
                    try {
                        for (Row d3 : ds) {
                            curMap.put(d3.getString("soid"), d3.getString("name"));
                        }
                    }
                    catch (Throwable throwable) {
                        d2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (ds != null) {
                            if (d2 != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)d2).addSuppressed(throwable);
                                }
                            } else {
                                ds.close();
                            }
                        }
                    }
                    for (DynamicObject row : rows) {
                        String currency;
                        String org = (String)orgMap.get(row.getString("orgunit"));
                        if (org != null) {
                            row.set("orgunit", (Object)org);
                        }
                        if ((currency = (String)curMap.get(row.getString("currency"))) == null) continue;
                        row.set("currency", (Object)currency);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return rows;
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        QFilter filter = new QFilter("bizkey", "!=", (Object)"");
        qFilters.add(filter);
    }
}

