/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.DimmensionMappingEnum;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public class OtherDimensionPlugin
extends AbstractBaseListPlugin {
    public static final String ENTRYENTITY = "entryentity";
    public static final String SOURCE = "source";
    public static final String SOURCE_1 = "1";
    public static final String SOURCE_2 = "2";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners("btn_ok", "btn_cancel");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ComboEdit comboEdit = (ComboEdit)this.getControl(SOURCE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6", (String)"DimensionMappingPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0])), SOURCE_1));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6", (String)"DimensionMappingPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0])), SOURCE_2));
        comboEdit.setComboItems(items);
        this.getView().updateView(SOURCE);
        String isFloat = (String)this.getView().getFormShowParameter().getCustomParam("isfloat");
        if (StringUtils.isEmpty((String)isFloat)) {
            return;
        }
        if (StringUtils.equals((String)isFloat, (String)String.valueOf(DimmensionMappingEnum.FLOAT.index)) || StringUtils.equals((String)isFloat, (String)String.valueOf(DimmensionMappingEnum.UNFLOAT.index))) {
            this.getModel().setValue(SOURCE, (Object)SOURCE_1);
            this.buildAsstactType();
        } else if (StringUtils.equals((String)isFloat, (String)String.valueOf(DimmensionMappingEnum.COMMON.index))) {
            this.getModel().setValue(SOURCE, (Object)SOURCE_2);
            this.buildCommonAssists();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (StringUtil.equals((String)propertyName, (String)SOURCE)) {
            String source;
            this.getModel().deleteEntryData(ENTRYENTITY);
            switch (source = (String)this.getModel().getValue(SOURCE)) {
                case "1": {
                    this.buildAsstactType();
                    break;
                }
                case "2": {
                    this.buildCommonAssists();
                    break;
                }
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        int row = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        if ("btn_ok".equals(key)) {
            DynamicObject selectedRow = this.getModel().getEntryRowEntity(ENTRYENTITY, row);
            this.getView().returnDataToParent((Object)selectedRow);
            this.getView().close();
        }
    }

    private void buildAsstactType() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accounttablenumber"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accounttablename"});
        String selectFields = "id,number,name";
        DynamicObjectCollection assts = QueryServiceHelper.query((String)"bd_asstacttype", (String)selectFields, (QFilter[])new QFilter[0], (String)"number");
        if (assts == null || assts.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        int size = assts.size();
        int[] rows = model.batchCreateNewEntryRow(ENTRYENTITY, size);
        int index = 0;
        for (DynamicObject dynamicObject : assts) {
            int rowNum = rows[index];
            model.setValue("asstid", (Object)dynamicObject.getLong("id"), rowNum);
            model.setValue("number", (Object)dynamicObject.getString("number"), rowNum);
            model.setValue("name", (Object)dynamicObject.getString("name"), rowNum);
            model.setValue("childsource", model.getValue(SOURCE), rowNum);
            ++index;
        }
    }

    private void buildCommonAssists() {
        List commonAssists;
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accounttablenumber"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"accounttablename"});
        try {
            commonAssists = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"CommonAssistService", (String)"getCommonAssist", (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u603b\u8d26\u5e94\u7528\u7684\u7248\u672c\u3002", (String)"CommonAssistPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        IDataModel model = this.getModel();
        int size = commonAssists.size();
        if (size == 0) {
            return;
        }
        int[] rows = model.batchCreateNewEntryRow(ENTRYENTITY, size);
        int index = 0;
        for (Map commonAssist : commonAssists) {
            int rowNum = rows[index];
            model.setValue("number", commonAssist.get("commonAssistNumber"), rowNum);
            model.setValue("name", commonAssist.get("commonAssistName"), rowNum);
            model.setValue("accounttablenumber", commonAssist.get("accountTableNumber"), rowNum);
            model.setValue("accounttablename", commonAssist.get("accountTableName"), rowNum);
            model.setValue("commonassistkey", commonAssist.get("commonAssistKey"), rowNum);
            model.setValue("childsource", model.getValue(SOURCE), rowNum);
            ++index;
        }
    }
}

