/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.FilterDimensionEntry;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimPropEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.DefaultPageDimSettingUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.PageDimSelectTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.report.multi.ModelDataProvider;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import org.apache.commons.collections.CollectionUtils;

public class PageDimMemSetPlugin
extends AbstractBasePlugIn
implements SingleMemberF7Util.ISingleMemberF7Handle,
BeforeF7SelectListener {
    private static final String entryentity = "entryentity";
    private static final String PAGEDIM_COL = "pagedim";
    private static final String PAGEDIM_NAME_COL = "pagedim2";
    private static final String MEMBER_COL = "member";
    private static final String CODEMAPPINGCONTROL = "codemappingcontrol";
    private static final String CODEMAPPINGMEMBER = "codemappingmember";

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"bar_cancel", "bar_confirm"});
    }

    private void cacheObject(String key, Object o) {
        this.getPageCache().put(key, ObjectSerialUtil.toByteSerialized((Object)o));
    }

    private List<String> getDimNums() {
        if (Objects.nonNull(this.getPageCache().get(CODEMAPPINGCONTROL))) {
            return (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(CODEMAPPINGCONTROL));
        }
        return new ArrayList<String>(16);
    }

    private Map<String, DynamicObject> getDimDyo() {
        if (Objects.nonNull(this.getPageCache().get(CODEMAPPINGMEMBER))) {
            return (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(CODEMAPPINGMEMBER));
        }
        return new HashMap<String, DynamicObject>(16);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        List filterDimensionEntries;
        List dims;
        int rowIndex = beforeF7SelectEvent.getRow();
        List<String> dimNums = this.getDimNums();
        String dimNum = dimNums.get(rowIndex);
        DynamicObject dyo = this.getDimDyo().get(dimNum);
        Long dimId = 0L;
        String dimName = "";
        if (Objects.nonNull(dyo)) {
            dimId = dyo.getLong("id");
            dimName = dyo.getString("name");
        }
        String caption = String.format(ResManager.loadKDString((String)"%s\u6210\u5458", (String)"PageDimMemSetPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimName);
        beforeF7SelectEvent.getFormShowParameter().setCaption(caption);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        String entityName = this.getModel().getValue(PAGEDIM_COL, rowIndex).toString();
        qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
        TemplateModel templateModel = ModelDataProvider.getTemplateModel(this.getTemplateId());
        qFilterList.add(TemplateUtil.getTemplatePageMemberFilter((String)dimNum, (long)dimId, (TemplateModel)templateModel));
        qFilterList.add(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.LABEL.index));
        if ("bcm_currencymembertree".equals(entityName)) {
            qFilterList.add(new QFilter("number", "!=", (Object)"PC"));
        }
        if (!(dims = (filterDimensionEntries = templateModel.getFilterDimensionEntries()).stream().map(e -> e.getDimension().getNumber()).collect(Collectors.toList())).contains(dimNum)) {
            qFilterList.add(new QFilter("isleaf", "=", (Object)"1"));
        }
        qFilterList.add(new QFilter("dimension.id", "=", (Object)dimId));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null) {
            this.getModel().setItemValueByID(MEMBER_COL, (Object)((DynamicObject)closedCallBackEvent.getReturnData()).getLong("id"), Integer.parseInt(this.getPageCache().get("selectrow")));
        }
        this.getPageCache().put("isBeforeInit", null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ItemClassEdit fieldEdit = (ItemClassEdit)this.getView().getControl(MEMBER_COL);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("bar_confirm".equals(key)) {
            String message = this.checkNotNuLll();
            if (StringUtils.isNotEmpty((String)message)) {
                this.getView().showTipNotification(message);
                return;
            }
            DynamicObjectCollection dcs = this.getModel().getEntryEntity(entryentity);
            StringBuilder msg = new StringBuilder();
            String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
            for (DynamicObject e : dcs) {
                msg.append(e.getString("member.name")).append(',');
                String entityname = e.getString(PAGEDIM_COL);
                IDNumberTreeNode treeNode = MemberReader.findMemberById((String)modelNum, (String)entityname, (Long)e.getDynamicObject(MEMBER_COL).getLong("id"));
                if (treeNode != IDNumberTreeNode.NotFoundTreeNode && StorageTypeEnum.LABEL != treeNode.getStorageType()) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ef4\u5ea6\u6210\u5458\u7ec4\u5408\u4e2d\u5305\u542b\u201c\u6807\u7b7e\u201d\u5b58\u50a8\u7c7b\u578b\u7684\u6210\u5458\u3002", (String)"PageDimMemSetPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.saveData();
            if (msg.length() > 0) {
                msg.deleteCharAt(msg.length() - 1);
            }
            msg.append("||").append(this.getPageCache().get("templatenumber"));
            String orgNumber = this.getOrgNumber();
            if (StringUtils.isNotEmpty((String)orgNumber)) {
                msg.append("||").append(orgNumber);
            }
            this.getView().returnDataToParent((Object)msg.toString());
            this.getView().close();
        } else {
            this.getView().close();
        }
    }

    private String getOrgNumber() {
        Object param = this.getView().getFormShowParameter().getCustomParam("orgnumber");
        if (param instanceof String) {
            return param.toString();
        }
        return "";
    }

    public void afterCreateNewData(EventObject e) {
        this.loadData();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"template"});
        if (this.getOrgId() != 0L) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"clear"});
        }
    }

    private void loadData() {
        HashSet<Long> ids;
        String entityName;
        DynamicObject dimDyo;
        String dimNum;
        long modelId = this.getModelId();
        this.getModel().setValue("model", (Object)modelId);
        long templateId = this.getTemplateId();
        TemplateModel template = ModelDataProvider.getTemplateModel(templateId);
        this.getModel().setValue("template", (Object)templateId);
        this.getPageCache().put("templatenumber", template.getNumber());
        HashMap<String, Long> tempPageSelects = new HashMap<String, Long>(16);
        HashMap<String, Long> orgTempPageSelects = new HashMap<String, Long>(16);
        this.getExitPageSelects(tempPageSelects, orgTempPageSelects, PageDimSelectTypeEnum.PAGEDIM.index);
        Map dimMap = MemberReader.getDimDyoByModelId((long)modelId);
        HashSet notSetDims = Sets.newHashSet((Object[])new String[]{DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber()});
        int row = 0;
        ArrayList<String> dims = new ArrayList<String>(16);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        for (PageDimensionEntry pDimEntry : template.getPageDimensionEntries()) {
            dimNum = pDimEntry.getDimension().getNumber();
            if (notSetDims.contains(dimNum) || !Objects.nonNull(dimDyo = (DynamicObject)dimMap.get(dimNum))) continue;
            dims.add(dimNum);
            map.put(dimNum, dimDyo);
            entityName = dimDyo.getString("membermodel");
            ids = new HashSet<Long>(16);
            for (Member e : pDimEntry.getMembers()) {
                new MembRangeItem(entityName, Long.valueOf(e.getId()), e.getNumber(), e.getScope(), false, (Object)modelId).matchItems(c -> ids.add((Long)c.getId()));
            }
            this.getModel().getEntryRowEntity(entryentity, row);
            this.commonAction(dimDyo, ids, row, tempPageSelects, orgTempPageSelects);
            row = this.getModel().createNewEntryRow(entryentity);
        }
        for (PageDimPropEntry pPropEntry : template.getPagePropEntries()) {
            dimNum = pPropEntry.getDimension().getNumber();
            if (notSetDims.contains(dimNum) || !Objects.nonNull(dimDyo = (DynamicObject)dimMap.get(dimNum))) continue;
            dims.add(dimNum);
            map.put(dimNum, dimDyo);
            entityName = dimDyo.getString("membermodel");
            ids = new HashSet(16);
            for (MembProperty membProperty : pPropEntry.getAllMembProperties()) {
                new MembRangeItem(entityName, Long.valueOf(membProperty.getId()), membProperty.getNumber(), membProperty.getScope(), true, (Object)modelId).matchItems(c -> ids.add((Long)c.getId()));
            }
            this.commonAction(dimDyo, ids, row, tempPageSelects, orgTempPageSelects);
            row = this.getModel().createNewEntryRow(entryentity);
        }
        HashMap<String, Long> tempFilterSelects = new HashMap<String, Long>(16);
        HashMap<String, Long> orgTempFilterSelects = new HashMap<String, Long>(16);
        this.getExitPageSelects(tempFilterSelects, orgTempFilterSelects, PageDimSelectTypeEnum.FILTERDIM.index);
        for (FilterDimensionEntry filterDimensionEntry : template.getFilterDimensionEntries()) {
            Long memberId;
            String dimNum2 = filterDimensionEntry.getDimension().getNumber();
            DynamicObject dimDyo2 = (DynamicObject)dimMap.get(dimNum2);
            if (!Objects.nonNull(dimDyo2)) continue;
            dims.add(dimNum2);
            map.put(dimNum2, dimDyo2);
            String entityName2 = dimDyo2.getString("membermodel");
            ArrayList ids2 = new ArrayList(16);
            for (Member e : filterDimensionEntry.getMembers()) {
                new MembRangeItem(entityName2, Long.valueOf(e.getId()), e.getNumber(), e.getScope(), false, (Object)modelId).matchItems(c -> ids2.add(c.getId()));
            }
            this.getModel().getEntryRowEntity(entryentity, row);
            this.getModel().setValue(PAGEDIM_COL, (Object)entityName2, row);
            this.getModel().setValue(PAGEDIM_NAME_COL, (Object)dimDyo2.getString("name"), row);
            Long id = 0L;
            if (orgTempFilterSelects.containsKey(dimNum2)) {
                memberId = (Long)orgTempFilterSelects.get(dimNum2);
                if (ids2.contains(memberId)) {
                    id = memberId;
                }
            } else if (tempFilterSelects.containsKey(dimNum2)) {
                memberId = (Long)tempFilterSelects.get(dimNum2);
                if (ids2.contains(memberId)) {
                    id = memberId;
                }
            } else if (!ids2.isEmpty()) {
                id = (Long)ids2.get(0);
            }
            this.getModel().setValue(MEMBER_COL, (Object)id, row);
            this.getModel().setValue("type", (Object)"1", row);
            row = this.getModel().createNewEntryRow(entryentity);
        }
        this.cacheObject(CODEMAPPINGCONTROL, dims);
        this.cacheObject(CODEMAPPINGMEMBER, map);
        this.getModel().deleteEntryRow(entryentity, row);
    }

    private void commonAction(DynamicObject dimDyo, Set<Long> ids, int row, Map<String, Long> tempPageSelects, Map<String, Long> orgTempPageSelects) {
        Long memberId = null;
        long modelId = this.getModelId();
        boolean isFromTemp = this.getOrgId() == 0L;
        String dimName = dimDyo.getString("name");
        String entityName = dimDyo.getString("membermodel");
        String dimNum = dimDyo.getString("number");
        if (Arrays.asList("bcm_audittrialmembertree", "bcm_processmembertree").contains(entityName)) {
            memberId = this.getDefaultMemberId(entityName, dimNum, modelId);
            this.getView().setEnable(Boolean.valueOf(false), row, new String[]{MEMBER_COL});
        } else {
            Map<String, Long> result = isFromTemp ? tempPageSelects : (orgTempPageSelects.isEmpty() ? tempPageSelects : orgTempPageSelects);
            memberId = Objects.nonNull(result.get(dimNum)) ? result.get(dimNum) : this.getDefaultMemberId(entityName, dimNum, modelId);
            if (!ids.contains(memberId)) {
                memberId = null;
            }
        }
        this.getModel().setValue(PAGEDIM_COL, (Object)entityName, row);
        this.getModel().setValue(PAGEDIM_NAME_COL, (Object)dimName, row);
        this.getModel().setValue(MEMBER_COL, (Object)memberId, row);
        this.getModel().setValue("type", (Object)"0", row);
    }

    private Long getDefaultMemberId(String entityNum, String dimNum, Long modelId) {
        Long id = null;
        String number = "";
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        switch (entityNum) {
            case "bcm_accountmembertree": {
                break;
            }
            case "bcm_changetypemembertree": {
                if (!MemberReader.isExistChangeTypeDimension((String)modelNum)) break;
                number = "EndingBalance";
                break;
            }
            case "bcm_audittrialmembertree": {
                number = "EntityInput";
                break;
            }
            case "bcm_processmembertree": {
                number = "EIRpt";
                break;
            }
            case "bcm_icmembertree": {
                number = "ICNone";
                break;
            }
            case "bcm_mycompanymembertree": {
                number = "MCNone";
                break;
            }
            case "bcm_rulemembertree": {
                number = "PRCGAAP";
                break;
            }
            case "bcm_currencymembertree": {
                number = "DC";
                break;
            }
            case "bcm_datasortmembertree": {
                number = "Actual";
                break;
            }
            case "bcm_userdefinedmembertree": {
                number = this.getDefaultDefineNumber(dimNum, modelId);
                break;
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)number)) {
            id = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)number).getId();
        }
        return id;
    }

    private String getDefaultDefineNumber(String dimNum, long modelId) {
        DynamicObject dy = (DynamicObject)MemberReader.getDimDyoByModelId((long)modelId).get(dimNum);
        String noneNumber = "";
        if (Objects.nonNull(dy)) {
            noneNumber = dy.getString("shortnumber") + "None";
        }
        return noneNumber;
    }

    private void getExitPageSelects(Map<String, Long> tempPageSelects, Map<String, Long> orgTempPageSelects, char type) {
        DynamicObjectCollection pageDimSetting = DefaultPageDimSettingUtil.getPageDimSetting(Collections.singleton(this.getTemplateId()), Collections.singleton(this.getOrgId()), null, (char)type);
        if (CollectionUtils.isNotEmpty((Collection)pageDimSetting)) {
            pageDimSetting.forEach(dyo -> {
                if (dyo.getLong("org.id") == 0L) {
                    tempPageSelects.put(dyo.getString("dimension.number"), dyo.getLong(MEMBER_COL));
                } else {
                    orgTempPageSelects.put(dyo.getString("dimension.number"), dyo.getLong(MEMBER_COL));
                }
            });
        }
    }

    private long getEntityId(String key) {
        Object modelId = this.getView().getFormShowParameter().getCustomParam(key);
        if (modelId instanceof Long) {
            return LongUtil.toLong((Object)modelId);
        }
        return 0L;
    }

    private long getModelId() {
        return this.getEntityId("modelId");
    }

    private long getTemplateId() {
        return this.getEntityId("pkId");
    }

    private long getOrgId() {
        return this.getEntityId("orgid");
    }

    @Override
    public void beforeSingleMemberF7Select(BeforeF7SelectEvent arg0) {
        DynamicObject modelF7 = (DynamicObject)this.getModel().getValue("model");
        if (modelF7 == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"PageDimMemSetPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private String checkNotNuLll() {
        DynamicObjectCollection dcs = this.getModel().getEntryEntity(entryentity);
        boolean isNull = false;
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject dy : dcs) {
                if (dy.getDynamicObject(MEMBER_COL) != null) continue;
                isNull = true;
            }
        }
        if (isNull) {
            return ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PageDimMemSetPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private void saveData() {
        boolean isNeedClear = (Boolean)this.getModel().getValue("clear");
        long templateId = this.getTemplateId();
        QFilter filter = new QFilter("template", "=", (Object)templateId);
        long orgId = this.getOrgId();
        QFilter orgfilter = new QFilter("org", "=", (Object)orgId);
        if (isNeedClear) {
            orgfilter = new QFilter("1", "=", (Object)1);
        }
        DeleteServiceHelper.delete((String)"bcm_pageselect", (QFilter[])new QFilter[]{filter, orgfilter});
        ArrayList list = new ArrayList(16);
        DynamicObjectCollection dcs = this.getModel().getEntryEntity(entryentity);
        if (CollectionUtils.isEmpty((Collection)dcs)) {
            return;
        }
        Map<String, DynamicObject> map = this.getDimDyo();
        List<String> dimNums = this.getDimNums();
        dcs.forEach(dy -> {
            DynamicObject dyObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_pageselect");
            if (dimNums.size() == dcs.size()) {
                String dimNum = (String)dimNums.get(dcs.indexOf(dy));
                Long dimId = 0L;
                if (Objects.nonNull(map.get(dimNum))) {
                    dimId = ((DynamicObject)map.get(dimNum)).getLong("id");
                }
                dyObj.set("dimension", (Object)dimId);
                dyObj.set(MEMBER_COL, (Object)dy.getDynamicObject(MEMBER_COL).getLong("id"));
                dyObj.set("template", (Object)templateId);
                dyObj.set("org", (Object)orgId);
                dyObj.set("type", (Object)dy.getString("type"));
                list.add(dyObj);
            }
        });
        if (list.isEmpty()) {
            return;
        }
        BusinessDataServiceHelper.save((IDataEntityType)((DynamicObject)list.get(0)).getDataEntityType(), (Object[])list.toArray());
        String opName = ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570-\u9875\u9762\u7ef4\u6210\u5458\u8bbe\u7f6e", (String)"PageDimMemSetPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        long modelId = this.getModelId();
        TemplateModel templateModel = TemplateServiceHelper.getTemplateModelById((Object)templateId);
        String templateNum = templateModel == null ? "" : templateModel.getNumber();
        IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        String opDescription = String.format(ResManager.loadKDString((String)"\u6309\u6a21\u677f %s \u9875\u9762\u7ef4\u6210\u5458\u4fdd\u5b58\u6210\u529f", (String)"PageDimMemSetPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), templateNum);
        if (isNeedClear) {
            opDescription = String.format(ResManager.loadKDString((String)"\u6309\u6a21\u677f %s \u9875\u9762\u7ef4\u6210\u5458\u4fdd\u5b58\u6210\u529f\uff08\u8986\u76d6\u7ec4\u7ec7\u516c\u5f0f\u53d6\u6570\u8bbe\u7f6e\uff09", (String)"PageDimMemSetPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), templateNum);
        } else if (entity != IDNumberTreeNode.NotFoundTreeNode) {
            String orgNum = entity.getNumber();
            opDescription = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 %1s \u6a21\u677f %2s \u9875\u9762\u7ef4\u6210\u5458\u4fdd\u5b58\u6210\u529f", (String)"PageDimMemSetPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), orgNum, templateNum);
        }
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescription, (Long)modelId, (String)this.getModel().getDataEntityType().getName());
        OperationLogUtil.writeOperationLog((AppLogInfo)logInfo);
    }
}

