/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public class ReferenceMappingPlugin
extends AbstractBaseListPlugin {
    public static final String ENTRYENTITY = "entryentity";
    public static final String FIELD_REFSOURCE = "refsource";
    public static final String FIELD_INTEGRATION = "integration";
    public static final String FIELD_SCHEME = "scheme";
    public static final String REF_TYPE_1 = "1";
    public static final String REF_TYPE_2 = "2";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners("btn_ok", "btn_cancel", FIELD_INTEGRATION);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtil.equals((String)key, (String)FIELD_INTEGRATION)) {
            Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bcm_integration_list");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("model", (Object)modelId);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIELD_INTEGRATION));
            this.getView().showForm(formShowParameter);
        } else if ("btn_ok".equals(key)) {
            int[] selectIndexs = ((EntryGrid)this.getView().getControl(ENTRYENTITY)).getSelectRows();
            if (selectIndexs == null || selectIndexs.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u65b9\u6848\u518d\u64cd\u4f5c\u3002", (String)"ISSchemeListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return;
            }
            DynamicObject dobj = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(selectIndexs[0]);
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            String refType = (String)this.getModel().getValue(FIELD_REFSOURCE);
            returnMap.put("refType", refType);
            if (StringUtil.equals((String)refType, (String)REF_TYPE_1)) {
                returnMap.put("refid", dobj.getLong("recordid"));
                String showMsg = String.format(ResManager.loadKDString((String)"\u516c\u5171\u6620\u5c04\uff1a%1$s->%2$s", (String)"DimensionMappingPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dobj.getString("owndim"), dobj.getString("otherdim"));
                returnMap.put("refdesc", showMsg);
            } else if (StringUtil.equals((String)refType, (String)REF_TYPE_2)) {
                returnMap.put("refid", ((DynamicObject)this.getModel().getValue(FIELD_SCHEME)).getLong("id"));
                returnMap.put("refdetailid", dobj.getLong("recordid"));
                String showMsg = String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\uff1a%1$s %2$s->%3$s", (String)"DimensionMappingPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ((DynamicObject)this.getModel().getValue(FIELD_SCHEME)).getString("number"), dobj.getString("owndimname"), dobj.getString("otherdimname"));
                returnMap.put("refdesc", showMsg);
            }
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if (FIELD_INTEGRATION.equals(actionId)) {
            IDataModel model = this.getModel();
            model.deleteEntryData(ENTRYENTITY);
            Object schemeId = returnData;
            model.setValue(FIELD_SCHEME, schemeId);
            DynamicObject scheme = (DynamicObject)model.getValue(FIELD_SCHEME);
            if (scheme == null) {
                return;
            }
            this.showIntegrationDetail(scheme);
        }
    }

    private void showIntegrationDetail(DynamicObject scheme) {
        IDataModel model = this.getModel();
        model.setValue(FIELD_INTEGRATION, (Object)scheme.getString("name"));
        QFilter[] filters = new QFilter[]{new QFilter(FIELD_SCHEME, "=", scheme.getPkValue())};
        DynamicObjectCollection dimCollection = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,number,name", (QFilter[])filters);
        if (dimCollection == null || dimCollection.size() == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dimCollection) {
            String[] numbers = ((String)dynamicObject.get("number")).split("-");
            String[] name = ((String)dynamicObject.get("name")).split("-");
            if (numbers.length != 2 || name.length != 2) continue;
            int rowNum = model.createNewEntryRow(ENTRYENTITY);
            model.setValue("owndimnum", (Object)numbers[0], rowNum);
            model.setValue("owndimname", (Object)name[0], rowNum);
            model.setValue("otherdimnum", (Object)numbers[1], rowNum);
            model.setValue("otherdimname", (Object)name[1], rowNum);
            model.setValue("recordid", dynamicObject.get("id"), rowNum);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ComboEdit comboEdit = (ComboEdit)this.getControl(FIELD_REFSOURCE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u516c\u5171\u6620\u5c04", (String)"DimensionMappingPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0])), REF_TYPE_1));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848", (String)"DimensionMappingPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0])), REF_TYPE_2));
        comboEdit.setComboItems(items);
        this.getView().updateView(FIELD_REFSOURCE);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_INTEGRATION});
        String refType = (String)this.getView().getFormShowParameter().getCustomParam("reftype");
        if (StringUtils.isEmpty((String)refType)) {
            return;
        }
        this.getModel().setValue(FIELD_REFSOURCE, (Object)refType);
        if (StringUtils.equals((String)refType, (String)REF_TYPE_1)) {
            this.initCommonRef();
        } else if (StringUtils.equals((String)refType, (String)REF_TYPE_2)) {
            this.showRefType2Field();
            String schemeId = (String)this.getView().getFormShowParameter().getCustomParam("refid");
            this.getModel().setValue(FIELD_SCHEME, (Object)schemeId);
            DynamicObject scheme = (DynamicObject)this.getModel().getValue(FIELD_SCHEME);
            if (scheme == null) {
                return;
            }
            this.showIntegrationDetail(scheme);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (StringUtil.equals((String)propertyName, (String)FIELD_REFSOURCE)) {
            String source;
            this.getModel().deleteEntryData(ENTRYENTITY);
            switch (source = (String)this.getModel().getValue(FIELD_REFSOURCE)) {
                case "1": {
                    this.initCommonRef();
                    break;
                }
                case "2": {
                    this.showRefType2Field();
                    break;
                }
            }
        }
    }

    private void initCommonRef() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_INTEGRATION, "owndimnum", "owndimname", "otherdimnum", "otherdimname"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"owndim", "otherdim"});
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bcm_bdmapping", (String)"id,entryentity.entryid, entryentity.config,entryentity.dimension", (QFilter[])new QFilter[]{filter});
        if (dyns == null || dyns.length == 0) {
            return;
        }
        IDataModel model = this.getModel();
        for (DynamicObject dyn : dyns) {
            DynamicObjectCollection doc = (DynamicObjectCollection)dyn.get(ENTRYENTITY);
            for (DynamicObject d : doc) {
                int rowNum = model.createNewEntryRow(ENTRYENTITY);
                model.setValue("owndim", (Object)d.getString("dimension.name"), rowNum);
                model.setValue("otherdim", (Object)d.getString("config.name"), rowNum);
                model.setValue("recordid", (Object)d.getString("id"), rowNum);
            }
        }
    }

    private void showRefType2Field() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{FIELD_INTEGRATION, "owndimnum", "owndimname", "otherdimnum", "otherdimname"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"owndim", "otherdim"});
    }
}

