/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.config.ProcessSelectionEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class RptParamConfigPlugin
extends AbstractBaseFormPlugin {
    private static final String ENTITY = "entity";
    private static final String RANGE_VALUE = "rangevalue";
    private static final String CHECK_REPORT = "checkreport";
    private static final String PROCESS_SELECTION = "processselection";
    public static final String SELECT_ORG_ENTITY_ID = "dentity";

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getProperty(SELECT_ORG_ENTITY_ID) != null) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(SELECT_ORG_ENTITY_ID);
            Set collect = entryEntity.stream().map(entity -> Long.parseLong(entity.getString("oid"))).collect(Collectors.toSet());
            List definedDynamicObjects = QueryMemberDetailsHelper.getDefinedPropertyByIds(collect);
            Map<String, String> id2PidMap = definedDynamicObjects.stream().collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy.getString("propertyid.id")));
            for (int i = 0; i < entryEntity.size(); ++i) {
                String pid = id2PidMap.get(((DynamicObject)entryEntity.get(i)).getString("oid"));
                if (null == pid) continue;
                this.getModel().setValue("pid", (Object)pid, i);
            }
            DynamicObject cm018Info = this.getCM018Info();
            this.getModel().setValue(CHECK_REPORT, (Object)cm018Info.getBoolean("config"));
            this.getModel().setValue(PROCESS_SELECTION, (Object)this.getProcessSelection(cm018Info));
            this.getView().setEnable(Boolean.valueOf(cm018Info.getBoolean("config")), new String[]{PROCESS_SELECTION});
            this.getModel().setDataChanged(false);
        }
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnsave"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap"});
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"scenario", "initperiodstatus"});
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"name"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"description"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
        }
        Object description = this.getModel().getValue("description");
        if (!StringUtils.equals((CharSequence)ConfigEnum.CM018.getDescription(), (CharSequence)(Objects.nonNull(description) ? description.toString() : ""))) {
            this.getModel().setValue("description", (Object)ConfigEnum.CM018.getDescription());
        }
    }

    private String getProcessSelection(DynamicObject cm018Info) {
        JSONObject json;
        if (cm018Info.getDataEntityType().getProperties().containsKey((Object)"json") && (json = JSONObjectUtil.parseObjectOrder((String)cm018Info.getString("json"))) != null && json.get((Object)PROCESS_SELECTION) != null) {
            return json.get((Object)PROCESS_SELECTION).toString();
        }
        return ProcessSelectionEnum.REPORTCOMMIT.getValue();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ConfigEnum configDataByNumber = ConfigEnum.getConfigDataByNumber((String)"CM018");
        this.getModel().setValue("number", (Object)configDataByNumber.getNumber());
        this.getModel().setValue("name", (Object)configDataByNumber.getName());
        this.getModel().setValue("description", (Object)configDataByNumber.getDescription());
        this.getModel().setValue("model", (Object)this.getModelId());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("addrow", "deleterow", "btnsave");
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "!=", (Object)SysDimensionEnum.Scenario.getNumber());
        beforeF7SelectEvent.getCustomQFilters().add(qFilter);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (propertyName.equalsIgnoreCase(CHECK_REPORT)) {
            Boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
            this.getView().setEnable(newValue, new String[]{PROCESS_SELECTION});
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnsave": {
                this.save();
                break;
            }
            case "addrow": {
                this.showSelectOrgView();
                break;
            }
            case "deleterow": {
                this.deleteOrgMember();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection olddoc = this.getModel().getEntryEntity(SELECT_ORG_ENTITY_ID);
        switch (actionId) {
            case "selectmember": {
                if (e.getReturnData() == null) break;
                DynamicObjectCollection newdoc = (DynamicObjectCollection)e.getReturnData();
                this.selectOrgMember(olddoc, newdoc);
            }
        }
    }

    private void selectOrgMember(DynamicObjectCollection olddoc, DynamicObjectCollection newdoc) {
        IDataModel model = this.getModel();
        boolean isexist = false;
        HashSet<Integer> list = new HashSet<Integer>(16);
        EntryGrid eg = (EntryGrid)this.getControl(SELECT_ORG_ENTITY_ID);
        int[] rows = eg.getSelectRows();
        for (DynamicObject newone : newdoc) {
            isexist = false;
            for (DynamicObject oldone : olddoc) {
                if (!newone.get(4).equals(oldone.get("oid")) || !newone.get(5).equals(oldone.get(RANGE_VALUE))) continue;
                isexist = true;
                break;
            }
            if (isexist) continue;
            int index = model.createNewEntryRow(SELECT_ORG_ENTITY_ID);
            model.setValue(ENTITY, newone.get(3), index);
            model.setValue(RANGE_VALUE, newone.get(5), index);
            model.setValue("oid", newone.get(4), index);
            model.setValue("pid", newone.get(6), index);
            model.setValue("num", newone.get(2), index);
            list.add(index);
        }
        for (Object t : (Object)rows) {
            list.add((int)t);
        }
        if (list.size() == 0) {
            return;
        }
        rows = new int[list.size()];
        int index = 0;
        for (Integer row : list) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }

    private void showSelectOrgView() {
        long modelId = this.getModelId();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_dis");
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"RptParamConfigPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectmember");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void deleteOrgMember() {
        EntryGrid eg = (EntryGrid)this.getControl(SELECT_ORG_ENTITY_ID);
        int[] row = eg.getEntryState().getSelectedRows();
        if (row.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c\u3002", (String)"RptParamConfigPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(SELECT_ORG_ENTITY_ID, row);
    }

    private void save() {
        Boolean checkReport = (Boolean)this.getModel().getValue(CHECK_REPORT);
        String processSelection = (String)this.getModel().getValue(PROCESS_SELECTION);
        HashMap<String, String> json = new HashMap<String, String>(1);
        json.put(PROCESS_SELECTION, processSelection);
        QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)"CM018").add("model", "=", (Object)this.getModelId());
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_configsetting", (String)"id,config,number,modifytime,modifier,json", (QFilter[])qfBuilder.toArray());
        if (checkReport.booleanValue()) {
            dy.set("config", (Object)"1");
        } else {
            dy.set("config", (Object)"0");
        }
        dy.set("json", (Object)new JSONObject(json).toJSONString());
        dy.set("modifytime", (Object)TimeServiceHelper.now());
        dy.set("modifier", (Object)this.getUserId());
        SaveServiceHelper.update((DynamicObject)dy);
        ConfigServiceHelper.remove((Long)this.getModelId(), (String)"CM018");
        this.getModel().setDataChanged(false);
        this.getView().invokeOperation("save");
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"RptParamConfigPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().close();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.beforeSaveCheck();
    }

    private void beforeSaveCheck() {
        DynamicObjectCollection dentity = this.getModel().getEntryEntity(SELECT_ORG_ENTITY_ID);
        for (int i = 0; i < dentity.size(); ++i) {
            if (this.getModel().getValue("pid", i).toString().trim().isEmpty() || !this.getModel().getValue(RANGE_VALUE, i).equals("110") && !this.getModel().getValue(RANGE_VALUE, i).equals("90")) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7ec4\u7ec7\u201c%2$s\u201d\u4e3a\u81ea\u5b9a\u4e49\u5c5e\u6027\uff0c\u4e0d\u80fd\u9009\u62e9\u201c\u6240\u6709_\u4ec5\u660e\u7ec6\u6210\u5458\u201d\u6216\u201c\u6240\u6709_\u4ec5\u975e\u660e\u7ec6\u6210\u5458\u201d\u8303\u56f4\u3002", (String)"RptParamConfigPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1, this.getModel().getValue(ENTITY, i)));
        }
    }

    private DynamicObject getCM018Info() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId()).and("number", "=", (Object)"CM018");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_configsetting", (String)"id, number, config, json", (QFilter[])qFilter.toArray());
        return dynamicObject;
    }
}

