/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.api;

import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.sql.MDResultSetReader;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.model.ModelOlapDataOpeLogEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.intergration.util.EADataPushUtil;
import kd.fi.bcm.task.common.OperatorHelper;
import kd.fi.bcm.task.common.PlanParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.StringUtils;

public class EADataPushApi {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(EADataPushApi.class);
    private static final String DIM_KEY = "dimKey";
    private static final String FIELD_SCOPE = "scope";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_FMONEY = "FMONEY";
    private static final String EA_TABLE_KEY_PREFIX = "EA_TABLE_KEY_PREFIX_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> sendOlapDataToDb(PlanParam planParam) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        String opeSucess = ResManager.loadKDString((String)"\u6210\u529f", (String)"EADataPushApi_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String opeFail = ResManager.loadKDString((String)"\u5931\u8d25", (String)"EADataPushApi_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        Map dimMap = (Map)SerializationUtils.fromJsonString((String)planParam.getParamSetting(), Map.class);
        Long executor = planParam.getExecutor();
        String curAppId = kd.bos.util.StringUtils.isEmpty((String)((String)dimMap.get("appid"))) ? ApplicationTypeEnum.CM.getAppnum() : (String)dimMap.get("appid");
        String pushScheme = (String)dimMap.get("datapushscheme");
        if (StringUtils.isEmpty((String)pushScheme) || "0".equals(pushScheme)) {
            result.put("msg", String.format(ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c\uff1a%1$s\uff0c\u8be6\u60c5\uff1a%2$s", (String)"EADataPushApi_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opeFail, "pushScheme is null"));
            return result;
        }
        if (executor == 0L) {
            result.put("msg", String.format(ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c\uff1a%1$s\uff0c\u8be6\u60c5\uff1a%2$s", (String)"EADataPushApi_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opeFail, "executor is null"));
            return result;
        }
        if (StringUtils.isEmpty((String)curAppId)) {
            result.put("msg", String.format(ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c\uff1a%1$s\uff0c\u8be6\u60c5\uff1a%2$s", (String)"EADataPushApi_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opeFail, "curAppId is null"));
            return result;
        }
        long schemeId = Long.parseLong(pushScheme);
        DynamicObject scheDy = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_ea_datapushschemdata");
        Object model = scheDy.get("model");
        long modelId = model instanceof DynamicObject ? ((DynamicObject)model).getLong("id") : ((Long)model).longValue();
        ApplicationTypeEnum appEnum = EADataPushApi.getAppById(curAppId);
        if (appEnum == null) {
            result.put("msg", String.format(ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c\uff1a%1$s\uff0c\u8be6\u60c5\uff1a%2$s", (String)"EADataPushApi_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opeFail, String.format(ResManager.loadKDString((String)"\u5e94\u7528\u6807\u8bc6\u65e0\u6cd5\u8bc6\u522b %s", (String)"EADataPushApi_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), curAppId)));
            return result;
        }
        if (!MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)appEnum).contains(modelId)) {
            result.put("msg", String.format(ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c\uff1a%1$s\uff0c\u8be6\u60c5\uff1a%2$s", (String)"EADataPushApi_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opeFail, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u4f53\u7cfb\u7684\u7ba1\u7406\u6743\uff0c\u8bf7\u6388\u6743\u540e\u91cd\u8bd5", (String)"EADataPushApi_9", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            return result;
        }
        String msg = EADataPushApi.checkScheDy(scheDy);
        if (StringUtils.isNotEmpty((String)msg)) {
            result.put("msg", String.format(ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c\uff1a%1$s\uff0c\u8be6\u60c5\uff1a%2$s", (String)"EADataPushApi_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opeFail, msg));
            return result;
        }
        String tablename = scheDy.getString("tablename");
        Object key = AppCacheServiceHelper.get((String)(EA_TABLE_KEY_PREFIX + tablename));
        if (key != null && !"".equals(key.toString())) {
            result.put("msg", String.format(ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c\uff1a%1$s\uff0c\u8be6\u60c5\uff1a%2$s", (String)"EADataPushApi_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opeFail, ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u6570\u636e\u6b63\u5728\u63a8\u9001\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"EADataPushDBTask_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            return result;
        }
        Map<String, List<Map<String, String>>> f7data = EADataPushUtil.buildDefaultF7Data(scheDy, modelId);
        String checkMsg = EADataPushApi.coverFyAndPeriod(f7data, planParam, (String)dimMap.get("iscover"), modelId);
        if (StringUtils.isNotEmpty((String)checkMsg)) {
            result.put("msg", String.format(ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c\uff1a%1$s\uff0c\u8be6\u60c5\uff1a%2$s", (String)"EADataPushApi_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opeFail, checkMsg));
            return result;
        }
        String dimF7Logs = EADataPushUtil.buildLogOfDimension(f7data, MemberReader.findModelNumberById((Object)modelId));
        try {
            AppCacheServiceHelper.put((String)(EA_TABLE_KEY_PREFIX + tablename), (Object)"1", (int)1200);
            Map<String, Object> opeResult = EADataPushApi.exportDataToDB(modelId, f7data, scheDy);
            result.put("msg", String.format(ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c\uff1a%1$s\uff0c\u8be6\u60c5\uff1a%2$s", (String)"EADataPushApi_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opeSucess, dimF7Logs));
            EADataPushApi.saveOpeLogOfOlaoData("true", "", opeResult.size() > 0 ? (Integer)opeResult.get("totalData") : 0, scheDy, modelId, f7data, executor);
        }
        catch (KDBizException e) {
            result.put("msg", e.getMessage());
            EADataPushApi.saveOpeLogOfOlaoData("false", e.getMessage(), 0, scheDy, modelId, f7data, executor);
        }
        finally {
            AppCacheServiceHelper.remove((String)(EA_TABLE_KEY_PREFIX + tablename));
        }
        return result;
    }

    private static String coverFyAndPeriod(Map<String, List<Map<String, String>>> f7data, PlanParam planParam, String isCover, long modelId) {
        if ("true".equals(isCover)) {
            Pair<Long, Long> yearAndPeriod = null;
            try {
                yearAndPeriod = OperatorHelper.calYearAndPeriod(planParam, "", 0L, 0L);
            }
            catch (Exception e) {
                return e.getMessage();
            }
            IDNumberTreeNode yearNode = MemberReader.findMemberById((long)modelId, (String)"bcm_fymembertree", (Long)((Long)yearAndPeriod.p1));
            HashMap<String, String> yearMap = new HashMap<String, String>(16);
            yearMap.put(FIELD_NUMBER, yearNode.getNumber());
            yearMap.put(FIELD_SCOPE, "10");
            yearMap.put("name", yearNode.getName());
            yearMap.put(DIM_KEY, SysDimensionEnum.Year.getNumber().toLowerCase(Locale.ENGLISH));
            yearMap.put("pid", "");
            yearMap.put("id", String.valueOf(yearNode.getId()));
            f7data.put(SysDimensionEnum.Year.getNumber().toLowerCase(Locale.ENGLISH), Collections.singletonList(yearMap));
            IDNumberTreeNode periodNode = MemberReader.findMemberById((long)modelId, (String)"bcm_periodmembertree", (Long)((Long)yearAndPeriod.p2));
            HashMap<String, String> periodMap = new HashMap<String, String>(16);
            periodMap.put(FIELD_NUMBER, periodNode.getNumber());
            periodMap.put(FIELD_SCOPE, "10");
            periodMap.put("name", periodNode.getName());
            periodMap.put(DIM_KEY, SysDimensionEnum.Period.getNumber().toLowerCase(Locale.ENGLISH));
            periodMap.put("pid", "");
            periodMap.put("id", String.valueOf(periodNode.getId()));
            f7data.put(SysDimensionEnum.Period.getNumber().toLowerCase(Locale.ENGLISH), Collections.singletonList(periodMap));
        }
        return "";
    }

    private static ApplicationTypeEnum getAppById(String curAppId) {
        if (ApplicationTypeEnum.CM.getAppnum().equals(curAppId)) {
            return ApplicationTypeEnum.CM;
        }
        if (ApplicationTypeEnum.RPT.getAppnum().equals(curAppId)) {
            return ApplicationTypeEnum.RPT;
        }
        return null;
    }

    private static void saveOpeLogOfOlaoData(String opeResult, String reason, Integer totalnum, DynamicObject scheDy, long modelId, Map<String, List<Map<String, String>>> f7data, long executor) {
        BatchProcessHelper.handleAsync(() -> {
            DynamicObject dyLog = BusinessDataServiceHelper.newDynamicObject((String)"bcm_olapdata_opelog");
            dyLog.set("model", (Object)modelId);
            boolean isSuccess = Boolean.TRUE.toString().equals(opeResult);
            dyLog.set("operesult", (Object)(isSuccess ? "1" : "2"));
            dyLog.set("opetype", (Object)ModelOlapDataOpeLogEnum.OPE_TASK.getCode());
            dyLog.set("reason", (Object)reason);
            dyLog.set("scheme", (Object)scheDy.getLong("id"));
            dyLog.set("dimcombs", (Object)EADataPushApi.compDims(f7data, modelId));
            dyLog.set("tablename", (Object)scheDy.getString("tablename"));
            dyLog.set("iscontaindydata", (Object)(scheDy.getBoolean("iscontaindydata") ? "1" : "0"));
            dyLog.set("totalnum", (Object)totalnum);
            dyLog.set("traceid", (Object)RequestContext.get().getTraceId());
            dyLog.set("creator", (Object)executor);
            dyLog.set("createtime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyLog});
        });
    }

    private static String compDims(Map<String, List<Map<String, String>>> f7data, long modelId) {
        Map<String, String> dimNum2Names = MemberReader.getDimensionNumber2nameMap((String)MemberReader.findModelNumberById((Object)modelId)).values().stream().map(x -> x.split(";")).collect(Collectors.toMap(k -> k[0].toLowerCase(Locale.ENGLISH), v -> v[1], (k, v) -> k));
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<Map<String, String>>> next : f7data.entrySet()) {
            List<Map<String, String>> members = next.getValue();
            if (members.size() <= 0) continue;
            String dimNum = next.getKey();
            String dimName = dimNum2Names.get(dimNum);
            sb.append(dimNum).append(" ").append(dimName).append(":");
            members.forEach(x -> sb.append((String)x.get(FIELD_NUMBER)).append(" ").append((String)x.get("name")).append(";"));
            sb.append(" ");
        }
        return sb.toString();
    }

    private static String checkScheDy(DynamicObject scheDy) {
        if (scheDy == null) {
            return ResManager.loadKDString((String)"\u63d0\u53d6\u65b9\u6848\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u65b9\u6848\u662f\u5426\u5b58\u5728", (String)"EADataPushApi_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        Object model = scheDy.get("model");
        if (model == null) {
            return ResManager.loadKDString((String)"\u63d0\u53d6\u65b9\u6848\u7684\u4f53\u7cfb\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"EADataPushApi_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        long modelId = ((DynamicObject)model).getLong("id");
        if (!QueryServiceHelper.exists((String)"bcm_model", (QFilter[])new QFilter("id", "=", (Object)modelId).toArray())) {
            return ResManager.loadKDString((String)"\u63d0\u53d6\u65b9\u6848\u5bf9\u5e94\u7684\u4f53\u7cfb\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u4f53\u7cfb\u662f\u5426\u5b58\u5728", (String)"EADataPushApi_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (!"0".equals(scheDy.get("exprtype"))) {
            return ResManager.loadKDString((String)"\u63d0\u53d6\u7c7b\u578b\u5fc5\u987b\u662f\u201c\u6570\u636e\u5e93\u201d\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u63d0\u53d6\u65b9\u6848", (String)"EADataPushApi_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)scheDy.getString("tablename"))) {
            return ResManager.loadKDString((String)"\u8868\u540d\u672a\u627e\u5230\uff0c\u8bf7\u8fde\u7eed\u7ba1\u7406\u5458", (String)"EADataPushApi_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        DynamicObjectCollection entryDys = scheDy.getDynamicObjectCollection("commembentry");
        for (DynamicObject entry : entryDys) {
            DynamicObject dimension = entry.getDynamicObject("comdimension");
            String dimNumber = dimension.getString(FIELD_NUMBER);
            String memberModel = dimension.getString("membermodel");
            long pid = entry.getLong("pid");
            Long mid = entry.getLong("commembid");
            DynamicObject memOrPro = EADataPushUtil.queryMemberById(memberModel, mid, pid, modelId);
            if (memOrPro != null) continue;
            return String.format(ResManager.loadKDString((String)"\u65b9\u6848\u4e2d\u7684\u201c%s\u201d\u7ef4\u5ea6\u6709\u6210\u5458\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u65b9\u6848\u3002", (String)"EADataPushBillPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimNumber);
        }
        return "";
    }

    private static Map<String, Object> dealWithApiExp(SQLBuilder sql, long modelId, DynamicObject scheme, Set<String> entityIdNodeSet, Set<String> processNumNodeSet) {
        List<String> tableFieIdList;
        LOG.info("dealWithApiExp\u751f\u6210\u52a8\u6001sql:" + JSON.toJSONString((Object)sql));
        List<String> selectFieldList = tableFieIdList = EADataPushApi.getDims(modelId).get("dimsUpperCase");
        sql.addSelectField(selectFieldList.toArray(new String[0]));
        sql.setExcludeDynaData(!scheme.getBoolean("iscontaindydata"));
        selectFieldList.add(FIELD_FMONEY);
        List<Long> entityIdList = entityIdNodeSet.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        Map<String, Set<String>> DCCurrencyMap = EADataPushUtil.getDCCurrency(modelId, entityIdList, Lists.newArrayList(processNumNodeSet.iterator()));
        HashMap<String, List<String>> DC2CurrencyMap = new HashMap<String, List<String>>(16);
        DCCurrencyMap.forEach((k, v) -> DC2CurrencyMap.put((String)k, new ArrayList(v)));
        Map<String, String> nodeCurrMap = EADataPushUtil.addNodeCurrency(sql.getCubecatalog(), entityIdList);
        List<String> orgEntityList = EADataPushUtil.queryDataByDime(sql, modelId, "Entity", "bcm_entitymembertree");
        String tableName = scheme.getString("tablename");
        Gson gson = new Gson();
        String sqlStr = gson.toJson((Object)sql);
        long startTime = System.currentTimeMillis();
        int totalData = EADataPushApi.runInThread(sqlStr, orgEntityList, selectFieldList, tableName, tableFieIdList, modelId, DC2CurrencyMap, nodeCurrMap);
        long timeConsuming = System.currentTimeMillis() - startTime;
        LOG.info("\u6570\u636e\u5bfc\u51fa\u6210\u529f,\u603b\u6570\u636e:" + totalData);
        LOG.info("\u603b\u5171\u8017\u65f6:" + timeConsuming);
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        result.put("totalData", totalData);
        return result;
    }

    private static int runInThread(String sqlStr, List<String> orgEntityList, List<String> selectFieldList, String tableName, List<String> tableFieIdList, long modelId, Map<String, List<String>> DC2CurrencyMap, Map<String, String> nodeCurrMap) {
        EADataPushUtil.dropTable(tableName);
        EADataPushUtil.createTable(EADataPushUtil.addFToFieId(tableFieIdList), tableName);
        return EADataPushApi.queryOlapDataAndInsert(sqlStr, orgEntityList, selectFieldList, tableName, modelId, DC2CurrencyMap, nodeCurrMap);
    }

    public static int queryOlapDataAndInsert(String sqlStr, List<String> entities, List<String> selectFieldList, String table, Long modelId, Map<String, List<String>> DC2CurrencyMap, Map<String, String> nodeCurrMap) {
        ArrayList<Callable<Integer>> runners = new ArrayList<Callable<Integer>>(entities.size());
        for (String entity : entities) {
            runners.add(() -> {
                Gson gson = new Gson();
                SQLBuilder sql = (SQLBuilder)gson.fromJson(sqlStr, SQLBuilder.class);
                sql.getFilters().removeIf(pair -> "Entity".equalsIgnoreCase((String)pair.p1));
                sql.getFilters().add(new Pair((Object)"Entity", (Object)new String[]{entity}));
                ArrayList<Object[]> resultList = new ArrayList<Object[]>(1024);
                ArrayList<Object> sqlParams = new ArrayList<Object>(16);
                int totalCount = 0;
                Map<String, String> dataMap = EADataPushUtil.dealWithDataByProcess(sql, modelId);
                boolean isContainsEIRpt = dataMap.containsKey("isContainsEIRpt");
                boolean isContainsERAdj = dataMap.containsKey("isContainsERAdj");
                EADataPushUtil.transformSqlByECOrDC(sql, DC2CurrencyMap, nodeCurrMap, entity);
                int processIndex = EADataPushUtil.getSelectFieldIndex(selectFieldList, "process") + 1;
                try (MDResultSetReader resultSet = OlapServiceHelper.queryDataReader((SQLBuilder)sql);){
                    while (resultSet.next()) {
                        sqlParams.clear();
                        sqlParams.add(GlobalIdUtil.genGlobalLongId());
                        Row row = resultSet.getRow();
                        selectFieldList.forEach(e -> {
                            String value = row.getString(e);
                            sqlParams.add(value);
                        });
                        String currency = row.getString("Currency");
                        String process = row.getString("Process");
                        if (isContainsEIRpt && "IRpt".equals(process) && currency.equalsIgnoreCase((String)nodeCurrMap.get(entity))) {
                            sqlParams.set(processIndex, "EIRpt");
                        } else if (isContainsERAdj && "RAdj".equals(process) && currency.equalsIgnoreCase((String)nodeCurrMap.get(entity))) {
                            sqlParams.set(processIndex, "ERAdj");
                        }
                        resultList.add(sqlParams.toArray());
                    }
                }
                totalCount = EADataPushUtil.pollAndInsertData(resultList, totalCount, EADataPushUtil.addFToFieId(selectFieldList), table);
                return totalCount;
            });
        }
        List countList = ThreadPoolService.runInWaiting4Thread((Callable[])runners.toArray(new Callable[0]));
        int totalData = 0;
        for (int i = 0; i < countList.size(); ++i) {
            totalData += ((Integer)countList.get(i)).intValue();
        }
        return totalData;
    }

    private static Map<String, Object> exportDataToDB(long modelId, Map<String, List<Map<String, String>>> f7data, DynamicObject scheme) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        SQLBuilder sql = new SQLBuilder(modelNumber);
        HashSet<String> entityIdNodeSet = new HashSet<String>(16);
        HashSet<String> processNumNodeSet = new HashSet<String>(16);
        EADataPushApi.assemOlapSql(modelId, f7data, sql, entityIdNodeSet, processNumNodeSet);
        return EADataPushApi.dealWithApiExp(sql, modelId, scheme, entityIdNodeSet, processNumNodeSet);
    }

    private static void assemOlapSql(long modelId, Map<String, List<Map<String, String>>> f7data, SQLBuilder sql, Set<String> entityIdNodeSet, Set<String> processNumNodeSet) {
        Map<String, List<String>> mapData = EADataPushApi.getDims(modelId);
        List<String> dims = mapData.get("dims");
        List<String> tableFieIdList = mapData.get("dimsUpperCase");
        List<String> dimsMemberModelList = mapData.get("dimsMemberModelList");
        for (int i = 0; i < dims.size(); ++i) {
            String tableFieId = tableFieIdList.get(i);
            String actionId = dims.get(i);
            String memberModel = dimsMemberModelList.get(i);
            List<Map<String, String>> filterList = f7data.get(actionId);
            ArrayList<String> filterValueList = new ArrayList<String>(10);
            if (CollectionUtils.isEmpty(filterList)) continue;
            for (Map<String, String> dataMap : filterList) {
                if (!actionId.equals(dataMap.get(DIM_KEY))) continue;
                String range = dataMap.get(FIELD_SCOPE);
                if ("10".equals(range)) {
                    filterValueList.add(dataMap.get(FIELD_NUMBER));
                    if ("Entity".equalsIgnoreCase(actionId)) {
                        entityIdNodeSet.add(dataMap.get("id"));
                    }
                    if (!"Process".equalsIgnoreCase(actionId)) continue;
                    processNumNodeSet.add((String)dataMap.get(FIELD_NUMBER));
                    continue;
                }
                String member = MemberReader.findMemberById((long)modelId, (String)memberModel, (Long)Long.parseLong(dataMap.get("id"))).getNumber();
                Map result = QueryMemberDetailsHelper.getMemberIdsByRange((String)memberModel, (Long)Long.parseLong(dataMap.get("id")), (String)member, (int)Integer.parseInt(range), (String)String.valueOf(modelId), (DetailTypeEnum)DetailTypeEnum.OTHERS);
                if ("Entity".equalsIgnoreCase(actionId)) {
                    entityIdNodeSet.addAll((Collection)result.get("ids"));
                }
                if ("Process".equalsIgnoreCase(actionId)) {
                    processNumNodeSet = (Set)result.get("numbers");
                }
                ((Set)result.get("numbers")).forEach(data -> filterValueList.add((String)data));
            }
            if (CollectionUtils.isNotEmpty(filterValueList)) {
                sql.addFilter(tableFieId, filterValueList.toArray(new String[0]));
            }
            if (!"Process".equalsIgnoreCase(actionId) || !CollectionUtils.isEmpty(processNumNodeSet)) continue;
            processNumNodeSet.addAll(EADataPushUtil.queryDataByDime(sql, modelId, "Process", "bcm_processmembertree"));
        }
    }

    private static Map<String, List<String>> getDims(long modelId) {
        HashMap<String, List<String>> mapData = new HashMap<String, List<String>>(16);
        ArrayList dims = new ArrayList(10);
        ArrayList dimsUpperCase = new ArrayList(10);
        ArrayList dimsMemberModelList = new ArrayList(10);
        DynamicObjectCollection dyObjectList = EADataPushApi.getAllDimsInfo(modelId);
        List<DynamicObject> dynamicObjects = EADataPushUtil.sortDims(dyObjectList);
        dynamicObjects.forEach(dyObj -> {
            dims.add(dyObj.getString(FIELD_NUMBER).toLowerCase(Locale.ENGLISH));
            dimsUpperCase.add(dyObj.getString(FIELD_NUMBER));
            dimsMemberModelList.add(dyObj.getString("membermodel"));
        });
        mapData.put("dims", dims);
        mapData.put("dimsUpperCase", dimsUpperCase);
        mapData.put("dimsMemberModelList", dimsMemberModelList);
        return mapData;
    }

    private static DynamicObjectCollection getAllDimsInfo(long modelId) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)"bcm_dimension", (String)"id,name,number,shortnumber,issysdimension,membermodel,dseq", (QFilter[])qf.toArray());
    }
}

