/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.api;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.ModelPermHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.OpenApiUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.lang3.time.DateUtils;

public class IsRpaTaskLogApiPlugin
extends AbstractBillWebApiPlugin {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String STATUS = "status";
    private static final String SELECT_PROPERTIES = "rpascheme,taskid,status,executiondate,executionrobot,notice,noticedate,scenario,year,period,enddate,modeid";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, IsRpaTaskLogApiPlugin.class);
    private static final String appUrl = "/app/cm/RpaLogUpdate";

    public ApiResult doCustomService(WebApiContext ctx) {
        return this.doCustomService(ctx.getData());
    }

    public ApiResult doCustomService(Map<String, Object> params) {
        StringBuilder msg;
        block23: {
            Object request = params.get("request");
            if (request != null) {
                params = request instanceof String ? (Map)JSONObject.parseObject((String)request.toString(), Map.class) : (Map)request;
            }
            logger.info("into IsRpaTaskLogApiPlugin " + JacksonUtils.toJson((Object)params));
            msg = new StringBuilder();
            String taskId = (String)params.get("taskId");
            String entityNumber = (String)params.get("entityNumber");
            String status = (String)params.get(STATUS);
            String execTime = (String)params.get("executionTime");
            String execRobot = (String)params.get("executionRobot");
            String notice = (String)params.get("notice");
            if (StringUtils.isEmpty((String)taskId)) {
                msg.append(ResManager.loadKDString((String)"\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RpaReportTaskService_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)entityNumber)) {
                msg.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u3002", (String)"RpaReportTaskService_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)status)) {
                msg.append(ResManager.loadKDString((String)"\u6267\u884c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RpaReportTaskService_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)execTime)) {
                msg.append(ResManager.loadKDString((String)"\u6267\u884c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RpaReportTaskService_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)execRobot)) {
                msg.append(ResManager.loadKDString((String)"\u6267\u884c\u673a\u5668\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RpaReportTaskService_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)msg.toString())) {
                QFBuilder qf = new QFBuilder().and("taskid", "=", (Object)taskId).and("entity.number", "=", (Object)entityNumber);
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        DynamicObject schemeTask = BusinessDataServiceHelper.loadSingle((String)"bcm_rpaschemetask", (String)SELECT_PROPERTIES, (QFilter[])qf.toArray());
                        if (schemeTask == null) {
                            msg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u4e0d\u5b58\u5728\u4efb\u52a1%2$s\u3002", (String)"RpaReportTaskService_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), entityNumber, taskId));
                            logger.error(msg.toString());
                            break block23;
                        }
                        if (OpenApiUtil.getAuthStatus((String)appUrl) && !ModelPermHelper.hasModelPerm((long)schemeTask.getLong("modeid_id"))) {
                            String info = String.format(ResManager.loadKDString((String)"\u7528\u6237\u65e0%s\u4f53\u7cfb\u4f7f\u7528\u6743\u9650\u3002", (String)"RpaIniFileRulePlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MemberReader.findModelSNumberById((Object)schemeTask.getLong("modeid_id")));
                            throw new KDBizException(info);
                        }
                        schemeTask.set("enddate", (Object)DateUtils.parseDate((String)execTime, (String[])new String[]{DATE_FORMAT}));
                        schemeTask.set("executionrobot", (Object)execRobot);
                        schemeTask.set("notice", (Object)notice);
                        schemeTask.set("noticedate", (Object)TimeServiceHelper.now());
                        schemeTask.set(STATUS, (Object)status);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeTask});
                        long schemeId = schemeTask.getLong("rpascheme.id");
                        this.updateRpaSchemeExecStatus(schemeId);
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        msg.append(e.getMessage());
                        logger.error((Throwable)e);
                    }
                }
            }
        }
        String message = msg.toString();
        ApiResult result = new ApiResult();
        result.setSuccess(StringUtils.isEmpty((String)message));
        result.setMessage(message);
        return result;
    }

    private void updateRpaSchemeExecStatus(long schemeId) {
        DynamicObject rpaScheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isrpascheme");
        String execStatus = rpaScheme.getString("excstatus");
        DynamicObjectCollection rpaTasks = rpaScheme.getDynamicObjectCollection("rpataskid");
        HashMap orgTaskMap = new HashMap(16);
        rpaTasks.forEach(e -> orgTaskMap.put(e.getLong("orgid.id"), e.getString("task")));
        String rpastatus = null;
        QFBuilder builder = new QFBuilder("rpascheme", "=", (Object)schemeId);
        builder.add("taskid", "in", orgTaskMap.values());
        builder.add("entity", "in", orgTaskMap.keySet());
        DynamicObjectCollection logs = QueryServiceHelper.query((String)"bcm_rpaschemetask", (String)"entity,taskid,status", (QFilter[])builder.toArray());
        for (DynamicObject log : logs) {
            long entity = log.getLong("entity");
            String task = log.getString("taskid");
            if (!task.equals(orgTaskMap.get(entity))) continue;
            String temp = log.getString(STATUS);
            if ("3".equals(temp)) {
                rpastatus = temp;
                break;
            }
            if ("2".equals(temp)) {
                rpastatus = temp;
                continue;
            }
            if (rpastatus != null) continue;
            rpastatus = temp;
        }
        if (rpastatus == null) {
            rpastatus = "0";
        }
        if (!execStatus.equals(rpastatus)) {
            rpaScheme.set("excstatus", (Object)rpastatus);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rpaScheme});
        }
    }
}

