/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.api;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.intergration.api.pojo.UserRoleDataReq;
import kd.fi.bcm.formplugin.intergration.api.util.BeanUtil;
import kd.fi.bcm.formplugin.intergration.api.util.UserRoleResult;

public class UserAssignRoles
implements IBillWebApiPlugin {
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());

    public ApiResult doCustomService(Map<String, Object> params) {
        this.log.info("UserAssignRoles\u65b9\u6cd5\u5165\u53c2\u6570\u636e: " + params.toString());
        UserRoleResult result = new UserRoleResult();
        result.setCode("1");
        String str = JSONObject.toJSONString(params);
        JSONObject jsonObject = JSONObject.parseObject((String)str);
        UserRoleDataReq reqData = (UserRoleDataReq)jsonObject.toJavaObject(UserRoleDataReq.class);
        UserRoleDataReq.transformUserGroupName(reqData);
        Boolean success = false;
        boolean isUserGroupUpdateSuccess = false;
        if (UserRoleDataReq.checkReqIsEmpty(reqData).booleanValue()) {
            this.log.info("\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570:AppModule || UserGroupName || UserAccount || SyncType");
            result.setMessage(ResManager.loadKDString((String)"\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570\u6216\u53c2\u6570\u51fa\u9519\u3002", (String)"UserAssignRoles_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            result.setCode("0");
            return result;
        }
        try {
            isUserGroupUpdateSuccess = this.userGroupUpdate(reqData);
            List orgIdList = this.queryDataId("bcm_model", "shownumber", Collections.singletonList(reqData.getAppModule())).stream().map(p -> Long.parseLong(p.getString("id"))).collect(Collectors.toList());
            QFilter userGroupRoleFilters = new QFilter("usergroup.number", "=", (Object)reqData.getUserGroupName());
            DynamicObject userGroupRoleDy = QueryServiceHelper.queryOne((String)"bcm_usergroup_rolemapper", (String)"role", (QFilter[])userGroupRoleFilters.toArray());
            List<String> roleIdList = Collections.singletonList(userGroupRoleDy.getString("role"));
            List userIdList = this.queryDataId("bos_user", "number", Collections.singletonList(reqData.getUserAccount())).stream().map(p -> Long.parseLong(p.getString("id"))).collect(Collectors.toList());
            reqData.setUserId((Long)userIdList.get(0));
            HashMap assignInfo = new HashMap();
            assignInfo.put(orgIdList.get(0), roleIdList);
            String dimType = "DIM_BCM_MODEL";
            Boolean isAdd = "grant".equals(reqData.getSyncType());
            this.log.info("\u65b9\u6cd5\u53c2\u6570\u8c03\u7528userId:" + JSONObject.toJSONString(userIdList.get(0)) + ";assignInfo:" + JSONObject.toJSONString(assignInfo) + ";isAdd:" + isAdd);
            success = PermissionServiceHelper.userAssignRole((Long)((Long)userIdList.get(0)), (String)dimType, assignInfo, null, (boolean)isAdd);
        }
        catch (Exception e) {
            this.log.error("UserAssignRoles\u7528\u6237\u89d2\u8272\u5206\u914d\u8bbe\u7f6e\u8bf7\u6c42\u62a5\u9519:", (Throwable)e);
            String msg = isUserGroupUpdateSuccess ? ResManager.loadKDString((String)"\u7528\u6237\u5206\u914d\u7528\u6237\u7ec4\u6210\u529f\u3002", (String)"UserAssignRoles_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7528\u6237\u5206\u914d\u89d2\u8272\u8bbe\u7f6e\u5931\u8d25\u3002", (String)"UserAssignRoles_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            result.setMessage(msg);
            result.setCode("0");
            return result;
        }
        if (!success.booleanValue()) {
            result.setCode("0");
            result.setMessage(ResManager.loadKDString((String)"\u7528\u6237\u5206\u914d\u89d2\u8272\u8bbe\u7f6e\u5931\u8d25\u3002", (String)"UserAssignRoles_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return result;
        }
        result.setMessage(ResManager.loadKDString((String)"\u7528\u6237\u5206\u914d\u89d2\u8272\u8bbe\u7f6e\u6210\u529f\u3002", (String)"UserAssignRoles_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        return result;
    }

    private boolean userGroupUpdate(UserRoleDataReq req) {
        ArrayList<String> reqIdList = new ArrayList<String>();
        reqIdList.add(req.getUserAccount());
        QFBuilder qfBuilder = new QFBuilder("number", "in", reqIdList);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_usergroup_user", (String)"id,phone,number,usergroup", (QFilter[])qfBuilder.toArray());
        List<DynamicObject> list = Arrays.asList(dynamicObjects);
        QFilter userGroupFilters = new QFilter("number", "=", (Object)req.getUserGroupName());
        DynamicObject userGroupDy = QueryServiceHelper.queryOne((String)"bos_usergroup", (String)"id,name", (QFilter[])userGroupFilters.toArray());
        ArrayList userIdList = new ArrayList(list.size());
        ArrayList dyList = new ArrayList(list.size());
        list.forEach(dynamicObject -> {
            String userGroup = dynamicObject.getString("usergroup");
            if (BeanUtil.isEmpty(userGroup).booleanValue() || req.getUserGroupName().equals(userGroup) || "[]".equals(userGroup)) {
                DynamicObject dyUserGroupStaff = BusinessDataServiceHelper.newDynamicObject((String)"bos_usergroupstaff");
                dyUserGroupStaff.set("user", dynamicObject);
                dyUserGroupStaff.set("usergroup", (Object)userGroupDy.getLong("id"));
                userIdList.add(dynamicObject.getString("id"));
                dyList.add(dyUserGroupStaff);
            }
        });
        QFilter userGroupStaffFilter = new QFilter("user", "in", userIdList);
        DeleteServiceHelper.delete((String)"bos_usergroupstaff", (QFilter[])userGroupStaffFilter.toArray());
        SaveServiceHelper.save((DynamicObject[])dyList.toArray(new DynamicObject[0]));
        return true;
    }

    private DynamicObjectCollection queryDataId(String entityName, String filter, List<String> reqList) {
        QFilter filters = new QFilter(filter, "in", reqList);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityName, (String)"id,number", (QFilter[])filters.toArray());
        return dynamicObjects;
    }
}

