/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.bifetch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.intergration.bifetch.BIReportFetchServiceHelper;
import kd.fi.bcm.formplugin.intergration.bifetch.BIReportFetchServiceHelperV2;
import kd.fi.bcm.formplugin.intergration.bifetch.ctx.BIFetchContext;
import kd.fi.bcm.formplugin.intergration.bifetch.ctx.BIFetchContextV2;
import kd.fi.bcm.formplugin.intergration.bifetch.ctx.IBIFetchContext;

public class BIReportFetchMsServiceHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(BIReportFetchMsServiceHelper.class);

    public Map<String, Object> query(Map<String, Object> param) {
        log.startWatch();
        log.info("--BIReportFetchMsServiceHelper--param:" + param);
        try {
            Map<String, Object> data;
            IBIFetchContext ctx;
            if (StringUtils.isNotEmpty((CharSequence)((String)param.get("version"))) && param.get("version").equals("V2")) {
                ctx = new BIFetchContextV2(param);
                data = BIReportFetchServiceHelperV2.execute(ctx);
            } else {
                ctx = new BIFetchContext(param);
                data = BIReportFetchServiceHelper.execute(ctx);
            }
            if (DebugServiceHelper.isDebugModel()) {
                log.info("--BIReportFetchMsServiceHelper--" + data);
            }
            HashMap<String, Object> result = new HashMap<String, Object>(4);
            if (ctx.getEC2RealCurrency() != null) {
                param.put("realCurrency", ctx.getEC2RealCurrency().p2);
            }
            result.put("param", param);
            result.put("data", data);
            return result;
        }
        catch (Exception e) {
            log.error("--BIReportFetchMsServiceHelper--error\n" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            if (e instanceof KDBizException) {
                throw new KDBizException(e.getMessage());
            }
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
    }

    public Map<String, Object> getModels() {
        QFilter qf;
        HasPermDimObjResult result = PermissionServiceHelper.getUserHasPermDimObjs((long)LongUtil.toLong((Object)RequestContext.get().getUserId()), (String)"bcm_model");
        if (result.hasAllDimObjPerm()) {
            qf = new QFilter("1", "=", (Object)1);
        } else {
            Set modelids = MemberPermHelper.getLimitedModelListByUser();
            modelids.addAll(result.getHasPermDimObjs());
            qf = new QFilter("id", "in", (Object)modelids);
        }
        QFilter reporttype = new QFilter("reporttype", "in", (Object)new String[]{ApplicationTypeEnum.CM.getOIndex(), ApplicationTypeEnum.RPT.getOIndex()});
        DynamicObjectCollection modelDyns = QueryServiceHelper.query((String)"bcm_model", (String)"number,shownumber,name,reporttype", (QFilter[])new QFilter[]{qf, reporttype});
        HashMap<String, Object> models = new HashMap<String, Object>(modelDyns.size());
        for (DynamicObject d : modelDyns) {
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("shownumber", d.getString("shownumber"));
            map.put("name", d.getString("name"));
            map.put("reporttype", d.getString("reporttype"));
            models.put(d.getString("number"), map);
        }
        return models;
    }

    public Map<String, Object> getTemplates(List<String> modelNumbers) {
        HashMap<String, Object> result = new HashMap<String, Object>(modelNumbers.size());
        QFilter qfModel = new QFilter("model.number", "in", modelNumbers);
        QFilter qfStatus = new QFilter("status", "=", (Object)"1");
        QFilter qfType = new QFilter("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        DynamicObjectCollection tmplDyns = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number,name,model.number", (QFilter[])new QFilter[]{qfModel, qfStatus, qfType});
        tmplDyns.forEach(tmpl -> {
            Map map = result.getOrDefault(tmpl.getString("model.number"), new HashMap());
            map.put(tmpl.getString("number"), tmpl.getString("name"));
            result.put(tmpl.getString("model.number"), map);
        });
        return result;
    }
}

