/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.bifetch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.template.model.ColDimensionEntry;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.business.template.model.MembSettingBaseDetail;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.RowDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.TemplateUtils;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.intergration.bifetch.ctx.IBIFetchContext;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.model.DimMember;

public class BIReportFetchServiceHelper {
    private static final Set<String> NOTNEEDDIMS4TMPL = new HashSet<String>(){
        {
            this.add(SysDimensionEnum.Entity.getNumber());
            this.add(SysDimensionEnum.Scenario.getNumber());
            this.add(SysDimensionEnum.Year.getNumber());
            this.add(SysDimensionEnum.Period.getNumber());
            this.add(SysDimensionEnum.Process.getNumber());
            this.add(SysDimensionEnum.Currency.getNumber());
        }
    };
    private static final Set<String> NOTNEEDDIMS4DATA = new HashSet<String>(){
        {
            this.add(SysDimensionEnum.Entity.getNumber());
            this.add(SysDimensionEnum.Scenario.getNumber());
            this.add(SysDimensionEnum.Year.getNumber());
            this.add(SysDimensionEnum.Period.getNumber());
            this.add(SysDimensionEnum.Currency.getNumber());
        }
    };

    public static Map<String, Object> execute(IBIFetchContext ctx) {
        ArrayList olapresult = new ArrayList(10);
        List dimensions = DimensionServiceHelper.getDimensionNumListByModel((Object)ctx.getModel().p1);
        List need4DataDims = dimensions.stream().filter(d -> !NOTNEEDDIMS4DATA.contains(d)).collect(Collectors.toList());
        Map<String, Set<String>> datafilter = BIReportFetchServiceHelper.setDataFilterInCtx(ctx);
        List<TemplateModel> tmplModels = BIReportFetchServiceHelper.getTmplModels(ctx);
        tmplModels.forEach(tmpl -> {
            Map<String, Set<String>> members = BIReportFetchServiceHelper.getMembersInTmpl(tmpl);
            ctx.getScope().keySet().forEach(members::remove);
            members.putAll(datafilter);
            olapresult.addAll(BIReportFetchServiceHelper.queryOlap(ctx, members, need4DataDims, tmpl.getNumber()));
        });
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        need4DataDims.add(0, "tmplNum");
        data.put("dimension", need4DataDims);
        data.put("data", olapresult);
        return data;
    }

    private static Map<String, Set<String>> setDataFilterInCtx(final IBIFetchContext ctx) {
        HashMap<String, Set<String>> datafilter = new HashMap<String, Set<String>>(16);
        datafilter.put(SysDimensionEnum.Entity.getNumber(), new HashSet<String>(){
            {
                this.add(ctx.getOrg().p2);
            }
        });
        datafilter.put(SysDimensionEnum.Scenario.getNumber(), new HashSet<String>(){
            {
                this.add(ctx.getScene().p2);
            }
        });
        datafilter.put(SysDimensionEnum.Year.getNumber(), new HashSet<String>(){
            {
                this.add(ctx.getYear().p2);
            }
        });
        datafilter.put(SysDimensionEnum.Period.getNumber(), new HashSet<String>(){
            {
                this.add(ctx.getPeriod().p2);
            }
        });
        datafilter.put(SysDimensionEnum.Currency.getNumber(), new HashSet<String>(){
            {
                this.add(ctx.getCurrency().p2);
            }
        });
        datafilter.put(SysDimensionEnum.Process.getNumber(), new HashSet<String>(ctx.getProcessList()));
        if (ctx.getScope().size() > 0) {
            ctx.getScope().forEach((k, v) -> datafilter.put((String)k, new HashSet((List)v)));
        }
        return datafilter;
    }

    private static Map<String, Set<String>> getMembersInTmpl(TemplateModel tmpl) {
        HashMap<String, Set<String>> members = new HashMap<String, Set<String>>(16);
        tmpl.getViewPointDimensionEntries().forEach(v -> BIReportFetchServiceHelper.setMembersInEntry(v, v.getDimension().getNumber(), tmpl.getModelId(), members));
        tmpl.getPageDimensionEntries().forEach(p -> BIReportFetchServiceHelper.setMembersInEntry(p, p.getDimension().getNumber(), tmpl.getModelId(), members));
        tmpl.getAreaRangeEntries().forEach(area -> {
            area.getColDimEntries().forEach(c -> BIReportFetchServiceHelper.setMembersInEntry(c, c.getDimension().getNumber(), tmpl.getModelId(), members));
            area.getRowDimEntries().forEach(r -> BIReportFetchServiceHelper.setMembersInEntry(r, r.getDimension().getNumber(), tmpl.getModelId(), members));
        });
        BIReportFetchServiceHelper.setMembers4DynaMebScopes(tmpl, members);
        return members;
    }

    private static void setMembers4DynaMebScopes(TemplateModel tmpl, Map<String, Set<String>> members) {
        if (TemplateTypeEnum.DYNA.getType() == tmpl.getTemplateType().intValue()) {
            SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)tmpl.getRptData());
            for (PositionInfo e : sm.getAreaManager().getPostionInfoSet()) {
                List basepoints = e.getBasePoints();
                for (BasePointInfo basepoint : basepoints) {
                    List lines = basepoint.getBasePointInnerLineInfo();
                    lines.forEach(line -> {
                        List scopes = line.getDynaMembScopes();
                        scopes.forEach(scope -> {
                            Set numbers = members.getOrDefault(line.getDimension().getNumber(), new HashSet());
                            if (scope.isCustom()) {
                                numbers.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number((String)scope.getMember().getDimension().getUqCode(), (Long)((DimMember)scope.getMember()).getId(), (String)scope.getMember().getNumber(), (int)scope.getRangeId(), (String)String.valueOf(tmpl.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
                            } else {
                                numbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange((String)scope.getMember().getDimension().getUqCode(), (Long)((DimMember)scope.getMember()).getId(), (String)((DimMember)scope.getMember()).getNumber(), (int)scope.getRangeId(), (String)String.valueOf(tmpl.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
                            }
                        });
                    });
                }
            }
        }
    }

    private static void setMembersInEntry(Object entry, String dimNum, long modelid, Map<String, Set<String>> members) {
        if (NOTNEEDDIMS4TMPL.contains(dimNum)) {
            return;
        }
        Set dimMembers = members.getOrDefault(dimNum, new HashSet(16));
        if (entry instanceof ViewPointDimensionEntry) {
            dimMembers.add(((ViewPointDimensionEntry)entry).getMember().getNumber());
        } else if (entry instanceof PageDimensionEntry) {
            ((PageDimensionEntry)entry).getMembers().forEach(m -> new MembRangeItem(((PageDimensionEntry)entry).getDimension().getMemberEntityNumber(), Long.valueOf(m.getId()), m.getNumber(), RangeEnum.getRangeByVal((int)m.getScope()), false, (Object)modelid).matchItems(c -> dimMembers.add(c.number)));
        } else if ((entry instanceof ColDimensionEntry || entry instanceof RowDimensionEntry) && ((MembSettingBaseDetail)entry).getMembers() != null) {
            dimMembers.addAll(((MembSettingBaseDetail)entry).getMembers().stream().map(DynaEntityObject::getNumber).collect(Collectors.toSet()));
        }
        members.put(dimNum, dimMembers);
    }

    private static List<TemplateModel> getTmplModels(IBIFetchContext ctx) {
        QFBuilder filters = new QFBuilder("model", "=", ctx.getModel().p1);
        filters.add("number", "in", ctx.getTmplList());
        filters.add("templatetype", "in", (Object)new String[]{String.valueOf(TemplateTypeEnum.FIX.getType()), String.valueOf(TemplateTypeEnum.DYNA.getType())});
        DynamicObjectCollection tmpls = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])filters.toArray());
        Set idsMap = tmpls.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        Map rightTmplIds = TemplateUtils.getRightTplIdByVersioned((Long)((Long)ctx.getModel().p1), (Long)((Long)ctx.getYear().p1), (Long)((Long)ctx.getPeriod().p1), idsMap);
        ArrayList<TemplateModel> models = new ArrayList<TemplateModel>(10);
        rightTmplIds.values().forEach(e -> models.add(TemplateServiceHelper.getTemplateModelById((Object)e)));
        return models;
    }

    private static List<List<String>> queryOlap(IBIFetchContext ctx, Map<String, Set<String>> datafilter, List<String> need4DataDims, String tmplNum) {
        ArrayList<List<String>> result = new ArrayList<List<String>>(10);
        if (datafilter.size() == 0) {
            return result;
        }
        SQLBuilder sql = new SQLBuilder((String)ctx.getModel().p2);
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        sql.addSelectField(need4DataDims.toArray(new String[0]));
        datafilter.forEach((k, v) -> sql.addFilter(k, v.toArray(new String[0])));
        MDResultSet resultset = OlapServiceHelper.queryData((SQLBuilder)sql);
        while (resultset.next()) {
            ArrayList<String> row = new ArrayList<String>(10);
            row.add(tmplNum);
            need4DataDims.forEach(e -> row.add(resultset.getString(e)));
            row.add(resultset.getString(FacTabFieldDefEnum.FIELD_MONEY.getField()));
            result.add(row);
        }
        return result;
    }
}

