/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.bifetch;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.TemplateUtils;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.intergration.bifetch.ctx.IBIFetchContext;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.Tuple;

public class BIReportFetchServiceHelperV2 {
    private static final Set<String> NOTNEEDDIMS4TMPL = new HashSet<String>(){
        {
            this.add(SysDimensionEnum.Entity.getNumber());
            this.add(SysDimensionEnum.Scenario.getNumber());
            this.add(SysDimensionEnum.Year.getNumber());
            this.add(SysDimensionEnum.Period.getNumber());
            this.add(SysDimensionEnum.Process.getNumber());
            this.add(SysDimensionEnum.Currency.getNumber());
        }
    };
    private static final Set<String> NOTNEEDDIMS4DATA = new HashSet<String>(){
        {
            this.add(SysDimensionEnum.Entity.getNumber());
            this.add(SysDimensionEnum.Scenario.getNumber());
            this.add(SysDimensionEnum.Year.getNumber());
            this.add(SysDimensionEnum.Period.getNumber());
            this.add(SysDimensionEnum.Currency.getNumber());
        }
    };

    public static Map<String, Object> execute(IBIFetchContext ctx) {
        ArrayList olapresult = new ArrayList(10);
        List dimensions = DimensionServiceHelper.getDimensionNumListByModel((Object)ctx.getModel().p1);
        List need4DataDims = dimensions.stream().filter(d -> !NOTNEEDDIMS4DATA.contains(d)).collect(Collectors.toList());
        Map<String, Set<String>> datafilter = BIReportFetchServiceHelperV2.setDataFilterInCtx(ctx);
        List<TemplateModel> tmplModels = BIReportFetchServiceHelperV2.getTmplModels(ctx);
        dimensions.removeAll(NOTNEEDDIMS4TMPL);
        dimensions.removeAll(ctx.getScope().keySet());
        tmplModels.forEach(tmpl -> {
            SpreadManager tsm = JsonSerializerUtil.toSpreadManager((String)tmpl.getRptData());
            BIReportFetchServiceHelperV2.analysisReport(ctx, olapresult, datafilter, need4DataDims, tsm, tmpl, dimensions);
        });
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        need4DataDims.add(0, "tmplNum");
        data.put("dimension", need4DataDims);
        data.put("data", olapresult);
        return data;
    }

    private static Map<String, Set<String>> setDataFilterInCtx(final IBIFetchContext ctx) {
        HashMap<String, Set<String>> datafilter = new HashMap<String, Set<String>>(16);
        datafilter.put(SysDimensionEnum.Entity.getNumber(), new HashSet<String>(){
            {
                this.add(ctx.getOrg().p2);
            }
        });
        datafilter.put(SysDimensionEnum.Scenario.getNumber(), new HashSet<String>(){
            {
                this.add(ctx.getScene().p2);
            }
        });
        datafilter.put(SysDimensionEnum.Year.getNumber(), new HashSet<String>(){
            {
                this.add(ctx.getYear().p2);
            }
        });
        datafilter.put(SysDimensionEnum.Period.getNumber(), new HashSet<String>(){
            {
                this.add(ctx.getPeriod().p2);
            }
        });
        datafilter.put(SysDimensionEnum.Currency.getNumber(), new HashSet<String>(){
            {
                this.add(ctx.getCurrency().p2);
            }
        });
        datafilter.put(SysDimensionEnum.Process.getNumber(), new HashSet<String>(ctx.getProcessList()));
        if (ctx.getScope().size() > 0) {
            ctx.getScope().forEach((k, v) -> datafilter.put((String)k, new HashSet((List)v)));
        }
        return datafilter;
    }

    private static List<TemplateModel> getTmplModels(IBIFetchContext ctx) {
        QFBuilder filters = new QFBuilder("model", "=", ctx.getModel().p1);
        filters.add("number", "in", ctx.getTmplList());
        filters.add("templatetype", "in", (Object)new String[]{String.valueOf(TemplateTypeEnum.FIX.getType()), String.valueOf(TemplateTypeEnum.DYNA.getType())});
        DynamicObjectCollection tmpls = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])filters.toArray());
        Set idsMap = tmpls.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        Map rightTmplIds = TemplateUtils.getRightTplIdByVersioned((Long)((Long)ctx.getModel().p1), (Long)((Long)ctx.getYear().p1), (Long)((Long)ctx.getPeriod().p1), idsMap);
        ArrayList<TemplateModel> models = new ArrayList<TemplateModel>(10);
        rightTmplIds.values().forEach(e -> models.add(TemplateServiceHelper.getTemplateModelById((Object)e)));
        return models;
    }

    private static List<List<String>> queryOlap(IBIFetchContext ctx, Map<String, Set<String>> datafilter, List<String> need4DataDims, String tmplNum) {
        ArrayList<List<String>> result = new ArrayList<List<String>>(10);
        if (datafilter.size() == 0) {
            return result;
        }
        SQLBuilder sql = new SQLBuilder((String)ctx.getModel().p2);
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        sql.addSelectField(need4DataDims.toArray(new String[0]));
        datafilter.forEach((k, v) -> sql.addFilter(k, v.toArray(new String[0])));
        MDResultSet resultset = OlapServiceHelper.queryData((SQLBuilder)sql);
        while (resultset.next()) {
            ArrayList<String> row = new ArrayList<String>(10);
            row.add(tmplNum);
            need4DataDims.forEach(e -> row.add(resultset.getString(e)));
            row.add(resultset.getString(FacTabFieldDefEnum.FIELD_MONEY.getField()));
            result.add(row);
        }
        return result;
    }

    private static void analysisReport(IBIFetchContext ctx, List<List<String>> olapresult, Map<String, Set<String>> datafilter, List<String> need4DataDims, SpreadManager sm, TemplateModel model, List<String> selectDim) {
        HashMap<String, Set<String>> members;
        ArrayList<String> unScope = new ArrayList<String>();
        for (PositionInfo ps : sm.getAreaManager().getPostionInfoSet()) {
            if (ps.getExtendInfo() != null) continue;
            Map<String, Set<String>> map = BIReportFetchServiceHelperV2.getNormalMap(sm, ps, model, false, selectDim);
            members = new HashMap<String, Set<String>>(16);
            members.putAll(datafilter);
            for (BasePointInfo bp : ps.getBasePoints()) {
                unScope.clear();
                for (BasePointInnerLineInfo info : bp.getBasePointInnerLineInfo()) {
                    if (selectDim.size() > 0 && !selectDim.contains(info.getDimension().getNumber())) continue;
                    ArrayList numbers = new ArrayList();
                    List scope = info.getDynaMembScopes();
                    if (scope.size() == 0) {
                        if (info.isFloated()) {
                            String modelNumber = MemberReader.findModelNumberById((Object)model.getModelId());
                            IDNumberTreeNode memberNode = MemberReader.findMemberByNumber((String)modelNumber, (String)info.getDimension().getNumber(), (String)info.getDimension().getNumber());
                            Set numberSet = memberNode.getAllChildren().stream().map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
                            numbers.addAll(numberSet);
                            Set<String> li = map.get(info.getDimension().getNumber());
                            if (li == null) {
                                li = new HashSet<String>();
                            }
                            li.addAll(numbers);
                            map.put(info.getDimension().getNumber(), li);
                            continue;
                        }
                        unScope.add(info.getDimension().getNumber());
                        continue;
                    }
                    for (DynaMembScopeInfo scinfo : scope) {
                        if (scinfo.isCustom()) {
                            numbers.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number((String)scinfo.getMember().getDimension().getUqCode(), (Long)((DimMember)scinfo.getMember()).getId(), (String)scinfo.getMember().getNumber(), (int)scinfo.getRangeId(), (String)String.valueOf(model.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
                            continue;
                        }
                        numbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange((String)scinfo.getMember().getDimension().getUqCode(), (Long)((DimMember)scinfo.getMember()).getId(), (String)((DimMember)scinfo.getMember()).getNumber(), (int)scinfo.getRangeId(), (String)String.valueOf(model.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
                    }
                    map.remove(info.getDimension().getNumber());
                    HashSet li = new HashSet();
                    li.addAll(numbers);
                    map.put(info.getDimension().getNumber(), li);
                }
                for (String s : unScope) {
                    map.remove(s);
                }
                members.putAll(map);
                BIReportFetchServiceHelperV2.queryData(ctx, sm, members, olapresult, need4DataDims, model.getNumber(), false, null);
            }
        }
        Map<String, Set<String>> mapRowColDim = BIReportFetchServiceHelperV2.getRowColMap(sm, selectDim);
        Recorder rec = new Recorder((Object)true);
        mapRowColDim.entrySet().forEach(e -> {
            if (datafilter.get(e.getKey()) != null && !((Set)e.getValue()).retainAll((Collection)datafilter.get(e.getKey()))) {
                rec.setRecord((Object)false);
            }
        });
        if (mapRowColDim.size() > 0 && ((Boolean)rec.getRecord()).booleanValue()) {
            Map<String, Set<String>> mapViewPageDim = BIReportFetchServiceHelperV2.getNormalMap(sm, null, model, true, selectDim);
            members = new HashMap(16);
            members.putAll(mapViewPageDim);
            members.putAll(mapRowColDim);
            members.putAll(datafilter);
            HashMap<String, Set<String>> rowColAndDatafilter = new HashMap<String, Set<String>>(3);
            datafilter.keySet().forEach(k -> {
                if (mapRowColDim.containsKey(k)) {
                    rowColAndDatafilter.put((String)k, (Set<String>)datafilter.get(k));
                }
            });
            BIReportFetchServiceHelperV2.queryData(ctx, sm, members, olapresult, need4DataDims, model.getNumber(), true, rowColAndDatafilter);
        }
    }

    private static Map<String, Set<String>> getNormalMap(SpreadManager sm, PositionInfo ps, TemplateModel model, boolean isOnlyViewPageDim, List<String> selectDim) {
        HashSet<String> numbers;
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
        if (!isOnlyViewPageDim) {
            Tuple t = sm.getAreaManager().getRowAndColDomainByPosition(ps);
            for (IDimension r : ((RowDimDomain)t.k).getDimensions()) {
                if (selectDim.size() > 0 && !selectDim.contains(r.getNumber())) continue;
                numbers = new HashSet<String>(16);
                for (IDimMember m : r.getMembers()) {
                    numbers.add(m.getNumber());
                }
                map.put(r.getNumber(), numbers);
            }
            for (IDimension r : ((ColumnDimDomain)t.v).getDimensions()) {
                if (selectDim.size() > 0 && !selectDim.contains(r.getNumber())) continue;
                numbers = new HashSet(16);
                for (IDimMember m : r.getMembers()) {
                    numbers.add(m.getNumber());
                }
                map.put(r.getNumber(), numbers);
            }
        }
        for (ViewPointDimensionEntry v : model.getViewPointDimensionEntries()) {
            if (selectDim.size() > 0 && !selectDim.contains(v.getDimension().getNumber())) continue;
            map.put(v.getDimension().getNumber(), Sets.newHashSet((Object[])new String[]{v.getMember().getNumber()}));
        }
        for (PageDimensionEntry p : model.getPageDimensionEntries()) {
            if (selectDim.size() > 0 && !selectDim.contains(p.getDimension().getNumber())) continue;
            numbers = new HashSet(16);
            for (Member m : p.getMembers()) {
                numbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange((String)p.getDimension().getMemberEntityNumber(), (Long)m.getId(), (String)m.getNumber(), (int)m.getScope(), (String)String.valueOf(model.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
            }
            map.put(p.getDimension().getNumber(), numbers);
        }
        for (PageDimensionEntry p : model.getPagePropEntries()) {
            if (selectDim.size() > 0 && !selectDim.contains(p.getDimension().getNumber())) continue;
            numbers = new HashSet(16);
            for (Member m : p.getAllMembProperties()) {
                numbers.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number((String)p.getDimension().getMemberEntityNumber(), (Long)m.getId(), (String)m.getNumber(), (int)m.getScope(), (String)String.valueOf(model.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
            }
            map.put(p.getDimension().getNumber(), numbers);
        }
        return map;
    }

    private static Map<String, Set<String>> getRowColMap(SpreadManager sm, List<String> selectDim) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        if (selectDim.size() == 0) {
            return map;
        }
        sm.getBook().getSheet(0).iteratorCells(c -> {
            if (c.isMdDataDomain() && c.getMemberFromUserObject() != null && !c.getMemberFromUserObject().isEmpty()) {
                for (IDimMember m : c.getMemberFromUserObject()) {
                    String dim = m.getDimension().getNumber();
                    Set members = map.getOrDefault(dim, new HashSet());
                    members.add(m.getNumber());
                    map.put(dim, members);
                }
            }
        });
        return map;
    }

    private static void queryData(IBIFetchContext ctx, SpreadManager sm, Map<String, Set<String>> members, List<List<String>> olapresult, List<String> need4DataDims, String tmplNum, boolean onlyMatchFix, Map<String, Set<String>> rowColAndDatafilter) {
        HashMap<String, Integer> dimIndex = new HashMap<String, Integer>(need4DataDims.size());
        for (int i = 0; i < need4DataDims.size(); ++i) {
            dimIndex.put(need4DataDims.get(i), i + 1);
        }
        List<List<String>> tempResult = BIReportFetchServiceHelperV2.queryOlap(ctx, members, need4DataDims, tmplNum);
        Iterator<List<String>> it = tempResult.iterator();
        while (it.hasNext()) {
            List<String> next = it.next();
            if (BIReportFetchServiceHelperV2.hitArea(dimIndex, next, sm, onlyMatchFix, rowColAndDatafilter)) continue;
            it.remove();
        }
        olapresult.addAll(tempResult);
    }

    private static boolean hitArea(Map<String, Integer> dimIndex, List<String> row, SpreadManager sm, boolean onlyMatchFix, Map<String, Set<String>> rowColAndDatafilter) {
        Recorder hit = new Recorder((Object)false);
        Recorder onlyFix = new Recorder((Object)onlyMatchFix);
        sm.getBook().getSheet(0).iteratorCells(c -> {
            boolean hitThisArea = true;
            if (!((Boolean)hit.getRecord()).booleanValue() && c.getMemberFromUserObject() != null && !c.getMemberFromUserObject().isEmpty()) {
                if (((Boolean)onlyFix.getRecord()).booleanValue() && !c.isMdDataDomain()) {
                    return;
                }
                for (IDimMember m : c.getMemberFromUserObject()) {
                    String dim = m.getDimension().getNumber();
                    if ((dimIndex.get(dim) == null || ((String)row.get((Integer)dimIndex.get(dim))).equals(m.getNumber())) && (rowColAndDatafilter == null || !rowColAndDatafilter.containsKey(dim) || ((Set)rowColAndDatafilter.get(dim)).contains(m.getNumber()))) continue;
                    hitThisArea = false;
                    break;
                }
                if (hitThisArea) {
                    hit.setRecord((Object)true);
                    return;
                }
                hit.setRecord((Object)false);
            }
        });
        return (Boolean)hit.getRecord();
    }
}

