/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.bifetch.ctx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.intergration.bifetch.ctx.BIFetchContext;
import kd.fi.bcm.formplugin.intergration.bifetch.ctx.IBIFetchContext;

public class BIFetchContextV2
implements IBIFetchContext,
Cloneable {
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(BIFetchContext.class);
    private Pair<Long, String> model;
    private Pair<Long, String> scene;
    private Pair<Long, String> currency;
    private Pair<Long, String> year;
    private Pair<Long, String> period;
    private Pair<Long, String> org;
    private List<String> processList;
    private List<String> tmplList;
    private Map<String, Object> scope = new HashMap<String, Object>();
    private Pair<String, String> EC2RealCurrency;
    private final Set<String> MUSTDIM = new HashSet<String>(){
        {
            this.add(SysDimensionEnum.Entity.getNumber());
            this.add(SysDimensionEnum.Scenario.getNumber());
            this.add(SysDimensionEnum.Year.getNumber());
            this.add(SysDimensionEnum.Period.getNumber());
            this.add(SysDimensionEnum.Process.getNumber());
            this.add(SysDimensionEnum.Currency.getNumber());
        }
    };

    public BIFetchContextV2(Map<String, Object> param) {
        String modelNum = (String)param.get("model");
        String orgNum = (String)param.get("entity");
        String sceneNum = (String)param.get("scene");
        String yearNum = (String)param.get("year");
        String periodNum = (String)param.get("period");
        String currencyNum = ObjectUtils.isEmpty((Object)param.get("currency")) ? CurrencyEnum.EC.getNumber() : (String)param.get("currency");
        ArrayList<String> processList = ObjectUtils.isEmpty((Object)param.get("processList")) ? new ArrayList() : (List)param.get("processList");
        List tmplList = (List)param.get("tmplList");
        if (modelNum == null || orgNum == null || sceneNum == null || yearNum == null || periodNum == null || tmplList == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5931\u5fc5\u8981\u53c2\u6570\u3002", (String)"BIFetchContext_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject model = BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)modelNum)});
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"BIFetchContext_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.model = Pair.onePair((Object)model.getLong("id"), (Object)modelNum);
        QFilter modelQFilter = new QFilter("model", "=", (Object)model.getLong("id"));
        String orgNum4Check = orgNum;
        if (orgNum.contains("_")) {
            orgNum4Check = orgNum4Check.split("_")[0];
        }
        DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])new QFilter[]{modelQFilter, new QFilter("number", "=", (Object)orgNum4Check)});
        DynamicObject scene = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)"id", (QFilter[])new QFilter[]{modelQFilter, new QFilter("number", "=", (Object)sceneNum)});
        DynamicObject year = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)"id", (QFilter[])new QFilter[]{modelQFilter, new QFilter("number", "=", (Object)yearNum)});
        DynamicObject period = QueryServiceHelper.queryOne((String)"bcm_periodmembertree", (String)"id", (QFilter[])new QFilter[]{modelQFilter, new QFilter("number", "=", (Object)periodNum)});
        this.validateParam(org, DimTypesEnum.ENTITY);
        this.validateParam(scene, DimTypesEnum.SCENARIO);
        this.validateParam(year, DimTypesEnum.YEAR);
        this.validateParam(period, DimTypesEnum.PERIOD);
        this.checkPerm(model, org);
        this.handleProcess(org, processList, modelQFilter);
        this.handleCurrency(org, year, period, currencyNum, modelQFilter);
        this.org = Pair.onePair((Object)org.getLong("id"), (Object)orgNum);
        this.scene = Pair.onePair((Object)scene.getLong("id"), (Object)sceneNum);
        this.year = Pair.onePair((Object)year.getLong("id"), (Object)yearNum);
        this.period = Pair.onePair((Object)period.getLong("id"), (Object)periodNum);
        this.tmplList = tmplList;
        this.initScope(param.get("scope"));
    }

    private void validateParam(DynamicObject dyn, DimTypesEnum dim) {
        if (dyn == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684%s\u4e0d\u5b58\u5728\u3002", (String)"BIFetchContext_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim.getName()));
        }
    }

    private void handleProcess(DynamicObject org, List<String> processList, QFilter modelQFilter) {
        String process;
        boolean isNewModel = QueryServiceHelper.exists((String)"bcm_currencymembertree", (QFilter[])new QFilter[]{modelQFilter, new QFilter("number", "=", (Object)CurrencyEnum.DC.getNumber())});
        boolean isLeaf = TreeStructureServiceHelper.isLeafMembNode((String)"bcm_entitymembertree", (String)org.getString("number"), (Object)this.model.p1);
        String string = isNewModel ? "IRpt" : (process = isLeaf ? "IRpt" : "CS");
        if (processList.size() == 0) {
            processList.add(process);
        } else {
            for (int i = 0; i < processList.size(); ++i) {
                if (!processList.get(i).equals("IRpt") && !processList.get(i).equals("CS")) continue;
                processList.set(i, process);
            }
        }
        this.processList = processList;
    }

    private void handleCurrency(DynamicObject org, DynamicObject year, DynamicObject period, String currencyNum, QFilter modelQFilter) {
        Long curId = 0L;
        String curNum = "";
        if (CurrencyEnum.EC.getNumber().equals(currencyNum) || CurrencyEnum.DC.getNumber().equals(currencyNum)) {
            DynamicObject orgCurrency = OrgCurrencyServiceHelper.getOrgById((Long)org.getLong("id"), (Long)year.getLong("id"), (Long)period.getLong("id"));
            curId = orgCurrency.getLong("currency.id");
            curNum = orgCurrency.getString("currency.number");
            this.EC2RealCurrency = Pair.onePair((Object)currencyNum, (Object)curNum);
        } else {
            DynamicObject currency = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)"id, number", (QFilter[])new QFilter[]{modelQFilter, new QFilter("number", "=", (Object)currencyNum)});
            this.validateParam(currency, DimTypesEnum.CURRENCY);
            curId = currency.getLong("id");
            curNum = currency.getString("number");
        }
        this.currency = Pair.onePair((Object)curId, (Object)curNum);
    }

    private void checkPerm(DynamicObject model, DynamicObject org) {
        this.log.info(String.format("BIFetchContext userId is %s", LongUtil.toLong((Object)RequestContext.get().getUserId())));
        Set modelids = MemberPermHelper.getLimitedModelListByUser();
        if (modelids.contains(model.getLong("id"))) {
            return;
        }
        HasPermDimObjResult result = PermissionServiceHelper.getUserHasPermDimObjs((long)LongUtil.toLong((Object)RequestContext.get().getUserId()), (String)"bcm_model");
        if (result.hasAllDimObjPerm()) {
            return;
        }
        Long orgDimId = DimensionServiceHelper.getIdByNum((String)"bcm_dimension", (long)model.getLong("id"), (String)DimEntityNumEnum.ENTITY.getNumber());
        HashSet<Long> orgIds = new HashSet<Long>(2);
        orgIds.add(org.getLong("id"));
        if (PermissionServiceImpl.getInstance((Long)model.getLong("id")).isAllNoPerm(orgDimId, "bcm_entitymembertree", orgIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u67e5\u8be2\u6743\u9650\u3002", (String)"BIFetchContext_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void initScope(Object scope) {
        if (scope == null) {
            return;
        }
        try {
            Map objectMap = scope instanceof String ? (Map)JSONUtils.cast((String)((String)scope), Map.class) : (Map)scope;
            List dimensions = DimensionServiceHelper.getDimensionNumListByModel((Object)this.model.p1);
            dimensions.forEach(d -> {
                if (!this.MUSTDIM.contains(d) && objectMap.get(d) != null) {
                    this.scope.put((String)d, Arrays.asList(objectMap.get(d).toString().split(",")));
                }
            });
        }
        catch (IOException e) {
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
    }

    @Override
    public Pair<Long, String> getCurrency() {
        return this.currency;
    }

    @Override
    public Pair<Long, String> getYear() {
        return this.year;
    }

    @Override
    public Pair<Long, String> getPeriod() {
        return this.period;
    }

    @Override
    public Pair<Long, String> getOrg() {
        return this.org;
    }

    @Override
    public Pair<Long, String> getModel() {
        return this.model;
    }

    @Override
    public Pair<Long, String> getScene() {
        return this.scene;
    }

    @Override
    public List<String> getProcessList() {
        return this.processList;
    }

    @Override
    public List<String> getTmplList() {
        return this.tmplList;
    }

    @Override
    public Map<String, Object> getScope() {
        return this.scope;
    }

    @Override
    public Pair<String, String> getEC2RealCurrency() {
        return this.EC2RealCurrency;
    }
}

