/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.intergration.di.utils.DIUserSelectUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public abstract class DIAbstractListPlugin
extends AbstractBaseListPlugin {
    protected long getSchemeId() {
        Long schemeId = (Long)ThreadCache.get((Object)"getSchemeId");
        if (schemeId != null) {
            return schemeId;
        }
        Optional<IDataEntityProperty> schemeProp = DIUserSelectUtil.getSchemeProp(this.getView());
        if (schemeProp.isPresent()) {
            DynamicObject scheme = (DynamicObject)this.getModel().getValue(schemeProp.get().getName());
            schemeId = scheme == null ? 0L : scheme.getLong("id");
        }
        if (schemeId == null) {
            schemeId = 0L;
        } else if (schemeId != 0L) {
            ThreadCache.put((Object)"getSchemeId", (Object)schemeId);
        }
        return schemeId;
    }

    @Override
    protected void refreshBillByUserSelect(List<String> dimKeys, Boolean isOnlyLeaf) {
        if (GuidePageUtils.refreshBillByUserSelect4List(dimKeys, this.getView())) {
            return;
        }
        if (!this.isInitF7BySelected) {
            return;
        }
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model");
        if (StringUtils.isEmpty((String)modelId)) {
            this.getPageCache().put("KEY_MODEL_ID", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f53\u7cfb\u53ef\u4ee5\u4f7f\u7528\u3002", (String)"AbstractBaseListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject userSelect;
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId);
            ApplicationTypeEnum application = this.getApplicationType();
            SingleMemberF7Util.cacheModelPrem(this.getPageCache(), Long.valueOf(modelId), application);
            ArrayList<String> dimensions = new ArrayList<String>(10);
            for (String key : dimKeys) {
                dimensions.add(UserSelectUtil.getDimensionByKey(key));
                dimensions.add(UserSelectUtil.getDimensionByKey(key) + ".membermodel");
                dimensions.add(key + ".isleaf");
            }
            String selectFields = UserSelectUtil.buildOtherSelectFileds(dimensions);
            if (DIUserSelectUtil.isHasScheme(this.getView())) {
                selectFields = selectFields + ",config";
            }
            if ((userSelect = UserSelectUtil.getUserSelectDynamicObject(selectFields, application)) == null || !modelId.equals(userSelect.getString("model"))) {
                return;
            }
            this.getModel().beginInit();
            if (DIUserSelectUtil.isHasScheme(this.getView())) {
                JSONObject jsonObject;
                Long schemeId;
                String name = DIUserSelectUtil.getSchemeProp(this.getView()).get().getName();
                String config = userSelect.getString("config");
                if (StringUtils.isNotEmpty((String)config) && (schemeId = (jsonObject = JSONObject.parseObject((String)config)).getLong("scheme")) != null) {
                    this.getView().getModel().setValue(name, (Object)schemeId);
                }
            }
            PermissionService permSerivce = PermissionServiceImpl.getInstance((Long)LongUtil.toLong((Object)modelId));
            for (String key : dimKeys) {
                try {
                    boolean isNoPerm;
                    SysDimensionEnum dim;
                    Long memberId = userSelect.getLong(key);
                    if (memberId == 0L || !QueryServiceHelper.exists((String)(dim = SysDimensionEnum.getEnumByLowerCaseNumber((String)key)).getMemberTreefrom(), (QFilter[])QFilter.of((String)"model = ? and id = ?", (Object[])new Object[]{Long.valueOf(modelId), memberId}).toArray()) || (isNoPerm = permSerivce.isAllNoPerm(Long.valueOf(userSelect.getLong(UserSelectUtil.getDimensionByKey(key))), userSelect.getString(UserSelectUtil.getDimensionByKey(key) + ".membermodel"), (Collection)Lists.newArrayList((Object[])new Long[]{memberId}))) || isOnlyLeaf.booleanValue() && !userSelect.getBoolean(key + ".isleaf")) continue;
                    this.getModel().setValue(key, (Object)memberId);
                    this.getPageCache().put(key, String.valueOf(memberId));
                }
                catch (Exception e) {
                    log.error(String.format("Model %1$s userSelect get dim %2$s error", modelId, key));
                }
            }
            this.getModel().endInit();
        }
    }

    @Override
    protected void propertyChangedModelUse(List<String> dimKeys) {
        DIUserSelectUtil.propertyChangedModelUse(this.getView(), dimKeys);
    }

    protected void propertyChangedUse(String key, DynamicObject newValue, Boolean isOnlyLeaf, Boolean hasCurrency) {
        DIUserSelectUtil.propertyChangedUse(this.getView(), key, newValue, isOnlyLeaf, hasCurrency);
    }
}

