/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.IndexInfo;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.spread.common.util.StringUtil;

public class DIAddTableIndexPlugin
extends AbstractBaseFormPlugin {
    private String TABLENAME = "tableName";
    private String INDEXSET = "indexSet";
    private String TALBETYPE_IMPORT = "1";
    private String TALBETYPE_COMP = "2";
    private String TALBETYPE_COMP_NOT_APPLY = "4";
    private String TALBETYPE_IMPORT_NOT_APPLY = "3";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_search", "btn_addindex", "btn_deleteindex", "btn_addandapply", "btn_deleteandapply");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        switch (key = Control2.getKey()) {
            case "btn_search": {
                this.searchTable();
                break;
            }
            case "btn_addindex": {
                this.addIndex(false);
                break;
            }
            case "btn_deleteindex": {
                this.deleteIndex(false);
                break;
            }
            case "btn_addandapply": {
                this.addIndex(true);
                break;
            }
            case "btn_deleteandapply": {
                this.deleteIndex(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIndex(boolean isApply) {
        String indexname = (String)this.getView().getModel().getValue("indexname");
        if (StringUtil.isEmptyString((String)indexname)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7d22\u5f15\u540d\u3002", (String)"DIAddTableIndexPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        indexname = indexname.trim();
        String indexSetStr = this.getPageCache().get(this.INDEXSET);
        Set indexSet = (Set)JSONObject.parseObject((String)indexSetStr, Set.class);
        if (!indexSet.contains(indexname)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7d22\u5f15\u662f\u5426\u5b58\u5728\u3002", (String)"DIAddTableIndexPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String tableName = this.getPageCache().get(this.TABLENAME);
        String indexFields = this.getIndesField(tableName, indexname);
        if (indexFields == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7d22\u5f15\u662f\u5426\u5b58\u5728\u3002", (String)"DIAddTableIndexPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject scheme = this.getSchemeByTableName(tableName);
        ArrayList<String> tableTypes = new ArrayList<String>(16);
        tableTypes.add(tableName.toLowerCase(Locale.ENGLISH).endsWith("_cp") ? this.TALBETYPE_COMP : this.TALBETYPE_IMPORT);
        tableTypes.add(tableName.toLowerCase(Locale.ENGLISH).endsWith("_cp") ? this.TALBETYPE_COMP_NOT_APPLY : this.TALBETYPE_IMPORT_NOT_APPLY);
        boolean exists = this.isIndexExists(scheme.getLong("scheme"), indexFields, tableTypes);
        if (!exists) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u4e0d\u662f\u901a\u8fc7\u540e\u53f0\u6dfb\u52a0\u7684\u7d22\u5f15\u3002", (String)"DIAddTableIndexPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                String sql = "DROP INDEX " + tableName + "." + indexname;
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sql);
                if (isApply) {
                    this.deleteApply(tableName, indexFields);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                log.error(String.format("UpgradeServiceHelper - upgrade: %s", e.getMessage()));
            }
        }
        finally {
            this.getModel().setValue("mulcombofield", null);
            this.getModel().setValue("indexname", null);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"DIAddTableIndexPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private boolean isIndexExists(long schemeId, String indexFields, List<String> tableTypes) {
        QFilter schemeQf = new QFilter("scheme", "=", (Object)schemeId);
        QFilter fieldsQf = new QFilter("indexfields", "=", (Object)indexFields);
        QFilter typeQf = new QFilter("tabletype", "in", tableTypes);
        return QueryServiceHelper.exists((String)"di_tableindexapply", (QFilter[])new QFilter[]{schemeQf, fieldsQf, typeQf});
    }

    private String getIndesField(String tableName, String indexName) {
        List indexInfo = DB.getIndexInfo((DBRoute)BCMConstant.DBROUTE, (String)tableName);
        for (IndexInfo index : indexInfo) {
            if (!indexName.equals(index.getIndexName())) continue;
            StringBuilder sb = new StringBuilder(16);
            for (IndexInfo.IndexFieldInfo fieldInfo : index.getIndexFieldInfo()) {
                sb.append(fieldInfo.getFieldName()).append(",");
            }
            return sb.substring(0, sb.length() - 1);
        }
        return null;
    }

    private void deleteApply(String tableName, String indexFields) {
        DynamicObject scheme = this.getSchemeByTableName(tableName);
        QFilter schemeQf = new QFilter("scheme", "=", (Object)scheme.getLong("scheme"));
        QFilter fieldsQf = new QFilter("indexfields", "=", (Object)indexFields);
        QFilter typeQf = new QFilter("tabletype", "=", (Object)(tableName.toLowerCase(Locale.ENGLISH).endsWith("_cp") ? this.TALBETYPE_COMP : this.TALBETYPE_IMPORT));
        DeleteServiceHelper.delete((String)"di_tableindexapply", (QFilter[])new QFilter[]{schemeQf, fieldsQf, typeQf});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIndex(boolean isApply) {
        String tableName;
        boolean exists;
        String indexname = (String)this.getView().getModel().getValue("indexname");
        if (StringUtil.isEmptyString((String)indexname)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7d22\u5f15\u540d\u3002", (String)"DIAddTableIndexPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if ((indexname = indexname.trim()).length() > 50) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7d22\u5f15\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"DIAddTableIndexPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (indexname.matches("^\\d+.*")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7d22\u5f15\u540d\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\u3002", (String)"DIAddTableIndexPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String indexColumn = (String)this.getModel().getValue("mulcombofield");
        if (StringUtil.isEmptyString((String)indexColumn)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7d22\u5f15\u5b57\u6bb5\u3002", (String)"DIAddTableIndexPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (indexColumn.startsWith(",")) {
            indexColumn = indexColumn.substring(1, indexColumn.length());
        }
        if (indexColumn.endsWith(",")) {
            indexColumn = indexColumn.substring(0, indexColumn.length() - 1);
        }
        if (exists = this.isExistsTheIndex(tableName = this.getPageCache().get(this.TABLENAME), indexColumn, indexname)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5b57\u6bb5\u4e3a%1$s\u7684\u7d22\u5f15\u6216\u540d\u4e3a%2$s\u7684\u7d22\u5f15\u3002", (String)"DIAddTableIndexPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), indexColumn, indexname));
            return;
        }
        String sql = "CREATE INDEX " + indexname + " ON " + tableName + " ( " + indexColumn + " );";
        try (TXHandle tx = TX.required();){
            try {
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sql);
                this.saveApply(tableName, indexname, indexColumn, isApply);
            }
            catch (Exception e) {
                tx.markRollback();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002", (String)"DIAddTableIndexPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                log.error("UpgradeServiceHelper - upgrade: %s", (Throwable)e);
            }
        }
        finally {
            this.getModel().setValue("mulcombofield", null);
            this.getModel().setValue("indexname", null);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"DIAddTableIndexPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private boolean isExistsTheIndex(String tableName, String indexColumn, String indexname) {
        List indexInfo = DB.getIndexInfo((DBRoute)BCMConstant.DBROUTE, (String)tableName);
        StringBuilder sb = new StringBuilder();
        for (IndexInfo index : indexInfo) {
            if (indexname.equals(index.getIndexName())) {
                return true;
            }
            List indexFieldInfo = index.getIndexFieldInfo();
            for (int i = 0; i < indexFieldInfo.size(); ++i) {
                sb.append(((IndexInfo.IndexFieldInfo)indexFieldInfo.get(i)).getFieldName());
                if (i == indexFieldInfo.size() - 1) continue;
                sb.append(",");
            }
            if (!indexColumn.equals(sb.toString())) continue;
            return true;
        }
        return false;
    }

    private void saveApply(String tableName, String indexname, String indexFields, boolean isApply) {
        DynamicObject scheme = this.getSchemeByTableName(tableName);
        Long schemeId = scheme.getLong("scheme");
        ArrayList<String> tableTypes = new ArrayList<String>(16);
        tableTypes.add(tableName.toLowerCase(Locale.ENGLISH).endsWith("_cp") ? this.TALBETYPE_COMP : this.TALBETYPE_IMPORT);
        tableTypes.add(tableName.toLowerCase(Locale.ENGLISH).endsWith("_cp") ? this.TALBETYPE_COMP_NOT_APPLY : this.TALBETYPE_IMPORT_NOT_APPLY);
        boolean exists = this.isIndexExists(schemeId, indexFields, tableTypes);
        if (exists) {
            return;
        }
        DynamicObject apply = BusinessDataServiceHelper.newDynamicObject((String)"di_tableindexapply");
        apply.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        apply.set("scheme", (Object)schemeId);
        apply.set("indexname", (Object)indexname);
        apply.set("referencetable", (Object)tableName);
        if (isApply) {
            apply.set("tabletype", (Object)(tableName.toLowerCase(Locale.ENGLISH).endsWith("_cp") ? this.TALBETYPE_COMP : this.TALBETYPE_IMPORT));
        } else {
            apply.set("tabletype", (Object)(tableName.toLowerCase(Locale.ENGLISH).endsWith("_cp") ? this.TALBETYPE_COMP_NOT_APPLY : this.TALBETYPE_IMPORT_NOT_APPLY));
        }
        apply.set("indexfields", (Object)indexFields);
        apply.set("creator", (Object)RequestContext.get().getCurrUserId());
        apply.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{apply});
    }

    private DynamicObject getSchemeByTableName(String tableName) {
        QFilter qf = new QFilter("imptable", "=", (Object)tableName);
        if (tableName.toLowerCase(Locale.ENGLISH).endsWith("_cp")) {
            qf = new QFilter("comptable", "=", (Object)tableName);
        }
        return QueryServiceHelper.queryOne((String)"di_tableroute", (String)"scheme", (QFilter[])new QFilter[]{qf});
    }

    private void searchTable() {
        String tablename = (String)this.getView().getModel().getValue("tablename");
        if (StringUtil.isEmptyString((String)tablename)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8868\u540d\u3002", (String)"DIAddTableIndexPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qf = new QFilter("imptable", "=", (Object)tablename).or(new QFilter("comptable", "=", (Object)tablename));
        if (!QueryServiceHelper.exists((String)"di_tableroute", (QFilter[])new QFilter[]{qf})) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8868\u5728\u7d22\u5f15\u8868\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"DIAddTableIndexPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!DB.exitsTable((DBRoute)BCMConstant.DBROUTE, (String)tablename)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8868\u4e0d\u5b58\u5728\u3002", (String)"DIAddTableIndexPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(this.TABLENAME, tablename);
        this.setIndexText(tablename);
        this.setCombo(tablename);
    }

    private void setIndexText(String tableName) {
        List indexInfo = DB.getIndexInfo((DBRoute)BCMConstant.DBROUTE, (String)tableName);
        StringBuilder sb = new StringBuilder();
        HashSet<String> indexSet = new HashSet<String>(5);
        for (IndexInfo index : indexInfo) {
            sb.append(index.getIndexName()).append(":");
            indexSet.add(index.getIndexName());
            List indexFieldInfo = index.getIndexFieldInfo();
            for (int i = 0; i < indexFieldInfo.size(); ++i) {
                sb.append(((IndexInfo.IndexFieldInfo)indexFieldInfo.get(i)).getFieldName());
                if (i == indexFieldInfo.size() - 1) continue;
                sb.append(",");
            }
            sb.append("\n");
        }
        this.getPageCache().put(this.INDEXSET, JSONObject.toJSONString(indexSet));
        Label label = (Label)this.getView().getControl("labelap1");
        label.setText(sb.toString());
    }

    private void setCombo(String tableName) {
        MulComboEdit mce = (MulComboEdit)this.getControl("mulcombofield");
        List columnNames = DB.getColumnNames((DBRoute)BCMConstant.DBROUTE, (String)tableName);
        ArrayList<ComboItem> processComboItems = new ArrayList<ComboItem>(columnNames.size());
        for (String column : columnNames) {
            ComboItem ci = new ComboItem();
            ci.setCaption(new LocaleString(column));
            ci.setValue(column);
            processComboItems.add(ci);
            mce.setComboItems(processComboItems);
        }
    }
}

