/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.ImportStartData;
import kd.bos.form.plugin.ImportStartPlugin;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.intergration.di.importexport.DIDeriveRuleExportImp;
import kd.fi.bcm.formplugin.intergration.di.importexport.DIDeriveRuleImportImp;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DIDeriveRuleStartPlugin
extends ImportStartPlugin
implements BCMBaseFunction {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DIDeriveRuleStartPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile", "btnimgzipdelete"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String titleName = showParam.getCustomParam("title").toString();
        Label title = (Label)this.getControl("title");
        title.setText(titleName);
        this.getModel().setValue("importtype", (Object)ImportStartData.ImportStartTypeEnum.OVERRIDENEW.getType());
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue("filepath", (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
                break;
            }
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                FormShowParameter parameter = this.getView().getFormShowParameter();
                Long schemeId = (Long)parameter.getCustomParam("schemeId");
                String schemeName = (String)parameter.getCustomParam("schemeName");
                DIDeriveRuleExportImp exportService = new DIDeriveRuleExportImp();
                XSSFWorkbook workbook = exportService.exportTemplate(schemeId);
                try {
                    String url = ImportAndExportUtil.writeFile(workbook, String.format(ResManager.loadKDString((String)"%1$s_\u7279\u6b8a\u8f6c\u6362\u89c4\u5219\u5bfc\u51fa\u6a21\u677f", (String)"DIDeriveRuleStartPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), schemeName));
                    this.downloadFile(url, null, null);
                    break;
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u6a21\u677f\u5931\u8d25", (String)"DIDeriveRuleStartPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void importData() {
        String url = (String)this.getModel().getValue("filepath");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long schemeId = (Long)parameter.getCustomParam("schemeId");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"DIDeriveRuleStartPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            DIDeriveRuleImportImp importService = new DIDeriveRuleImportImp();
            String importModel = this.getModel().getValue("importtype").toString();
            importService.importData(url, schemeId, importModel);
            this.openTipsPage(importService.getErrorMsgs(), importService.getSuccessCount());
        }
    }

    private void openTipsPage(List<Object> errorMsgs, Integer successCount) {
        String titleInfo = errorMsgs.size() > 0 ? String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f%1$s\u884c\uff0c\u5c55\u5f00\u8be6\u60c5\u67e5\u770b\u5931\u8d25\u6570\u636e", (String)"DIDeriveRuleStartPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), successCount) : String.format(ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u5165%1$s\u884c\u3002", (String)"DIDeriveRuleStartPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), successCount);
        String detailInfo = "";
        detailInfo = errorMsgs.size() > 2000 ? errorMsgs.subList(0, 1999).stream().map(Object::toString).collect(Collectors.joining("")) : errorMsgs.stream().map(Object::toString).collect(Collectors.joining(""));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("di_membmapimporttip");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("title", (Object)titleInfo);
        showParameter.setCustomParam("isAllSuccess", (Object)(errorMsgs.size() == 0 ? 1 : 0));
        showParameter.setCustomParam("detail", (Object)detailInfo);
        this.getView().showForm(showParameter);
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String url = (String)urls[0];
            IFormView view = this.getView();
            view.setVisible(Boolean.TRUE, new String[]{"filepanel"});
            view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)url.substring(url.lastIndexOf("/") + 1));
            model.setValue("filepath", (Object)url);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }
}

