/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityCollection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integration.model.SrcDimCommonModel;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.intergration.di.DIAbstractListPlugin;
import kd.fi.bcm.formplugin.intergration.di.DIMappingDTO;
import kd.fi.bcm.formplugin.intergration.di.DIMappingVO;
import kd.fi.bcm.formplugin.intergration.di.SelectDimDTO;
import kd.fi.bcm.formplugin.intergration.util.DISchemeUtil;

public class DIDimMapListPlugin
extends DIAbstractListPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TAG_DIM = "tagdim";
    private static final String TAG_DIM_IDS = "tagdimids";
    private static final String DIM_IDS = "dimids";
    private static final String SRC_DIM = "srcdim";
    private static final String SRC_DIM_IDS = "srcdimids";
    private static final String TAG_DIM_DEF_VALUE = "tagdimdefvalue";
    private static final String TAG_DIM_DEF_VALUE_IDS = "tagdimdefvalueids";
    private static final String SET_DIM_MAP = "setDimMap";
    private static final String TYPE = "type";
    public static final String NAME = "mname1";
    public static final String NUMBER = "mnum1";
    public static final String ID = "mid1";
    private static final String SCHEME = "scheme";
    private static final String MODEL = "model";
    private static final String CAESURA_SIGN = "\u3001";
    private static final String SAVE_TYPE_MODIFY = "modify";
    private static final String SAVE_TYPE_SAME = "same";
    private static final String SAVE_TYPE_ADD = "add";
    private static final String DI_MAPPING_DTOS = "diMappingDTOs";
    private static final String PRIORITY = "priority";
    private static final String DATATYPE = "datatype";
    private static final String INHERITANCE_SCHEME = "inheritancescheme";
    private static final String SELECT_FIELD = "selectField";
    private static final String NEED_CLEAR_TABLE_ROUTE = "needcleartableroute";
    private static final String MAPPED_TYPE = "mappedtype";
    private static final List<String> MUST_TAG_DIM_DEF_LIST = Arrays.asList(DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber(), DimTypesEnum.SCENARIO.getNumber());

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit bdEdit = (BasedataEdit)this.getControl(SCHEME);
        if (bdEdit != null) {
            bdEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        super.registerListener(e);
        this.addClickListeners(TAG_DIM, SRC_DIM, TAG_DIM_DEF_VALUE);
        EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                DIDimMapListPlugin.this.rowClick();
            }
        });
        BasedataEdit edit = (BasedataEdit)this.getControl(INHERITANCE_SCHEME);
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void rowClick() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
        if (rowObj.getBoolean("issys")) {
            if (this.isOlapDim(rowObj)) {
                this.setDeleteBtnDisable();
            } else if (this.isUniqueEXTFiled(rowObj.getLong(TAG_DIM_IDS)).booleanValue()) {
                this.setDeleteBtnDisable();
            } else {
                this.setDeleteBtnEnable();
            }
        } else if (rowObj.getString(MAPPED_TYPE) != null && rowObj.getString(MAPPED_TYPE).equals(DimMappTypeEnum.SPECIAL.getCode())) {
            this.setDeleteBtnDisable();
        } else {
            this.setDeleteBtnEnable();
        }
    }

    private Long getExtendsModelId(Long schemeId) {
        QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)schemeId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"extendsmodel", (QFilter[])qfBuilder.toArray());
        return dyn.getLong("extendsmodel");
    }

    private boolean isOlapDim(DynamicObject rowObj) {
        if (rowObj.getString(DATATYPE) != null && rowObj.getString(DATATYPE) != "") {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean isUniqueEXTFiled(Long extField) {
        Long schemeId = ((DynamicObject)this.getModel().getValue(SCHEME)).getLong("id");
        Long extModelId = this.getExtendsModelId(schemeId);
        QFBuilder qfBuilder = new QFBuilder("extmodelid", "=", (Object)extModelId).add("extfield", "=", (Object)extField).add("uniquecheck", "=", (Object)"1").or("isnecessary", "=", (Object)"1");
        Boolean isUnique = QueryServiceHelper.exists((String)"bcm_extmodelfield", (QFilter[])qfBuilder.toArray());
        return isUnique;
    }

    private void setDeleteBtnEnable() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"delete"});
    }

    private void setDeleteBtnDisable() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"delete"});
    }

    private void setPriorityState() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        Map<String, Integer> tagDimCountMap = this.getTagDimMap(entryEntity);
        Set<String> isSameTagDim = this.getSameTagDim(tagDimCountMap);
        Set<String> onlyOneTagDim = this.getOneTagDim(tagDimCountMap);
        this.setAllPriorityDisable(entryEntity);
        this.setPriorityEnable(isSameTagDim, entryEntity);
        this.emptyPriorityState(onlyOneTagDim, entryEntity);
    }

    private Map<String, Integer> getTagDimMap(DynamicObjectCollection entryEntity) {
        HashMap<String, Integer> tagDimCountMap = new HashMap<String, Integer>(entryEntity.size());
        for (DynamicObject d : entryEntity) {
            if (DimMappTypeEnum.TARGET_DEFAULT.getCode().equals(d.getString(MAPPED_TYPE)) || DimMappTypeEnum.SPECIAL.getCode().equals(d.getString(MAPPED_TYPE))) continue;
            tagDimCountMap.put(d.getString(TAG_DIM_IDS), tagDimCountMap.getOrDefault(d.getString(TAG_DIM_IDS), 0) + 1);
        }
        return tagDimCountMap;
    }

    private Set<String> getOneTagDim(Map<String, Integer> tagDimCountMap) {
        HashSet<String> onlyOneTagDim = new HashSet<String>(8);
        Set<Map.Entry<String, Integer>> set = tagDimCountMap.entrySet();
        for (Map.Entry<String, Integer> integerEntry : set) {
            if (integerEntry.getValue() != 1) continue;
            onlyOneTagDim.add(integerEntry.getKey());
        }
        return onlyOneTagDim;
    }

    private Set<String> getSameTagDim(Map<String, Integer> tagDimCountMap) {
        HashSet<String> isSameTagDim = new HashSet<String>(8);
        Set<Map.Entry<String, Integer>> set = tagDimCountMap.entrySet();
        for (Map.Entry<String, Integer> integerEntry : set) {
            if (integerEntry.getValue() <= 1 || !StringUtils.isNotEmpty((String)integerEntry.getKey())) continue;
            isSameTagDim.add(integerEntry.getKey());
        }
        return isSameTagDim;
    }

    private void setAllPriorityDisable(DynamicObjectCollection entryEntity) {
        for (int k = 0; k < entryEntity.size(); ++k) {
            this.getView().setEnable(Boolean.FALSE, k, new String[]{PRIORITY});
        }
    }

    private void emptyPriorityState(Set<String> onlyOneTagDim, DynamicObjectCollection entryEntity) {
        for (String s : onlyOneTagDim) {
            int j = 0;
            for (DynamicObject d : entryEntity) {
                if (s.equals(d.getString(TAG_DIM_IDS)) && d.getLong(PRIORITY) != 0L) {
                    this.getModel().setValue(PRIORITY, (Object)0, j);
                }
                ++j;
            }
        }
    }

    private void setPriorityEnable(Set<String> isSameTagDim, DynamicObjectCollection entryEntity) {
        if (isSameTagDim.size() > 0) {
            for (String s : isSameTagDim) {
                int j = 0;
                for (DynamicObject d : entryEntity) {
                    if (s.equals(d.getString(TAG_DIM_IDS)) && StringUtils.isEmpty((String)d.getString(TAG_DIM_DEF_VALUE_IDS))) {
                        this.getView().setEnable(Boolean.TRUE, j, new String[]{PRIORITY});
                    }
                    ++j;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Object type = e.getSource();
        if (type instanceof NewEntry) {
            int index = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getView().setEnable(Boolean.FALSE, index, new String[]{PRIORITY});
        }
        if (type instanceof DeleteEntry) {
            this.setPriorityState();
            this.rowClick();
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long schemeId;
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(Collections.emptyList(), false);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        if (scheme != null && (schemeId = Long.valueOf(scheme.getLong("id"))) != 0L) {
            this.schemeChanged(schemeId);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (!this.validate() && !"btn_exit".equals(itemKey)) {
            return;
        }
        if ("btn_refresh".equals(itemKey)) {
            this.refreshEntity();
        }
        if ("btn_save".equals(itemKey)) {
            String needClearTableRoute;
            String errorMsg = this.checkEntryEntity();
            if (errorMsg != null) {
                this.getView().showErrorNotification(errorMsg);
                return;
            }
            List<DIMappingDTO> diMappingDTOs = this.getDIMappingDTOs();
            HashSet<Long> checkIds = new HashSet<Long>(8);
            HashSet<String> allPageDims = new HashSet<String>(diMappingDTOs.size() * 2);
            HashSet<String> allDBDims = new HashSet<String>(diMappingDTOs.size() * 2);
            this.checkDataModify(diMappingDTOs, checkIds, allPageDims, allDBDims);
            Set<Long> deleteIds = this.getNeedDeleteDimMapIds(diMappingDTOs);
            checkIds.addAll(deleteIds);
            DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
            Long schemeId = scheme.getLong("id");
            String prompt = this.showConfirm(checkIds, allPageDims, allDBDims, schemeId);
            String string = needClearTableRoute = this.needClearTableRoute(allPageDims, allDBDims, schemeId) != false ? "1" : "0";
            if (StringUtils.isNotEmpty((String)prompt)) {
                this.getView().showConfirm(prompt, MessageBoxOptions.YesNo, new ConfirmCallBackListener("change", (IFormPlugin)this));
                this.getPageCache().put(DI_MAPPING_DTOS, ObjectSerialUtil.toByteSerialized(diMappingDTOs));
                this.getPageCache().put(NEED_CLEAR_TABLE_ROUTE, needClearTableRoute);
                return;
            }
            this.doSave(diMappingDTOs, deleteIds);
        }
    }

    private String showConfirm(Set<Long> checkIds, Set<String> allPageDims, Set<String> allDBDims, Long schemeId) {
        String prompt = "";
        Boolean needClearTableRoute = this.needClearTableRoute(allPageDims, allDBDims, schemeId);
        Boolean needConfirmFlag = Boolean.FALSE;
        Boolean checkIdsFlag = checkIds.size() > 0;
        if (checkIdsFlag.booleanValue()) {
            needConfirmFlag = this.needConfirm(checkIds);
        }
        if (needConfirmFlag.booleanValue() && !needClearTableRoute.booleanValue()) {
            prompt = ResManager.loadKDString((String)"\u4fee\u6539\u5f53\u524d\u7ef4\u5ea6\u6620\u5c04\u5c06\u4f1a\u6e05\u9664\u5df2\u5b58\u5728\u7684\u6210\u5458\u6620\u5c04\u914d\u7f6e\uff0c\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"ISDimMappingAddPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (needConfirmFlag.booleanValue() && needClearTableRoute.booleanValue()) {
            prompt = ResManager.loadKDString((String)"\u4fee\u6539\u5f53\u524d\u7ef4\u5ea6\u6620\u5c04\u5c06\u4f1a\u6e05\u9664\u5df2\u5b58\u5728\u7684\u96c6\u6210\u65b9\u6848\u5386\u53f2\u6570\u636e\u53ca\u6210\u5458\u6620\u5c04\u914d\u7f6e\uff0c\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"ISDimMappingAddPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (!needConfirmFlag.booleanValue() && needClearTableRoute.booleanValue()) {
            prompt = ResManager.loadKDString((String)"\u4fee\u6539\u5f53\u524d\u7ef4\u5ea6\u6620\u5c04\u5c06\u4f1a\u6e05\u9664\u96c6\u6210\u65b9\u6848\u5386\u53f2\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"ISDimMappingAddPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return prompt;
    }

    private Boolean needClearTableRoute(Set<String> allPageDims, Set<String> allDBDims, Long schemeId) {
        if (DIIntegrationUtil.existTableRouteData((Long)schemeId).booleanValue()) {
            return allPageDims != null && !allPageDims.equals(allDBDims);
        }
        return Boolean.FALSE;
    }

    private void doSave(List<DIMappingDTO> diMappingDTOs, Set<Long> deleteIds) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.deleteDimMapById(deleteIds);
                this.saveDimMappings(diMappingDTOs);
            }
            catch (Exception e) {
                tx.markRollback();
                log.error("doSave failed,information:" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30), (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DIDimMapListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        this.refreshEntity();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DISchemeEditPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
    }

    private Boolean needConfirm(Set<Long> modifyMappingIds) {
        DynamicObject groupDys = BusinessDataServiceHelper.loadSingle((String)"bcm_isgroupmap", (String)"data", (QFilter[])new QFilter[]{new QFilter("dimmapid", "in", modifyMappingIds)});
        if (groupDys != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * Unable to fully structure code
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        var3_3 = callBackId = messageBoxClosedEvent.getCallBackId();
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case -1361636432: {
                if (!var3_3.equals("change")) break;
                var4_4 = 0;
            }
        }
        switch (var4_4) {
            case 0: {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) ** GOTO lbl58
                tx = TX.requiresNew();
                var6_6 = null;
                try {
                    diMappingDTOs = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("diMappingDTOs"));
                    needClearTableRoute = this.getPageCache().get("needcleartableroute");
                    if ("1".equals(needClearTableRoute)) {
                        scheme = (DynamicObject)this.getModel().getValue("scheme");
                        schemeId = scheme.getLong("id");
                        DIIntegrationUtil.clearTableRoute((long)schemeId);
                    }
                    deleteIds = this.getNeedDeleteDimMapIds(diMappingDTOs);
                    checkIds = diMappingDTOs.stream().filter((Predicate<DIMappingDTO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$confirmCallBack$0(kd.fi.bcm.formplugin.intergration.di.DIMappingDTO ), (Lkd/fi/bcm/formplugin/intergration/di/DIMappingDTO;)Z)()).map((Function<DIMappingDTO, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getMappingid(), (Lkd/fi/bcm/formplugin/intergration/di/DIMappingDTO;)Ljava/lang/Long;)()).collect(Collectors.toSet());
                    if (deleteIds.size() > 0) {
                        checkIds.addAll(deleteIds);
                    }
                    DISchemeUtil.deleteMemberMap(checkIds);
                    this.doSave(diMappingDTOs, deleteIds);
                }
                catch (Exception e) {
                    tx.markRollback();
                    DIDimMapListPlugin.log.error("confirmCallBack change failed,information:" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30), (Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DIDimMapListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (tx == null) break;
                if (var6_6 == null) ** GOTO lbl41
                try {
                    tx.close();
                }
                catch (Throwable var7_9) {
                    var6_6.addSuppressed(var7_9);
                }
                break;
lbl41:
                // 1 sources

                tx.close();
                break;
                catch (Throwable var7_10) {
                    try {
                        var6_6 = var7_10;
                        throw var7_10;
                    }
                    catch (Throwable var11_14) {
                        if (tx != null) {
                            if (var6_6 != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable var12_15) {
                                    var6_6.addSuppressed(var12_15);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        throw var11_14;
                    }
                }
lbl58:
                // 1 sources

                if (!MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) break;
                this.getPageCache().remove("diMappingDTOs");
                this.getModel().setDataChanged(false);
                break;
            }
        }
    }

    private boolean validate() {
        if (this.getModel().getValue(MODEL) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DISBaseEntQueryListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue(SCHEME) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u3002", (String)"DISBaseEntQueryListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void deleteDimMapById(Set<Long> ids) {
        try {
            if (ids.size() == 0) {
                return;
            }
            DISchemeUtil.deleteDefMapping(ids);
            DeleteServiceHelper.delete((String)"bcm_isdimmap", (QFilter[])new QFilter("id", "in", ids).toArray());
        }
        catch (Exception e) {
            log.error("deleteDimMapById failed,information:" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5206\u5f55\u5220\u9664\u5931\u8d25\u3002", (String)"DIDimMapListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private Set<Long> getNeedDeleteDimMapIds(List<DIMappingDTO> diMappingDTOs) {
        Set<Long> pageIds = this.getPageDimMapIds(diMappingDTOs);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        Long schemeId = scheme.getLong("id");
        Set<Long> DBIds = this.getDBDimMapIds(schemeId);
        DBIds.removeAll(pageIds);
        return DBIds;
    }

    private Set<Long> getDBDimMapIds(Long schemeId) {
        QFBuilder filter = new QFBuilder(SCHEME, "=", (Object)schemeId);
        if (!DIIntegrationUtil.getSpecialMappingStatus((Long)schemeId).booleanValue()) {
            filter.add(MAPPED_TYPE, "!=", (Object)DimMappTypeEnum.SPECIAL.getCode());
        }
        return QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id", (QFilter[])filter.toArray()).stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
    }

    private Set<Long> getPageDimMapIds(List<DIMappingDTO> diMappingDTOs) {
        HashSet<Long> pageIds = new HashSet<Long>(diMappingDTOs.size());
        for (DIMappingDTO mappingDTO : diMappingDTOs) {
            if (null == mappingDTO.getMappingid() || mappingDTO.getMappingid() == 0L) continue;
            pageIds.add(mappingDTO.getMappingid());
        }
        return pageIds;
    }

    private void saveDimMappings(List<DIMappingDTO> mappingDTOs) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        Long schemeId = scheme.getLong("id");
        Long modelId = this.getSchemeModelId(scheme.getLong("id"));
        ArrayList<DynamicObject> dimMappingsModify = new ArrayList<DynamicObject>(mappingDTOs.size());
        ArrayList<DynamicObject> dimMappingsAdd = new ArrayList<DynamicObject>(mappingDTOs.size());
        QFilter filter = new QFilter(SCHEME, "=", (Object)schemeId);
        DynamicObjectCollection maxSeq = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"sequence", (QFilter[])filter.toArray(), (String)"sequence desc", (int)1);
        int seq = maxSeq.size() > 0 ? ((DynamicObject)maxSeq.get(0)).getInt("sequence") + 1 : 1;
        for (DIMappingDTO mappingDTO : mappingDTOs) {
            if (SAVE_TYPE_MODIFY.equals(mappingDTO.getDataSaveType())) {
                dimMappingsModify.add(this.saveModifyDimMapping(mappingDTO, currUserId, date));
                continue;
            }
            if (!SAVE_TYPE_ADD.equals(mappingDTO.getDataSaveType())) continue;
            DynamicObject dynamicObject = this.saveAddDimMapping(mappingDTO, currUserId, date, modelId, schemeId);
            dynamicObject.set("sequence", (Object)seq);
            ++seq;
            dimMappingsAdd.add(dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])dimMappingsModify.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])dimMappingsAdd.toArray(new DynamicObject[0]));
        DISchemeUtil.enableScheme(schemeId);
    }

    private DynamicObject saveAddDimMapping(DIMappingDTO mappingDTO, Long currUserId, Date date, Long modelId, Long schemeId) {
        DynamicObject dynamicObject = new DynamicObject();
        if (mappingDTO.getMappingType().equals(DimMappTypeEnum.TARGET_DEFAULT.getCode())) {
            dynamicObject = this.saveAddTagDimMapping(mappingDTO, currUserId, date, modelId, schemeId);
        } else if (mappingDTO.getMappingType().equals(DimMappTypeEnum.COMBO.getCode()) || mappingDTO.getMappingType().equals(DimMappTypeEnum.SIMPLE.getCode())) {
            dynamicObject = this.saveAddCobmoDimMapping(mappingDTO, currUserId, date, schemeId);
        }
        return dynamicObject;
    }

    private DynamicObject saveAddTagDimMapping(DIMappingDTO mappingDTO, Long currUserId, Date date, Long modelId, Long schemeId) {
        DynamicObject dimMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isdimmap");
        dimMapping.set(SCHEME, (Object)schemeId);
        dimMapping.set("creator", (Object)currUserId);
        dimMapping.set("createtime", (Object)date);
        dimMapping.set(MAPPED_TYPE, (Object)mappingDTO.getMappingType());
        dimMapping.set(PRIORITY, (Object)mappingDTO.getPriority());
        dimMapping.set("number", (Object)MemberReader.getDimensionNumById((long)LongUtil.toLong((Object)mappingDTO.getTagDimIds())));
        dimMapping.set("name", (Object)MemberReader.getDimensionNameById((long)LongUtil.toLong((Object)mappingDTO.getTagDimIds())));
        DynamicObjectCollection tagCollections = dimMapping.getDynamicObjectCollection("isdimmaptargentry");
        DynamicObject dimMappingtag = tagCollections.addNew();
        dimMappingtag.set("tagbyfrom", (Object)"1");
        dimMappingtag.set("tagdimtype", (Object)"bcm_dimension");
        dimMappingtag.set("tagdimension", (Object)mappingDTO.getTagDimIds());
        dimMappingtag.set("seq", (Object)1);
        List<String> tagDimDefValueIds = Arrays.asList(mappingDTO.getTagDimDefValueIds().split(","));
        int index = 1;
        String memberModel = MemberReader.getDimensionDynById((long)LongUtil.toLong((Object)mappingDTO.getTagDimIds())).getString("membermodel");
        for (String memberId : tagDimDefValueIds) {
            DynamicObjectCollection tagDefaultCollections = dimMappingtag.getDynamicObjectCollection("isdimmaptargdefval");
            DynamicObject dimMappingDefaultTag = tagDefaultCollections.addNew();
            IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)memberModel, (Long)LongUtil.toLong((Object)memberId));
            dimMappingDefaultTag.set("tagmemname", (Object)member.getName());
            dimMappingDefaultTag.set("tagmemb", (Object)memberId);
            dimMappingDefaultTag.set("targetmemnum", (Object)member.getNumber());
            dimMappingDefaultTag.set("seq", (Object)index);
            ++index;
        }
        return dimMapping;
    }

    private DynamicObject saveAddCobmoDimMapping(DIMappingDTO mappingDTO, Long currUserId, Date date, Long schemeId) {
        DynamicObject dimMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isdimmap");
        dimMapping.set(SCHEME, (Object)schemeId);
        dimMapping.set("creator", (Object)currUserId);
        dimMapping.set("createtime", (Object)date);
        dimMapping.set(MAPPED_TYPE, (Object)mappingDTO.getMappingType());
        dimMapping.set(PRIORITY, (Object)mappingDTO.getPriority());
        dimMapping.set(INHERITANCE_SCHEME, (Object)mappingDTO.getInheritanceScheme());
        DynamicObjectCollection tagCollections = dimMapping.getDynamicObjectCollection("isdimmaptargentry");
        List<String> tagDimIds = Arrays.asList(mappingDTO.getTagDimIds().split(","));
        int indexTag = 1;
        StringBuilder tagNumber = new StringBuilder();
        StringBuilder tagName = new StringBuilder();
        for (String tagDimId : tagDimIds) {
            DynamicObject dimMappingtarg = tagCollections.addNew();
            dimMappingtarg.set("tagbyfrom", (Object)"1");
            if (StringUtils.isEmpty((String)mappingDTO.getDataType())) {
                dimMappingtarg.set("tagdimtype", (Object)"bcm_dimension");
                tagNumber.append(MemberReader.getDimensionNumById((long)LongUtil.toLong((Object)tagDimId))).append(",");
                tagName.append(MemberReader.getDimensionNameById((long)LongUtil.toLong((Object)tagDimId))).append(",");
            } else {
                dimMapping.set(DATATYPE, (Object)mappingDTO.getDataType());
                dimMappingtarg.set("tagdimtype", (Object)"bcm_structofextend");
                DynamicObject extDny = DISchemeUtil.getStructOfExtendById(LongUtil.toLong((Object)tagDimId));
                tagNumber.append(extDny.getString("number")).append(",");
                tagName.append(extDny.getString("name")).append(",");
            }
            dimMappingtarg.set("tagdimension", (Object)tagDimId);
            dimMappingtarg.set("seq", (Object)indexTag);
            ++indexTag;
        }
        DynamicObjectCollection srcCollections = dimMapping.getDynamicObjectCollection("isdimmapsrcentry");
        List<String> srcDimIds = Arrays.asList(mappingDTO.getSrcDimIds().split(","));
        int indexSrc = 1;
        StringBuilder srcNumber = new StringBuilder();
        StringBuilder srcName = new StringBuilder();
        for (String srcDimId : srcDimIds) {
            DynamicObject dimMappingsrc = srcCollections.addNew();
            dimMappingsrc.set("srcbyfrom", (Object)"2");
            dimMappingsrc.set("srcdimtype", (Object)"bcm_isbaseentlist");
            dimMappingsrc.set("srcdimension", (Object)srcDimId);
            srcNumber.append(this.getBaseEntNumberById(LongUtil.toLong((Object)srcDimId))).append(",");
            srcName.append(this.getBaseEntNameById(LongUtil.toLong((Object)srcDimId))).append(",");
            dimMappingsrc.set("seq", (Object)indexSrc);
            ++indexSrc;
        }
        dimMapping.set("number", (Object)(tagNumber.substring(0, tagNumber.length() - 1) + "-" + srcNumber.substring(0, srcNumber.length() - 1)));
        dimMapping.set("name", (Object)(tagName.substring(0, tagName.length() - 1) + "-" + srcName.substring(0, srcName.length() - 1)));
        return dimMapping;
    }

    private String getBaseEntNameById(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bcm_isbaseentlist", (String)"name", (QFilter[])filter.toArray()).getString("name");
    }

    private String getBaseEntNumberById(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bcm_isbaseentlist", (String)"number", (QFilter[])filter.toArray()).getString("number");
    }

    private DynamicObject saveModifyDimMapping(DIMappingDTO mappingDTO, Long currUserId, Date date) {
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)mappingDTO.getMappingid(), (String)"bcm_isdimmap");
        List<String> tagIdsList = Arrays.asList(mappingDTO.getTagDimIds().split(","));
        DynamicObjectCollection tagDyn = dyn.getDynamicObjectCollection("isdimmaptargentry");
        tagDyn.clear();
        Long modelId = (Long)this.getModel().getValue("model_id");
        for (int i = 0; i < tagIdsList.size(); ++i) {
            DynamicObject dimtarg = tagDyn.addNew();
            dimtarg.set("tagbyfrom", (Object)"1");
            if (StringUtils.isEmpty((String)mappingDTO.getDataType())) {
                dimtarg.set("tagdimtype", (Object)"bcm_dimension");
            } else {
                dimtarg.set("tagdimtype", (Object)"bcm_structofextend");
                dyn.set(DATATYPE, (Object)mappingDTO.getDataType());
            }
            dimtarg.set("tagdimension", (Object)tagIdsList.get(i));
            dimtarg.set("seq", (Object)(i + 1));
            DynamicObjectCollection tagDefaultCollections = dimtarg.getDynamicObjectCollection("isdimmaptargdefval");
            if (StringUtils.isNotEmpty((String)mappingDTO.getTagDimDefValueIds()) && tagIdsList.size() == 1) {
                List<String> tagDimDefValueIdsList = Arrays.asList(mappingDTO.getTagDimDefValueIds().split(","));
                String memberModel = MemberReader.getDimensionDynById((long)LongUtil.toLong((Object)tagIdsList.get(i))).getString("membermodel");
                int index = 1;
                for (String memberId : tagDimDefValueIdsList) {
                    DynamicObject dimMappingDefaultTag = tagDefaultCollections.addNew();
                    IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)memberModel, (Long)LongUtil.toLong((Object)memberId));
                    dimMappingDefaultTag.set("tagmemname", (Object)member.getName());
                    dimMappingDefaultTag.set("tagmemb", (Object)member.getId());
                    dimMappingDefaultTag.set("targetmemnum", (Object)member.getNumber());
                    dimMappingDefaultTag.set("seq", (Object)index);
                    ++index;
                }
            }
            if (!StringUtils.isNotEmpty((String)mappingDTO.getSrcDimIds()) || !StringUtils.isEmpty((String)mappingDTO.getTagDimDefValueIds())) continue;
            tagDefaultCollections.clear();
        }
        DynamicObjectCollection srcDyn = dyn.getDynamicObjectCollection("isdimmapsrcentry");
        srcDyn.clear();
        if (StringUtils.isNotEmpty((String)mappingDTO.getSrcDimIds())) {
            List<String> srcIdsList = Arrays.asList(mappingDTO.getSrcDimIds().split(","));
            for (int i = 0; i < srcIdsList.size(); ++i) {
                DynamicObject dimsrc = srcDyn.addNew();
                dimsrc.set("srcbyfrom", (Object)"2");
                dimsrc.set("srcdimension", (Object)srcIdsList.get(i));
                dimsrc.set("srcdimtype", (Object)"bcm_isbaseentlist");
                dimsrc.set("seq", (Object)(i + 1));
            }
        }
        dyn.set(MAPPED_TYPE, (Object)mappingDTO.getMappingType());
        dyn.set("modifier", (Object)currUserId);
        dyn.set("modifytime", (Object)date);
        dyn.set(PRIORITY, (Object)mappingDTO.getPriority());
        dyn.set(INHERITANCE_SCHEME, (Object)mappingDTO.getInheritanceScheme());
        dyn.set("number", (Object)this.getMappingNumber(mappingDTO.getTagDimIds(), mappingDTO.getDataType(), mappingDTO.getSrcDimIds()).get("number"));
        dyn.set("name", (Object)this.getMappingNumber(mappingDTO.getTagDimIds(), mappingDTO.getDataType(), mappingDTO.getSrcDimIds()).get("name"));
        return dyn;
    }

    private DynamicObjectCollection afterSortDimData(List<Long> ids, DynamicObjectCollection collection) {
        Map map = collection.stream().collect(Collectors.toMap(t -> t.getLong("id"), Function.identity()));
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        for (Long id : ids) {
            dynamicObjects.add(map.get(id));
        }
        return dynamicObjects;
    }

    private Map<String, String> getMappingNumber(String tagDimIds, String dateType, String srcDimIds) {
        HashMap<String, String> nameNumberMap = new HashMap<String, String>(2);
        StringBuilder tagName = new StringBuilder();
        StringBuilder tagNumber = new StringBuilder();
        if (StringUtils.isNotEmpty((String)tagDimIds)) {
            List<String> tagIdsList = Arrays.asList(tagDimIds.split(","));
            List<Long> tagIdsLong = tagIdsList.stream().mapToLong(t -> Long.parseLong(t.trim())).boxed().collect(Collectors.toList());
            QFBuilder tagqf = new QFBuilder("id", "in", tagIdsLong);
            DynamicObjectCollection tagcollection = StringUtils.isEmpty((String)dateType) ? QueryServiceHelper.query((String)"bcm_dimension", (String)"id,name,number", (QFilter[])tagqf.toArray()) : QueryServiceHelper.query((String)"bcm_structofextend", (String)"id,name,number", (QFilter[])tagqf.toArray());
            DynamicObjectCollection sortCollection = this.afterSortDimData(tagIdsLong, tagcollection);
            for (DynamicObject dynamicObject : sortCollection) {
                tagName.append(dynamicObject.getString("name")).append(",");
                tagNumber.append(dynamicObject.getString("number")).append(",");
            }
        }
        if (StringUtils.isNotEmpty((String)srcDimIds)) {
            List<String> srcIdsList = Arrays.asList(srcDimIds.split(","));
            List<Long> srcIdsLong = srcIdsList.stream().mapToLong(t -> Long.parseLong(t.trim())).boxed().collect(Collectors.toList());
            QFBuilder srcqf = new QFBuilder("id", "in", srcIdsLong);
            DynamicObjectCollection srcCollection = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"id,name,number", (QFilter[])srcqf.toArray());
            StringBuilder srcName = new StringBuilder();
            StringBuilder srcNumber = new StringBuilder();
            DynamicObjectCollection sortCollection = this.afterSortDimData(srcIdsLong, srcCollection);
            for (DynamicObject dynamicObject : sortCollection) {
                srcName.append(dynamicObject.getString("name")).append(",");
                srcNumber.append(dynamicObject.getString("number")).append(",");
            }
            nameNumberMap.put("name", tagName.substring(0, tagName.length() - 1) + "-" + srcName.substring(0, srcName.length() - 1));
            nameNumberMap.put("number", tagNumber.substring(0, tagNumber.length() - 1) + "-" + srcNumber.substring(0, srcNumber.length() - 1));
        } else {
            nameNumberMap.put("name", tagName.substring(0, tagName.length() - 1));
            nameNumberMap.put("number", tagNumber.substring(0, tagNumber.length() - 1));
        }
        return nameNumberMap;
    }

    private void checkDataModify(List<DIMappingDTO> diMappingDTOs, Set<Long> modifyIds, Set<String> allPageDims, Set<String> allDBDims) {
        for (DIMappingDTO diMappingDTO : diMappingDTOs) {
            if (diMappingDTO.getMappingid() != 0L) {
                DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)diMappingDTO.getMappingid(), (String)"bcm_isdimmap", (String)"id, tagdimension, tagdimtype, tagbyfrom, srcdimension, srcdimtype, srcbyfrom, mappedtype, srcmemname, tagmemname, mappedtype,priority,tagmemb,inheritancescheme");
                if (dyn != null) {
                    StringBuilder pageMapping = new StringBuilder();
                    pageMapping.append(StringUtils.isNotEmpty((String)diMappingDTO.getMappingType()) ? diMappingDTO.getMappingType() : "");
                    pageMapping.append(StringUtils.isNotEmpty((String)diMappingDTO.getTagDimIds()) ? "-" + diMappingDTO.getTagDimIds() : "");
                    pageMapping.append(StringUtils.isNotEmpty((String)diMappingDTO.getTagDimDefValueIds()) ? "-" + diMappingDTO.getTagDimDefValueIds() : "");
                    pageMapping.append(StringUtils.isNotEmpty((String)diMappingDTO.getSrcDimIds()) ? "-" + diMappingDTO.getSrcDimIds() : "");
                    String withoutPriorityData = pageMapping.toString();
                    pageMapping.append(diMappingDTO.getInheritanceScheme() != 0L ? "-" + diMappingDTO.getInheritanceScheme() : "");
                    String DBMappingWithoutPriority = this.getDBDimData(dyn, Boolean.FALSE, allDBDims);
                    if (withoutPriorityData.equals(DBMappingWithoutPriority)) {
                        diMappingDTO.setDataDeleteMemberMap(Boolean.FALSE);
                    } else {
                        modifyIds.add(diMappingDTO.getMappingid());
                        diMappingDTO.setDataDeleteMemberMap(Boolean.TRUE);
                    }
                    String DBMappingWithPriority = this.getDBDimData(dyn, Boolean.TRUE, allDBDims);
                    pageMapping.append("-").append(diMappingDTO.getPriority());
                    if (pageMapping.toString().equals(DBMappingWithPriority)) {
                        diMappingDTO.setDataSaveType(SAVE_TYPE_SAME);
                    } else {
                        diMappingDTO.setDataSaveType(SAVE_TYPE_MODIFY);
                    }
                }
            } else {
                diMappingDTO.setDataSaveType(SAVE_TYPE_ADD);
                diMappingDTO.setDataDeleteMemberMap(Boolean.FALSE);
            }
            allPageDims.addAll(this.getDimList(diMappingDTO.getTagDimIds()));
            allPageDims.addAll(this.getDimList(diMappingDTO.getSrcDimIds()));
        }
    }

    private List<String> getDimList(String dim) {
        if (StringUtils.isNotEmpty((String)dim)) {
            return Arrays.asList(dim.split(","));
        }
        return Collections.emptyList();
    }

    private String getDBDimData(DynamicObject dyn, Boolean withPriority, Set<String> allDBDims) {
        String srcMappingIds;
        String tagMappingIds;
        StringBuilder mappingFromDB = new StringBuilder();
        DynamicObjectCollection tagDyns = dyn.getDynamicObjectCollection("isdimmaptargentry");
        DynamicObjectCollection srcDyns = dyn.getDynamicObjectCollection("isdimmapsrcentry");
        if (dyn.getString(MAPPED_TYPE) != null) {
            mappingFromDB.append(dyn.getString(MAPPED_TYPE));
        }
        if (tagDyns != null && tagDyns.size() > 0 && StringUtils.isNotEmpty((String)(tagMappingIds = this.getTagMappingIds(tagDyns, allDBDims)))) {
            mappingFromDB.append("-").append(tagMappingIds);
        }
        if (srcDyns != null && srcDyns.size() > 0 && StringUtils.isNotEmpty((String)(srcMappingIds = this.getSrcMappingIds(srcDyns, allDBDims)))) {
            mappingFromDB.append("-").append(srcMappingIds);
        }
        if (withPriority.booleanValue()) {
            if (dyn.getString(INHERITANCE_SCHEME) != null) {
                mappingFromDB.append("-").append(dyn.getString(INHERITANCE_SCHEME));
            }
            mappingFromDB.append("-").append(dyn.getString(PRIORITY));
        }
        return mappingFromDB.toString();
    }

    private String getSrcMappingIds(DynamicObjectCollection srcDyns, Set<String> allDBDims) {
        StringBuilder srcIds = new StringBuilder();
        for (DynamicObject srsDyn : srcDyns) {
            String srcId = srsDyn.getDynamicObject("srcdimension").getString("id");
            if (!StringUtils.isNotEmpty((String)srcId)) continue;
            allDBDims.add(srcId);
            srcIds.append(srcId).append(",");
        }
        if (srcIds.length() > 0) {
            return srcIds.substring(0, srcIds.length() - 1);
        }
        return null;
    }

    private String getTagMappingIds(DynamicObjectCollection tagDyns, Set<String> allDBDims) {
        StringBuilder tagIds = new StringBuilder();
        StringBuilder tagMembIds = new StringBuilder();
        for (DynamicObject tagDyn : tagDyns) {
            String tagId = tagDyn.getDynamicObject("tagdimension").getString("id");
            if (StringUtils.isNotEmpty((String)tagId)) {
                allDBDims.add(tagId);
                tagIds.append(tagId).append(",");
            }
            DynamicObjectCollection tagDynDefCollection = tagDyn.getDynamicObjectCollection("isdimmaptargdefval");
            for (DynamicObject tagDyndef : tagDynDefCollection) {
                if (!StringUtils.isNotEmpty((String)tagDyndef.getString("tagmemb"))) continue;
                tagMembIds.append(tagDyndef.getString("tagmemb")).append(",");
            }
        }
        if (tagIds.length() > 0) {
            if (tagMembIds.length() != 0) {
                return tagIds.substring(0, tagIds.length() - 1) + "-" + tagMembIds.substring(0, tagMembIds.length() - 1);
            }
            return tagIds.substring(0, tagIds.length() - 1);
        }
        return null;
    }

    private Boolean isExtendProduct(Long schemeId) {
        QFilter filter = new QFilter("id", "=", (Object)schemeId);
        filter.and("targtype", "=", (Object)"2");
        return QueryServiceHelper.exists((String)"bcm_isscheme", (QFilter[])filter.toArray());
    }

    private String checkEntryEntity() {
        Object duplicateProperties;
        Long schemeId = ((DynamicObject)this.getModel().getValue(SCHEME)).getLong("id");
        if (this.checkSchemeEnable(schemeId).booleanValue()) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u6210\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"ISDimMappingV2Plugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        if (DIIntegrationUtil.getSpecialMappingStatus((Long)schemeId) != false ? entryEntity.stream().noneMatch(mappedData -> DimMappTypeEnum.SPECIAL.getCode().equals(mappedData.getString(MAPPED_TYPE))) : entryEntity.stream().anyMatch(mappedData -> DimMappTypeEnum.SPECIAL.getCode().equals(mappedData.getString(MAPPED_TYPE)))) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u6210\u65b9\u6848\u914d\u7f6e\u5df2\u66f4\u6539\uff0c\u8bf7\u5237\u65b0\u540e\u4fdd\u5b58\u3002", (String)"DIDimMapListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        int combinationIndex = 0;
        int i = 1;
        if (this.isExtendProduct(schemeId).booleanValue() && !(duplicateProperties = this.duplicateProperties(entryEntity)).isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf\u7ef4\u5ea6\u62d3\u5c55\u5b57\u6bb5%s\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DIDimMapListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), duplicateProperties);
        }
        for (DynamicObject dynamicObject : entryEntity) {
            String nullError = this.checkNotNull(dynamicObject, i);
            if (StringUtils.isNotEmpty((String)nullError)) {
                return nullError;
            }
            ++i;
            if (dynamicObject.getString(MAPPED_TYPE).equals(DimMappTypeEnum.COMBO.getCode())) {
                ++combinationIndex;
            }
            if (combinationIndex <= 1) continue;
            return ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u7ec4\u5408\u6620\u5c04\uff0c\u8bf7\u4fee\u6539\u540e\u4fdd\u5b58\u3002", (String)"DISetDimPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        Map<String, Integer> tagDimCountMap = this.getTagDimMap(entryEntity);
        Set<String> isSameTagDim = this.getSameTagDim(tagDimCountMap);
        ArrayList<String> dimNameList = new ArrayList<String>(1);
        if (isSameTagDim.size() > 0 && this.checkSameTagDimPriority(isSameTagDim, entryEntity, dimNameList).booleanValue()) {
            return String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf\u7ef4\u5ea6%s\u5b58\u5728\u591a\u4e2a\uff0c\u9700\u8981\u7ef4\u62a4\u4f18\u5148\u7ea7\u3002", (String)"DISetDimPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimNameList.get(0));
        }
        ArrayList<String> samePriorityList = new ArrayList<String>(1);
        if (isSameTagDim.size() > 0 && this.checkSameTagDimPriorityValue(isSameTagDim, entryEntity, samePriorityList).booleanValue()) {
            return String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf\u7ef4\u5ea6%s\u5b58\u5728\u76f8\u540c\u7684\u4f18\u5148\u7ea7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DISetDimPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), samePriorityList.get(0));
        }
        return null;
    }

    private Set<Object> duplicateProperties(DynamicObjectCollection entryEntity) {
        Set<Object> duplicateProperties = entryEntity.stream().filter(obj -> StringUtils.isNotEmpty((String)obj.getString(DATATYPE))).map(obj -> obj.get(TAG_DIM)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        return duplicateProperties;
    }

    private Boolean checkSameTagDimPriority(Set<String> isSameTagDim, DynamicObjectCollection entryEntity, List<String> dimName) {
        for (String s : isSameTagDim) {
            for (DynamicObject dyn : entryEntity) {
                if (!s.equals(dyn.getString(TAG_DIM_IDS)) || dyn.getInt(PRIORITY) != 0 || !StringUtils.isEmpty((String)dyn.getString(TAG_DIM_DEF_VALUE_IDS))) continue;
                dimName.add(dyn.getString(TAG_DIM));
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private Boolean checkSameTagDimPriorityValue(Set<String> isSameTagDim, DynamicObjectCollection entryEntity, List<String> samePriorityList) {
        HashMap<String, Integer> sameTagDimPriorityValue = new HashMap<String, Integer>(2);
        for (String s : isSameTagDim) {
            for (DynamicObject dyn : entryEntity) {
                if (!s.equals(dyn.getString(TAG_DIM_IDS)) || DimMappTypeEnum.TARGET_DEFAULT.getCode().equals(dyn.getString(MAPPED_TYPE))) continue;
                String key = dyn.getString(TAG_DIM_IDS) + "-" + dyn.getString(PRIORITY);
                sameTagDimPriorityValue.put(key, sameTagDimPriorityValue.getOrDefault(key, 0) + 1);
            }
        }
        Set set = sameTagDimPriorityValue.entrySet();
        for (Map.Entry entry : set) {
            if (entry == null || (Integer)entry.getValue() <= 1) continue;
            String id = ((String)entry.getKey()).split("-")[0];
            samePriorityList.add(this.getTagNameById(entryEntity, id));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getTagNameById(DynamicObjectCollection entryEntity, String id) {
        for (DynamicObject tag : entryEntity) {
            if (!id.equals(tag.getString(TAG_DIM_IDS))) continue;
            return tag.getString(TAG_DIM);
        }
        return null;
    }

    private Boolean checkSchemeEnable(Long schemeId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", (Object)schemeId);
        qfBuilder.add("status", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"bcm_isscheme", (QFilter[])qfBuilder.toArray());
    }

    private String checkNotNull(DynamicObject dynamicObject, int i) {
        if (StringUtils.isEmpty((String)dynamicObject.getString(TAG_DIM_IDS))) {
            return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5b58\u5728\u672a\u5f55\u5165\u7684\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u7f3a\u7701\u6210\u5458\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DISetDimPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i);
        }
        if (StringUtils.isEmpty((String)dynamicObject.getString(SRC_DIM_IDS)) && StringUtils.isEmpty((String)dynamicObject.getString(TAG_DIM_DEF_VALUE_IDS))) {
            return String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7b2c%s\u884c\u7684\u76ee\u6807\u7f3a\u7701\u503c\u6216\u6e90\u7cfb\u7edf\u7ef4\u5ea6\uff0c\u4e24\u8005\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"DISetDimPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i);
        }
        if (StringUtils.isEmpty((String)dynamicObject.getString(MAPPED_TYPE))) {
            return String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6620\u5c04\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u4fdd\u5b58\u3002", (String)"DISetDimPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i);
        }
        return null;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        if (SCHEME.equals(key)) {
            if (this.getModel().getValue(MODEL) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DISBaseEntQueryListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter qf = new QFilter(MODEL, "=", (Object)this.getModelId());
            qf.and("issrc.number", "like", (Object)"DI%");
            qf.and("id", "not in", (Object)DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)this.getModelId()));
            beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(qf));
        }
        if (INHERITANCE_SCHEME.equals(key)) {
            if (this.getModel().getValue(SCHEME) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u3002", (String)"DISBaseEntQueryListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            Long schemeId = (Long)this.getModel().getValue("scheme_id");
            QFilter qf = new QFilter("id", "in", this.getSchemeIds(this.getModelId(), schemeId));
            beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(qf));
        }
    }

    private List<Long> findSchemeIds(Long modelId, Long schemeId) {
        QFilter filter = new QFilter(MODEL, "in", (Object)modelId).and("id", "!=", (Object)schemeId).and("issrc", "in", this.getDIProductId());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id", (QFilter[])filter.toArray());
        List<Long> schemeIds = dynamicObjects.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        return schemeIds;
    }

    private Set<Long> getDIProductId() {
        DynamicObjectCollection productSrc = QueryServiceHelper.query((String)"bcm_isproduct", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "like", (Object)"DI%")});
        return productSrc.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
    }

    private List<Long> getSchemeIds(Long modelId, Long schemeId) {
        List<Long> schemeIds = new ArrayList<Long>(8);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (selectRows != null && selectRows.length > 0) {
            for (int selectRow : selectRows) {
                Long dimMapId = (Long)((DynamicObject)entity.get(selectRow)).get("dimmappingid");
                String mappedType = (String)((DynamicObject)entity.get(selectRow)).get(MAPPED_TYPE);
                String tagDimIds = (String)((DynamicObject)entity.get(selectRow)).get(TAG_DIM_IDS);
                String dateType = (String)((DynamicObject)entity.get(selectRow)).get(DATATYPE);
                String srcDimIds = (String)((DynamicObject)entity.get(selectRow)).get(SRC_DIM_IDS);
                String dimMapNumber = this.getDimMapNameByPage(tagDimIds, dateType, srcDimIds);
                schemeIds = this.getDimMapSchemeIds(this.findSchemeIds(modelId, schemeId), dimMapNumber, mappedType);
            }
        }
        schemeIds.removeAll(DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)modelId));
        return schemeIds;
    }

    private String getDimMapNameByPage(String tagDimIds, String dateType, String srcDimIds) {
        return this.getMappingNumber(tagDimIds, dateType, srcDimIds).get("number");
    }

    private String getDimMapNumberById(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bcm_isdimmap", (String)"number", (QFilter[])filter.toArray()).getString("number");
    }

    private List<Long> getDimMapSchemeIds(List<Long> schemeIds, String dimMapNumber, String mappedType) {
        QFilter filter = new QFilter(SCHEME, "in", schemeIds);
        QFilter filterNumber = new QFilter("number", "=", (Object)dimMapNumber);
        QFilter filterMapType = new QFilter(MAPPED_TYPE, "=", (Object)mappedType);
        DynamicObjectCollection dyn = QueryServiceHelper.query((String)"bcm_isdimmap", (String)SCHEME, (QFilter[])new QFilter[]{filter, filterNumber});
        List<Long> ids = dyn.stream().map(k -> k.getLong(SCHEME)).collect(Collectors.toList());
        return ids;
    }

    private List<DIMappingDTO> getDIMappingDTOs() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        ArrayList<DIMappingDTO> diMappingTDOList = new ArrayList<DIMappingDTO>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            DIMappingDTO dto = new DIMappingDTO();
            dto.setTagDimIds(dynamicObject.getString(TAG_DIM_IDS));
            dto.setSrcDimIds(dynamicObject.getString(SRC_DIM_IDS));
            dto.setTagDimDefValueIds(dynamicObject.getString(TAG_DIM_DEF_VALUE_IDS));
            dto.setPriority(dynamicObject.getInt(PRIORITY));
            dto.setMappingid(dynamicObject.getLong("dimmappingid"));
            dto.setDataType(dynamicObject.getString(DATATYPE));
            dto.setMappingType(dynamicObject.getString(MAPPED_TYPE));
            dto.setInheritanceScheme(dynamicObject.getLong("inheritancescheme_id"));
            diMappingTDOList.add(dto);
        }
        return diMappingTDOList;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String item = ((Control)evt.getSource()).getKey();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        switch (item) {
            case "tagdim": 
            case "srcdim": {
                this.setDim(currentRowIndex, item);
                break;
            }
            case "tagdimdefvalue": {
                this.setTargDimDefValue(currentRowIndex);
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent cb) {
        String actionId = cb.getActionId();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        if (cb.getReturnData() != null) {
            if (SET_DIM_MAP.equals(actionId)) {
                List selectDimDTOList = (List)cb.getReturnData();
                this.closedCallBackDimMap(selectDimDTOList, currentRowIndex);
            } else if (TAG_DIM_DEF_VALUE.equals(actionId)) {
                List selectdimList = (List)cb.getReturnData();
                this.closedCallBackTag(selectdimList, currentRowIndex);
            } else if (SELECT_FIELD.equals(actionId) && cb.getReturnData() != null) {
                DynamicObject field = (DynamicObject)this.deSerializedBytes((String)cb.getReturnData());
                this.closedCallBankExtFiled(field, currentRowIndex);
            }
        }
    }

    private void closedCallBankExtFiled(DynamicObject field, int currentRowIndex) {
        if (field != null) {
            this.getModel().setValue(TAG_DIM, (Object)field.getString("name"), currentRowIndex);
            this.getModel().setValue(TAG_DIM_IDS, (Object)field.getString("id"), currentRowIndex);
            this.getModel().setValue(DATATYPE, (Object)field.getString(DATATYPE), currentRowIndex);
            this.getModel().setValue(MAPPED_TYPE, (Object)DimMappTypeEnum.SIMPLE.getCode(), currentRowIndex);
            String tagDimId = field.getString("id");
            this.setPriorityEnable(tagDimId, currentRowIndex);
        }
    }

    private void closedCallBackDimMap(List<SelectDimDTO> selectDimDTOList, int currentRowIndex) {
        if (selectDimDTOList.size() > 0) {
            ArrayList list = new ArrayList(selectDimDTOList.size());
            for (int i = 0; i < selectDimDTOList.size(); ++i) {
                HashMap<String, String> map = new HashMap<String, String>(16);
                SelectDimDTO selectDimDTO = selectDimDTOList.get(i);
                map.put(ID, selectDimDTO.getId());
                map.put(NUMBER, selectDimDTO.getNumber());
                map.put(NAME, selectDimDTO.getName());
                map.put(TYPE, selectDimDTO.getType());
                list.add(map);
            }
            List numbers = list.stream().map(v -> (String)v.get(NAME)).collect(Collectors.toList());
            List<String> ids = list.stream().map(v -> (String)v.get(ID)).collect(Collectors.toList());
            String type = selectDimDTOList.get((int)0).type;
            if (TAG_DIM.equals(type)) {
                if (ids.size() == 1) {
                    this.setPriorityEnable((String)ids.get(0), currentRowIndex);
                }
                this.setTargMappedType(currentRowIndex, ids);
                this.getModel().setValue(TAG_DIM, (Object)String.join((CharSequence)CAESURA_SIGN, numbers), currentRowIndex);
                this.getModel().setValue(TAG_DIM_IDS, (Object)String.join((CharSequence)",", ids), currentRowIndex);
            } else if (SRC_DIM.equals(type)) {
                String id;
                if (this.getModel().getValue(TAG_DIM_IDS, currentRowIndex) != null && StringUtils.isNotEmpty((String)(id = this.getModel().getValue(TAG_DIM_IDS, currentRowIndex).toString())) && !id.contains(",")) {
                    this.setPriorityEnable(id, currentRowIndex);
                }
                this.setSrcMappedType(currentRowIndex);
                this.getModel().setValue(SRC_DIM, (Object)String.join((CharSequence)CAESURA_SIGN, numbers), currentRowIndex);
                this.getModel().setValue(SRC_DIM_IDS, (Object)String.join((CharSequence)",", ids), currentRowIndex);
            }
        }
    }

    private void setTargMappedType(int currentRowIndex, List<String> ids) {
        if (ids.size() == 1) {
            if (this.getModel().getValue(MAPPED_TYPE, currentRowIndex) == null) {
                this.getModel().setValue(MAPPED_TYPE, (Object)DimMappTypeEnum.SIMPLE.getCode(), currentRowIndex);
            } else if (this.getModel().getValue(MAPPED_TYPE, currentRowIndex).toString().equals(DimMappTypeEnum.COMBO.getCode())) {
                this.getModel().setValue(MAPPED_TYPE, (Object)DimMappTypeEnum.SIMPLE.getCode(), currentRowIndex);
            }
        } else if (ids.size() > 1) {
            if (this.getModel().getValue(MAPPED_TYPE, currentRowIndex) == null) {
                this.getModel().setValue(MAPPED_TYPE, (Object)DimMappTypeEnum.COMBO.getCode(), currentRowIndex);
            } else {
                String mappedType = this.getModel().getValue(MAPPED_TYPE, currentRowIndex).toString();
                if (!mappedType.equals(DimMappTypeEnum.SPECIAL.getCode())) {
                    this.getModel().setValue(MAPPED_TYPE, (Object)DimMappTypeEnum.COMBO.getCode(), currentRowIndex);
                }
            }
        }
    }

    private void setSrcMappedType(int currentRowIndex) {
        if (this.getModel().getValue(MAPPED_TYPE, currentRowIndex) == null) {
            if (this.getModel().getValue(TAG_DIM_IDS) != null && this.getModel().getValue(TAG_DIM_IDS) != "") {
                if (this.getModel().getValue(TAG_DIM_IDS).toString().contains(",")) {
                    this.getModel().setValue(MAPPED_TYPE, (Object)DimMappTypeEnum.COMBO.getCode(), currentRowIndex);
                } else {
                    this.getModel().setValue(MAPPED_TYPE, (Object)DimMappTypeEnum.SIMPLE.getCode(), currentRowIndex);
                }
            }
        } else {
            String mappedType = this.getModel().getValue(MAPPED_TYPE, currentRowIndex).toString();
            if (!mappedType.equals(DimMappTypeEnum.SPECIAL.getCode()) && !mappedType.equals(DimMappTypeEnum.COMBO.getCode())) {
                this.getModel().setValue(MAPPED_TYPE, (Object)DimMappTypeEnum.SIMPLE.getCode(), currentRowIndex);
            }
        }
    }

    private void setPriorityEnable(String id, int currentRowIndex) {
        if (this.checkSameTagDim(id, currentRowIndex)) {
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            int i = 0;
            for (DynamicObject dynamicObject : entryEntity) {
                if (id.equals(dynamicObject.getString(TAG_DIM_IDS)) && !DimMappTypeEnum.TARGET_DEFAULT.getCode().equals(dynamicObject.getString(MAPPED_TYPE))) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{PRIORITY});
                }
                ++i;
            }
            this.getView().setEnable(Boolean.TRUE, currentRowIndex, new String[]{PRIORITY});
        }
    }

    private boolean checkSameTagDim(String tagDimId, int currentRowIndex) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObjectCollection excludedCurrentRow = IntStream.range(0, entryEntity.size()).filter(index -> index != currentRowIndex).mapToObj(arg_0 -> entryEntity.get(arg_0)).collect(DynamicObjectCollection::new, DataEntityCollection::add, DynamicObjectCollection::addAll);
        List tagIds = excludedCurrentRow.stream().filter(dyn -> StringUtils.isEmpty((String)dyn.getString(TAG_DIM_DEF_VALUE_IDS))).map(dyn -> dyn.getString(TAG_DIM_IDS)).collect(Collectors.toList());
        if (tagIds.contains(tagDimId)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void closedCallBackTag(List<SrcDimCommonModel> selectdimList, int currentRowIndex) {
        if (selectdimList != null && selectdimList.size() > 0) {
            String ids = "";
            String names = "";
            int index = 0;
            for (SrcDimCommonModel selectDim : selectdimList) {
                String name = selectDim.getName();
                String id = selectDim.getId();
                if (index == 0) {
                    names = name;
                    ids = id;
                } else {
                    names = names + "," + name;
                    ids = ids + "," + id;
                }
                ++index;
            }
            this.getModel().setValue(MAPPED_TYPE, (Object)DimMappTypeEnum.TARGET_DEFAULT.getCode(), currentRowIndex);
            this.getModel().setValue(TAG_DIM_DEF_VALUE, (Object)names, currentRowIndex);
            this.getModel().setValue(TAG_DIM_DEF_VALUE_IDS, (Object)ids, currentRowIndex);
            this.getModel().setValue(PRIORITY, (Object)0, currentRowIndex);
            this.getView().setEnable(Boolean.FALSE, currentRowIndex, new String[]{PRIORITY});
        }
    }

    private void setTargDimDefValue(int currentRowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object value = this.getModel().getValue(TAG_DIM, currentRowIndex);
        if (value == null || value == "") {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u7ef4\u5ea6\u518d\u8fdb\u884c\u9ed8\u8ba4\u503c\u7684\u8bbe\u5b9a\u3002", (String)"ISDimMappingAddPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (value.toString().contains(CAESURA_SIGN)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u5b58\u5728\u591a\u4e2a\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u3002", (String)"DIDimMapListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object datatype = this.getModel().getValue(DATATYPE, currentRowIndex);
        if (datatype != null && datatype != "") {
            view.showErrorNotification(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf\u7ef4\u5ea6\u4e3a\u62d3\u5c55\u5b57\u6bb5\u6210\u5458\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u3002", (String)"DIDimMapListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object srcValue = this.getModel().getValue(SRC_DIM_IDS, currentRowIndex);
        if (srcValue != null && srcValue != "") {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e\u6e90\u7cfb\u7edf\u7ef4\u5ea6\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u3002", (String)"DIDimMapListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String dimId = (String)this.getModel().getValue(TAG_DIM_IDS, currentRowIndex);
        DynamicObject tagDim = MemberReader.getDimensionDynById((long)LongUtil.toLong((Object)dimId));
        view.getFormShowParameter().setCustomParam("dimDyn", (Object)tagDim);
        DynamicObject scheme = (DynamicObject)model.getValue(SCHEME);
        Long modelId = this.getSchemeModelId(scheme.getLong("id"));
        QFilter filters = this.getDimDetailQFilter(modelId, view);
        String entityName = this.getDimEntityName(tagDim.getLong("id"));
        boolean isMulti = Boolean.FALSE;
        List<String> selectNumbers = this.getSelectNumbers(currentRowIndex, entityName);
        this.openMultiF7Select(filters.toArray(), entityName, isMulti, selectNumbers);
    }

    private List<String> getSelectNumbers(int focusRow, String entityName) {
        ArrayList<String> selectNumber = new ArrayList<String>();
        String tagDimDefValueIDs = (String)this.getModel().getValue(TAG_DIM_DEF_VALUE_IDS, focusRow);
        if (StringUtils.isNotEmpty((String)tagDimDefValueIDs)) {
            List<String> tagDimDefValueIDsList = Arrays.asList(tagDimDefValueIDs.split(","));
            List tagDimDefValueIDsListLong = tagDimDefValueIDsList.stream().mapToLong(t -> Long.parseLong(t.trim())).boxed().collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", tagDimDefValueIDsListLong);
            QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])qFilter.toArray()).forEach(e -> selectNumber.add(e.getString("number")));
        }
        return selectNumber;
    }

    public String getDimEntityName(Long id) {
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id, membermodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (queryOne != null) {
            return queryOne.getString("membermodel");
        }
        return null;
    }

    public QFilter getDimDetailQFilter(Long modelId, IFormView formView) {
        DynamicObject dim = (DynamicObject)formView.getFormShowParameter().getCustomParam("dimDyn");
        if (DimEntityNumEnum.AUDITTRIAL.getNumber().equalsIgnoreCase(dim.getString("number"))) {
            return QFilter.of((String)"model = ? and dimension = ? and storagetype <> ? and (datasource = '1')", (Object[])new Object[]{modelId, dim.getLong("id"), StorageTypeEnum.SHARE.index});
        }
        if (DimEntityNumEnum.PROCESS.getNumber().equalsIgnoreCase(dim.getString("number"))) {
            return QFilter.of((String)"model = ? and dimension = ? and storagetype <> ? and number in ('IRpt','EIRpt','CSTE','Process')", (Object[])new Object[]{modelId, dim.getLong("id"), StorageTypeEnum.SHARE.index});
        }
        return QFilter.of((String)"model = ? and dimension = ? and storagetype <> ?  and isleaf = ?", (Object[])new Object[]{modelId, dim.getLong("id"), StorageTypeEnum.SHARE.index, "1"});
    }

    private Long getSchemeModelId(Long schemeId) {
        QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)schemeId);
        return QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)MODEL, (QFilter[])qfBuilder.toArray()).getLong(MODEL);
    }

    private void openMultiF7Select(QFilter[] filters, String entityName, boolean isMulti, List<String> selectNumber) {
        HashMap<String, String> openParameter = new HashMap<String, String>();
        openParameter.put("formId", "di_multiselect_f7");
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam("ismulti", (Object)String.valueOf(isMulti));
        formShowParameter.setCustomParam("entitynumber", (Object)entityName);
        formShowParameter.setCustomParam("filters", (Object)ObjectSerialUtil.toByteSerialized((Object)filters));
        formShowParameter.setCustomParam("selectNumber", (Object)ObjectSerialUtil.toByteSerialized(selectNumber));
        formShowParameter.setCustomParam("parentClassName", (Object)"default_class");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7f3a\u7701\u503c\u9009\u62e9", (String)"ISDimMappingAddPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TAG_DIM_DEF_VALUE));
        this.getView().showForm(formShowParameter);
    }

    private void setDim(int rowIndex, String type) {
        Long schemeId = (Long)this.getModel().getValue("scheme_id");
        if (type.equals(TAG_DIM) && this.isExtendProduct(schemeId).booleanValue()) {
            this.openExtFieldForm(schemeId);
        } else {
            this.openDimForm(rowIndex, type, schemeId);
        }
    }

    private void openDimForm(int rowIndex, String type, Long schemeId) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("di_setdimmapping");
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getModel().getValue("model_id").toString());
        param.setCustomParam(TYPE, (Object)type);
        Boolean flag = Boolean.TRUE;
        Object tagDefaultValue = this.getModel().getValue(TAG_DIM_DEF_VALUE_IDS, rowIndex);
        Object tagDimtValue = this.getModel().getValue(TAG_DIM_IDS, rowIndex);
        if (TAG_DIM.equals(type)) {
            if (tagDefaultValue != null && tagDefaultValue != "") {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fee\u6539\u76ee\u6807\u7cfb\u7edf\u7ef4\u5ea6\uff0c\u8bf7\u5148\u6e05\u7a7a\u76ee\u6807\u9ed8\u8ba4\u503c\u3002", (String)"DIDimMapListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            param.setCaption(ResManager.loadKDString((String)"\u8bbe\u7f6e\u76ee\u6807\u7cfb\u7edf\u7ef4\u5ea6", (String)"DISetDimPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            param.setCustomParam(DIM_IDS, this.getModel().getValue(TAG_DIM_IDS, rowIndex));
        } else if (SRC_DIM.equals(type)) {
            if (tagDimtValue == null || tagDimtValue == "") {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u76ee\u6807\u7cfb\u7edf\u7ef4\u5ea6\uff0c\u518d\u8fdb\u884c\u6e90\u7cfb\u7edf\u7ef4\u5ea6\u7684\u8bbe\u7f6e\u3002", (String)"DIDimMapListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (tagDefaultValue != null && tagDefaultValue != "") {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e\u76ee\u6807\u7f3a\u7701\u503c\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u6e90\u7cfb\u7edf\u7ef4\u5ea6\u3002", (String)"DIDimMapListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean isExtend = this.isExtendProduct(schemeId);
            if (isExtend.booleanValue()) {
                flag = Boolean.FALSE;
                String error = this.checkMustTagDefaultMember(rowIndex);
                if (StringUtils.isNotEmpty((String)error)) {
                    this.getView().showErrorNotification(error);
                    return;
                }
            }
            param.setCaption(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6e90\u7cfb\u7edf\u7ef4\u5ea6", (String)"DISetDimPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            param.setCustomParam(DIM_IDS, this.getModel().getValue(SRC_DIM_IDS, rowIndex));
            param.setCustomParam(SCHEME, (Object)this.getModel().getValue("scheme_id").toString());
        }
        param.setCustomParam("ismulti", (Object)String.valueOf(flag));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SET_DIM_MAP);
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private String checkMustTagDefaultMember(int rowIndex) {
        Long tagDim;
        DynamicObject dim;
        Object dataType = this.getModel().getValue(DATATYPE, rowIndex);
        if ((dataType == null || dataType == "") && (dim = MemberReader.getDimensionDynById((long)(tagDim = LongUtil.toLong((Object)this.getModel().getValue(TAG_DIM_IDS, rowIndex))))) != null && MUST_TAG_DIM_DEF_LIST.contains(dim.getString("number"))) {
            String error = String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6620\u5c04%s\u7ef4\u5ea6\u53ea\u80fd\u8bbe\u7f6e\u76ee\u6807\u9ed8\u8ba4\u503c\u3002", (String)"DISetDimPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim.getString("name"));
            return error;
        }
        return "";
    }

    private void openExtFieldForm(Long schemeId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_exttargfieldsetting");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(SCHEME, (Object)schemeId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECT_FIELD);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void refreshEntity() {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (this.validate()) {
            DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
            this.schemeChanged(scheme.getLong("id"));
        }
    }

    private void fillMappingData(Long schemeId) {
        DynamicObject[] dimMappings = DIDimMapListPlugin.queryDimMapping(schemeId);
        this.doFillMappingData(dimMappings);
    }

    public static DynamicObject[] queryDimMapping(Long schemeId) {
        QFBuilder filter = new QFBuilder(SCHEME, "=", (Object)schemeId);
        if (!DIIntegrationUtil.getSpecialMappingStatus((Long)schemeId).booleanValue()) {
            filter.add(MAPPED_TYPE, "!=", (Object)DimMappTypeEnum.SPECIAL.getCode());
        }
        return BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id, tagdimension, tagdimtype, tagbyfrom, srcdimension, srcdimtype, srcbyfrom, mappedtype, srcmemname, tagmemname, mappedtype,priority,tagmemb,issys,datatype,inheritancescheme", (QFilter[])filter.toArray(), (String)"sequence asc");
    }

    private void doFillMappingData(DynamicObject[] dimmappings) {
        ArrayList<DIMappingVO> datas = new ArrayList<DIMappingVO>();
        for (DynamicObject dimmapping : dimmappings) {
            String dimType = dimmapping.getString(MAPPED_TYPE);
            if (DimMappTypeEnum.TARGET_DEFAULT.getCode().equals(dimType)) {
                datas.addAll(this.generateTagVO(dimmapping));
                continue;
            }
            datas.addAll(this.generateDefaultVO(dimmapping));
        }
        int size = datas.size();
        List<String> tagdimIds = this.getRepeatTagDim(datas);
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        entryEntity.clear();
        for (int i = 0; i < size; ++i) {
            DynamicObject addNew = entryEntity.addNew();
            DIMappingVO dvo = (DIMappingVO)datas.get(i);
            addNew.set(TAG_DIM, (Object)dvo.getTagDim());
            addNew.set(TAG_DIM_IDS, (Object)dvo.getTagDimIds());
            addNew.set(TAG_DIM_DEF_VALUE, (Object)dvo.getTagDimDefValue());
            addNew.set(TAG_DIM_DEF_VALUE_IDS, (Object)dvo.getTagDimDefValueIds());
            addNew.set(SRC_DIM, (Object)dvo.getSrcDim());
            addNew.set(SRC_DIM_IDS, (Object)dvo.getSrcDimIds());
            addNew.set("dimmappingid", (Object)dvo.getMappingid());
            addNew.set(PRIORITY, (Object)dvo.getPriority());
            addNew.set("issys", (Object)dvo.getIssys());
            addNew.set(DATATYPE, (Object)dvo.getDataType());
            addNew.set(MAPPED_TYPE, (Object)dvo.getMappedType());
            if (dvo.getInheritanceScheme() == null || dvo.getInheritanceScheme() == 0L) {
                addNew.set(INHERITANCE_SCHEME, null);
            } else {
                addNew.set(INHERITANCE_SCHEME, (Object)DISchemeUtil.getSchemeById(dvo.getInheritanceScheme()));
            }
            this.setPriorityEnable(tagdimIds, dvo, i);
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void setPriorityEnable(List<String> tagdimIds, DIMappingVO dvo, int i) {
        if (tagdimIds.contains(dvo.getTagDimIds()) && StringUtils.isEmpty((String)dvo.getTagDimDefValueIds()) && !DimMappTypeEnum.SPECIAL.getCode().equals(dvo.getMappedType()) && !DimMappTypeEnum.COMBO.getCode().equals(dvo.getMappedType())) {
            this.getView().setEnable(Boolean.TRUE, i, new String[]{PRIORITY});
        } else {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{PRIORITY});
        }
    }

    private List<String> getRepeatTagDim(List<DIMappingVO> datas) {
        ArrayList<String> tagDimIds = new ArrayList<String>();
        HashMap map = new HashMap();
        datas.stream().filter(dto -> StringUtils.isEmpty((String)dto.getTagDimDefValueIds())).forEach(dto -> map.put(dto.getTagDimIds(), map.getOrDefault(dto.getTagDimIds(), 0) + 1));
        Set entrySet = map.entrySet();
        for (Map.Entry s : entrySet) {
            if ((Integer)s.getValue() <= 1) continue;
            tagDimIds.add((String)s.getKey());
        }
        return tagDimIds;
    }

    public List<DIMappingVO> generateTagVO(DynamicObject dataEntity) {
        DynamicObjectCollection tagDynCollection = dataEntity.getDynamicObjectCollection("isdimmaptargentry");
        ArrayList<DIMappingVO> returnData = new ArrayList<DIMappingVO>();
        for (DynamicObject tagDyn : tagDynCollection) {
            DIMappingVO dvo = new DIMappingVO();
            String tagname = tagDyn.getDynamicObject("tagdimension").getString("name");
            dvo.setTagDim(tagname);
            dvo.setTagDimIds(tagDyn.getDynamicObject("tagdimension").getString("id"));
            dvo.setPriority(dataEntity.getInt(PRIORITY));
            dvo.setMappingid(dataEntity.getLong("id"));
            dvo.setIssys(dataEntity.getBoolean("issys"));
            dvo.setMappedType(dataEntity.getString(MAPPED_TYPE));
            DynamicObjectCollection tagDynDefCollection = tagDyn.getDynamicObjectCollection("isdimmaptargdefval");
            String defaultValue = "";
            String membids = "";
            int index = 0;
            for (DynamicObject tagDyndef : tagDynDefCollection) {
                String name = tagDyndef.getString("tagmemname");
                String membid = tagDyndef.getString("tagmemb");
                if (index == 0) {
                    defaultValue = name;
                    membids = membid;
                } else {
                    defaultValue = defaultValue + "," + name;
                    membids = membids + "," + membid;
                }
                ++index;
            }
            dvo.setTagDimDefValue(defaultValue);
            dvo.setTagDimDefValueIds(membids);
            returnData.add(dvo);
        }
        return returnData;
    }

    public List<DIMappingVO> generateDefaultVO(DynamicObject dataEntity) {
        DynamicObjectCollection srcDynCollection = dataEntity.getDynamicObjectCollection("isdimmapsrcentry");
        DynamicObjectCollection tagDynCollection = dataEntity.getDynamicObjectCollection("isdimmaptargentry");
        ArrayList<DIMappingVO> returnData = new ArrayList<DIMappingVO>();
        DIMappingVO dvo = new DIMappingVO();
        String srcname = this.getDimName(srcDynCollection, "srcdimension");
        String srcDimIds = this.getDimId(srcDynCollection, "srcdimension");
        String tagname = this.getDimName(tagDynCollection, "tagdimension");
        String tagDimIds = this.getDimId(tagDynCollection, "tagdimension");
        dvo.setSrcDim(srcname);
        dvo.setSrcDimIds(srcDimIds);
        dvo.setTagDim(tagname);
        dvo.setTagDimIds(tagDimIds);
        dvo.setPriority(dataEntity.getInt(PRIORITY));
        dvo.setMappingid(dataEntity.getLong("id"));
        dvo.setIssys(dataEntity.getBoolean("issys"));
        dvo.setDataType(dataEntity.getString(DATATYPE));
        dvo.setMappedType(dataEntity.getString(MAPPED_TYPE));
        dvo.setInheritanceScheme(dataEntity.getLong("inheritanceScheme_id"));
        returnData.add(dvo);
        return returnData;
    }

    private String getDimName(DynamicObjectCollection srcDynCollection, String columnName) {
        String srcname = "";
        int size = srcDynCollection.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject src = (DynamicObject)srcDynCollection.get(i);
            DynamicObject dynamicObject = src.getDynamicObject(columnName);
            if (dynamicObject == null) continue;
            String name = dynamicObject.getString("name");
            srcname = i == 0 ? name : srcname + CAESURA_SIGN + name;
        }
        return srcname;
    }

    private String getDimId(DynamicObjectCollection srcDynCollection, String columnName) {
        String srcId = "";
        int size = srcDynCollection.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject src = (DynamicObject)srcDynCollection.get(i);
            DynamicObject dynamicObject = src.getDynamicObject(columnName);
            if (dynamicObject == null) continue;
            String id = Long.valueOf(dynamicObject.getLong("id")).toString();
            srcId = i == 0 ? id : srcId + "," + id;
        }
        return srcId;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "scheme": {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
                if (this.getModelId() == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DISBaseEntQueryListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    break;
                }
                if (newValue == null || newValue.getPkValue().equals(oldValue == null ? null : oldValue.getPkValue())) break;
                this.schemeChanged(newValue.getLong("id"));
                this.propertyChangedUse(SCHEME, newValue, false, false);
                break;
            }
            case "model": {
                DynamicObject newValueModel = (DynamicObject)e.getChangeSet()[0].getNewValue();
                DynamicObject oldValueModel = (DynamicObject)e.getChangeSet()[0].getOldValue();
                if (newValueModel == null || newValueModel.getPkValue().equals(oldValueModel == null ? null : oldValueModel.getPkValue())) break;
                this.propertyChangedModelUse(Collections.emptyList());
                this.refreshEntity();
                break;
            }
        }
    }

    protected void schemeChanged(Long schemeId) {
        if (this.validate()) {
            if (schemeId != 0L) {
                this.fillMappingData(schemeId);
            }
            this.checkAndSetWritePermission();
        }
    }

    private Boolean checkAndSetWritePermission() {
        if (!this.validate()) {
            return false;
        }
        Long modelId = this.getModelId();
        Long schemeId = this.getSchemeId();
        Boolean hasWritePermission = DIIntegrationUtil.isWriteSchemePerm((long)schemeId, (long)modelId);
        this.getView().setEnable(hasWritePermission, new String[]{"btn_save", "addnew", "delete", ENTRY_ENTITY});
        return hasWritePermission;
    }

    private static /* synthetic */ boolean lambda$confirmCallBack$0(DIMappingDTO dto) {
        return SAVE_TYPE_MODIFY.equals(dto.getDataSaveType()) && dto.getDataDeleteMemberMap() != false;
    }
}

