/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.intergration.di;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.fi.bcm.business.integration.di.service.DIDataQueryFactory;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.formplugin.intergration.di.DIExecuteDetailPlugin;

public class DIExecutDetailQuery
extends AbstractReportListDataPlugin {
    private static final String TEMP_TABLE = "t_di_tablelabel";
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DIExecutDetailQuery.class);

    public DataSet query(ReportQueryParam paramReportQueryParam, Object paramObject) throws Throwable {
        try {
            Map customParam = paramReportQueryParam.getCustomParam();
            String executeId = (String)customParam.get("executeId");
            if (executeId == null) {
                return DB.queryDataSet((String)"DI", (DBRoute)BCMConstant.DBROUTE, (String)"select fid from t_di_tablelabel where 1=2");
            }
            String curStep = (String)customParam.get("curStep");
            String isSrc = (String)customParam.get("isSrc");
            String extendsTable = (String)customParam.get("extendstable");
            String extendsTableCp = (String)customParam.get("extendstable_cp");
            String otherFilter = (String)customParam.get("otherFilter");
            otherFilter = this.getOtherFilterFromFilterInfo(paramReportQueryParam.getFilter(), otherFilter);
            String dataSql = DIDataQueryFactory.getDataQueryService((String)isSrc).buildDataSql(curStep, extendsTable, extendsTableCp, Long.valueOf(Long.parseLong(executeId)), otherFilter);
            return DIDataQueryFactory.getDataQueryService((String)isSrc).queryData(dataSql, null, curStep);
        }
        catch (Exception e) {
            log.error("query DataSet error:", (Throwable)e);
            return DB.queryDataSet((String)"DI", (DBRoute)BCMConstant.DBROUTE, (String)"select fid from t_di_tablelabel where 1=2");
        }
    }

    private String getOtherFilterFromFilterInfo(FilterInfo filter, String otherFilter) {
        if (filter == null) {
            return otherFilter;
        }
        List tableHeadFilterItems = filter.getTableHeadFilterItems();
        if (CollectionUtil.isEmpty((Collection)tableHeadFilterItems)) {
            return otherFilter;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(otherFilter == null ? "" : otherFilter);
        for (FilterItemInfo filterItemInfo : tableHeadFilterItems) {
            sb.append(this.getFilterStr(filterItemInfo.getPropName(), filterItemInfo.getCompareType(), filterItemInfo.getValue()));
        }
        return sb.toString();
    }

    private String getFilterStr(String propName, String compareType, Object value) {
        propName = this.getRealColumnName(propName);
        value = this.getRealValue(propName, value);
        switch (compareType) {
            case "LIKE": {
                return " and " + propName + " like '%" + value.toString() + "%'";
            }
            case "NOT LIKE": {
                return " and " + propName + " not like '%" + value.toString() + "%'";
            }
            case "=": {
                return " and " + propName + " = '" + value.toString() + "'";
            }
            case "<>": {
                return " and " + propName + " <> '" + value.toString() + "'";
            }
            case "lIKE": {
                return " and " + propName + " like '" + value.toString() + "%'";
            }
            case "like": {
                return " and " + propName + " like '%" + value.toString() + "'";
            }
            case "ISNULL": {
                return " and " + propName + " is null";
            }
            case "NOTISNULL": {
                return " and " + propName + " is not null";
            }
        }
        return "";
    }

    private Object getRealValue(String propName, Object value) {
        if ("fdatafrom".equals(propName)) {
            if (ResManager.loadKDString((String)"\u5bfc\u5165", (String)"IDIDataQueryService_2", (String)"fi-bcm-business", (Object[])new Object[0]).equals(value.toString())) {
                return "0";
            }
            if (ResManager.loadKDString((String)"\u89c4\u5219", (String)"IDIDataQueryService_3", (String)"fi-bcm-business", (Object[])new Object[0]).equals(value.toString())) {
                return "1";
            }
        } else if ("fmatchingstatus".equals(propName)) {
            if (ResManager.loadKDString((String)"\u5931\u8d25", (String)"BizRuleConstant_11", (String)"fi-bcm-common", (Object[])new Object[0]).equals(value.toString())) {
                return "0";
            }
            if (ResManager.loadKDString((String)"\u6210\u529f", (String)"BizRuleConstant_10", (String)"fi-bcm-common", (Object[])new Object[0]).equals(value.toString())) {
                return "1";
            }
        } else if ("folapstatus".equals(propName)) {
            if (ResManager.loadKDString((String)"\u5426", (String)"IDIDataQueryService_5", (String)"fi-bcm-business", (Object[])new Object[0]).equals(value.toString())) {
                return "0";
            }
            if (ResManager.loadKDString((String)"\u662f", (String)"IDIDataQueryService_4", (String)"fi-bcm-business", (Object[])new Object[0]).equals(value.toString())) {
                return "1";
            }
        }
        return value;
    }

    private String getRealColumnName(String columnName) {
        String[] split;
        if (columnName.startsWith("__") && (split = columnName.split("__")).length > 2) {
            columnName = "b.f" + split[1];
        }
        return columnName;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        columns = super.getColumns(columns);
        columns.clear();
        Map customParam = this.getQueryParam().getCustomParam();
        String executeId = (String)customParam.get("executeId");
        if (executeId == null) {
            return columns;
        }
        List columnNames = (List)customParam.get("columnNames");
        if (columnNames == null) {
            return columns;
        }
        Map nameLable = (Map)customParam.get("nameLable");
        String singlemetric = (String)customParam.get("money_attr");
        Set<String> moneyAttrList = DIExecuteDetailPlugin.getMoneyAttrSet(singlemetric);
        Map fieldTypeMap = (Map)customParam.get("fieldTypeMap");
        for (String columnName : columnNames) {
            DecimalReportColumn qty;
            if (moneyAttrList.contains(columnName) || this.isNumtype(columnName, fieldTypeMap)) {
                qty = new DecimalReportColumn();
                qty.setSummary(1);
                qty.setCaption(new LocaleString(nameLable.get(columnName) == null ? columnName : (String)nameLable.get(columnName)));
                qty.setFieldKey(columnName);
                qty.setScale(9);
                qty.setFieldType("decimal");
                columns.add(qty);
                continue;
            }
            qty = new ReportColumn();
            qty.setFieldType("text");
            qty.setCaption(new LocaleString(nameLable.get(columnName) == null ? columnName : (String)nameLable.get(columnName)));
            qty.setFieldKey(columnName);
            columns.add(qty);
        }
        return columns;
    }

    private boolean isNumtype(String columnName, Map<String, String> fieldTypeMap) {
        return "numeric".equals(fieldTypeMap.get(columnName.toLowerCase()));
    }
}

